REM CKNJ16.BAS ver 0.11
REM Class CKNJ16 for MachiKania Type Z/M
REM using Shinonome 16x16 font

STATIC PRIVATE MODE,FBUFF,FO,PLT,BMPF

METHOD INIT
  REM File buffer size is 32 bytes
  dim FBUFF(7)
  REM 16x16 bytes matrix for PUTBMP
  dim BMPF(63)
  REM Set encoding
  REM MODE: either "EUC-JP", or "UTF-8"
  if 0<args(0) then
    if 0=STRNCMP("EUC-JP",args$(1),7) then
      MODE=1
    elseif 0=STRNCMP("UTF-8",args$(1),6) then
      MODE=2
    else
      print "Illegal encoding:";args$(1)
      end
    endif
  else
    REM Default: EUC-JP
    MODE=1
  endif
  return

METHOD GPRT
  var t$,b,i,j
  fclose
  FO=0
  REM Set palette
  PLT=args(2)*256+args(3)
  gosub GPSTR,args$(1)
  fclose
  return

REM Private method GPRTCH
REM 1st param: JIS code #
LABEL GPRTCH
  var i,x,y
  REM Create BMP from font file
  gosub FGETCH,args(1)
  for y=0 to 15
    i=peek(FBUFF+y*2)
    for x=0 to 7
      if i and (1<<(7-x)) then
        poke BMPF+y*16+x,PLT>>8
      else
        poke BMPF+y*16+x,PLT and 0xff
      endif
    next
    i=peek(FBUFF+y*2+1)
    for x=8 to 15
      if i and (1<<(15-x)) then
        poke BMPF+y*16+x,PLT>>8
      else
        poke BMPF+y*16+x,PLT and 0xff
      endif
    next
  next
  REM Draw in graphic
  x=SYSTEM(28)
  y=SYSTEM(29)
  putbmp x,y,16,16,BMPF
  if x+32<SYSTEM(22) then
    x=x+16
  else
    x=0
    y=y+16
  endif
  point x,y
  return

REM Private medthod FGETCH
REM 1st param: JIS code #
LABEL FGETCH
  var p
  if 0=FO then
    REM File isn't yet open
    REM open it 
    FO=1
    if 2=MODE then
      fopen "SINONOME.UNI","r"
    else
      fopen "SINONOME.JIS","r"
    endif
  endif
  p=args(1)
  if 2=MODE then
    REM UTF-8
    if p<0x0500 then
      p=p-0x500
    elseif p<0x2000 then
      REM ERR
      p=-1
    elseif p<0x2700 then
      p=p-0x2000+0x0500
    elseif p<0x3000 then
      p=-1
    elseif p<0x3100 then
      p=p-0x3000+0x0c00
    elseif p<0x4e00 then
      p=-1
    elseif p<0xa000 then
      p=p-0x4e00+0x0d00
    elseif p<0xff00 then
      p=-1
    else
      p=p-0xff00+0x5f00
    endif
  else
    REM EUC
    p=p-0xa1a1
  endif
  p=p*32
  if 0<=p and p+32<flen() then
    fseek p
    fget FBUFF,32
  else
    for p=0 to 7
      FBUFF(p)=0
    next
  endif
  return

REM Private method GPSTR
REM 1st param: JIS/EUC/UTF string
REM return: string with PCG set
LABEL GPSTR
  t$=""
  i=0
  if 1=MODE then
  	goto EUCSTR
  elseif 2=MODE then
  	goto UTFSTR
  else
  	goto EUCSTR
  endif

REM Private method EUCSTR
REM supports EUC-JP string
LABEL EUCSTR
  while i<len(args$(1))
    b=peek(args(1)+i)
    if 0xa0<b then
      REM Detect Kanji
      REM Get EUC code in var j
      j=b*256+peek(args(1)+i+1)
      i=i+2
      REM GPrint character
      gosub GPRTCH,j
    elseif 0x20<b then
      REM 7 bit character
      gosub GPRTCH,0xa3b0+b-0x30
      i=i+1
    endif
  wend
  return

REM Private method UTFSTR
REM supports UTF-8 string
LABEL UTFSTR
  while i<len(args$(1))
    b=peek(args(1)+i)
    if 0xc0 = (0xe0 and b) then
      REM Get Unicode in j
      j=((b and 0x1f)<<6)+(peek(args(1)+i+1) and 0x3f)
      i=i+2
      REM GPrint character
      gosub GPRTCH,j
    elseif 0xe0 = (0xf0 and b) then
      REM Get Unicode in j
      j=((b and 0x0f)<<12)+((peek(args(1)+i+1) and 0x3f)<<6)+(peek(args(1)+i+2) and 0x3f)
      i=i+3
      REM GPrint character
      gosub GPRTCH,j
    elseif 0x20<b then
      REM 7 bit character
      gosub GPRTCH,0xff00+b-0x20
      i=i+1
    endif
  wend
  return
