package com.mxmobiling.kitting;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class Email {

	public static final String STRING = "string";
	public static final String INTEGER = "integer";

	public Email() {
	}

	/*
	 * EmailAccountDescription
	 * 
	 * 電子メールアカウントの説明。アカウント欄の表示名
	 */
	public void EmailAccountDescription(Element PayloadContentDict,
			Document document, String valueType, String description) {
		Element EmailAccountDescriptionKey = document.createElement("key");
		PayloadContentDict.appendChild(EmailAccountDescriptionKey);

		Text EmailAccountDescriptionKeyParam = document
				.createTextNode("EmailAccountDescription");
		EmailAccountDescriptionKey.appendChild(EmailAccountDescriptionKeyParam);

		Element EmailAccountDescriptionString = document
				.createElement(valueType);
		PayloadContentDict.appendChild(EmailAccountDescriptionString);

		Text EmailAccountDescriptionStringParam = document
				.createTextNode(description);
		EmailAccountDescriptionString
				.appendChild(EmailAccountDescriptionStringParam);
	}

	/*
	 * EmailAccountName
	 * 
	 * アカウントのユーザー名。送信メッセージのヘッダーなどに表示される
	 */
	public void EmailAccountName(Element PayloadContentDict, Document document,
			String valueType, String accountName) {
		Element EmailAccountNameKey = document.createElement("key");
		PayloadContentDict.appendChild(EmailAccountNameKey);

		Text EmailAccountNameKeyParam = document
				.createTextNode("EmailAccountName");
		EmailAccountNameKey.appendChild(EmailAccountNameKeyParam);

		Element EmailAccountNameString = document.createElement(valueType);
		PayloadContentDict.appendChild(EmailAccountNameString);

		Text EmailAccountNameStringParam = document.createTextNode(accountName);
		EmailAccountNameString.appendChild(EmailAccountNameStringParam);
	}

	/*
	 * EmailAccountType
	 * 
	 * EmailTypeIMAP or EmailTypePOPを選択
	 */
	public void EmailAccountType(Element PayloadContentDict, Document document,
			String valueType, String accountType) {
		Element EmailAccountTypeKey = document.createElement("key");
		PayloadContentDict.appendChild(EmailAccountTypeKey);

		Text EmailAccountTypeKeyParam = document
				.createTextNode("EmailAccountType");
		EmailAccountTypeKey.appendChild(EmailAccountTypeKeyParam);

		Element EmailAccountTypeString = document.createElement(valueType);
		PayloadContentDict.appendChild(EmailAccountTypeString);

		Text EmailAccountTypeStringParam = document.createTextNode(accountType);
		EmailAccountTypeString.appendChild(EmailAccountTypeStringParam);
	}

	/*
	 * EmailAddress
	 * 
	 * Eメールアドレス
	 */
	public void EmailAddress(Element PayloadContentDict, Document document,
			String valueType, String emailAddress) {
		Element EmailAddressKey = document.createElement("key");
		PayloadContentDict.appendChild(EmailAddressKey);

		Text EmailAddressKeyParam = document.createTextNode("EmailAddress");
		EmailAddressKey.appendChild(EmailAddressKeyParam);

		Element EmailAddressString = document.createElement(valueType);
		PayloadContentDict.appendChild(EmailAddressString);

		Text EmailAddressStringParam = document.createTextNode(emailAddress);
		EmailAddressString.appendChild(EmailAddressStringParam);
	}

	/*
	 * IncomingMailServerAuthentication
	 * 
	 * 受信メールの認証スキーム（作業用GmailならEmailAuthPassword）
	 */
	public void IncomingMailServerAuthentication(Element PayloadContentDict,
			Document document, String valueType, String authType) {
		Element IncomingMailServerAuthenticationKey = document
				.createElement("key");
		PayloadContentDict.appendChild(IncomingMailServerAuthenticationKey);

		Text IncomingMailServerAuthenticationKeyParam = document
				.createTextNode("IncomingMailServerAuthentication");
		IncomingMailServerAuthenticationKey
				.appendChild(IncomingMailServerAuthenticationKeyParam);

		Element IncomingMailServerAuthenticationString = document
				.createElement(valueType);
		PayloadContentDict.appendChild(IncomingMailServerAuthenticationString);

		Text IncomingMailServerAuthenticationStringParam = document
				.createTextNode(authType);
		IncomingMailServerAuthenticationString
				.appendChild(IncomingMailServerAuthenticationStringParam);
	}

	/*
	 * IncomingMailServerHostName
	 * 
	 * 受信メールサーバのホスト名（作業用Gmailならimap.gmail.com）
	 */
	public void IncomingMailServerHostName(Element PayloadContentDict,
			Document document, String valueType, String hostName) {
		Element IncomingMailServerHostNameKey = document.createElement("key");
		PayloadContentDict.appendChild(IncomingMailServerHostNameKey);

		Text IncomingMailServerHostNameKeyParam = document
				.createTextNode("IncomingMailServerHostName");
		IncomingMailServerHostNameKey
				.appendChild(IncomingMailServerHostNameKeyParam);

		Element IncomingMailServerHostNameString = document
				.createElement(valueType);
		PayloadContentDict.appendChild(IncomingMailServerHostNameString);

		Text IncomingMailServerHostNameStringParam = document
				.createTextNode(hostName);
		IncomingMailServerHostNameString
				.appendChild(IncomingMailServerHostNameStringParam);
	}

	/*
	 * IncomingMailServerIMAPPathPrefix
	 * 
	 * なぞのパラメータ（作業用Gmailなら\\（/））
	 */
	public void IncomingMailServerIMAPPathPrefix(Element PayloadContentDict,
			Document document, String valueType, String prefix) {
		Element IncomingMailServerIMAPPathPrefixKey = document
				.createElement("key");
		PayloadContentDict.appendChild(IncomingMailServerIMAPPathPrefixKey);

		Text IncomingMailServerIMAPPathPrefixKeyParam = document
				.createTextNode("IncomingMailServerIMAPPathPrefix");
		IncomingMailServerIMAPPathPrefixKey
				.appendChild(IncomingMailServerIMAPPathPrefixKeyParam);

		Element IncomingMailServerIMAPPathPrefixString = document
				.createElement(valueType);
		PayloadContentDict.appendChild(IncomingMailServerIMAPPathPrefixString);

		Text IncomingMailServerIMAPPathPrefixStringParam = document
				.createTextNode(prefix);
		IncomingMailServerIMAPPathPrefixString
				.appendChild(IncomingMailServerIMAPPathPrefixStringParam);
	}

	/*
	 * IncomingMailServerPortNumber
	 * 
	 * 受信メールサーバーのポート番号（作業用Gmailなら993）
	 */
	public void IncomingMailServerPortNumber(Element PayloadContentDict,
			Document document, String valueType, String portNo) {
		Element IncomingMailServerPortNumberKey = document.createElement("key");
		PayloadContentDict.appendChild(IncomingMailServerPortNumberKey);

		Text IncomingMailServerPortNumberKeyParam = document
				.createTextNode("IncomingMailServerPortNumber");
		IncomingMailServerPortNumberKey
				.appendChild(IncomingMailServerPortNumberKeyParam);

		Element IncomingMailServerPortNumberString = document
				.createElement(valueType);
		PayloadContentDict.appendChild(IncomingMailServerPortNumberString);

		Text IncomingMailServerPortNumberStringParam = document
				.createTextNode(portNo);
		IncomingMailServerPortNumberString
				.appendChild(IncomingMailServerPortNumberStringParam);
	}

	/*
	 * IncomingMailServerUseSSL
	 * 
	 * 受信メールサーバーにSSLを使用するか（デフォルトはtrue）
	 */
	public void IncomingMailServerUseSSL(Element PayloadContentDict,
			Document document, Boolean ssl) {
		Element IncomingMailServerUseSSLKey = document.createElement("key");
		PayloadContentDict.appendChild(IncomingMailServerUseSSLKey);

		Text IncomingMailServerUseSSLKeyParam = document
				.createTextNode("IncomingMailServerUseSSL");
		IncomingMailServerUseSSLKey
				.appendChild(IncomingMailServerUseSSLKeyParam);

		Element IncomingMailServerUseSSLString = document.createElement(String
				.valueOf(ssl));
		PayloadContentDict.appendChild(IncomingMailServerUseSSLString);
	}

	/*
	 * IncomingMailServerUsername
	 * 
	 * 電子メールアカウントのユーザ名（通常なら＠以前だが、作業用Gmailの場合は＠以降も）
	 */
	public void IncomingMailServerUsername(Element PayloadContentDict,
			Document document, String valueType, String userName) {
		Element IncomingMailServerUsernameKey = document.createElement("key");
		PayloadContentDict.appendChild(IncomingMailServerUsernameKey);

		Text IncomingMailServerUsernameKeyParam = document
				.createTextNode("IncomingMailServerUsername");
		IncomingMailServerUsernameKey
				.appendChild(IncomingMailServerUsernameKeyParam);

		Element IncomingMailServerUsernameString = document
				.createElement(valueType);
		PayloadContentDict.appendChild(IncomingMailServerUsernameString);

		Text IncomingMailServerUsernameStringParam = document
				.createTextNode(userName);
		IncomingMailServerUsernameString
				.appendChild(IncomingMailServerUsernameStringParam);
	}

	/*
	 * IncomingPassword
	 * 
	 * 電子メールアカウントのパスワード（作業用Gmailの場合はGmailログインパスワード）
	 */
	public void IncomingPassword(Element PayloadContentDict, Document document,
			String valueType, String password) {
		Element IncomingPasswordKey = document.createElement("key");
		PayloadContentDict.appendChild(IncomingPasswordKey);

		Text IncomingPasswordKeyParam = document
				.createTextNode("IncomingPassword");
		IncomingPasswordKey.appendChild(IncomingPasswordKeyParam);

		Element IncomingPasswordString = document.createElement(valueType);
		PayloadContentDict.appendChild(IncomingPasswordString);

		Text IncomingPasswordStringParam = document.createTextNode(password);
		IncomingPasswordString.appendChild(IncomingPasswordStringParam);
	}

	/*
	 * OutgoingMailServerAuthentication
	 * 
	 * 送信メールの認証スキーム（作業用GmailならEmailAuthPassword）
	 */
	public void OutgoingMailServerAuthentication(Element PayloadContentDict,
			Document document, String valueType, String authType) {
		Element OutgoingMailServerAuthenticationKey = document
				.createElement("key");
		PayloadContentDict.appendChild(OutgoingMailServerAuthenticationKey);

		Text OutgoingMailServerAuthenticationKeyParam = document
				.createTextNode("OutgoingMailServerAuthentication");
		OutgoingMailServerAuthenticationKey
				.appendChild(OutgoingMailServerAuthenticationKeyParam);

		Element OutgoingMailServerAuthenticationString = document
				.createElement(valueType);
		PayloadContentDict.appendChild(OutgoingMailServerAuthenticationString);

		Text OutgoingMailServerAuthenticationStringParam = document
				.createTextNode(authType);
		OutgoingMailServerAuthenticationString
				.appendChild(OutgoingMailServerAuthenticationStringParam);
	}

	/*
	 * OutgoingMailServerHostName
	 * 
	 * 送信メールサーバのホスト名（作業用Gmailならsmtp.gmail.com）
	 */
	public void OutgoingMailServerHostName(Element PayloadContentDict,
			Document document, String valueType, String hostName) {
		Element OutgoingMailServerHostNameKey = document.createElement("key");
		PayloadContentDict.appendChild(OutgoingMailServerHostNameKey);

		Text OutgoingMailServerHostNameKeyParam = document
				.createTextNode("OutgoingMailServerHostName");
		OutgoingMailServerHostNameKey
				.appendChild(OutgoingMailServerHostNameKeyParam);

		Element OutgoingMailServerHostNameString = document
				.createElement(valueType);
		PayloadContentDict.appendChild(OutgoingMailServerHostNameString);

		Text OutgoingMailServerHostNameStringParam = document
				.createTextNode(hostName);
		OutgoingMailServerHostNameString
				.appendChild(OutgoingMailServerHostNameStringParam);
	}

	/*
	 * OutgoingMailServerPortNumber
	 * 
	 * 送信メールサーバーのポート番号（作業用Gmailなら587）
	 */
	public void OutgoingMailServerPortNumber(Element PayloadContentDict,
			Document document, String valueType, String portNo) {
		Element OutgoingMailServerPortNumberKey = document.createElement("key");
		PayloadContentDict.appendChild(OutgoingMailServerPortNumberKey);

		Text OutgoingMailServerPortNumberKeyParam = document
				.createTextNode("OutgoingMailServerPortNumber");
		OutgoingMailServerPortNumberKey
				.appendChild(OutgoingMailServerPortNumberKeyParam);

		Element OutgoingMailServerPortNumberString = document
				.createElement(valueType);
		PayloadContentDict.appendChild(OutgoingMailServerPortNumberString);

		Text OutgoingMailServerPortNumberStringParam = document
				.createTextNode(portNo);
		OutgoingMailServerPortNumberString
				.appendChild(OutgoingMailServerPortNumberStringParam);
	}

	/*
	 * OutgoingMailServerUseSSL
	 * 
	 * 送信メールサーバーにSSLを使用するか（デフォルトはtrue）
	 */
	public void OutgoingMailServerUseSSL(Element PayloadContentDict,
			Document document, Boolean ssl) {
		Element OutgoingMailServerUseSSLKey = document.createElement("key");
		PayloadContentDict.appendChild(OutgoingMailServerUseSSLKey);

		Text OutgoingMailServerUseSSLKeyParam = document
				.createTextNode("OutgoingMailServerUseSSL");
		OutgoingMailServerUseSSLKey
				.appendChild(OutgoingMailServerUseSSLKeyParam);

		Element OutgoingMailServerUseSSLString = document.createElement(String
				.valueOf(ssl));
		PayloadContentDict.appendChild(OutgoingMailServerUseSSLString);
	}

	/*
	 * OutgoingMailServerUsername
	 * 
	 * 電子メールアカウントのユーザ名（通常なら＠以前だが、作業用Gmailの場合は＠以降も）
	 */
	public void OutgoingMailServerUsername(Element PayloadContentDict,
			Document document, String valueType, String userName) {
		Element OutgoingMailServerUsernameKey = document.createElement("key");
		PayloadContentDict.appendChild(OutgoingMailServerUsernameKey);

		Text OutgoingMailServerUsernameKeyParam = document
				.createTextNode("OutgoingMailServerUsername");
		OutgoingMailServerUsernameKey
				.appendChild(OutgoingMailServerUsernameKeyParam);

		Element OutgoingMailServerUsernameString = document
				.createElement(valueType);
		PayloadContentDict.appendChild(OutgoingMailServerUsernameString);

		Text OutgoingMailServerUsernameStringParam = document
				.createTextNode(userName);
		OutgoingMailServerUsernameString
				.appendChild(OutgoingMailServerUsernameStringParam);
	}

	/*
	 * OutgoingPasswordSameAsIncomingPassword
	 * 
	 * よくわからないが、デフォルトはtrue
	 */
	public void OutgoingPasswordSameAsIncomingPassword(
			Element PayloadContentDict, Document document, Boolean passRemind) {
		Element OutgoingPasswordSameAsIncomingPasswordKey = document
				.createElement("key");
		PayloadContentDict
				.appendChild(OutgoingPasswordSameAsIncomingPasswordKey);

		Text OOutgoingPasswordSameAsIncomingPasswordKeyParam = document
				.createTextNode("OutgoingPasswordSameAsIncomingPassword");
		OutgoingPasswordSameAsIncomingPasswordKey
				.appendChild(OOutgoingPasswordSameAsIncomingPasswordKeyParam);

		Element OutgoingPasswordSameAsIncomingPasswordString = document
				.createElement(String.valueOf(passRemind));
		PayloadContentDict
				.appendChild(OutgoingPasswordSameAsIncomingPasswordString);
	}

	/*
	 * PreventAppSheet
	 * 
	 * メールを他社製メールアプリで使用できないようにする
	 */
	public void EmailPreventAppSheet(Element PayloadContentDict,
			Document document, Boolean appSheet) {
		Element EmailPreventAppSheetKey = document.createElement("key");
		PayloadContentDict.appendChild(EmailPreventAppSheetKey);

		Text EmailPreventAppSheetKeyParam = document
				.createTextNode("PreventAppSheet");
		EmailPreventAppSheetKey.appendChild(EmailPreventAppSheetKeyParam);

		Element EmailPreventAppSheetParamString = document.createElement(String
				.valueOf(appSheet));
		PayloadContentDict.appendChild(EmailPreventAppSheetParamString);
	}

	/*
	 * PreventMove
	 * 
	 * Exchangeメールを他のフォルダへ移動できないようにする
	 */
	public void EmailPreventMove(Element PayloadContentDict, Document document,
			Boolean move) {
		Element EmailPreventMoveKey = document.createElement("key");
		PayloadContentDict.appendChild(EmailPreventMoveKey);

		Text EmailPreventMoveKeyParam = document.createTextNode("PreventMove");
		EmailPreventMoveKey.appendChild(EmailPreventMoveKeyParam);

		Element EmailPreventMoveString = document.createElement(String
				.valueOf(move));
		PayloadContentDict.appendChild(EmailPreventMoveString);
	}

	/*
	 * SMIMEEnabled
	 * 
	 * ExchangeメールのS/MIME対応可否
	 */
	public void EmailSMIMEEnabled(Element PayloadContentDict,
			Document document, Boolean smime) {
		Element EmailSMIMEEnabledKey = document.createElement("key");
		PayloadContentDict.appendChild(EmailSMIMEEnabledKey);

		Text EmailSMIMEEnabledKeyParam = document
				.createTextNode("SMIMEEnabled");
		EmailSMIMEEnabledKey.appendChild(EmailSMIMEEnabledKeyParam);

		Element EmailSMIMEEnabledString = document.createElement(String
				.valueOf(smime));
		PayloadContentDict.appendChild(EmailSMIMEEnabledString);
	}

	/*
	 * disableMailRecentsSyncing
	 * 
	 * なぞのパラメータ。とりあえずfalse
	 */
	public void disableMailRecentsSyncing(Element PayloadContentDict,
			Document document, Boolean syncing) {
		Element disableMailRecentsSyncingKey = document.createElement("key");
		PayloadContentDict.appendChild(disableMailRecentsSyncingKey);

		Text disableMailRecentsSyncingKeyParam = document
				.createTextNode("disableMailRecentsSyncing");
		disableMailRecentsSyncingKey
				.appendChild(disableMailRecentsSyncingKeyParam);

		Element disableMailRecentsSyncingString = document.createElement(String
				.valueOf(syncing));
		PayloadContentDict.appendChild(disableMailRecentsSyncingString);
	}

}
