﻿Imports System.Net
Imports KittingSupportCustomerManegeSystem.sForce
Imports System.Text

Public Class SoapCliantControl

    Public Event ProxyCredentialsError()
    Public Event LoginFailer()

    Private _binding As SforceService
    Private _username As String
    Private _password As String
    Private _ProxyID As String
    Private _proxyPWD As String
    Private _host As String
    Private _sessionlength As Integer
    Private _sessionId As String
    Private _serverURL As String
    Private _nextLoginTime As DateTime
    Private _querySize As Integer

    Public Sub New()
        _binding = New SforceService
        _binding.Timeout = 60000
        _sessionlength = 29
        _querySize = 250
        _host = "https://test.salesforce.com/services/Soap/u/31.0"

    End Sub

    '呼び出し関数に対して変数を公開する
    Public Property username() As String
        '呼び出しクラスに対して値の取得を許可する
        Get
            Return Me._username
        End Get
        '呼び出しクラスに対して値の設定を許可する
        Set(ByVal Value As String)
            Me._username = Value
        End Set
    End Property

    Public Property password() As String
        Get
            Return Me._password
        End Get
        Set(ByVal Value As String)
            Me._password = Value
        End Set
    End Property

    Public Property host() As String
        Get
            Return Me._host
        End Get
        Set(ByVal Value As String)
            Me._host = Value
        End Set
    End Property

    Public ReadOnly Property serverURL() As String
        Get
            Return Me._serverURL
        End Get
    End Property

    Public Property sessionlength() As Integer
        Get
            Return Me._sessionlength
        End Get
        Set(ByVal Value As Integer)
            Me._sessionlength = Value
        End Set
    End Property

    'プロキシサーバの場合
    'SoapHttpClientProtocolクラスは、クライアントに、プロキシ情報を設定している場合は有効だが、
    'GWで一括管理している場合は、無効となる。
    Public Property proxy() As System.Net.WebProxy
        Get
            Return Me._binding.Proxy
        End Get
        Set(ByVal Value As System.Net.WebProxy)
            Me._binding.Proxy = Value
        End Set
    End Property

    Public Property proxyid() As String
        Get
            Return Me._ProxyID
        End Get
        Set(ByVal Value As String)
            Me._ProxyID = Value
        End Set
    End Property

    Public Property proxypwd() As String
        Get
            Return Me._proxyPWD
        End Get
        Set(ByVal Value As String)
            Me._proxyPWD = Value
        End Set
    End Property

    Public Sub Login()
        'GWにプロキシがあるか確認する
        Dim SOAPWebrequest As HttpWebRequest
        SOAPWebrequest = HttpWebRequest.Create(host)
        Dim MyProxy As IWebProxy
        MyProxy = SOAPWebrequest.Proxy
        Dim newUri As Uri
        If MyProxy Is Nothing Then
        Else
            newUri = MyProxy.GetProxy(SOAPWebrequest.RequestUri)
            Try
                MyProxy.Credentials = New NetworkCredential(_ProxyID, _proxyPWD)
            Catch ex As Exception
                'プロキシ認証エラーをイベント発生させる
                RaiseEvent ProxyCredentialsError()
                Exit Sub
            End Try

        End If
        Dim lr As LoginResult
        'Me._binding.Url = Me._host
        'Try
        lr = Me._binding.login(username, password)

        'Catch ex As Exception
        'RaiseEvent LoginFailer()
        'MessageBox.Show(ex.Message, "ログインエラー", MessageBoxButtons.OK, MessageBoxIcon.Error)
        'Exit Sub
        'End Try

        Me._nextLoginTime = Now().AddMinutes(Me.sessionlength)
        'SOAP エンドポイントを返されたサーバ URL にリセットする
        Me._binding.Url = lr.serverUrl
        Me._binding.SessionHeaderValue = New SessionHeader
        Me._binding.SessionHeaderValue.sessionId = lr.sessionId
        Me._sessionId = lr.sessionId
        Me._serverURL = lr.serverUrl
    End Sub

    Public Sub logout()
        Me._binding.logout()
        Me._sessionId = ""
    End Sub

    Public Function isConnected() As Boolean
        If _sessionId <> "" And _sessionId <> Nothing Then
            If Now() > Me._nextLoginTime Then
                isConnected = False
            End If
            isConnected = True
        Else
            isConnected = False
        End If
    End Function

    Private Function loginRequired() As Boolean
        loginRequired = Not (isConnected())
    End Function


    ''' <summary>
    ''' SaleseForceからデータのロードをします
    ''' </summary>
    ''' <param name="strSoql">SOQL</param>
    ''' <param name="queryBatchSize">デフォルト250</param>
    ''' <returns>1度に返却するデータ数はqueryBatchSizeに準拠</returns>
    ''' <remarks></remarks>
    Public Function query(ByVal strSoql As String, Optional ByVal queryBatchSize As Integer = -1) As QueryResult
        If queryBatchSize = -1 Then
            queryBatchSize = _querySize
        End If
        If (Me.loginRequired()) Then
            Login()
        End If
        _binding.QueryOptionsValue = New KittingSupportCustomerManegeSystem.QueryOptions
        _binding.QueryOptionsValue.batchSize = queryBatchSize
        _binding.QueryOptionsValue.batchSizeSpecified = True
        query = _binding.query(strSoql)
    End Function
    ''' <summary>
    ''' queryの続きの取得に使います　サーバで15分間は保持してる
    ''' </summary>
    ''' <param name="queryLocator"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function QueryMore(ByVal queryLocator As String) As QueryResult
        If loginRequired() Then Login()
        Return _binding.queryMore(queryLocator)
    End Function

    Public Function search(ArgSOSL As String) As SearchResult

        If ArgSOSL = "" Then
            Return Nothing
            Exit Function
        End If
        If (Me.loginRequired()) Then
            Login()
        End If

        Return Binding.search(ArgSOSL)

    End Function

    ''' <summary>
    ''' retrieveコマンドを行う
    ''' </summary>
    ''' <param name="fieldlist">取得する項目を、区切りでリスト化</param>
    ''' <param name="objname">対象のオブジェクト</param>
    ''' <param name="ids">取得対象のID</param>
    ''' <returns>sObject()</returns>
    ''' <remarks></remarks>
    Public Function retrieve(fieldlist As String, objname As String, ids As String()) As sObject()
        If loginRequired() Then Login()
        Return Binding.retrieve(fieldlist, objname, ids)
    End Function

    Public Function Delete(ids As String()) As DeleteResult()
        If loginRequired() Then Login()
        Return Binding.delete(ids)
    End Function

    Public ReadOnly Property Binding() As SforceService
        Get
            Return _binding
        End Get
    End Property
    ''' <summary>
    ''' 
    ''' </summary>
    ''' <param name="records"></param>
    ''' <param name="batchSize">規定値200を指定</param>
    ''' <returns>SaveResultの配列</returns>
    ''' <remarks></remarks>
    Public Function create(ByVal records() As sObject, Optional ByVal batchSize As Integer = 200) As SaveResult()
        Return batch(records, batchSize, New CreateBatcher)
    End Function

    ''' <summary>
    ''' 
    ''' </summary>
    ''' <param name="records"></param>
    ''' <param name="batchSize">規定値200を指定</param>
    ''' <returns>SaveResultの配列</returns>
    ''' <remarks></remarks>
    Public Function update(ByVal records() As sObject, Optional ByVal batchSize As Integer = 200) As SaveResult()
        Return batch(records, batchSize, New UpdateBatcher)
    End Function

    Private Function batch(ByVal records() As sObject, ByVal batchSize As Integer, ByVal oper As Batcher) As SaveResult()
        If loginRequired() Then Login()

        If (records.Length <= batchSize) Then
            batch = oper.perform(Binding, records)
            Exit Function
        End If

        Dim saveResults(records.Length - 1) As SaveResult
        Dim thisBatch As sObject()
        Dim pos As Integer = 0
        Dim thisBatchSize As Integer

        While (pos < records.Length)
            thisBatchSize = Math.Min(batchSize, records.Length - pos)
            ReDim thisBatch(thisBatchSize)
            System.Array.Copy(records, pos, thisBatch, 0, thisBatchSize)
            Dim sr As SaveResult() = oper.perform(Binding, thisBatch)
            System.Array.Copy(sr, 0, saveResults, pos, thisBatchSize)
            pos += sr.Length
        End While
        batch = saveResults

    End Function

    '継承クラスの宣言
    Private Class CreateBatcher
        Inherits Batcher
        Public Overrides Function perform(ByVal binding As SforceService, ByVal records As sObject()) As SaveResult()
            perform = binding.create(records)
        End Function
    End Class

    '必ず継承しないと利用できない空クラスの定義
    Private MustInherit Class Batcher
        Public MustOverride Function perform(ByVal binding As SforceService, ByVal records As sObject()) As SaveResult()
        'perform = Nothing
        'End Function
    End Class

    '継承クラスの宣言
    Private Class UpdateBatcher
        Inherits Batcher
        Public Overrides Function perform(ByVal binding As SforceService, ByVal records As sObject()) As SaveResult()
            perform = binding.update(records)
        End Function
    End Class
End Class
