﻿Imports System.Data.SQLite
Imports System.Text

Public Class CustDB
    'データベースは排他制御はまったくいらないし、決まった場所にあるので、これでおｋ
    Public conn As New SQLiteConnection("Version=3;Data Source=CustMain.db;New=false;Compress=True;")

    Public Function DBConnection() As Boolean
        Try
            conn.Open()
            Return True
        Catch ex As System.Exception
            MessageBox.Show("ローカルデータベースファイルがありません", "データベース接続", MessageBoxButtons.OK, MessageBoxIcon.Error)
            Return False
        End Try
    End Function

    ''' <summary>
    ''' SQLiteの接続を閉じます
    ''' </summary>
    ''' <remarks></remarks>
    Public Sub DBDisconnection()
        conn.Close()
    End Sub

    ''' <summary>
    ''' 画面に表示するためのマスタデータ群を取り出す
    ''' </summary>
    ''' <returns>DataSet</returns>
    ''' <remarks></remarks>
    Public Function GetListData() As DataSet
        Dim AdLite As New SQLiteDataAdapter
        Dim Command As New SQLiteCommand
        Dim Ds As New DataSet

        'コマンド作成
        Command.Connection = conn
        Command.CommandText = "SELECT * FROM listdata"
        AdLite.SelectCommand = Command
        Ds.Clear()
        Try
            AdLite.Fill(Ds)
            Return Ds.Copy
        Catch ex As System.Exception
            MessageBox.Show(ex.Message, "GetListData", MessageBoxButtons.OK, MessageBoxIcon.Error)
            Return Nothing
        End Try
    End Function

    ''' <summary>
    ''' ローカルデータベースのデータバージョンを取得します
    ''' </summary>
    ''' <returns>DataSet</returns>
    ''' <remarks></remarks>
    Public Function GetDataVersion() As String
        Dim AdLite As New SQLiteDataAdapter
        Dim Command As New SQLiteCommand
        Dim Ds As New DataSet

        'コマンド作成
        Command.Connection = conn
        Command.CommandText = "SELECT * FROM sys"
        AdLite.SelectCommand = Command
        Ds.Clear()
        Try
            AdLite.Fill(Ds)
            Return Ds.Tables(0).Rows(0).Item(0).ToString()
            'Return Ds.Copy
        Catch ex As System.Exception
            MessageBox.Show(ex.Message, "GetDataVersion", MessageBoxButtons.OK, MessageBoxIcon.Error)
            Return ""
        End Try
    End Function
End Class
