﻿Imports System.Xml
Imports System.Text

Module Common

    Enum Editmode As Integer
        update = 1
        insert = 2
    End Enum
    Public Const TABLE_NAME As String = "CustomerMG__c"

    ''' <summary>
    ''' 案件管理テーブル定義
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function MakeAnkenTablesType() As DataTable
        Dim DtAnken As DataTable

        DtAnken = New DataTable
        DtAnken.TableName = "CustomerMG__c"
        With DtAnken
            '//項目定義
            .Columns.Add("id")
            .Columns.Add("name")     '案件名
            .Columns.Add("AM__c", GetType(Boolean))    'AM指定有無
            .Columns.Add("AppleID_kind__c")  'AppleID種類
            .Columns.Add("auEntry_Day__c", GetType(System.DateTime))   'au登録日
            .Columns.Add("anken_staff__c")   'A案件担当
            .Columns.Add("TSSC_store_flg__c", GetType(System.Boolean))    'TSSC格納
            .Columns.Add("Fraud_Check__c")   'フラウド
            .Columns.Add("rental_flg__c", GetType(Boolean))    'レンタルフラグ
            .Columns.Add("LOT__c")           'ロット
            .Columns.Add("irai_staff__c")    '依頼者
            .Columns.Add("irai__c", GetType(System.DateTime))          '依頼日
            .Columns.Add("Type__c")          '機種
            .Columns.Add("contract_kind__c") '契約種別  
            .Columns.Add("onePermin__c", GetType(System.Decimal))     '工数
            .Columns.Add("work_place_Team__c")   '作業担当T
            .Columns.Add("motikomi_tomeoki_flg__c")  '持込留置フラグ
            .Columns.Add("operate_t_staff__c")   '手順書T担当
            .Columns.Add("store_flg__c", GetType(System.Boolean))     '手順書格納フラグ
            .Columns.Add("Cnt__c", GetType(System.Decimal))           '台数 
            .Columns.Add("memo__c")          '特記事項
            .Columns.Add("plan_hold__c", GetType(System.Boolean))     '日程確保有無
            .Columns.Add("Status__c")   '状態（ステータス）
            .Columns.Add("Delivery_Day__c", GetType(System.DateTime))  '納品日
            .Columns.Add("mitumori__c") '見積有無
            .Columns.Add("setcnt__c", GetType(System.Decimal)) '設定数
            .Columns.Add("errorhour__c", GetType(System.Decimal)) 'エラー工数
            .Columns.Add("verifyhour__c", GetType(System.Decimal)) '検証工数
            .Columns.Add("difficalRank__c")    '難易度
            .Columns.Add("work_Day__c", GetType(System.DateTime)) '作業予定日
            .Columns.Add("resultsDay__c", GetType(System.DateTime)) '実績予定日
            .Columns.Add("yoteihour__c", GetType(System.Decimal)) '予定工数
            .Columns.Add("workmemo__c") '作業メモ
            .Columns.Add("irregular_exists_flg__c", GetType(System.Boolean))     '例外有
            .Columns.Add("Delivery_Day_yet__c", GetType(System.Boolean))     '納品日未定
            .Columns.Add("error_exists_flg__c", GetType(System.Boolean))     'エラー有
            .Columns.Add("fin_flg__c", GetType(System.Boolean))     '調整完了
            '//属性定義
            Dim pkey(0) As DataColumn
            Dim col As DataColumn
            col = DtAnken.Columns("id")
            col.Unique = True
            col.DefaultValue = "NEWRecord" & Now.Year.ToString & Now.Month.ToString & Now.Day.ToString & Now.Hour.ToString & Now.Minute.ToString & Now.Second.ToString
            pkey(0) = col
            col.Caption = "id"
            col = DtAnken.Columns("name") '案件名
            col.Caption = "案件名"
            col = DtAnken.Columns("AppleID_kind__c") 'AppleID種類
            col.Caption = "AppleID種類"
            col = DtAnken.Columns("anken_staff__c") '案件担当
            col.Caption = "案件担当"
            col = DtAnken.Columns("Fraud_Check__c") 'フラウド
            col.Caption = "フラウド"
            col = DtAnken.Columns("LOT__c") 'ロット
            col.Caption = "ロット"
            col = DtAnken.Columns("irai_staff__c") '依頼者
            col.Caption = "依頼者"
            col = DtAnken.Columns("Type__c") '機種
            col.Caption = "機種"
            col = DtAnken.Columns("contract_kind__c") '契約種別
            col.Caption = "契約種別"
            col = DtAnken.Columns("work_place_Team__c") '作業担当
            col.Caption = "作業担当"
            col = DtAnken.Columns("motikomi_tomeoki_flg__c") '持込留置
            col.Caption = "持込留置"
            col = DtAnken.Columns("operate_t_staff__c") '手順書T担当
            col.Caption = "手順書T担当"
            col = DtAnken.Columns("mitumori__c") '見積有無
            col.Caption = "見積有無"
            col = DtAnken.Columns("difficalRank__c") '難易度
            col.Caption = "難易度"
            col = DtAnken.Columns("memo__c") '特記事項1
            col.Caption = "特記事項"
            col = DtAnken.Columns("Status__c") '状態
            col.Caption = "ステータス"
            col = DtAnken.Columns("workmemo__c") '特記事項2
            col.Caption = "特記事項2"

            col = DtAnken.Columns("AM__c") 'AM指定有無
            col.DefaultValue = False
            col.Caption = "AM指定"
            col = DtAnken.Columns("auEntry_Day__c") 'au登録日
            col.DefaultValue = Today
            col.Caption = "au登録日"
            col = DtAnken.Columns("TSSC_store_flg__c") 'TSSC格納
            col.DefaultValue = False
            col.Caption = "TSSC格納"
            col = DtAnken.Columns("rental_flg__c") 'レンタルフラグ
            col.DefaultValue = False
            col.Caption = "レンタル"
            col = DtAnken.Columns("irai__c") '依頼日
            col.Caption = "依頼日"
            col.DefaultValue = Today
            col = DtAnken.Columns("onePermin__c") '工数
            col.Caption = "工数"
            col.DefaultValue = 0
            col = DtAnken.Columns("store_flg__c") '手順書格納フラグ
            col.Caption = "手順書格納"
            col.DefaultValue = False
            col = DtAnken.Columns("Cnt__c") '台数 
            col.Caption = "台数"
            col.DefaultValue = 0
            col = DtAnken.Columns("plan_hold__c") '日程確保有無
            col.Caption = "日程確保"
            col.DefaultValue = False
            col = DtAnken.Columns("Delivery_Day__c") '納品日
            col.Caption = "納品日"
            col.DefaultValue = Today
            col = DtAnken.Columns("resultsDay__c") '作業開始日
            col.Caption = "作業開始日"
            col.DefaultValue = Today
            col = DtAnken.Columns("work_Day__c") '作業予定日
            col.Caption = "作業予定日"
            col.DefaultValue = Today
            col = DtAnken.Columns("setcnt__c") '設定数
            col.Caption = "設定数"
            col.DefaultValue = 0
            col = DtAnken.Columns("errorhour__c") 'エラー工数
            col.Caption = "エラー工数"
            col.DefaultValue = 0
            col = DtAnken.Columns("verifyhour__c") '検証工数
            col.Caption = "検証工数"
            col.DefaultValue = 0
            col = DtAnken.Columns("yoteihour__c") '予定工数
            col.Caption = "予定工数"
            col.DefaultValue = 0
            col = DtAnken.Columns("irregular_exists_flg__c") '例外有フラグ
            col.Caption = "例外有"
            col.DefaultValue = False
            col = DtAnken.Columns("Delivery_Day_yet__c") '納品日未定フラグ
            col.Caption = "納品日未定"
            col.DefaultValue = False
            col = DtAnken.Columns("error_exists_flg__c") 'エラー有フラグ
            col.Caption = "エラー有"
            col.DefaultValue = False
            col = DtAnken.Columns("fin_flg__c") '調整完了フラグ
            col.Caption = "調整完了"
            col.DefaultValue = False

            '//プライマリキーの設定
            .PrimaryKey = pkey 'ID
        End With
        Return DtAnken.Clone()
    End Function

    ''' <summary>
    ''' 項目をカンマ区切りで並べます
    ''' </summary>
    ''' <param name="ArgTBL">並べたいDataTable</param>
    ''' <returns>StringBuilder</returns>
    ''' <remarks></remarks>
    Public Function ColmunsName(ArgTBL As DataTable) As StringBuilder
        Dim colname As New StringBuilder
        For Each col As DataColumn In ArgTBL.Columns
            colname.Append(col.ColumnName)
            colname.Append(",")
        Next
        colname.Remove(colname.Length - 1, 1)
        Return colname
    End Function

    ''' <summary>
    ''' sObjectの中身をDataTableに入れて戻す
    ''' </summary>
    ''' <param name="argDtanken"></param>
    ''' <param name="argsQueryResult"></param>
    ''' <returns></returns>
    ''' <remarks>QueryResult用</remarks>
    Public Function sObject2AnkenTables(argDtanken As DataTable, argsQueryResult As QueryResult) As DataTable
        Dim DrNew As DataRow
        'データが戻ってこないとき、空を返却
        If IsNothing(argsQueryResult.records) Then
            Return argDtanken
            Exit Function
        End If
        For i = 0 To argsQueryResult.records.Length - 1
            Dim Rec As sObject
            Rec = argsQueryResult.records(i)
            DrNew = argDtanken.NewRow()
            For col = 0 To Rec.Any.Length - 1
                Select Case argDtanken.Columns(Rec.Any(col).LocalName).DataType
                    Case GetType(System.DateTime)
                        If Rec.Any(col).InnerText = "" Then
                            DrNew.Item(Rec.Any(col).LocalName) = DBNull.Value
                        Else
                            DrNew.Item(Rec.Any(col).LocalName) = Rec.Any(col).InnerText
                        End If
                    Case Else
                        '改行コードを変換する
                        If IsNothing(Rec.Any(col).FirstChild) Then
                            DrNew.Item(Rec.Any(col).LocalName) = ""
                        Else
                            DrNew.Item(Rec.Any(col).LocalName) = Rec.Any(col).InnerText
                        End If

                End Select
            Next
            argDtanken.Rows.Add(DrNew)
        Next
        Return argDtanken.Copy
    End Function

    ''' <summary>
    ''' sObjectの中身をDataTableに入れて戻す
    ''' </summary>
    ''' <param name="argDtanken"></param>
    ''' <param name="argsFindResult"></param>
    ''' <returns></returns>
    ''' <remarks>SearchResult用</remarks>
    Public Function sObject2AnkenTables(argDtanken As DataTable, argsFindResult As SearchResult) As DataTable
        'データが戻ってこないとき、空を返却
        If IsNothing(argsFindResult.searchRecords) Then
            Return argDtanken
            Exit Function
        End If

        Dim DrNew As DataRow
        For i = 0 To argsFindResult.searchRecords.Length - 1
            Dim Rec As sObject
            Rec = argsFindResult.searchRecords(i).record
            DrNew = argDtanken.NewRow()
            For col = 0 To Rec.Any.Length - 1
                Select Case argDtanken.Columns(Rec.Any(col).LocalName).DataType
                    Case GetType(System.DateTime)
                        If Rec.Any(col).InnerText = "" Then
                            DrNew.Item(Rec.Any(col).LocalName) = DBNull.Value
                        Else
                            DrNew.Item(Rec.Any(col).LocalName) = Rec.Any(col).InnerText
                        End If
                    Case Else
                        DrNew.Item(Rec.Any(col).LocalName) = Rec.Any(col).InnerText
                End Select
            Next
            argDtanken.Rows.Add(DrNew)
        Next
        Return argDtanken.Copy
    End Function
    ''' <summary>
    ''' 
    ''' </summary>
    ''' <param name="argDtanken"></param>
    ''' <param name="argsobjects"></param>
    ''' <returns></returns>
    ''' <remarks>リトリーブ用</remarks>
    Public Function sObject2AnkenTables(argDtanken As DataTable, argsobjects As sObject()) As DataTable
        Dim DrNew As DataRow
        For i = 0 To argsobjects.Length - 1
            Dim Rec As sObject
            Rec = argsobjects(i)
            DrNew = argDtanken.NewRow()
            For col = 0 To Rec.Any.Length - 1
                Select Case argDtanken.Columns(Rec.Any(col).LocalName).DataType
                    Case GetType(System.DateTime)
                        If Rec.Any(col).InnerText = "" Then
                            DrNew.Item(Rec.Any(col).LocalName) = DBNull.Value
                        Else
                            DrNew.Item(Rec.Any(col).LocalName) = Rec.Any(col).InnerText
                        End If
                    Case Else
                        'テキストボックスのマルチラインに対応させるため
                        DrNew.Item(Rec.Any(col).LocalName) = Replace(Rec.Any(col).InnerText, vbLf, vbCrLf)
                End Select
            Next
            argDtanken.Rows.Add(DrNew)
        Next
        Return argDtanken.Copy
    End Function

    ''' <summary>
    ''' 変更をデータベースに反映させるためのsObjectを作成します(複数レコード対応）
    ''' </summary>
    ''' <param name="ArgDt">対象のDataTable</param>
    ''' <param name="mode">Editmode</param>
    ''' <returns>sObject配列</returns>
    ''' <remarks>Editmode.update Modified行だけが対象
    ''' 　　　　Editmode.insert　Added行だけが対象</remarks>
    Public Function DataTables2sObjects(ByVal ArgDt As DataTable, ByVal mode As Editmode) As sObject()
        Dim p As New sObject
        Dim elm As New System.Collections.ArrayList
        Dim feildofnull As New System.Collections.ArrayList
        Dim sObj As New System.Collections.ArrayList

        For Each EditRec As DataRow In ArgDt.Rows
            'レコード単位で初期化
            elm.Clear()
            feildofnull.Clear()
            '更新モード
            Select Case mode
                Case Editmode.update
                    '行ステータスが「変更」のものだけ対象
                    If EditRec.RowState = DataRowState.Modified Then
                        p.type = ArgDt.TableName
                        p.Id = EditRec.Item("id").ToString
                        Dim doc As New XmlDocument
                        'カラム名称を取出し、XML要素にする
                        '項目単位に変更点が不明なので、全部行う
                        For i As Integer = 0 To ArgDt.Columns.Count - 1
                            Dim Colname As String
                            Colname = ArgDt.Columns(i).ColumnName
                            'id以外
                            If Colname <> "id" Then
                                '変更前と後で変更があったか判断対応
                                'Dbnullでエラーになるための
                                If IIf(IsDBNull(EditRec(Colname, DataRowVersion.Original)), "", EditRec(Colname, DataRowVersion.Original)) <>
                                    IIf(IsDBNull(EditRec(Colname, DataRowVersion.Current)), "", EditRec(Colname, DataRowVersion.Current)) Then
                                    'NULLに更新があった項目とそれ以外
                                    If IsDBNull(EditRec(Colname, DataRowVersion.Current)) OrElse IsNothing(EditRec(Colname, DataRowVersion.Current)) Then

                                        feildofnull.Add(Colname)

                                    Else
                                        Dim elem As XmlElement = Nothing
                                        '変更があったら、Element要素と値の作成
                                        elem = doc.CreateElement(Colname)
                                        '日付ならスラッシュをハイフンに変換する
                                        If ArgDt.Columns(Colname).DataType = GetType(System.DateTime) Then
                                            elem.InnerText = Replace(EditRec.Item(Colname), "/", "-")
                                        Else
                                            elem.InnerText = IIf(IsDBNull(EditRec.Item(Colname)), "", EditRec.Item(Colname))
                                        End If
                                        'Arreyに一旦格納（複数変更対応）
                                        elm.Add(elem)

                                    End If
                                End If
                            End If
                        Next
                        If Not IsNothing(elm) Then
                            'Arryに格納したXmlElementを展開して代入しなおす
                            Dim ElemList(elm.Count - 1) As XmlElement
                            Dim cntidx As Integer = 0
                            For Each dmyelem As Object In elm.ToArray
                                ElemList(cntidx) = CType(dmyelem, XmlElement)
                                cntidx += 1
                            Next
                            '変更要素を配列化してsObjectの要素として代入
                            p.Any = ElemList
                            'そのsObjectをArreyに格納（複数レコード対応）
                        End If
                        If Not IsNothing(feildofnull) Then
                            p.fieldsToNull = CType(feildofnull.ToArray(GetType(String)), String())
                        End If
                        sObj.Add(p)
                    End If
                    '新規モード
                Case Editmode.insert
                    If EditRec.RowState = DataRowState.Added Then
                        p.type = ArgDt.TableName
                        Dim doc As New XmlDocument
                        For i As Integer = 0 To ArgDt.Columns.Count - 1
                            Dim Colname As String
                            Colname = ArgDt.Columns(i).ColumnName
                            If Colname <> "id" Then
                                Dim elem As XmlElement
                                elem = doc.CreateElement(Colname)
                                '日付ならスラッシュをハイフンに変換する
                                If ArgDt.Columns(Colname).DataType = GetType(System.DateTime) Then
                                    elem.InnerText = Replace(EditRec.Item(Colname), "/", "-")
                                Else
                                    elem.InnerText = IIf(IsDBNull(EditRec.Item(Colname)), "", EditRec.Item(Colname))
                                End If

                                elm.Add(elem)
                            End If
                        Next
                        If Not IsNothing(elm) Then
                            'Arryに格納したXmlElementを展開して代入しなおす
                            Dim ElemList(elm.Count - 1) As XmlElement
                            Dim cntidx As Integer = 0
                            For Each dmyelem As Object In elm.ToArray
                                ElemList(cntidx) = CType(dmyelem, XmlElement)
                                cntidx += 1
                            Next
                            '変更要素を配列化してsObjectの要素として代入
                            p.Any = ElemList
                            'そのsObjectをArreyに格納（複数レコード対応）
                            sObj.Add(p)
                        End If
                    End If
            End Select
        Next
        '作成されたArreyをsObject配列に入れなおす
        If Not IsNothing(sObj) Then
            Dim sObjectp(sObj.Count - 1) As sObject
            Dim objidx As Integer = 0
            For Each dmyobj As Object In sObj.ToArray
                sObjectp(objidx) = CType(dmyobj, sObject)
                objidx += 1
            Next
            Return sObjectp
        Else
            Return Nothing
        End If
    End Function


    Public Function MakeListData(ArgDs As DataSet) As DataSet
        Dim NewRec As DataRow
        'データセットのデータを細分化して各テーブルとして再設定する
        If ArgDs.Tables.Count > 1 Then
            Return Nothing
            Exit Function
        End If
        Try
            '-------------------ST-------------
            Dim DtTmp As New DataTable
            DtTmp = ArgDs.Tables(0).Clone
            DtTmp.TableName = "ST"
            '未選択行を追加する  
            NewRec = DtTmp.NewRow()
            NewRec.Item("no") = 0
            NewRec.Item("id") = "ST"
            NewRec.Item("label") = "未選択"
            NewRec.Item("val") = DBNull.Value
            DtTmp.Rows.Add(NewRec)
            For Each R As DataRow In ArgDs.Tables(0).Select("ID = 'ST'")
                DtTmp.Rows.Add(R.ItemArray)
            Next
            ArgDs.Tables.Add(DtTmp)
            '-------------------TYPE-------------
            Dim Dttype As New DataTable
            Dttype = ArgDs.Tables(0).Clone
            Dttype.TableName = "TYPE"
            '未選択行を追加する
            NewRec = Dttype.NewRow()
            NewRec.Item("no") = 0
            NewRec.Item("id") = "TYPE"
            NewRec.Item("label") = "未選択"
            NewRec.Item("val") = DBNull.Value
            Dttype.Rows.Add(NewRec)
            For Each R As DataRow In ArgDs.Tables(0).Select("ID = 'TYPE'")
                Dttype.Rows.Add(R.ItemArray)
            Next
            ArgDs.Tables.Add(Dttype)
            '-------------------KIND-------------
            Dim Dtkind As New DataTable
            Dtkind = ArgDs.Tables(0).Clone
            Dtkind.TableName = "KIND"
            '未選択行を追加する
            NewRec = Dtkind.NewRow()
            NewRec.Item("no") = 0
            NewRec.Item("id") = "KIND"
            NewRec.Item("label") = "未選択"
            NewRec.Item("val") = DBNull.Value
            Dtkind.Rows.Add(NewRec)
            For Each R As DataRow In ArgDs.Tables(0).Select("ID = 'KIND'")
                Dtkind.Rows.Add(R.ItemArray)
            Next
            ArgDs.Tables.Add(Dtkind)
            '-------------------A(持込）-------------
            Dim DtA As New DataTable
            DtA = ArgDs.Tables(0).Clone
            DtA.TableName = "A"
            '未選択行を追加する
            NewRec = DtA.NewRow()
            NewRec.Item("no") = 0
            NewRec.Item("id") = "A"
            NewRec.Item("label") = "未選択"
            NewRec.Item("val") = DBNull.Value
            DtA.Rows.Add(NewRec)
            For Each R As DataRow In ArgDs.Tables(0).Select("ID = 'A'")
                DtA.Rows.Add(R.ItemArray)
            Next
            ArgDs.Tables.Add(DtA)
            '-------------------APP-------------
            Dim DtApp As New DataTable
            DtApp = ArgDs.Tables(0).Clone
            DtApp.TableName = "APP"
            '未選択行を追加する
            NewRec = DtApp.NewRow()
            NewRec.Item("no") = 0
            NewRec.Item("id") = "APP"
            NewRec.Item("label") = "未選択"
            NewRec.Item("val") = DBNull.Value
            DtApp.Rows.Add(NewRec)
            For Each R As DataRow In ArgDs.Tables(0).Select("ID = 'APP'")
                DtApp.Rows.Add(R.ItemArray)
            Next
            ArgDs.Tables.Add(DtApp)
            '-------------------WORK-------------
            Dim DtWORK As New DataTable
            DtWORK = ArgDs.Tables(0).Clone
            DtWORK.TableName = "WORK"
            '未選択行を追加する
            NewRec = DtWORK.NewRow()
            NewRec.Item("no") = 0
            NewRec.Item("id") = "WORK"
            NewRec.Item("label") = "未選択"
            NewRec.Item("val") = DBNull.Value
            DtWORK.Rows.Add(NewRec)
            For Each R As DataRow In ArgDs.Tables(0).Select("ID = 'WORK'")
                DtWORK.Rows.Add(R.ItemArray)
            Next
            ArgDs.Tables.Add(DtWORK)
            '-------------------FD--------------
            Dim DtFD As New DataTable
            DtFD = ArgDs.Tables(0).Clone
            DtFD.TableName = "FD"
            '未選択行を追加する
            NewRec = DtFD.NewRow()
            NewRec.Item("no") = 0
            NewRec.Item("id") = "FD"
            NewRec.Item("label") = "未選択"
            NewRec.Item("val") = DBNull.Value
            DtFD.Rows.Add(NewRec)
            For Each R As DataRow In ArgDs.Tables(0).Select("ID = 'FD'")
                DtFD.Rows.Add(R.ItemArray)
            Next
            ArgDs.Tables.Add(DtFD)

            '-------------------DIFF--------------
            Dim DtDiff As New DataTable
            DtDiff = ArgDs.Tables(0).Clone
            DtDiff.TableName = "DIFF"
            '未選択行を追加する
            NewRec = DtDiff.NewRow()
            NewRec.Item("no") = 0
            NewRec.Item("id") = "DIFF"
            NewRec.Item("label") = "未選択"
            NewRec.Item("val") = DBNull.Value
            DtDiff.Rows.Add(NewRec)
            For Each R As DataRow In ArgDs.Tables(0).Select("ID = 'DIFF'")
                DtDiff.Rows.Add(R.ItemArray)
            Next
            ArgDs.Tables.Add(DtDiff)

            ArgDs.AcceptChanges()
            Return ArgDs.Copy
        Catch ex As Exception
            MessageBox.Show(ex.Message)
            Return Nothing
        End Try
    End Function

    ''' <summary>
    ''' メインウィンドウの位置を相対的に取得
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function GetCenterWindowPostion() As Point
        Dim screenH As Integer
        Dim ScreenW As Integer
        Dim SavePoint As Point
        screenH = (FrmMain.Top + FrmMain.Height) / 2
        ScreenW = (FrmMain.Left + FrmMain.Width) / 2
        '//プライマリーディスプレイの作業領域の取得
        'screenH = My.Computer.Screen.WorkingArea.Height
        'ScreenW = My.Computer.Screen.WorkingArea.Width
        'screenH = screenH / 2
        'ScreenW = ScreenW / 2
        SavePoint.X = ScreenW
        SavePoint.Y = screenH

        Return SavePoint
    End Function

    Public Sub ShowFrmProginfo()
        Dim loca As Point

        loca = GetCenterWindowPostion()
        loca.X = loca.X - FrmProgInfo.Width / 2
        loca.Y = loca.Y - FrmProgInfo.Height / 2
        FrmProgInfo.LocalPosition = loca
        FrmProgInfo.Show()
        Application.DoEvents()
    End Sub

    Public Sub setKartyWindow()
        Dim loca As Point
        loca = GetCenterWindowPostion()
        loca.X = loca.X - FrmKarty.Width / 2
        loca.Y = loca.Y - FrmKarty.Height / 2
        FrmKarty.LocalPosition = loca
    End Sub
    ''' <summary>
    ''' 
    ''' </summary>
    ''' <param name="ArgDt"></param>
    ''' <param name="sBinding"></param>
    ''' <returns></returns>
    ''' <remarks>保存は複数対応ですが返却が１件単位</remarks>
    Public Function Save(ArgDt As DataTable, sBinding As SoapCliantControl) As String

        Dim DtChg As DataTable
        Dim sR As SaveResult()
        Dim id As String = ""
        DtChg = ArgDt.GetChanges()
        '対象データがあるか確認。ないならスルー
        If IsNothing(DtChg) OrElse DtChg.Rows.Count = 0 Then
            Return False
            Exit Function
        End If

        '更新用(複数用）
        Dim updp() As sObject
        Dim insp() As sObject

        updp = DataTables2sObjects(DtChg, Editmode.update)
        insp = DataTables2sObjects(DtChg, Editmode.insert)

        Dim updSuccessCnt As Integer
        Dim insSuccesscnt As Integer

        If updp.Length > 0 Then
            sR = sBinding.update(updp)
            For i = 0 To sR.Length - 1
                If (sR(i).success) Then
                    updSuccessCnt += 1
                    id = sR(i).id
                Else
                    MessageBox.Show("更新エラー対象id=" & id & vbCrLf & "エラー内容=" & sR(i).errors(0).ToString, "保存エラー", MessageBoxButtons.OK, MessageBoxIcon.Error)
                    Return ""
                    Exit Function
                End If
            Next
            Return id
        End If
        If insp.Length > 0 Then
            sR = sBinding.create(insp)
            For i = 0 To sR.Length - 1
                '成功ならidが返却される
                If (sR(i).success) Then
                    insSuccesscnt += 1
                    id = sR(i).id
                Else
                    MessageBox.Show("エラー内容=" & sR(i).errors(0).ToString, "保存エラー", MessageBoxButtons.OK, MessageBoxIcon.Error)
                    Return ""
                    Exit Function
                End If
            Next
        End If
        'MessageBox.Show("更新件数：" & updSuccessCnt.ToString & vbCrLf & "新規件数:" & insSuccesscnt.ToString, "更新しました", MessageBoxButtons.OK, MessageBoxIcon.Information)
        Return id
    End Function

#Region "CSV変換"

    ''' <summary>
    ''' DataTableの内容をCSVファイルに保存する
    ''' </summary>
    ''' <param name="dt">CSVに変換するDataTable</param>
    ''' <param name="csvPath">保存先のCSVファイルのパス</param>
    ''' <param name="writeHeader">ヘッダを書き込む時はtrue。</param>
    Public Sub ConvertDataTableToCsv( _
            dt As DataTable, csvPath As String, writeHeader As Boolean)
        'CSVファイルに書き込むときに使うEncoding
        Dim enc As System.Text.Encoding = _
            System.Text.Encoding.GetEncoding("Shift_JIS")

        '書き込むファイルを開く
        Dim sr As New System.IO.StreamWriter(csvPath, False, enc)

        Dim colCount As Integer = dt.Columns.Count
        Dim lastColIndex As Integer = colCount - 1
        Dim i As Integer

        'ヘッダを書き込む
        If writeHeader Then
            For i = 0 To colCount - 1
                'ヘッダの取得
                Dim field As String = dt.Columns(i).Caption
                '"で囲む
                field = EncloseDoubleQuotesIfNeed(field)
                'フィールドを書き込む
                sr.Write(field)
                'カンマを書き込む
                If lastColIndex > i Then
                    sr.Write(","c)
                End If
            Next
            '改行する
            sr.Write(vbCrLf)
        End If

        'レコードを書き込む
        Dim row As DataRow
        For Each row In dt.Rows
            For i = 0 To colCount - 1
                Dim field As String
                If row.Table.Columns(i).DataType = GetType(System.DateTime) Then
                    field = Format(row(i), "yyyy/MM/dd")
                Else
                    field = row(i).ToString()
                End If
                'フィールドの取得

                '"で囲む
                Field = EncloseDoubleQuotesIfNeed(Field)
                'フィールドを書き込む
                sr.Write(Field)
                'カンマを書き込む
                If lastColIndex > i Then
                    sr.Write(","c)
                End If
            Next
            '改行する
            sr.Write(vbCrLf)
        Next

        '閉じる
        sr.Close()
    End Sub

    ''' <summary>
    ''' 必要ならば、文字列をダブルクォートで囲む
    ''' </summary>
    Private Function EncloseDoubleQuotesIfNeed(field As String) As String
        If NeedEncloseDoubleQuotes(field) Then
            Return EncloseDoubleQuotes(field)
        End If
        Return field
    End Function

    ''' <summary>
    ''' 文字列をダブルクォートで囲む
    ''' </summary>
    Private Function EncloseDoubleQuotes(field As String) As String
        If field.IndexOf(""""c) > -1 Then
            '"を""とする
            field = field.Replace("""", """""")
        End If
        Return """" & field & """"
    End Function

    ''' <summary>
    ''' 文字列をダブルクォートで囲む必要があるか調べる
    ''' </summary>
    Private Function NeedEncloseDoubleQuotes(field As String) As Boolean
        Return field.IndexOf(""""c) > -1 OrElse _
            field.IndexOf(","c) > -1 OrElse _
            field.IndexOf(ControlChars.Cr) > -1 OrElse _
            field.IndexOf(ControlChars.Lf) > -1 OrElse _
            field.StartsWith(" ") OrElse _
            field.StartsWith(vbTab) OrElse _
            field.EndsWith(" ") OrElse _
            field.EndsWith(vbTab)
    End Function

#End Region
End Module
