﻿' 以下の名前空間をインポートする
Imports System.Diagnostics
Imports System.Runtime.InteropServices

Public Class ProcessClass

    Public ProductNo As String              'No
    Public PhoneNo As String                '電話番号
    Public ID As String                     'ID
    Public Password As String               'パスワード
    Public Question1 As String              '質問1
    Public Answer1 As String                '回答1
    Public Question2 As String              '質問2
    Public Answer2 As String                '回答2
    Public Question3 As String              '質問3
    Public Answer3 As String                '回答3
    Public BirthDay As Date                 '誕生日
    Public MailReceiveiTunes As Boolean     'メール受信(itune)
    Public MailReceiveApple As Boolean      'メール受信(Apple)
    '    Public RescueMail As String            '任意レスキューメール
    Public LastName As String               '姓
    Public FirstName As String              '名
    Public LastNameJP As String             '姓(ふりがな)
    Public FirstNameJP As String            '名(ふりがな)
    Public PostCode As String               '郵便番号
    Public PrefName As String               '都道府県
    Public CityName As String               '市区町村
    Public Address As String                '住所
    Public Tel As String                    '電話番号
    Public AutoEnter As Boolean             '自動遷移フラグ

    'プロセスWindowを表示するAPI
    '<DllImport("USER32.DLL", CharSet:=CharSet.Auto)> _
    'Private Shared Function ShowWindow( _
    '    ByVal hWnd As System.IntPtr, _
    '    ByVal nCmdShow As Integer) As Integer
    'End Function

    '指定プロセスを最前面にもってくるAPI
    '<DllImport("USER32.DLL", CharSet:=CharSet.Auto)> _
    'Private Shared Function SetForegroundWindow( _
    '    ByVal hWnd As System.IntPtr) As Boolean
    'End Function

    'Private Const SW_NORMAL As Integer = 1

    ''' ------------------------------------------------------------------------------------
    ''' <summary>
    '''     iTuesのプロセスが起動中の場合、メイン ウィンドウをアクティブにします。</summary>
    ''' <returns>
    '''     既に起動中であれば True。それ以外は False。</returns>
    ''' ------------------------------------------------------------------------------------
    Public Shared Function ShowiTunesProcess() As Boolean
        Const ITUNES As String = "iTunes"
        Dim hProcesses As Process() = Process.GetProcessesByName(ITUNES)
        Dim iThisProcessId As Integer

        ' 取得できたプロセスからプロセス ID を取得する
        For Each hProcess As Process In hProcesses
            '予定では1プロセスしかないはず
            iThisProcessId = hProcess.Id
            If hProcess.Id = iThisProcessId Then
                AppActivate(hProcess.Id)
                'Call ShowWindow(hProcess.MainWindowHandle, SW_NORMAL)
                'Call SetForegroundWindow(hProcess.MainWindowHandle)
                Return True
            End If
        Next hProcess

        Return False
    End Function

    '誕生日の年を取り出す
    Public Function GetBirthYear() As Integer
        GetBirthYear = BirthDay.Year
    End Function

    '誕生日の月を取り出す
    Public Function GetBirthMonth() As Integer
        GetBirthMonth = BirthDay.Month
    End Function

    '誕生日の日を取り出す
    Public Function GetBirthDate() As Integer
        GetBirthDate = BirthDay.Day
    End Function

    '年齢を取り出す
    Public Function GetAge() As Long
        '和暦の場合、正しく計算しないのでその対応

        Return ((Today.Year * 10000 + Today.Month * 100 + Today.Day) - _
        (BirthDay.Year * 10000 + BirthDay.Month * 100 + BirthDay.Day)) \ 10000

    End Function

    '電話番号から市外局番の位置を特定する
    Public Function GetTelCityNo() As String

        Dim i As Integer
        Dim strRet As String

        If Len(Tel) = 0 Then GetTelCityNo = ""

        strRet = ""
        For i = 0 To Len(Tel)

            If Mid(Tel, i + 1, 1) = "-" Then
                Return strRet
                'GetTelCityNo = strRet
                Exit For
            Else
                strRet = strRet & Mid(Tel, i + 1, 1)
            End If
        Next

    End Function

    '電話番号から市外局番を抜く
    Public Function GetTelNo() As String

        Return Mid(Tel, Len(GetTelCityNo) + 2)

    End Function

    'Sendkeyが特殊操作記号として認識する文字を、特殊文字ではなく、一般文字に変換する
    '「＋」=SHIFT「＾」=CTRL「％」=ALT
    Public Function sendkeySpecialstring(ByVal ArgStr As String) As String
        Dim tmpStr As String
        tmpStr = Replace(ArgStr, "+", "{+}")
        tmpStr = Replace(tmpStr, "^", "{^}")
        tmpStr = Replace(tmpStr, "%", "{%}")
        sendkeySpecialstring = tmpStr
    End Function

    'iTunesの画面1用の操作
    Public Function InputiTunes1(ArgDeley As Integer) As Boolean
        Dim Deley As Integer
        Dim i As Integer

        '秒をミリセックに変換
        Deley = ArgDeley * 1000
        If Not ShowiTunesProcess() Then
            MessageBox.Show("iTunesが見つかりません。" & vbCrLf & "iTunesを起動し、新規AppleID取得画面で待機してください", "iTunesがみつかりません", MessageBoxButtons.OK, MessageBoxIcon.Exclamation)
            Return False
            Exit Function
        End If

        'AppActivate(task.Name, False)
        Try

            System.Threading.Thread.Sleep(Deley)
            SendKeys.SendWait("{TAB}")
            System.Threading.Thread.Sleep(Deley)
            'AppleID
            SendKeys.SendWait(ID)
            System.Threading.Thread.Sleep(Deley)

            SendKeys.SendWait("{TAB}")
            System.Threading.Thread.Sleep(Deley)
            'パスワード
            SendKeys.SendWait(Password)
            SendKeys.SendWait("{TAB}")
            System.Threading.Thread.Sleep(Deley)
            '確認パスワード
            SendKeys.SendWait(Password)
            System.Threading.Thread.Sleep(Deley)
            SendKeys.SendWait("{TAB}")
            System.Threading.Thread.Sleep(Deley)
            '質問１
            SendKeys.SendWait(Question1)
            SendKeys.SendWait("{TAB}")
            SendKeys.SendWait(Answer1)
            SendKeys.SendWait("{TAB}")
            '質問２
            SendKeys.SendWait(Question2)
            SendKeys.SendWait("{TAB}")
            SendKeys.SendWait(Answer2)
            SendKeys.SendWait("{TAB}")
            '質問３
            SendKeys.SendWait(Question3)
            SendKeys.SendWait("{TAB}")
            SendKeys.SendWait(Answer3)
            SendKeys.SendWait("{TAB}")
            'レスキューメール(任意）
            SendKeys.SendWait("{TAB}")
            ' SendKeys.SendWait("{TAB}")
            System.Threading.Thread.Sleep(Deley)
            '年
            SendKeys.SendWait(GetBirthYear)
            System.Threading.Thread.Sleep(Deley)
            SendKeys.SendWait("{TAB}")
            System.Threading.Thread.Sleep(Deley)

            '月
            SendKeys.SendWait("{HOME}")
            System.Threading.Thread.Sleep(Deley)

            For i = 0 To GetBirthMonth() - 1
                SendKeys.SendWait("{DOWN}")
            Next

            SendKeys.SendWait("{TAB}")
            System.Threading.Thread.Sleep(Deley)
            '日
            SendKeys.SendWait("{HOME}")
            System.Threading.Thread.Sleep(Deley)

            For i = 0 To GetBirthDate() - 1
                SendKeys.SendWait("{DOWN}")
            Next

            SendKeys.SendWait("{TAB}")
            System.Threading.Thread.Sleep(Deley)
            'False=0 True=1
            'チェックなし=0　チェックあり=1
            'iTunesニュースリリース受信
            '年齢が20以下だとDMが外れるので、その対応
            If GetAge() >= 20 Then
                If Not MailReceiveiTunes Then
                    SendKeys.SendWait(" ")
                End If
            Else
                If MailReceiveiTunes Then
                    SendKeys.SendWait(" ")
                End If
            End If

            System.Threading.Thread.Sleep(Deley)
            SendKeys.SendWait("{TAB}")
            System.Threading.Thread.Sleep(Deley)
            'False=0 True=1
            'チェックなし=0　チェックあり=1
            'iTunesニュースリリース受信
            '年齢が20以下だとDMが外れるので、その対応
            If GetAge() >= 20 Then
                If Not MailReceiveiTunes Then
                    SendKeys.SendWait(" ")
                End If
            Else
                If MailReceiveiTunes Then
                    SendKeys.SendWait(" ")
                End If
            End If

            '戻るフォーカス
            SendKeys.SendWait("{TAB}")
            'キャンセル
            SendKeys.SendWait("{TAB}")
            '次
            SendKeys.SendWait("{TAB}")

            '自動遷移がオンの場合
            If AutoEnter Then
                System.Threading.Thread.Sleep(Deley)
                'Enter
                SendKeys.SendWait("{ENTER}")
            End If
            Return True

        Catch ex As Exception
            MessageBox.Show(ex.Message)
            Return False
        End Try

    End Function

    'iTunesの画面2用の操作
    Public Function InputiTunes2(ArgDeley As Integer) As Boolean

        Dim Deley As Integer

        '秒をミリセックに変換
        Deley = ArgDeley * 1000
        If Not ShowiTunesProcess() Then
            MessageBox.Show("iTunesが見つかりません。" & vbCrLf & "iTunesを起動し、新規AppleID取得画面で待機してください", "iTunesがみつかりません", MessageBoxButtons.OK, MessageBoxIcon.Exclamation)
            Return False
            Exit Function
        End If

        Try

            System.Threading.Thread.Sleep(Deley)
            SendKeys.SendWait("{TAB}")
            SendKeys.SendWait("{TAB}")
            SendKeys.SendWait("{TAB}")
            SendKeys.SendWait("{TAB}")
            SendKeys.SendWait("{TAB}")
            SendKeys.SendWait("{TAB}")
            SendKeys.SendWait("{TAB}")
            SendKeys.SendWait("{TAB}")
            System.Threading.Thread.Sleep(Deley)
            SendKeys.SendWait("{TAB}")

            System.Threading.Thread.Sleep(Deley)
            '姓
            SendKeys.SendWait(LastName)
            System.Threading.Thread.Sleep(Deley)
            SendKeys.SendWait("{TAB}")

            System.Threading.Thread.Sleep(Deley)
            '名
            SendKeys.SendWait(FirstName)
            System.Threading.Thread.Sleep(Deley)
            SendKeys.SendWait("{TAB}")

            System.Threading.Thread.Sleep(Deley)
            '姓（かな）
            SendKeys.SendWait(LastNameJP)
            System.Threading.Thread.Sleep(Deley)
            SendKeys.SendWait("{TAB}")

            System.Threading.Thread.Sleep(Deley)
            '名（かな）
            SendKeys.SendWait(FirstNameJP)
            System.Threading.Thread.Sleep(Deley)
            SendKeys.SendWait("{TAB}")

            System.Threading.Thread.Sleep(Deley)
            '郵便番号
            SendKeys.SendWait(PostCode)
            System.Threading.Thread.Sleep(Deley)
            SendKeys.SendWait("{TAB}")

            System.Threading.Thread.Sleep(Deley)
            '都道府県リスト
            SendKeys.SendWait("{HOME}")
            System.Threading.Thread.Sleep(Deley)
            SendKeys.SendWait(PrefName)
            System.Threading.Thread.Sleep(Deley)
            SendKeys.SendWait("{TAB}")
            '市町村
            System.Threading.Thread.Sleep(Deley)
            SendKeys.SendWait(CityName)
            System.Threading.Thread.Sleep(Deley)
            SendKeys.SendWait("{TAB}")
            '住所
            System.Threading.Thread.Sleep(Deley)
            SendKeys.SendWait(Address)

            System.Threading.Thread.Sleep(Deley)
            SendKeys.SendWait("{TAB}")
            System.Threading.Thread.Sleep(Deley)
            SendKeys.SendWait("{TAB}")
            '市外局番
            System.Threading.Thread.Sleep(Deley)
            SendKeys.SendWait(GetTelCityNo)
            System.Threading.Thread.Sleep(Deley)

            SendKeys.SendWait("{TAB}")
            System.Threading.Thread.Sleep(Deley)
            '電話番号
            SendKeys.SendWait(GetTelNo)

            System.Threading.Thread.Sleep(Deley)
            SendKeys.SendWait("{TAB}")
            SendKeys.SendWait("{TAB}")
            SendKeys.SendWait("{TAB}")
            '自動遷移がオンの場合
            If AutoEnter Then
                System.Threading.Thread.Sleep(Deley)
                'Enter
                SendKeys.SendWait("{ENTER}")
            End If
            Return True
        Catch ex As Exception
            MessageBox.Show(ex.Message)
            Return False
        End Try

    End Function
End Class
