﻿Imports Microsoft.Win32

'組み込んで利用しているWebBrowserのバージョンがIE7のため、それを別のヴァージョン(IE9)で利用させるのが目的
'HKEY_CURRENT_USER\Software\Microsoft\Internet Explorer\Main\FeatureControl
'に、キー「FEATURE_BROWSER_EMULATION」を追加して、
'その中にDWORD型で、プログラムのファイル名の値を作成し、値のデータを10000(Ver10)にします。

Public Class RegistryControl

    Public Sub SetBrowberChange(ByVal ArgAppName As String)
        Const Regpath As String = "Software\Microsoft\Internet Explorer\Main\FeatureControl\FEATURE_BROWSER_EMULATION"
        Dim wkReg As RegistryKey
        Dim wkDWORD As Integer

        'アクセス権がないと読込すらはじかれる対応
        Try
            wkReg = Registry.CurrentUser.OpenSubKey(Regpath, True)
            '指定パスが存在しないとき、Nullを返す
            If IsNothing(wkReg) Then
                'サブキーが存在しないので、作成する
                wkReg = Registry.CurrentUser.CreateSubKey(Regpath)
            End If
            'キーを指定して値を取り出す
            wkDWORD = CInt(wkReg.GetValue(ArgAppName))
            '値がない場合0を返す
            If wkDWORD = 0 Then
#If DEBUG Then
                'デバッグ用プロセス名
                wkReg.SetValue(ArgAppName & ".vshost.exe", 11000)
#Else
                'リリース用プロセス名
                wkReg.SetValue(ArgAppName & ".exe", 11000)
#End If
            End If
            wkReg.Close()
        Catch ex As Exception

        End Try
    End Sub

End Class
