  for help_class in all synopsis options actions
  do case $help_class in ${optarg-"all"}*) optarg=$help_class;; esac
  done

  help_synopsis(){
    cat <<-ETX
	Usage: ${cmd-"mingw-pkg"} [OPTIONS] [ACTION ...]
	Construct and manage MinGW.org standard distributable packages.

	ETX
      }

  help_options(){
    cat <<-ETX
	Options:
	  --help[=class]	Display help, and exit; "class" is any one of:--
	  	synopsis	Show only the command synopsis.
	  	options		Show the synopsis, and summary of options.
	  	actions		Show the synopsis, and summary of action keywords.
	  	all		Show the full "help" display; (this is the default).

	ETX
      }

  help_actions(){
    cat <<-ETX
	Actions:
	  initialize		Prepare the development environment, considering
	  			the current state of the package directory as being
	  			representative of the clean upstream package, for
	  			progression towards a MinGW port.

	  compile		Compile the package, in whatever state is currently
	  			represented by the content of the package directory.

	ETX
      }

  case $optarg in
    synopsis) help_$optarg;;
    options | actions) help_synopsis; help_$optarg;;
    all) help_synopsis; help_options; help_actions;;
    *) die "unknown help category '$optarg'";;
  esac

  exit 0
