<?php

class relatefile {

	# ログを配列に代入
	function open_log($logfile) {
		if(!file_exists($logfile)) {$this->make_log("$logfile","");}
		$fp = @fopen("$logfile","r+");
		if(!$fp) {return;}
		flock($fp,LOCK_EX);
		$lines = array();
		while (!feof($fp)) {
			$lines[] = fgets($fp);
		}
		fclose($fp);
		return $lines;
	}

	# ログファイルを作成/編集
	function make_log($logfile,$value) {
		# 改行コード
		$value = str_replace("\r\n","\n",$value);
		$value = str_replace("\r","\n",$value);
		
		# 階層の確認
		$dirs = explode('/',$logfile);
		if($dirs[0] == '.') {@array_shift($dirs);}
		@array_pop($dirs);
		$befDir = '';
		for($u=0;$dirs[$u];$u++) {
			if(!file_exists(".".$befDir."/"."$dirs[$u]")) {
				$newDir = ".".$befDir."/"."$dirs[$u]";
				@mkdir($newDir,0707);
				$old = umask(0);
				chmod($newDir, 0707);
				umask($old);
			}
			$befDir .= "/".$dirs[$u];
		}
		
		# ファイルオープン
		if(!($uni = @fopen("$logfile","r+"))) {
			$uni = fopen("$logfile","w");
			$ext = substr($logfile,strrpos($logfile,'.'));
			if($ext == '.html') {
				$old = umask(0); // パーミッション
				chmod($logfile,0644);
				umask($old);
			} else {
				$old = umask(0); // パーミッション
				chmod($logfile,0606);
				umask($old);
			}
		}
		flock($uni,LOCK_EX);
		ftruncate($uni, 0);
		rewind($uni);
		fwrite($uni, $value);
		fclose($uni);
	}

	# ページ/ディレクトリ一覧ファイルに追記
	function push_line($logfile,$value,$new_id) {
		# その他の外部処理クラス
		$other = new other();

		# 改行コード
		$value = str_replace("\r\n","\n",$value);
		$value = str_replace("\r","\n",$value);

		# ファイルオープン
		if(!file_exists($logfile)) {$this->make_log("$logfile","");}
		$fp = @fopen("$logfile","r+");
		flock($fp,LOCK_EX);
		$lines = array();
		$g = 0;
		while (!feof($fp)) {
			$lines[$g] = fgets($fp);
			# 既存IDか確かめる
			list($type,$id,$notuse) = explode("<>",$lines[$g]);
			if($new_id == $id) {
				fclose($fp);
				$other->error("そのファイル名は既に使用されています");
			}
			$g++;
		}
		$g--;
		$lines[$g] = $value;
		ftruncate($fp, 0);
		rewind($fp);
		for($i=0;$lines[$i];$i++) {
			fputs($fp,$lines[$i]);
		}
		fclose($fp);
	}

	# ページ/ディレクトリ一覧から削除
	function del_line($logfile,$del_id) {
		# ファイルオープン
		$fp = fopen("$logfile","r+") or die;
		flock($fp,LOCK_EX);
		$lines = array();
		while (!feof($fp)) {
			$line = fgets($fp);
			# 該当IDをはじく
			list($type,$id,$notuse) = explode("<>",$line);
			if($del_id != $id) {
				$lines[] = $line;
			} else {
				# 削除対象で、さらにtypeがpageならデリートファイルに追加
				if($type == 'page') {$this->deleted_file("page<>$now_dir$del_id<>");}
			}
		}
		ftruncate($fp, 0);
		rewind($fp);
		for($i=0;$lines[$i];$i++) {
			fputs($fp,$lines[$i]);
		}
		fclose($fp);
	}
	
	# ログファイル削除
	function del_log($logfile) {
		if(@unlink($logfile)) {
			return true;
		} else {return false;}
	}

	# ログファイル詳細
	function log_info($now_dir,$info_id) {
		# log_info配列変数
		$log_info = array();
		
		$Path = "./log/contents_log/".$now_dir."allpage.cgi";
		
		# 一覧ファイルオープン
		if(!file_exists($Path)) {$this->make_log($Path,"");}
		$fp = @fopen($Path,"r+");
		flock($fp,LOCK_EX);
		$lines = array();
		while (!feof($fp)) {
			$line = fgets($fp);
			list($type,$id,$notuse) = explode("<>",$line);
			if($info_id == $id) {
				$info_line = $line;
				break;
			}
		}
		fclose($fp);
		list($log_info[type],$log_info[id],$log_info[title],$log_info[not_titleb],$log_info[not_menu],$log_info[caption],$log_info[explain],$log_info[makedate],$log_info[lastdate],$log_info[non_disp]) = explode("<>",$info_line);
	
		if($log_info[type] == "file") {
			# コンテンツファイルオープン
			if(!file_exists("./log/contents_log/".$now_dir.$info_id.".cgi")) {$this->make_log("./log/contents_log/".$now_dir.$info_id.".cgi","");}
			$fp = @fopen("./log/contents_log/".$now_dir.$info_id.".cgi","r+");
			flock($fp,LOCK_EX);
			$lines = array();
			while (!feof($fp)) {
				$contentsline .= fgets($fp);
			}
			fclose($fp);
		}

		# 整理
		$log_info[contents] = $contentsline;
		
		return $log_info;
	}

	# 削除ファイルを一覧に追加
	function deleted_file($file) {
		# ファイルオープン
		if(!file_exists("./log/contents_log/deleted_files.cgi")) {$this->make_log("./log/contents_log/deleted_files.cgi","");}
		$fp = @fopen("./log/contents_log/deleted_files.cgi","r+");
		flock($fp,LOCK_EX);
		$lines = array();
		while (!feof($fp)) {
			$lines[] = fgets($fp);
		}
		array_unshift($lines,"$file\n");
		ftruncate($fp, 0);
		rewind($fp);
		for($i=0;$lines[$i];$i++) {
			fputs($fp,$lines[$i]);
		}
		fclose($fp);
	}

	# 掲示板ログの編集処理
	function edit_bbslog($logfile,$value) {
		# ファイルオープン
		if(!file_exists($logfile)) {$this->make_log($logfile,"");}
		$fp = @fopen("$logfile","r+");
		flock($fp,LOCK_EX);
		$lines = array();
		while (!feof($fp)) {
			$lines[] = fgets($fp);
		}
		$lines[0] = $value;
		ftruncate($fp, 0);
		rewind($fp);
		for($i=0;$lines[$i];$i++) {
			fputs($fp,$lines[$i]);
		}
		fclose($fp);
	}

	# ファイルに追記(オールマイティ)
	function push_line_def($logfile,$value) {
		# 改行コード
		$value = str_replace("\r\n","\n",$value);
		$value = str_replace("\r","\n",$value);

		# ファイルオープン
		$fp = fopen("$logfile","r+") or die;
		flock($fp,LOCK_EX);
		fseek($fp,0,SEEK_END); 
		fputs($fp,$value);
		fclose($fp);
	}

	# ログを配列に代入(オールマイティ)
	function open_log_def($logfile) {
		$fp = @fopen("$logfile","r+");
		if(!$fp) {return;}
		flock($fp,LOCK_EX);
		$lines = array();
		while (!feof($fp)) {
			$lines[] = fgets($fp);
		}
		fclose($fp);
		return $lines;
	}
}

