<?php

class feedclass
{
	var $initialDir = './log/contents_log/';
	var $outputDir = '../';
	var $outputName = 'feed';
	var $itemLimit = 15;

	function generate( $type = 'RSS' )
	{
		// 対応フィードタイプのチェックと拡張子の決定
		switch( $type )
		{
		case 'RSS':
			$extension = '.rss';
			break;

		default:
			echo( 'feedclass::generate(), not implemented.' );
			return FALSE;
		}

		// エントリ一覧の取得
		$entries = array();
		if( $this->fetch( $entries, $this->initialDir ) === FALSE )
		{
			echo( 'feedclass::generate(), failed at fetch().' );
			return FALSE;
		}
		
		// フィードの構築
		$feed = array();
		switch( $type )
		{
		case 'RSS':
			$feed = $this->generateRSS( $entries );
			break;
		}

		// ファイルへの書き込み
		$fn = $this->outputDir . $this->outputName . $extension;
		$f = fopen( $fn, 'wb' );
		fwrite( $f, join( "\n", $feed ) );
		fclose( $f );
		
		// 完了
		return TRUE;
	}
	
	function &generateRSS( &$entries )
	{
		# WEBサイトURLを取得
		$thisURL = 'http://'.htmlspecialchars($_SERVER['HTTP_HOST'],ENT_QUOTES).htmlspecialchars($_SERVER['REQUEST_URI'],ENT_QUOTES);
		$thisURL = str_replace(basename($_SERVER['SCRIPT_NAME']),"",$thisURL);
		list($thisURL,$notuse) = explode("manage/",$thisURL);
	
		$feed[] = '<?xml version="1.0" encoding="UTF-8" ?>';
		$feed[] = '<rss version="2.0" xmlns:content="http://purl.org/rss/1.0/modules/content/">';
		$feed[] = '<channel>';
		$feed[] = '<title>' . $thisURL . '</title>'; // サイトタイトルはテンプレート埋め込みなのでURLで代用
		$feed[] = '<link>' . $thisURL . '</link>';
		$feed[] = '<pubDate>' . date('r') . '</pubDate>';
		//$feed[] = '<description></description>';
		
		$c = $this->itemLimit;
		foreach( $entries as $e )
		{
			$feed[] = '<item>';
			$feed[] = '<title>' . $this->escape( $e['title'] ) . '</title>';
			$feed[] = '<link>' . $thisURL . $e['path'] . '</link>';
			$feed[] = '<guid isPermaLink="true">' . $thisURL . $e['path'] . '</guid>';
			$feed[] = '<pubDate>' . date( 'r', mktime
			                                   (	substr( $e['last_day'], 9, 2 )
			                                   ,	substr( $e['last_day'], 12, 2 )
			                                   ,	0
			                                   ,	substr( $e['last_day'], 3, 2 )
			                                   ,	substr( $e['last_day'], 6, 2 )
			                                   ,	substr( $e['last_day'], 0, 2 )
			                                   )
			                        ) . '</pubDate>';
			$feed[] = '<description>' . $this->escape( $e['explain'] ) . '</description>';
			$feed[] = '</item>';
			
			// アイテム数制限
			if( --$c == 0 )
				break;
		}
		
		$feed[] = '</channel>';
		$feed[] = '</rss>';
		
		return $feed;
	}

	function generateRDF( &$entries )
	{
		return array();
	}
	
	function fetch( &$entries, $dir )
	{
		// フォルダが存在するかチェック
		if( !file_exists( $dir ) )
			return FALSE;
	
		// データの取得
		$lines = file( $dir . 'allpage.cgi' );

		// パース
		// - ファイル
		$files = preg_grep( '/^file<>/', $lines );
		foreach( $files as $f )
		{
			list($type,$id,$title,$not_titleb,$not_menu,$caption,$explain,$make_day,$last_day,$non_disp) = explode( '<>', $f );
			
			// non_disp であれば飛ばす
			if( $non_disp )
				continue;
			
			// last_day が無ければ make_day を利用
			if( $last_day == '' )
				$last_day = $make_day;
			
			// explain が無ければ caption を利用
			if( $explain == '' )
				$explain = $caption;
			
			// エントリ一覧に追加
			$key = $last_day;
			// - 同一のキーを回避		
			while( isset( $entries[ $key ] ) )
				$key .= '.';
			// - 追加
			$entries[ $key ] = array
			(	'id'	=> $id
			,	'title'	=> $title
			,	'caption'	=> $caption
			,	'explain'	=> $explain
			,	'last_day'	=> $last_day
			,	'path'	=> substr( $dir, strlen( $this->initialDir) ) .  $id . '.html'
			);
		}

		// - ディレクトリ
		$dirs = preg_grep( '/^dir<>/', $lines );
		foreach( $dirs as $d )
		{
			list($type,$id,$title,$not_titleb,$not_menu,$caption,$explain,$make_day,$last_day,$non_disp) = explode( '<>', $d );
			
			// non_disp であれば飛ばす
			if( $non_disp )
				continue;
			
			// last_day が無ければ make_day を利用
			if( $last_day == '' )
				$last_day = $make_day;

			// explain が無ければ caption を利用
			if( $explain == '' )
				$explain = $caption;
			
			// エントリ一覧に追加
			$key = $last_day;
			// - 同一のキーを回避		
			while( isset( $entries[ $key ] ) )
				$key .= '.';
			// - 追加
			$entries[ $key ] = array
			(	'id'	=> $id
			,	'title'	=> $title
			,	'caption'	=> $caption
			,	'explain'	=> $explain
			,	'last_day'	=> $last_day
			,	'path'	=> substr( $dir, strlen( $this->initialDir ) ) . $id . '/'
			);

			if( $this->fetch( $entries, $this->initialDir . substr( $dir, strlen( $this->initialDir ) ) . $id . '/' ) === FALSE )
				return FALSE;
		}
		
		// - 掲示板
		// not implemented.

		// 新しい順にソート
		krsort( $entries );

		return TRUE;
	}
	
	function escape( &$str )
	{
		return mb_convert_encoding( htmlspecialchars( $str ) );
	}
}
