#include	"dmonitor.h"
#include	"dstar.h"
#include	"dvap.h"

void	rig_close(void);
void	inet_send_buff_set(void);
void	inet_send_position_update (char call[]);
void	send_rig_init (void);
int	icom_open (void);
void	sind_rig_alive (void);
void	icom_reinit (void);
void    rig_write (int length, unsigned char buff[]);
void    rig_led_onoff(void);
void	inet_led_onoff(void);
int	getFifo (char str[]);
void	jitter_buff_init (void);
int	dvap_open (void);
void	dvap_init(void);
void	dvap (void);
int	rig_read (void);
void    dvap_write (int fd, unsigned char buff[], int length);

char	init_pkt[] = {0xff, 0xff, 0xff};
char	alive[] = {0x02, 0x02, 0xff};
int	gw_on;
unsigned	char	rig_buff[1024];

time_t  rig_alive_send_time;
int	rig_error_cnt;

int	rig_init_recv (void)
{
	int length;
	int	i;
	int	k;

	if (FD_ISSET (rig_fd, &read_set))
	{
		length = read (rig_fd, &rig_buff[rig_buff_pnt], 
			1024 - rig_buff_pnt);
		if (length == -1)
		{
			syslog(LOG_ERR, "rig read error %s", strerror(errno));
		} 
		if (length > 0)
		{
			rig_buff_pnt += length;
		}
		if (rig_buff_pnt >= 3)
		{
			for (i = 0 ; i < rig_buff_pnt - 2 ; i++)
			{
				if ((rig_buff[i] == 0xff)
					&& (rig_buff[i+1] == 0xff)
					&& (rig_buff[i+2] == 0xff))
				{
					k = rig_buff_pnt - i - 3;
					if (k > 0) 
					{
						memmove (&rig_buff[0], &rig_buff[i+3], k);
						rig_buff_pnt = k;
					}
					else
						rig_buff_pnt = 0;
					time (&rig_alive_recv);
					return TRUE;
				}
			}
                	memmove (&rig_buff[0], &rig_buff[rig_buff_pnt - 2], 2);
                	rig_buff_pnt  = 2;
			
		}
		if (length < 0)
		{
			if (errno == EAGAIN) return TRUE;
		}
	}
	return FALSE;
}
	
enum
{
	RIG_CHECK = 0,
	ICOM_OPEN,
	ICOM_INIT,
	ICOM_INIT_DONE,
	DVAP_OPEN,
	DVAP_INIT,
	DVAP_INIT_DONE,
	RIG_READ
} rig_state = RIG_CHECK;


void	rig(void)
{
	time_t	cur_time;
	char	dummy[42];
	int	length;
	int	n;
	struct	stat	st;

	switch (rig_state)
	{
		case RIG_CHECK:
			if (rig_type == ICOM)
			{
				rig_state = ICOM_OPEN;
			}
			else if (rig_type == DVAP)
			{
				rig_state = DVAP_OPEN;
			}
			else
				sig_term = TRUE;
			break;

		case ICOM_OPEN:
			if (!icom_open()) sig_term = TRUE;
			else	rig_state = ICOM_INIT;
			break;

		case ICOM_INIT:
			memset (inet_frame_id, 0xff, 2);
			send_rig_init();
			rig_state = ICOM_INIT_DONE;
			time (&rig_init_time);
			rig_alive_send_time = 0;
			rig_send_sw = FALSE;
			while (getFifo(dummy)) ;
			jitter_buff_init();
			break;
	
		case ICOM_INIT_DONE:
			if (rig_init_recv())
			{
				rig_state = RIG_READ;
				syslog (LOG_INFO, "RIG(ID-xxPlus) init/re-init done");
				memset (inet_frame_id, 0x00, 2);
				rig_send_sw = FALSE;
				rig_buff_pnt = 0;
        			rig_last_frame_send = TRUE;
				gettimeofday (&inet_recv_time, NULL);
				Fifo_cnt = 0;
			}
			else
			{
				time (&cur_time);
				if ((cur_time - rig_init_time) >= 2)
				{
        				if(!scan_sw) syslog (LOG_INFO, "RIG(ID-xxPlus) no resp.");
        				else fprintf (status_fd, "RIG(ID-xxPlus) no resp.\n");
					rig_close();
					sig_term = TRUE;
				}
			}
			break;

		case DVAP_OPEN:
			if (!dvap_open()) sig_term = TRUE;
			rig_state = DVAP_INIT;
			rig_error_cnt = 0;
			rig_buff_pnt = 0;
			break;

		case DVAP_INIT:
			dvap_init();
			dvap_check_wait = FALSE;
			rig_state = DVAP_INIT_DONE;
                        length = 1;
                        while (length) length = getFifo(dummy);
                        jitter_buff_init();
			break;
		
		case DVAP_INIT_DONE:
	                if (dvap_check_wait)
			{
				rig_state = RIG_READ;
			}
			else
			{
				time(&cur_time);
				if ((cur_time - rig_init_time) >= 2)
				{
					rig_state = DVAP_INIT;
					rig_error_cnt++;
				}
				if (rig_error_cnt > 5)
				{
					//sig_term = TRUE;
					rig_state = RIG_READ;
					rig_type = DVAP;
				}
			}
			break;

		case RIG_READ:
			if (rig_type == ICOM)
			{
				if (!rig_read())
				{
					if (rig_type == ICOM)  rig_state = ICOM_OPEN;
					else if (rig_type == DVAP) rig_state = DVAP_OPEN;
				}
				time (&cur_time);
               		 	if ((cur_time - rig_alive_send_time) >= 1)
                		{
					rig_write (3, alive);
                       			rig_alive_send_time = cur_time;
					digitalWrite (RIG_LED, 0);
               			}
                		if ((cur_time - rig_alive_recv) >= 3)
                		{
                        		icom_reinit();
                		}
			}
			else
				dvap();
			break;
	}
}

void	icom_reinit(void)
{
	if (error_msg_sw)
	{
		error_msg_sw = TRUE;
		if (!scan_sw) syslog (LOG_INFO, "rig not terminal/access mode");
		else fprintf (status_fd, "rig not terminal/access mode\n");
	}	
	rig_state = ICOM_INIT;
	rig_buff_pnt = 0;
	digitalWrite (RIG_LED, 0);
	digitalWrite (INET_LED, 0);
}

int	rig_read (void)
{
	int	length;
	int	len;
	int	k;
	int	ret;
	struct	timeval	cu_time;
	struct	timeval	t_time;
	struct	timeval	ack_timeout;

	if (FD_ISSET (rig_fd, &read_set))
	{
		length = read (rig_fd, &rig_buff[rig_buff_pnt], 
				1024 - rig_buff_pnt);
		if (length < 0)
		{
			syslog (LOG_ERR, "Rig read error %s", strerror(errno));
			if (errno == EAGAIN) return TRUE;
			rig_close();
			return FALSE;
		}
		//time (&rig_alive_send_time);
		rig_buff_pnt += length;
		time (&rig_alive_recv);
		#ifdef	_DEBUG_RIG
		syslog (LOG_INFO, "read length:%d (%d) %2.2x", length, rig_buff_pnt, rig_buff[0]);
		#endif
	}
	while (rig_buff_pnt)
	{
		if (rig_buff[0] != 0xff)
		{
			len = rig_buff[0];
			if (len > rig_buff_pnt) break;

			if (len == 3)
			{
				if (rig_buff[1] == 0x21)
				{
					#ifdef  _DEBUG_RIG
					syslog (LOG_INFO, "ack header:%2.2x seq:%2.2x", rig_buff[1], rig_buff[2]);
					#endif
				}
				else if (rig_buff[1] = 0x03)
				{
					#ifdef	_DEBUG_RIG
					syslog (LOG_INFO, "ack keep alive:%2.2x seq:%2.2x", rig_buff[1], rig_buff[2]);
					#endif
					ptt = rig_buff[2];
				}
				
				k = rig_buff_pnt - len;
				if (k > 0) memmove(&rig_buff[0], &rig_buff[len], k);
				rig_buff_pnt = k;
				break;
			}
			else if (len == 4)
			{
				if (rig_buff[1] == 0x23)
				{
					#ifdef _DEBUG_RIG
					syslog (LOG_INFO, "ack voice:%2.2x seq:%2.2x(%2.2x) %2.2x",
						rig_buff[1], rig_buff[2], seq & 0xff, rig_buff[3]);
					#endif
					if (rig_buff[2] == seq)
					{
						//if (rig_buff[3] == 0x00)
						//{
						//	seq++;
						//	seq &= 0xff;
						//}
                                		k = rig_buff_pnt - len;
                                		if (k > 0) memmove(&rig_buff[0], &rig_buff[len], k);
                                		rig_buff_pnt = k;
                                		break;
					}
					else
					{
						//seq = rig_buff[2] + 1;
						//seq &= 0xff;
					}
					#ifdef	_DEBUG_RIG
					syslog(LOG_INFO, "ack seq error %2.2x %2.2x %2.2x", rig_buff[2], seq, rig_buff[3]);
					#endif
				}
			}
			else if (len == 44)	/* header */
			{
				if (!scan_sw) syslog (LOG_NOTICE, "%8.8s from Rig", &rig_buff[29]);
				else 
				{
					fprintf (status_fd, "%8.8s from Rig\n", &rig_buff[29]);
				}
				gw_on = FALSE;
				inet_send_buff_set();
				inet_send_buff[16] = 0x80;
				memcpy (&inet_send_buff[17], &rig_buff[2], 41);
				memcpy (&inet_send_buff[20], area_call, 8); 
				memcpy (&inet_send_buff[28], area_call, 8);
				if (memcmp (&inet_send_buff[36], "CQCQCQ  ", 8)) gw_on = TRUE;
				if (send_sw && !rig_send_sw) 
				{
					memset (inet_frame_id, 0xff, 2);
					in_addr.sin_port = htons(dest_inet_port);
					in_addr.sin_addr.s_addr = inet_addr(dest_address);
					m_seq++;
					m_seq &= 0xffff;
        				inet_send_buff[4] = (m_seq >> 8) & 0xff;
        				inet_send_buff[5] = m_seq & 0xff;
					inet_send_buff[7] |= FWD | ZR;
					ret = sendto (in_addr_sock, inet_send_buff, 58, MSG_DONTWAIT,
						(struct sockaddr *)&in_addr, sizeof(in_addr));
					m_seq++;
					m_seq &= 0xffff;
					inet_send_buff[4] = (m_seq >> 8) & 0xff;
					inet_send_buff[5] = m_seq & 0xff;
					//memcpy (&inet_send_buff[28], area_call, 8);
					//memcpy (&inet_send_buff[20], area_call, 8);
					sendto (in_addr_sock, inet_send_buff, 58, MSG_DONTWAIT,
						(struct sockaddr *)&in_addr, sizeof(in_addr));
					if (gw_on)
					{
						memcpy (&inet_send_buff[20], zone_call, 8);
						inet_send_buff[27] = 'G';
						inet_send_buff[7]  &= 0x33;
						inet_send_buff[7] |= GW;
						m_seq++;
						m_seq &= 0xffff;
						inet_send_buff[4] = (m_seq >> 8) & 0xff;
						inet_send_buff[5] = m_seq & 0xff;
						sendto (in_addr_sock, inet_send_buff, 58, MSG_DONTWAIT,
							(struct sockaddr *)&in_addr, sizeof(in_addr));
						m_seq++;
						m_seq &= 0xffff;
						inet_send_buff[4] = (m_seq >> 8) & 0xff;
						inet_send_buff[5] = m_seq & 0xff;
						sendto (in_addr_sock, inet_send_buff, 58, MSG_DONTWAIT,
							(struct sockaddr *)&in_addr, sizeof(in_addr));
						if ((m_seq % 5) == 0) inet_led_onoff();
					}
				}
				m_seq++;
				m_seq &= 0xffff;
			}
			else if (len == 16)	/* voice */
			{
				inet_send_buff[9] = 0x13;
				inet_send_buff[4] = (m_seq >> 8) & 0xff;
				inet_send_buff[5] = m_seq & 0xff;
				inet_send_buff[7] &= 0x33;
				inet_send_buff[7] |= FWD | ZR;
				if (gw_on) 
				{
					inet_send_buff[7] |= GW;
					if ((m_seq % 5) == 0) inet_led_onoff();
				}
				if (rig_buff[3] & 0x40) memset (&rig_buff[13], 0x55, 3);
				memcpy (&inet_send_buff[16], &rig_buff[3], 13);
				if (send_sw)
				{
                                        in_addr.sin_port = htons(dest_inet_port);
                                        in_addr.sin_addr.s_addr = inet_addr(dest_address);
					sendto (in_addr_sock, inet_send_buff, 29, MSG_DONTWAIT,
						(struct sockaddr *)&in_addr, sizeof(in_addr));
				}
				if (rig_buff[3] & 0x40) 
				{
					memset (inet_frame_id, 0x00, 2);
					digitalWrite (RIG_LED, 0);
					digitalWrite (INET_LED, 0);
				}
				m_seq++;
				m_seq &= 0xffff;
			}
			#ifdef	_DEBUG_RIG
			else 
			{
				syslog (LOG_INFO, "ack length:%d", len);
			}
			#endif

			if (rig_buff[3] == 0x14) rig_led_onoff();
			if ((m_seq % 5) == 0) inet_led_onoff();
		}
		else
			len = 1;
		k = rig_buff_pnt - len;
		if (k > 0) memmove (&rig_buff[0], &rig_buff[len], k);
		rig_buff_pnt = k;
	}
	error_msg_sw = FALSE;

#if 0
	if ((Fifo_cnt > fifo_hold_limit) || (Fifo_cnt < 0))
	{
		syslog (LOG_INFO, "rig fifo overflow (%d)", Fifo_cnt);
		memset (inet_frame_id, 0xff, 2);
		rig_state = RIG_INIT;
		drop_rate_print();
	}
#endif
	return TRUE;
}

void	rig_write (int length, unsigned char buff[])
{
	int ret;
	unsigned char	temp[8];

	if (length == 17)
	{
		seq++;
		seq &= 0xff;
		recv_frame_seq = buff[3];
	}

	if ((length == 42) && (buff[12] =='G'))
	{
		memcpy (temp, &buff[5], 8);
		memcpy (&buff[5], &buff[13], 8);
		memcpy (&buff[13], temp, 8);
	}
	if (rig_type == ICOM)
	{
		if (length == 42) syslog (LOG_DEBUG, "rpt2:%8.8s rpt1:%8.8s ur:%8.8s my:%8.8s my2:%4.4s", &buff[5], &buff[13],&buff[21], &buff[29 ], &buff[36]);
		ret = write (rig_fd, buff, length);
		if (ret == -1) syslog(LOG_ERR, "rig write error %s", strerror(errno));
		time (&rig_alive_send_time);
	}
	else
	{
		dvap_write (rig_fd, buff, length);
	}
		
	#ifdef	_DEBUG_RIG
	syslog (LOG_INFO, "rig_write %d %d %2.2x %2.2x", length, ret, buff[2], buff[3]);
	#endif
	#ifdef	_DEBUG_RIG_WRITE_PACKET
	if (length == 17)
	{
		syslog (LOG_DEBUG, 
			"%2.2x %2.2x %2.2x  %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %d %d",
			buff[0], buff[1], buff[2], buff[3], buff[4], buff[5], buff[6], buff[7], buff[8], buff[9], buff[10], 
			buff[11], buff[12], buff[13], buff[14], buff[15], buff[16], fifo_hold_limit, Fifo_cnt);
	}
	#endif
}

void	send_rig_init (void)
{
	int	len;

	rig_write (3, init_pkt);
	time (&rig_init_time);
}

void	rig_led_onoff(void)
{
	if (rig_led_sw) rig_led_sw = 0;
	else		rig_led_sw = 1;
	digitalWrite (RIG_LED, rig_led_sw);
}
