#include	"dmonitor.h"
#include	"dstar.h"
#include	"dvap.h"


void	dvap_conf (void)
{
	char	buff[256];
	char	*delmi = "=\n\r\t\0";
	char	*pnt;
	char	*p;
	int	n;
	int	field_sw;
	int	port;

	FILE	*config_file;

	config_file = fopen (DVAP_CONF, "r");
	if (!config_file)
	{
		syslog (LOG_ERR, "dvap config file not found (%s)\n", 
					DVAP_CONF);
		return;
	}

	while (fgets (buff, 255, config_file))
	{
		if (buff[0] != '#')
		{
			n = 0;
			while (buff[n] == 0x20) n++;
			p = strtok(&buff[n], delmi);
			if (p != NULL)
			{
				pnt = strtok(NULL, delmi);
	
				if (!memcmp (p, "DVAP_TX_FREQUENCY",  17))
				{
					dvap_tx_freq = atoi(pnt);
				}
				else if (!memcmp (p, "DVAP_RX_FREQUENCY",  17))
				{
					dvap_rx_freq = atoi (pnt);
				}
				else if (!memcmp (p, "DVAP_FREQUENCY", 14))
				{
					dvap_freq = atoi (pnt);
				}
				else if (!memcmp (p, "DVAP_SQUELCH", 12))
				{
					dvap_squelch = atoi (pnt);
					if ((dvap_squelch > -45) || (dvap_squelch < -128)) dvap_squelch = 0;
				}
				else if (!memcmp (p, "DVAP_CALIBRATION",  16))
				{
					dvap_calibration = atoi (pnt);
					if ((dvap_calibration < -2000) || (dvap_calibration > 2000)) dvap_calibration = 0;
				}
                                else if (!memcmp (p, "DVAP_AUTO_CALIBRATION", 21))
                                {
                                        dvap_auto_calibration = atoi (pnt);
                                }
				else
				{
					syslog (LOG_ERR, "Error on dvap config file : %s", buff);
				}
			}
		}
	}

	fclose (config_file);

	return;
}

	
