#include	"extern_rpt_conn.h"
#include	"extern_dvap.h"

void	dvap_header_send (char header[]);
void	dvap_skip(void);
void	dvap_send_wait_set(void);
void	send_dvap_keep_alive(void);
int	inet_send_buff_set(void);
void	inet_led_onoff(void);
void	dstar_data(unsigned char string[], int inet);
void	short_msg_wrt (void);

//struct	termios	save_attr;
//char	dvap_buff[1024];
extern char	dvap_header[47];
extern char	dvap_check_status;
extern int	dvap_loop_cnt;
extern int	band_scan_sw;
extern char	rssi[201];
extern	char RunState[];

unsigned char   band_scan[11] = {0x0b, 0x20, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
char    lastframe[6] ={0x55, 0x55, 0x55, 0x55, 0xc8, 0x7a};
char	resync[3] = {0x55, 0x2d, 0x16};
char    error_check[4] = {0x04, 0x20, 0x05, 0x00};

enum
{
        DVAP_IDLE = 0,
	DVAP_ERROR_CHECK,
	DVAP_ERROR_CHECK_WAIT,
        DVAP_MODULATION,
	DVAP_MODULATION_CHECK,
	DVAP_MODULATION_WAIT,
        DVAP_FREQUENCY,
	DVAP_FREQUENCY_CHECK,
	DVAP_FREQUENCY_WAIT,
        DVAP_TX_FREQUENCY,
	DVAP_TX_FREQUENCY_CHECK,
	DVAP_TX_FREQUENCY_WAIT,
        DVAP_RX_FREQUENCY,
	DVAP_RX_FREQUENCY_CHECK,
	DVAP_RX_FREQUENCY_WAIT,
        DVAP_SQUELCH,
	DVAP_SQUELCH_CHECK,
	DVAP_SQUELCH_WAIT,
        DVAP_CALIBRATION,
	DVAP_CALIBRATION_CHECK,
	DVAP_CALIBRATION_WAIT,
	DVAP_RUN,
	DVAP_CALIBRATION_CLEAR,
	DVAP_CALIBRATION_CLEAR_CHECK,
	DVAP_CALIBRATION_CLEAR_WAIT,
	DVAP_BAND_SCAN,
	DVAP_BAND_SCAN_CHECK,
	DVAP_BAND_SCAN_WAIT
} dvap_state = DVAP_ERROR_CHECK;

void	dvap_reset(void)
{
	dvap_state = DVAP_ERROR_CHECK;
}

void	dvap(void)
{
	int	ret;
	int	offset_tmp;
	long	int	freq;
	int	k;
	int	step;
	ssize_t	len;

	char	modulation[5] = {0x05, 0x00, 0x28, 0x00, 0x01};
        //char    TargetName[4] = {0x04, 0x20, 0x01, 0x00};
	char	frequency[8] = {0x08, 0x00, 0x20, 0x02, 0x00, 0x00, 0x00, 0x00};
	signed char	squelch[5] = {0x05, 0x00, 0x80, 0x00, 0x00};
	char	calibration[6] = {0x06, 0x00, 0x00, 0x04, 0x00, 0x00};

	struct	timeval	timer_tmp1;
	struct	timeval timer_tmp2;
	time_t	cur_time;

        time (&cur_time);
        if ((cur_time - dvap_keep_alive) >= 2)
                send_dvap_keep_alive();
	switch (dvap_state)
	{
		case DVAP_IDLE:
			break;

		case DVAP_ERROR_CHECK:
			dvap_check_wait = FALSE;
			len = write (rig_fd, error_check, 4);
			if (len < 0) 
			{
				dvap_close();
				return;
			}
			dvap_loop_cnt = 0;
			dvap_state = DVAP_ERROR_CHECK_WAIT;
			break;

		case DVAP_ERROR_CHECK_WAIT:
			if (!dvap_check_wait) 
			{
				if (dvap_loop_cnt++ > 50)
				{
					dvap_state = DVAP_ERROR_CHECK;		
				}
				break;
			}
			if (dvap_check_status != 0x00)
				dvap_state = DVAP_ERROR_CHECK;
			else
				dvap_state = DVAP_MODULATION;
			break;

		case DVAP_MODULATION:
			len = write (rig_fd, modulation, 5);
			if (len < 0)
			{
				dvap_close ();
				return;
			}
			dvap_state = DVAP_MODULATION_CHECK;
			break;
		case DVAP_MODULATION_CHECK:
                        dvap_check_wait = FALSE;
                        len = write (rig_fd, error_check, 4);

                        if (len < 0)
                        {
                                dvap_close();
                                return;
                        }
                        dvap_loop_cnt = 0;
                        dvap_state = DVAP_MODULATION_WAIT;
                        break;

		case DVAP_MODULATION_WAIT:
                        if (!dvap_check_wait)
                        {
                                if (dvap_loop_cnt++ > 50)
                                {
                                        dvap_state = DVAP_MODULATION;
                                }
                                break;
                        }
                        if (dvap_check_status == 0x01)
                        {
                                dvap_state = DVAP_MODULATION_CHECK;
                        }
                        else if (dvap_check_status != 0x00)
                        {
                                dvap_state = DVAP_MODULATION;
                        }
                        else
			{
                                dvap_state = DVAP_FREQUENCY;
                        	time(&cur_time);
                        	syslog (LOG_INFO, "DVAP D-STAR Modulation set\n");
			}
                        break;

		case DVAP_FREQUENCY:
			if (dvap_freq)
			{
				frequency[3] = 0x02;
				frequency[4] = dvap_freq & 0xff;
				frequency[5] = (dvap_freq >> 8) & 0xff;
				frequency[6] = (dvap_freq >> 16) & 0xff;
				frequency[7] = (dvap_freq >> 24) & 0xff;
				len = write (rig_fd, frequency, 8);
				if (ret < 0)
				{
					time(&cur_time);
					syslog (LOG_ERR, "DVAP write (freuqncy) error %s\n",
						strerror(errno));
					dvap_close();
					return;
				}
				dvap_state = DVAP_FREQUENCY_CHECK;
			}
			else 
				dvap_state = DVAP_TX_FREQUENCY;
			break;
		case DVAP_FREQUENCY_CHECK:
                        dvap_check_wait = FALSE;
                        len = write (rig_fd, error_check, 4);

                        if (len < len)
                        {
                                dvap_close();
                                return;
                        }
                        dvap_loop_cnt = 0;
                        dvap_state = DVAP_FREQUENCY_WAIT;
                        break;

		case DVAP_FREQUENCY_WAIT:
                        if (!dvap_check_wait)
                        {
                                if (dvap_loop_cnt++ > 50)
                                {
                                        dvap_state = DVAP_FREQUENCY;
                                }
                                break;
                        }
                        if (dvap_check_status == 0x01)
                        {
                                dvap_state = DVAP_FREQUENCY_CHECK;
                        }
                        else if (dvap_check_status != 0x00)
                        {
                                dvap_state = DVAP_FREQUENCY;
                        }
                        else
			{
                                dvap_state = DVAP_TX_FREQUENCY;
                                time(&cur_time);
                                syslog (LOG_INFO,  "DVAP TX/RX Frequency Set %ld Hz",
                                        dvap_freq);
			}
                        break;

		case DVAP_TX_FREQUENCY:
			if (dvap_tx_freq)
			{
				frequency[3] = 0x01;
				frequency[4] = dvap_tx_freq & 0xff;
				frequency[5] = (dvap_tx_freq >> 8) & 0xff;
				frequency[6] = (dvap_tx_freq >> 16) & 0xff;
				frequency[7] = (dvap_tx_freq >> 24) & 0xff;
				len = write (rig_fd, frequency, 8);
				if (ret < 0)
				{
					dvap_close ();
					return;
				}
				dvap_state = DVAP_TX_FREQUENCY_CHECK;
			}
			else
				dvap_state = DVAP_RX_FREQUENCY;
			break;

		case DVAP_TX_FREQUENCY_CHECK:
                        dvap_check_wait = FALSE;
                        len = write (rig_fd, error_check, 4);
                        if (len < 0)
                        {
                                dvap_close();
                                return;
                        }
                        dvap_loop_cnt = 0;
                        dvap_state = DVAP_TX_FREQUENCY_WAIT;
                        break;
		case DVAP_TX_FREQUENCY_WAIT:
                        if (!dvap_check_wait)
                        {
                                if (dvap_loop_cnt++ > 50)
                                {
                                        dvap_state = DVAP_TX_FREQUENCY;
                                }
                                break;
                        }
                        if (dvap_check_status == 0x01)
                        {
                                dvap_state = DVAP_TX_FREQUENCY_CHECK;
                        }
                        else if (dvap_check_status != 0x00)
                        {
                                dvap_state = DVAP_TX_FREQUENCY;
                        }
                        else
			{
                                dvap_state = DVAP_RX_FREQUENCY;
                                syslog (LOG_INFO,  "DVAP TX Frequency Set %ld Hz",
                                         dvap_tx_freq);
			}
                        break;

		case DVAP_RX_FREQUENCY:
			if (dvap_rx_freq)
			{
				frequency[3] = 0x00;
				frequency[4] = dvap_rx_freq & 0xff;
				frequency[5] = (dvap_rx_freq >> 8) & 0xff;
				frequency[6] = (dvap_rx_freq >> 16) & 0xff;
				frequency[7] = (dvap_rx_freq >> 24) & 0xff;
				len = write (rig_fd, frequency, 8);
				if (ret < 0)
				{
					dvap_close ();
					return;
				}
				dvap_state = DVAP_RX_FREQUENCY_CHECK;
			}	
			else 
				dvap_state = DVAP_SQUELCH;
			break;

		case DVAP_RX_FREQUENCY_CHECK:
                        dvap_check_wait = FALSE;
                        len = write (rig_fd, error_check, 4);
                        if (len < 0)
                        {
                                dvap_close();
                                return;
                        }
                        dvap_loop_cnt = 0;
                        dvap_state = DVAP_RX_FREQUENCY_WAIT;
                        break;

		case DVAP_RX_FREQUENCY_WAIT:
                        if (!dvap_check_wait)
                        {
                                if (dvap_loop_cnt++ > 50)
                                {
                                        dvap_state = DVAP_RX_FREQUENCY;
                                }
                                break;
                        }
                        if (dvap_check_status == 0x01)
                        {
                                dvap_state = DVAP_RX_FREQUENCY_CHECK;
                        }
                        else if (dvap_check_status != 0x00)
                        {
                                dvap_state = DVAP_RX_FREQUENCY;
                        }
                        else
			{
                                dvap_state = DVAP_SQUELCH;
                                syslog (LOG_INFO, "DVAP RX Frequency Set %ld Hz",
                                        dvap_rx_freq);
			}
                        break;

		case DVAP_SQUELCH:
			if (dvap_squelch)
			{
				squelch[4] = dvap_squelch;
				len = write (rig_fd, squelch, 5);
				dvap_state = DVAP_SQUELCH_CHECK;
			}
			else 
				dvap_state = DVAP_CALIBRATION;
			break;

		case DVAP_SQUELCH_CHECK:
                        dvap_check_wait = FALSE;
                        len = write (rig_fd, error_check, 4);
                        if (len < 0)
                        {
                                dvap_close();
                                return;
                        }
                        dvap_loop_cnt = 0;
                        dvap_state = DVAP_SQUELCH_WAIT;
                        break;

		case DVAP_SQUELCH_WAIT:
                        if (!dvap_check_wait)
                        {
                                if (dvap_loop_cnt++ > 50)
                                {
                                        dvap_state = DVAP_SQUELCH;
                                }
                                break;
                        }
                        if (dvap_check_status == 0x01)
                        {
                                dvap_state = DVAP_SQUELCH_CHECK;
                        }
                        else if (dvap_check_status != 0x00)
                        {
                                dvap_state = DVAP_SQUELCH;
                        }
                        else
			{
                                dvap_state = DVAP_CALIBRATION;
                                syslog (LOG_INFO, "DVAP Squelch Set %d",
                                dvap_squelch);
			}
                        break;

		case DVAP_CALIBRATION:
			if (!dvap_auto_calibration || dvap_auto_calibration_set)
			{
				calibration[4] = dvap_calibration & 0xff;
				calibration[5] = (dvap_calibration >> 8) & 0xff;
				len = write (rig_fd, calibration, 6);
				dvap_check_wait = FALSE;
				dvap_state = DVAP_CALIBRATION_CHECK;
			}
			else
				dvap_state = DVAP_RUN;
			dvap_auto_calibration_set = FALSE;
			break;

		case DVAP_CALIBRATION_CHECK:
			len = write (rig_fd, error_check, 4);
			dvap_loop_cnt = 0;
			dvap_state = DVAP_CALIBRATION_WAIT;
			break;

		case DVAP_CALIBRATION_WAIT:
			if (!dvap_check_wait)
			{
				if (dvap_loop_cnt++ > 50)
				{
					dvap_state = DVAP_CALIBRATION;
				}
				break;
			}
			if (dvap_check_status == 0x01)
			{
				dvap_state = DVAP_CALIBRATION_CHECK;
			}
			else if (dvap_check_status != 0x00)
			{
				dvap_state = DVAP_CALIBRATION;
			}
			else
			{
				dvap_state = DVAP_RUN;
                                syslog (LOG_INFO, "DVAP Calibration Set %d Hz",
                                        dvap_calibration);
			}
			break;

		case DVAP_RUN:
			RunState[4] = 0x01;
			len = write (rig_fd, RunState, 5);
			if (len < 0)
			{
				dvap_close ();
				return;
			}
			dvap_state = DVAP_IDLE;
			time (&dvap_keep_alive);
			break;

                case DVAP_CALIBRATION_CLEAR:
                        RunState[4] = 0x00;
                        len = write (rig_fd, RunState, 5);
                 	calibration[4] = 0x00;
                        calibration[5] = 0x00;
                        len = write (rig_fd, calibration, 6);
                        dvap_check_wait = FALSE;
                        dvap_state = DVAP_CALIBRATION_CLEAR_CHECK;
                        break;

                case DVAP_CALIBRATION_CLEAR_CHECK:
                        len = write (rig_fd, error_check, 4);
                        dvap_loop_cnt = 0;
                        dvap_state = DVAP_CALIBRATION_CLEAR_WAIT;
                        break;

                case DVAP_CALIBRATION_CLEAR_WAIT:
                        if (!dvap_check_wait)
                        {
                                if (dvap_loop_cnt++ > 50)
                                {
                                        dvap_state = DVAP_CALIBRATION_CLEAR;
                                }
                                break;
                        }
                        if (dvap_check_status == 0x01)
                        {
                                dvap_state = DVAP_CALIBRATION_CLEAR_CHECK;
                        }
                        else if (dvap_check_status != 0x00)
                        {
                                dvap_state = DVAP_CALIBRATION_CLEAR;
                        }
                        else
                                dvap_state = DVAP_BAND_SCAN;
                        break;

		case DVAP_BAND_SCAN:
                	freq = dvap_freq - 10000;
			step = 201;
                	band_scan[4] = step & 0xff;
                	band_scan[5] = (step >> 8) & 0xff;
                	band_scan[6] = 0x01;
                	band_scan[7] = freq & 0xff;
                	band_scan[8] = (freq >> 8) & 0xff;
                	band_scan[9] = (freq >> 16) & 0xff;
                	band_scan[10] = (freq >> 24) & 0xff;
                	band_scan_sw = FALSE;
                	len = write (rig_fd, band_scan, 11);
                	dvap_state = DVAP_BAND_SCAN_CHECK;
			break;

		case DVAP_BAND_SCAN_CHECK:
			if (band_scan_sw)
			{
				dvap_state = DVAP_BAND_SCAN_WAIT;
			}
			break;

		case DVAP_BAND_SCAN_WAIT:
			offset_tmp = 0;
			for (k = 0 ; k < 201 ; k++)
			{
				offset_tmp += rssi[k];
			}
			offset_tmp /= 2;
			freq = dvap_freq - 10000;
			time(&cur_time);
			for (k = 0 ; k < 201 ; k++)
			{
				offset_tmp -= rssi[k];
				if (offset_tmp == 0)
				{
					dvap_calibration = freq - dvap_freq;
					
					syslog (LOG_INFO, "DVAP Calibration offset %d Hz", 
						dvap_calibration);
					break;
				}
				else if (offset_tmp < 0)
				{
					dvap_calibration = freq - dvap_freq - 50;
					syslog (LOG_INFO, "DVAP Calibration offset %d Hz", 
						dvap_calibration);
					break;
				}
				else 
					freq += 100;
			}
			dvap_auto_calibration_set = TRUE;
			dvap_state = DVAP_ERROR_CHECK;
			break;
	}
}

int	dvap_status_check (void)
{
	if (dvap_state == DVAP_IDLE) return TRUE;
	return FALSE;
}

void	send_dvap_keep_alive(void)
{
	int	ret; 

	char keep_alive[3] = {0x03, 0x60, 0x00};

	ret = write (rig_fd, keep_alive, 3);
	if (ret < 0)
	{
		dvap_close();
		return;
	}
	time (&dvap_keep_alive);
	#ifdef	_DEBUG_DVAP_SEND
	syslog (LOG_DEBUG, "keep alive send");
	#endif
}

unsigned char    dvap_send_pkt[47];

void	dvap_write (int	fd, unsigned char buff[], int length)
{
	unsigned short int tmp;
	int	ret;

	if (length == 42)
	{
		time(&dvap_keep_alive);
		dvap_send_pkt[0] = 0x2f;
       		dvap_send_pkt[1] = 0xa0;
       		tmp = rand() & 0xffff;
       		memcpy (&dvap_send_pkt[2], &tmp, 2);
       		dvap_send_pkt[4] = 0x80;
       		dvap_send_pkt[5] = 0x00;
       		memcpy (&dvap_send_pkt[6], &buff[2], 41);
		dvap_send_pkt[6] &= 0x07;
		ret = write (fd, dvap_send_pkt, 47);
		dvap_send_pkt[4] = 0x00;
		dvap_send_pkt[5]++;
		dvap_first_voice_pkt = TRUE;
		syslog (LOG_DEBUG, "to DVAP rpt2:%8.8s rpt1:%8.8s ur:%8.8s my:%8.8s my2:%4.4s", &buff[5], &buff[13],&buff[21], &buff[29], &buff[37]);
#if 0 
sysog (LOG_DEBUG, "%2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x",
	dvap_send_pkt[0],dvap_send_pkt[1],dvap_send_pkt[2],dvap_send_pkt[3], dvap_send_pkt[4],dvap_send_pkt[5],dvap_send_pkt[6], dvap_send_pkt[7],dvap_send_pkt[8],dvap_send_pkt[9], dvap_send_pkt[10],dvap_send_pkt[11],dvap_send_pkt[12], dvap_send_pkt[13],dvap_send_pkt[14],dvap_send_pkt[15]);
syslog (LOG_DEBUG, "%2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x",
        dvap_send_pkt[16],dvap_send_pkt[17],dvap_send_pkt[18],dvap_send_pkt[19], dvap_send_pkt[20],dvap_send_pkt[21],dvap_send_pkt[22], dvap_send_pkt[23],dvap_send_pkt[24],dvap_send_pkt[25], dvap_send_pkt[26],dvap_send_pkt[27],dvap_send_pkt[28], dvap_send_pkt[29],dvap_send_pkt[30],dvap_send_pkt[31]);
syslog (LOG_DEBUG, "%2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x",
        dvap_send_pkt[32],dvap_send_pkt[33],dvap_send_pkt[34],dvap_send_pkt[35], dvap_send_pkt[36],dvap_send_pkt[37],dvap_send_pkt[38], dvap_send_pkt[39],dvap_send_pkt[40],dvap_send_pkt[41], dvap_send_pkt[42],dvap_send_pkt[43],dvap_send_pkt[44], dvap_send_pkt[45],dvap_send_pkt[46],dvap_send_pkt[47]);
#endif
	}
	else if (length == 17)
	{
		if (!dvap_first_voice_pkt || !memcmp (&buff[13], resync , 3))
		{ 
        		time(&dvap_keep_alive);
        		dvap_send_pkt[0] = 0x12;
        		dvap_send_pkt[1] = 0xc0;
        		memcpy (&dvap_send_pkt[6], &buff[4], 12);
			if ((dvap_send_pkt[4] & 0x40) || 
				(!memcmp (&dvap_send_pkt[6], &lastframe[3], 3) && !memcmp (&dvap_send_pkt[15], lastframe, 3)))
			{
				dvap_send_pkt[4] |= 0x40;
			}
        		ret = write (fd, dvap_send_pkt, 18);
        		dvap_send_pkt[5]++;
        		dvap_send_pkt[4]++;
        		if (dvap_send_pkt[4] == 21) dvap_send_pkt[4] = 0;
			dvap_first_voice_pkt = FALSE;
#if 0
syslog (LOG_DEBUG, "%2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x",
        dvap_send_pkt[0], dvap_send_pkt[1], dvap_send_pkt[2], dvap_send_pkt[3], dvap_send_pkt[4], dvap_send_pkt[5], dvap_send_pkt[6], dvap_send_pkt[7], dvap_send_pkt[8], dvap_send_pkt[9], dvap_send_pkt[10], dvap_send_pkt[11], dvap_send_pkt[12], dvap_send_pkt[13], dvap_send_pkt[14], dvap_send_pkt[15], dvap_send_pkt[16], dvap_send_pkt[17]);
#endif
		}
	}
	else
	{
		syslog (LOG_DEBUG, "dvap busy write length:%d", length);
	}
}
