#include	"extern_dmonitor.h"
#include	"extern_dvap.h"


void	dvmega_conf (void)
{
	char	buff[256];
	char	*delmi = "=\n\r\t\0";
	char	*pnt;
	char	*p;
	int	n;
	int	field_sw;
	int	port;

	FILE	*config_file;

	config_file = fopen (DVMEGA_CONF, "r");
	if (!config_file)
	{
		syslog (LOG_ERR, "dvmega config file not found (%s)\n", 
					DVMEGA_CONF);
		return;
	}

	dvmega_rxOffset = 0;
	dvmega_txOffset = 0;

	while (fgets (buff, 255, config_file))
	{
		if (buff[0] != '#')
		{
			n = 0;
			while (buff[n] == 0x20) n++;
			p = strtok(&buff[n], delmi);
			if (p != NULL)
			{
				pnt = strtok(NULL, delmi);
	
				if (!memcmp (p, "DVMEGA_TX_FREQUENCY",  19))
				{
					dvmega_txFrequency = atoi(pnt);
				}
				else if (!memcmp (p, "DVMEGA_RX_FREQUENCY", 19))
				{
					dvmega_rxFrequency = atoi (pnt);
				}
				else if (!memcmp (p, "DVMEGA_FREQUENCY", 16))
				{
					dvmega_Frequency = atoi (pnt);
					dvmega_rxFrequency = dvmega_txFrequency = dvmega_Frequency;
				}
				else if (!memcmp (p, "DVMEGA_RX_LEVEL", 15))
				{
					dvmega_rxLevel = atof(pnt);
					//if ((dvmega_rxLevel > -45) || (dvmega_rxLevel < -128)) dvmega_rxLevel = 0;
				}
				else if (!memcmp (p, "DVMEGA_TX_LEVEL", 15))
				{
					dvmega_txLevel = atof(pnt);
				}
				else if (!memcmp (p, "DVMEGA_TX_DELAY", 15))
				{
					dvmega_tx_delay = atoi (pnt);
				}
				else if (!memcmp (p, "DVMEGA_DEVICE", 13))
				{
					memset (rig_device, 0x00, sizeof(rig_device));
					memcpy (rig_device, pnt, strlen(p));
				}
				else if (!memcmp (p, "DVMEGA_TX_OFFSET", 16))
				{
					dvmega_txOffset = atoi (pnt);
				}
				else if (!memcmp (p, "DVMEGA_RX_OFFSET", 16))
				{
					dvmega_rxOffset = atoi (pnt);
				}
				else
				{
					syslog (LOG_ERR, "Error on dvmega config file : %s", buff);
				}
			}
		}
	}
	fclose (config_file);
}

	
