#include	"extern_dmonitor.h"
#include	"extern_dvmega.h"

int	dvmega_setMode(unsigned char mode);
void	dvmega_close (void);
int     dvmega_setFrequency(void);
int	send_dvmega_status(void);
int	dvmega_setConfig (void);

extern struct	termios	save_attr;
char	dvmega_check_status;

extern	char	error_check[];


enum
{
        DVMEGA_IDLE = 0,
        DVMEGA_MODULATION,
	DVMEGA_MODULATION_WAIT,
        DVMEGA_FREQUENCY,
	DVMEGA_FREQUENCY_WAIT,
        DVMEGA_CONFIG,
	DVMEGA_CONFIG_WAIT,
	DVMEGA_RUN,
} dvmega_state = DVMEGA_MODULATION;


void    dvmega_last_frame_send (void)
{
        if (!dvmega_voice_send_sw) return;
        dvmega_last_frame_sw = FALSE;
}

void	dvmega(void)
{
	int	ret;
	int	offset_tmp;
	int	k;
	int	step;
	ssize_t	len;

	struct	timeval	timer_tmp1;
	struct	timeval timer_tmp2;
	time_t	cur_time;

	switch (dvmega_state)
	{
		case DVMEGA_IDLE:
			if (dvmega_last_frame_sw)
			{
				gettimeofday (&timer_tmp2, NULL);
				timersub (&timer_tmp2, &dvmega_InTime, &timer_tmp1);
				timer_tmp2.tv_sec = 0;
				timer_tmp2.tv_usec = 500000;
				if (timercmp (&timer_tmp1, &timer_tmp2, >)) 
				{
					dvmega_last_frame_send();
				}	
			}
			break;

		case DVMEGA_MODULATION:
			if (dvmega_setMode(MODE_DSTAR) != 4)
			{
				dvmega_close ();
				return;
			}
			dvmega_state = DVMEGA_MODULATION_WAIT;
			dvmega_check_wait = FALSE;
			dvmega_loop_cnt = 0;
			break;

		case DVMEGA_MODULATION_WAIT:
                        if (dvmega_check_wait)
			{
                                dvmega_state = DVMEGA_FREQUENCY;
                        	syslog (LOG_INFO, "DVMEGA D-STAR Modulation set\n");
			}
			else
			{
				if (dvmega_loop_cnt++ > 50)
				{
					dvmega_state = DVMEGA_MODULATION;
				}
			}
                        break;

		case DVMEGA_FREQUENCY:
			if (dvmega_setFrequency() == 12)
			{
				dvmega_state = DVMEGA_FREQUENCY_WAIT;
				dvmega_check_wait = FALSE;
				dvmega_loop_cnt = 0;
			}
			else
			{
				syslog (LOG_ERR, "DVMEGA write (freuqncy) error %s\n",
					strerror(errno));
					dvmega_close();
					return;
			}
			break;

		case DVMEGA_FREQUENCY_WAIT:
                        if (dvmega_check_wait)
			{
                        	dvmega_state = DVMEGA_CONFIG;
                                syslog (LOG_INFO,  "DVMEGA TX/RX Frequency Set %ld Hz",
                                        dvmega_Frequency);
			}
			else
			{
				if (dvmega_loop_cnt++ > 50)
				{
					dvmega_state = DVMEGA_FREQUENCY;
				}
			}
                        break;

		case DVMEGA_CONFIG:
			if (dvmega_setConfig() != 24)
			{
				dvmega_close();
				return;
			}
			dvmega_state = DVMEGA_CONFIG_WAIT;
			dvmega_check_wait = FALSE;
			dvmega_loop_cnt = 0;
			break;

		case DVMEGA_CONFIG_WAIT:
                        if (dvmega_check_wait)
                        {
				dvmega_state = DVMEGA_RUN;
				syslog (LOG_INFO, "DVMEGA config Set ");
			}
			else
			{
                                if (dvmega_loop_cnt++ > 50)
                                {
                                        dvmega_state = DVMEGA_CONFIG;
                                }
                        }
                        break;

		case DVMEGA_RUN:
			dvmega_state = DVMEGA_IDLE;
			break;
	}
        gettimeofday (&timer_tmp2, NULL);
        timersub (&timer_tmp2, &dvmega_status_send, &timer_tmp1);
        timer_tmp2.tv_sec = 0;
        timer_tmp2.tv_usec = 250000;
        if (timercmp (&timer_tmp1, &timer_tmp2, >))
        {
                send_dvmega_status();
        }
}

int     dvmega_status_check (void)
{
        if (dvmega_state == DVMEGA_IDLE) return TRUE;
        return FALSE;
}
