#include	"extern_dmonitor.h"
#include	"extern_dvap.h"

void	dvap_send_header(void);
void	dvap_send_voice(void);

struct  timeval dvap_in_time;
char    RunState[5] = {0x05, 0x00, 0x18, 0x00, 0x01};
//char    TargetName[4] = {0x04, 0x20, 0x01, 0x00};
//char    dvap_buff[1024];
char    dvap_header[47];
char    dvap_voice[18];
char    dvap_check_status;
int     dvap_loop_cnt;
int     band_scan_sw;
char    rssi[201];

void	dvap_init (void)
{
	ssize_t	len;

        RunState[4] = 0x00;
        len = write (rig_fd, RunState, 5);
	time(&rig_init_time);
	dvap_buff_pnt = 0;
	cpu_time = clock();
}

void	dvap_close (void)
{
	ssize_t	len;

	RunState[4] = 0x00;
	len = write (rig_fd, RunState, 5);
	tcsetattr (rig_fd, TCSANOW, &save_attr);
	dvap_NoRespReply_sw = FALSE;
	//dvap_skip();
	dvap_gw_resp_sw = FALSE;
	dvap_last_frame_sw = FALSE;
	dvap_voice_send_sw = FALSE;
	if (dvap_sw)
	{
		syslog (LOG_INFO, "DVAP down.");
	}
	dvap_sw = FALSE;
	FD_CLR (rig_fd, &fd_save);
	close (rig_fd);
	rig_fd = 0;
}

void	dvap_read(void)
{
	int	len;
	int	k;
	int	n;
	char    dvap_ack[3] = {0x03, 0x60, 0x00};
	struct	timeval	in_time;
	struct	timeval	tmp_time;
	struct	timeval	interval_time;
	ssize_t	wrt_len;
	clock_t	cpu_time;

	interval_time.tv_sec = 0;
	interval_time.tv_usec = 500000;
	gettimeofday (&in_time, NULL);
	timersub (&in_time, &dvap_in_time, &tmp_time);
	if (timercmp (&tmp_time, &interval_time, >)) dvap_buff_pnt = 0;
	dvap_in_time.tv_sec = in_time.tv_sec;
	dvap_in_time.tv_usec = in_time.tv_usec;

	len = read (rig_fd, &dvap_buff[dvap_buff_pnt], 
		sizeof(dvap_buff) - dvap_buff_pnt);
	if (len < 0)
	{
		time(&cur_time);
		syslog (LOG_ERR,  "DVAP read error %s", 
			strerror(errno));
		dvap_close();
		return;
	}
	dvap_buff_pnt += len;
	#ifdef  _DEBUG_DVAP
	if (len != 7) syslog (LOG_DEBUG, "dvap read length : %d %d", len, dvap_buff_pnt);
	#endif
if (len > 1024)
{
	syslog(LOG_DEBUG, "%2.2x %2.2x", dvap_buff[0], dvap_buff[1]);
}
	while (dvap_buff_pnt)
	{
	n = (dvap_buff[0] & 0xff) | ((dvap_buff[1] & 0x1f) << 8);
	#ifdef	_DEBUG_DVAP
	syslog (LOG_DEBUG, "%d %d", dvap_buff_pnt, n);
	#endif
	if (n > dvap_buff_pnt) return;

        if (n == 7)
        {
        	if ((dvap_buff[2] == 0x90)
                	&& (dvap_buff[3] == 0x00))
                {
                        dvap_squelch_status = dvap_buff[5];
                        #ifdef  _DEBUG_DVAP_SQUELCH
                        syslog (LOG_INFO, "squelch %d", dvap_squelch);
                        #endif
                }
	}
	/* header */
	else if (n == 47)
	{
		if ((dvap_buff[1] & 0xe0) == 0xa0)	/* header */
		{
			dvap_ack[2] = 0x01;
			wrt_len = write (rig_fd, dvap_ack, 3);
			gettimeofday (&dvap_InTime, NULL);
			memcpy (dvap_header, dvap_buff, 47);
			dvap_send_header();
		}	/* ack */
		#ifdef  _DEBUG_DVAP_SEND
		else if ((dvap_buff[1] & 0xe0) == 0x60)
		{
			syslog	(LOG_DEBUG, "header %2.2x", dvap_buff[1]);
		}
		#endif
	}
	/* voice */
	else if ((n == 18) && ((dvap_buff[1] & 0xe0) == 0xc0))
	{
                 #ifdef  _DEBUG_DVAP_SEND
                 syslog (LOG_DEBUG, "%2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x",
                 	dvap_buff[0], dvap_buff[1], dvap_buff[2], dvap_buff[3], dvap_buff[4], dvap_buff[5],
                        dvap_buff[6], dvap_buff[7], dvap_buff[8], dvap_buff[9], dvap_buff[10], dvap_buff[11],
                        dvap_buff[12], dvap_buff[13], dvap_buff[14], dvap_buff[15], dvap_buff[16], dvap_buff[17]);
                #endif
		dvap_ack[2] = 0x02;
		wrt_len = write (rig_fd, dvap_ack, 3);

		gettimeofday (&dvap_InTime, NULL);
		memcpy (dvap_voice, dvap_buff, 18);
		dvap_send_voice();
	}
	if ((dvap_buff[2] == 0x04) && (dvap_buff[3] == 0x04))
	{
		band_scan_sw = TRUE;
		memcpy (rssi, &dvap_buff[4], 201);
	}
	/* status / error code */
	if (n >= 5)
	{
		if ((dvap_buff[2] == 0x05) && (dvap_buff[3] == 0x00))
		{
//syslog (LOG_DEBUG, "%2.2x %2.2x %2.2x %2.2x %2.2x", dvap_buff[0], dvap_buff[1], dvap_buff[2], dvap_buff[3], dvap_buff[4]);
			if ((dvap_buff[1] & 0xe0) == 0x00)
			{
				if (n == 5)
				{
					dvap_check_wait = TRUE;
					dvap_check_status = dvap_buff[4];
					if (dvap_check_status)
					{
#if 0
						time(&cur_time);
						if (dvap_buff[4] == 0x00) syslog (LOG_ERR,  "DVAP status Code STOP"); 
						else if (dvap_buff[4] == 0x01) syslog (LOG_ERR,  "DVAP status Code RUN");
						else syslog (LOG_ERR,  "DVAP status Code %2.2x",  
							dvap_buff[4]);
#endif
					}
				}
				else
				{
					if (n > 6)
					{
						time (&cur_time);
						syslog (LOG_ERR, "DVAP Error String ");
						for (k = 4 ; k < dvap_buff[0] ; k++)
						{
							syslog (LOG_INFO, "%c", dvap_buff[k]);
						}
					}
				}
			}
		}
		else if (n == 5)
		{
			if (!memcmp (dvap_buff, RunState, 4))
			{
                        	dvap_check_wait = TRUE;
                                dvap_check_status = dvap_buff[4];
			}
		}
	}	

	k = dvap_buff_pnt - n;
	//if (k > 0) memmove (&dvap_buff[0], &dvap_buff[n], k);
	if (k > 0) memcpy (&dvap_buff[0], &dvap_buff[n], k);
	dvap_buff_pnt = k;
	}
}

