#include	"extern_dmonitor.h"
#include	"init.h"

void	rig_write (int length, char buff[]);
int	getFifo (unsigned char pkt[]);
void	LastFrameSend (void);
void	rig_led_onoff(void);
void	inet_led_onoff(void);
void	buff_hold_size_write (int n);
void	dummy_last_frame (void);
void	jitter_putFifo (void);
int	send_dest_keep_alive(void);
int	node_usb_init (void);
void	node_close (void);
void	lcd_write(void);
int	node_space_check (int length);
int	check_getFifo(void);
void	send_dvap_keep_alive(void);

extern	char	dummy_frame_1[12];
extern	char	dummy_frame_2[12];
extern	char	dummy_frame_3[12];

int     htoi (const char *s)
{
        int n;

        if ( *s != '0' || !(*(s+1) != 'x' || *(s+1) != 'X') ) return 0;

        for (n=0,s+=2 ; *s ; s++)
        {
                if ( *s >= '0' && *s <= '9' )
                {
                        n = 16 * n + (*s - '0');
                }
                else if ( *s >= 'a' && *s <= 'f' ) {
                        n = 16 * n + ((*s - 'a') + 10);
                }
                else if ( *s >= 'A' && *s <= 'F' ) {
                        n = 16 * n + ((*s - 'A') + 10);
                }
        }

        return n;
}

int	rig_open(void)
{
        struct termios attr;
	int	wrt_len;

	if (rig_type == NODE)
	{
		return node_usb_init();
	}

        rig_fd = open(rig_device, O_RDWR | O_NOCTTY | O_NONBLOCK | O_SYNC);
        if (rig_fd < 0) 
	{
		if (rig_type == ICOM) syslog (LOG_ERR, "USB open error on ICOM rig");
		else if (rig_type == DVMEGA) syslog (LOG_ERR, "uart open error on DVMEGA");
		else if (rig_type == DVAP) syslog (LOG_ERR, "USB open error on DVAP");
                return FALSE;
        }

        tcgetattr(rig_fd, &attr);
        save_attr = attr;

	bzero (&attr, sizeof(attr));
	if (rig_type == ICOM)
	{
        	cfsetispeed(&attr, IDxxPlus_SPEED);
        	cfsetospeed(&attr, IDxxPlus_SPEED);
	}
	else if (rig_type == DVMEGA) 
	{
		cfsetispeed(&attr, DVMEGA_SPEED);
		cfsetospeed(&attr, DVMEGA_SPEED);
	}
	else if (rig_type == DVAP)
	{
		cfsetispeed(&attr, DVAP_SPEED);
		cfsetospeed(&attr, DVAP_SPEED);
	}
		
        cfmakeraw(&attr);
        attr.c_cflag |= CS8 | CLOCAL | CREAD;
        attr.c_iflag = IGNPAR;
        attr.c_oflag = 0;
        attr.c_lflag = 0;
        attr.c_cc[VMIN] = 0;
        attr.c_cc[VTIME] = 0;

        tcsetattr(rig_fd, TCSANOW, &attr);
	ioctl (rig_fd, TCSETS, &attr);

	if (!scan_sw) syslog (LOG_INFO, "RIG open");
	else fprintf (status_fd, "RIG open.\n");
	rig_buff_pnt = 0;
	FD_SET (rig_fd, &fd_save);
	return TRUE;
}

void	rig_close (void)
{
	int	ret;

	if (rig_type == NODE)
	{
		node_close();
		if(!scan_sw) syslog (LOG_INFO, "RIG(NODE) close.");
		else fprintf (status_fd, "RIG(NODE) close.\n");
		return;
	}

	tcsetattr (rig_fd, TCSANOW, &save_attr);
	ret = close (rig_fd);
	FD_CLR (rig_fd, &fd_save);
	rig_fd = 0;
	if (rig_type == ICOM)
	{
		if(!scan_sw) syslog (LOG_INFO, "RIG(ICOM) close.");
		else fprintf (status_fd, "RIG(ICOM) close.\n");
	}
	else if (rig_type == DVAP)
	{
		if(!scan_sw) syslog (LOG_INFO, "DVAP close.");
		else fprintf (status_fd, "DVAP close.\n");
	}
	else if (rig_type == DVMEGA)
	{
		if(!scan_sw) syslog (LOG_INFO, "DVMEGA close.");
		else fprintf (status_fd, "DVMEGA close.\n");
	}
}

void    pselectSet(void)
{
        FD_ZERO (&fd_save);
        timeout.tv_sec = 0;
        timeout.tv_nsec = 10000000;
}

void    handler (int sig)
{
	sig_term = FALSE;
        if (sig == SIGINT)
	{
		FD_CLR (in_addr_sock, &fd_save);
		sig_term = TRUE;
                sprintf (msg_temp, "UNLINK FROM %8.8s", area_call);
                memcpy  (mycall2, "UNLK", 4);
                send_msg_sw = TRUE;
                time (&msg_send_set_time);
                unlink_sw = TRUE;
                lcd_write();
	}
	else if (sig == SIGUSR1)
	{
		fifo_new_hold += 50;
		syslog (LOG_INFO, "New FiFo buffer hold size %d", fifo_new_hold);
		buff_hold_size_write(fifo_new_hold);
	}
        else if (sig == SIGUSR2)
        {
		fifo_new_hold -= 50;
		if (fifo_new_hold < 20) fifo_new_hold = 20;
		syslog (LOG_INFO, "New FiFo buffer hold size %d", fifo_new_hold);
		buff_hold_size_write (fifo_new_hold);
        }
	else
		syslog (LOG_INFO, "signal %d", sig);
}

void	buff_hold_size_write (int cnt)
{
	FILE *cnt_file;
        struct  stat    sb;

        if (stat ("/var/www/", &sb)) return;
        if ((sb.st_mode & S_IFMT) != S_IFDIR) return;

	cnt_file = fopen (BUFF_HOLD, "w");
	fprintf (cnt_file, "%d\n", cnt);
	fclose (cnt_file);
}

int	buff_hold_size_read (void)
{
	FILE *cnt_file;
	struct	stat	sb;
	int	cnt;
	char	str[10];

	if (stat (BUFF_HOLD, &sb)) return 20;
	if ((sb.st_mode & S_IFMT) != S_IFREG)
	{
		buff_hold_size_write (20);
		return 20;
	}
	cnt_file = fopen (BUFF_HOLD, "r");
	if (fgets (str, 10, cnt_file))
	{
		cnt = atoi(str);
	}
	else
		cnt = 0;
	fclose (cnt_file);
	return cnt;
}

int     handler_init(void)
{
	sigemptyset (&save_sig);
	sigaddset (&save_sig, SIGUSR1);
	sigaddset (&save_sig, SIGUSR2);
	sigaddset (&save_sig, SIGINT);
	sigaddset (&save_sig, SIGPIPE);
	sigaddset (&save_sig, SIGHUP);
	sigaddset (&save_sig, SIGTERM);

	if (signal(SIGUSR1, handler) == SIG_ERR)
	{
		syslog (LOG_ERR, "signal (SIGUSR1) error");
		return FALSE;
	}	
        if (signal(SIGUSR2, handler) == SIG_ERR)
        {
                syslog (LOG_ERR, "signal (SIGUSR2) error");
                return FALSE;
        }
        if (signal(SIGINT, handler) == SIG_ERR)
        {
		syslog (LOG_ERR, "signal (SIGINT) error");
                return FALSE;
        }
        if (signal(SIGHUP, handler) == SIG_ERR)
        {
                syslog (LOG_ERR, "signal (SIGEPIPE) error");
                return FALSE;
        }
        if (signal(SIGQUIT, handler) == SIG_ERR)
        {
                syslog (LOG_ERR, "signal (SIGQUIT) error");
                return FALSE;
        }
	if (signal(SIGPIPE, handler) == SIG_ERR)
	{
		syslog (LOG_ERR, "signal (SIGPIPE) error");
		return FALSE;
	}
        if (signal(SIGTERM, handler) == SIG_ERR)
        {
                syslog (LOG_ERR, "signal (SIGTERM) error");
                return FALSE;
        }
        return TRUE;
}

int	send_dest_keep_alive (void)
{
	int k;
	int n;
	char	buff[80];
	struct  hostent *host;

        in_addr.sin_family = AF_INET;
        in_addr.sin_port = htons(dest_inet_port);
        in_addr.sin_addr.s_addr = inet_addr(dest_address);
        if (in_addr.sin_addr.s_addr == 0xffffffff)
        {
                host = gethostbyname(dest_address);
                if (host == NULL) return FALSE;
                in_addr.sin_addr.s_addr = *(unsigned int *)host->h_addr_list[0];
        }
	memset (buff, 0x00, sizeof(buff));
	memcpy (&buff[20], connect_call, 8);	
        sprintf (&buff[4], "%s", inet_ntoa (in_addr.sin_addr));
        sendto(in_addr_sock, &buff[4], 24, MSG_DONTWAIT, 
		(struct sockaddr *)&in_addr, sizeof(in_addr));
	time(&hole_punch_send_time);
	time(&dest_keep_alive_send_time);
	return TRUE;
}

void	send_keep_alive(void)
{
	int k;
	int n;
	char	buff[88];
	struct  hostent *host;

        in_addr.sin_family = AF_INET;
        in_addr.sin_port = htons(dest_inet_port);
        in_addr.sin_addr.s_addr = inet_addr(dest_address);
        if (in_addr.sin_addr.s_addr == 0xffffffff)
        {
                host = gethostbyname(dest_address);
                if (host == NULL) return;
                in_addr.sin_addr.s_addr = *(unsigned int *)host->h_addr_list[0];
        }
	memset (buff, 0x00, sizeof(buff));
	memcpy (&buff[20], connect_call, 8);	
        sprintf (&buff[4], "%s", inet_ntoa (in_addr.sin_addr));
        sendto(in_addr_sock, &buff[4], 24, MSG_DONTWAIT, 
		(struct sockaddr *)&in_addr, sizeof(in_addr));
	time(&hole_punch_send_time);

	memcpy (&buff[20], "dmoni", 5);
	memcpy (&buff[25], PACKAGE_VERSION, 5);
        time (&send_time);
	buff[31] = rig_type;
	memcpy (&buff[32], MD5_dmonitor, 32);
	for (n = 0 ; n < 8 ; n++)
	{
		for (k = 0 ; k < 4 ; k++)
		{
			buff[32+(n*4)+k] ^= (send_time >> (k*8)) & 0xff;
		}
	}

	in_addr.sin_family = AF_INET;
	in_addr.sin_port = htons(hole_punch_port);
	in_addr.sin_addr.s_addr = inet_addr(hole_punch_server);
	if (in_addr.sin_addr.s_addr == 0xffffffff)
	{
		host = gethostbyname(hole_punch_server);
		if (host == NULL) return;
		in_addr.sin_addr.s_addr = *(unsigned int *)host->h_addr_list[0];
	}
	memcpy (buff, "HPCH", 4);
	memcpy (&buff[64], area_call, 8); 
	memcpy (&buff[72], zone_call, 7);
	memcpy (&buff[80], connect_call, 8);
	buff[79] = 0x20;
	sendto(in_addr_sock, buff, 88, MSG_DONTWAIT, 
		(struct sockaddr *)&in_addr, sizeof(in_addr));
        time(&hole_punch_send_time);
        time(&dest_keep_alive_send_time);
}

int	inet_send_buff_set(void)
{
	if (frameID != 0) return FALSE;
	memset (inet_send_buff, 0x00, 58);
	memcpy (inet_send_buff, "DSTR", 4);

	inet_send_buff[4] = (m_seq >> 8) & 0xff;
	inet_send_buff[5] = m_seq & 0xff;

	inet_send_buff[6] = 's';
	inet_send_buff[7] = 0x12;
	//inet_send_buff[7] |= ZR;
	inet_send_buff[8] = 0x00;
	inet_send_buff[9] = 0x30;
	inet_send_buff[10] = 0x20;
	inet_send_buff[11] = 0x00;
	inet_send_buff[12] = 0x01;
	inet_send_buff[13] = 0x02;
	frameID = rand();
	inet_send_buff[14] = (frameID >> 8) & 0xff;
	inet_send_buff[15] = frameID & 0xff;
	return TRUE;
}

void	header_store (char header[])
{
	memcpy (header_save, header, 42);
}

void	send_drop_packet (void)
{
                send_buff[0] = 0x10;
                send_buff[1] = 0x22;
		if (send_buff[3] > 20)
		{
			send_buff[3] = 0;
			memcpy  (&send_buff[4], NullVoice, 12);
		}
		else
		{
			memcpy  (&send_buff[4], NullVoice1, 12);
		}
                send_buff[2] = seq & 0xff;
		seq++;
                send_buff[16] = 0xff;
		if ((seq % 5) == 0) rig_led_onoff();
                rig_write (17, send_buff);
}

int	send_rig (void)
{
	int	length;
	int	rate;

	length = check_getFifo();
	if (rig_type == NODE)
	{
		if (length = 42) if (!node_space_check (95)) return TRUE;
		if (!node_space_check (12)) return TRUE;
	}
	if (rig_type == DVAP)
	{
		//if ((length == 13) && !dvap_header_ack_sw) return TRUE;
	}

	length = getFifo (&send_buff[3]);
	if (length == 0)
	{
		memset (inet_frame_id, 0x00, 2);
		rig_send_sw = FALSE;
		return FALSE;
	}
	else if (length == 42)
	{
		rig_write (42, &send_buff[3]);
		seq = 0;
	}
	else if (length == 13)
	{
		#if 0 
		syslog (LOG_DEBUG, "%2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x",
		send_buff[3], send_buff[4], send_buff[5], send_buff[6], send_buff[7], send_buff[8], send_buff[9], send_buff[10],
		send_buff[11], send_buff[12], send_buff[13], send_buff[14], send_buff[15]);
		#endif
		send_buff[0] = 0x10;
		send_buff[1] = 0x22;
		send_buff[2] = seq & 0xff;
		if ((seq % 5) == 0) rig_led_onoff();
		send_buff[16] = 0xff;
		rig_write (17, send_buff);
		if (send_buff[3] & 0x40)
		{
			#ifdef	_DEBUG
			syslog (LOG_INFO, "Fifo_cnt (last frame) %d", Fifo_cnt);
			#endif
			if (Fifo_cnt < fifo_hold) 
			{
				rig_send_sw = FALSE;
				fifo_hold_limit = fifo_hold + 10;
			}
			else	fifo_hold_limit = Fifo_cnt + 10;
                	rig_last_frame_send = TRUE;
                	send_header_sw = FALSE;
			memset (inet_frame_id, 0x00, 2);
			frameID = 0;
		}
	}
	return TRUE;
}

void    LastFrameSend (void)
{
	int	rate;

	#ifdef _DEBUG
	syslog(LOG_INFO, "LastFrameSend");
	#endif
        send_buff[0] = 0x10;
        send_buff[1] = 0x22;
        send_buff[2] = seq & 0xff;
	seq++;
	seq &= 0xff;
	recv_frame_seq++;
	recv_frame_seq %= 0x15;
	send_buff[3] = recv_frame_seq;
	memcpy (&send_buff[4], dummy_frame_1, 12);
        send_buff[16] = 0xff;
        rig_write (17, send_buff);
	
	if (recv_frame_seq % 2)
	{
		send_buff[2] = seq & 0xff;
		recv_frame_seq++;
		recv_frame_seq %= 0x15;
		send_buff[3] = recv_frame_seq;
		memcpy (&send_buff[4], dummy_frame_2, 12);
		rig_write (17, send_buff);
	}

        send_buff[2] = seq & 0xff;
        recv_frame_seq++;
        recv_frame_seq %= 0x15;
        send_buff[3] = recv_frame_seq;
        send_buff[3] |= 0x40;
        memcpy (&send_buff[4], dummy_frame_3, 12);
        rig_write (17, send_buff);
	drop_rate_print();
	inet_read_cnt = 0;
	inet_read_drop_cnt = 0;
	rig_last_frame_send = TRUE;
	if (Fifo_cnt < fifo_hold) rig_send_sw = FALSE;

}

int	check_getFifo (void)
{
	struct	FifoPkt	*tmp;

	if (Rp->next == NULL) return 0;
	tmp = Rp->next; 
	return tmp->length;
}
	
int	getFifo	(unsigned char pkt[])
{
	struct	FifoPkt	*tmp;
	int	len;

	if (Rp->next ==	NULL) 
	{
		Fifo_cnt = 0;
		return 0;
	}
	tmp = Rp;
	Rp = Rp->next;
	len = Rp->length;
	memcpy (pkt, Rp->pkt, Rp->length);
	free (tmp);
	Fifo_cnt--;
	#ifdef	_DEBUG
	syslog (LOG_INFO, "Fifo counter(getFifo):%d", Fifo_cnt);
	#endif
	return	len;
}

void    putFifo (int len, unsigned char pkt[])
{
        struct FifoPkt  *ret;
	#ifdef	_DEBUG
	syslog (LOG_INFO, "putFifo len:%d %2.2x", len, pkt[0]);
	#endif
        ret = malloc (sizeof(struct FifoPkt) - 1024 + len);
        if (ret == NULL)
        {
                syslog (LOG_ERR, "memory error in gw");
                return;
        }
        ret->next = NULL;
        ret->length = len;
        memcpy (ret->pkt, pkt, len);
        Wp->next = ret;
        Wp = ret;
        Fifo_cnt++;
	#ifdef	_DEBUG
	syslog (LOG_INFO, "Fifo counter:%d %2.2x", Fifo_cnt, rig_send_sw);
	#endif
	rig_fifo_check();
}

void	delete_last_header (void)
{
	struct FifoPkt  *ret;

	if (Wp->length != 42) return;
	ret = Wp;
	Wp = ret->next;
	Fifo_cnt--;
	free (ret);
}

void	connected_table(char str[])
{
	struct	stat	sb;
	int	i;
	int	ret;

	if (stat ("/var/tmp/", &sb)) return;
	if ((sb.st_mode & S_IFMT) != S_IFDIR) return;
	if (!memcmp (&str[4], "START", 5))
	{
		if (connected_fd != NULL) fclose (connected_fd);
		connected_fd = fopen (CONNECTED_LIST_TEMP, "w");
		fprintf (connected_fd, "<!DOCTYPE HTML>\n");
		fprintf (connected_fd, "<html lang=\"ja\"><head>\n");
		fprintf (connected_fd, "<meta http-equiv=\"Pragma\" content=\"no-cache\">\n");
		fprintf (connected_fd, "<meta http-equiv=\"Cache-Control\" content=\"no-cache\">\n");
		fprintf (connected_fd, "<meta name=\"expires\" content=\"0\">\n");
		//fprintf (connected_fd, "<meta http-equiv=\"refresh\" content=\"1;URL=./connected_table.html\">\n");
		fprintf (connected_fd, "<meta http-equiv=\"refresh\" content=\"1\">\n");
		fprintf (connected_fd, "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n");
       		//fprintf (connected_fd, "<script type=\"text/javascript\">\n");
		//fprintf (connected_fd, "setTimeout (function() {location.reload() ;} , 1000) ;\n"); 
		//fprintf (connected_fd, "</script>\n");
		fprintf (connected_fd, "</head>\n");
		fprintf (connected_fd, "<body style=\"background-color:#ffe6e6;\">\n");
		//fprintf (connected_fd, "<center>%8.8s 接続ユーザ 一覧 (%s)<br>\n", &str[36], &str[10]);
		fprintf (connected_fd, "<center>%8.8s 接続ユーザ 一覧 <br>\n", &str[36]);
		fprintf (connected_fd, "<table border=\"1\" style=\"font-size:0.9em;\">\n");
	}
	else if (!memcmp(&str[4], "END", 3))
	{
		if (connected_fd)
		{
			fprintf (connected_fd, "</table></center></body></html>\n");
			fflush (connected_fd);
			fclose (connected_fd);
			sprintf (cmd, "/var/www/cgi-bin/file_check  %s %s", CONNECTED_LIST_TEMP, CONNECTED_LIST);
			ret = system (cmd);
			connected_fd = NULL;
		}
	}
	else
	{
		if (connected_fd)
		{
			fprintf (connected_fd, "<tr>\n");
			for (i = 0 ; i < 5 ; i++)
			{
				if (str[i*8+4] != 0x00) fprintf (connected_fd, "<td>%8.8s</td>\n", &str[i*8+4]);
			}
			fprintf (connected_fd, "</tr>\n");
		}
	}
}

void	connected_table_clean(void)
{
	int	ret;

	ret = system("sudo cp /var/www/html/connected_table.html.save /var/tmp/connected_table.html");
	ret = system("sudo touch /var/tmp/connected_table.html");
}

void	error_msg (char str[])
{
        struct  stat    sb;
        int     i;
        int     ret;
	FILE	*error_fd;

       	if (stat ("/var/tmp/", &sb)) return;
       	if ((sb.st_mode & S_IFMT) != S_IFDIR) return;
       	error_fd = fopen (ERROR_TEMP, "w");
	fprintf (error_fd, "<!DOCTYPE HTML>\n");
       	fprintf (error_fd, "<html><head>\n");
	fprintf (error_fd, "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n");
	fprintf (error_fd, "<meta http-equiv=\"Pragma\" content=\"no-cache\">\n");
	fprintf (error_fd, "<meta http-equiv=\"Cache-Control\" content=\"no-cache\">\n");
	fprintf (error_fd, "<meta name=\"expires\" content=\"0\">\n");
	fprintf (error_fd, "<meta http-equiv=\"refresh\" content=\"1;URL=./error_msg.html\">\n");
       	fprintf (error_fd, "</head>\n");
       	fprintf (error_fd, "<body style=\"background-color:#ff8c00;\">\n");
       	fprintf (error_fd, "<center>%s</center>", &str[5]);
	fprintf (error_fd, "</body></html>");
	fflush (error_fd);
	fclose (error_fd);
	sprintf (cmd, "/var/www/cgi-bin/file_check %s %s", ERROR_TEMP, ERROR_MSG);
       	ret = system (cmd);

	if (!memcmp (&str[44], "未登録", 9))
	{
               	sprintf (msg_temp, "NOT REGIST %8.8s ", &str[31]);
               	memcpy (mycall2, "NORG", 4);
               	send_msg_sw = TRUE;
		time (&msg_send_set_time);
               	sig_term = TRUE;
		not_clear_error_msg = TRUE;
		lcd_write();
	}
	if (!memcmp (&str[44], "登録済", 9))
       	{
       		sprintf (msg_temp, "LINK TO %8.8s    ", area_call);
               	memcpy (mycall2, "LINK", 4);
               	send_msg_sw = TRUE;
		time (&msg_send_set_time);
		lcd_write ();
       	}
}

void    called_msg (char mycall[], char urcall[8])
{
        struct  stat    sb;
        int     i;
        int     ret;
        FILE    *called_fd;

        if (stat ("/var/tmp/", &sb)) return;
        if ((sb.st_mode & S_IFMT) != S_IFDIR) return;
        called_fd = fopen (ERROR_TEMP, "w");
        fprintf (called_fd, "<!DOCTYPE HTML>\n");
        fprintf (called_fd, "<html><head>\n");
	//fprintf (called_fd, "<meta http-equiv=\"Pragma\" content=\"no-cache\">\n");
	//fprintf (called_fd, "<meta http-equiv=\"Cache-Control\" content=\"no-cache\">\n");
	//fprintf (called_fd, "<meta name=\"expires\" content=\"0\">\n");
        //fprintf (called_fd, "<meta http-equiv=\"refresh\" content=\"1;URL=./error_msg.html\">\n");
	//fprintf (called_fd, "<meta http-equiv=\"refresh\" content=\"1\">\n");
        fprintf (called_fd, "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n");
        fprintf (called_fd, "<script type=\"text/javascript\">\n");
        fprintf (called_fd, "setTimeout (function() {location.reload() ;} , 1000) ;\n");
        fprintf (called_fd, "</script>\n");
        fprintf (called_fd, "</head>\n");
        fprintf (called_fd, "<body style=\"background-color:#ff8c00;\">\n");
        fprintf (called_fd, "<center>%8.8s が %8.8s を呼んでいます</center>", mycall, urcall);
        fprintf (called_fd, "</body></html>");
        fclose (called_fd);
        sprintf (cmd, "/var/www/cgi-bin/file_check  %s %s", ERROR_TEMP, ERROR_MSG);
        ret = system (cmd);
}

void    drop_rate_msg (char str[])
{
        struct  stat    sb;
        int     i;
        int     ret;
        FILE    *called_fd;

        if (stat ("/var/tmp/", &sb)) return;
        if ((sb.st_mode & S_IFMT) != S_IFDIR) return;
        called_fd = fopen (ERROR_TEMP, "w");
        fprintf (called_fd, "<!DOCTYPE HTML>\n");
        fprintf (called_fd, "<html><head>\n");
        //fprintf (called_fd, "<meta http-equiv=\"Pragma\" content=\"no-cache\">\n");
        //fprintf (called_fd, "<meta http-equiv=\"Cache-Control\" content=\"no-cache\">\n");
	//fprintf (called_fd, "<meta name=\"expires\" content=\"0\">\n");
        fprintf (called_fd, "<meta http-equiv=\"refresh\" content=\"1;URL=./error_msg.html\">\n");
	//fprintf (called_fd, "<meta http-equiv=\"refresh\" content=\"1\">\n");
        fprintf (called_fd, "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n");
        fprintf (called_fd, "</head>\n");
        fprintf (called_fd, "<body style=\"background-color:#ff8c00;\">\n");
        fprintf (called_fd, "<center>%s</center>", str);
        fprintf (called_fd, "</body></html>");
        fclose (called_fd);
        sprintf (cmd, "/var/www/cgi-bin/file_check  %s %s", ERROR_TEMP, ERROR_MSG);
        ret = system (cmd);
}

void    error_msg_clean(void)
{
        int     ret;

        ret = system("sudo cp /var/www/html/error_msg.html.save /var/tmp/error_msg.html");
	ret = system("sudo touch /var/tmp/error_msg.html");
}

void	dmonitor_close (void)
{
	char	buff[24];
	struct  hostent *host;
	int	ret;
	int	queue_length;
	int	cnt;

        in_addr.sin_family = AF_INET;
        in_addr.sin_port = htons(dest_inet_port);
        in_addr.sin_addr.s_addr = inet_addr(dest_address);
        if (in_addr.sin_addr.s_addr == 0xffffffff)
        {
                host = gethostbyname(dest_address);
                if (host == NULL) return;
                in_addr.sin_addr.s_addr = *(unsigned int *)host->h_addr_list[0];
        }
        memset (buff, 0x00, sizeof(buff));
	memcpy (buff, "DISCONNECT", 10); 
        ret = sendto(in_addr_sock, buff, 24, MSG_DONTWAIT,
                (struct sockaddr *)&in_addr, sizeof(in_addr));
}

void	jitter_buff_init(void)
{
	int	n;

	jitter_rd_pnt = 0;
	jitter_wr_pnt = 0;
	jitter_wr_cnt = 0;

	for (n = 0 ; n < 21 ; n++)
	{
		jitter_buff[n][0] = 0xff;
		if (n == 0) memcpy (&jitter_buff[n][1], NullVoice, 12);
		else        memcpy (&jitter_buff[n][1], NullVoice1, 12);
	}
        l_int = (fifo_hold - 10) * 20;
        inet_recv_timeout.tv_sec = l_int / 1000;
        inet_recv_timeout.tv_usec = (l_int % 1000) * 1000;
}

void	jitter_put (unsigned char buff[])
{
	if (rig_last_frame_send) return;
	jitter_wr_pnt = buff[0] & 0x1f;
	if (jitter_wr_pnt > 20) return;
	if (jitter_wr_pnt)
		memcpy (&jitter_buff[jitter_wr_pnt][0], buff, 13);
	else
		memcpy (&jitter_buff[jitter_wr_pnt][0], buff, 10);
	jitter_wr_cnt++;
	//if (jitter_wr_cnt < 0) jitter_wr_pnt = 0;
	#ifdef	_DEBUG_JITTER
	syslog (LOG_INFO, "jitter put %d %d   %2.2x  %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x   %2.2x %2.2x %2.2x", 
		jitter_wr_pnt, jitter_wr_cnt,
		buff[0], buff[1], buff[2], buff[3], buff[4], buff[5], buff[6],buff[7],buff[8],buff[9],buff[10], buff[11],buff[12]);
	#endif
	jitter_putFifo();
}

void	jitter_putFifo (void)
{
	int k, n;
	int	jitter_n;
	if (jitter_buff[jitter_wr_pnt][0] == 0xff) return;
	if ((jitter_buff[jitter_wr_pnt][0] != 0xff) &&  (jitter_buff[jitter_wr_pnt][0] & 0x40))
	{
		#ifdef	_DEBUG_JITTER
		syslog(LOG_DEBUG, "last frame in jitter");
		#endif
		while (jitter_wr_pnt != jitter_rd_pnt)
		{
			if (jitter_buff[jitter_rd_pnt][0] == 0xff) 
			{
				jitter_buff[jitter_rd_pnt][0] = jitter_rd_pnt;
				inet_read_drop_cnt++;
				syslog (LOG_INFO, "packet loss (drop last frame) %2.2x", jitter_rd_pnt);
			}
			putFifo (13, &jitter_buff[jitter_rd_pnt][0]);
			jitter_buff[jitter_rd_pnt][0] = 0xff;
			if (jitter_rd_pnt == 0) memcpy (&jitter_buff[jitter_rd_pnt][1], NullVoice, 12);
			else        memcpy (&jitter_buff[jitter_rd_pnt][1], NullVoice1, 12);
			jitter_rd_pnt++;
			if (jitter_rd_pnt > 20) jitter_rd_pnt = 0;
		}
		putFifo (13, &jitter_buff[jitter_wr_pnt][0]);
		jitter_buff[jitter_wr_pnt][0] = 0xff;
		jitter_rd_pnt++;
		//jitter_wr_pnt = jitter_rd_pnt;
		if (jitter_rd_pnt > 20) jitter_rd_pnt = 0;
                digitalWrite (INET_LED, 0);
                digitalWrite (RIG_LED, 0);
		rig_last_frame_send = TRUE;
		//memset (inet_frame_id, 0x00, 2);
		jitter_rd_pnt = 0;
		return;
	}
	while (jitter_buff[jitter_rd_pnt][0] != 0xff)
	{
		//syslog (LOG_DEBUG, "jitter_putFifo %d", jitter_rd_pnt);
		putFifo (13, &jitter_buff[jitter_rd_pnt][0]);
		jitter_buff[jitter_rd_pnt][0] = 0xff;
		if (jitter_rd_pnt == 0) memcpy (&jitter_buff[jitter_rd_pnt][1], NullVoice, 12);
		else        memcpy (&jitter_buff[jitter_rd_pnt][1], NullVoice1, 12);
		//jitter_wr_pnt = jitter_rd_pnt;
		jitter_rd_pnt++;
		if (jitter_rd_pnt > 20) jitter_rd_pnt = 0;
		jitter_wr_cnt--;
	}
	#ifdef	_DEBUG_JITTER
	syslog (LOG_INFO, "debug %d %d", jitter_wr_pnt, jitter_rd_pnt);
	syslog (LOG_INFO, "%2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x %2.2x",
		jitter_buff[0][0], jitter_buff[1][0],jitter_buff[2][0],jitter_buff[3][0],jitter_buff[4][0],
		jitter_buff[5][0],jitter_buff[6][0],jitter_buff[7][0],jitter_buff[8][0],jitter_buff[9][0],jitter_buff[10][0],
		jitter_buff[11][0], jitter_buff[12][0],jitter_buff[13][0],jitter_buff[14][0],jitter_buff[15][0],
		jitter_buff[16][0],jitter_buff[17][0],jitter_buff[18][0],jitter_buff[19][0],jitter_buff[20][0]);
	#endif
#if 0 
	n = 0;
	syslog (LOG_DEBUG, "%d %d %d", jitter_wr_pnt+1, jitter_rd_pnt, jitter_rd_pnt+21);
	if (((jitter_wr_pnt + 1) != jitter_rd_pnt) && ((jitter_wr_pnt + 1) != (jitter_rd_pnt + 21)))
	{
		k = jitter_rd_pnt;
		while (k != jitter_wr_pnt)
		{
			if (jitter_buff[k][0] != 0xff)
			{
				n++;
			}
			else
				break;
			k--;
			if (k < 0) k = 20;
		}
		#ifdef	_DEBUG_JITTER
		syslog (LOG_INFO, "n:%d\n", n);
		#endif
	}
	if (n > 5)
	{
		jitter_n = jitter_rd_pnt;
		while (jitter_n != jitter_wr_pnt)
		{
			if (jitter_buff[jitter_n][0] == 0xff)
			{
				inet_read_drop_cnt++;
                                syslog (LOG_INFO, "packet loss (drop) %2.2x", jitter_n);
			}
			jitter_buff[jitter_n][0] = jitter_n;
			putFifo (13, &jitter_buff[jitter_n][0]);
			jitter_buff[jitter_n][0] = 0xff;
			if (jitter_n == 0) memcpy (&jitter_buff[jitter_n][1], NullVoice, 12);
			else        memcpy (&jitter_buff[jitter_n][1], NullVoice1, 12);
			jitter_n++;
			if (jitter_n > 20) jitter_n = 0;
		}
		//jitter_wr_cnt = 0;
	}
#endif
	send_dvap_keep_alive();
}

void	drop_rate_print (void)
{
	int	rate;
	char	str[64];

        if (inet_read_cnt)
        {
                rate = (inet_read_drop_cnt * 10000) / inet_read_cnt;
                syslog(LOG_INFO, "drop packet rate %d.%02d%% (%ld/%ld)",
                        rate/100, rate%100, inet_read_drop_cnt, inet_read_cnt);
                syslog(LOG_INFO, "jitter info. ave:%ldmSec. max:%ldmSec. min:%ldmSec.",
                        jitter_ave/inet_read_cnt + 20, jitter_max, jitter_min);
		memset (str, 0x00, sizeof(str));
		sprintf (str, "drop packet rate %d,%02d%% (%ld/%ld)", 
			rate/100, rate%100, inet_read_drop_cnt, inet_read_cnt);
		drop_rate_msg (str);
                digitalWrite (INET_LED, 0);
                digitalWrite (RIG_LED, 0);
        }
}

int    ETagGen (char file_name[], char md_string[])
{
        MD5_CTX ctx;
        unsigned char   md[MD5_LBLOCK];
        FILE    *fp;
        int     ret;
	char	temp[512];

        fp = fopen (file_name, "rb");
	if (!fp) return -1;
        MD5_Init (&ctx);
        while (1)
        {
                ret = fread (temp, 1, sizeof(temp), fp);
                if (ret > 0) MD5_Update(&ctx, temp, ret);
                else break;
        }
        fclose (fp);
        MD5_Final (md, &ctx);
        sprintf (md_string, "%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x",
                        md[0], md[1], md[2], md[3], md[4], md[5], md[6], md[7],
                        md[8], md[9], md[10], md[11], md[12], md[13], md[14], md[15]);
	return 0;
}

void	rig_not_connect_msg (void)
{
        struct  stat    sb;
        int     i;
        int     ret;
	FILE	*error_fd;

        if (stat ("/var/tmp/", &sb)) return;
        if ((sb.st_mode & S_IFMT) != S_IFDIR) return;
        error_fd = fopen (ERROR_TEMP, "w");
        fprintf (error_fd, "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n");
        fprintf (error_fd, "<script type=\"text/javascript\">\n");
        fprintf (error_fd, "<!--\n");
        fprintf (error_fd, "setTimeout (function() {location.reload() ;} , 5000) ;\n");
        fprintf (error_fd, "// -->\n</script>\n");
        fprintf (error_fd, "</head>\n");
        fprintf (error_fd, "<body style=\"background-color:#FF82B2;\">\n");
        fprintf (error_fd, "<center><b>無線機が接続されていません</b></center>\n");
	fprintf (error_fd, "</body></html>");
	fclose (error_fd);
	sprintf (cmd, "/var/www/cgi-bin/file_check %s %s", ERROR_TEMP, ERROR_MSG);
        ret = system (cmd);
        digitalWrite (INET_LED, 0);
        digitalWrite (RIG_LED, 0);
}

int     ja_check (unsigned char callsign[])
{
        /* JA-JS,7J-7N,8J-8N */
        if (callsign[7] == 'S') return FALSE;
        if ((callsign[7] == ' ') || ((callsign[7] >= 'A') && (callsign[7] <= 'Z')))
        {
                if (memcmp (callsign, "JA", 2) >= 0  && memcmp (callsign, "JS", 2) <= 0) return TRUE;
                if (memcmp (callsign, "7J", 2) >= 0  && memcmp (callsign, "7N", 2) <= 0) return TRUE;
                if (memcmp (callsign, "8J", 2) >= 0  && memcmp (callsign, "8N", 2) <= 0) return TRUE;
        }
        return FALSE;
}

void	invalid_os (void)
{
        struct  stat    sb;
        int     i;
        int     ret;
	FILE	*error_fd;

       	if (stat ("/var/tmp/", &sb)) return;
       	if ((sb.st_mode & S_IFMT) != S_IFDIR) return;
       	error_fd = fopen (ERROR_TEMP, "w");
	fprintf (error_fd, "<!DOCTYPE HTML>\n");
       	fprintf (error_fd, "<html><head>\n");
       	fprintf (error_fd, "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n");
       	fprintf (error_fd, "<script type=\"text/javascript\">\n");
	fprintf (error_fd, "</script>\n");
       	fprintf (error_fd, "</head>\n");
       	fprintf (error_fd, "<body style=\"background-color:#ff8c00;\">\n");
       	fprintf (error_fd, "<center>サポートされていないOSです</center>");
	fprintf (error_fd, "</body></html>");
	fclose (error_fd);
	sprintf (cmd, "/var/www/cgi-bin/file_check %s %s", ERROR_TEMP, ERROR_MSG);
       	ret = system (cmd);
}

void	right_os (void)
{
        struct  stat    sb;
        int     i;
        int     ret;
	FILE	*error_fd;

       	if (stat ("/var/tmp/", &sb)) return;
       	if ((sb.st_mode & S_IFMT) != S_IFDIR) return;
       	error_fd = fopen (ERROR_TEMP, "w");
	fprintf (error_fd, "<!DOCTYPE HTML>\n");
       	fprintf (error_fd, "<html><head>\n");
       	fprintf (error_fd, "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n");
       	fprintf (error_fd, "<script type=\"text/javascript\">\n");
	fprintf (error_fd, "</script>\n");
       	fprintf (error_fd, "</head>\n");
       	fprintf (error_fd, "<body style=\"background-color:#ff8c00;\">\n");
       	fprintf (error_fd, "<center></center>");
	fprintf (error_fd, "</body></html>");
	fclose (error_fd);
	sprintf (cmd, "/var/www/cgi-bin/file_check %s %s", ERROR_TEMP, ERROR_MSG);
       	ret = system (cmd);
}

