#include	"multi_forward.h"
#include	"config.h"
#define START_SEND      0x01
#define END_SEND        0x02
#define NO_SEND         0x00
#define NOEFECT         0xff

extern	void	handler(int sig);
void	ctbl(void);
void    ctbl_putFifo (char call[], unsigned char pkt[]);
int	ctbl_getFifo (char call[], unsigned char pkt[]);
void	send_not_regist (struct MultiConnectTable *pnt);
void	send_not_xmit (struct MultiConnectTable *pnt);
void    send_no_error_auth (struct MultiConnectTable *pnt);
void    send_no_error_xmit (struct MultiConnectTable *pnt);
void	position_update (unsigned char call[], char ar_call[]);
void    send_current_use_call (char call[]);
void	multi_sd_queue_check(void);
void	area_call_set (unsigned char call[]);
void    ETagGen (char file_name[], unsigned char md_string[]);

extern	struct  timeval         time_100ms;

int *parser_result(const char *buf, int size);
void    hole_punch_interval_reset (char buff[]);

void	pselectSet(void)
{
	FD_ZERO (&read_save);
	sigemptyset (&save_sig);
	sigaddset (&save_sig, SIGUSR1);
	sigaddset (&save_sig, SIGUSR2);
	sigaddset (&save_sig, SIGTERM);
	sigaddset (&save_sig, SIGINT);
        timeout.tv_sec = 0;
        timeout.tv_nsec = 5000000;
}

void	keep_alive_check (void)
{
	struct	MultiConnectTable	*next;
	struct	MultiConnectTable	*prev;
	struct	FifoPkt	*Rp;
	struct	FifoPkt	*temp;
	time_t	cur_time;
	int	change_sw;

	change_sw = FALSE;
	time (&cur_time);
	prev = NULL;
	next = MultiConnectTablePnt;
	while (next)
	{
		if ((cur_time - next->AccessTime) > 30)
		{
			fprintf (log_file, "%24.24s Disconnect from %8.8s %s(%d)\n",
				ctime(&cur_time), 
				next->auth_callsign, inet_ntoa (next->multi_addr.sin_addr), 
				next->multi_addr.sin_port);
			fflush (log_file);
                        Rp = next->Rp;
                        while (Rp)
                        {
                                temp = Rp;
                                Rp = Rp->next;;
                                free (temp);
                        }
			if (prev)
			{
				prev->f_chain = next->f_chain;
				free (next);
				next = prev->f_chain;
			}
			else
			{
				MultiConnectTablePnt = next->f_chain;
				free (next);
				next = MultiConnectTablePnt;
			}
			change_sw = TRUE;
		}
		else
		{
			prev = next;
			next = next->f_chain;
		}
	}
	if (change_sw) ctbl();
}

void	delete_MultiConnectTable (struct sockaddr_in multi_addr)
{
	struct	MultiConnectTable	*next;
	struct	MultiConnectTable	*prev;
	struct  FifoPkt *Rp;
	struct	FifoPkt	*temp;
	time_t	cur_time;

	next = MultiConnectTablePnt;
	prev = NULL;
	while (next)
	{
		if ((multi_addr.sin_addr.s_addr == next->multi_addr.sin_addr.s_addr)
			&& (multi_addr.sin_port == next->multi_addr.sin_port))
		{
			time(&cur_time);
                        fprintf (log_file, "%24.24s Disconnect from %8.8s %s(%d)\n",
                                ctime(&cur_time),
                                next->auth_callsign, inet_ntoa (next->multi_addr.sin_addr),
                                next->multi_addr.sin_port);
                        fflush (log_file);

			Rp = next->Rp;
			while (Rp)
			{
				temp = Rp;
				Rp = Rp->next;;
				free (temp);
			}
			if (prev)
			{
				prev->f_chain = next->f_chain;
				free (next);
				next = prev->f_chain;
			}
			else
			{
				MultiConnectTablePnt = next->f_chain;
				free (next);
				next = MultiConnectTablePnt;
			}
			return;
		}
		next = next->f_chain;
	}
}

char    CpuUsage[10];
int     prev_idle = 0, prev_total = 0;
void    cpu_usage (void)
{
        int size,  *nums, idle, total, i;
        char    buf[256];

        size = read(cpu_fd, buf, sizeof(buf));
        if(size <= 0) return;

        nums = parser_result(buf, size);
        idle=nums[3];
        for(i=0, total=0; i<10; i++){
                total += nums[i];
        }
        int diff_idle = idle-prev_idle;
        int diff_total = total-prev_total;
        float usage = (float)(((float)(1000*(diff_total-diff_idle))/(float)diff_total+5)/(float)10);
        sprintf(CpuUsage, "%6.2f%%", usage);

        prev_total = total;
        prev_idle = idle;
        lseek(cpu_fd, 0, SEEK_SET);
}

int *parser_result(const char *buf, int size){
        static int ret[10];
        int i, j = 0, start = 0;

        for(i=0; i<size; i++){
                char c = buf[i];
                if(c >= '0' && c <= '9'){
                        if(!start){
                                start = 1;
                                ret[j] = c-'0';
                        } else {
                                ret[j] *= 10;
                                ret[j] += c-'0';
                        }
                } else if(c == '\n'){
                        break;
                } else {
                        if(start){
                                j++;
                                start = 0;
                        }
                }
        }

        return ret;
}

void	send_hole_punch (void)
{
	struct	area_callsign	*ar_temp;
	unsigned char	hole_punch[56];

	struct	addrinfo	hints;
	struct	addrinfo	*result, *rp;
	char	PORT[10];
	int	ret;
	time_t	atime;
	char	temp[10];
	char	*pnt;
	int	n;
	int	k;

	memset (&hints, 0x00, sizeof(struct addrinfo));
	hints.ai_family = AF_UNSPEC;
	hints.ai_socktype = SOCK_DGRAM;
	hints.ai_protocol = UDP;
	result = NULL;
	ret = sprintf (PORT, "%d", hole_punch_port);
	PORT[ret] = 0x00;
	ret = getaddrinfo (hole_punch_server, PORT, &hints, &result);
	if (ret == 0)
	{
		for (rp = result ; rp != NULL ; rp = rp->ai_next)
		{
			if (rp->ai_family == AF_INET)
			{
				ar_temp = ar_callsign_pnt;
				while (ar_temp)
				{
        				memset (hole_punch, 0x00, sizeof(hole_punch));
					memcpy (hole_punch, "HPCH", 4);
        				memcpy (&hole_punch[4], ar_temp->ar_callsign, 8);
        				hole_punch[12] = (multi_port >> 8) & 0xff;
        				hole_punch[13] = multi_port & 0xff;
					memset (temp, 0x00, sizeof(temp));
					memcpy (temp, VERSION, strlen(VERSION));
					pnt = strtok(temp, ".");
					hole_punch[14] = atoi(pnt) & 0xff;
					pnt += 3;
					hole_punch[15] = atoi(pnt) & 0xff;
					memcpy (&hole_punch[16], zr_callsign, 8);
					//if (read_md5()) return;
					memcpy (&hole_punch[24], &MD5_multi_forward[0], 32);
					//hole_punch[23] = 0x20;
					time (&atime);
					for (n = 0 ; n < 8 ; n++)
					{
						for (k = 0 ; k < 4 ; k++)
						{
							hole_punch[24+(n*4)+k] ^= (atime >> (k*8)) & 0xff;
						}
					}
					multi_sd_queue_check();
					ret = sendto (multi_sd, hole_punch, 56, MSG_DONTWAIT,	// new version 0.
						rp->ai_addr, rp->ai_addrlen);
                			if (ret == -1)
                			{
                        			time(&atime);
                        			fprintf (log_file, "%24.24s hole_punch send error %s\n", ctime(&atime), strerror(errno));
                        			fflush (log_file);
                			}
					else if (ret != 56)
					{
						time(&atime);
						fprintf (log_file, "%24.24s hole_punch send error %d(56)\n", ctime(&atime), ret);
						fflush (log_file);
					}
					time (&hole_punch_send_time);
					hole_punch_ack_sw = FALSE;

					ar_temp = ar_temp->next;
				}
				break;
			}
		}
		freeaddrinfo (result);
	}
	else
	{
		time (&cur_time);
		fprintf (log_file, "%24.24s getaddrinfo error (send_hole_punch) %s\n",
                                ctime(&cur_time), gai_strerror(ret));
                fflush (log_file);
	}
}

void	multi_sd_queue_check (void)
{
	int	que_length;
	int	cnt;

	ioctl (multi_sd, TIOCOUTQ, &que_length);
	cnt = 0;
	while (que_length)
	{
		if (cnt > 20) break;
		usleep (500);
		ioctl (multi_sd, TIOCOUTQ, &que_length);
		cnt++;
	}
}

struct MultiConnectTable *multi_table_create(struct sockaddr_in multi_addr)
{
        struct  MultiConnectTable       *next;

        next = malloc (sizeof(struct MultiConnectTable));
        next->f_chain = MultiConnectTablePnt;
        memcpy (&next->multi_addr, &multi_addr, sizeof (multi_addr));
        time (&next->AccessTime);
        next->in = 0;
        next->out = 0;
        next->gw = 0;
        next->zr = 0;
        next->auth = AUTH_WAIT;
        next->xmit = XMIT_FALSE;
        memset (next->auth_callsign, 0x20, 8);
        memset (next->xmit_callsign, 0x20, 8);
        memset (next->ar_callsign, 0x20, 8);
        next->Rp = malloc (sizeof (struct FifoPkt) - 1024);
        next->Wp = next->Rp;
        next->Rp->next = NULL;
        MultiConnectTablePnt = next;
        return next;
}

void	read_hole_punch (char buff[], int length)
{
	char	ip_add[20];
	int	port;
	int	k;
	struct	sockaddr_in	hole_addr;
	int	ret;
	int	len;
	time_t	atime;
	struct	MultiConnectTable *pnt;
	//struct	MultiConnectTable *next;

	port = multi_port;
	if (length == 10)
	{
		hole_punch_interval_reset(buff);
		hole_punch_ack_sw = TRUE;
		upnp_msearch_cnt = 0;
	}
	else if (length == 42)	// new version
	{
		if (memcmp (&buff[34], zr_callsign, 7)) return;
		memset (ip_add, 0x00, 20);
		len = strlen (buff);
		for (k = 4 ; k < len ; k++)
		{
			if (buff[k] != ':')
			{
				ip_add[k-4] = buff[k];
			}
			else
			{
				port = atoi (&buff[k+1]);
				break;
			}
		}
        	hole_addr.sin_family = AF_INET;
        	hole_addr.sin_port = htons(port);
        	hole_addr.sin_addr.s_addr = inet_addr(ip_add);

		pnt = MultiConnectTablePnt;
		while (pnt)
		{
			if ((pnt->multi_addr.sin_addr.s_addr == hole_addr.sin_addr.s_addr)
				&& (pnt->multi_addr.sin_port == hole_addr.sin_port)
				&& !memcmp(&pnt->ar_callsign, &buff[26], 8)
				&& !memcmp(&pnt->zr_callsign, &buff[34], 7))
			{
				time (&pnt->AccessTime);
				break;
			}
			pnt = pnt->f_chain;
		}
		if (pnt == NULL)
		{
			pnt = multi_table_create (hole_addr);
		}
		if (pnt == NULL) return;
		
		memcpy (pnt->ar_callsign, &buff[26], 8);
		memcpy (pnt->zr_callsign, &buff[34], 7);
		pnt->zr_callsign[7] = 0x20;
		multi_sd_queue_check();
		ret = sendto (multi_sd, buff, 25, MSG_DONTWAIT, 
			(struct sockaddr *)&hole_addr, sizeof(hole_addr));
                if (ret == -1)
                {
                        time(&atime);
                        fprintf (log_file, "%24.24s multi hole_punch ack error %s\n", ctime(&atime), strerror(errno));
                        fflush (log_file);
                }
		else if (ret != 25)
		{
			time(&atime);
			fprintf (log_file, "%24.24s multi hole_punch ack error %d(25)\n", ctime(&atime), ret);
			fflush (log_file);
		}
	}
	else if ((length == 26) || (length == 36))
	{
		memset (ip_add, 0x00, 20);
		len = strlen (buff);
		for (k = 4 ; k < len ; k++)
		{
			if (buff[k] != ':')
			{
				ip_add[k-4] = buff[k];
			}
			else
			{
				port = atoi (&buff[k+1]);
				break;
			}
		}
        	hole_addr.sin_family = AF_INET;
        	hole_addr.sin_port = htons(port);
        	hole_addr.sin_addr.s_addr = inet_addr(ip_add);

		pnt = MultiConnectTablePnt;
		while (pnt)
		{
			if ((pnt->multi_addr.sin_addr.s_addr == hole_addr.sin_addr.s_addr)
				&& (pnt->multi_addr.sin_port == hole_addr.sin_port))
			{
				time (&pnt->AccessTime);
				break;
			}
			pnt = pnt->f_chain;
		}
		if (pnt == NULL) pnt = multi_table_create (hole_addr);	// dummy address
		multi_sd_queue_check();
		ret = sendto (multi_sd, buff, 25, MSG_DONTWAIT, 
			(struct sockaddr *)&hole_addr, sizeof(hole_addr));
                if (ret == -1)
                {
                        time(&atime);
                        fprintf (log_file, "%24.24s multi hole_punch ack error %s\n", ctime(&atime), strerror(errno));
                        fflush (log_file);
                }
		else if (ret != 25)
		{
			time(&atime);
			fprintf (log_file, "%24.24s multi hole_punch ack error %d(25)\n", ctime(&atime), ret);
			fflush (log_file);
		}
	}
}

void	hole_punch_interval_reset (char buff[])
{
	int	nat_port;
	time_t	atime;

	nat_port = atoi (&buff[4]);
	if (nat_port != hole_punch_port_save)
	{
		time(&atime);
		fprintf (log_file, "%24.24s port number changed %d -> %d\n",
			ctime(&atime), hole_punch_port_save, nat_port);
		fflush (log_file);
		hole_punch_port_save = nat_port;
		if (hole_punch_interval == 20) hole_punch_interval = 10;
		else if (hole_punch_interval == 10) hole_punch_interval =5;
		else if (hole_punch_interval == 5) hole_punch_interval = 2;
		else if (hole_punch_interval == 2) hole_punch_interval = 1;
	}
}
	
void	status_on (char	call[], char ur_call[], char my_call[], char rpt1_call[], char rpt2_call[])
{
	char	status_string[48];

	struct	addrinfo	hints;
	struct	addrinfo	*result, *rp;
	char	PORT[10];
	int	ret;
	time_t	atime;

	memcpy (current_use_call, my_call, 8);
	send_current_use_call (current_use_call);
	memset (&hints, 0x00, sizeof(struct addrinfo));
	hints.ai_family = AF_UNSPEC;
	hints.ai_socktype = SOCK_DGRAM;
	hints.ai_protocol = UDP;

	result = NULL;
	ret = sprintf (PORT, "%d", hole_punch_port);
	PORT[ret] = 0x00;
	ret = getaddrinfo (hole_punch_server, PORT, &hints, &result);
	if (ret == 0)
	{
		for (rp = result ; rp != NULL ; rp = rp->ai_next)
		{
			if (rp->ai_family == AF_INET)
			{
					memcpy (status_string, "STAT", 4);
        				memcpy (&status_string[4], call, 8);
					memcpy (&status_string[12], "ON  ", 4);
					memcpy (&status_string[16], ur_call, 8);
					memcpy (&status_string[24], my_call, 8);
					memcpy (&status_string[32], rpt1_call, 8);
					memcpy (&status_string[40], rpt2_call, 8);
					multi_sd_queue_check();
        				ret = sendto(multi_sd, status_string, 48, MSG_DONTWAIT, 
						rp->ai_addr, rp->ai_addrlen);
                			if (ret == -1)
                			{
                        			time(&atime);
                        			fprintf (log_file, "%24.24s satus_on error %s\n", ctime(&atime), strerror(errno));
                        			fflush (log_file);
                			}
					else if (ret != 48)
					{
						time (&atime);
						fprintf (log_file, "%24.24s satus_on error %d(48)\n", ctime(&atime), ret);
						fflush (log_file);
					}
			}
			break;		/* new version test */
		}
		freeaddrinfo (result);
	}
	else
	{
		time (&cur_time);
		fprintf (log_file, "%24.24s getaddrinfo error (send_status_on) %s\n",
                                ctime(&cur_time), gai_strerror(ret));
                fflush (log_file);
	}
}


void	status_off (unsigned char call[])
{
	char	status_string[16];

	struct	addrinfo	hints;
	struct	addrinfo	*result, *rp;
	char	PORT[10];
	int	ret;
	time_t	atime;

	memcpy (current_use_call, "なし    ", 8);
	send_current_use_call (current_use_call);
	memset (&hints, 0x00, sizeof(struct addrinfo));
	hints.ai_family = AF_UNSPEC;
	hints.ai_socktype = SOCK_DGRAM;
	hints.ai_protocol = UDP;

	result = NULL;
	ret = sprintf (PORT, "%d", hole_punch_port);
	PORT[ret] = 0x00;
	ret = getaddrinfo (hole_punch_server, PORT, &hints, &result);
	if (ret == 0)
	{
		for (rp = result ; rp != NULL ; rp = rp->ai_next)
		{
			if (rp->ai_family == AF_INET)
			{
				memcpy (status_string, "STAT", 4);
        			memcpy (&status_string[4], call, 8);
				memcpy (&status_string[12], "OFF ", 4);
				multi_sd_queue_check();
        			ret = sendto(multi_sd, status_string, 16, MSG_DONTWAIT, 
					rp->ai_addr, rp->ai_addrlen);
                		if (ret == -1)
                		{
                        		time(&atime);
                        		fprintf (log_file, "%24.24s status_off error %s\n", ctime(&atime), strerror(errno));
                        		fflush (log_file);
                		}
				else if (ret != 16)
				{
					time (&atime);
					fprintf (log_file, "%24.24s status_off error %d(16)\n", ctime(&atime), ret);
					fflush (log_file);
				}
			}
			break;		/* new version test */
		}
		freeaddrinfo (result);
	}
	else
	{
		time (&cur_time);
		fprintf (log_file, "%24.24s getaddrinfo error (send_status_off) %s\n",
                                ctime(&cur_time), gai_strerror(ret));
                fflush (log_file);
	}
}

void    status_check (void)
{
        struct  area_callsign       *next_pnt;
        time_t	cur_time;

        time (&cur_time);
        next_pnt = ar_callsign_pnt;
        while (next_pnt)
        {
               	if ((cur_time - next_pnt->status_time) >= 3)
                {
			if (next_pnt->status == ON)
			{
				status_off (next_pnt->ar_callsign);
				next_pnt->status = OFF;
				memset (next_pnt->FrameID, 0x00, 2);
			}
		}
		next_pnt = next_pnt->next;
        }
}

int	ja_check (unsigned char callsign[])
{
	/* JA-JS,7J-7N,8J-8N */
	if (callsign[7] == 'S') return FALSE;
	if ((callsign[7] == ' ') || ((callsign[7] >= 'A') && (callsign[7] <= 'Z')))
	{
		if (memcmp (callsign, "JA", 2) >= 0  && memcmp (callsign, "JS", 2) <= 0) return TRUE;
		if (memcmp (callsign, "7J", 2) >= 0  && memcmp (callsign, "7N", 2) <= 0) return TRUE;
		if (memcmp (callsign, "8J", 2) >= 0  && memcmp (callsign, "8N", 2) <= 0) return TRUE;
	}
	return FALSE;
}

int	mycall2_check (unsigned char mycall2[])
{
	int	i;

	for (i = 0 ; i < 4 ; i++)
	{
		if (mycall2[i] == 0x00) return FALSE;
	}
	return TRUE;
}

int     ur_call_check (unsigned char callsign[])
{
        /* JA-JS,7J-7N,8J-8N */
        if ((callsign[7] == 'S') || (callsign[7] == 'G')) return FALSE;
        if (!memcmp (callsign, "        ", 8)) return FALSE; 
        return TRUE;
}
void	trust_read (int length, unsigned char buff[])
{
	struct MultiConnectTable	*next;
	time_t	atime;

	if (buff[2] == 0x80)
	{
		if (buff[4] == 0x02)
		{
			next = MultiConnectTablePnt;
			while (next)
			{
				if (!memcmp (next->auth_callsign, &buff[8], 8))
				{
					if (buff[3] == 0x00) 
					{
						if (next->auth != AUTH_TRUE)
						{
							next->auth = AUTH_TRUE;
							time (&atime);
        						fprintf (log_file, "%24.24s Connect from %8.8s:%8.8s:%8.8s %s(%d)\n", ctime(&atime),
              							next->auth_callsign, next->ar_callsign, next->zr_callsign, 
								inet_ntoa (next->multi_addr.sin_addr), next->multi_addr.sin_port);
        						fflush (log_file);
							ctbl();
							send_no_error_auth (next);
						}
					}
					else if (buff[3] == 0x01)
					{
						time(&atime);
						fprintf (log_file, "%24.24s not regist.(connect) callsign %8.8s %s(%d)\n", ctime(&atime), 
							next->auth_callsign, inet_ntoa (next->multi_addr.sin_addr), next->multi_addr.sin_port);
						fflush (log_file);		 
						next->auth = AUTH_FALSE;
						send_not_regist (next);
					}
					break;
				}
				next = next->f_chain;
			}
			next = MultiConnectTablePnt;
			while (next)
			{	
				if (!memcmp (next->xmit_callsign, &buff[8], 8))
				{
					if (buff[3] == 0x00)
					{
						if (next->xmit != XMIT_TRUE)
							position_update(&buff[8], next->ar_callsign);
						next->xmit = XMIT_TRUE;
						send_no_error_xmit(next);
					}
					else if (buff[3] == 0x01) 
					{
						time(&atime);
						next->xmit = XMIT_FALSE;
						fprintf (log_file, "%24.24s not regist.(XMIT) callsign %8.8s %s(%d)\n", ctime(&atime), 
						next->xmit_callsign, inet_ntoa (next->multi_addr.sin_addr), next->multi_addr.sin_port);
						fflush (log_file);
						send_not_xmit (next);
					}
					break;
				}
				next = next->f_chain;
			}
		}
		else if ((buff[3] == 0x00) && (buff[4] == 0x25))
		{
			if (buff[15] != 'S') area_call_set(&buff[8]);
		}
	}
}


void    putFifo (int len, struct MultiConnectTable *pnt, unsigned char pkt[])
{
        struct	FifoPkt  *ret;
	time_t	atime;

	time(&atime);
        if ((len == pnt->Wp->length) && (len != 26))
        {
                if (!memcmp (&pkt[6], &pnt->Wp->pkt[6], len-6))
		{
			fprintf (log_file, "%24.24s dup. packet frame seq:%2.2x\n", ctime(&atime), pkt[16]);
			fflush (log_file);
			return;
		}
        }
        ret = malloc (sizeof(struct FifoPkt) - 1024 + len);
        if (ret == NULL)
        {
                fprintf (log_file, "%24.24s memory error in gw\n", ctime(&atime));
                fflush (log_file);
                return;
        }
        ret->next = NULL;
        ret->length = len;
        memcpy (ret->pkt, pkt, len);
	pnt->Wp->next = ret;
        pnt->Wp = ret;
}

int     getFifo (struct MultiConnectTable *pnt, unsigned char pkt[])
{
        struct  FifoPkt *tmp;
	int	len;
	char	auth;
	char	xmit;

	if (pnt == NULL) return 0;
        if (pnt->Rp->next == NULL) return 0;
	if (pnt->auth == AUTH_WAIT) return 0;
	if (pnt->xmit == XMIT_WAIT) return 0;
        tmp = pnt->Rp;
	pnt->Rp = pnt->Rp->next;
        len = pnt->Rp->length;
        memcpy (pkt, pnt->Rp->pkt, len);

	auth = pnt->auth;
	xmit = pnt->xmit;
        free (tmp);
        if ((auth == AUTH_TRUE) && (xmit == XMIT_TRUE)) return len;
	return 0;
}

void	send_inquire (char call[])
{
	unsigned char	buff[16];

	struct	addrinfo	hints;
	struct	addrinfo	*result;
	char	PORT[10];
	int	ret;
	time_t	atime;

        memset (buff, 0x00, 8);
        buff[0] = 0x01;
        buff[1] = 0x03;
        buff[4] = 0x02;
        memcpy (&buff[8], call, 8);
	memset (&hints, 0x00, sizeof(struct addrinfo));
	hints.ai_family = AF_INET;
	hints.ai_socktype = SOCK_DGRAM;
	hints.ai_protocol = UDP;

	ret = sprintf (PORT, "%d", trust_port);
	PORT[ret] = 0x00;
	ret = getaddrinfo (trust_server, PORT, &hints, &result);
	if (ret == 0)
	{
		multi_sd_queue_check();
       		ret = sendto(multi_sd, buff, 16, MSG_DONTWAIT, 
			result->ai_addr, result->ai_addrlen);
               	if (ret == -1)
               	{
                       	time(&atime);
                       	fprintf (log_file, "%24.24s inquire error %s\n", ctime(&atime), strerror(errno));
                       	fflush (log_file);
               	}
		else if (ret != 16)
		{
			time(&atime);
			fprintf (log_file, "%24.24s inquire error %d(16)\n", ctime(&atime), ret);
			fflush (log_file);
		}
		freeaddrinfo (result);
	}
	else 
	{
		time(&atime);
		fprintf (log_file, "%24.24s getaddrinfo error (send_inquire) %s\n", ctime(&atime), gai_strerror(ret));
		fflush (log_file);
	}
}

void	trust_resp_check(void)
{
	struct	MultiConnectTable	*next;
	struct	timeval		atime;
	struct	timeval		temp_time;

	gettimeofday (&atime, NULL);
	next = MultiConnectTablePnt;
	while (next)
	{
                timeradd (&next->AuthInquireTime, &time_100ms, &temp_time);
                if (timercmp (&atime, &temp_time, >))
                {
			if (next->auth == AUTH_WAIT) next->auth = AUTH_FALSE;
		}
		timeradd (&next->XmitInquireTime, &time_100ms, &temp_time);
		if (timercmp (&atime, &temp_time, >))
		{
			if (next->xmit == XMIT_WAIT) next->xmit = XMIT_FALSE;
		}
		next = next->f_chain;
	}
}

void	ctbl(void)
{
	struct	MultiConnectTable	*pnt;
	struct	area_callsign		*ar_pnt;
	unsigned char	buff[44];
	char	ar_call[8];
	int	k;
	int	first_sw;

	ar_pnt = ar_callsign_pnt;

	while (ar_pnt)
	{
		first_sw = TRUE;
		pnt = MultiConnectTablePnt;
		while (pnt)
		{
			if (!memcmp (ar_pnt->ar_callsign, pnt->ar_callsign, 8))
			{
				if (first_sw)
				{
					memcpy (ar_call, ar_pnt->ar_callsign, 8);
					k = 0;
					memcpy (buff, "CTBL", 4);
					memset (&buff[4], 0x00, 40);
					memcpy (&buff[4], "START", 5);
					memcpy (&buff[10], PACKAGE_STRING, sizeof(PACKAGE_STRING));
					ctbl_putFifo (ar_call, buff);
					first_sw = FALSE;
				}
				memset (&buff[4], 0x00, 40);
				while (pnt)
				{
					if (pnt->auth == AUTH_TRUE)
					{
						memcpy (&buff[k*8+4], pnt->auth_callsign, 8);
						k++;
						memcpy (ar_call, pnt->ar_callsign, 8);
						if (k == 5)
						{
							ctbl_putFifo(ar_call, buff);
							k = 0;
							memset (&buff[4], 0x00, 40);
						}
					}		
					pnt = pnt->f_chain;
				}		
				if (k)
				{
					ctbl_putFifo(ar_call, buff);
				}
				memset (&buff[4], 0x00, 40);
				memcpy (&buff[4], "END", 3);
				memcpy (&buff[10], PACKAGE_STRING, sizeof(PACKAGE_STRING));
				ctbl_putFifo(ar_call, buff);
				break;
			}
			else
				pnt = pnt->f_chain;
		}
		ar_pnt = ar_pnt->next;
	}
}

void    ctbl_putFifo (char ar_call[], unsigned char pkt[])
{
        struct  ctblPkt  *ret;

        ret = malloc (sizeof(struct ctblPkt));
        if (ret == NULL)
        {
                fprintf (log_file, "memory error in gw\n");
                fflush (log_file);
                return;
        }
        ret->next = NULL;
	memcpy (ret->area_callsign, ar_call, 8);
        memcpy (ret->pkt, pkt, 44);
        ctblWp->next = ret;
        ctblWp = ret;
}

int     ctbl_getFifo (char ar_call[], unsigned char pkt[])
{
        struct  ctblPkt *tmp;

        if (ctblRp->next == NULL) return 0;
        tmp = ctblRp;
        ctblRp = ctblRp->next;
        memcpy (pkt, ctblRp->pkt, 44);
	memcpy (ar_call, ctblRp->area_callsign, 8);
        free (tmp);
	return 44;
}

void	ctbl_send(void)
{
	struct	MultiConnectTable	*next;
	unsigned char	buff[44];
	char	ar_call[8];
	int	ret;
	time_t	atime;

	if (ctbl_getFifo (ar_call, buff) == 0) return;

	next = MultiConnectTablePnt;
        while (next)
        {
		if (!memcmp (ar_call, next->ar_callsign, 8))
		{
			if (!memcmp (&buff[4], "START", 5))
			{
				memcpy (&buff[36], ar_call, 8);
			}
			multi_sd_queue_check();
        		ret = sendto (multi_sd, buff, 44, MSG_DONTWAIT,
               			(struct sockaddr *)&next->multi_addr,
                      			sizeof(struct sockaddr));
               		if (ret == -1)
               		{
               			time(&atime);
               			fprintf (log_file, "%24.24s ctbl_send error %s\n", 
					ctime(&atime), strerror(errno));
                       		fflush (log_file);
               		}
			else if (ret != 44)
			{
				time(&atime);
				fprintf (log_file, "%24.24s ctbl_send error %d(44)\n", ctime(&atime), ret);
				fflush (log_file);
			}
		}
                next = next->f_chain;
	}
}

void	send_not_regist(struct MultiConnectTable *pnt)
{
	char	buff[64];
	int		ret;
	time_t		atime;
	
	memcpy (buff, "ERROR", 5);
	memset (&buff[5], 0x00, 59);
	sprintf (&buff[5], "接続コールサイン '%8.8s' は未登録", pnt->auth_callsign);
	multi_sd_queue_check();
        ret = sendto (multi_sd, buff, 64, MSG_DONTWAIT,
        	(struct sockaddr *)&pnt->multi_addr,sizeof(struct sockaddr));
	if (ret == -1)
	{
		time(&atime);
		fprintf (log_file, "%24.24s send_not_regist error %s\n",
			ctime(&atime), strerror(errno));
		fflush (log_file);
	}
	else if (ret != 64)
	{
		time (&atime);
		fprintf (log_file, "%24.24s send_not_regist error %d(64)\n", ctime (&atime), ret);
		fflush (log_file);
	}
}

void	send_not_xmit (struct MultiConnectTable *pnt)
{
	char	buff[64];
	int		ret;
	time_t		atime;

	memcpy (buff, "ERROR", 5);
	memset (&buff[5], 0x00, 59);
	sprintf (&buff[5], "MyCall '%8.8s' は未登録", pnt->xmit_callsign);
	multi_sd_queue_check();
	ret = sendto (multi_sd, buff, 64, MSG_DONTWAIT,
		 (struct sockaddr *)&pnt->multi_addr,sizeof(struct sockaddr));
        if (ret == -1)
        {
                time(&atime);
                fprintf (log_file, "%24.24s send_not_xmit error %s\n",
                        ctime(&atime), strerror(errno));
                fflush (log_file);
        }
	else if (ret != 64)
	{
		time (&atime);
		fprintf (log_file, "%24.24s send_not_xmit error %d(64)\n", ctime(&atime), ret);
		fflush (log_file);
	}
}

void	send_no_error_auth (struct MultiConnectTable *pnt)
{
	char   buff[64];
	int		ret;
	time_t		atime;

	memcpy (buff, "ERROR", 5);
	memset (&buff[5], 0x00, 59);
        sprintf (&buff[5], "接続コールサイン '%8.8s' は登録済", pnt->auth_callsign);
	multi_sd_queue_check();
	ret = sendto (multi_sd, buff, 64, MSG_DONTWAIT,
		(struct sockaddr *)&pnt->multi_addr, sizeof(struct sockaddr));
        if (ret == -1)
        {
                time(&atime);
                fprintf (log_file, "%24.24s send_no_error_auth  error %s\n",
                        ctime(&atime), strerror(errno));
                fflush (log_file);
        }
	else if (ret != 64)
	{
		time(&atime);
		fprintf (log_file, "%24.24s send_no_error_auth  error %d(64)\n", ctime(&atime), ret);
		fflush (log_file);
	}
}

void	send_invalid_call (char call[], struct sockaddr_in multi_addr)
{
	char   buff[64];
	int		ret;
	time_t		atime;

	memcpy (buff, "ERROR", 5);
	memset (&buff[5], 0x00, 59);
	sprintf (&buff[5], "コールサイン '%8.8s' が間違っている", call);
	multi_sd_queue_check();
	ret = sendto (multi_sd, buff, 64, MSG_DONTWAIT,
		(struct sockaddr *)&multi_addr, sizeof(struct sockaddr_in));
        if (ret == -1)
        {
                time(&atime);
                fprintf (log_file, "%24.24s send_invalid call error %s\n",
                        ctime(&atime), strerror(errno));
                fflush (log_file);
        }
	else if (ret != 64)
	{
		time (&atime);
		fprintf (log_file, "%24.24s send_invalid call error %d(64)\n", ctime(&atime), ret);
		fflush (log_file);
	}
}

void    send_no_error_xmit (struct MultiConnectTable *pnt)
{
        char   buff[64];
	int		ret;
	time_t		atime;

        memcpy (buff, "ERROR", 5);
        memset (&buff[5], 0x00, 59);
        sprintf (&buff[5], "MyCall '%8.8s' は登録済", pnt->xmit_callsign);
	multi_sd_queue_check();
        ret = sendto (multi_sd, buff, 64, MSG_DONTWAIT,
                (struct sockaddr *)&pnt->multi_addr, sizeof(struct sockaddr));
        if (ret == -1)
        {
                time(&atime);
                fprintf (log_file, "%24.24s send_no_error_xmit error %s\n",
                        ctime(&atime), strerror(errno));
                fflush (log_file);
        }
	else if (ret != 64)
	{
		time(&atime);
		fprintf (log_file, "%24.24s send_no_error_xmit error %d(64)\n", ctime(&atime), ret);
		fflush (log_file);
	}
}

void    send_current_use_call (char call[8])
{
        char   buff[64];
	struct MultiConnectTable *pnt;
	int	ret;
	time_t	atime;

       	memcpy (buff, "MESSG", 5);
       	memset (&buff[5], 0x00, 59);
       	sprintf (&buff[5], "使用中の局 %8.8s", call);
	pnt = MultiConnectTablePnt;
	while (pnt)
	{
		multi_sd_queue_check();
        	ret = sendto (multi_sd, buff, 64, MSG_DONTWAIT,
                	(struct sockaddr *)&pnt->multi_addr, sizeof(struct sockaddr));
        	if (ret == -1)
        	{
                	time(&atime);
                	fprintf (log_file, "%24.24s send_current_use_call error %s\n",
                        	ctime(&atime), strerror(errno));
                	fflush (log_file);
        	}
		else if (ret != 64)
		{
			time(&atime);
			fprintf (log_file, "%24.24s send_current_use_call error %d(64)\n", ctime(&atime), ret);
			fflush (log_file);
		}
		pnt = pnt->f_chain;
	}
}

void	send_disconnect_hole_punch (void)
{
	struct	area_callsign	*ar_temp;
	unsigned char	hole_punch[24];

	struct	addrinfo	hints;
	struct	addrinfo	*result, *rp;
	char	PORT[10];
	int	ret;
	time_t	atime;
	char	temp[10];
	char	*pnt;

	memset (&hints, 0x00, sizeof(struct addrinfo));
	hints.ai_family = AF_UNSPEC;
	hints.ai_socktype = SOCK_DGRAM;
	hints.ai_protocol = UDP;

	result = NULL;
	ret = sprintf (PORT, "%d", hole_punch_port);
	PORT[ret] = 0x00;
	ret = getaddrinfo (hole_punch_server, PORT, &hints, &result);
	if (ret == 0)
	{
		for (rp = result ; rp != NULL ; rp = rp->ai_next)
		{
			if (rp->ai_family == AF_INET)
			{
				ar_temp = ar_callsign_pnt;
				while (ar_temp)
				{
        				memset (hole_punch, 0x00, sizeof(hole_punch));
					memcpy (hole_punch, "DISC", 4);
        				memcpy (&hole_punch[4], ar_temp->ar_callsign, 8);
        				hole_punch[12] = (multi_port >> 8) & 0xff;
        				hole_punch[13] = multi_port & 0xff;
					memset (temp, 0x00, sizeof(temp));
					memcpy (temp, VERSION, strlen(VERSION));
					pnt = strtok(temp, ".");
					hole_punch[14] = atoi(pnt) & 0xff;
					pnt = strtok(NULL,".");
					hole_punch[15] = atoi(pnt) & 0xff;
					memcpy (&hole_punch[16], zr_callsign, 8);
					multi_sd_queue_check();
					//hole_punch[23] = 0x20;
        				ret = sendto(multi_sd, hole_punch, 24, MSG_DONTWAIT, 
						rp->ai_addr, rp->ai_addrlen);
                			if (ret == -1)
                			{
                        			time(&atime);
                        			fprintf (log_file, "%24.24s disconnect_hole_punch error %s\n", ctime(&atime), strerror(errno));
                        			fflush (log_file);
                			}
					else if (ret != 24)
					{
						time (&atime);
						fprintf (log_file, "%24.24s disconnect_hole_punch error %s(24)\n", ctime(&atime), strerror(errno));
						fflush (log_file);
					}
					ar_temp = ar_temp->next;
				}
				break;		/* new version test */
			}
		}
		freeaddrinfo (result);
	}
	else
	{
		time (&cur_time);
		fprintf (log_file, "%24.24s getaddrinfo error (send_disconnect_hole_punch) %s\n",
                                ctime(&cur_time), gai_strerror(ret));
                fflush (log_file);
	}
}

void	position_update(unsigned char call[], char ar_call[])
{
	char	buff[26];
	int	ret;
	time_t	atime;

	memset (buff, 0x20, 26);
	memcpy (buff, "DSTR", 4);
	buff[4] = (fwd_send_seq >> 8) & 0xff;
	buff[5] = fwd_send_seq & 0xff;
	fwd_send_seq++;
	fwd_send_seq &= 0xffff;
	buff[6] = 's';
	buff[7] = 0x21 | GW;
	buff[8] = 0x00;
	buff[9] = 0x10;
	memcpy (&buff[10], call, 8);
	memcpy (&buff[18], ar_call, 8);
	multi_sd_queue_check();

        ret = sendto (fwd_sd, buff, 26, MSG_DONTWAIT,
        	(struct sockaddr *)&fwd_recv_addr, sizeof(fwd_recv_addr));
        if (ret == -1)
        {
        	time(&atime);
                fprintf (log_file, "%24.24s mult->fwd error %s\n", 
			ctime(&atime), strerror(errno));
                fflush (log_file);
        }
	else if (ret != 26)
	{
		time (&atime);
		fprintf (log_file, "%24.24s mult->fwd error %d(26)\n", ctime(&atime), ret);
		fflush (log_file);
	}
}

int    getOwnIp (void)
{
        int     fd;
        struct  ifreq   ifr;
        int     ret;

        fd = socket (PF_INET, SOCK_DGRAM, 0);
        ifr.ifr_addr.sa_family = PF_INET;
        strncpy (ifr.ifr_name, NicDevice, IFNAMSIZ);
        ret = ioctl (fd, SIOCGIFADDR, &ifr);
        close (fd);
        time (&cur_time);
        if (ret == -1)
        {
                fprintf (log_file, "%24.24s ioctl error: %s %s\n", ctime(&cur_time), strerror(errno), NicDevice);
                fflush (log_file);
                return FALSE;

        }
	OwnMultiIP.s_addr = ((struct sockaddr_in *)&ifr.ifr_addr)->sin_addr.s_addr;
        fprintf(log_file, "%24.24s Own IP address %s\n", ctime(&cur_time),
        	inet_ntoa (OwnMultiIP));
        fflush (log_file);
        return TRUE;
}

void	repeater_name_req (void)
{
	unsigned char	buff[16];

	struct	addrinfo	hints;
	struct	addrinfo	*result;
	char	PORT[10];
	int	ret;
	time_t	atime;
	struct  area_callsign   *ar_temp;
	struct  area_callsign	*ar_save;

        memset (buff, 0x00, 8);
        buff[0] = 0x01;
        buff[1] = 0x03;
        buff[4] = 0x25;
        memcpy (&buff[8], zr_callsign, 7);
	buff[15] = 0x20;
	memset (&hints, 0x00, sizeof(struct addrinfo));
	hints.ai_family = AF_INET;
	hints.ai_socktype = SOCK_DGRAM;
	hints.ai_protocol = UDP;

	ret = sprintf (PORT, "%d", trust_port);
	PORT[ret] = 0x00;
	ret = getaddrinfo (trust_server, PORT, &hints, &result);
	if (ret == 0)
	{
		multi_sd_queue_check();
       		ret = sendto(multi_sd, buff, 16, MSG_DONTWAIT, 
			result->ai_addr, result->ai_addrlen);
               	if (ret == -1)
               	{
                       	time(&atime);
                       	fprintf (log_file, "%24.24s repeater name error %s\n", ctime(&atime), strerror(errno));
                       	fflush (log_file);
               	}
		else if (ret != 16)
		{
			time(&atime);
			fprintf (log_file, "%24.24s repeater name error %d(16)\n", ctime(&atime), ret);
			fflush (log_file);
		}
		freeaddrinfo (result);
	}
	else 
	{
		time(&atime);
		fprintf (log_file, "%24.24s getaddrinfo error (repeater name req) %s\n", ctime(&atime), gai_strerror(ret));
		fflush (log_file);
	}
	
	ar_temp = ar_callsign_pnt;
	ar_save = NULL;
	time (&atime);
	while (ar_temp)
	{
		if ((atime - ar_temp->update_time) >= 900)
		{
			if (ar_save == NULL)
			{
				ar_callsign_pnt = ar_temp->next;
				free (ar_temp);
				ar_temp = ar_callsign_pnt;
			}
			else
			{
				ar_save->next = ar_temp->next;
				free (ar_temp);
				ar_temp = ar_save->next;
			}
		}
		else
		{
			ar_save = ar_temp;
			ar_temp = ar_temp->next;
		}
	}
}


void	area_call_set (unsigned char area_call[])
{
	struct  area_callsign     *ar_call_next;

        ar_call_next = ar_callsign_pnt;
        while (ar_call_next)
        {
        	if (!memcmp (ar_call_next->ar_callsign, area_call, 8))
		{
			time (&ar_call_next->update_time);
			return;
		}
                ar_call_next = ar_call_next->next;
	}

	ar_call_next =  malloc (sizeof(struct area_callsign));
	memcpy (ar_call_next->ar_callsign, area_call, 8);
	time (&ar_call_next->update_time);
	memset (ar_call_next->FrameID, 0x00, 2);
	ar_call_next->status = OFF;
	//ar_call_next->addr.sin_addr.s_addr = fwd_addr.sin_addr.s_addr;
	//ar_call_next->addr.sin_port = fwd_addr.sin_port;
	if (ar_callsign_pnt == NULL) 
	{
		ar_callsign_pnt = ar_call_next;
		ar_call_next->next = NULL;
	}
	else
	{
		ar_call_next->next = ar_callsign_pnt;
		ar_callsign_pnt = ar_call_next;
	}
	send_hole_punch();
}

int	read_md5 (void)
{
	char	pg_path[256];
	int	ret;

        ret = readlink ("/proc/self/exe", pg_path, sizeof (pg_path));
        if (ret <= 0) return -1;
        pg_path[ret] = 0x00;
        ETagGen (pg_path, MD5_multi_forward);
	//memcpy (MD5_multi_forward, "953a24a7f2696b86d48b2e4b67569958", 32);	// debug
	return 0;
}

