/*
	Interface for ID-RP2C

*/

//#define	_UPNP_DEBUG

#define	CONFIG_FILE	"/opt/dstar/conf/multi_forward.conf"
#define	DSGWD_CONF_FILE	"/etc/dsgwd.conf"
#define LOG_FILE	"/var/log/multi_forward.log"
#define	PID_FILE	"/var/run/multi_forward.pid"

#define	TRUE		1
#define	FALSE		0
#define INVALID		2

#define ON	1
#define OFF	0

#define	GW	0x80
#define	ZR	0x40
#define	FWD	0x04
#define VOICE	0x12
#define DATA	0x11
#define	C_MASK	0x33
#define	POSIT	0x21
#define	XFWD	GW | ZR | FWD

#include	<stdint.h>
#include	<string.h>
#include	<ctype.h>
#include	<time.h>
#include	<sys/time.h>
#include	<stdio.h>
#include	<stdlib.h>
#include	<sys/socket.h>
#include 	<sys/types.h>
#include 	<netinet/in.h>
#include 	<netdb.h>
#include	<signal.h>
#include	<sys/ioctl.h>
#include	<sys/stat.h>
#include	<net/if.h>
#include	<errno.h>
#include	<sys/utsname.h>
#include	<netinet/in.h>
#include	<arpa/inet.h>
#include	<unistd.h>
#include	<fcntl.h>
#include	<termios.h>
#include	"dstar.h"
#include	"packet.h"

#define	HOLE_PUNCHD_SERVER	"hole-punchd.d-star.info"
#define HOLE_PUNCHD_PORT		30010
#define	TRUST_SERVER		"trust.d-star.info"
#define	TRUST_PORT		30001
#define CSS_FILE        	"/opt/dstar/web/dstar.css"
#define LOGO_FILE       	"/opt/dstar/web/logo.png"
#define JS_FILE         	"/opt/dstar/web/dstar.js"
#define	DCS_CONFIG_FILE		"/dstar/dcs_icom.cfg"
#define	GATEWAY_PORT		51000

#define	NOP	0
#define	WAIT	1
#define	SKIP	2

#define	CON_AUTH	0x01
#define	XMIT_AUTH	0x02

#define	AUTH_TRUE	0x00
#define	AUTH_FALSE	0x01
#define	AUTH_WAIT	0x02

#define	XMIT_TRUE	0x00
#define	XMIT_FALSE	0x01
#define	XMIT_WAIT	0x02

#define	XMIT		0x01
#define	AUTH		0x02

#define	TCP		6
#define	UDP		17

struct	MultiConnectTable
{
	struct	MultiConnectTable	*f_chain;
	struct  FifoPkt *Rp;
	struct  FifoPkt *Wp;
	struct	timeval	AuthInquireTime;
	struct	timeval XmitInquireTime;
	time_t		AccessTime;
	struct	sockaddr_in	multi_addr;
	char	auth_callsign[8];
	char	xmit_callsign[8];
	char	ar_callsign[8];
	char	zr_callsign[8];
	long int	in;
	long int	out;
	long int	zr;
	long int	gw;
	char		auth;
	char		xmit;
	char		ctbl_send_sw;
};

struct	MultiConnectTable	*MultiConnectTablePnt;
//struct	MultiConnectTable	*XmitPnt;

char	hole_punch_server[128];
int	hole_punch_port;
struct	addrinfo	*hole_punch_serv;

char	trust_server[128];
int	trust_port;
struct	addrinfo	*trust_serv;
struct  timeval send_inquire_time;

int	fwd_port;

int	reload;
int	debug_sw;
int	sig_term;

FILE	*log_file;
FILE	*pid_file;


fd_set          read_set;
fd_set		read_save;

struct	sockaddr_in    	fwd_addr;
struct	sockaddr_in	fwd_recv_addr;
struct	sockaddr_in	multi_addr;
socklen_t		len_fwd_addr;
socklen_t		len_fwd_recv_addr;
socklen_t		len_multi_addr;

struct	tm	*gt;

struct 	utsname      uname_buf;

struct	termios	termio_save;


sigset_t	save_sig;
sigset_t	sigset;
struct  timespec        timeout;

int	fwd_sd;
int	multi_port;
int	multi_sd;

struct  addrinfo        *multi_serv;

int	http_port;
int	http_sd;
struct	sockaddr_storage	http_recv;
struct	addrinfo		*http_serv;

int	cpu_fd;

time_t	cur_time;

int	hole_punch_interval;
int	hole_punch_port_save;

struct	area_callsign
{
	struct	area_callsign	*next;
	time_t	status_time;
	time_t	update_time;
	//struct  sockaddr_in     addr;
	unsigned char	ar_callsign[8];
	char	FrameID[2];
	char	status;
	unsigned char	rf_header[58];
	unsigned short int	connected_count;
};

struct	area_callsign	*ar_callsign_pnt;

char	zr_callsign[8];

char	dcs_name[8];

char	forward_addr[128];

struct  FifoPkt
{
        struct  FifoPkt *next;
        int     length;
        unsigned char pkt[1024];
};

struct  ctblPkt
{
        struct  ctblPkt *next;
	char	area_callsign[8];
        unsigned char pkt[44];
};

struct  ctblPkt *ctblRp;
struct  ctblPkt *ctblWp;

union
{
        struct  dstar_packet    d_packet;
        unsigned char    forward_buffer[256];
}       forward_buff;

union
{
        struct  dstar_packet    d_packet;
        unsigned char    multi_buffer[256];
}	multi_buff;

char	forward_buff_save[256];

unsigned int	multi_send_seq;
unsigned int	fwd_send_seq;

char		current_use_call[8];

time_t  area_call_set_time;

unsigned char	MD5_multi_forward[32];

/* UPNP */
int	upnp_udp_sd;
int	upnp_http_sd;
struct	addrinfo	*upnp_sock;
struct	addrinfo	*upnp_bind_sock;
struct	sockaddr_storage	in_upnp_addr;
socklen_t	in_upnp_addr_len;
struct	sockaddr_storage	upnp_addr;
socklen_t	upnp_addr_len;
char	upnp_ip_addr[64];
char	upnp_buf[4096];
int	upnp_sw;
int	upnp_buf_pnt;
time_t	upnp_send_time;
int	upnp_add_sw;
int	upnp_start_pnt;
int	upnp_check_cnt;
time_t  hole_punch_send_time;
unsigned int	gateway_port;

char    NicDevice[IFNAMSIZ];
struct	in_addr	OwnMultiIP;
struct  sockaddr_in     upnp_udp;
struct  addrinfo        *upnp_serv;

int	hole_punch_ack_sw;
int     upnp_msearch_cnt;

