#include	"multi_forward.h"

void	status_on (unsigned char call[], unsigned char ur_call[], unsigned char my_call[], 
		unsigned char rpt1_call[], unsigned char rpt2_call[]);
void	status_off (unsigned char call[]);
int	ja_check (unsigned char call[]);
int	mycall2_check (unsigned char call2[]);
int	getFifo (struct MultiConnectTable *pnt, unsigned char str[]);
void	putFifo (int length, struct MultiConnectTable *pnt, unsigned char str[]);
void	multi_sd_queue_check (void);
void	read_hole_punch (char buff[], int length);
void	trust_read (int length, unsigned char buff[]);
void	delete_MultiConnectTable (struct sockaddr_in multi_addr);
void	send_invalid_call (unsigned char call[], struct sockaddr_in multi_addr);
void    send_inquire (unsigned char call[]);
int	ur_call_check (unsigned char call[]);

extern  struct  sockaddr_in     in_sock;
extern  socklen_t       len_in_sock;

void    forward_reply (char pkt[])
{
        char    forward_reply_frame[10];
        int     ret;
        time_t  atime;

        memset (forward_reply_frame, 0x00, 10);
        memcpy (forward_reply_frame, pkt, 6);
        forward_reply_frame[6] = 'r';

        ret = sendto (fwd_sd, forward_reply_frame, 10, MSG_DONTWAIT,
                (struct sockaddr *)&fwd_recv_addr, sizeof(fwd_recv_addr));
        if (ret == -1)
        {
		time(&atime);
                fprintf (log_file, "%24.24s sendto (forward reply) error:%s\n",
                        ctime(&atime), strerror(errno));
                fflush (log_file);
        }
	else if (ret != 10)
	{
		time (&atime);
		fprintf (log_file, "%24.24s sendto (forward reply) error %d(10)\n", ctime(&atime), ret);
		fflush (log_file);
	}
}

int	forward_resend (void)
{
	int	length;
	time_t	atime;
	struct	MultiConnectTable	*next;
	struct  area_callsign     *ar_call_next;
	int	ret;

	ar_call_next = NULL;
	len_fwd_recv_addr = sizeof (fwd_recv_addr);
    	length = recvfrom(fwd_sd, &forward_buff, sizeof(forward_buff), 0, 
		(struct sockaddr *)&fwd_recv_addr, &len_fwd_recv_addr);
	if (length < 0) {
               	time(&atime);
               	fprintf (log_file, "%24.24s xchange data Recv. error\n", ctime(&atime));
		fflush (log_file);
        	return FALSE;
    	}
	if (length < 10) return TRUE;

	if (!memcmp(forward_buff.d_packet.id, "DSTR", 4) && (forward_buff.d_packet.sr == 's')) 
	{
		forward_reply((char *)&forward_buff);
	}

	if (length < 16) return TRUE;

        if (!memcmp (&forward_buff.forward_buffer[6], forward_buff_save, length-6)) return TRUE;
        memcpy (forward_buff_save, &forward_buff.forward_buffer[6], length-6);

	if (((forward_buff.d_packet.c & C_MASK) != VOICE)
		&& ((forward_buff.d_packet.c & C_MASK) != POSIT)) return TRUE;
	if ((length == 58) && (forward_buff.d_packet.l[1] == 0x30))
	{
		if (!mycall2_check (forward_buff.d_packet.body.header.mycall_ex)) return TRUE;
		if (!ja_check (forward_buff.d_packet.body.header.mycall)) return TRUE;
		if (!ja_check (forward_buff.d_packet.body.header.rpt1)
			|| !ja_check (forward_buff.d_packet.body.header.rpt2)) return TRUE;
		if (forward_buff.d_packet.c & ZR)
		{

			if (forward_buff.d_packet.body.header.rpt1[7] == 0x20)
				forward_buff.d_packet.body.header.rpt1[7] = 'A';
			if (!memcmp(forward_buff.d_packet.body.header.rpt2, zr_callsign, 7))
			{
                      		ar_call_next = ar_callsign_pnt;
                       		while (ar_call_next)
                       		{
                      			if (!memcmp (ar_call_next->ar_callsign, forward_buff.d_packet.body.header.rpt1, 8))
                              		{
						if ((ar_call_next->FrameID[0] == 0x00) && (ar_call_next->FrameID[1] == 0x00))
						{
                               				memcpy (ar_call_next->FrameID, forward_buff.d_packet.trunk.FrameID, 2);
							//memcpy (&ar_call_next->addr, &fwd_addr, sizeof(struct sockaddr_in));
						}
						goto skip;
                               		}
                               		ar_call_next = ar_call_next->next;
                       		}
				return TRUE;
			}
		}
		else if (forward_buff.d_packet.c & GW) 
		{
			if (forward_buff.d_packet.body.header.rpt2[7] == 0x20)
				forward_buff.d_packet.body.header.rpt2[7] = 'A';
			if (!memcmp(forward_buff.d_packet.body.header.rpt1, zr_callsign, 7))
			{
				ar_call_next = ar_callsign_pnt;
				while (ar_call_next)
				{
					if (!memcmp (ar_call_next->ar_callsign, forward_buff.d_packet.body.header.rpt2, 8))
					{
						if ((ar_call_next->FrameID[0] == 0x00) && (ar_call_next->FrameID[1] == 0x00))
						{
							memcpy (ar_call_next->FrameID, forward_buff.d_packet.trunk.FrameID, 2);
							//memcpy (&ar_call_next->addr, &fwd_addr, sizeof(struct sockaddr_in));
						}
						goto skip;
					}
					ar_call_next = ar_call_next->next;
				}
				return TRUE;
			}
		}
		return  TRUE;

skip:
		time (&ar_call_next->status_time);
		if (forward_buff.d_packet.c & ZR) 
			status_on (forward_buff.d_packet.body.header.rpt1,
				forward_buff.d_packet.body.header.urcall,
				forward_buff.d_packet.body.header.mycall,
				forward_buff.d_packet.body.header.rpt1,
				forward_buff.d_packet.body.header.rpt2);
		else if (forward_buff.d_packet.c & GW) 
			status_on (forward_buff.d_packet.body.header.rpt2,
				forward_buff.d_packet.body.header.urcall,
				forward_buff.d_packet.body.header.mycall,
				forward_buff.d_packet.body.header.rpt1,
				forward_buff.d_packet.body.header.rpt2);
		memcpy (ar_call_next->rf_header, &forward_buff, 58);
		ar_call_next->status = ON;
		goto skip_1;
	}
	else if (((length == 29) && (forward_buff.d_packet.l[1] == 0x13))
		|| ((length == 32) && (forward_buff.d_packet.l[1] == 0x16)))
	{
		if ((forward_buff.d_packet.trunk.FrameSeq & 0x1f) > 0x14) return TRUE;
		ar_call_next = ar_callsign_pnt;
		while (ar_call_next)
		{
			if (!memcmp (ar_call_next->FrameID, forward_buff.d_packet.trunk.FrameID, 2))
				//&& !memcmp (&ar_call_next->addr, &fwd_addr, sizeof(struct sockaddr_in)))
			{
				time (&ar_call_next->status_time);
				if (forward_buff.d_packet.trunk.FrameSeq & 0x40)
				{
					status_off (ar_call_next->ar_callsign);
					memset (ar_call_next->FrameID, 0x00, 2);
				}
				goto skip_1;
			}
			ar_call_next = ar_call_next->next;
		}
		return TRUE;
	}
skip_1:
	forward_buff.d_packet.m[0] = (multi_send_seq >> 8) & 0xff;
	forward_buff.d_packet.m[1] = multi_send_seq & 0xff;
	multi_send_seq++;
	multi_send_seq &= 0xffff;
	if (forward_buff.d_packet.trunk.FrameSeq  == 0x14)
	{
		ar_call_next->rf_header[4] = (multi_send_seq >> 8) & 0xff;
		ar_call_next->rf_header[5] = multi_send_seq & 0xff;
		multi_send_seq++;
		multi_send_seq &= 0xffff;
	}
	next = MultiConnectTablePnt;
	while (next)
	{
		multi_sd_queue_check();
		ret = sendto (multi_sd, &forward_buff, length, MSG_DONTWAIT,
			(struct sockaddr *)&next->multi_addr, sizeof(struct sockaddr));
		if (ret == -1)
		{
			time(&atime);
			fprintf (log_file, "%24.24s fwd->mult error %s\n", ctime(&atime), strerror(errno));
			fflush (log_file);
		}
		else if (ret != length)
		{
			time(&atime);
			fprintf (log_file, "%24.24s fwd->mult error %d(%d)\n", ctime(&atime), ret, length);
			fflush (log_file);
		}	
		next->out++;
		next = next->f_chain;
	}
	if (forward_buff.d_packet.trunk.FrameSeq  == 0x14)
	{
        	next = MultiConnectTablePnt;
        	while (next)
        	{
			multi_sd_queue_check();
                        ret = sendto (multi_sd, &ar_call_next->rf_header, 58, MSG_DONTWAIT,
                                (struct sockaddr *)&next->multi_addr, sizeof(struct sockaddr));
                        if (ret == -1)
                        {
                                time(&atime);
                                fprintf (log_file, "%24.24s fwd->mult (RF header) error %s\n", ctime(&atime), strerror(errno));
                                fflush (log_file);
                        }
			else if (ret != 58)
			{
				time (&atime);
				fprintf (log_file, "%24.24s fwd->mult (RF header) error %d(58)\n", ctime(&atime), ret);
				fflush (log_file);
			}
                        next->out++;
                	next = next->f_chain;
		}
        }
	return TRUE;
}

int	forward_init(void)
{
	time_t	atime;

	if (fwd_port > 0)
	{
    		if((fwd_sd = socket(AF_INET, SOCK_DGRAM, 0)) < 0)
		{
                	time(&atime);
                	fprintf (log_file, "%24.24s Forward  socket not open\n", ctime(&atime));
			fflush (log_file);
        		return FALSE;	
    		}

        	fwd_addr.sin_family = PF_INET;
        	fwd_addr.sin_port = htons(fwd_port);
		if (forward_addr[0] == 0x00)
		{
			memset (forward_addr, 0x00, sizeof(forward_addr));
			memcpy (forward_addr, "127.0.0.1", 9);
		}
		fwd_addr.sin_addr.s_addr = inet_addr(forward_addr);

		FD_SET (fwd_sd, &read_save);

    		// Bind
    		if(bind(fwd_sd, (struct sockaddr *)&fwd_addr, sizeof(fwd_addr)) < 0) {
			time(&atime);
			fprintf (log_file, "%24.24s Forward socket not bind %s\n", 
				ctime(&atime), strerror(errno));
			fflush (log_file);
        		return FALSE;
    		}
	}
	return TRUE;
}

void	multi_connect (void)
{
        int     length;
        time_t  atime;
	struct	MultiConnectTable	*next;
        struct  addrinfo        hints;
        struct  addrinfo        *result, *rp;
        char    PORT[10];
        int     ret;

	len_multi_addr = sizeof(multi_addr);
        length = recvfrom(multi_sd, &multi_buff, sizeof(multi_buff), 0, 
		(struct sockaddr *)&multi_addr, &len_multi_addr);
	time (&atime);
        if (length < 10) {
                fprintf (log_file, "%24.24s Multi forward data Reciv. error\n", ctime(&atime));
		fflush (log_file);
                return;                   // end
        }
	if (!memcmp (multi_buff.d_packet.id, "HPCH", 4))
	{
        	memset (&hints, 0x00, sizeof(struct addrinfo));
        	hints.ai_family = AF_UNSPEC;
        	hints.ai_socktype = SOCK_DGRAM;
        	hints.ai_protocol = UDP;

        	result = NULL;
        	memset (PORT, 0x00, 10);
        	sprintf (PORT, "%d", hole_punch_port);
        	ret = getaddrinfo (hole_punch_server, PORT, &hints, &result);
        	if (ret == 0)
        	{
                	for (rp = result ; rp != NULL ; rp = rp->ai_next)
                	{
                        	if (rp->ai_family == AF_INET)
                        	{
                                        if (((struct sockaddr_in *)(rp->ai_addr))->sin_addr.s_addr 
						== multi_addr.sin_addr.s_addr) 
					{
						freeaddrinfo (result);
						read_hole_punch((char *)&multi_buff, length);
						return;
					}
				}
                        }
			freeaddrinfo (result);
                }
		return;
	}

	if (length < 16) return;

        if ((length == 40) && (multi_buff.d_packet.id[0] == 0x01) && (multi_buff.d_packet.id[1] == 0x03))
        {
                trust_read (length, (unsigned char *)&multi_buff);
                return;
        }
	if (length == 24)
	{
		if (!memcmp (&multi_buff.multi_buffer, "DISCONNECT", 10)) 
		{
			delete_MultiConnectTable (multi_addr);
			return;
		}
		if (!ja_check (&multi_buff.multi_buffer[16])) 
		{
			time(&atime);
			fprintf (log_file, "%24.24s Invalid connect callsign '%8.8s' from %s(%d)\n", 
				ctime(&atime), &multi_buff.multi_buffer[16],
				inet_ntoa (multi_addr.sin_addr), multi_addr.sin_port);
			fflush (log_file);
			send_invalid_call (&multi_buff.multi_buffer[16], multi_addr);
			return;
		}
		next = MultiConnectTablePnt;	// keep alive
		while (next)
		{
			if ((multi_addr.sin_addr.s_addr == next->multi_addr.sin_addr.s_addr) 
				&& (multi_addr.sin_port == next->multi_addr.sin_port))
			{
				time(&next->AccessTime);
				if (next->auth != AUTH_TRUE)
				{
					memcpy (next->auth_callsign, &multi_buff.multi_buffer[16], 8);
					send_inquire(&multi_buff.multi_buffer[16]);
					next->auth = AUTH_WAIT;
					gettimeofday (&next->AuthInquireTime, NULL);
				}
				return;
			}
			next = next->f_chain;
		}
		return;
	}

	if ((length == 58) || (length == 29) || (length == 32))
	{
		if (multi_buff.d_packet.l[0] != 0x00) return;
	    	if (memcmp (multi_buff.d_packet.id, "DSTR", 4)) return;

		if (((length == 58) && (multi_buff.d_packet.l[1] == 0x30))
			|| ((length == 29) && (multi_buff.d_packet.l[1] == 0x13))
			|| ((length == 32) && (multi_buff.d_packet.l[1] == 0x16)))
		{
			if (((multi_buff.d_packet.c & C_MASK) == VOICE)
				|| ((multi_buff.d_packet.c & C_MASK) == POSIT))
			{
				next = MultiConnectTablePnt;
				while (next)
				{
                        		if ((multi_addr.sin_addr.s_addr == next->multi_addr.sin_addr.s_addr)
                                		&& (multi_addr.sin_port == next->multi_addr.sin_port))
					{
						if (next->auth == AUTH_TRUE)
					    	{
							if (length == 58) 
							{
								if (memcmp (next->xmit_callsign, multi_buff.d_packet.body.header.mycall, 8)
									|| (next->xmit != XMIT_TRUE))
								{
									memcpy (next->xmit_callsign, multi_buff.d_packet.body.header.mycall, 8);
									memcpy (next->ar_callsign, multi_buff.d_packet.body.header.rpt1, 8);
									next->xmit = XMIT_WAIT;
									gettimeofday (&next->XmitInquireTime, NULL);
									send_inquire(multi_buff.d_packet.body.header.mycall);
								}
							}	
							putFifo (length, next, multi_buff.multi_buffer);
						}
				    		return;	
					}
					next = next->f_chain;
				}
		    	}
		}
	}
}

void	multi_read(struct MultiConnectTable *nextTable)
{
        int     length;
	int	ret;
        time_t  atime;
        struct  MultiConnectTable       *next;
        struct  area_callsign     *ar_call_next;
	char	zr_save[8];

	length = getFifo (nextTable, multi_buff.multi_buffer);
        if (length == 58)
        {
		if (!mycall2_check (multi_buff.d_packet.body.header.mycall_ex)) return;
		if (!ja_check (multi_buff.d_packet.body.header.mycall)) return;
		if (!ur_call_check(multi_buff.d_packet.body.header.urcall)) return;
		if (!ja_check (multi_buff.d_packet.body.header.rpt1) 
			|| !ja_check (multi_buff.d_packet.body.header.rpt2)) return;
		//if (memcmp (zr_callsign, multi_buff.d_packet.body.header.rpt2, 7))
		//{
		//		if (memcmp (multi_buff.d_packet.body.header.rpt1, multi_buff.d_packet.body.header.rpt2, 7)) return;
		//	memcpy (multi_buff.d_packet.body.header.rpt1, zr_callsign, 8);
		//}
		ar_call_next = ar_callsign_pnt;
                while (ar_call_next)
                {
                       	if (!memcmp (ar_call_next->ar_callsign, multi_buff.d_packet.body.header.rpt1, 8))
                        {
                               	if ((ar_call_next->FrameID[0] == 0x00) && (ar_call_next->FrameID[1] == 0x00))
                                {
                                       	memcpy (ar_call_next->FrameID, multi_buff.d_packet.trunk.FrameID, 2);
					//memcpy (&ar_call_next->addr, &multi_addr, sizeof(struct sockaddr_in));
                                        status_on (multi_buff.d_packet.body.header.rpt1,
						multi_buff.d_packet.body.header.urcall,
						multi_buff.d_packet.body.header.mycall,
						multi_buff.d_packet.body.header.rpt1,
						multi_buff.d_packet.body.header.rpt2);
					time (&ar_call_next->status_time);
					memcpy (ar_call_next->rf_header, &multi_buff, 58);
                                }
				goto send;
                        }
                        ar_call_next = ar_call_next->next;
              	}
		return; 
	}
        else if ((length == 29) || (length == 32))
        {
		if ((multi_buff.d_packet.trunk.FrameSeq & 0x1f) > 0x14) return;
		goto send;
        }
	return;
send:
	ar_call_next = ar_callsign_pnt;
	while (ar_call_next)
	{
		if (!memcmp (ar_call_next->FrameID, multi_buff.d_packet.trunk.FrameID, 2))
		{
			time (&ar_call_next->status_time);
        		multi_buff.d_packet.m[0] = (fwd_send_seq >> 8) & 0xff;
        		multi_buff.d_packet.m[1] = fwd_send_seq & 0xff;
        		fwd_send_seq++;
        		fwd_send_seq &= 0xffff;
			multi_buff.d_packet.c |= FWD;
			if (length == 58)
			{
				memcpy (zr_save, multi_buff.d_packet.body.header.rpt1, 8);
				if (memcmp (zr_callsign, multi_buff.d_packet.body.header.rpt1, 7))
				{
					memcpy (multi_buff.d_packet.body.header.rpt1, zr_callsign, 8);
				}
			}
			ret = sendto (fwd_sd,  &multi_buff, length, MSG_DONTWAIT,
				(struct sockaddr *)&fwd_recv_addr, sizeof(fwd_recv_addr));
                	if (ret == -1)
                	{
                        	time(&atime);
                        	fprintf (log_file, "%24.24s mult->fwd error %s\n", 
					ctime(&atime), strerror(errno));
                        	fflush (log_file);
                	}
			else if (ret != length)
			{
				time (&atime);
				fprintf (log_file, "%24.24s mult->fwd error %d(%d)\n", ctime(&atime), ret, length);
				fflush (log_file);
			}
			memcpy (multi_buff.d_packet.body.header.rpt1, zr_save, 8);
                	multi_buff.d_packet.m[0] = (multi_send_seq >> 8) & 0xff;
                	multi_buff.d_packet.m[1] = multi_send_seq & 0xff;
                	multi_send_seq++;
                	multi_send_seq &= 0xffff;
                	if (multi_buff.d_packet.trunk.FrameSeq  == 0x14)
                	{
                        	ar_call_next->rf_header[4] = (multi_send_seq >> 8) & 0xff;
                        	ar_call_next->rf_header[5] = multi_send_seq & 0xff;
                        	multi_send_seq++;
                        	multi_send_seq &= 0xffff;
                	}
			next = MultiConnectTablePnt;
			while (next)
			{
                        	if ((multi_addr.sin_addr.s_addr != next->multi_addr.sin_addr.s_addr)
                                	|| (multi_addr.sin_port != next->multi_addr.sin_port))
				{
					multi_sd_queue_check();
					ret = sendto (multi_sd, &multi_buff, length, MSG_DONTWAIT,
						(struct sockaddr *)&next->multi_addr,
				 		sizeof(struct sockaddr));
                			if (ret == -1)
                			{
                        			time(&atime);
                        			fprintf (log_file, "%24.24s mult error %s\n", ctime(&atime), strerror(errno));
                        			fflush (log_file);
                			}
					else if (ret != length)
					{
						time(&atime);
						fprintf (log_file, "%24.24s mult error %d(%d)\n", ctime(&atime), ret, length);
						fflush (log_file);
					}
					next->out++;
				}
				else
				{
					next->in++;
					if (multi_buff.d_packet.c & GW) next->gw++;
					if (multi_buff.d_packet.c & ZR) next->zr++;
				}
				next = next->f_chain;
			}
                        next = MultiConnectTablePnt;
                        while (next)
                        {
                        	if ((multi_addr.sin_addr.s_addr != next->multi_addr.sin_addr.s_addr)
                                	|| (multi_addr.sin_port != next->multi_addr.sin_port))
                                {
                                        if ((multi_buff.d_packet.trunk.FrameSeq == 0x14) && ar_call_next)
                                        {
						multi_sd_queue_check();
                                                ret = sendto (multi_sd, &ar_call_next->rf_header, 58, MSG_DONTWAIT,
                                                        (struct sockaddr *)&next->multi_addr, sizeof(struct sockaddr));
                                                if (ret == -1)
                                                {
                                                        time(&atime);
                                                        fprintf (log_file, "%24.24s mult(RF header) error %s\n", ctime(&atime), strerror(errno));
                                                        fflush (log_file);
                                                }
						else if (ret != 58)
						{
							time (&atime);
							fprintf (log_file, "%24.24s mult(RF header) error %d(58)\n", ctime(&atime), ret);
							fflush (log_file);
						}
                                                next->out++;
                                        }
                                }
                                next = next->f_chain;
                        }
			if (multi_buff.d_packet.trunk.FrameSeq & 0x40)
                        {
                               	status_off (ar_call_next->ar_callsign);
                                memset (ar_call_next->FrameID, 0x00, 2);
                        }
			return;
		}	
		ar_call_next = ar_call_next->next;
	}
    	return;
}
