/***************************************************************
 * MPFSImg2.c
 * Defines an MPFS2 image to be stored in program memory.
 *
 * NOT FOR HAND MODIFICATION
 * This file is automatically generated by the MPFS2 Utility
 * ALL MODIFICATIONS WILL BE OVERWRITTEN BY THE MPFS2 GENERATOR
 * Generated  8 13 2012 04:15:07 
 ***************************************************************/

#define __MPFSIMG2_C

#include "TCPIPConfig.h"
#if !defined(MPFS_USE_EEPROM) && !defined(MPFS_USE_SPI_FLASH)

#include "TCPIP Stack/TCPIP.h"
#if defined(STACK_USE_MPFS2)


/**************************************
 * MPFS2 Image Data
 **************************************/
#define DATACHUNK000000 \
	0x4d,0x50,0x46,0x53,0x02,0x01,0x2e,0x00,0x6a,0x55,0x5e,0x2a,0xea,0x87,0xff,0xff, /* MPFS....jU^..... */ \
	0xaa,0xcf,0xff,0xff,0x26,0x4f,0x26,0x2d,0x0a,0xa3,0xff,0xff,0x8a,0x24,0xff,0xff, /* ....&O&-.....$.. */ \
	0x6a,0x83,0xff,0xff,0xea,0x72,0xff,0xff,0x4a,0xe3,0xff,0xff,0x6a,0xe3,0xff,0xff, /* j....r..J...j... */ \
	0x6a,0x6b,0xff,0xff,0xea,0x92,0xff,0xff,0xea,0x3c,0xff,0xff,0xaa,0xa5,0xff,0xff, /* jk.......<...... */ \
	0x8a,0x96,0xff,0xff,0xca,0x21,0xff,0xff,0x8a,0x9e,0xff,0xff,0x4a,0x8c,0xff,0xff, /* .....!......J... */ \
	0x0a,0x4f,0xff,0xff,0x26,0xb6,0xff,0xff,0x8a,0xb6,0xff,0xff,0xea,0xd2,0xff,0xff, /* .O..&........... */ \
	0xca,0xb4,0xff,0xff,0x58,0x04,0x00,0x00,0x12,0x06,0x00,0x00,0xda,0x03,0x00,0x00, /* ....X........... */ \
	0x74,0x78,0x44,0x4f,0x00,0x00,0x00,0x00,0x01,0x00,0x63,0x04,0x00,0x00,0xec,0x09, /* txDO......c..... */ \
	0x00,0x00,0xb2,0x05,0x00,0x00,0x8c,0x47,0x0a,0x4f,0x00,0x00,0x00,0x00,0x01,0x00, /* .......G.O...... */ \
	0x6d,0x04,0x00,0x00,0x9e,0x0f,0x00,0x00,0x23,0x08,0x00,0x00,0x8d,0xf0,0x09,0x50, /* m.......#......P */ \
	0x00,0x00,0x00,0x00,0x02,0x00,0x79,0x04,0x00,0x00,0xc1,0x17,0x00,0x00,0x48,0x00, /* ......y.......H. */ \
	0x00,0x00,0x8d,0xf0,0x09,0x50,0x00,0x00,0x00,0x00,0x00,0x00,0x7a,0x04,0x00,0x00, /* .....P......z... */ \
	0x09,0x18,0x00,0x00,0xf2,0x07,0x00,0x00,0x71,0xf0,0x09,0x50,0x00,0x00,0x00,0x00, /* ........q..P.... */ \
	0x02,0x00,0x83,0x04,0x00,0x00,0xfb,0x1f,0x00,0x00,0x68,0x00,0x00,0x00,0x71,0xf0, /* ..........h...q. */ \
	0x09,0x50,0x00,0x00,0x00,0x00,0x00,0x00,0x84,0x04,0x00,0x00,0x63,0x20,0x00,0x00, /* .P..........c .. */ \
	0x9f,0x00,0x00,0x00,0x8c,0x47,0x0a,0x4f,0x00,0x00,0x00,0x00,0x00,0x00,0x8f,0x04, /* .....G.O........ */ \
	0x00,0x00,0x02,0x21,0x00,0x00,0xb4,0x07,0x00,0x00,0x25,0x91,0x22,0x50,0x00,0x00, /* ...!......%."P.. */ \
	0x00,0x00,0x00,0x00,0x9a,0x04,0x00,0x00,0xb6,0x28,0x00,0x00,0x63,0x06,0x00,0x00, /* .........(..c... */ \
	0x5f,0x16,0x0a,0x50,0x00,0x00,0x00,0x00,0x02,0x00,0xa4,0x04,0x00,0x00,0x19,0x2f, /* _..P.........../ */ \
	0x00,0x00,0x88,0x00,0x00,0x00,0x5f,0x16,0x0a,0x50,0x00,0x00,0x00,0x00,0x00,0x00, /* ......_..P...... */ \
	0xa5,0x04,0x00,0x00,0xa1,0x2f,0x00,0x00,0x13,0x06,0x00,0x00,0xea,0xa8,0x28,0x50, /* ...../........(P */ \
	0x00,0x00,0x00,0x00,0x02,0x00,0xb3,0x04,0x00,0x00,0xb4,0x35,0x00,0x00,0x50,0x00, /* ...........5..P. */ \
	0x00,0x00,0xea,0xa8,0x28,0x50,0x00,0x00,0x00,0x00,0x00,0x00,0xb4,0x04,0x00,0x00, /* ....(P.......... */ \
	0x04,0x36,0x00,0x00,0x4c,0x0b,0x00,0x00,0x0e,0x61,0x09,0x50,0x00,0x00,0x00,0x00, /* .6..L....a.P.... */ \
	0x02,0x00,0xbf,0x04,0x00,0x00,0x50,0x41,0x00,0x00,0x98,0x00,0x00,0x00,0x0e,0x61, /* ......PA.......a */ \
	0x09,0x50,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x04,0x00,0x00,0xe8,0x41,0x00,0x00, /* .P...........A.. */ \
	0xf6,0x08,0x00,0x00,0x38,0xf0,0x09,0x50,0x00,0x00,0x00,0x00,0x02,0x00,0xd7,0x04, /* ....8..P........ */ \
	0x00,0x00,0xde,0x4a,0x00,0x00,0x80,0x00,0x00,0x00,0x38,0xf0,0x09,0x50,0x00,0x00, /* ...J......8..P.. */ \
	0x00,0x00,0x00,0x00,0xd8,0x04,0x00,0x00,0x5e,0x4b,0x00,0x00,0x7a,0x02,0x00,0x00, /* ........^K..z... */ \
	0x42,0x5d,0x16,0x4f,0x00,0x00,0x00,0x00,0x02,0x00,0xf0,0x04,0x00,0x00,0xd8,0x4d, /* B].O...........M */ \
	0x00,0x00,0x28,0x00,0x00,0x00,0x42,0x5d,0x16,0x4f,0x00,0x00,0x00,0x00,0x00,0x00, /* ..(...B].O...... */ \
	0xf1,0x04,0x00,0x00,0x00,0x4e,0x00,0x00,0x52,0x0a,0x00,0x00,0x8c,0x47,0x0a,0x4f, /* .....N..R....G.O */ \
	0x00,0x00,0x00,0x00,0x02,0x00,0x09,0x05,0x00,0x00,0x52,0x58,0x00,0x00,0xb0,0x00, /* ..........RX.... */ \
	0x00,0x00,0x8c,0x47,0x0a,0x4f,0x00,0x00,0x00,0x00,0x00,0x00,0x0a,0x05,0x00,0x00, /* ...G.O.......... */ \
	0x02,0x59,0x00,0x00,0x2f,0x02,0x00,0x00,0xc2,0x8a,0x61,0x4f,0x00,0x00,0x00,0x00, /* .Y../.....aO.... */ \
	0x02,0x00,0x1d,0x05,0x00,0x00,0x31,0x5b,0x00,0x00,0x20,0x00,0x00,0x00,0xc2,0x8a, /* ......1[.. ..... */ \
	0x61,0x4f,0x00,0x00,0x00,0x00,0x00,0x00,0x1e,0x05,0x00,0x00,0x51,0x5b,0x00,0x00, /* aO..........Q[.. */ \
	0xfa,0x0e,0x00,0x00,0x91,0x45,0x28,0x50,0x00,0x00,0x00,0x00,0x02,0x00,0x31,0x05, /* .....E(P......1. */ \
	0x00,0x00,0x4b,0x6a,0x00,0x00,0xc8,0x00,0x00,0x00,0x91,0x45,0x28,0x50,0x00,0x00, /* ..Kj.......E(P.. */ \
	0x00,0x00,0x00,0x00,0x32,0x05,0x00,0x00,0x13,0x6b,0x00,0x00,0xac,0x01,0x00,0x00, /* ....2....k...... */ \
	0xa9,0xf0,0x09,0x50,0x00,0x00,0x00,0x00,0x02,0x00,0x44,0x05,0x00,0x00,0xbf,0x6c, /* ...P......D....l */ \
	0x00,0x00,0x18,0x00,0x00,0x00,0xa9,0xf0,0x09,0x50,0x00,0x00,0x00,0x00,0x00,0x00, /* .........P...... */ \
	0x45,0x05,0x00,0x00,0xd7,0x6c,0x00,0x00,0xed,0x0d,0x00,0x00,0xcf,0xf0,0x09,0x50, /* E....l.........P */ \
	0x00,0x00,0x00,0x00,0x02,0x00,0x56,0x05,0x00,0x00,0xc4,0x7a,0x00,0x00,0xb8,0x00, /* ......V....z.... */ \
	0x00,0x00,0xcf,0xf0,0x09,0x50,0x00,0x00,0x00,0x00,0x00,0x00,0x57,0x05,0x00,0x00, /* .....P......W... */ \
	0x7c,0x7b,0x00,0x00,0x54,0x19,0x00,0x00,0x85,0xe7,0x6f,0x4f,0x00,0x00,0x00,0x00, /* |{..T.....oO.... */ \
	0x02,0x00,0x6c,0x05,0x00,0x00,0xd0,0x94,0x00,0x00,0x10,0x00,0x00,0x00,0x85,0xe7, /* ..l............. */ \
	0x6f,0x4f,0x00,0x00,0x00,0x00,0x00,0x00,0x6d,0x05,0x00,0x00,0xe0,0x94,0x00,0x00, /* oO......m....... */ \
	0x5b,0x02,0x00,0x00,0x90,0x8a,0x61,0x4f,0x00,0x00,0x00,0x00,0x02,0x00,0x85,0x05, /* [.....aO........ */ \
	0x00,0x00,0x3b,0x97,0x00,0x00,0x20,0x00,0x00,0x00,0x90,0x8a,0x61,0x4f,0x00,0x00, /* ..;... .....aO.. */ \
	0x00,0x00,0x00,0x00,0x86,0x05,0x00,0x00,0x5b,0x97,0x00,0x00,0x6d,0x13,0x00,0x00, /* ........[...m... */ \
	0x66,0xf6,0x42,0x4f,0x00,0x00,0x00,0x00,0x02,0x00,0x97,0x05,0x00,0x00,0xc8,0xaa, /* f.BO............ */ \
	0x00,0x00,0x10,0x00,0x00,0x00,0x66,0xf6,0x42,0x4f,0x00,0x00,0x00,0x00,0x00,0x00, /* ......f.BO...... */ \
	0x98,0x05,0x00,0x00,0xd8,0xaa,0x00,0x00,0xee,0x03,0x00,0x00,0xcc,0x65,0x0a,0x50, /* .............e.P */ \
	0x00,0x00,0x00,0x00,0x02,0x00,0xb0,0x05,0x00,0x00,0xc6,0xae,0x00,0x00,0x28,0x00, /* ..............(. */ \
	0x00,0x00,0xcc,0x65,0x0a,0x50,0x00,0x00,0x00,0x00,0x00,0x00,0xb1,0x05,0x00,0x00, /* ...e.P.......... */ \
	0xee,0xae,0x00,0x00,0xa8,0x03,0x00,0x00,0x8c,0x47,0x0a,0x4f,0x00,0x00,0x00,0x00, /* .........G.O.... */ \
	0x02,0x00,0xc3,0x05,0x00,0x00,0x96,0xb2,0x00,0x00,0x18,0x00,0x00,0x00,0x8c,0x47, /* ...............G */ \
	0x0a,0x4f,0x00,0x00,0x00,0x00,0x00,0x00,0xc4,0x05,0x00,0x00,0xae,0xb2,0x00,0x00, /* .O.............. */ \
	0x08,0x00,0x00,0x00,0x8c,0x47,0x0a,0x4f,0x00,0x00,0x00,0x00,0x02,0x00,0xd7,0x05, /* .....G.O........ */ \
	0x00,0x00,0xb6,0xb2,0x00,0x00,0x08,0x00,0x00,0x00,0x8c,0x47,0x0a,0x4f,0x00,0x00, /* ...........G.O.. */ \
	0x00,0x00,0x00,0x00,0xd8,0x05,0x00,0x00,0xbe,0xb2,0x00,0x00,0x47,0x02,0x00,0x00, /* ............G... */ \
	0xa4,0x82,0x43,0x4f,0x00,0x00,0x00,0x00,0x02,0x00,0xeb,0x05,0x00,0x00,0x05,0xb5, /* ..CO............ */ \
	0x00,0x00,0x28,0x00,0x00,0x00,0xa4,0x82,0x43,0x4f,0x00,0x00,0x00,0x00,0x00,0x00  /* ..(.....CO...... */
#define DATACHUNK000001 \
	0xec,0x05,0x00,0x00,0x2d,0xb5,0x00,0x00,0x20,0x02,0x00,0x00,0xd0,0x43,0x51,0x4f, /* ....-... ....CQO */ \
	0x00,0x00,0x00,0x00,0x02,0x00,0xff,0x05,0x00,0x00,0x4d,0xb7,0x00,0x00,0x18,0x00, /* ..........M..... */ \
	0x00,0x00,0xd0,0x43,0x51,0x4f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x00,0x00, /* ...CQO.......... */ \
	0x65,0xb7,0x00,0x00,0x75,0x03,0x00,0x00,0xa8,0xf3,0x1d,0x4f,0x00,0x00,0x00,0x00, /* e...u......O.... */ \
	0x02,0x00,0x11,0x06,0x00,0x00,0xda,0xba,0x00,0x00,0x30,0x00,0x00,0x00,0xa8,0xf3, /* ..........0..... */ \
	0x1d,0x4f,0x00,0x00,0x00,0x00,0x00,0x00,0x37,0x6d,0x33,0x74,0x6a,0x7a,0x2e,0x63, /* .O......7m3tjz.c */ \
	0x73,0x73,0x00,0x37,0x6d,0x33,0x74,0x6a,0x7a,0x2e,0x6a,0x73,0x00,0x61,0x70,0x72, /* ss.7m3tjz.js.apr */ \
	0x73,0x6d,0x73,0x67,0x2e,0x68,0x74,0x6d,0x00,0x00,0x64,0x70,0x72,0x73,0x2e,0x68, /* smsg.htm..dprs.h */ \
	0x74,0x6d,0x00,0x00,0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e,0x63,0x00,0x68, /* tm..footer.inc.h */ \
	0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63,0x00,0x69,0x6e,0x64,0x65,0x78,0x2e, /* eader.inc.index. */ \
	0x68,0x74,0x6d,0x00,0x00,0x72,0x65,0x66,0x73,0x65,0x6c,0x65,0x63,0x74,0x2e,0x68, /* htm..refselect.h */ \
	0x74,0x6d,0x00,0x00,0x73,0x74,0x61,0x74,0x75,0x73,0x2e,0x68,0x74,0x6d,0x00,0x00, /* tm..status.htm.. */ \
	0x6e,0x6f,0x64,0x65,0x61,0x64,0x61,0x70,0x74,0x65,0x72,0x2f,0x63,0x6f,0x6e,0x66, /* nodeadapter/conf */ \
	0x69,0x67,0x2e,0x68,0x74,0x6d,0x00,0x00,0x6e,0x6f,0x64,0x65,0x61,0x64,0x61,0x70, /* ig.htm..nodeadap */ \
	0x74,0x65,0x72,0x2f,0x63,0x6f,0x6e,0x66,0x69,0x67,0x32,0x2e,0x68,0x74,0x6d,0x00, /* ter/config2.htm. */ \
	0x00,0x6e,0x6f,0x64,0x65,0x61,0x64,0x61,0x70,0x74,0x65,0x72,0x2f,0x63,0x6f,0x6e, /* .nodeadapter/con */ \
	0x66,0x69,0x67,0x33,0x2e,0x68,0x74,0x6d,0x00,0x00,0x70,0x72,0x6f,0x74,0x65,0x63, /* fig3.htm..protec */ \
	0x74,0x2f,0x61,0x63,0x63,0x65,0x73,0x73,0x2e,0x68,0x74,0x6d,0x00,0x00,0x70,0x72, /* t/access.htm..pr */ \
	0x6f,0x74,0x65,0x63,0x74,0x2f,0x63,0x6f,0x6e,0x66,0x69,0x67,0x2e,0x68,0x74,0x6d, /* otect/config.htm */ \
	0x00,0x00,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x64,0x65,0x62,0x75,0x67,0x2e, /* ..protect/debug. */ \
	0x68,0x74,0x6d,0x00,0x00,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x64,0x70,0x72, /* htm..protect/dpr */ \
	0x73,0x2e,0x68,0x74,0x6d,0x00,0x00,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x64, /* s.htm..protect/d */ \
	0x70,0x72,0x73,0x65,0x64,0x69,0x74,0x2e,0x68,0x74,0x6d,0x00,0x00,0x70,0x72,0x6f, /* prsedit.htm..pro */ \
	0x74,0x65,0x63,0x74,0x2f,0x44,0x70,0x72,0x73,0x4d,0x73,0x67,0x43,0x74,0x72,0x6c, /* tect/DprsMsgCtrl */ \
	0x2e,0x68,0x74,0x6d,0x00,0x00,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x65,0x64, /* .htm..protect/ed */ \
	0x69,0x74,0x2e,0x68,0x74,0x6d,0x00,0x00,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f, /* it.htm..protect/ */ \
	0x67,0x61,0x74,0x65,0x77,0x61,0x79,0x61,0x75,0x74,0x68,0x2e,0x68,0x74,0x6d,0x00, /* gatewayauth.htm. */ \
	0x00,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x69,0x6e,0x64,0x65,0x78,0x2e,0x68, /* .protect/index.h */ \
	0x74,0x6d,0x00,0x00,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x72,0x65,0x62,0x6f, /* tm..protect/rebo */ \
	0x6f,0x74,0x2e,0x63,0x67,0x69,0x00,0x00,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f, /* ot.cgi..protect/ */ \
	0x72,0x65,0x62,0x6f,0x6f,0x74,0x2e,0x68,0x74,0x6d,0x00,0x00,0x70,0x72,0x6f,0x74, /* reboot.htm..prot */ \
	0x65,0x63,0x74,0x2f,0x75,0x70,0x64,0x61,0x74,0x65,0x2e,0x68,0x74,0x6d,0x00,0x00, /* ect/update.htm.. */ \
	0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x75,0x73,0x65,0x72,0x2e,0x68,0x74,0x6d, /* protect/user.htm */ \
	0x00,0x00,0x1f,0x8b,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xd5,0x57,0x4d,0x6f, /* .............WMo */ \
	0xdb,0x38,0x10,0x3d,0x27,0x80,0xff,0x83,0x80,0x5c,0x23,0x43,0x1f,0x96,0xdb,0x2a, /* .8.='....\#C.... */ \
	0xa7,0xc5,0x9e,0xb7,0xc7,0xbd,0x53,0xe2,0xd0,0x22,0x42,0x8b,0x02,0x45,0xd5,0x6e, /* ......S.."B..E.n */ \
	0x8b,0xfe,0xf7,0x25,0x29,0x4a,0xa4,0x24,0x3a,0x69,0xda,0x00,0x8b,0x42,0x40,0x1b, /* ...%)J.$:i...B@. */ \
	0x53,0x9c,0x79,0x8f,0x6f,0x3e,0x38,0xaa,0x38,0xfe,0x1a,0x7d,0xdf,0xdd,0xdf,0x11, /* S.y.o>8.8..}.... */ \
	0xde,0xca,0x98,0xa0,0x33,0x65,0x5f,0xcb,0xe8,0x5f,0x10,0x18,0xb5,0xe8,0x31,0xfa, /* ....3e_.._....1. */ \
	0x4b,0x50,0xc4,0x1e,0xa3,0x1e,0xb5,0x7d,0xdc,0x83,0xa0,0xe4,0x49,0x6d,0xad,0x50, /* KP.....}....Im.P */ \
	0xfd,0x7c,0x12,0x7c,0x68,0x71,0x19,0x3d,0x14,0x95,0x7e,0xf4,0xf2,0x19,0x89,0x13, /* .|.|hq.=..~..... */ \
	0x6d,0xcb,0x28,0xe9,0xae,0x11,0x1a,0x24,0xd7,0x6b,0x1d,0xc2,0x98,0xb6,0x27,0xb5, /* m.(....$.k....'. */ \
	0xa8,0x9e,0x4c,0xbf,0x49,0xd4,0xf2,0x8f,0xdd,0xfd,0xee,0xfe,0xa1,0x6f,0x10,0xe6, /* ..L.I........o.. */ \
	0x97,0x98,0xb7,0x60,0x08,0x5c,0x28,0x96,0x4d,0x19,0x7d,0x38,0xaa,0x5d,0x06,0x85, /* ...`.\(.M.}8.].. */ \
	0x0b,0x0c,0xa2,0x8c,0x52,0x65,0xd4,0x73,0x46,0xb1,0xc2,0x2a,0x0a,0xf7,0x26,0x96, /* ....Re.sF.....&. */ \
	0xbc,0x2b,0x8d,0xbb,0x10,0xf2,0x0f,0x07,0x20,0x2f,0xdc,0x00,0x04,0x1c,0x1e,0x2a, /* .+...... /...... */ \
	0xfd,0x84,0x7c,0xfa,0xf6,0x8d,0x00,0xb8,0xe9,0xe1,0x70,0x78,0xc5,0x9c,0xf0,0x41, /* ..|.......px...A */ \
	0xdc,0xb2,0xce,0x91,0x7e,0x6e,0x38,0x50,0x2e,0x3a,0x74,0xba,0x89,0x9c,0xe7,0xf9, /* ....~n8P.:t..... */ \
	0x26,0x18,0x84,0x90,0xa0,0x40,0x73,0x18,0x32,0x2b,0xae,0x89,0x76,0x4f,0xbf,0x81, /* &....@s.2+..vO.. */ \
	0x72,0x99,0x74,0x72,0x09,0x28,0xb1,0xcb,0x88,0xc0,0x1e,0x49,0x25,0xb3,0xac,0x7c, /* r.tr.(.....I%..| */ \
	0xec,0x24,0x21,0x64,0xa4,0x34,0xa3,0x1d,0x3c,0xb0,0x0b,0xd0,0x53,0x23,0xcb,0xa8, /* .$!d.4..<...S#.. */ \
	0xe2,0x0c,0xeb,0xc5,0x9a,0x33,0x2e,0x1c,0xe5,0x31,0x84,0x71,0xc5,0xa5,0xe4,0x67, /* .....3...1.q...g */ \
	0x05,0x58,0x8c,0xa6,0x8d,0xb5,0x4a,0x8f,0xe6,0xb7,0x4f,0x60,0x2f,0xf4,0xab,0x91, /* .X....J...O`/... */ \
	0x29,0xe3,0x48,0x6d,0x32,0x0b,0x4f,0x2e,0x95,0x0e,0x89,0x3d,0xad,0x84,0xab,0x8c, /* ).Hm2.O....=.... */ \
	0x11,0xa3,0xa7,0xd6,0x6d,0x1a,0x5d,0x9d,0xa1,0x1d,0x7c,0x17,0x0c,0x88,0xef,0x21, /* ....m.]...|....! */ \
	0x2d,0xac,0x07,0x7b,0xa4,0x58,0x8c,0x74,0xac,0x8c,0x9e,0x0f,0xe4,0xe7,0x70,0x7a, /* -..{.X.t......pz */ \
	0xb0,0x66,0x98,0xf6,0x1d,0x43,0xaa,0xa0,0x2a,0xc6,0xeb,0xe7,0x4d,0xb8,0x9c,0x64, /* .f...C......M..d */ \
	0x56,0x8d,0x4b,0x43,0x25,0x2c,0x24,0xfc,0xf8,0x82,0x84,0x36,0xcc,0xb3,0x66,0x2e, /* V.KC%,$....6..f. */ \
	0x37,0xac,0xa8,0xe6,0xdc,0x18,0x6a,0x2e,0x90,0xa4,0x5c,0x1d,0xbe,0x55,0xc5,0xb6, /* 7.....j...\..U.. */ \
	0xe2,0x5d,0x36,0xfc,0x0b,0x88,0x6d,0x38,0xb1,0x21,0x66,0x05,0x57,0x05,0xf0,0x8f, /* .]6...m8.!f.W... */ \
	0xda,0x9d,0xfe,0xae,0x54,0xce,0xd1,0x2f,0xeb,0x55,0xd7,0xff,0x97,0x5e,0x1e,0xf9, /* ....T../.U...^.. */ \
	0xb7,0x88,0x96,0xbd,0x97,0x68,0xd9,0x9f,0x2c,0x5a,0xf6,0x36,0xd1,0xf2,0xf7,0x12, /* .....h..,Z.6.... */ \
	0x2d,0xff,0x93,0x45,0xcb,0x7f,0x4a,0x34,0x65,0x50,0x2b,0x12,0xd0,0x4a,0xff,0xa4, /* -..E..J4eP+..J.. */ \
	0x45,0x66,0x5b,0xe8,0xba,0x39,0xae,0x54,0x4b,0x7d,0xd5,0x26,0x3f,0xa3,0x66,0x53  /* Ef[..9.TK}.&?.fS */
#define DATACHUNK000002 \
	0x8b,0xae,0x93,0xe4,0x75,0xce,0xb3,0xa9,0xc7,0x78,0x72,0x30,0x92,0xdd,0x3a,0x50, /* ....u....xr0..:P */ \
	0x47,0x01,0xc1,0x68,0xc0,0x4b,0x33,0xb6,0x1a,0x7b,0x2b,0x8c,0x17,0x99,0xe3,0xb9, /* G..h.K3..{+..... */ \
	0xef,0x3b,0x54,0x4f,0x18,0x0c,0x90,0xd0,0xca,0xcb,0x66,0xf6,0x42,0x38,0x97,0xf6, /* .;TO......f.B8.. */ \
	0xb5,0x77,0x89,0x25,0xfb,0x8f,0x70,0xf6,0xaf,0x9e,0xe3,0xf1,0xb8,0xbe,0x1d,0x6a, /* .w.%..p........j */ \
	0x05,0x0e,0xc2,0x9f,0x29,0xb4,0x3e,0x51,0x61,0x26,0x97,0x68,0x9d,0x78,0x86,0x57, /* ....).>Qa&.h.x.W */ \
	0xba,0x98,0x57,0xec,0x9a,0xda,0x8e,0x55,0xf0,0x01,0x4f,0x28,0x76,0xe4,0x91,0x48, /* ..W....U..O(v..H */ \
	0x0e,0xfd,0x22,0x21,0x3f,0xbc,0x1c,0x26,0xe7,0xdf,0x27,0xb4,0x9e,0x8f,0x96,0x58, /* .."!?..&..'....X */ \
	0xc1,0x9c,0x5c,0x10,0xe8,0x0c,0x85,0x19,0xa2,0x18,0x4f,0xa7,0xfe,0x4d,0xfd,0x1b, /* ..\.......O..M.. */ \
	0x93,0xaa,0xf0,0xb4,0xca,0x43,0xbc,0xa6,0x30,0x0f,0x28,0x7b,0xb8,0xa2,0x73,0xc7, /* .....C..0.({..s. */ \
	0xa0,0xe2,0x57,0x2f,0x5e,0xa5,0xd1,0x4c,0x57,0x5a,0x34,0xff,0x15,0x2a,0x9d,0xd0, /* ..W/^..LWZ4..... */ \
	0x09,0x72,0x2f,0x55,0xc6,0x98,0xb8,0x90,0x78,0x05,0xf0,0x80,0xf1,0x7c,0xa8,0x7d, /* .r/U....x....|.} */ \
	0xcd,0x31,0x6c,0x67,0xd8,0xbf,0xd5,0xdc,0x45,0x55,0x16,0x7c,0x86,0xcb,0xe3,0xf4, /* .1lg....EU.|.... */ \
	0xe3,0x31,0x22,0xf4,0x0a,0x38,0x36,0xe2,0xdb,0x1f,0xde,0x59,0x40,0xd4,0xb4,0x0f, /* .1"..86....Y@... */ \
	0x8c,0x36,0x04,0x3e,0x3d,0xad,0xf4,0xf2,0x66,0x16,0xdd,0x9e,0x36,0x69,0x30,0x2e, /* .6.>=...f...6i0. */ \
	0x66,0xae,0xf0,0xa1,0xca,0x1d,0x92,0x10,0x5c,0xf8,0x09,0xbe,0x74,0xb1,0x09,0xfd, /* f.......\...t... */ \
	0x92,0x0c,0xc6,0x2f,0xe1,0x7c,0x4a,0xdc,0xf8,0x38,0x57,0xd3,0xd1,0x1b,0x22,0xbd, /* .../.|J..8W...". */ \
	0x0c,0x45,0x7d,0xe3,0x69,0x3e,0x27,0x58,0xb1,0xa2,0x91,0xac,0x66,0x31,0xaf,0x10, /* .E}.i>'X....f1.. */ \
	0xbd,0xf8,0xdb,0xa9,0xd1,0x8b,0xdc,0xd4,0xb7,0xd7,0x1d,0xa7,0x70,0x0e,0x08,0x05, /* ............p... */ \
	0x86,0x7b,0x90,0xef,0x9b,0x3d,0x37,0x12,0x65,0x06,0xc3,0xf4,0xcb,0xb2,0x00,0xb4, /* .{...=7.e....... */ \
	0x7e,0x1a,0x4b,0xff,0x3f,0x5d,0x2f,0x5b,0x13,0x86,0x2a,0x60,0xdb,0xb0,0xc5,0xe9, /* ~.K.?]/[...`.... */ \
	0x21,0xd4,0x17,0xb2,0x71,0x6d,0xaa,0xf3,0xe9,0xb3,0x26,0x78,0x5f,0x74,0xbc,0xa7, /* !...qm....&x_t.. */ \
	0x63,0x4b,0x44,0x95,0x8a,0xe3,0x20,0x61,0x43,0x80,0xb6,0xdd,0x20,0xb7,0xe0,0x53, /* cKD... aC... ..S */ \
	0x4b,0x9a,0x60,0xb2,0x10,0x79,0x63,0xbb,0xef,0xcf,0x7e,0xe3,0x71,0xdf,0x49,0x9b, /* K.`..yc...~.q.I. */ \
	0x8d,0x08,0xa7,0x81,0x9d,0x8b,0x3e,0x69,0x43,0xbb,0xb4,0xae,0x06,0x75,0xdd,0xb5, /* ......>iC....u.. */ \
	0xda,0xbc,0x7a,0xcd,0x7e,0x31,0x85,0xcf,0x0e,0xf4,0x0e,0x24,0x60,0x71,0x63,0x67, /* ..z.~1.....$`qcg */ \
	0xc1,0x70,0x4c,0x44,0xf3,0x10,0x90,0xf7,0x39,0xf8,0x22,0xee,0x5e,0x40,0x3f,0x30, /* .pLD....9.".^@?0 */ \
	0xb9,0xbb,0xff,0xbe,0x5b,0xf5,0xfb,0xb7,0x65,0xdf,0xf2,0x83,0x2c,0x7c,0x9d,0x84, /* ....[...e...,|.. */ \
	0xc7,0x04,0xbf,0xae,0x01,0xe6,0xa0,0xdf,0xed,0xf9,0xb3,0x39,0xd8,0x54,0xb2,0xf3, /* ...........9.T.. */ \
	0x8d,0x55,0x99,0xfe,0xbe,0x32,0x24,0x66,0x30,0x51,0x96,0x77,0xda,0x94,0x20,0xca, /* .U...2$f0Q.w.. . */ \
	0x82,0xc6,0xd5,0x31,0x60,0x4c,0x60,0x61,0x3c,0xb4,0x61,0xe0,0xba,0x0e,0xd9,0x12, /* ...1`L`a<.a..... */ \
	0x6c,0x6d,0xff,0x03,0x23,0xf3,0xfb,0x9f,0x46,0x10,0x00,0x00,0x1f,0x8b,0x08,0x00, /* lm..#...F....... */ \
	0x00,0x00,0x00,0x00,0x00,0x00,0xcd,0x57,0x4d,0x6f,0xdb,0x46,0x10,0x3d,0x93,0xbf, /* .......WMo.F.=.. */ \
	0x62,0xaa,0x43,0x4c,0x01,0xb2,0x2c,0x07,0x4d,0x0f,0x31,0x94,0xc2,0xb1,0x83,0xd6, /* b.CL..,.M.1..... */ \
	0x85,0x53,0x1b,0xb6,0x52,0x04,0x68,0x7b,0x58,0x93,0x23,0x6b,0x63,0x8a,0xcb,0xec, /* .S..R.h{X.#kc... */ \
	0x2e,0xa5,0x08,0x81,0x7f,0x50,0xff,0x65,0xdf,0x2c,0x3f,0x44,0x2b,0x4e,0xda,0x22, /* .....P.e.,?D+N." */ \
	0x39,0xd4,0x07,0x4b,0xe4,0xec,0xbe,0x9d,0x7d,0xf3,0xe6,0x43,0x07,0x07,0x74,0x62, /* 9..K....}..C..tb */ \
	0xca,0x8d,0xd5,0xb7,0x0b,0x4f,0x7f,0xd1,0xd3,0xc9,0xe4,0xe9,0xfe,0xd3,0xc9,0xe1, /* .....O.......... */ \
	0x84,0x5e,0xeb,0xd4,0x9a,0x74,0xa1,0x4b,0x9a,0x71,0xba,0x28,0x4c,0x6e,0x6e,0x37, /* .^...t.K.q.(Lnn7 */ \
	0x74,0x56,0xa4,0x63,0xa2,0xe3,0x3c,0xa7,0xb0,0xc1,0x91,0x65,0xc7,0x76,0xc5,0xd9, /* tV.c..<....e.v.. */ \
	0x38,0x3e,0x38,0xa0,0x6b,0xe6,0xfe,0xb6,0x93,0xcb,0x83,0xb3,0x4b,0xba,0xf6,0x2a, /* 8>8.k.......K... */ \
	0xbd,0xa3,0xcc,0xa4,0xd5,0x92,0x0b,0xaf,0xbc,0x36,0x05,0xcd,0x8d,0xa5,0x5c,0xa7, /* .........6....\. */ \
	0x5c,0x38,0x26,0x5d,0xe0,0x69,0x19,0xde,0x8f,0xe3,0x58,0x60,0x4e,0xd9,0xb3,0x5d, /* \8&].i....X`N..] */ \
	0xea,0x82,0x1d,0xad,0x17,0x5c,0x90,0xc2,0x29,0xef,0x2b,0x76,0x9e,0xb4,0xa3,0xd4, /* .....\..).+v.... */ \
	0x14,0x4e,0x67,0x6c,0x39,0xa3,0x81,0xd7,0x4b,0x7c,0x98,0xca,0x0f,0xe2,0x95,0xb2, /* .Ngl9...K|...... */ \
	0x24,0x8f,0x17,0x95,0x7f,0x7d,0x4d,0x53,0x7a,0x36,0x99,0x4c,0x8e,0xe8,0xe0,0x60, /* $....}MSz6.L...` */ \
	0xe9,0x62,0x0a,0xae,0x79,0x03,0x57,0x01,0x05,0xa0,0x8a,0xc9,0xcc,0xe9,0xf8,0x97, /* .b..y.W......... */ \
	0xe3,0xb7,0xc4,0x2b,0xf8,0xe4,0xc8,0x1b,0x2a,0xe1,0x35,0x3b,0x17,0x80,0xd4,0x3b, /* ...+......5;...; */ \
	0xf5,0xe1,0x5c,0xe3,0xbc,0x29,0x15,0xbc,0xa6,0x63,0x6b,0xd5,0x26,0x19,0x1e,0x05, /* ..\..)...ck.&... */ \
	0xe7,0xce,0x0a,0xed,0xb5,0xf2,0x01,0x2b,0x18,0x05,0x26,0x35,0xcb,0xa5,0x2a,0x32, /* .......+..&5...2 */ \
	0xd8,0xa3,0xca,0xe6,0xcf,0xc9,0x2f,0x98,0xf0,0x45,0x70,0x55,0x1a,0x60,0x61,0x81, /* ....../..EpU.`a. */ \
	0xe7,0x5e,0xe1,0x56,0xb6,0xb6,0xb7,0x8c,0xd0,0xd9,0xa9,0xac,0x9b,0xeb,0x3c,0x1f, /* .^.V..........<. */ \
	0x11,0x78,0x51,0x34,0xaf,0x8a,0x34,0xd0,0x84,0xd7,0xa9,0x02,0xd7,0x6b,0xed,0x17, /* .xQ4..4......k.. */ \
	0xc2,0x74,0x69,0x84,0xb0,0xb7,0xaf,0xcf,0x29,0x31,0xa5,0xac,0x50,0xf9,0x50,0x90, /* .ti.....)1..P.P. */ \
	0x2d,0x97,0xac,0x3c,0x60,0x2d,0xae,0x86,0x4d,0xf5,0x33,0x4e,0x11,0xbe,0x04,0x40, /* -..<`-..M.3N...@ */ \
	0x17,0x19,0xcf,0x35,0x3c,0xe7,0x7c,0xb3,0xb3,0x37,0x53,0x5e,0x3d,0x27,0x55,0xd0, /* ...5<.|..7S^='U. */ \
	0x9b,0xab,0x73,0xe2,0x22,0x35,0x19,0x28,0x75,0xde,0xea,0xe2,0x56,0xa0,0x6e,0x98, /* ..s."5.(u...V.n. */ \
	0x5c,0x75,0xb3,0xd4,0xde,0xe3,0xb5,0x72,0x74,0x79,0x71,0x3d,0x23,0xd9,0xd3,0x87, /* \u.....rtyq=#... */ \
	0xe9,0x1c,0x06,0x21,0xc2,0xc7,0x49,0x4d,0x47,0x02,0x0a,0x46,0xd4,0x5d,0x7b,0xd4, /* ...!..IMG..F.]{. */ \
	0xf8,0x35,0x0a,0xfb,0x87,0xf1,0xc7,0x38,0x0a,0x9a,0xf1,0x54,0x95,0x08,0xa2,0x25, /* .5.....8...T...% */ \
	0x73,0xf3,0x8e,0x53,0x1f,0x47,0x12,0x02,0x41,0x42,0x14,0x9a,0x08,0x5c,0x04,0x8b, /* s..S.G..AB...\.. */ \
	0x84,0x20,0x18,0x41,0xdf,0x0c,0xb1,0xb6,0x8d,0xf5,0x14,0xe1,0x08,0xb6,0x66,0xd3, /* . .A..........f. */ \
	0x58,0xa8,0x9f,0x4a,0x00,0x7a,0xef,0x3a,0x37,0x60,0xe9,0xbe,0xf7,0xec,0x0d,0x67, /* X..J.z.:7`.....g */ \
	0xd3,0xc6,0xc9,0x9e,0x45,0xd4,0x70,0xc5,0xef,0xe5,0xb0,0x2a,0x17,0xc8,0xe0,0xf7, /* ....E.p......... */ \
	0x89,0xc5,0x2a,0x06,0x71,0x60,0x8b,0xf1,0x4f,0x42,0xda,0xc8,0x34,0x8e,0xf4,0x3c  /* ....q`..OB..4..< */
#define DATACHUNK000003 \
	0x59,0x83,0x73,0xb3,0x1e,0x23,0x58,0x3f,0x7b,0x5f,0x5e,0xd5,0x96,0x21,0x7d,0x8c, /* Y.s..#X?{_^..!}. */ \
	0xa9,0xf9,0x7b,0x04,0x1e,0x77,0x79,0xb8,0x5e,0x6e,0xf5,0x99,0xf5,0x63,0x53,0x72, /* ..{..wy.^n...cSr */ \
	0x91,0x24,0x42,0xe5,0x74,0x2a,0x8e,0x0d,0x7f,0x1c,0xfc,0xf4,0x6a,0x36,0x78,0x3e, /* .$B.t.......j6x> */ \
	0x90,0x10,0x0d,0x46,0xd4,0x23,0x63,0x14,0x94,0xf1,0x05,0x2c,0xb9,0x41,0x80,0x6a, /* ...F.#c....,.A.j */ \
	0xd6,0x88,0xce,0xe7,0xb4,0xe6,0x3d,0x0b,0x1d,0x3b,0x91,0xc2,0xd9,0xab,0x1f,0xa0, /* ......=..;...... */ \
	0x8a,0x4d,0xce,0x94,0x2c,0xd5,0x06,0xaa,0x78,0x36,0x7e,0x26,0xb2,0x2f,0x91,0xb8, /* .M..,...x6~&./.. */ \
	0x37,0xb9,0xa8,0xce,0x0c,0xc3,0xd6,0x7b,0xe2,0x5c,0xb2,0xba,0x63,0xe0,0x18,0xd2, /* 7......{.\..c... */ \
	0x58,0xf1,0xdb,0x3a,0x84,0xff,0x4c,0xc0,0x83,0xe5,0xc9,0x20,0x94,0x13,0x67,0xe6, /* X..:..L.... ..g. */ \
	0x3e,0x30,0x39,0x9b,0x5d,0x0e,0x7a,0xd7,0xc0,0x21,0x3b,0x20,0x7d,0xfc,0x6f,0x4d, /* >09.].z..!; }.oM */ \
	0xda,0xbf,0x21,0x2e,0x30,0x10,0x6f,0xff,0xc7,0xfd,0x4d,0xb9,0x72,0xfe,0x04,0xe9, /* ..!.0.o...M.r... */ \
	0x88,0x4c,0x9a,0x76,0x1a,0x1e,0xdf,0xb2,0x97,0x2f,0x6d,0xa8,0x5b,0xfe,0x43,0xc1, /* .L.v...../m.[.C. */ \
	0x42,0xe2,0x86,0xcc,0x50,0x52,0x81,0x82,0xa5,0x2d,0x4d,0xe3,0xb2,0x72,0x8b,0xf6, /* B...PR...-M..r.. */ \
	0xf6,0xd8,0x7a,0x1f,0x8a,0xd3,0xb9,0x31,0xa5,0x23,0xb3,0x82,0xca,0x25,0xed,0x71, /* ..z....1.#...%.q */ \
	0xd9,0x4c,0x82,0xb7,0x53,0xea,0xb2,0xb6,0xbe,0x82,0x40,0x08,0x78,0x83,0x1a,0x15, /* .L..S.....@.x... */ \
	0xb2,0x57,0xbb,0xa0,0x60,0x8d,0xda,0xba,0x4d,0xe9,0xd2,0xe4,0xb9,0xec,0x4f,0x40, /* .W..`...M.....O@ */ \
	0x6d,0x54,0xa7,0x5f,0x5a,0xd9,0xff,0x9e,0x9b,0x62,0xe3,0x5c,0x95,0x8e,0xb3,0x36, /* mT._Z....b.\...6 */ \
	0x85,0xae,0x58,0xa1,0x7a,0xcf,0xe7,0x21,0x77,0xba,0x9a,0x5b,0x57,0x01,0xdc,0x02, /* ..X.z..!w..[W... */ \
	0xfe,0xdd,0x6c,0xe4,0x23,0x8e,0xd0,0x21,0x12,0x0d,0xc4,0xee,0xf6,0x39,0x17,0xb7, /* ..l.#..!.....9.. */ \
	0x7e,0x71,0x44,0x9a,0x5e,0x10,0xea,0xbc,0xde,0xdf,0x1f,0xc6,0x11,0x0a,0x4a,0xb4, /* ~qD.^.........J. */ \
	0xf5,0xad,0x5b,0xeb,0x16,0x7a,0x5e,0xfb,0x27,0x79,0xf9,0x5d,0xb3,0x02,0xeb,0xa3, /* ..[..z^.'y.].... */ \
	0x50,0x92,0x75,0x51,0xb1,0xd8,0x1a,0xe7,0x1e,0x0d,0x0d,0xed,0xb7,0x97,0xee,0x05, /* P.uQ............ */ \
	0x51,0x36,0x45,0xb8,0x49,0xd4,0x66,0x0b,0x2a,0x65,0xca,0x8c,0xfa,0x59,0x9f,0xd4, /* Q6E.I.f..e...Y.. */ \
	0xee,0x68,0xb5,0x82,0x82,0x91,0x6d,0xd0,0x0d,0x51,0x35,0xa6,0x53,0xfa,0x9e,0x9e, /* .h....m..Q5.S... */ \
	0x3c,0xa1,0xdd,0x25,0x0e,0xd6,0xca,0x89,0x19,0x7d,0x58,0xb4,0x1c,0xb5,0xe8,0xda, /* <..%.....}X..... */ \
	0xd3,0x42,0x49,0xcf,0xe9,0x95,0xd3,0xb5,0x45,0x41,0x6f,0x0a,0x8f,0xab,0x72,0x2f, /* .BI.....EAo...r/ */ \
	0xab,0x71,0xae,0xdf,0x94,0x6c,0xb6,0xc7,0x77,0x1b,0x86,0x82,0xbb,0xd7,0x06,0x76, /* .q...l..w......v */ \
	0x6f,0x18,0xd0,0xa3,0x4f,0x96,0x3d,0xe2,0x77,0xdd,0x78,0x90,0x80,0xe3,0xb6,0x69, /* o...O.=.w.x....i */ \
	0xbd,0xca,0x59,0x3e,0x02,0xa9,0xd1,0x36,0xe5,0xbf,0x7c,0x74,0xdd,0x55,0xf6,0x9a, /* ..Y>...6..|t.U.. */ \
	0x7b,0x45,0x2d,0x96,0xd0,0xdc,0xe0,0xbd,0xdc,0x9c,0x65,0x8f,0xec,0x1e,0xeb,0x02, /* {E-.......e..... */ \
	0x1f,0x3f,0xcf,0xd0,0xf8,0xa6,0x9f,0x70,0xd6,0xba,0x37,0xe3,0x0f,0xbe,0x71,0x07, /* .?.....p..7...q. */ \
	0x94,0x25,0x06,0xbc,0xd8,0xb5,0x76,0xd2,0x68,0xa9,0xc0,0x93,0x24,0x82,0xcc,0x1d, /* .%....v.h...$... */ \
	0x92,0xf6,0xb4,0x52,0x39,0xea,0x6b,0xd0,0x40,0x1c,0x49,0x5e,0x45,0xbb,0xb0,0xea, /* ...R9.k.@.I^E... */ \
	0xc6,0xd8,0x5a,0x35,0x8f,0x99,0xbb,0x66,0xd0,0x8f,0xd0,0x9e,0x0b,0xa3,0x8a,0xb4, /* ..Z5...f........ */ \
	0x0f,0x25,0x35,0xb1,0x69,0x07,0x23,0x09,0x51,0x21,0x6e,0x38,0xd3,0x84,0xa8,0x45, /* .%5.i.#.Q!n8...E */ \
	0xab,0x17,0x07,0x37,0xa2,0x9d,0xde,0xd9,0x2e,0xa9,0x7b,0xe8,0x2e,0x25,0xdb,0x57, /* ...7......{..%.W */ \
	0x0d,0xc4,0xd1,0xae,0x9c,0xef,0xe3,0x07,0xda,0xdc,0x5b,0x31,0xad,0x95,0x96,0x2e, /* ..........[1.... */ \
	0x1e,0xca,0xc3,0x21,0xba,0x16,0x96,0x67,0x8d,0x73,0x10,0x6f,0x37,0x4c,0xd5,0xea, /* ...!...g.s.o7L.. */ \
	0x6d,0xd3,0xe1,0xc5,0x76,0xac,0xea,0x09,0xb2,0x58,0x99,0xbb,0x5a,0x7a,0x15,0xe6, /* m...v....X..Zz.. */ \
	0xbf,0xed,0xc4,0x12,0x26,0x95,0xc0,0xb0,0x2e,0xca,0xea,0x5b,0x29,0x32,0x54,0xea, /* ....&......[)2T. */ \
	0xbe,0xd4,0xea,0x85,0x70,0xe4,0x38,0x67,0xeb,0x3b,0x3f,0xc2,0x5b,0x25,0xaf,0x92, /* ....p.8g.;?.[%.. */ \
	0x41,0xc3,0x23,0xcd,0x95,0x46,0xae,0x8e,0xff,0x28,0x4e,0x0c,0x44,0xd4,0xcd,0x55, /* A.#..F...(N.D..U */ \
	0x19,0xca,0x61,0x6e,0xca,0x30,0x80,0xdd,0x18,0x65,0x33,0xb0,0xe3,0x28,0x37,0xa8, /* ..an.0...e3..(7. */ \
	0x17,0x83,0xe6,0xa8,0xf8,0xeb,0x94,0x51,0xd7,0x86,0xff,0xbb,0x38,0x2e,0xda,0x34, /* .......Q....8..4 */ \
	0x19,0xd1,0xbb,0x0a,0xd5,0xf7,0x8e,0xb9,0x0c,0x42,0x41,0xba,0x60,0xc5,0xc3,0x76, /* .........BA.`..v */ \
	0xd3,0x96,0x4e,0x40,0xdc,0xb7,0x63,0x90,0xf4,0x19,0xb4,0x28,0xc7,0xf9,0x4a,0x66, /* ..N@..c....(..Jf */ \
	0xe2,0x5b,0x78,0x20,0x5d,0xeb,0x70,0x82,0xc9,0x3b,0x72,0x75,0x01,0x85,0xa8,0x92, /* .[x ].p..;ru.... */ \
	0xc1,0xb6,0x91,0x0c,0x46,0x87,0x13,0xc1,0x88,0xef,0x03,0x49,0x40,0xb9,0x54,0x00, /* ....F......I@.T. */ \
	0x70,0x21,0x8e,0x1f,0x96,0xf9,0x55,0x3b,0xe9,0x5a,0xf6,0x95,0x2d,0x20,0x42,0xf4, /* p!....U;.Z..- B. */ \
	0x01,0x4c,0xa8,0xcd,0x04,0xd0,0xcc,0x46,0xed,0xb8,0x88,0x19,0x16,0x7b,0x4e,0xc3, /* .L.....F.....{N. */ \
	0x18,0xdb,0x00,0xc8,0x43,0xb7,0x59,0xf0,0x31,0x5d,0x73,0x9e,0xd5,0xf6,0xf0,0x55, /* ....C.Y.1]s....U */ \
	0x24,0xe0,0x58,0xd9,0x74,0x21,0x35,0x61,0xdb,0xed,0x50,0x8a,0x70,0xca,0x6f,0x52, /* $.X.t!5a..P.p.oR */ \
	0x1d,0x92,0x06,0x68,0x54,0xef,0x08,0xe2,0xf7,0x76,0x13,0xb4,0x87,0x28,0x35,0xd6, /* ...hT....v...(5. */ \
	0x5e,0xf1,0x72,0x2f,0x37,0x33,0x75,0xfb,0xab,0x42,0xc3,0xa8,0x77,0xfc,0x3e,0xf9, /* ^.r/73u..B..w.>. */ \
	0x73,0x3c,0xd7,0x16,0xfd,0x62,0xa1,0xf3,0x6c,0x5c,0x60,0xb4,0x0e,0xc8,0x21,0xa4, /* s<...b..l\`...!. */ \
	0xb5,0x7b,0xf4,0x15,0x30,0x75,0xd3,0x72,0xdc,0x43,0x6b,0x94,0x77,0x8f,0xa9,0xdf, /* .{..0u.r.Ck.w... */ \
	0xa7,0x8b,0x84,0x2d,0x52,0xec,0x23,0xf5,0x8d,0x98,0x4b,0xc2,0xa8,0x70,0xa7,0xf1, /* ...-R.#...K..p.. */ \
	0xa3,0xac,0xed,0xbd,0x61,0x3e,0x78,0x53,0x62,0x8e,0x41,0x0e,0x7d,0x2e,0x66,0xf8, /* ....a>xSb.A.}.f. */ \
	0x45,0x25,0x3f,0x81,0xfe,0x06,0xc4,0xdd,0x52,0x7e,0x30,0x0e,0x00,0x00,0x7e,0x69, /* E%?.....R~0...~i */ \
	0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a, /* nc:header.inc~.. */ \
	0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74, /* <div id="content */ \
	0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x41,0x50,0x52,0x53,0x20,0x4d, /* ">....<h1>APRS M */ \
	0x65,0x73,0x73,0x61,0x67,0x65,0x20,0x53,0x65,0x6e,0x64,0x3c,0x2f,0x68,0x31,0x3e, /* essage Send</h1> */ \
	0x0d,0x0a,0x0d,0x0a,0x3c,0x66,0x6f,0x72,0x6d,0x20,0x6d,0x65,0x74,0x68,0x6f,0x64, /* ....<form method */ \
	0x3d,0x22,0x70,0x6f,0x73,0x74,0x22,0x20,0x61,0x63,0x74,0x69,0x6f,0x6e,0x3d,0x22  /* ="post" action=" */
#define DATACHUNK000004 \
	0x2f,0x61,0x70,0x72,0x73,0x6d,0x73,0x67,0x2e,0x68,0x74,0x6d,0x22,0x20,0x6e,0x61, /* /aprsmsg.htm" na */ \
	0x6d,0x65,0x3d,0x22,0x6d,0x65,0x73,0x73,0x61,0x67,0x65,0x22,0x3e,0x0d,0x0a,0x3c, /* me="message">..< */ \
	0x66,0x69,0x65,0x6c,0x64,0x73,0x65,0x74,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e, /* fieldset>..<div> */ \
	0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x53,0x65,0x6e,0x64,0x65,0x72,0x20,0x43,0x61, /* <label>Sender Ca */ \
	0x6c,0x6c,0x73,0x69,0x67,0x6e,0x20,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e, /* llsign :</label> */ \
	0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73, /* &nbsp;&nbsp;&nbs */ \
	0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e, /* p;&nbsp;&nbsp;&n */ \
	0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b, /* bsp;&nbsp;&nbsp; */ \
	0x26,0x6e,0x62,0x73,0x70,0x3b,0x0d,0x0a,0x3c,0x73,0x65,0x6c,0x65,0x63,0x74,0x20, /* &nbsp;..<select  */ \
	0x6e,0x61,0x6d,0x65,0x3d,0x22,0x73,0x63,0x61,0x6c,0x22,0x3e,0x0d,0x0a,0x7e,0x6f, /* name="scal">..~o */ \
	0x72,0x67,0x53,0x53,0x49,0x44,0x7e,0x0d,0x0a,0x7e,0x61,0x6c,0x74,0x53,0x53,0x49, /* rgSSID~..~altSSI */ \
	0x44,0x7e,0x0d,0x0a,0x3c,0x2f,0x73,0x65,0x6c,0x65,0x63,0x74,0x3e,0x0d,0x0a,0x3c, /* D~..</select>..< */ \
	0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62, /* /div>..<div><lab */ \
	0x65,0x6c,0x3e,0x44,0x65,0x73,0x74,0x69,0x6e,0x61,0x74,0x69,0x6f,0x6e,0x20,0x3a, /* el>Destination : */ \
	0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74, /* </label>..<input */ \
	0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d, /*  type="text" nam */ \
	0x65,0x3d,0x22,0x64,0x65,0x73,0x74,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22, /* e="dest" value=" */ \
	0x7e,0x64,0x65,0x73,0x74,0x69,0x6e,0x61,0x74,0x69,0x6f,0x6e,0x7e,0x22,0x20,0x73, /* ~destination~" s */ \
	0x69,0x7a,0x65,0x3d,0x22,0x31,0x30,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22, /* ize="10" class=" */ \
	0x61,0x64,0x31,0x22,0x2f,0x3e,0x0d,0x0a,0x20,0x41,0x63,0x6b,0x20,0x52,0x65,0x63, /* ad1"/>.. Ack Rec */ \
	0x65,0x69,0x76,0x65,0x64,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65, /* eived<input type */ \
	0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65, /* ="checkbox" name */ \
	0x3d,0x22,0x61,0x63,0x6b,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x31,0x22, /* ="ack" value="1" */ \
	0x20,0x7e,0x61,0x63,0x6b,0x7e,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x31,0x22,0x20, /*  ~ack~ size="1"  */ \
	0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x33,0x22,0x20,0x64,0x69,0x73,0x61, /* class="ad3" disa */ \
	0x62,0x6c,0x65,0x64,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c, /* bled /></div>..< */ \
	0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x4d,0x65,0x73,0x73,0x61, /* div><label>Messa */ \
	0x67,0x65,0x20,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69, /* ge :</label>..<i */ \
	0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22, /* nput type="text" */ \
	0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6d,0x65,0x73,0x67,0x22,0x20,0x76,0x61,0x6c, /*  name="mesg" val */ \
	0x75,0x65,0x3d,0x22,0x7e,0x6d,0x65,0x73,0x67,0x42,0x6f,0x64,0x79,0x7e,0x22,0x20, /* ue="~mesgBody~"  */ \
	0x73,0x69,0x7a,0x65,0x3d,0x22,0x34,0x30,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d, /* size="40" class= */ \
	0x22,0x61,0x64,0x31,0x22,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c, /* "ad1"/></div>..< */ \
	0x64,0x69,0x76,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d, /* div><input type= */ \
	0x22,0x62,0x75,0x74,0x74,0x6f,0x6e,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x73, /* "button" name="s */ \
	0x65,0x6e,0x64,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x53,0x65,0x6e,0x64, /* end" value="Send */ \
	0x22,0x20,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x33,0x22,0x20,0x6f, /* "  class="ad3" o */ \
	0x6e,0x43,0x6c,0x69,0x63,0x6b,0x3d,0x22,0x66,0x69,0x65,0x6c,0x64,0x63,0x68,0x65, /* nClick="fieldche */ \
	0x63,0x6b,0x28,0x29,0x22,0x20,0x20,0x2f,0x3e,0x0d,0x0a,0x26,0x6e,0x62,0x73,0x70, /* ck()"  />..&nbsp */ \
	0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79, /* ;&nbsp;<input ty */ \
	0x70,0x65,0x3d,0x22,0x62,0x75,0x74,0x74,0x6f,0x6e,0x22,0x20,0x6e,0x61,0x6d,0x65, /* pe="button" name */ \
	0x3d,0x22,0x66,0x72,0x65,0x73,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x52, /* ="fres" value="R */ \
	0x65,0x66,0x72,0x65,0x73,0x68,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61, /* efresh" class="a */ \
	0x64,0x33,0x22,0x20,0x6f,0x6e,0x43,0x6c,0x69,0x63,0x6b,0x3d,0x22,0x66,0x69,0x65, /* d3" onClick="fie */ \
	0x6c,0x64,0x72,0x65,0x6c,0x6f,0x61,0x64,0x28,0x29,0x22,0x20,0x2f,0x3e,0x0d,0x0a, /* ldreload()" />.. */ \
	0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x69,0x6e,0x70, /* &nbsp;&nbsp;<inp */ \
	0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x62,0x75,0x74,0x74,0x6f,0x6e,0x22, /* ut type="button" */ \
	0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x63,0x6c,0x61,0x72,0x22,0x20,0x76,0x61,0x6c, /*  name="clar" val */ \
	0x75,0x65,0x3d,0x22,0x43,0x6c,0x65,0x61,0x72,0x22,0x20,0x63,0x6c,0x61,0x73,0x73, /* ue="Clear" class */ \
	0x3d,0x22,0x61,0x64,0x33,0x22,0x20,0x6f,0x6e,0x43,0x6c,0x69,0x63,0x6b,0x3d,0x22, /* ="ad3" onClick=" */ \
	0x66,0x69,0x65,0x6c,0x64,0x63,0x6c,0x65,0x61,0x72,0x28,0x29,0x22,0x20,0x20,0x2f, /* fieldclear()"  / */ \
	0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x62,0x72,0x3e,0x0d, /* >..</div>..<br>. */ \
	0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x4c,0x61,0x73, /* .<div><label>Las */ \
	0x74,0x20,0x52,0x65,0x63,0x76,0x2e,0x20,0x4d,0x65,0x73,0x2e,0x20,0x49,0x6e,0x66, /* t Recv. Mes. Inf */ \
	0x6f,0x2e,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e, /* o.</label></div> */ \
	0x3c,0x62,0x72,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61, /* <br>....<div><la */ \
	0x62,0x65,0x6c,0x3e,0x53,0x65,0x6e,0x64,0x65,0x72,0x20,0x43,0x61,0x6c,0x6c,0x73, /* bel>Sender Calls */ \
	0x69,0x67,0x6e,0x20,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c, /* ign :</label>..< */ \
	0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74, /* input type="text */ \
	0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6c,0x63,0x61,0x6c,0x22,0x20,0x76,0x61, /* " name="lcal" va */ \
	0x6c,0x75,0x65,0x3d,0x22,0x7e,0x73,0x65,0x6e,0x64,0x65,0x72,0x63,0x61,0x6c,0x6c, /* lue="~sendercall */ \
	0x7e,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x31,0x30,0x22,0x20,0x63,0x6c,0x61, /* ~" size="10" cla */ \
	0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x20,0x72,0x65,0x61,0x64,0x6f,0x6e,0x6c, /* ss="ad1" readonl */ \
	0x79,0x20,0x6f,0x6e,0x43,0x6c,0x69,0x63,0x6b,0x3d,0x22,0x43,0x70,0x79,0x53,0x65  /* y onClick="CpySe */
#define DATACHUNK000005 \
	0x6e,0x64,0x65,0x72,0x43,0x61,0x6c,0x6c,0x28,0x29,0x22,0x2f,0x3e,0x3c,0x2f,0x64, /* nderCall()"/></d */ \
	0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c, /* iv>..<div><label */ \
	0x3e,0x52,0x65,0x63,0x65,0x69,0x76,0x65,0x64,0x20,0x4d,0x65,0x73,0x73,0x61,0x67, /* >Received Messag */ \
	0x65,0x20,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e, /* e :</label>..<in */ \
	0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20, /* put type="text"  */ \
	0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6c,0x6d,0x73,0x67,0x22,0x20,0x76,0x61,0x6c,0x75, /* name="lmsg" valu */ \
	0x65,0x3d,0x22,0x7e,0x4c,0x61,0x73,0x74,0x4d,0x73,0x67,0x7e,0x22,0x20,0x73,0x69, /* e="~LastMsg~" si */ \
	0x7a,0x65,0x3d,0x22,0x34,0x30,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61, /* ze="40" class="a */ \
	0x64,0x31,0x22,0x20,0x72,0x65,0x61,0x64,0x6f,0x6e,0x6c,0x79,0x20,0x6f,0x6e,0x43, /* d1" readonly onC */ \
	0x6c,0x69,0x63,0x6b,0x3d,0x22,0x43,0x70,0x79,0x4d,0x73,0x67,0x28,0x29,0x22,0x2f, /* lick="CpyMsg()"/ */ \
	0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x2f,0x66,0x69,0x65, /* ></div>....</fie */ \
	0x6c,0x64,0x73,0x65,0x74,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x6f,0x72,0x6d,0x3e,0x0d, /* ldset>..</form>. */ \
	0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74, /* .</div>..<script */ \
	0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x2f,0x6a,0x61,0x76,0x61, /*  type="text/java */ \
	0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x0d,0x0a,0x3c,0x21,0x2d,0x2d,0x0d,0x0a, /* script">..<!--.. */ \
	0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x20,0x66,0x69,0x65,0x6c,0x64,0x63,0x68, /* function fieldch */ \
	0x65,0x63,0x6b,0x28,0x29,0x0d,0x0a,0x7b,0x0d,0x0a,0x20,0x69,0x66,0x20,0x28,0x64, /* eck()..{.. if (d */ \
	0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x66,0x6f,0x72,0x6d,0x73,0x2e,0x6d,0x65, /* ocument.forms.me */ \
	0x73,0x73,0x61,0x67,0x65,0x2e,0x64,0x65,0x73,0x74,0x2e,0x76,0x61,0x6c,0x75,0x65, /* ssage.dest.value */ \
	0x2e,0x6c,0x65,0x6e,0x67,0x74,0x68,0x20,0x3d,0x3d,0x20,0x30,0x29,0x0d,0x0a,0x20, /* .length == 0)..  */ \
	0x7b,0x0d,0x0a,0x20,0x20,0x20,0x77,0x69,0x6e,0x64,0x6f,0x77,0x2e,0x61,0x6c,0x65, /* {..   window.ale */ \
	0x72,0x74,0x20,0x28,0x22,0x44,0x65,0x73,0x74,0x69,0x6e,0x61,0x74,0x69,0x6f,0x6e, /* rt ("Destination */ \
	0x20,0x69,0x73,0x20,0x65,0x6d,0x70,0x74,0x79,0x21,0x22,0x29,0x3b,0x0d,0x0a,0x20, /*  is empty!");..  */ \
	0x20,0x20,0x72,0x65,0x74,0x75,0x72,0x6e,0x3b,0x0d,0x0a,0x20,0x7d,0x20,0x0d,0x0a, /*   return;.. } .. */ \
	0x20,0x69,0x66,0x20,0x28,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x66,0x6f, /*  if (document.fo */ \
	0x72,0x6d,0x73,0x2e,0x6d,0x65,0x73,0x73,0x61,0x67,0x65,0x2e,0x6d,0x65,0x73,0x67, /* rms.message.mesg */ \
	0x2e,0x76,0x61,0x6c,0x75,0x65,0x2e,0x6c,0x65,0x6e,0x67,0x74,0x68,0x20,0x3d,0x3d, /* .value.length == */ \
	0x20,0x30,0x29,0x0d,0x0a,0x20,0x7b,0x0d,0x0a,0x20,0x20,0x20,0x77,0x69,0x6e,0x64, /*  0).. {..   wind */ \
	0x6f,0x77,0x2e,0x61,0x6c,0x65,0x72,0x74,0x20,0x28,0x22,0x4d,0x65,0x73,0x73,0x61, /* ow.alert ("Messa */ \
	0x67,0x65,0x20,0x69,0x73,0x20,0x65,0x6d,0x70,0x74,0x79,0x21,0x22,0x29,0x3b,0x0d, /* ge is empty!");. */ \
	0x0a,0x20,0x20,0x20,0x72,0x65,0x74,0x75,0x72,0x6e,0x3b,0x0d,0x0a,0x20,0x7d,0x0d, /* .   return;.. }. */ \
	0x0a,0x20,0x20,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x66,0x6f,0x72, /* .   document.for */ \
	0x6d,0x73,0x2e,0x6d,0x65,0x73,0x73,0x61,0x67,0x65,0x2e,0x73,0x75,0x62,0x6d,0x69, /* ms.message.submi */ \
	0x74,0x28,0x29,0x3b,0x20,0x0d,0x0a,0x7d,0x0d,0x0a,0x0d,0x0a,0x66,0x75,0x6e,0x63, /* t(); ..}....func */ \
	0x74,0x69,0x6f,0x6e,0x20,0x66,0x69,0x65,0x6c,0x64,0x63,0x6c,0x65,0x61,0x72,0x28, /* tion fieldclear( */ \
	0x29,0x0d,0x0a,0x7b,0x0d,0x0a,0x20,0x20,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e, /* )..{..   documen */ \
	0x74,0x2e,0x66,0x6f,0x72,0x6d,0x73,0x2e,0x6d,0x65,0x73,0x73,0x61,0x67,0x65,0x2e, /* t.forms.message. */ \
	0x64,0x65,0x73,0x74,0x2e,0x76,0x61,0x6c,0x75,0x65,0x20,0x3d,0x20,0x22,0x22,0x3b, /* dest.value = ""; */ \
	0x0d,0x0a,0x20,0x20,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x66,0x6f, /* ..   document.fo */ \
	0x72,0x6d,0x73,0x2e,0x6d,0x65,0x73,0x73,0x61,0x67,0x65,0x2e,0x6d,0x65,0x73,0x67, /* rms.message.mesg */ \
	0x2e,0x76,0x61,0x6c,0x75,0x65,0x20,0x3d,0x20,0x22,0x22,0x3b,0x0d,0x0a,0x7d,0x0d, /* .value = "";..}. */ \
	0x0a,0x0d,0x0a,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x20,0x66,0x69,0x65,0x6c, /* ...function fiel */ \
	0x64,0x72,0x65,0x6c,0x6f,0x61,0x64,0x28,0x29,0x0d,0x0a,0x7b,0x0d,0x0a,0x20,0x20, /* dreload()..{..   */ \
	0x20,0x6c,0x6f,0x63,0x61,0x74,0x69,0x6f,0x6e,0x2e,0x72,0x65,0x6c,0x6f,0x61,0x64, /*  location.reload */ \
	0x28,0x74,0x72,0x75,0x65,0x29,0x3b,0x0d,0x0a,0x7d,0x0d,0x0a,0x0d,0x0a,0x66,0x75, /* (true);..}....fu */ \
	0x6e,0x63,0x74,0x69,0x6f,0x6e,0x20,0x43,0x70,0x79,0x4d,0x73,0x67,0x28,0x29,0x0d, /* nction CpyMsg(). */ \
	0x0a,0x7b,0x0d,0x0a,0x20,0x20,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e, /* .{..   document. */ \
	0x66,0x6f,0x72,0x6d,0x73,0x2e,0x6d,0x65,0x73,0x73,0x61,0x67,0x65,0x2e,0x6d,0x65, /* forms.message.me */ \
	0x73,0x67,0x2e,0x76,0x61,0x6c,0x75,0x65,0x20,0x3d,0x20,0x64,0x6f,0x63,0x75,0x6d, /* sg.value = docum */ \
	0x65,0x6e,0x74,0x2e,0x66,0x6f,0x72,0x6d,0x73,0x2e,0x6d,0x65,0x73,0x73,0x61,0x67, /* ent.forms.messag */ \
	0x65,0x2e,0x6c,0x6d,0x73,0x67,0x2e,0x76,0x61,0x6c,0x75,0x65,0x3b,0x0d,0x0a,0x7d, /* e.lmsg.value;..} */ \
	0x0d,0x0a,0x0d,0x0a,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x20,0x43,0x70,0x79, /* ....function Cpy */ \
	0x53,0x65,0x6e,0x64,0x65,0x72,0x43,0x61,0x6c,0x6c,0x28,0x29,0x0d,0x0a,0x7b,0x0d, /* SenderCall()..{. */ \
	0x0a,0x20,0x20,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x66,0x6f,0x72, /* .   document.for */ \
	0x6d,0x73,0x2e,0x6d,0x65,0x73,0x73,0x61,0x67,0x65,0x2e,0x64,0x65,0x73,0x74,0x2e, /* ms.message.dest. */ \
	0x76,0x61,0x6c,0x75,0x65,0x20,0x3d,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74, /* value = document */ \
	0x2e,0x66,0x6f,0x72,0x6d,0x73,0x2e,0x6d,0x65,0x73,0x73,0x61,0x67,0x65,0x2e,0x6c, /* .forms.message.l */ \
	0x63,0x61,0x6c,0x2e,0x76,0x61,0x6c,0x75,0x65,0x3b,0x0d,0x0a,0x7d,0x0d,0x0a,0x2f, /* cal.value;..}../ */ \
	0x2f,0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74,0x3e,0x0d, /* /-->..</script>. */ \
	0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e,0x63, /* .~inc:footer.inc */ \
	0x7e,0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0xcb,0x00,0x00, /* ~....3.......... */ \
	0x00,0x0b,0x01,0x00,0x00,0xcc,0x00,0x00,0x00,0x72,0x01,0x00,0x00,0xb8,0x00,0x00, /* .........r...... */ \
	0x00,0xd3,0x01,0x00,0x00,0xc8,0x00,0x00,0x00,0x46,0x02,0x00,0x00,0xb9,0x00,0x00, /* .........F...... */ \
	0x00,0x27,0x04,0x00,0x00,0xcd,0x00,0x00,0x00,0xc5,0x04,0x00,0x00,0xce,0x00,0x00  /* .'.............. */
#define DATACHUNK000006 \
	0x00,0x13,0x08,0x00,0x00,0x02,0x00,0x00,0x00,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65, /* .........~inc:he */ \
	0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20, /* ader.inc~..<div  */ \
	0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d, /* id="content">... */ \
	0x0a,0x3c,0x68,0x31,0x3e,0x44,0x50,0x52,0x53,0x20,0x43,0x6f,0x6e,0x66,0x69,0x67, /* .<h1>DPRS Config */ \
	0x75,0x72,0x61,0x74,0x69,0x6f,0x6e,0x3c,0x2f,0x68,0x31,0x3e,0x0d,0x0a,0x0d,0x0a, /* uration</h1>.... */ \
	0x3c,0x66,0x6f,0x72,0x6d,0x20,0x6d,0x65,0x74,0x68,0x6f,0x64,0x3d,0x22,0x70,0x6f, /* <form method="po */ \
	0x73,0x74,0x22,0x20,0x61,0x63,0x74,0x69,0x6f,0x6e,0x3d,0x22,0x2f,0x64,0x70,0x72, /* st" action="/dpr */ \
	0x73,0x2e,0x68,0x74,0x6d,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x64,0x70,0x72, /* s.htm" name="dpr */ \
	0x73,0x22,0x3e,0x0d,0x0a,0x3c,0x66,0x69,0x65,0x6c,0x64,0x73,0x65,0x74,0x3e,0x0d, /* s">..<fieldset>. */ \
	0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70, /* .<div><input typ */ \
	0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x63,0x6c,0x61, /* e="checkbox" cla */ \
	0x73,0x73,0x3d,0x22,0x73,0x6d,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x64,0x70, /* ss="sm" name="dp */ \
	0x73,0x77,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x31,0x22,0x20,0x6f,0x6e, /* sw" value="1" on */ \
	0x63,0x6c,0x69,0x63,0x6b,0x3d,0x22,0x63,0x6f,0x6e,0x66,0x69,0x67,0x44,0x50,0x52, /* click="configDPR */ \
	0x53,0x42,0x6f,0x78,0x65,0x73,0x28,0x29,0x22,0x20,0x7e,0x44,0x50,0x52,0x53,0x5f, /* SBoxes()" ~DPRS_ */ \
	0x63,0x68,0x65,0x63,0x6b,0x65,0x64,0x7e,0x20,0x2f,0x3e,0x20,0x45,0x6e,0x61,0x62, /* checked~ /> Enab */ \
	0x6c,0x65,0x20,0x44,0x50,0x52,0x53,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c, /* le DPRS</div>..< */ \
	0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x44,0x50,0x52,0x53,0x20, /* div><label>DPRS  */ \
	0x53,0x65,0x72,0x76,0x65,0x72,0x20,0x49,0x50,0x20,0x3a,0x3c,0x2f,0x6c,0x61,0x62, /* Server IP :</lab */ \
	0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65, /* el>..<input type */ \
	0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x64,0x70, /* ="text" name="dp */ \
	0x69,0x70,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x64,0x70,0x72,0x73, /* ip" value="~dprs */ \
	0x69,0x70,0x7e,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x32,0x30,0x22,0x20,0x63, /* ip~" size="20" c */ \
	0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x3e,0x3c,0x2f,0x64,0x69,0x76, /* lass="ad1"></div */ \
	0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x44, /* >..<div><label>D */ \
	0x50,0x52,0x53,0x20,0x53,0x65,0x72,0x76,0x65,0x72,0x20,0x50,0x6f,0x72,0x74,0x20, /* PRS Server Port  */ \
	0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75, /* :</label>..<inpu */ \
	0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61, /* t type="text" na */ \
	0x6d,0x65,0x3d,0x22,0x64,0x70,0x70,0x74,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d, /* me="dppt" value= */ \
	0x22,0x7e,0x64,0x70,0x72,0x73,0x70,0x6f,0x72,0x74,0x7e,0x22,0x20,0x73,0x69,0x7a, /* "~dprsport~" siz */ \
	0x65,0x3d,0x22,0x35,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31, /* e="5" class="ad1 */ \
	0x22,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c, /* "></div>..<div>< */ \
	0x6c,0x61,0x62,0x65,0x6c,0x3e,0x59,0x6f,0x75,0x72,0x20,0x43,0x61,0x6c,0x6c,0x73, /* label>Your Calls */ \
	0x69,0x67,0x6e,0x20,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c, /* ign :</label>..< */ \
	0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74, /* input type="text */ \
	0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x64,0x70,0x63,0x6c,0x22,0x20,0x76,0x61, /* " name="dpcl" va */ \
	0x6c,0x75,0x65,0x3d,0x22,0x7e,0x64,0x70,0x72,0x73,0x63,0x61,0x6c,0x6c,0x7e,0x22, /* lue="~dprscall~" */ \
	0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x37,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d, /*  size="7" class= */ \
	0x22,0x61,0x64,0x31,0x22,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64, /* "ad1"></div>..<d */ \
	0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x44,0x2d,0x53,0x54,0x41,0x52, /* iv><label>D-STAR */ \
	0x20,0x49,0x44,0x20,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c, /*  ID :</label>..< */ \
	0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74, /* input type="text */ \
	0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x64,0x73,0x69,0x64,0x22,0x20,0x76,0x61, /* " name="dsid" va */ \
	0x6c,0x75,0x65,0x3d,0x22,0x7e,0x64,0x73,0x74,0x61,0x72,0x69,0x64,0x7e,0x22,0x20, /* lue="~dstarid~"  */ \
	0x73,0x69,0x7a,0x65,0x3d,0x22,0x31,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22, /* size="1" class=" */ \
	0x61,0x64,0x31,0x22,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69, /* ad1"></div>..<di */ \
	0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x56,0x61,0x6c,0x69,0x64,0x61,0x74, /* v><label>Validat */ \
	0x69,0x6f,0x6e,0x20,0x43,0x6f,0x64,0x65,0x20,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65, /* ion Code :</labe */ \
	0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d, /* l>..<input type= */ \
	0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x64,0x70,0x63, /* "text" name="dpc */ \
	0x64,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x64,0x70,0x72,0x73,0x76, /* d" value="~dprsv */ \
	0x61,0x6c,0x69,0x64,0x7e,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x37,0x22,0x20, /* alid~" size="7"  */ \
	0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x3e,0x3c,0x2f,0x64,0x69, /* class="ad1"></di */ \
	0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e, /* v>..<div><label> */ \
	0x43,0x6c,0x69,0x65,0x6e,0x74,0x20,0x49,0x6e,0x66,0x6f,0x6d,0x61,0x74,0x69,0x6f, /* Client Infomatio */ \
	0x6e,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x3c, /* n</label></div>< */ \
	0x62,0x72,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c, /* br>..<div><label */ \
	0x3e,0x4c,0x61,0x74,0x69,0x74,0x75,0x64,0x65,0x20,0x3a,0x3c,0x2f,0x6c,0x61,0x62, /* >Latitude :</lab */ \
	0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65, /* el>..<input type */ \
	0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x70,0x6c, /* ="text" name="pl */ \
	0x61,0x74,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x70,0x6c,0x61,0x74, /* at" value="~plat */ \
	0x7e,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x38,0x22,0x20,0x63,0x6c,0x61,0x73, /* ~" size="8" clas */ \
	0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a, /* s="ad1"></div>.. */ \
	0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x4c,0x6f,0x6e,0x67  /* <div><label>Long */
#define DATACHUNK000007 \
	0x69,0x74,0x75,0x64,0x65,0x20,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d, /* itude :</label>. */ \
	0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65, /* .<input type="te */ \
	0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x70,0x6c,0x6e,0x67,0x22,0x20, /* xt" name="plng"  */ \
	0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x70,0x6c,0x6f,0x6e,0x67,0x7e,0x22,0x20, /* value="~plong~"  */ \
	0x73,0x69,0x7a,0x65,0x3d,0x22,0x39,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22, /* size="9" class=" */ \
	0x61,0x64,0x31,0x22,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69, /* ad1"></div>..<di */ \
	0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x43,0x6f,0x6d,0x6d,0x65,0x6e,0x74, /* v><label>Comment */ \
	0x20,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70, /*  :</label>..<inp */ \
	0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e, /* ut type="text" n */ \
	0x61,0x6d,0x65,0x3d,0x22,0x70,0x63,0x6d,0x74,0x22,0x20,0x76,0x61,0x6c,0x75,0x65, /* ame="pcmt" value */ \
	0x3d,0x22,0x7e,0x70,0x63,0x6f,0x6d,0x6d,0x65,0x6e,0x74,0x7e,0x22,0x20,0x73,0x69, /* ="~pcomment~" si */ \
	0x7a,0x65,0x3d,0x22,0x32,0x30,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61, /* ze="20" class="a */ \
	0x64,0x31,0x22,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x64, /* d1"></div>....<d */ \
	0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x41,0x63,0x63,0x65,0x70,0x74, /* iv><label>Accept */ \
	0x20,0x66,0x72,0x6f,0x6d,0x20,0x52,0x61,0x64,0x69,0x6f,0x20,0x3a,0x3c,0x2f,0x6c, /*  from Radio :</l */ \
	0x61,0x62,0x65,0x6c,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65, /* abel><input type */ \
	0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65, /* ="checkbox" name */ \
	0x3d,0x22,0x64,0x70,0x72,0x64,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x73, /* ="dprd" class="s */ \
	0x6d,0x22,0x20,0x7e,0x64,0x70,0x72,0x73,0x52,0x61,0x64,0x69,0x6f,0x7e,0x20,0x76, /* m" ~dprsRadio~ v */ \
	0x61,0x6c,0x75,0x65,0x3d,0x22,0x31,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76, /* alue="1" /></div */ \
	0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x41, /* >..<div><label>A */ \
	0x63,0x63,0x65,0x70,0x74,0x20,0x66,0x72,0x6f,0x6d,0x20,0x49,0x6e,0x65,0x74,0x20, /* ccept from Inet  */ \
	0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20, /* :</label><input  */ \
	0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20, /* type="checkbox"  */ \
	0x6e,0x61,0x6d,0x65,0x3d,0x22,0x64,0x70,0x69,0x74,0x22,0x20,0x63,0x6c,0x61,0x73, /* name="dpit" clas */ \
	0x73,0x3d,0x22,0x73,0x6d,0x22,0x20,0x7e,0x64,0x70,0x72,0x73,0x49,0x6e,0x65,0x74, /* s="sm" ~dprsInet */ \
	0x7e,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x31,0x22,0x20,0x2f,0x3e,0x3c,0x2f, /* ~ value="1" /></ */ \
	0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x69,0x6e,0x70,0x75, /* div>..<div><inpu */ \
	0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x73,0x75,0x62,0x6d,0x69,0x74,0x22,0x20, /* t type="submit"  */ \
	0x6e,0x61,0x6d,0x65,0x20,0x3d,0x22,0x73,0x75,0x62,0x22,0x20,0x63,0x6c,0x61,0x73, /* name ="sub" clas */ \
	0x73,0x3d,0x22,0x73,0x6d,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x53,0x61, /* s="sm" value="Sa */ \
	0x76,0x65,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x2f, /* ve" /></div>..</ */ \
	0x66,0x69,0x65,0x6c,0x64,0x73,0x65,0x74,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x2f,0x66, /* fieldset>....</f */ \
	0x6f,0x72,0x6d,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a, /* orm>..</div>.... */ \
	0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x6c,0x61,0x6e,0x67,0x75,0x61,0x67,0x65, /* <script language */ \
	0x3d,0x22,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x0d,0x0a, /* ="javascript">.. */ \
	0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x20,0x63,0x6f,0x6e,0x66,0x69,0x67,0x44, /* function configD */ \
	0x50,0x52,0x53,0x42,0x6f,0x78,0x65,0x73,0x28,0x29,0x20,0x7b,0x0d,0x0a,0x09,0x65, /* PRSBoxes() {...e */ \
	0x20,0x3d,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x66,0x6f,0x72,0x6d, /*  = document.form */ \
	0x73,0x2e,0x64,0x70,0x72,0x73,0x3b,0x0d,0x0a,0x09,0x69,0x66,0x20,0x28,0x21,0x64, /* s.dprs;...if (!d */ \
	0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x66,0x6f,0x72,0x6d,0x73,0x2e,0x64,0x70, /* ocument.forms.dp */ \
	0x72,0x73,0x2e,0x64,0x70,0x73,0x77,0x2e,0x63,0x68,0x65,0x63,0x6b,0x65,0x64,0x29, /* rs.dpsw.checked) */ \
	0x0d,0x0a,0x09,0x7b,0x0d,0x0a,0x09,0x20,0x20,0x65,0x2e,0x64,0x70,0x69,0x70,0x2e, /* ...{...  e.dpip. */ \
	0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x74,0x72,0x75,0x65,0x3b, /* disabled = true; */ \
	0x0d,0x0a,0x09,0x20,0x20,0x65,0x2e,0x64,0x70,0x70,0x74,0x2e,0x64,0x69,0x73,0x61, /* ...  e.dppt.disa */ \
	0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x74,0x72,0x75,0x65,0x3b,0x0d,0x0a,0x09,0x20, /* bled = true;...  */ \
	0x20,0x65,0x2e,0x64,0x70,0x63,0x6c,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64, /*  e.dpcl.disabled */ \
	0x20,0x3d,0x20,0x74,0x72,0x75,0x65,0x3b,0x0d,0x0a,0x09,0x20,0x20,0x65,0x2e,0x64, /*  = true;...  e.d */ \
	0x73,0x69,0x64,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x74, /* sid.disabled = t */ \
	0x72,0x75,0x65,0x3b,0x0d,0x0a,0x09,0x20,0x20,0x65,0x2e,0x64,0x70,0x63,0x64,0x2e, /* rue;...  e.dpcd. */ \
	0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x74,0x72,0x75,0x65,0x3b, /* disabled = true; */ \
	0x0d,0x0a,0x09,0x7d,0x0d,0x0a,0x09,0x65,0x6c,0x73,0x65,0x0d,0x0a,0x09,0x7b,0x0d, /* ...}...else...{. */ \
	0x0a,0x09,0x20,0x20,0x65,0x2e,0x64,0x70,0x69,0x70,0x2e,0x64,0x69,0x73,0x61,0x62, /* ..  e.dpip.disab */ \
	0x6c,0x65,0x64,0x20,0x3d,0x20,0x66,0x61,0x6c,0x73,0x65,0x3b,0x0d,0x0a,0x09,0x20, /* led = false;...  */ \
	0x20,0x65,0x2e,0x64,0x70,0x70,0x74,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64, /*  e.dppt.disabled */ \
	0x20,0x3d,0x20,0x66,0x61,0x6c,0x73,0x65,0x3b,0x0d,0x0a,0x09,0x20,0x20,0x65,0x2e, /*  = false;...  e. */ \
	0x64,0x70,0x63,0x6c,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20, /* dpcl.disabled =  */ \
	0x66,0x61,0x6c,0x73,0x65,0x3b,0x0d,0x0a,0x09,0x20,0x20,0x65,0x2e,0x64,0x73,0x69, /* false;...  e.dsi */ \
	0x64,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x66,0x61,0x6c, /* d.disabled = fal */ \
	0x73,0x65,0x3b,0x0d,0x0a,0x09,0x20,0x20,0x65,0x2e,0x64,0x70,0x63,0x64,0x2e,0x64, /* se;...  e.dpcd.d */ \
	0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x66,0x61,0x6c,0x73,0x65,0x3b, /* isabled = false; */ \
	0x0d,0x0a,0x09,0x7d,0x0d,0x0a,0x7d,0x0d,0x0a,0x2f,0x2f,0x2d,0x2d,0x3e,0x0d,0x0a, /* ...}..}..//-->.. */ \
	0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74,0x3e,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a, /* </script>..~inc: */ \
	0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x00,0x00,0x00,0x00,0x33  /* footer.inc~....3 */
#define DATACHUNK000008 \
	0x00,0x00,0x00,0xe1,0x00,0x00,0x00,0xb1,0x00,0x00,0x00,0x52,0x01,0x00,0x00,0xac, /* ...........R.... */ \
	0x00,0x00,0x00,0xc8,0x01,0x00,0x00,0xad,0x00,0x00,0x00,0x3c,0x02,0x00,0x00,0xae, /* ...........<.... */ \
	0x00,0x00,0x00,0xac,0x02,0x00,0x00,0xaf,0x00,0x00,0x00,0x21,0x03,0x00,0x00,0xb0, /* ...........!.... */ \
	0x00,0x00,0x00,0xc2,0x03,0x00,0x00,0xb5,0x00,0x00,0x00,0x2e,0x04,0x00,0x00,0xb6, /* ................ */ \
	0x00,0x00,0x00,0x99,0x04,0x00,0x00,0xb7,0x00,0x00,0x00,0x1a,0x05,0x00,0x00,0xb2, /* ................ */ \
	0x00,0x00,0x00,0x8e,0x05,0x00,0x00,0xb3,0x00,0x00,0x00,0xe2,0x07,0x00,0x00,0x02, /* ................ */ \
	0x00,0x00,0x00,0x3c,0x64,0x69,0x76,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x73, /* ...<div class="s */ \
	0x70,0x61,0x63,0x65,0x72,0x22,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x64, /* pacer">&nbsp;</d */ \
	0x69,0x76,0x3e,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x66,0x6f,0x6f, /* iv>.<div id="foo */ \
	0x74,0x65,0x72,0x22,0x3e,0x43,0x6f,0x70,0x79,0x72,0x69,0x67,0x68,0x74,0x20,0x26, /* ter">Copyright & */ \
	0x63,0x6f,0x70,0x79,0x3b,0x20,0x32,0x30,0x31,0x31,0x2d,0x32,0x30,0x31,0x32,0x20, /* copy; 2011-2012  */ \
	0x53,0x61,0x74,0x6f,0x73,0x68,0x69,0x20,0x59,0x61,0x73,0x75,0x64,0x61,0x20,0x37, /* Satoshi Yasuda 7 */ \
	0x6d,0x33,0x74,0x6a,0x7a,0x2f,0x61,0x64,0x36,0x67,0x7a,0x3c,0x2f,0x64,0x69,0x76, /* m3tjz/ad6gz</div */ \
	0x3e,0x0a,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x3c, /* >..</div></div>< */ \
	0x2f,0x64,0x69,0x76,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x3c,0x2f,0x64,0x69,0x76, /* /div></div></div */ \
	0x3e,0x0a,0x0a,0x3c,0x2f,0x62,0x6f,0x64,0x79,0x3e,0x0a,0x3c,0x2f,0x68,0x74,0x6d, /* >..</body>.</htm */ \
	0x6c,0x3e,0x3c,0x21,0x44,0x4f,0x43,0x54,0x59,0x50,0x45,0x20,0x68,0x74,0x6d,0x6c, /* l><!DOCTYPE html */ \
	0x20,0x50,0x55,0x42,0x4c,0x49,0x43,0x20,0x22,0x2d,0x2f,0x2f,0x57,0x33,0x43,0x2f, /*  PUBLIC "-//W3C/ */ \
	0x2f,0x44,0x54,0x44,0x20,0x58,0x48,0x54,0x4d,0x4c,0x20,0x31,0x2e,0x30,0x20,0x53, /* /DTD XHTML 1.0 S */ \
	0x74,0x72,0x69,0x63,0x74,0x2f,0x2f,0x45,0x4e,0x22,0x0d,0x0a,0x20,0x20,0x22,0x68, /* trict//EN"..  "h */ \
	0x74,0x74,0x70,0x3a,0x2f,0x2f,0x77,0x77,0x77,0x2e,0x77,0x33,0x2e,0x6f,0x72,0x67, /* ttp://www.w3.org */ \
	0x2f,0x54,0x52,0x2f,0x78,0x68,0x74,0x6d,0x6c,0x31,0x2f,0x44,0x54,0x44,0x2f,0x78, /* /TR/xhtml1/DTD/x */ \
	0x68,0x74,0x6d,0x6c,0x31,0x2d,0x73,0x74,0x72,0x69,0x63,0x74,0x2e,0x64,0x74,0x64, /* html1-strict.dtd */ \
	0x22,0x3e,0x0d,0x0a,0x3c,0x68,0x74,0x6d,0x6c,0x20,0x78,0x6d,0x6c,0x6e,0x73,0x3d, /* ">..<html xmlns= */ \
	0x22,0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,0x77,0x77,0x77,0x2e,0x77,0x33,0x2e,0x6f, /* "http://www.w3.o */ \
	0x72,0x67,0x2f,0x31,0x39,0x39,0x39,0x2f,0x78,0x68,0x74,0x6d,0x6c,0x22,0x20,0x78, /* rg/1999/xhtml" x */ \
	0x6d,0x6c,0x3a,0x6c,0x61,0x6e,0x67,0x3d,0x22,0x65,0x6e,0x22,0x20,0x6c,0x61,0x6e, /* ml:lang="en" lan */ \
	0x67,0x3d,0x22,0x65,0x6e,0x22,0x3e,0x0d,0x0a,0x3c,0x68,0x65,0x61,0x64,0x3e,0x0d, /* g="en">..<head>. */ \
	0x0a,0x3c,0x74,0x69,0x74,0x6c,0x65,0x3e,0x53,0x74,0x61,0x6e,0x64,0x20,0x41,0x6c, /* .<title>Stand Al */ \
	0x6f,0x6e,0x65,0x20,0x41,0x63,0x63,0x65,0x73,0x73,0x20,0x50,0x6f,0x69,0x6e,0x74, /* one Access Point */ \
	0x3c,0x2f,0x74,0x69,0x74,0x6c,0x65,0x3e,0x0d,0x0a,0x3c,0x6c,0x69,0x6e,0x6b,0x20, /* </title>..<link  */ \
	0x68,0x72,0x65,0x66,0x3d,0x22,0x2f,0x37,0x6d,0x33,0x74,0x6a,0x7a,0x2e,0x63,0x73, /* href="/7m3tjz.cs */ \
	0x73,0x22,0x20,0x72,0x65,0x6c,0x3d,0x22,0x73,0x74,0x79,0x6c,0x65,0x73,0x68,0x65, /* s" rel="styleshe */ \
	0x65,0x74,0x22,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x2f,0x63, /* et" type="text/c */ \
	0x73,0x73,0x22,0x20,0x2f,0x3e,0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20, /* ss" />..<script  */ \
	0x73,0x72,0x63,0x3d,0x22,0x2f,0x37,0x6d,0x33,0x74,0x6a,0x7a,0x2e,0x6a,0x73,0x22, /* src="/7m3tjz.js" */ \
	0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x2f,0x6a,0x61,0x76,0x61, /*  type="text/java */ \
	0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74, /* script"></script */ \
	0x3e,0x0d,0x0a,0x3c,0x2f,0x68,0x65,0x61,0x64,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x73, /* >..</head>....<s */ \
	0x63,0x72,0x69,0x70,0x74,0x20,0x6c,0x61,0x6e,0x67,0x75,0x61,0x67,0x65,0x3d,0x22, /* cript language=" */ \
	0x4a,0x61,0x76,0x61,0x53,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x0d,0x0a,0x3c,0x21, /* JavaScript">..<! */ \
	0x2d,0x2d,0x0d,0x0a,0x2f,0x2f,0x20,0x74,0x72,0x65,0x65,0x20,0x6d,0x65,0x6e,0x75, /* --..// tree menu */ \
	0x0d,0x0a,0x66,0x6c,0x61,0x67,0x20,0x3d,0x20,0x66,0x61,0x6c,0x73,0x65,0x3b,0x0d, /* ..flag = false;. */ \
	0x0a,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x20,0x74,0x72,0x65,0x65,0x4d,0x65, /* .function treeMe */ \
	0x6e,0x75,0x28,0x74,0x4e,0x61,0x6d,0x65,0x29,0x20,0x7b,0x0d,0x0a,0x20,0x20,0x74, /* nu(tName) {..  t */ \
	0x4d,0x65,0x6e,0x75,0x20,0x3d,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e, /* Menu = document. */ \
	0x61,0x6c,0x6c,0x5b,0x74,0x4e,0x61,0x6d,0x65,0x5d,0x2e,0x73,0x74,0x79,0x6c,0x65, /* all[tName].style */ \
	0x3b,0x0d,0x0a,0x20,0x20,0x69,0x66,0x28,0x74,0x4d,0x65,0x6e,0x75,0x2e,0x64,0x69, /* ;..  if(tMenu.di */ \
	0x73,0x70,0x6c,0x61,0x79,0x20,0x3d,0x3d,0x20,0x27,0x6e,0x6f,0x6e,0x65,0x27,0x29, /* splay == 'none') */ \
	0x20,0x74,0x4d,0x65,0x6e,0x75,0x2e,0x64,0x69,0x73,0x70,0x6c,0x61,0x79,0x20,0x3d, /*  tMenu.display = */ \
	0x20,0x22,0x62,0x6c,0x6f,0x63,0x6b,0x22,0x3b,0x0d,0x0a,0x20,0x20,0x65,0x6c,0x73, /*  "block";..  els */ \
	0x65,0x20,0x74,0x4d,0x65,0x6e,0x75,0x2e,0x64,0x69,0x73,0x70,0x6c,0x61,0x79,0x20, /* e tMenu.display  */ \
	0x3d,0x20,0x22,0x6e,0x6f,0x6e,0x65,0x22,0x3b,0x0d,0x0a,0x7d,0x0d,0x0a,0x2f,0x2f, /* = "none";..}..// */ \
	0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74,0x3e,0x0d,0x0a, /* -->..</script>.. */ \
	0x0d,0x0a,0x3c,0x62,0x6f,0x64,0x79,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69, /* ..<body>..<div i */ \
	0x64,0x3d,0x22,0x73,0x68,0x61,0x64,0x6f,0x77,0x2d,0x6f,0x6e,0x65,0x22,0x3e,0x3c, /* d="shadow-one">< */ \
	0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x73,0x68,0x61,0x64,0x6f,0x77,0x2d,0x74, /* div id="shadow-t */ \
	0x77,0x6f,0x22,0x3e,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x73,0x68,0x61, /* wo"><div id="sha */ \
	0x64,0x6f,0x77,0x2d,0x74,0x68,0x72,0x65,0x65,0x22,0x3e,0x3c,0x64,0x69,0x76,0x20, /* dow-three"><div  */ \
	0x69,0x64,0x3d,0x22,0x73,0x68,0x61,0x64,0x6f,0x77,0x2d,0x66,0x6f,0x75,0x72,0x22, /* id="shadow-four" */ \
	0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x70,0x61,0x67,0x65, /* >..<div id="page */ \
	0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x74, /* ">....<div id="t */ \
	0x69,0x74,0x6c,0x65,0x22,0x3e,0x3c,0x64,0x69,0x76,0x20,0x63,0x6c,0x61,0x73,0x73, /* itle"><div class */ \
	0x3d,0x22,0x72,0x69,0x67,0x68,0x74,0x22,0x3e,0x64,0x53,0x71,0x75,0x61,0x72,0x65  /* ="right">dSquare */
#define DATACHUNK000009 \
	0x20,0x53,0x74,0x61,0x6e,0x64,0x20,0x41,0x6c,0x6f,0x6e,0x65,0x20,0x41,0x63,0x63, /*  Stand Alone Acc */ \
	0x65,0x73,0x73,0x20,0x50,0x6f,0x69,0x6e,0x74,0x20,0x56,0x30,0x30,0x2e,0x33,0x32, /* ess Point V00.32 */ \
	0x3c,0x2f,0x64,0x69,0x76,0x3e,0x3c,0x73,0x70,0x61,0x6e,0x20,0x69,0x64,0x3d,0x22, /* </div><span id=" */ \
	0x68,0x65,0x6c,0x6c,0x6f,0x22,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x73, /* hello">&nbsp;</s */ \
	0x70,0x61,0x6e,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76, /* pan></div>..<div */ \
	0x20,0x69,0x64,0x3d,0x22,0x6d,0x65,0x6e,0x75,0x22,0x3e,0x0d,0x0a,0x3c,0x61,0x20, /*  id="menu">..<a  */ \
	0x68,0x72,0x65,0x66,0x3d,0x22,0x2f,0x69,0x6e,0x64,0x65,0x78,0x2e,0x68,0x74,0x6d, /* href="/index.htm */ \
	0x22,0x3e,0x4f,0x76,0x65,0x72,0x76,0x69,0x65,0x77,0x3c,0x2f,0x61,0x3e,0x0d,0x0a, /* ">Overview</a>.. */ \
	0x3c,0x61,0x20,0x68,0x72,0x65,0x66,0x3d,0x22,0x2f,0x73,0x74,0x61,0x74,0x75,0x73, /* <a href="/status */ \
	0x2e,0x68,0x74,0x6d,0x22,0x3e,0x43,0x75,0x72,0x72,0x65,0x6e,0x74,0x20,0x53,0x74, /* .htm">Current St */ \
	0x61,0x74,0x75,0x73,0x3c,0x2f,0x61,0x3e,0x0d,0x0a,0x3c,0x61,0x20,0x68,0x72,0x65, /* atus</a>..<a hre */ \
	0x66,0x3d,0x22,0x2f,0x61,0x70,0x72,0x73,0x6d,0x73,0x67,0x2e,0x68,0x74,0x6d,0x22, /* f="/aprsmsg.htm" */ \
	0x3e,0x41,0x50,0x52,0x53,0x20,0x4d,0x73,0x67,0x2e,0x20,0x53,0x65,0x6e,0x64,0x3c, /* >APRS Msg. Send< */ \
	0x2f,0x61,0x3e,0x0d,0x0a,0x3c,0x41,0x20,0x68,0x72,0x65,0x66,0x3d,0x22,0x6a,0x61, /* /a>..<A href="ja */ \
	0x76,0x61,0x53,0x63,0x72,0x69,0x70,0x74,0x3a,0x74,0x72,0x65,0x65,0x4d,0x65,0x6e, /* vaScript:treeMen */ \
	0x75,0x28,0x27,0x74,0x72,0x65,0x65,0x4d,0x65,0x6e,0x75,0x31,0x27,0x29,0x22,0x3e, /* u('treeMenu1')"> */ \
	0x2b,0x20,0x53,0x41,0x41,0x50,0x20,0x53,0x65,0x74,0x74,0x69,0x6e,0x67,0x3c,0x2f, /* + SAAP Setting</ */ \
	0x61,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x74,0x72,0x65, /* a>..<div id="tre */ \
	0x65,0x4d,0x65,0x6e,0x75,0x31,0x22,0x20,0x73,0x74,0x79,0x6c,0x65,0x3d,0x22,0x64, /* eMenu1" style="d */ \
	0x69,0x73,0x70,0x6c,0x61,0x79,0x3a,0x6e,0x6f,0x6e,0x65,0x22,0x3e,0x0d,0x0a,0x3c, /* isplay:none">..< */ \
	0x61,0x20,0x68,0x72,0x65,0x66,0x3d,0x22,0x2f,0x70,0x72,0x6f,0x74,0x65,0x63,0x74, /* a href="/protect */ \
	0x2f,0x63,0x6f,0x6e,0x66,0x69,0x67,0x2e,0x68,0x74,0x6d,0x22,0x3e,0x4e,0x65,0x74, /* /config.htm">Net */ \
	0x77,0x6f,0x72,0x6b,0x20,0x43,0x6f,0x6e,0x66,0x69,0x67,0x75,0x72,0x61,0x74,0x69, /* work Configurati */ \
	0x6f,0x6e,0x3c,0x2f,0x61,0x3e,0x0d,0x0a,0x3c,0x61,0x20,0x68,0x72,0x65,0x66,0x3d, /* on</a>..<a href= */ \
	0x22,0x2f,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x67,0x61,0x74,0x65,0x77,0x61, /* "/protect/gatewa */ \
	0x79,0x61,0x75,0x74,0x68,0x2e,0x68,0x74,0x6d,0x22,0x3e,0x47,0x61,0x74,0x65,0x77, /* yauth.htm">Gatew */ \
	0x61,0x79,0x20,0x41,0x75,0x74,0x68,0x2e,0x20,0x43,0x61,0x6c,0x6c,0x73,0x69,0x67, /* ay Auth. Callsig */ \
	0x6e,0x3c,0x2f,0x61,0x3e,0x0d,0x0a,0x3c,0x61,0x20,0x68,0x72,0x65,0x66,0x3d,0x22, /* n</a>..<a href=" */ \
	0x2f,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x75,0x73,0x65,0x72,0x2e,0x68,0x74, /* /protect/user.ht */ \
	0x6d,0x22,0x3e,0x55,0x73,0x65,0x72,0x20,0x49,0x44,0x20,0x26,0x20,0x50,0x61,0x73, /* m">User ID & Pas */ \
	0x73,0x77,0x6f,0x72,0x64,0x20,0x73,0x65,0x74,0x74,0x69,0x6e,0x67,0x3c,0x2f,0x61, /* sword setting</a */ \
	0x3e,0x0d,0x0a,0x3c,0x61,0x20,0x68,0x72,0x65,0x66,0x3d,0x22,0x2f,0x70,0x72,0x6f, /* >..<a href="/pro */ \
	0x74,0x65,0x63,0x74,0x2f,0x75,0x70,0x64,0x61,0x74,0x65,0x2e,0x68,0x74,0x6d,0x22, /* tect/update.htm" */ \
	0x3e,0x46,0x69,0x72,0x6d,0x77,0x61,0x72,0x65,0x20,0x55,0x70,0x64,0x61,0x74,0x65, /* >Firmware Update */ \
	0x3c,0x2f,0x61,0x3e,0x0d,0x0a,0x3c,0x61,0x20,0x68,0x72,0x65,0x66,0x3d,0x22,0x2f, /* </a>..<a href="/ */ \
	0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x61,0x63,0x63,0x65,0x73,0x73,0x2e,0x68, /* protect/access.h */ \
	0x74,0x6d,0x22,0x3e,0x41,0x63,0x63,0x65,0x73,0x73,0x20,0x43,0x6f,0x6e,0x74,0x72, /* tm">Access Contr */ \
	0x6f,0x6c,0x20,0x46,0x69,0x6c,0x65,0x3c,0x2f,0x61,0x3e,0x0d,0x0a,0x3c,0x61,0x20, /* ol File</a>..<a  */ \
	0x68,0x72,0x65,0x66,0x3d,0x22,0x2f,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x72, /* href="/protect/r */ \
	0x65,0x62,0x6f,0x6f,0x74,0x2e,0x68,0x74,0x6d,0x22,0x3e,0x52,0x65,0x62,0x6f,0x6f, /* eboot.htm">Reboo */ \
	0x74,0x3c,0x2f,0x61,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c, /* t</a>..</div>..< */ \
	0x41,0x20,0x68,0x72,0x65,0x66,0x3d,0x22,0x6a,0x61,0x76,0x61,0x53,0x63,0x72,0x69, /* A href="javaScri */ \
	0x70,0x74,0x3a,0x74,0x72,0x65,0x65,0x4d,0x65,0x6e,0x75,0x28,0x27,0x74,0x72,0x65, /* pt:treeMenu('tre */ \
	0x65,0x4d,0x65,0x6e,0x75,0x32,0x27,0x29,0x22,0x3e,0x2b,0x20,0x4e,0x6f,0x64,0x65, /* eMenu2')">+ Node */ \
	0x20,0x41,0x64,0x61,0x70,0x74,0x65,0x72,0x20,0x53,0x65,0x74,0x74,0x69,0x6e,0x67, /*  Adapter Setting */ \
	0x3c,0x2f,0x61,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x74, /* </a>..<div id="t */ \
	0x72,0x65,0x65,0x4d,0x65,0x6e,0x75,0x32,0x22,0x20,0x73,0x74,0x79,0x6c,0x65,0x3d, /* reeMenu2" style= */ \
	0x22,0x64,0x69,0x73,0x70,0x6c,0x61,0x79,0x3a,0x6e,0x6f,0x6e,0x65,0x22,0x3e,0x0d, /* "display:none">. */ \
	0x0a,0x3c,0x61,0x20,0x68,0x72,0x65,0x66,0x3d,0x22,0x2f,0x6e,0x6f,0x64,0x65,0x61, /* .<a href="/nodea */ \
	0x64,0x61,0x70,0x74,0x65,0x72,0x2f,0x63,0x6f,0x6e,0x66,0x69,0x67,0x2e,0x68,0x74, /* dapter/config.ht */ \
	0x6d,0x22,0x3e,0x4e,0x6f,0x64,0x65,0x20,0x41,0x64,0x61,0x70,0x74,0x65,0x72,0x20, /* m">Node Adapter  */ \
	0x43,0x6f,0x6e,0x66,0x69,0x67,0x75,0x72,0x61,0x74,0x69,0x6f,0x6e,0x3c,0x2f,0x61, /* Configuration</a */ \
	0x3e,0x0d,0x0a,0x3c,0x61,0x20,0x68,0x72,0x65,0x66,0x3d,0x22,0x2f,0x6e,0x6f,0x64, /* >..<a href="/nod */ \
	0x65,0x61,0x64,0x61,0x70,0x74,0x65,0x72,0x2f,0x63,0x6f,0x6e,0x66,0x69,0x67,0x32, /* eadapter/config2 */ \
	0x2e,0x68,0x74,0x6d,0x22,0x3e,0x42,0x65,0x61,0x63,0x6f,0x6e,0x20,0x43,0x6f,0x6e, /* .htm">Beacon Con */ \
	0x66,0x69,0x67,0x75,0x72,0x61,0x74,0x69,0x6f,0x6e,0x3c,0x2f,0x61,0x3e,0x0d,0x0a, /* figuration</a>.. */ \
	0x3c,0x61,0x20,0x68,0x72,0x65,0x66,0x3d,0x22,0x2f,0x6e,0x6f,0x64,0x65,0x61,0x64, /* <a href="/nodead */ \
	0x61,0x70,0x74,0x65,0x72,0x2f,0x63,0x6f,0x6e,0x66,0x69,0x67,0x33,0x2e,0x68,0x74, /* apter/config3.ht */ \
	0x6d,0x22,0x3e,0x54,0x58,0x20,0x48,0x65,0x61,0x64,0x65,0x72,0x20,0x52,0x65,0x70, /* m">TX Header Rep */ \
	0x6c,0x61,0x63,0x65,0x20,0x43,0x6f,0x6e,0x66,0x69,0x67,0x75,0x72,0x61,0x74,0x69, /* lace Configurati */ \
	0x6f,0x6e,0x3c,0x2f,0x61,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a, /* on</a>..</div>.. */ \
	0x3c,0x41,0x20,0x68,0x72,0x65,0x66,0x3d,0x22,0x6a,0x61,0x76,0x61,0x53,0x63,0x72, /* <A href="javaScr */ \
	0x69,0x70,0x74,0x3a,0x74,0x72,0x65,0x65,0x4d,0x65,0x6e,0x75,0x28,0x27,0x74,0x72, /* ipt:treeMenu('tr */ \
	0x65,0x65,0x4d,0x65,0x6e,0x75,0x33,0x27,0x29,0x22,0x3e,0x2b,0x20,0x44,0x50,0x52  /* eeMenu3')">+ DPR */
#define DATACHUNK00000a \
	0x53,0x20,0x53,0x65,0x74,0x74,0x69,0x6e,0x67,0x3c,0x2f,0x61,0x3e,0x0d,0x0a,0x3c, /* S Setting</a>..< */ \
	0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x74,0x72,0x65,0x65,0x4d,0x65,0x6e,0x75, /* div id="treeMenu */ \
	0x33,0x22,0x20,0x73,0x74,0x79,0x6c,0x65,0x3d,0x22,0x64,0x69,0x73,0x70,0x6c,0x61, /* 3" style="displa */ \
	0x79,0x3a,0x6e,0x6f,0x6e,0x65,0x22,0x3e,0x0d,0x0a,0x3c,0x61,0x20,0x68,0x72,0x65, /* y:none">..<a hre */ \
	0x66,0x3d,0x22,0x2f,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x64,0x70,0x72,0x73, /* f="/protect/dprs */ \
	0x2e,0x68,0x74,0x6d,0x22,0x3e,0x44,0x50,0x52,0x53,0x20,0x43,0x6f,0x6e,0x66,0x69, /* .htm">DPRS Confi */ \
	0x67,0x75,0x72,0x61,0x74,0x69,0x6f,0x6e,0x3c,0x2f,0x61,0x3e,0x0d,0x0a,0x3c,0x61, /* guration</a>..<a */ \
	0x20,0x68,0x72,0x65,0x66,0x3d,0x22,0x2f,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f, /*  href="/protect/ */ \
	0x44,0x70,0x72,0x73,0x4d,0x73,0x67,0x43,0x74,0x72,0x6c,0x2e,0x68,0x74,0x6d,0x22, /* DprsMsgCtrl.htm" */ \
	0x3e,0x41,0x50,0x52,0x53,0x20,0x4d,0x73,0x67,0x2e,0x20,0x43,0x6f,0x6e,0x74,0x72, /* >APRS Msg. Contr */ \
	0x6f,0x6c,0x3c,0x2f,0x61,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a, /* ol</a>..</div>.. */ \
	0x3c,0x2f,0x64,0x69,0x76,0x3e,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65, /* </div>~inc:heade */ \
	0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d, /* r.inc~..<div id= */ \
	0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68, /* "content">....<h */ \
	0x31,0x3e,0x53,0x74,0x61,0x6e,0x64,0x20,0x41,0x6c,0x6f,0x6e,0x65,0x20,0x41,0x63, /* 1>Stand Alone Ac */ \
	0x63,0x65,0x73,0x73,0x20,0x50,0x6f,0x69,0x6e,0x74,0x3c,0x2f,0x68,0x31,0x3e,0x0d, /* cess Point</h1>. */ \
	0x0a,0x3c,0x74,0x61,0x62,0x6c,0x65,0x20,0x73,0x74,0x79,0x6c,0x65,0x3d,0x22,0x70, /* .<table style="p */ \
	0x61,0x64,0x64,0x69,0x6e,0x67,0x2d,0x6c,0x65,0x66,0x74,0x3a,0x20,0x31,0x30,0x70, /* adding-left: 10p */ \
	0x78,0x3b,0x22,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62, /* x;">..<tr><td><b */ \
	0x3e,0x4e,0x6f,0x64,0x65,0x20,0x43,0x61,0x6c,0x6c,0x73,0x69,0x67,0x6e,0x20,0x3a, /* >Node Callsign : */ \
	0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62, /* </b></td><td>&nb */ \
	0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x4e,0x6f,0x64, /* sp;</td><td>~Nod */ \
	0x65,0x4e,0x61,0x6d,0x65,0x7e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e, /* eName~</td></tr> */ \
	0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x69,0x72,0x63, /* ..<tr><td><b>irc */ \
	0x44,0x44,0x42,0x20,0x44,0x4e,0x53,0x20,0x75,0x73,0x65,0x20,0x3a,0x3c,0x2f,0x62, /* DDB DNS use :</b */ \
	0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b, /* ></td><td>&nbsp; */ \
	0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75, /* </td><td>..<inpu */ \
	0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78, /* t type="checkbox */ \
	0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x73,0x6d,0x22,0x20,0x7e,0x69,0x72, /* " class="sm" ~ir */ \
	0x63,0x44,0x44,0x42,0x7e,0x20,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x2f, /* cDDB~ disabled / */ \
	0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x7e,0x69,0x72,0x63,0x44,0x44,0x42,0x74,0x79, /* >&nbsp;~ircDDBty */ \
	0x70,0x65,0x7e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c, /* pe~</td></tr>..< */ \
	0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x52,0x65,0x70,0x65,0x61,0x74, /* tr><td><b>Repeat */ \
	0x65,0x72,0x2f,0x52,0x65,0x66,0x6c,0x65,0x63,0x74,0x6f,0x72,0x20,0x4e,0x61,0x6d, /* er/Reflector Nam */ \
	0x65,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e, /* e :</b></td><td> */ \
	0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e, /* &nbsp;</td><td>~ */ \
	0x52,0x65,0x66,0x4e,0x61,0x6d,0x65,0x7e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74, /* RefName~</td></t */ \
	0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x44, /* r>..<tr><td><b>D */ \
	0x50,0x6c,0x75,0x73,0x20,0x47,0x61,0x74,0x65,0x2f,0x52,0x65,0x66,0x2e,0x20,0x49, /* Plus Gate/Ref. I */ \
	0x50,0x20,0x61,0x64,0x64,0x72,0x65,0x73,0x73,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c, /* P address :</b>< */ \
	0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f, /* /td><td>&nbsp;</ */ \
	0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x73,0x65,0x72,0x76,0x65,0x72,0x5f,0x6e, /* td><td>~server_n */ \
	0x61,0x6d,0x65,0x7e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a, /* ame~</td></tr>.. */ \
	0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x41,0x75,0x74,0x6f,0x2e, /* <tr><td><b>Auto. */ \
	0x20,0x4c,0x69,0x6e,0x6b,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e, /*  Link :</b></td> */ \
	0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c, /* <td>&nbsp;</td>< */ \
	0x74,0x64,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65, /* td>..<input type */ \
	0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x63,0x6c,0x61,0x73, /* ="checkbox" clas */ \
	0x73,0x3d,0x22,0x73,0x6d,0x22,0x20,0x7e,0x41,0x75,0x74,0x43,0x6f,0x6e,0x6e,0x65, /* s="sm" ~AutConne */ \
	0x63,0x74,0x7e,0x20,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x2f,0x3e,0x3c, /* ct~ disabled />< */ \
	0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c, /* /td></tr>..<tr>< */ \
	0x74,0x64,0x3e,0x3c,0x62,0x3e,0x41,0x75,0x74,0x6f,0x2e,0x20,0x52,0x65,0x4c,0x69, /* td><b>Auto. ReLi */ \
	0x6e,0x6b,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64, /* nk :</b></td><td */ \
	0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e, /* >&nbsp;</td><td> */ \
	0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63, /* ..<input type="c */ \
	0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22, /* heckbox" class=" */ \
	0x73,0x6d,0x22,0x20,0x7e,0x52,0x65,0x43,0x6f,0x6e,0x6e,0x65,0x63,0x74,0x7e,0x20, /* sm" ~ReConnect~  */ \
	0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x2f,0x3e,0x3c,0x2f,0x74,0x64,0x3e, /* disabled /></td> */ \
	0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c, /* </tr>..<tr><td>< */ \
	0x62,0x3e,0x52,0x65,0x70,0x65,0x61,0x74,0x65,0x72,0x20,0x41,0x63,0x63,0x65,0x73, /* b>Repeater Acces */ \
	0x73,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e, /* s :</b></td><td> */ \
	0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x0d, /* &nbsp;</td><td>. */ \
	0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68, /* .<input type="ch */ \
	0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x73  /* eckbox" class="s */
#define DATACHUNK00000b \
	0x6d,0x22,0x20,0x7e,0x52,0x65,0x70,0x65,0x61,0x74,0x65,0x72,0x7e,0x20,0x64,0x69, /* m" ~Repeater~ di */ \
	0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x2f,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f, /* sabled /></td></ */ \
	0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e, /* tr>..<tr><td><b> */ \
	0x4e,0x54,0x50,0x20,0x53,0x65,0x72,0x76,0x65,0x72,0x20,0x44,0x6f,0x6d,0x61,0x69, /* NTP Server Domai */ \
	0x6e,0x20,0x4e,0x61,0x6d,0x65,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64, /* n Name :</b></td */ \
	0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e, /* ><td>&nbsp;</td> */ \
	0x3c,0x74,0x64,0x3e,0x7e,0x4e,0x74,0x70,0x4e,0x61,0x6d,0x65,0x7e,0x3c,0x2f,0x74, /* <td>~NtpName~</t */ \
	0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64, /* d></tr>..<tr><td */ \
	0x3e,0x3c,0x62,0x3e,0x54,0x69,0x6d,0x65,0x20,0x5a,0x6f,0x6e,0x65,0x20,0x3a,0x3c, /* ><b>Time Zone :< */ \
	0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73, /* /b></td><td>&nbs */ \
	0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x54,0x69,0x6d,0x65, /* p;</td><td>~Time */ \
	0x5a,0x6f,0x6e,0x65,0x7e,0x20,0x26,0x6e,0x62,0x73,0x70,0x3b,0x68,0x6f,0x75,0x72, /* Zone~ &nbsp;hour */ \
	0x73,0x26,0x6e,0x62,0x73,0x70,0x3b,0x7e,0x54,0x69,0x6d,0x65,0x5a,0x6f,0x6e,0x65, /* s&nbsp;~TimeZone */ \
	0x4d,0x69,0x6e,0x75,0x74,0x65,0x73,0x7e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x6d,0x69, /* Minutes~&nbsp;mi */ \
	0x6e,0x75,0x74,0x65,0x73,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d, /* nutes</td></tr>. */ \
	0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x4a,0x69,0x74,0x74, /* .<tr><td><b>Jitt */ \
	0x65,0x72,0x20,0x42,0x75,0x66,0x66,0x65,0x72,0x20,0x57,0x61,0x69,0x74,0x20,0x50, /* er Buffer Wait P */ \
	0x61,0x63,0x6b,0x65,0x74,0x73,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64, /* ackets :</b></td */ \
	0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e, /* ><td>&nbsp;</td> */ \
	0x3c,0x74,0x64,0x3e,0x7e,0x4a,0x69,0x74,0x74,0x65,0x72,0x53,0x69,0x7a,0x65,0x7e, /* <td>~JitterSize~ */ \
	0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e, /* </td></tr>..<tr> */ \
	0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x44,0x69,0x73,0x61,0x62,0x6c,0x65,0x20,0x4c, /* <td><b>Disable L */ \
	0x69,0x6e,0x6b,0x2f,0x55,0x6e,0x6c,0x69,0x6e,0x6b,0x20,0x66,0x72,0x6f,0x6d,0x20, /* ink/Unlink from  */ \
	0x52,0x46,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64, /* RF :</b></td><td */ \
	0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e, /* >&nbsp;</td><td> */ \
	0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63, /* ..<input type="c */ \
	0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22, /* heckbox" class=" */ \
	0x73,0x6d,0x22,0x20,0x7e,0x44,0x69,0x73,0x61,0x62,0x6c,0x65,0x52,0x46,0x63,0x6d, /* sm" ~DisableRFcm */ \
	0x64,0x7e,0x20,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x2f,0x3e,0x3c,0x2f, /* d~ disabled /></ */ \
	0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x62,0x72,0x3e,0x0d,0x0a, /* td></tr>..<br>.. */ \
	0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x56,0x6f,0x69,0x63,0x65, /* <tr><td><b>Voice */ \
	0x20,0x4d,0x65,0x73,0x73,0x61,0x67,0x65,0x20,0x4f,0x46,0x46,0x20,0x3a,0x3c,0x2f, /*  Message OFF :</ */ \
	0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73,0x70, /* b></td><td>&nbsp */ \
	0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70, /* ;</td><td>..<inp */ \
	0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f, /* ut type="checkbo */ \
	0x78,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x73,0x6d,0x22,0x20,0x20,0x7e, /* x" class="sm"  ~ */ \
	0x56,0x6f,0x69,0x63,0x65,0x4d,0x73,0x67,0x7e,0x20,0x64,0x69,0x73,0x61,0x62,0x6c, /* VoiceMsg~ disabl */ \
	0x65,0x64,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x0d, /* ed /></div>..... */ \
	0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x47,0x61,0x74,0x65, /* .<tr><td><b>Gate */ \
	0x2f,0x52,0x65,0x66,0x2e,0x20,0x46,0x69,0x6c,0x65,0x20,0x44,0x61,0x74,0x65,0x20, /* /Ref. File Date  */ \
	0x26,0x20,0x54,0x69,0x6d,0x65,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64, /* & Time :</b></td */ \
	0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e, /* ><td>&nbsp;</td> */ \
	0x3c,0x74,0x64,0x3e,0x7e,0x44,0x61,0x74,0x65,0x54,0x69,0x6d,0x65,0x7e,0x3c,0x2f, /* <td>~DateTime~</ */ \
	0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x2f,0x74,0x61,0x62,0x6c, /* td></tr>..</tabl */ \
	0x65,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x73,0x63,0x72, /* e>..</div>..<scr */ \
	0x69,0x70,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x2f,0x6a, /* ipt type="text/j */ \
	0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x0d,0x0a,0x3c,0x21,0x2d, /* avascript">..<!- */ \
	0x2d,0x0d,0x0a,0x2f,0x2f,0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69, /* -..//-->..</scri */ \
	0x70,0x74,0x3e,0x0d,0x0a,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74, /* pt>....~inc:foot */ \
	0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x00,0x00,0x00,0x00,0x33,0x00,0x00, /* er.inc~......3.. */ \
	0x00,0xa6,0x00,0x00,0x00,0x4e,0x00,0x00,0x00,0x17,0x01,0x00,0x00,0xd0,0x00,0x00, /* .....N.......... */ \
	0x00,0x31,0x01,0x00,0x00,0xd1,0x00,0x00,0x00,0x89,0x01,0x00,0x00,0x8a,0x00,0x00, /* .1.............. */ \
	0x00,0xe1,0x01,0x00,0x00,0x4a,0x00,0x00,0x00,0x51,0x02,0x00,0x00,0xa2,0x00,0x00, /* .....J...Q...... */ \
	0x00,0xce,0x02,0x00,0x00,0x9a,0x00,0x00,0x00,0x4d,0x03,0x00,0x00,0xa0,0x00,0x00, /* .........M...... */ \
	0x00,0xae,0x03,0x00,0x00,0x60,0x00,0x00,0x00,0xf5,0x03,0x00,0x00,0x61,0x00,0x00, /* .....`.......a.. */ \
	0x00,0x11,0x04,0x00,0x00,0x6d,0x00,0x00,0x00,0x7e,0x04,0x00,0x00,0x6e,0x00,0x00, /* .....m...~...n.. */ \
	0x00,0xfe,0x04,0x00,0x00,0xa1,0x00,0x00,0x00,0x89,0x05,0x00,0x00,0xa7,0x00,0x00, /* ................ */ \
	0x00,0xee,0x05,0x00,0x00,0xa6,0x00,0x00,0x00,0x51,0x06,0x00,0x00,0x02,0x00,0x00, /* .........Q...... */ \
	0x00,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63, /* .~inc:header.inc */ \
	0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74, /* ~..<div id="cont */ \
	0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x47,0x61,0x74, /* ent">....<h1>Gat */ \
	0x65,0x77,0x61,0x79,0x2f,0x52,0x65,0x66,0x6c,0x65,0x63,0x74,0x6f,0x72,0x20,0x53, /* eway/Reflector S */ \
	0x65,0x6c,0x65,0x63,0x74,0x3c,0x2f,0x68,0x31,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x66, /* elect</h1>....<f */ \
	0x6f,0x72,0x6d,0x20,0x6d,0x65,0x74,0x68,0x6f,0x64,0x3d,0x22,0x70,0x6f,0x73,0x74  /* orm method="post */
#define DATACHUNK00000c \
	0x22,0x20,0x61,0x63,0x74,0x69,0x6f,0x6e,0x3d,0x22,0x2f,0x72,0x65,0x66,0x73,0x65, /* " action="/refse */ \
	0x6c,0x65,0x63,0x74,0x2e,0x68,0x74,0x6d,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22, /* lect.htm" name=" */ \
	0x72,0x65,0x66,0x73,0x65,0x6c,0x22,0x3e,0x0d,0x0a,0x3c,0x66,0x69,0x65,0x6c,0x64, /* refsel">..<field */ \
	0x73,0x65,0x74,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65, /* set>..<div><labe */ \
	0x6c,0x3e,0x69,0x72,0x63,0x44,0x44,0x42,0x20,0x44,0x4e,0x53,0x20,0x75,0x73,0x65, /* l>ircDDB DNS use */ \
	0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75, /* :</label>..<inpu */ \
	0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78, /* t type="checkbox */ \
	0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x73,0x6d,0x22,0x20,0x6e,0x61,0x6d, /* " class="sm" nam */ \
	0x65,0x3d,0x22,0x69,0x72,0x63,0x64,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22, /* e="ircd" value=" */ \
	0x31,0x22,0x20,0x7e,0x69,0x72,0x63,0x44,0x44,0x42,0x7e,0x20,0x6f,0x6e,0x63,0x6c, /* 1" ~ircDDB~ oncl */ \
	0x69,0x63,0x6b,0x3d,0x22,0x63,0x6f,0x6e,0x66,0x69,0x67,0x49,0x52,0x43,0x28,0x29, /* ick="configIRC() */ \
	0x22,0x20,0x2f,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x0d,0x0a,0x54,0x79,0x70,0x65, /* " />&nbsp;..Type */ \
	0x20,0x3a,0x3c,0x73,0x65,0x6c,0x65,0x63,0x74,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22, /*  :<select name=" */ \
	0x69,0x72,0x63,0x74,0x22,0x3e,0x0d,0x0a,0x7e,0x69,0x72,0x63,0x53,0x65,0x6c,0x65, /* irct">..~ircSele */ \
	0x63,0x74,0x7e,0x0d,0x0a,0x3c,0x2f,0x73,0x65,0x6c,0x65,0x63,0x74,0x3e,0x0d,0x0a, /* ct~..</select>.. */ \
	0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61, /* </div>..<div><la */ \
	0x62,0x65,0x6c,0x3e,0x52,0x65,0x70,0x65,0x61,0x74,0x65,0x72,0x2f,0x52,0x65,0x66, /* bel>Repeater/Ref */ \
	0x6c,0x65,0x63,0x74,0x6f,0x72,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d, /* lector:</label>. */ \
	0x0a,0x7e,0x52,0x65,0x66,0x53,0x65,0x6c,0x65,0x63,0x74,0x46,0x69,0x72,0x73,0x74, /* .~RefSelectFirst */ \
	0x7e,0x0d,0x0a,0x7e,0x52,0x65,0x66,0x53,0x65,0x6c,0x65,0x63,0x74,0x7e,0x0d,0x0a, /* ~..~RefSelect~.. */ \
	0x26,0x6e,0x62,0x73,0x70,0x3b,0x42,0x61,0x6e,0x64,0x26,0x6e,0x62,0x73,0x70,0x3b, /* &nbsp;Band&nbsp; */ \
	0x0d,0x0a,0x3c,0x73,0x65,0x6c,0x65,0x63,0x74,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22, /* ..<select name=" */ \
	0x62,0x61,0x6e,0x64,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x33, /* band" class="ad3 */ \
	0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x31,0x22,0x2f,0x3e,0x0d,0x0a,0x7e,0x42, /* " size="1"/>..~B */ \
	0x61,0x6e,0x64,0x53,0x65,0x6c,0x65,0x63,0x74,0x7e,0x0d,0x0a,0x3c,0x2f,0x73,0x65, /* andSelect~..</se */ \
	0x6c,0x65,0x63,0x74,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c, /* lect>..</div>..< */ \
	0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x44,0x43,0x53,0x2f,0x58, /* div><label>DCS/X */ \
	0x52,0x46,0x20,0x72,0x65,0x66,0x6c,0x65,0x63,0x74,0x6f,0x72,0x3a,0x3c,0x2f,0x6c, /* RF reflector:</l */ \
	0x61,0x62,0x65,0x6c,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70, /* abel>&nbsp;&nbsp */ \
	0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62, /* ;&nbsp;&nbsp;&nb */ \
	0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26, /* sp;&nbsp;&nbsp;& */ \
	0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x0d,0x0a,0x3c,0x69,0x6e, /* nbsp;&nbsp;..<in */ \
	0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20, /* put type="text"  */ \
	0x6e,0x61,0x6d,0x65,0x3d,0x22,0x69,0x72,0x63,0x72,0x22,0x20,0x76,0x61,0x6c,0x75, /* name="ircr" valu */ \
	0x65,0x3d,0x22,0x7e,0x69,0x72,0x63,0x5f,0x72,0x65,0x66,0x7e,0x22,0x20,0x73,0x69, /* e="~irc_ref~" si */ \
	0x7a,0x65,0x3d,0x22,0x38,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64, /* ze="8" class="ad */ \
	0x33,0x22,0x2f,0x3e,0x0d,0x0a,0x26,0x6e,0x62,0x73,0x70,0x3b,0x42,0x61,0x6e,0x64, /* 3"/>..&nbsp;Band */ \
	0x26,0x6e,0x62,0x73,0x70,0x3b,0x0d,0x0a,0x3c,0x73,0x65,0x6c,0x65,0x63,0x74,0x20, /* &nbsp;..<select  */ \
	0x6e,0x61,0x6d,0x65,0x3d,0x22,0x69,0x72,0x63,0x62,0x22,0x20,0x63,0x6c,0x61,0x73, /* name="ircb" clas */ \
	0x73,0x3d,0x22,0x61,0x64,0x33,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x31,0x22, /* s="ad3" size="1" */ \
	0x2f,0x3e,0x0d,0x0a,0x7e,0x69,0x72,0x63,0x42,0x61,0x6e,0x64,0x53,0x65,0x6c,0x65, /* />..~ircBandSele */ \
	0x63,0x74,0x7e,0x0d,0x0a,0x3c,0x2f,0x73,0x65,0x6c,0x65,0x63,0x74,0x3e,0x3c,0x2f, /* ct~..</select></ */ \
	0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x62,0x72,0x3e,0x0d,0x0a,0x3c,0x62, /* div>....<br>..<b */ \
	0x72,0x3e,0x0d,0x0a,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b, /* r>..&nbsp;&nbsp; */ \
	0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x73,0x75,0x62, /* <input type="sub */ \
	0x6d,0x69,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6c,0x6e,0x6b,0x69,0x22, /* mit" name="lnki" */ \
	0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x4c,0x69,0x6e,0x6b,0x20,0x49,0x6d,0x6d, /*  value="Link Imm */ \
	0x65,0x64,0x69,0x61,0x74,0x65,0x6c,0x79,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d, /* ediately" class= */ \
	0x22,0x61,0x64,0x33,0x22,0x20,0x2f,0x3e,0x0d,0x0a,0x26,0x6e,0x62,0x73,0x70,0x3b, /* "ad3" />..&nbsp; */ \
	0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73, /* &nbsp;&nbsp;&nbs */ \
	0x70,0x3b,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x73, /* p;<input type="s */ \
	0x75,0x62,0x6d,0x69,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6c,0x6e,0x6b, /* ubmit" name="lnk */ \
	0x77,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x4c,0x69,0x6e,0x6b,0x20,0x49, /* w" value="Link I */ \
	0x6d,0x6d,0x65,0x64,0x69,0x61,0x74,0x65,0x6c,0x79,0x20,0x77,0x69,0x74,0x68,0x6f, /* mmediately witho */ \
	0x75,0x74,0x20,0x56,0x6f,0x69,0x63,0x65,0x20,0x4d,0x73,0x67,0x2e,0x22,0x20,0x63, /* ut Voice Msg." c */ \
	0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x33,0x22,0x20,0x2f,0x3e,0x0d,0x0a,0x3c, /* lass="ad3" />..< */ \
	0x62,0x72,0x3e,0x3c,0x62,0x72,0x3e,0x0d,0x0a,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26, /* br><br>..&nbsp;& */ \
	0x6e,0x62,0x73,0x70,0x3b,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65, /* nbsp;<input type */ \
	0x3d,0x22,0x73,0x75,0x62,0x6d,0x69,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22, /* ="submit" name=" */ \
	0x72,0x65,0x66,0x66,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x52,0x65,0x66, /* reff" value="Ref */ \
	0x72,0x65,0x73,0x68,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x33, /* resh" class="ad3 */ \
	0x22,0x20,0x2f,0x3e,0x0d,0x0a,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73, /* " />..&nbsp;&nbs */ \
	0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x69, /* p;&nbsp;&nbsp;<i */ \
	0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x73,0x75,0x62,0x6d,0x69  /* nput type="submi */
#define DATACHUNK00000d \
	0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x63,0x61,0x6e,0x63,0x22,0x20,0x76, /* t" name="canc" v */ \
	0x61,0x6c,0x75,0x65,0x3d,0x22,0x43,0x61,0x6e,0x63,0x65,0x6c,0x22,0x20,0x63,0x6c, /* alue="Cancel" cl */ \
	0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x33,0x22,0x20,0x2f,0x3e,0x0d,0x0a,0x3c,0x62, /* ass="ad3" />..<b */ \
	0x72,0x3e,0x3c,0x62,0x72,0x3e,0x0d,0x0a,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e, /* r><br>..&nbsp;&n */ \
	0x62,0x73,0x70,0x3b,0x3c,0x66,0x6f,0x6e,0x74,0x20,0x63,0x6f,0x6c,0x6f,0x72,0x3d, /* bsp;<font color= */ \
	0x72,0x65,0x64,0x3e,0x3c,0x62,0x3e,0x0d,0x0a,0x7e,0x4e,0x6f,0x74,0x69,0x63,0x65, /* red><b>..~Notice */ \
	0x7e,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x66,0x6f,0x6e,0x74,0x3e,0x0d,0x0a,0x3c,0x62, /* ~</b></font>..<b */ \
	0x72,0x3e,0x3c,0x62,0x72,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x69,0x65,0x6c,0x64,0x73, /* r><br>..</fields */ \
	0x65,0x74,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x6f,0x72,0x6d,0x3e,0x0d,0x0a,0x3c,0x2f, /* et>..</form>..</ */ \
	0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20, /* div>....<script  */ \
	0x6c,0x61,0x6e,0x67,0x75,0x61,0x67,0x65,0x3d,0x22,0x6a,0x61,0x76,0x61,0x73,0x63, /* language="javasc */ \
	0x72,0x69,0x70,0x74,0x22,0x3e,0x0d,0x0a,0x2f,0x2f,0x2d,0x2d,0x3e,0x0d,0x0a,0x66, /* ript">..//-->..f */ \
	0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x20,0x63,0x6f,0x6e,0x66,0x69,0x67,0x49,0x52, /* unction configIR */ \
	0x43,0x28,0x29,0x20,0x7b,0x0d,0x0a,0x09,0x65,0x20,0x3d,0x20,0x64,0x6f,0x63,0x75, /* C() {...e = docu */ \
	0x6d,0x65,0x6e,0x74,0x2e,0x66,0x6f,0x72,0x6d,0x73,0x2e,0x72,0x65,0x66,0x73,0x65, /* ment.forms.refse */ \
	0x6c,0x3b,0x0d,0x0a,0x09,0x73,0x74,0x20,0x3d,0x20,0x65,0x2e,0x69,0x72,0x63,0x64, /* l;...st = e.ircd */ \
	0x2e,0x63,0x68,0x65,0x63,0x6b,0x65,0x64,0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x52,0x65, /* .checked;...e.Re */ \
	0x66,0x6e,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74, /* fn.disabled = st */ \
	0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x62,0x61,0x6e,0x64,0x2e,0x64,0x69,0x73,0x61,0x62, /* ;...e.band.disab */ \
	0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x69,0x72, /* led = st;...e.ir */ \
	0x63,0x74,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x21,0x73, /* ct.disabled = !s */ \
	0x74,0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x69,0x72,0x63,0x72,0x2e,0x64,0x69,0x73,0x61, /* t;...e.ircr.disa */ \
	0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x21,0x73,0x74,0x3b,0x0d,0x0a,0x09,0x65,0x2e, /* bled = !st;...e. */ \
	0x69,0x72,0x63,0x62,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20, /* ircb.disabled =  */ \
	0x21,0x73,0x74,0x3b,0x0d,0x0a,0x7d,0x0d,0x0a,0x0d,0x0a,0x63,0x6f,0x6e,0x66,0x69, /* !st;..}....confi */ \
	0x67,0x49,0x52,0x43,0x28,0x29,0x3b,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70, /* gIRC();..</scrip */ \
	0x74,0x3e,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e, /* t>..~inc:footer. */ \
	0x69,0x6e,0x63,0x7e,0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0xf2,0x00,0x00,0x00, /* inc~....3....... */ \
	0xd0,0x00,0x00,0x00,0x37,0x01,0x00,0x00,0xd2,0x00,0x00,0x00,0x80,0x01,0x00,0x00, /* ....7........... */ \
	0xc2,0x00,0x00,0x00,0x92,0x01,0x00,0x00,0x8d,0x00,0x00,0x00,0xdd,0x01,0x00,0x00, /* ................ */ \
	0x99,0x00,0x00,0x00,0x82,0x02,0x00,0x00,0xd3,0x00,0x00,0x00,0xe3,0x02,0x00,0x00, /* ................ */ \
	0xd4,0x00,0x00,0x00,0xb8,0x04,0x00,0x00,0xa5,0x00,0x00,0x00,0x03,0x06,0x00,0x00, /* ................ */ \
	0x02,0x00,0x00,0x00,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e, /* ....~inc:header. */ \
	0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x2f,0x62,0x6f,0x64,0x79,0x3e,0x0d,0x0a,0x3c, /* inc~..</body>..< */ \
	0x62,0x6f,0x64,0x79,0x20,0x6f,0x6e,0x4c,0x6f,0x61,0x64,0x3d,0x22,0x74,0x69,0x6d, /* body onLoad="tim */ \
	0x65,0x5f,0x73,0x65,0x74,0x28,0x29,0x22,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20, /* e_set()">..<div  */ \
	0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d, /* id="content">... */ \
	0x0a,0x3c,0x68,0x31,0x3e,0x53,0x74,0x61,0x6e,0x64,0x20,0x41,0x6c,0x6f,0x6e,0x65, /* .<h1>Stand Alone */ \
	0x20,0x41,0x63,0x63,0x65,0x73,0x73,0x20,0x50,0x6f,0x69,0x6e,0x74,0x3c,0x2f,0x68, /*  Access Point</h */ \
	0x31,0x3e,0x0d,0x0a,0x3c,0x66,0x6f,0x72,0x6d,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22, /* 1>..<form name=" */ \
	0x73,0x74,0x61,0x74,0x75,0x73,0x22,0x20,0x6d,0x65,0x74,0x68,0x6f,0x64,0x3d,0x22, /* status" method=" */ \
	0x70,0x6f,0x73,0x74,0x22,0x20,0x61,0x63,0x74,0x69,0x6f,0x6e,0x3d,0x22,0x73,0x74, /* post" action="st */ \
	0x61,0x74,0x75,0x73,0x2e,0x68,0x74,0x6d,0x22,0x3e,0x0d,0x0a,0x3c,0x74,0x61,0x62, /* atus.htm">..<tab */ \
	0x6c,0x65,0x20,0x73,0x74,0x79,0x6c,0x65,0x3d,0x22,0x70,0x61,0x64,0x64,0x69,0x6e, /* le style="paddin */ \
	0x67,0x2d,0x6c,0x65,0x66,0x74,0x3a,0x20,0x31,0x30,0x70,0x78,0x3b,0x22,0x3e,0x0d, /* g-left: 10px;">. */ \
	0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x44,0x61,0x74,0x65, /* .<tr><td><b>Date */ \
	0x20,0x3a,0x20,0x3c,0x2f,0x62,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x7e,0x43,0x75, /*  : </b>&nbsp;~Cu */ \
	0x72,0x44,0x61,0x74,0x65,0x7e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73, /* rDate~&nbsp;&nbs */ \
	0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e, /* p;</td>..<td><b> */ \
	0x54,0x69,0x6d,0x65,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b, /* Time :</b>&nbsp; */ \
	0x7e,0x43,0x75,0x72,0x54,0x69,0x6d,0x65,0x7e,0x20,0x28,0x3c,0x69,0x6e,0x70,0x75, /* ~CurTime~ (<inpu */ \
	0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61, /* t type="text" na */ \
	0x6d,0x65,0x3d,0x22,0x63,0x75,0x74,0x6d,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22, /* me="cutm" size=" */ \
	0x38,0x22,0x3e,0x29,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a, /* 8">)</td></tr>.. */ \
	0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x69,0x72,0x63,0x44,0x44, /* <tr><td><b>ircDD */ \
	0x42,0x20,0x44,0x4e,0x53,0x20,0x75,0x73,0x65,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c, /* B DNS use :</b>< */ \
	0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74, /* /td><td>..<input */ \
	0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22, /*  type="checkbox" */ \
	0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x73,0x6d,0x22,0x20,0x7e,0x69,0x72,0x63, /*  class="sm" ~irc */ \
	0x44,0x44,0x42,0x7e,0x20,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x2f,0x3e, /* DDB~ disabled /> */ \
	0x26,0x6e,0x62,0x73,0x70,0x3b,0x7e,0x69,0x72,0x63,0x44,0x44,0x42,0x74,0x79,0x70, /* &nbsp;~ircDDBtyp */ \
	0x65,0x7e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74, /* e~</td></tr>..<t */ \
	0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x47,0x61,0x74,0x65,0x2f,0x52,0x65, /* r><td><b>Gate/Re */ \
	0x66,0x6c,0x65,0x63,0x74,0x6f,0x72,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74  /* flector :</b></t */
#define DATACHUNK00000e \
	0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x43,0x75,0x72,0x52,0x65,0x66,0x7e,0x26,0x6e, /* d><td>~CurRef~&n */ \
	0x62,0x73,0x70,0x3b,0x28,0x7e,0x52,0x65,0x66,0x4e,0x61,0x6d,0x65,0x7e,0x29,0x3c, /* bsp;(~RefName~)< */ \
	0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c, /* /td></tr>..<tr>< */ \
	0x74,0x64,0x3e,0x3c,0x62,0x3e,0x50,0x54,0x54,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x26, /* td><b>PTT :</b>& */ \
	0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x7e,0x43,0x75,0x72,0x50, /* nbsp;&nbsp;~CurP */ \
	0x54,0x54,0x7e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c, /* TT~&nbsp;&nbsp;< */ \
	0x2f,0x74,0x64,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x43,0x4f,0x53, /* /td>..<td><b>COS */ \
	0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73, /*  :</b>&nbsp;&nbs */ \
	0x70,0x3b,0x7e,0x43,0x75,0x72,0x43,0x4f,0x53,0x7e,0x3c,0x2f,0x74,0x64,0x3e,0x3c, /* p;~CurCOS~</td>< */ \
	0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62, /* /tr>..<tr><td><b */ \
	0x3e,0x4e,0x6f,0x64,0x65,0x20,0x55,0x73,0x65,0x72,0x20,0x3a,0x3c,0x2f,0x62,0x3e, /* >Node User :</b> */ \
	0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x7e,0x43,0x75,0x72, /* &nbsp;&nbsp;~Cur */ \
	0x55,0x73,0x65,0x72,0x7e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70, /* User~&nbsp;&nbsp */ \
	0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x53, /* ;</td>..<td><b>S */ \
	0x53,0x4e,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e, /* SN :</b>&nbsp;&n */ \
	0x62,0x73,0x70,0x3b,0x7e,0x43,0x75,0x72,0x53,0x53,0x4e,0x7e,0x3c,0x2f,0x74,0x64, /* bsp;~CurSSN~</td */ \
	0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x2f,0x74,0x61,0x62,0x6c,0x65,0x3e, /* ></tr>..</table> */ \
	0x0d,0x0a,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e, /* ..&nbsp;&nbsp;&n */ \
	0x62,0x73,0x70,0x3b,0x3c,0x62,0x3e,0x47,0x61,0x74,0x65,0x2f,0x52,0x65,0x66,0x2e, /* bsp;<b>Gate/Ref. */ \
	0x20,0x46,0x69,0x6c,0x65,0x20,0x44,0x61,0x74,0x65,0x20,0x26,0x20,0x54,0x69,0x6d, /*  File Date & Tim */ \
	0x65,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62, /* e :</b>&nbsp;&nb */ \
	0x73,0x70,0x3b,0x7e,0x44,0x61,0x74,0x65,0x54,0x69,0x6d,0x65,0x7e,0x3c,0x62,0x72, /* sp;~DateTime~<br */ \
	0x3e,0x0d,0x0a,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26, /* >..&nbsp;&nbsp;& */ \
	0x6e,0x62,0x73,0x70,0x3b,0x3c,0x62,0x3e,0x57,0x65,0x62,0x20,0x53,0x69,0x74,0x65, /* nbsp;<b>Web Site */ \
	0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73, /*  :</b>&nbsp;&nbs */ \
	0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x7e,0x68,0x74,0x74,0x70,0x7e,0x0d,0x0a, /* p;&nbsp;~http~.. */ \
	0x3c,0x62,0x72,0x3e,0x0d,0x0a,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73, /* <br>..&nbsp;&nbs */ \
	0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74, /* p;&nbsp;<input t */ \
	0x79,0x70,0x65,0x3d,0x22,0x62,0x75,0x74,0x74,0x6f,0x6e,0x22,0x20,0x6e,0x61,0x6d, /* ype="button" nam */ \
	0x65,0x3d,0x22,0x66,0x72,0x65,0x73,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22, /* e="fres" value=" */ \
	0x52,0x65,0x66,0x72,0x65,0x73,0x68,0x22,0x20,0x6f,0x6e,0x43,0x6c,0x69,0x63,0x6b, /* Refresh" onClick */ \
	0x3d,0x22,0x72,0x65,0x66,0x72,0x65,0x73,0x68,0x28,0x29,0x22,0x20,0x2f,0x3e,0x0d, /* ="refresh()" />. */ \
	0x0a,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x69,0x6e, /* .&nbsp;&nbsp;<in */ \
	0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x73,0x75,0x62,0x6d,0x69,0x74, /* put type="submit */ \
	0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6c,0x69,0x6e,0x6b,0x22,0x20,0x76,0x61, /* " name="link" va */ \
	0x6c,0x75,0x65,0x3d,0x22,0x4c,0x69,0x6e,0x6b,0x22,0x20,0x2f,0x3e,0x0d,0x0a,0x26, /* lue="Link" />..& */ \
	0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x69,0x6e,0x70,0x75, /* nbsp;&nbsp;<inpu */ \
	0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x73,0x75,0x62,0x6d,0x69,0x74,0x22,0x20, /* t type="submit"  */ \
	0x6e,0x61,0x6d,0x65,0x3d,0x22,0x75,0x6c,0x6e,0x6b,0x22,0x20,0x76,0x61,0x6c,0x75, /* name="ulnk" valu */ \
	0x65,0x3d,0x22,0x55,0x6e,0x4c,0x69,0x6e,0x6b,0x22,0x20,0x2f,0x3e,0x0d,0x0a,0x26, /* e="UnLink" />..& */ \
	0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x69,0x6e,0x70,0x75, /* nbsp;&nbsp;<inpu */ \
	0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x73,0x75,0x62,0x6d,0x69,0x74,0x22,0x20, /* t type="submit"  */ \
	0x6e,0x61,0x6d,0x65,0x3d,0x22,0x72,0x65,0x6c,0x64,0x22,0x20,0x76,0x61,0x6c,0x75, /* name="reld" valu */ \
	0x65,0x3d,0x22,0x52,0x65,0x4c,0x6f,0x61,0x64,0x20,0x47,0x61,0x74,0x65,0x2f,0x52, /* e="ReLoad Gate/R */ \
	0x65,0x66,0x20,0x4c,0x69,0x73,0x74,0x22,0x20,0x2f,0x3e,0x0d,0x0a,0x26,0x6e,0x62, /* ef List" />..&nb */ \
	0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20, /* sp;&nbsp;<input  */ \
	0x74,0x79,0x70,0x65,0x3d,0x22,0x62,0x75,0x74,0x74,0x6f,0x6e,0x22,0x20,0x6e,0x61, /* type="button" na */ \
	0x6d,0x65,0x3d,0x22,0x73,0x65,0x6c,0x72,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d, /* me="selr" value= */ \
	0x22,0x53,0x65,0x6c,0x65,0x63,0x74,0x20,0x47,0x61,0x74,0x65,0x2f,0x52,0x65,0x66, /* "Select Gate/Ref */ \
	0x22,0x20,0x6f,0x6e,0x63,0x6c,0x69,0x63,0x6b,0x3d,0x22,0x72,0x65,0x66,0x73,0x65, /* " onclick="refse */ \
	0x6c,0x65,0x63,0x74,0x28,0x29,0x22,0x20,0x2f,0x3e,0x0d,0x0a,0x3c,0x74,0x61,0x62, /* lect()" />..<tab */ \
	0x6c,0x65,0x20,0x73,0x74,0x79,0x6c,0x65,0x3d,0x22,0x70,0x61,0x64,0x64,0x69,0x6e, /* le style="paddin */ \
	0x67,0x2d,0x6c,0x65,0x66,0x74,0x3a,0x20,0x31,0x30,0x70,0x78,0x3b,0x22,0x3e,0x0d, /* g-left: 10px;">. */ \
	0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x41,0x50,0x52,0x53, /* .<tr><td><b>APRS */ \
	0x20,0x53,0x65,0x72,0x76,0x65,0x72,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74, /*  Server :</b></t */ \
	0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64, /* d><td>&nbsp;</td */ \
	0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x43,0x75,0x72,0x41,0x50,0x52,0x53,0x7e,0x3c,0x2f, /* ><td>~CurAPRS~</ */ \
	0x74,0x64,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26, /* td>..<td>&nbsp;& */ \
	0x6e,0x62,0x73,0x70,0x3b,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65, /* nbsp;<input type */ \
	0x3d,0x22,0x73,0x75,0x62,0x6d,0x69,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22, /* ="submit" name=" */ \
	0x6c,0x61,0x70,0x72,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x4c,0x69,0x6e, /* lapr" value="Lin */ \
	0x6b,0x22,0x20,0x2f,0x3e,0x0d,0x0a,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62, /* k" />..&nbsp;&nb */ \
	0x73,0x70,0x3b,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22, /* sp;<input type=" */ \
	0x73,0x75,0x62,0x6d,0x69,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x75,0x61  /* submit" name="ua */
#define DATACHUNK00000f \
	0x70,0x72,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x55,0x6e,0x4c,0x69,0x6e, /* pr" value="UnLin */ \
	0x6b,0x22,0x20,0x2f,0x3e,0x0d,0x0a,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62, /* k" />..&nbsp;&nb */ \
	0x73,0x70,0x3b,0x3c,0x62,0x3e,0x57,0x65,0x62,0x20,0x53,0x69,0x74,0x65,0x20,0x3a, /* sp;<b>Web Site : */ \
	0x20,0x3c,0x61,0x20,0x68,0x72,0x65,0x66,0x3d,0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f, /*  <a href=http:// */ \
	0x61,0x70,0x72,0x73,0x2e,0x66,0x69,0x20,0x74,0x61,0x72,0x67,0x65,0x74,0x3d,0x5f, /* aprs.fi target=_ */ \
	0x62,0x6c,0x61,0x6e,0x6b,0x3e,0x61,0x70,0x72,0x73,0x2e,0x66,0x69,0x3c,0x2f,0x61, /* blank>aprs.fi</a */ \
	0x3e,0x3c,0x2f,0x62,0x3e,0x0d,0x0a,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72, /* ></b>..</td></tr */ \
	0x3e,0x0d,0x0a,0x3c,0x2f,0x74,0x61,0x62,0x6c,0x65,0x3e,0x0d,0x0a,0x26,0x6e,0x62, /* >..</table>..&nb */ \
	0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x62,0x3e,0x53,0x65,0x6e,0x64, /* sp;&nbsp;<b>Send */ \
	0x65,0x72,0x3a,0x3c,0x2f,0x62,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62, /* er:</b>&nbsp;&nb */ \
	0x73,0x70,0x3b,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22, /* sp;<input type=" */ \
	0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6c,0x63,0x61,0x6c, /* text" name="lcal */ \
	0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x31,0x30,0x22,0x20,0x76,0x61,0x6c,0x75, /* " size="10" valu */ \
	0x65,0x3d,0x22,0x7e,0x73,0x65,0x6e,0x64,0x65,0x72,0x63,0x61,0x6c,0x6c,0x7e,0x22, /* e="~sendercall~" */ \
	0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x20,0x72,0x65,0x61, /*  class="ad1" rea */ \
	0x64,0x6f,0x6e,0x6c,0x79,0x20,0x6f,0x6e,0x43,0x6c,0x69,0x63,0x6b,0x3d,0x22,0x6a, /* donly onClick="j */ \
	0x75,0x6d,0x70,0x28,0x29,0x22,0x20,0x2f,0x3e,0x0d,0x0a,0x26,0x6e,0x62,0x73,0x70, /* ump()" />..&nbsp */ \
	0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x62,0x3e,0x52,0x63,0x76,0x2e,0x20,0x4d, /* ;&nbsp;<b>Rcv. M */ \
	0x73,0x67,0x2e,0x3a,0x3c,0x2f,0x62,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e, /* sg.:</b>&nbsp;&n */ \
	0x62,0x73,0x70,0x3b,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d, /* bsp;<input type= */ \
	0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6c,0x6d,0x73, /* "text" name="lms */ \
	0x67,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x4c,0x61,0x73,0x74,0x4d, /* g" value="~LastM */ \
	0x73,0x67,0x7e,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x34,0x30,0x22,0x20,0x63, /* sg~" size="40" c */ \
	0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x20,0x72,0x65,0x61,0x64,0x6f, /* lass="ad1" reado */ \
	0x6e,0x6c,0x79,0x2f,0x20,0x6f,0x6e,0x43,0x6c,0x69,0x63,0x6b,0x3d,0x22,0x6a,0x75, /* nly/ onClick="ju */ \
	0x6d,0x70,0x28,0x29,0x22,0x20,0x2f,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x62,0x72,0x3e, /* mp()" />....<br> */ \
	0x0d,0x0a,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x66, /* ..&nbsp;&nbsp;<f */ \
	0x6f,0x6e,0x74,0x20,0x63,0x6f,0x6c,0x6f,0x72,0x3d,0x72,0x65,0x64,0x3e,0x3c,0x62, /* ont color=red><b */ \
	0x3e,0x0d,0x0a,0x7e,0x4e,0x6f,0x74,0x69,0x63,0x65,0x7e,0x3c,0x2f,0x62,0x3e,0x3c, /* >..~Notice~</b>< */ \
	0x2f,0x66,0x6f,0x6e,0x74,0x3e,0x0d,0x0a,0x3c,0x62,0x72,0x3e,0x0d,0x0a,0x3c,0x74, /* /font>..<br>..<t */ \
	0x61,0x62,0x6c,0x65,0x20,0x73,0x74,0x79,0x6c,0x65,0x3d,0x22,0x70,0x61,0x64,0x64, /* able style="padd */ \
	0x69,0x6e,0x67,0x2d,0x6c,0x65,0x66,0x74,0x3a,0x20,0x31,0x30,0x70,0x78,0x3b,0x22, /* ing-left: 10px;" */ \
	0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x43,0x75, /* >..<tr><td><b>Cu */ \
	0x72,0x72,0x65,0x6e,0x74,0x20,0x53,0x75,0x62,0x20,0x43,0x6c,0x69,0x65,0x6e,0x74, /* rrent Sub Client */ \
	0x20,0x55,0x73,0x65,0x72,0x20,0x4e,0x61,0x6d,0x65,0x20,0x3a,0x3c,0x2f,0x62,0x3e, /*  User Name :</b> */ \
	0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x7e,0x43,0x6f,0x6e, /* </td></tr>..~Con */ \
	0x6e,0x65,0x63,0x74,0x55,0x73,0x65,0x72,0x7e,0x0d,0x0a,0x3c,0x2f,0x74,0x61,0x62, /* nectUser~..</tab */ \
	0x6c,0x65,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x6f,0x72,0x6d,0x3e,0x0d,0x0a,0x3c,0x2f, /* le>..</form>..</ */ \
	0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x2f,0x62,0x6f,0x64,0x79,0x3e,0x0d, /* div>....</body>. */ \
	0x0a,0x3c,0x6d,0x65,0x74,0x61,0x20,0x68,0x74,0x74,0x70,0x2d,0x65,0x71,0x75,0x69, /* .<meta http-equi */ \
	0x76,0x3d,0x22,0x72,0x65,0x66,0x72,0x65,0x73,0x68,0x22,0x20,0x63,0x6f,0x6e,0x74, /* v="refresh" cont */ \
	0x65,0x6e,0x74,0x3d,0x22,0x31,0x30,0x22,0x3e,0x0d,0x0a,0x3c,0x62,0x6f,0x64,0x79, /* ent="10">..<body */ \
	0x3e,0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x74,0x79,0x70,0x65,0x3d, /* >..<script type= */ \
	0x22,0x74,0x65,0x78,0x74,0x2f,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74, /* "text/javascript */ \
	0x22,0x3e,0x0d,0x0a,0x3c,0x21,0x2d,0x2d,0x0d,0x0a,0x0d,0x0a,0x66,0x75,0x6e,0x63, /* ">..<!--....func */ \
	0x74,0x69,0x6f,0x6e,0x20,0x74,0x69,0x6d,0x65,0x5f,0x73,0x65,0x74,0x28,0x29,0x7b, /* tion time_set(){ */ \
	0x0d,0x0a,0x20,0x20,0x6d,0x79,0x44,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x3d,0x20, /* ..  myD       =  */ \
	0x6e,0x65,0x77,0x20,0x44,0x61,0x74,0x65,0x28,0x29,0x3b,0x0d,0x0a,0x20,0x20,0x6d, /* new Date();..  m */ \
	0x79,0x48,0x6f,0x75,0x72,0x73,0x20,0x20,0x20,0x3d,0x20,0x6d,0x79,0x44,0x2e,0x67, /* yHours   = myD.g */ \
	0x65,0x74,0x48,0x6f,0x75,0x72,0x73,0x28,0x29,0x3b,0x0d,0x0a,0x20,0x20,0x69,0x66, /* etHours();..  if */ \
	0x20,0x28,0x6d,0x79,0x48,0x6f,0x75,0x72,0x73,0x20,0x3c,0x20,0x31,0x30,0x29,0x20, /*  (myHours < 10)  */ \
	0x6d,0x79,0x48,0x6f,0x75,0x72,0x73,0x20,0x3d,0x20,0x22,0x30,0x22,0x20,0x2b,0x20, /* myHours = "0" +  */ \
	0x6d,0x79,0x48,0x6f,0x75,0x72,0x73,0x3b,0x0d,0x0a,0x20,0x20,0x6d,0x79,0x4d,0x69, /* myHours;..  myMi */ \
	0x6e,0x75,0x74,0x65,0x73,0x20,0x3d,0x20,0x6d,0x79,0x44,0x2e,0x67,0x65,0x74,0x4d, /* nutes = myD.getM */ \
	0x69,0x6e,0x75,0x74,0x65,0x73,0x28,0x29,0x3b,0x0d,0x0a,0x20,0x20,0x69,0x66,0x20, /* inutes();..  if  */ \
	0x28,0x6d,0x79,0x4d,0x69,0x6e,0x75,0x74,0x65,0x73,0x20,0x3c,0x20,0x31,0x30,0x29, /* (myMinutes < 10) */ \
	0x20,0x6d,0x79,0x4d,0x69,0x6e,0x75,0x74,0x65,0x73,0x20,0x3d,0x20,0x22,0x30,0x22, /*  myMinutes = "0" */ \
	0x20,0x2b,0x20,0x6d,0x79,0x4d,0x69,0x6e,0x75,0x74,0x65,0x73,0x3b,0x0d,0x0a,0x20, /*  + myMinutes;..  */ \
	0x20,0x6d,0x79,0x53,0x65,0x63,0x6f,0x6e,0x64,0x73,0x20,0x3d,0x20,0x6d,0x79,0x44, /*  mySeconds = myD */ \
	0x2e,0x67,0x65,0x74,0x53,0x65,0x63,0x6f,0x6e,0x64,0x73,0x28,0x29,0x3b,0x0d,0x0a, /* .getSeconds();.. */ \
	0x20,0x20,0x69,0x66,0x20,0x28,0x6d,0x79,0x53,0x65,0x63,0x6f,0x6e,0x64,0x73,0x20, /*   if (mySeconds  */ \
	0x3c,0x20,0x31,0x30,0x29,0x20,0x6d,0x79,0x53,0x65,0x63,0x6f,0x6e,0x64,0x73,0x20, /* < 10) mySeconds  */ \
	0x3d,0x20,0x22,0x30,0x22,0x20,0x2b,0x20,0x6d,0x79,0x53,0x65,0x63,0x6f,0x6e,0x64, /* = "0" + mySecond */ \
	0x73,0x3b,0x0d,0x0a,0x0d,0x0a,0x20,0x20,0x6d,0x79,0x4d,0x65,0x73,0x73,0x20,0x3d  /* s;....  myMess = */
#define DATACHUNK000010 \
	0x20,0x6d,0x79,0x48,0x6f,0x75,0x72,0x73,0x20,0x2b,0x20,0x22,0x3a,0x22,0x20,0x2b, /*  myHours + ":" + */ \
	0x20,0x6d,0x79,0x4d,0x69,0x6e,0x75,0x74,0x65,0x73,0x20,0x2b,0x20,0x22,0x3a,0x22, /*  myMinutes + ":" */ \
	0x20,0x2b,0x20,0x6d,0x79,0x53,0x65,0x63,0x6f,0x6e,0x64,0x73,0x3b,0x0d,0x0a,0x20, /*  + mySeconds;..  */ \
	0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x73,0x74,0x61,0x74,0x75,0x73, /*  document.status */ \
	0x2e,0x63,0x75,0x74,0x6d,0x2e,0x76,0x61,0x6c,0x75,0x65,0x20,0x3d,0x20,0x6d,0x79, /* .cutm.value = my */ \
	0x4d,0x65,0x73,0x73,0x3b,0x0d,0x0a,0x20,0x20,0x73,0x65,0x74,0x54,0x69,0x6d,0x65, /* Mess;..  setTime */ \
	0x6f,0x75,0x74,0x20,0x28,0x22,0x74,0x69,0x6d,0x65,0x5f,0x73,0x65,0x74,0x28,0x29, /* out ("time_set() */ \
	0x22,0x2c,0x20,0x31,0x30,0x30,0x30,0x29,0x3b,0x0d,0x0a,0x7d,0x0d,0x0a,0x0d,0x0a, /* ", 1000);..}.... */ \
	0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x20,0x72,0x65,0x66,0x72,0x65,0x73,0x68, /* function refresh */ \
	0x28,0x29,0x0d,0x0a,0x7b,0x0d,0x0a,0x20,0x20,0x20,0x6c,0x6f,0x63,0x61,0x74,0x69, /* ()..{..   locati */ \
	0x6f,0x6e,0x2e,0x72,0x65,0x6c,0x6f,0x61,0x64,0x28,0x74,0x72,0x75,0x65,0x29,0x3b, /* on.reload(true); */ \
	0x0d,0x0a,0x7d,0x0d,0x0a,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x20,0x6a,0x75, /* ..}..function ju */ \
	0x6d,0x70,0x28,0x29,0x0d,0x0a,0x7b,0x0d,0x0a,0x20,0x20,0x20,0x6c,0x6f,0x63,0x61, /* mp()..{..   loca */ \
	0x74,0x69,0x6f,0x6e,0x2e,0x68,0x72,0x65,0x66,0x3d,0x22,0x61,0x70,0x72,0x73,0x6d, /* tion.href="aprsm */ \
	0x73,0x67,0x2e,0x68,0x74,0x6d,0x22,0x3b,0x0d,0x0a,0x7d,0x0d,0x0a,0x66,0x75,0x6e, /* sg.htm";..}..fun */ \
	0x63,0x74,0x69,0x6f,0x6e,0x20,0x72,0x65,0x66,0x73,0x65,0x6c,0x65,0x63,0x74,0x28, /* ction refselect( */ \
	0x29,0x0d,0x0a,0x7b,0x0d,0x0a,0x20,0x20,0x20,0x6c,0x6f,0x63,0x61,0x74,0x69,0x6f, /* )..{..   locatio */ \
	0x6e,0x2e,0x68,0x72,0x65,0x66,0x3d,0x22,0x72,0x65,0x66,0x73,0x65,0x6c,0x65,0x63, /* n.href="refselec */ \
	0x74,0x2e,0x68,0x74,0x6d,0x22,0x3b,0x0d,0x0a,0x7d,0x0d,0x0a,0x2f,0x2f,0x2d,0x2d, /* t.htm";..}..//-- */ \
	0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74,0x3e,0x0d,0x0a,0x7e,0x69, /* >..</script>..~i */ \
	0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a, /* nc:footer.inc~.. */ \
	0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0xe9,0x00,0x00,0x00,0x63,0x00,0x00,0x00, /* ....3.......c... */ \
	0x1c,0x01,0x00,0x00,0x64,0x00,0x00,0x00,0xa8,0x01,0x00,0x00,0xd0,0x00,0x00,0x00, /* ....d........... */ \
	0xc2,0x01,0x00,0x00,0xd1,0x00,0x00,0x00,0x02,0x02,0x00,0x00,0xa3,0x00,0x00,0x00, /* ................ */ \
	0x11,0x02,0x00,0x00,0x8a,0x00,0x00,0x00,0x47,0x02,0x00,0x00,0x66,0x00,0x00,0x00, /* ........G...f... */ \
	0x7e,0x02,0x00,0x00,0x67,0x00,0x00,0x00,0xb8,0x02,0x00,0x00,0x69,0x00,0x00,0x00, /* ~...g.......i... */ \
	0xf0,0x02,0x00,0x00,0x68,0x00,0x00,0x00,0x4f,0x03,0x00,0x00,0xa6,0x00,0x00,0x00, /* ....h...O....... */ \
	0x94,0x03,0x00,0x00,0xa8,0x00,0x00,0x00,0x81,0x05,0x00,0x00,0xb4,0x00,0x00,0x00, /* ................ */ \
	0xcf,0x06,0x00,0x00,0xcd,0x00,0x00,0x00,0x56,0x07,0x00,0x00,0xce,0x00,0x00,0x00, /* ........V....... */ \
	0xbf,0x07,0x00,0x00,0xa5,0x00,0x00,0x00,0x38,0x08,0x00,0x00,0x9d,0x00,0x00,0x00, /* ........8....... */ \
	0x3a,0x0b,0x00,0x00,0x02,0x00,0x00,0x00,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61, /* :.......~inc:hea */ \
	0x64,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69, /* der.inc~..<div i */ \
	0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a, /* d="content">.... */ \
	0x3c,0x68,0x31,0x3e,0x4e,0x6f,0x64,0x65,0x20,0x41,0x64,0x61,0x70,0x74,0x65,0x72, /* <h1>Node Adapter */ \
	0x20,0x43,0x6f,0x6e,0x66,0x69,0x67,0x75,0x72,0x61,0x74,0x69,0x6f,0x6e,0x3c,0x2f, /*  Configuration</ */ \
	0x68,0x31,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x66,0x6f,0x72,0x6d,0x20,0x6d,0x65,0x74, /* h1>....<form met */ \
	0x68,0x6f,0x64,0x3d,0x22,0x70,0x6f,0x73,0x74,0x22,0x20,0x61,0x63,0x74,0x69,0x6f, /* hod="post" actio */ \
	0x6e,0x3d,0x22,0x2f,0x6e,0x6f,0x64,0x65,0x61,0x64,0x61,0x70,0x74,0x65,0x72,0x2f, /* n="/nodeadapter/ */ \
	0x63,0x6f,0x6e,0x66,0x69,0x67,0x2e,0x68,0x74,0x6d,0x22,0x20,0x6e,0x61,0x6d,0x65, /* config.htm" name */ \
	0x3d,0x22,0x6e,0x6f,0x64,0x65,0x63,0x66,0x67,0x22,0x3e,0x0d,0x0a,0x3c,0x66,0x69, /* ="nodecfg">..<fi */ \
	0x65,0x6c,0x64,0x73,0x65,0x74,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c, /* eldset>..<div><l */ \
	0x61,0x62,0x65,0x6c,0x3e,0x54,0x58,0x20,0x44,0x65,0x6c,0x61,0x79,0x20,0x54,0x69, /* abel>TX Delay Ti */ \
	0x6d,0x65,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e, /* me:</label>..<in */ \
	0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20, /* put type="text"  */ \
	0x6e,0x61,0x6d,0x65,0x3d,0x22,0x64,0x65,0x6c,0x79,0x22,0x20,0x76,0x61,0x6c,0x75, /* name="dely" valu */ \
	0x65,0x3d,0x22,0x7e,0x64,0x65,0x6c,0x61,0x79,0x5f,0x74,0x69,0x6d,0x65,0x7e,0x22, /* e="~delay_time~" */ \
	0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x34,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d, /*  size="4" class= */ \
	0x22,0x61,0x64,0x31,0x22,0x20,0x2f,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x6d,0x53, /* "ad1" />&nbsp;mS */ \
	0x65,0x63,0x2e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e, /* ec.</div>..<div> */ \
	0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x54,0x58,0x20,0x54,0x69,0x6d,0x65,0x20,0x6f, /* <label>TX Time o */ \
	0x75,0x74,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e, /* ut:</label>..<in */ \
	0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20, /* put type="text"  */ \
	0x6e,0x61,0x6d,0x65,0x3d,0x22,0x74,0x6f,0x75,0x74,0x22,0x20,0x76,0x61,0x6c,0x75, /* name="tout" valu */ \
	0x65,0x3d,0x22,0x7e,0x74,0x69,0x6d,0x65,0x5f,0x6f,0x75,0x74,0x7e,0x22,0x20,0x73, /* e="~time_out~" s */ \
	0x69,0x7a,0x65,0x3d,0x22,0x34,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61, /* ize="4" class="a */ \
	0x64,0x31,0x22,0x2f,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x53,0x65,0x63,0x2e,0x3c, /* d1"/>&nbsp;Sec.< */ \
	0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62, /* /div>..<div><lab */ \
	0x65,0x6c,0x3e,0x52,0x58,0x20,0x4b,0x65,0x65,0x70,0x20,0x41,0x6c,0x69,0x76,0x65, /* el>RX Keep Alive */ \
	0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75, /* :</label>..<inpu */ \
	0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61, /* t type="text" na */ \
	0x6d,0x65,0x3d,0x22,0x6b,0x65,0x65,0x70,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d, /* me="keep" value= */ \
	0x22,0x7e,0x6b,0x65,0x65,0x70,0x5f,0x61,0x6c,0x69,0x76,0x65,0x7e,0x22,0x20,0x73, /* "~keep_alive~" s */ \
	0x69,0x7a,0x65,0x3d,0x22,0x34,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61, /* ize="4" class="a */ \
	0x64,0x31,0x22,0x2f,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x6d,0x53,0x65,0x63,0x2e  /* d1"/>&nbsp;mSec. */
#define DATACHUNK000011 \
	0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61, /* </div>..<div><la */ \
	0x62,0x65,0x6c,0x3e,0x4a,0x69,0x74,0x74,0x65,0x72,0x20,0x42,0x75,0x66,0x66,0x65, /* bel>Jitter Buffe */ \
	0x72,0x20,0x73,0x69,0x7a,0x65,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d, /* r size:</label>. */ \
	0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65, /* .<input type="te */ \
	0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6a,0x69,0x74,0x74,0x22,0x20, /* xt" name="jitt"  */ \
	0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x6a,0x69,0x74,0x74,0x74,0x65,0x72,0x5f, /* value="~jittter_ */ \
	0x73,0x69,0x7a,0x65,0x7e,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x33,0x22,0x20, /* size~" size="3"  */ \
	0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x2f,0x3e,0x26,0x6e,0x62, /* class="ad1"/>&nb */ \
	0x73,0x70,0x3b,0x30,0x3a,0x20,0x6e,0x6f,0x74,0x20,0x65,0x66,0x66,0x65,0x63,0x74, /* sp;0: not effect */ \
	0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61, /* </div>..<div><la */ \
	0x62,0x65,0x6c,0x3e,0x52,0x58,0x20,0x41,0x75,0x74,0x6f,0x20,0x50,0x6f,0x6c,0x61, /* bel>RX Auto Pola */ \
	0x72,0x69,0x74,0x79,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c, /* rity:</label>..< */ \
	0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63, /* input type="chec */ \
	0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x72,0x78,0x70,0x6c, /* kbox" name="rxpl */ \
	0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x52,0x58,0x5f,0x41, /* " value="" ~RX_A */ \
	0x75,0x74,0x6f,0x50,0x6f,0x6c,0x61,0x72,0x69,0x74,0x79,0x7e,0x20,0x63,0x6c,0x61, /* utoPolarity~ cla */ \
	0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e, /* ss="ad1"/></div> */ \
	0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x52,0x58, /* ..<div><label>RX */ \
	0x20,0x50,0x6f,0x6c,0x61,0x72,0x69,0x74,0x79,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65, /*  Polarity:</labe */ \
	0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d, /* l>..<input type= */ \
	0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d, /* "checkbox" name= */ \
	0x22,0x72,0x78,0x70,0x6f,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20, /* "rxpo" value=""  */ \
	0x7e,0x52,0x58,0x5f,0x50,0x6f,0x6c,0x61,0x72,0x69,0x74,0x79,0x7e,0x20,0x20,0x63, /* ~RX_Polarity~  c */ \
	0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x2f,0x3e,0x3c,0x2f,0x64,0x69, /* lass="ad1"/></di */ \
	0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e, /* v>..<div><label> */ \
	0x54,0x58,0x20,0x50,0x6f,0x6c,0x61,0x72,0x69,0x74,0x79,0x3a,0x3c,0x2f,0x6c,0x61, /* TX Polarity:</la */ \
	0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74, /* bel>..<td><input */ \
	0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22, /*  type="checkbox" */ \
	0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x74,0x78,0x70,0x6f,0x22,0x20,0x76,0x61,0x6c, /*  name="txpo" val */ \
	0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x54,0x58,0x5f,0x50,0x6f,0x6c,0x61,0x72,0x69, /* ue="" ~TX_Polari */ \
	0x74,0x79,0x7e,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x20, /* ty~ class="ad1"  */ \
	0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c, /* /></div>..<div>< */ \
	0x6c,0x61,0x62,0x65,0x6c,0x3e,0x43,0x4f,0x53,0x20,0x43,0x68,0x65,0x63,0x6b,0x3a, /* label>COS Check: */ \
	0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69, /* </label>..<td><i */ \
	0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b, /* nput type="check */ \
	0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x63,0x6f,0x73,0x22,0x20, /* box" name="cos"  */ \
	0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x43,0x4f,0x53,0x5f,0x43,0x68, /* value="" ~COS_Ch */ \
	0x65,0x63,0x6b,0x7e,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22, /* eck~ class="ad1" */ \
	0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e, /*  /></div>..<div> */ \
	0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x53,0x2f,0x4e,0x20,0x53,0x71,0x75,0x65,0x6c, /* <label>S/N Squel */ \
	0x63,0x68,0x20,0x56,0x61,0x6c,0x75,0x65,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c, /* ch Value:</label */ \
	0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79, /* >..<td><input ty */ \
	0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22, /* pe="text" name=" */ \
	0x73,0x6e,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x53,0x4e,0x5f,0x53, /* sn" value="~SN_S */ \
	0x71,0x75,0x65,0x6c,0x63,0x68,0x7e,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x35, /* quelch~" size="5 */ \
	0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x2f,0x3e,0x26, /* " class="ad1"/>& */ \
	0x6e,0x62,0x73,0x70,0x3b,0x30,0x3a,0x20,0x6e,0x6f,0x74,0x20,0x65,0x66,0x66,0x65, /* nbsp;0: not effe */ \
	0x63,0x74,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c, /* ct</div>..<div>< */ \
	0x6c,0x61,0x62,0x65,0x6c,0x3e,0x43,0x52,0x43,0x20,0x43,0x68,0x65,0x63,0x6b,0x3a, /* label>CRC Check: */ \
	0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69, /* </label>..<td><i */ \
	0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b, /* nput type="check */ \
	0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x63,0x72,0x63,0x22,0x20, /* box" name="crc"  */ \
	0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x43,0x52,0x43,0x5f,0x43,0x68, /* value="" ~CRC_Ch */ \
	0x65,0x63,0x6b,0x7e,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22, /* eck~ class="ad1" */ \
	0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c, /* /></div>..<div>< */ \
	0x6c,0x61,0x62,0x65,0x6c,0x3e,0x4c,0x61,0x73,0x74,0x20,0x46,0x72,0x61,0x6d,0x65, /* label>Last Frame */ \
	0x20,0x53,0x65,0x6e,0x64,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a, /*  Send:</label>.. */ \
	0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d, /* <td><input type= */ \
	0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d, /* "checkbox" name= */ \
	0x22,0x6c,0x61,0x73,0x74,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20, /* "last" value=""  */ \
	0x7e,0x4c,0x61,0x73,0x74,0x46,0x72,0x61,0x6d,0x65,0x7e,0x20,0x63,0x6c,0x61,0x73, /* ~LastFrame~ clas */ \
	0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e, /* s="ad1" /></div> */ \
	0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x48,0x65, /* ..<div><label>He */ \
	0x61,0x64,0x65,0x72,0x20,0x47,0x65,0x6e,0x65,0x72,0x61,0x74,0x69,0x6f,0x6e,0x3a  /* ader Generation: */
#define DATACHUNK000012 \
	0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69, /* </label>..<td><i */ \
	0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b, /* nput type="check */ \
	0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x68,0x64,0x72,0x67,0x22, /* box" name="hdrg" */ \
	0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x48,0x65,0x61,0x64,0x65, /*  value="" ~Heade */ \
	0x72,0x47,0x65,0x6e,0x7e,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31, /* rGen~ class="ad1 */ \
	0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76, /* " /></div>..<div */ \
	0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x48,0x65,0x61,0x64,0x65,0x72,0x20,0x47, /* ><label>Header G */ \
	0x65,0x6e,0x2e,0x20,0x54,0x79,0x70,0x65,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c, /* en. Type:</label */ \
	0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79, /* >..<td><input ty */ \
	0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61, /* pe="checkbox" na */ \
	0x6d,0x65,0x3d,0x22,0x68,0x64,0x72,0x74,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d, /* me="hdrt" value= */ \
	0x22,0x22,0x20,0x7e,0x48,0x65,0x61,0x64,0x65,0x72,0x47,0x65,0x6e,0x54,0x79,0x70, /* "" ~HeaderGenTyp */ \
	0x65,0x7e,0x20,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x2f, /* e~  class="ad1"/ */ \
	0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x43,0x68,0x65,0x63,0x6b,0x65,0x64,0x3a,0x20, /* >&nbsp;Checked:  */ \
	0x53,0x70,0x61,0x63,0x65,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69, /* Space</div>..<di */ \
	0x76,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e, /* v>&nbsp;&nbsp;&n */ \
	0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b, /* bsp;&nbsp;&nbsp; */ \
	0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73, /* &nbsp;&nbsp;&nbs */ \
	0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x0d,0x26, /* p;&nbsp;&nbsp;.& */ \
	0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70, /* nbsp;&nbsp;&nbsp */ \
	0x3b,0x0a,0x55,0x6e,0x63,0x68,0x65,0x63,0x6b,0x65,0x64,0x3a,0x20,0x4c,0x61,0x73, /* ;.Unchecked: Las */ \
	0x74,0x20,0x52,0x46,0x20,0x48,0x65,0x61,0x64,0x65,0x72,0x3c,0x2f,0x64,0x69,0x76, /* t RF Header</div */ \
	0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x48, /* >..<div><label>H */ \
	0x61,0x6c,0x66,0x2f,0x46,0x75,0x6c,0x6c,0x20,0x44,0x75,0x70,0x6c,0x65,0x78,0x3a, /* alf/Full Duplex: */ \
	0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69, /* </label>..<td><i */ \
	0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b, /* nput type="check */ \
	0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x68,0x5f,0x66,0x22,0x20, /* box" name="h_f"  */ \
	0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x48,0x61,0x6c,0x66,0x46,0x75, /* value="" ~HalfFu */ \
	0x6c,0x6c,0x7e,0x20,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22, /* ll~  class="ad1" */ \
	0x2f,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x43,0x68,0x65,0x63,0x6b,0x65,0x64,0x3a, /* />&nbsp;Checked: */ \
	0x26,0x6e,0x62,0x73,0x70,0x3b,0x48,0x61,0x6c,0x66,0x3c,0x2f,0x64,0x69,0x76,0x3e, /* &nbsp;Half</div> */ \
	0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62, /* ..<div>&nbsp;&nb */ \
	0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26, /* sp;&nbsp;&nbsp;& */ \
	0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70, /* nbsp;&nbsp;&nbsp */ \
	0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62, /* ;&nbsp;&nbsp;&nb */ \
	0x73,0x70,0x3b,0x0d,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b, /* sp;.&nbsp;&nbsp; */ \
	0x26,0x6e,0x62,0x73,0x70,0x3b,0x0a,0x55,0x6e,0x63,0x68,0x65,0x63,0x6b,0x65,0x64, /* &nbsp;.Unchecked */ \
	0x3a,0x20,0x46,0x75,0x6c,0x6c,0x20,0x44,0x75,0x70,0x6c,0x65,0x78,0x3c,0x2f,0x64, /* : Full Duplex</d */ \
	0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x69,0x6e,0x70, /* iv>....<div><inp */ \
	0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x73,0x75,0x62,0x6d,0x69,0x74,0x22, /* ut type="submit" */ \
	0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x70,0x31,0x22,0x20,0x76,0x61,0x6c, /*  class="ap1" val */ \
	0x75,0x65,0x3d,0x22,0x53,0x61,0x76,0x65,0x20,0x42,0x61,0x73,0x69,0x63,0x20,0x49, /* ue="Save Basic I */ \
	0x6e,0x66,0x6f,0x2e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a, /* nfo." /></div>.. */ \
	0x3c,0x2f,0x66,0x69,0x65,0x6c,0x64,0x73,0x65,0x74,0x3e,0x0d,0x0a,0x3c,0x2f,0x66, /* </fieldset>..</f */ \
	0x6f,0x72,0x6d,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x7e,0x69, /* orm>..</div>..~i */ \
	0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x00,0x00, /* nc:footer.inc~.. */ \
	0x00,0x00,0x33,0x00,0x00,0x00,0xeb,0x00,0x00,0x00,0x51,0x00,0x00,0x00,0x6b,0x01, /* ..3.......Q...k. */ \
	0x00,0x00,0x52,0x00,0x00,0x00,0xe9,0x01,0x00,0x00,0x53,0x00,0x00,0x00,0x6f,0x02, /* ..R.......S...o. */ \
	0x00,0x00,0x54,0x00,0x00,0x00,0x03,0x03,0x00,0x00,0x55,0x00,0x00,0x00,0x78,0x03, /* ..T.......U...x. */ \
	0x00,0x00,0x5e,0x00,0x00,0x00,0xee,0x03,0x00,0x00,0x56,0x00,0x00,0x00,0x61,0x04, /* ..^.......V...a. */ \
	0x00,0x00,0x57,0x00,0x00,0x00,0xd3,0x04,0x00,0x00,0x58,0x00,0x00,0x00,0x61,0x05, /* ..W.......X...a. */ \
	0x00,0x00,0x59,0x00,0x00,0x00,0xd8,0x05,0x00,0x00,0x5a,0x00,0x00,0x00,0x52,0x06, /* ..Y.......Z...R. */ \
	0x00,0x00,0x5b,0x00,0x00,0x00,0xcb,0x06,0x00,0x00,0x5c,0x00,0x00,0x00,0xd1,0x07, /* ..[.......\..... */ \
	0x00,0x00,0x5d,0x00,0x00,0x00,0xe6,0x08,0x00,0x00,0x02,0x00,0x00,0x00,0x7e,0x69, /* ..]...........~i */ \
	0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a, /* nc:header.inc~.. */ \
	0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74, /* <div id="content */ \
	0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x42,0x65,0x61,0x63,0x6f,0x6e, /* ">....<h1>Beacon */ \
	0x20,0x43,0x6f,0x6e,0x66,0x69,0x67,0x75,0x72,0x61,0x74,0x69,0x6f,0x6e,0x3c,0x2f, /*  Configuration</ */ \
	0x68,0x31,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x66,0x6f,0x72,0x6d,0x20,0x6d,0x65,0x74, /* h1>....<form met */ \
	0x68,0x6f,0x64,0x3d,0x22,0x70,0x6f,0x73,0x74,0x22,0x20,0x61,0x63,0x74,0x69,0x6f, /* hod="post" actio */ \
	0x6e,0x3d,0x22,0x2f,0x6e,0x6f,0x64,0x65,0x61,0x64,0x61,0x70,0x74,0x65,0x72,0x2f, /* n="/nodeadapter/ */ \
	0x63,0x6f,0x6e,0x66,0x69,0x67,0x32,0x2e,0x68,0x74,0x6d,0x22,0x20,0x6e,0x61,0x6d, /* config2.htm" nam */ \
	0x65,0x3d,0x22,0x62,0x65,0x61,0x63,0x6f,0x6e,0x22,0x3e,0x0d,0x0a,0x3c,0x66,0x69, /* e="beacon">..<fi */ \
	0x65,0x6c,0x64,0x73,0x65,0x74,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c  /* eldset>..<div><l */
#define DATACHUNK000013 \
	0x61,0x62,0x65,0x6c,0x3e,0x42,0x65,0x61,0x63,0x6f,0x6e,0x20,0x4d,0x65,0x73,0x73, /* abel>Beacon Mess */ \
	0x61,0x67,0x65,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69, /* age:</label>..<i */ \
	0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22, /* nput type="text" */ \
	0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x62,0x65,0x61,0x63,0x22,0x20,0x76,0x61,0x6c, /*  name="beac" val */ \
	0x75,0x65,0x3d,0x22,0x7e,0x42,0x65,0x61,0x63,0x6f,0x6e,0x4d,0x7e,0x22,0x20,0x73, /* ue="~BeaconM~" s */ \
	0x69,0x7a,0x65,0x3d,0x22,0x32,0x30,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22, /* ize="20" class=" */ \
	0x73,0x6d,0x22,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69, /* sm"/></div>..<di */ \
	0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x49,0x6e,0x65,0x72,0x76,0x61,0x6c, /* v><label>Inerval */ \
	0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75, /* :</label>..<inpu */ \
	0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61, /* t type="text" na */ \
	0x6d,0x65,0x3d,0x22,0x69,0x6e,0x74,0x76,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d, /* me="intv" value= */ \
	0x22,0x7e,0x42,0x65,0x61,0x63,0x6f,0x6e,0x49,0x6e,0x74,0x76,0x7e,0x22,0x20,0x73, /* "~BeaconIntv~" s */ \
	0x69,0x7a,0x65,0x3d,0x22,0x33,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61, /* ize="3" class="a */ \
	0x64,0x31,0x22,0x2f,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x53,0x65,0x63,0x2e,0x3c, /* d1"/>&nbsp;Sec.< */ \
	0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62, /* /div>..<div><lab */ \
	0x65,0x6c,0x3e,0x42,0x65,0x61,0x63,0x6f,0x6e,0x20,0x43,0x61,0x6c,0x6c,0x53,0x69, /* el>Beacon CallSi */ \
	0x67,0x6e,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e, /* gn:</label>..<in */ \
	0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20, /* put type="text"  */ \
	0x6e,0x61,0x6d,0x65,0x3d,0x22,0x62,0x63,0x61,0x6c,0x22,0x20,0x76,0x61,0x6c,0x75, /* name="bcal" valu */ \
	0x65,0x3d,0x22,0x7e,0x42,0x65,0x61,0x63,0x6f,0x6e,0x43,0x61,0x6c,0x6c,0x7e,0x22, /* e="~BeaconCall~" */ \
	0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x38,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d, /*  size="8" class= */ \
	0x22,0x73,0x6d,0x22,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a, /* "sm"/></div>.... */ \
	0x3c,0x64,0x69,0x76,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65, /* <div><input type */ \
	0x3d,0x22,0x73,0x75,0x62,0x6d,0x69,0x74,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d, /* ="submit" class= */ \
	0x22,0x61,0x70,0x31,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x53,0x61,0x76, /* "ap1" value="Sav */ \
	0x65,0x20,0x42,0x65,0x61,0x63,0x6f,0x6e,0x20,0x49,0x6e,0x66,0x6f,0x2e,0x22,0x20, /* e Beacon Info."  */ \
	0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x69,0x65,0x6c, /* /></div>..</fiel */ \
	0x64,0x73,0x65,0x74,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x6f,0x72,0x6d,0x3e,0x0d,0x0a, /* dset>..</form>.. */ \
	0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f, /* </div>..~inc:foo */ \
	0x74,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00, /* ter.inc~....3... */ \
	0xe6,0x00,0x00,0x00,0x71,0x00,0x00,0x00,0x53,0x01,0x00,0x00,0x72,0x00,0x00,0x00, /* ....q...S...r... */ \
	0xd5,0x01,0x00,0x00,0x9f,0x00,0x00,0x00,0x6a,0x02,0x00,0x00,0x02,0x00,0x00,0x00, /* ........j....... */ \
	0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e, /* ~inc:header.inc~ */ \
	0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e, /* .<div id="conten */ \
	0x74,0x22,0x3e,0x0a,0x0a,0x3c,0x68,0x31,0x3e,0x54,0x58,0x20,0x48,0x65,0x61,0x64, /* t">..<h1>TX Head */ \
	0x65,0x72,0x20,0x52,0x65,0x70,0x6c,0x61,0x63,0x65,0x20,0x43,0x6f,0x6e,0x66,0x69, /* er Replace Confi */ \
	0x67,0x75,0x72,0x61,0x74,0x69,0x6f,0x6e,0x3c,0x2f,0x68,0x31,0x3e,0x0a,0x0a,0x3c, /* guration</h1>..< */ \
	0x66,0x6f,0x72,0x6d,0x20,0x6d,0x65,0x74,0x68,0x6f,0x64,0x3d,0x22,0x70,0x6f,0x73, /* form method="pos */ \
	0x74,0x22,0x20,0x61,0x63,0x74,0x69,0x6f,0x6e,0x3d,0x22,0x2f,0x6e,0x6f,0x64,0x65, /* t" action="/node */ \
	0x61,0x64,0x61,0x70,0x74,0x65,0x72,0x2f,0x63,0x6f,0x6e,0x66,0x69,0x67,0x33,0x2e, /* adapter/config3. */ \
	0x68,0x74,0x6d,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x68,0x65,0x61,0x64,0x65, /* htm" name="heade */ \
	0x72,0x63,0x66,0x67,0x22,0x3e,0x0a,0x3c,0x66,0x69,0x65,0x6c,0x64,0x73,0x65,0x74, /* rcfg">.<fieldset */ \
	0x3e,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x54,0x58, /* >.<div><label>TX */ \
	0x20,0x48,0x65,0x61,0x64,0x65,0x72,0x20,0x52,0x65,0x70,0x6c,0x61,0x63,0x65,0x3a, /*  Header Replace: */ \
	0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20, /* </label>.<input  */ \
	0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20, /* type="checkbox"  */ \
	0x6e,0x61,0x6d,0x65,0x3d,0x22,0x74,0x78,0x68,0x72,0x22,0x20,0x76,0x61,0x6c,0x75, /* name="txhr" valu */ \
	0x65,0x3d,0x22,0x22,0x20,0x7e,0x48,0x65,0x61,0x64,0x65,0x72,0x52,0x65,0x70,0x7e, /* e="" ~HeaderRep~ */ \
	0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x20,0x6f,0x6e,0x63, /*  class="ad1" onc */ \
	0x6c,0x69,0x63,0x6b,0x3d,0x22,0x63,0x6f,0x6e,0x66,0x69,0x67,0x48,0x65,0x61,0x64, /* lick="configHead */ \
	0x65,0x72,0x28,0x29,0x22,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0a,0x3c,0x62, /* er()"/></div>.<b */ \
	0x72,0x3e,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x41, /* r>.<div><label>A */ \
	0x6c,0x74,0x65,0x72,0x20,0x4d,0x79,0x43,0x61,0x6c,0x6c,0x3a,0x3c,0x2f,0x6c,0x61, /* lter MyCall:</la */ \
	0x62,0x65,0x6c,0x3e,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65, /* bel>.<input type */ \
	0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6d,0x79, /* ="text" name="my */ \
	0x63,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x61,0x6c,0x74,0x5f,0x6d, /* c" value="~alt_m */ \
	0x79,0x63,0x61,0x6c,0x6c,0x7e,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x38,0x22, /* ycall~" size="8" */ \
	0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x2f,0x3e,0x0a,0x3c, /*  class="ad1"/>.< */ \
	0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63, /* input type="chec */ \
	0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x61,0x6d,0x79,0x63, /* kbox" name="amyc */ \
	0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x61,0x5f,0x6d,0x79, /* " value="" ~a_my */ \
	0x63,0x61,0x6c,0x6c,0x7e,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x33, /* call~ class="ad3 */ \
	0x22,0x20,0x2f,0x3e,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0a,0x3c,0x64,0x69,0x76, /* " />.</div>.<div */ \
	0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x41,0x6c,0x74,0x65,0x72,0x20,0x4d,0x79  /* ><label>Alter My */
#define DATACHUNK000014 \
	0x43,0x61,0x6c,0x6c,0x32,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0a,0x3c, /* Call2:</label>.< */ \
	0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74, /* input type="text */ \
	0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6d,0x79,0x63,0x32,0x22,0x20,0x76,0x61, /* " name="myc2" va */ \
	0x6c,0x75,0x65,0x3d,0x22,0x7e,0x61,0x6c,0x74,0x5f,0x6d,0x79,0x63,0x61,0x6c,0x6c, /* lue="~alt_mycall */ \
	0x32,0x7e,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x34,0x22,0x20,0x63,0x6c,0x61, /* 2~" size="4" cla */ \
	0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x2f,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b, /* ss="ad1"/>&nbsp; */ \
	0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73, /* &nbsp;&nbsp;&nbs */ \
	0x70,0x3b,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22, /* p;.<input type=" */ \
	0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22, /* checkbox" name=" */ \
	0x61,0x6d,0x79,0x32,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e, /* amy2" value="" ~ */ \
	0x61,0x5f,0x6d,0x79,0x63,0x61,0x6c,0x6c,0x32,0x7e,0x20,0x63,0x6c,0x61,0x73,0x73, /* a_mycall2~ class */ \
	0x3d,0x22,0x61,0x64,0x33,0x22,0x20,0x2f,0x3e,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e, /* ="ad3" />.</div> */ \
	0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x41,0x6c,0x74, /* .<div><label>Alt */ \
	0x65,0x72,0x20,0x59,0x6f,0x75,0x72,0x43,0x61,0x6c,0x6c,0x3a,0x3c,0x2f,0x6c,0x61, /* er YourCall:</la */ \
	0x62,0x65,0x6c,0x3e,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65, /* bel>.<input type */ \
	0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x79,0x72, /* ="text" name="yr */ \
	0x63,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x61,0x6c,0x74,0x5f,0x79, /* c" value="~alt_y */ \
	0x6f,0x75,0x72,0x63,0x61,0x6c,0x6c,0x7e,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22, /* ourcall~" size=" */ \
	0x38,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x2f,0x3e, /* 8" class="ad1"/> */ \
	0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68, /* .<input type="ch */ \
	0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x61,0x79, /* eckbox" name="ay */ \
	0x72,0x63,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x61,0x5f, /* rc" value="" ~a_ */ \
	0x79,0x6f,0x75,0x72,0x63,0x61,0x6c,0x6c,0x7e,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d, /* yourcall~ class= */ \
	0x22,0x61,0x64,0x33,0x22,0x20,0x2f,0x3e,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0a, /* "ad3" />.</div>. */ \
	0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x41,0x6c,0x74,0x65, /* <div><label>Alte */ \
	0x72,0x20,0x52,0x50,0x54,0x31,0x20,0x43,0x61,0x6c,0x6c,0x3a,0x3c,0x2f,0x6c,0x61, /* r RPT1 Call:</la */ \
	0x62,0x65,0x6c,0x3e,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65, /* bel>.<input type */ \
	0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x72,0x70, /* ="text" name="rp */ \
	0x74,0x31,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x61,0x6c,0x74,0x5f, /* t1" value="~alt_ */ \
	0x72,0x70,0x74,0x31,0x63,0x61,0x6c,0x6c,0x7e,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d, /* rpt1call~" size= */ \
	0x22,0x38,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x2f, /* "8" class="ad1"/ */ \
	0x3e,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63, /* >.<input type="c */ \
	0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x61, /* heckbox" name="a */ \
	0x72,0x74,0x31,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x61, /* rt1" value="" ~a */ \
	0x5f,0x72,0x70,0x74,0x31,0x63,0x61,0x6c,0x6c,0x7e,0x20,0x63,0x6c,0x61,0x73,0x73, /* _rpt1call~ class */ \
	0x3d,0x22,0x61,0x64,0x33,0x22,0x20,0x2f,0x3e,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e, /* ="ad3" />.</div> */ \
	0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x41,0x6c,0x74, /* .<div><label>Alt */ \
	0x65,0x72,0x20,0x52,0x50,0x54,0x32,0x20,0x43,0x61,0x6c,0x6c,0x3a,0x3c,0x2f,0x6c, /* er RPT2 Call:</l */ \
	0x61,0x62,0x65,0x6c,0x3e,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70, /* abel>.<input typ */ \
	0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x72, /* e="text" name="r */ \
	0x70,0x74,0x32,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x61,0x6c,0x74, /* pt2" value="~alt */ \
	0x5f,0x72,0x70,0x74,0x32,0x63,0x61,0x6c,0x6c,0x7e,0x22,0x20,0x73,0x69,0x7a,0x65, /* _rpt2call~" size */ \
	0x3d,0x22,0x38,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22, /* ="8" class="ad1" */ \
	0x2f,0x3e,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22, /* />.<input type=" */ \
	0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22, /* checkbox" name=" */ \
	0x61,0x72,0x74,0x32,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e, /* art2" value="" ~ */ \
	0x61,0x5f,0x72,0x70,0x74,0x32,0x63,0x61,0x6c,0x6c,0x7e,0x20,0x63,0x6c,0x61,0x73, /* a_rpt2call~ clas */ \
	0x73,0x3d,0x22,0x61,0x64,0x33,0x22,0x20,0x2f,0x3e,0x0a,0x3c,0x2f,0x64,0x69,0x76, /* s="ad3" />.</div */ \
	0x3e,0x0a,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x41, /* >..<div><label>A */ \
	0x6c,0x74,0x2e,0x20,0x54,0x58,0x20,0x48,0x65,0x61,0x64,0x65,0x72,0x20,0x46,0x6c, /* lt. TX Header Fl */ \
	0x61,0x67,0x73,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0a,0x3c,0x69,0x6e, /* ags:</label>.<in */ \
	0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62, /* put type="checkb */ \
	0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x66,0x6c,0x67,0x37,0x22,0x20, /* ox" name="flg7"  */ \
	0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x66,0x6c,0x61,0x67,0x37,0x7e, /* value="" ~flag7~ */ \
	0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x20,0x64,0x69,0x73, /*  class="ad1" dis */ \
	0x61,0x62,0x6c,0x65,0x64,0x2f,0x3e,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74, /* abled/>.<input t */ \
	0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e, /* ype="checkbox" n */ \
	0x61,0x6d,0x65,0x3d,0x22,0x66,0x6c,0x67,0x36,0x22,0x20,0x76,0x61,0x6c,0x75,0x65, /* ame="flg6" value */ \
	0x3d,0x22,0x22,0x20,0x7e,0x66,0x6c,0x61,0x67,0x36,0x7e,0x20,0x63,0x6c,0x61,0x73, /* ="" ~flag6~ clas */ \
	0x73,0x3d,0x22,0x61,0x64,0x33,0x22,0x20,0x2f,0x3e,0x0a,0x3c,0x69,0x6e,0x70,0x75, /* s="ad3" />.<inpu */ \
	0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78, /* t type="checkbox */ \
	0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x66,0x6c,0x67,0x35,0x22,0x20,0x76,0x61, /* " name="flg5" va */ \
	0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x66,0x6c,0x61,0x67,0x35,0x7e,0x20,0x63, /* lue="" ~flag5~ c */ \
	0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x33,0x22,0x20,0x2f,0x3e,0x0a,0x3c,0x69  /* lass="ad3" />.<i */
#define DATACHUNK000015 \
	0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b, /* nput type="check */ \
	0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x66,0x6c,0x67,0x34,0x22, /* box" name="flg4" */ \
	0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x66,0x6c,0x61,0x67,0x34, /*  value="" ~flag4 */ \
	0x7e,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x33,0x22,0x20,0x2f,0x3e, /* ~ class="ad3" /> */ \
	0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68, /* .<input type="ch */ \
	0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x66,0x6c, /* eckbox" name="fl */ \
	0x67,0x33,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x66,0x6c, /* g3" value="" ~fl */ \
	0x61,0x67,0x33,0x7e,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x33,0x22, /* ag3~ class="ad3" */ \
	0x20,0x2f,0x3e,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d, /*  />.<input type= */ \
	0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d, /* "checkbox" name= */ \
	0x22,0x66,0x6c,0x67,0x32,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20, /* "flg2" value=""  */ \
	0x7e,0x66,0x6c,0x61,0x67,0x32,0x7e,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61, /* ~flag2~ class="a */ \
	0x64,0x33,0x22,0x20,0x2f,0x3e,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79, /* d3" />.<input ty */ \
	0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61, /* pe="checkbox" na */ \
	0x6d,0x65,0x3d,0x22,0x66,0x6c,0x67,0x31,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d, /* me="flg1" value= */ \
	0x22,0x22,0x20,0x7e,0x66,0x6c,0x61,0x67,0x31,0x7e,0x20,0x63,0x6c,0x61,0x73,0x73, /* "" ~flag1~ class */ \
	0x3d,0x22,0x61,0x64,0x33,0x22,0x20,0x2f,0x3e,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74, /* ="ad3" />.<input */ \
	0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22, /*  type="checkbox" */ \
	0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x66,0x6c,0x67,0x30,0x22,0x20,0x76,0x61,0x6c, /*  name="flg0" val */ \
	0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x66,0x6c,0x61,0x67,0x30,0x7e,0x20,0x63,0x6c, /* ue="" ~flag0~ cl */ \
	0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x33,0x22,0x20,0x2f,0x3e,0x26,0x6e,0x62,0x73, /* ass="ad3" />&nbs */ \
	0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20, /* p;&nbsp;.<input  */ \
	0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20, /* type="checkbox"  */ \
	0x6e,0x61,0x6d,0x65,0x3d,0x22,0x61,0x66,0x6c,0x67,0x22,0x20,0x76,0x61,0x6c,0x75, /* name="aflg" valu */ \
	0x65,0x3d,0x22,0x22,0x20,0x7e,0x41,0x66,0x6c,0x61,0x67,0x7e,0x20,0x63,0x6c,0x61, /* e="" ~Aflag~ cla */ \
	0x73,0x73,0x3d,0x22,0x61,0x64,0x33,0x22,0x20,0x2f,0x3e,0x0a,0x3c,0x2f,0x64,0x69, /* ss="ad3" />.</di */ \
	0x76,0x3e,0x0a,0x0a,0x0a,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x69,0x6e,0x70,0x75, /* v>....<div><inpu */ \
	0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x73,0x75,0x62,0x6d,0x69,0x74,0x22,0x20, /* t type="submit"  */ \
	0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x70,0x31,0x22,0x20,0x6e,0x61,0x6d,0x65, /* class="ap1" name */ \
	0x3d,0x22,0x68,0x64,0x72,0x73,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x53, /* ="hdrs" value="S */ \
	0x61,0x76,0x65,0x20,0x48,0x65,0x61,0x64,0x65,0x72,0x20,0x49,0x6e,0x66,0x6f,0x2e, /* ave Header Info. */ \
	0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0a,0x3c,0x2f,0x66,0x69,0x65, /* " /></div>.</fie */ \
	0x6c,0x64,0x73,0x65,0x74,0x3e,0x0a,0x3c,0x2f,0x66,0x6f,0x72,0x6d,0x3e,0x0a,0x3c, /* ldset>.</form>.< */ \
	0x2f,0x64,0x69,0x76,0x3e,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x6c,0x61, /* /div>.<script la */ \
	0x6e,0x67,0x75,0x61,0x67,0x65,0x3d,0x22,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69, /* nguage="javascri */ \
	0x70,0x74,0x22,0x3e,0x0a,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x20,0x63,0x6f, /* pt">.function co */ \
	0x6e,0x66,0x69,0x67,0x48,0x65,0x61,0x64,0x65,0x72,0x28,0x29,0x20,0x7b,0x0a,0x09, /* nfigHeader() {.. */ \
	0x65,0x20,0x3d,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x66,0x6f,0x72, /* e = document.for */ \
	0x6d,0x73,0x2e,0x68,0x65,0x61,0x64,0x65,0x72,0x63,0x66,0x67,0x3b,0x0a,0x09,0x73, /* ms.headercfg;..s */ \
	0x74,0x20,0x3d,0x20,0x21,0x28,0x65,0x2e,0x74,0x78,0x68,0x72,0x2e,0x63,0x68,0x65, /* t = !(e.txhr.che */ \
	0x63,0x6b,0x65,0x64,0x29,0x3b,0x0a,0x09,0x65,0x2e,0x6d,0x79,0x63,0x2e,0x64,0x69, /* cked);..e.myc.di */ \
	0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0a,0x09,0x65,0x2e, /* sabled = st;..e. */ \
	0x6d,0x79,0x63,0x32,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20, /* myc2.disabled =  */ \
	0x73,0x74,0x3b,0x0a,0x09,0x65,0x2e,0x79,0x72,0x63,0x2e,0x64,0x69,0x73,0x61,0x62, /* st;..e.yrc.disab */ \
	0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0a,0x09,0x65,0x2e,0x72,0x70,0x74, /* led = st;..e.rpt */ \
	0x31,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b, /* 1.disabled = st; */ \
	0x0a,0x09,0x65,0x2e,0x72,0x70,0x74,0x32,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65, /* ..e.rpt2.disable */ \
	0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0a,0x09,0x65,0x2e,0x66,0x6c,0x67,0x36,0x2e, /* d = st;..e.flg6. */ \
	0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0a,0x09, /* disabled = st;.. */ \
	0x65,0x2e,0x66,0x6c,0x67,0x35,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20, /* e.flg5.disabled  */ \
	0x3d,0x20,0x73,0x74,0x3b,0x0a,0x09,0x65,0x2e,0x66,0x6c,0x67,0x34,0x2e,0x64,0x69, /* = st;..e.flg4.di */ \
	0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0a,0x09,0x65,0x2e, /* sabled = st;..e. */ \
	0x66,0x6c,0x67,0x33,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20, /* flg3.disabled =  */ \
	0x73,0x74,0x3b,0x0a,0x09,0x65,0x2e,0x66,0x6c,0x67,0x32,0x2e,0x64,0x69,0x73,0x61, /* st;..e.flg2.disa */ \
	0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0a,0x09,0x65,0x2e,0x66,0x6c, /* bled = st;..e.fl */ \
	0x67,0x31,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74, /* g1.disabled = st */ \
	0x3b,0x0a,0x09,0x65,0x2e,0x66,0x6c,0x67,0x30,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c, /* ;..e.flg0.disabl */ \
	0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0a,0x09,0x65,0x2e,0x61,0x66,0x6c,0x67, /* ed = st;..e.aflg */ \
	0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0a, /* .disabled = st;. */ \
	0x09,0x65,0x2e,0x61,0x6d,0x79,0x63,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64, /* .e.amyc.disabled */ \
	0x20,0x3d,0x20,0x73,0x74,0x3b,0x0a,0x09,0x65,0x2e,0x61,0x6d,0x79,0x32,0x2e,0x64, /*  = st;..e.amy2.d */ \
	0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0a,0x09,0x65, /* isabled = st;..e */ \
	0x2e,0x61,0x79,0x72,0x63,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d, /* .ayrc.disabled = */ \
	0x20,0x73,0x74,0x3b,0x0a,0x09,0x65,0x2e,0x61,0x72,0x74,0x31,0x2e,0x64,0x69,0x73  /*  st;..e.art1.dis */
#define DATACHUNK000016 \
	0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0a,0x09,0x65,0x2e,0x61, /* abled = st;..e.a */ \
	0x72,0x74,0x32,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73, /* rt2.disabled = s */ \
	0x74,0x3b,0x0a,0x7d,0x0a,0x0a,0x63,0x6f,0x6e,0x66,0x69,0x67,0x48,0x65,0x61,0x64, /* t;.}..configHead */ \
	0x65,0x72,0x28,0x29,0x3b,0x0a,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74,0x3e, /* er();..</script> */ \
	0x0a,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e, /* ..~inc:footer.in */ \
	0x63,0x7e,0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0xf5,0x00,0x00,0x00,0x73,0x00, /* c~....3.......s. */ \
	0x00,0x00,0x7a,0x01,0x00,0x00,0x74,0x00,0x00,0x00,0xcb,0x01,0x00,0x00,0x81,0x00, /* ..z...t......... */ \
	0x00,0x00,0x35,0x02,0x00,0x00,0x75,0x00,0x00,0x00,0x9f,0x02,0x00,0x00,0x82,0x00, /* ..5...u......... */ \
	0x00,0x00,0x0a,0x03,0x00,0x00,0x76,0x00,0x00,0x00,0x5d,0x03,0x00,0x00,0x83,0x00, /* ......v...]..... */ \
	0x00,0x00,0xcb,0x03,0x00,0x00,0x77,0x00,0x00,0x00,0x1e,0x04,0x00,0x00,0x84,0x00, /* ......w......... */ \
	0x00,0x00,0x8c,0x04,0x00,0x00,0x78,0x00,0x00,0x00,0xdf,0x04,0x00,0x00,0x85,0x00, /* ......x......... */ \
	0x00,0x00,0x59,0x05,0x00,0x00,0x79,0x00,0x00,0x00,0xa4,0x05,0x00,0x00,0x7a,0x00, /* ..Y...y.......z. */ \
	0x00,0x00,0xe7,0x05,0x00,0x00,0x7b,0x00,0x00,0x00,0x2a,0x06,0x00,0x00,0x7c,0x00, /* ......{.......|. */ \
	0x00,0x00,0x6d,0x06,0x00,0x00,0x7d,0x00,0x00,0x00,0xb0,0x06,0x00,0x00,0x7e,0x00, /* ..m...}.......~. */ \
	0x00,0x00,0xf3,0x06,0x00,0x00,0x7f,0x00,0x00,0x00,0x36,0x07,0x00,0x00,0x80,0x00, /* ..........6..... */ \
	0x00,0x00,0x85,0x07,0x00,0x00,0x88,0x00,0x00,0x00,0x42,0x0a,0x00,0x00,0x02,0x00, /* ..........B..... */ \
	0x00,0x00,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e, /* ..~inc:header.in */ \
	0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e, /* c~..<div id="con */ \
	0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x41,0x63,0x63,0x65, /* tent">..<h1>Acce */ \
	0x73,0x73,0x20,0x43,0x6f,0x6e,0x74,0x72,0x6f,0x6c,0x20,0x46,0x69,0x6c,0x65,0x3c, /* ss Control File< */ \
	0x2f,0x68,0x31,0x3e,0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x74,0x79, /* /h1>..<script ty */ \
	0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x2f,0x6a,0x61,0x76,0x61,0x73,0x63,0x72, /* pe="text/javascr */ \
	0x69,0x70,0x74,0x22,0x20,0x6c,0x61,0x6e,0x67,0x75,0x61,0x67,0x65,0x3d,0x22,0x4a, /* ipt" language="J */ \
	0x61,0x76,0x61,0x53,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x0d,0x0a,0x3c,0x21,0x2d, /* avaScript">..<!- */ \
	0x2d,0x0d,0x0a,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x20,0x49,0x6e,0x69,0x74, /* -..function Init */ \
	0x56,0x61,0x6c,0x75,0x65,0x53,0x65,0x74,0x28,0x29,0x0d,0x0a,0x7b,0x0d,0x0a,0x63, /* ValueSet()..{..c */ \
	0x61,0x6c,0x6c,0x73,0x69,0x67,0x6e,0x20,0x3d,0x20,0x6e,0x65,0x77,0x20,0x41,0x72, /* allsign = new Ar */ \
	0x72,0x61,0x79,0x28,0x29,0x3b,0x0d,0x0a,0x61,0x63,0x63,0x65,0x73,0x73,0x09,0x20, /* ray();..access.  */ \
	0x3d,0x20,0x6e,0x65,0x77,0x20,0x41,0x72,0x72,0x61,0x79,0x28,0x29,0x3b,0x09,0x0d, /* = new Array();.. */ \
	0x0a,0x7e,0x61,0x63,0x63,0x65,0x73,0x73,0x46,0x69,0x72,0x73,0x74,0x7e,0x0d,0x0a, /* .~accessFirst~.. */ \
	0x7e,0x61,0x63,0x63,0x65,0x73,0x73,0x7e,0x0d,0x0a,0x7d,0x0d,0x0a,0x0d,0x0a,0x2f, /* ~access~..}..../ */ \
	0x2f,0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74,0x3e,0x0d, /* /-->..</script>. */ \
	0x0a,0x3c,0x66,0x6f,0x72,0x6d,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x61,0x63,0x63, /* .<form name="acc */ \
	0x22,0x3e,0x0d,0x0a,0x3c,0x62,0x72,0x3e,0x0d,0x0a,0x3c,0x62,0x3e,0x4e,0x6f,0x74, /* ">..<br>..<b>Not */ \
	0x65,0x3a,0x20,0x44,0x6f,0x20,0x6e,0x6f,0x74,0x20,0x63,0x6c,0x6f,0x73,0x65,0x20, /* e: Do not close  */ \
	0x74,0x68,0x69,0x73,0x20,0x77,0x69,0x6e,0x64,0x6f,0x77,0x20,0x75,0x6e,0x74,0x69, /* this window unti */ \
	0x6c,0x20,0x63,0x6c,0x6f,0x73,0x69,0x6e,0x67,0x20,0x74,0x68,0x65,0x20,0x65,0x64, /* l closing the ed */ \
	0x69,0x74,0x20,0x77,0x69,0x6e,0x64,0x6f,0x77,0x21,0x3c,0x2f,0x62,0x3e,0x3c,0x62, /* it window!</b><b */ \
	0x72,0x3e,0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x74,0x79,0x70,0x65, /* r>..<script type */ \
	0x3d,0x22,0x74,0x65,0x78,0x74,0x2f,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70, /* ="text/javascrip */ \
	0x74,0x22,0x20,0x6c,0x61,0x6e,0x67,0x75,0x61,0x67,0x65,0x3d,0x22,0x4a,0x61,0x76, /* t" language="Jav */ \
	0x61,0x53,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x0d,0x0a,0x3c,0x21,0x2d,0x2d,0x0d, /* aScript">..<!--. */ \
	0x0a,0x76,0x61,0x72,0x20,0x77,0x3b,0x0d,0x0a,0x49,0x6e,0x69,0x74,0x56,0x61,0x6c, /* .var w;..InitVal */ \
	0x75,0x65,0x53,0x65,0x74,0x28,0x29,0x3b,0x0d,0x0a,0x69,0x66,0x20,0x28,0x21,0x77, /* ueSet();..if (!w */ \
	0x20,0x7c,0x7c,0x20,0x77,0x2e,0x63,0x6c,0x6f,0x73,0x65,0x64,0x29,0x20,0x77,0x69, /*  || w.closed) wi */ \
	0x6e,0x64,0x6f,0x77,0x2e,0x6f,0x70,0x65,0x6e,0x28,0x22,0x2e,0x2f,0x65,0x64,0x69, /* ndow.open("./edi */ \
	0x74,0x2e,0x68,0x74,0x6d,0x22,0x29,0x3b,0x0d,0x0a,0x65,0x6c,0x73,0x65,0x20,0x77, /* t.htm");..else w */ \
	0x2e,0x66,0x6f,0x63,0x75,0x73,0x28,0x29,0x3b,0x0d,0x0a,0x2f,0x2f,0x20,0x2d,0x2d, /* .focus();..// -- */ \
	0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74,0x3e,0x0d,0x0a,0x3c,0x2f, /* >..</script>..</ */ \
	0x66,0x6f,0x72,0x6d,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d, /* form>..</div>... */ \
	0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e,0x63, /* .~inc:footer.inc */ \
	0x7e,0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0xcf,0x00,0x00,0x00,0xc3,0x00,0x00, /* ~....3.......... */ \
	0x00,0xde,0x00,0x00,0x00,0xaa,0x00,0x00,0x00,0x1f,0x02,0x00,0x00,0x02,0x00,0x00, /* ................ */ \
	0x00,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63, /* .~inc:header.inc */ \
	0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74, /* ~..<div id="cont */ \
	0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x4e,0x65,0x74, /* ent">....<h1>Net */ \
	0x77,0x6f,0x72,0x6b,0x20,0x43,0x6f,0x6e,0x66,0x69,0x67,0x75,0x72,0x61,0x74,0x69, /* work Configurati */ \
	0x6f,0x6e,0x3c,0x2f,0x68,0x31,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x66,0x6f,0x72,0x6d, /* on</h1>....<form */ \
	0x20,0x6d,0x65,0x74,0x68,0x6f,0x64,0x3d,0x22,0x70,0x6f,0x73,0x74,0x22,0x20,0x61, /*  method="post" a */ \
	0x63,0x74,0x69,0x6f,0x6e,0x3d,0x22,0x2f,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f, /* ction="/protect/ */ \
	0x63,0x6f,0x6e,0x66,0x69,0x67,0x2e,0x68,0x74,0x6d,0x22,0x20,0x6e,0x61,0x6d,0x65, /* config.htm" name */ \
	0x3d,0x22,0x63,0x6f,0x6e,0x66,0x69,0x67,0x22,0x3e,0x0d,0x0a,0x3c,0x66,0x69,0x65, /* ="config">..<fie */ \
	0x6c,0x64,0x73,0x65,0x74,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61, /* ldset>..<div><la */ \
	0x62,0x65,0x6c,0x3e,0x4d,0x41,0x43,0x20,0x41,0x64,0x64,0x72,0x65,0x73,0x73,0x3a  /* bel>MAC Address: */
#define DATACHUNK000017 \
	0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74, /* </label>..<input */ \
	0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d, /*  type="text" nam */ \
	0x65,0x3d,0x22,0x6d,0x61,0x63,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e, /* e="mac" value="~ */ \
	0x63,0x6f,0x6e,0x66,0x69,0x67,0x5f,0x6d,0x61,0x63,0x7e,0x22,0x20,0x2f,0x3e,0x3c, /* config_mac~" />< */ \
	0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62, /* /div>..<div><lab */ \
	0x65,0x6c,0x3e,0x69,0x72,0x63,0x44,0x44,0x42,0x20,0x44,0x4e,0x53,0x20,0x75,0x73, /* el>ircDDB DNS us */ \
	0x65,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70, /* e:</label>..<inp */ \
	0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f, /* ut type="checkbo */ \
	0x78,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x73,0x6d,0x22,0x20,0x6e,0x61, /* x" class="sm" na */ \
	0x6d,0x65,0x3d,0x22,0x69,0x72,0x63,0x64,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d, /* me="ircd" value= */ \
	0x22,0x31,0x22,0x20,0x7e,0x69,0x72,0x63,0x44,0x44,0x42,0x7e,0x20,0x6f,0x6e,0x63, /* "1" ~ircDDB~ onc */ \
	0x6c,0x69,0x63,0x6b,0x3d,0x22,0x63,0x6f,0x6e,0x66,0x69,0x67,0x49,0x52,0x43,0x28, /* lick="configIRC( */ \
	0x29,0x22,0x20,0x2f,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x0d,0x0a,0x54,0x79,0x70, /* )" />&nbsp;..Typ */ \
	0x65,0x20,0x3a,0x3c,0x73,0x65,0x6c,0x65,0x63,0x74,0x20,0x6e,0x61,0x6d,0x65,0x3d, /* e :<select name= */ \
	0x22,0x69,0x72,0x63,0x74,0x22,0x3e,0x0d,0x0a,0x7e,0x69,0x72,0x63,0x53,0x65,0x6c, /* "irct">..~ircSel */ \
	0x65,0x63,0x74,0x7e,0x0d,0x0a,0x3c,0x2f,0x73,0x65,0x6c,0x65,0x63,0x74,0x3e,0x0d, /* ect~..</select>. */ \
	0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e, /* .</div>....<div> */ \
	0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x44,0x43,0x53,0x2f,0x58,0x52,0x46,0x20,0x72, /* <label>DCS/XRF r */ \
	0x65,0x66,0x6c,0x65,0x63,0x74,0x6f,0x72,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c, /* eflector:</label */ \
	0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62, /* >&nbsp;&nbsp;&nb */ \
	0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26, /* sp;&nbsp;&nbsp;& */ \
	0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70, /* nbsp;&nbsp;&nbsp */ \
	0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20, /* ;&nbsp;..<input  */ \
	0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65, /* type="text" name */ \
	0x3d,0x22,0x69,0x72,0x63,0x72,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e, /* ="ircr" value="~ */ \
	0x69,0x72,0x63,0x5f,0x72,0x65,0x66,0x7e,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22, /* irc_ref~" size=" */ \
	0x38,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x33,0x22,0x2f,0x3e, /* 8" class="ad3"/> */ \
	0x0d,0x0a,0x26,0x6e,0x62,0x73,0x70,0x3b,0x42,0x61,0x6e,0x64,0x26,0x6e,0x62,0x73, /* ..&nbsp;Band&nbs */ \
	0x70,0x3b,0x0d,0x0a,0x3c,0x73,0x65,0x6c,0x65,0x63,0x74,0x20,0x6e,0x61,0x6d,0x65, /* p;..<select name */ \
	0x3d,0x22,0x69,0x72,0x63,0x62,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61, /* ="ircb" class="a */ \
	0x64,0x33,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x31,0x22,0x2f,0x3e,0x0d,0x0a, /* d3" size="1"/>.. */ \
	0x7e,0x69,0x72,0x63,0x42,0x61,0x6e,0x64,0x53,0x65,0x6c,0x65,0x63,0x74,0x7e,0x0d, /* ~ircBandSelect~. */ \
	0x0a,0x3c,0x2f,0x73,0x65,0x6c,0x65,0x63,0x74,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e, /* .</select></div> */ \
	0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x52,0x65, /* ..<div><label>Re */ \
	0x70,0x65,0x61,0x74,0x65,0x72,0x2f,0x52,0x65,0x66,0x6c,0x65,0x63,0x74,0x6f,0x72, /* peater/Reflector */ \
	0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x7e,0x52,0x65,0x66,0x53, /* :</label>..~RefS */ \
	0x65,0x6c,0x65,0x63,0x74,0x46,0x69,0x72,0x73,0x74,0x7e,0x0d,0x0a,0x7e,0x52,0x65, /* electFirst~..~Re */ \
	0x66,0x53,0x65,0x6c,0x65,0x63,0x74,0x7e,0x0d,0x0a,0x26,0x6e,0x62,0x73,0x70,0x3b, /* fSelect~..&nbsp; */ \
	0x42,0x61,0x6e,0x64,0x26,0x6e,0x62,0x73,0x70,0x3b,0x0d,0x0a,0x3c,0x73,0x65,0x6c, /* Band&nbsp;..<sel */ \
	0x65,0x63,0x74,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x62,0x61,0x6e,0x64,0x22,0x20, /* ect name="band"  */ \
	0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x33,0x22,0x20,0x73,0x69,0x7a,0x65, /* class="ad3" size */ \
	0x3d,0x22,0x31,0x22,0x2f,0x3e,0x0d,0x0a,0x7e,0x42,0x61,0x6e,0x64,0x53,0x65,0x6c, /* ="1"/>..~BandSel */ \
	0x65,0x63,0x74,0x7e,0x0d,0x0a,0x3c,0x2f,0x73,0x65,0x6c,0x65,0x63,0x74,0x3e,0x0d, /* ect~..</select>. */ \
	0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c, /* .</div>..<div><l */ \
	0x61,0x62,0x65,0x6c,0x3e,0x44,0x50,0x6c,0x75,0x73,0x20,0x47,0x61,0x74,0x65,0x2f, /* abel>DPlus Gate/ */ \
	0x52,0x65,0x66,0x2e,0x20,0x49,0x50,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e, /* Ref. IP:</label> */ \
	0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74, /* ..<input type="t */ \
	0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x68,0x6f,0x73,0x74,0x22, /* ext" name="host" */ \
	0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x73,0x65,0x72,0x76,0x65,0x72,0x5f, /*  value="~server_ */ \
	0x6e,0x61,0x6d,0x65,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d, /* name~" /></div>. */ \
	0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x41,0x75,0x74, /* .<div><label>Aut */ \
	0x6f,0x2e,0x20,0x4c,0x69,0x6e,0x6b,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e, /* o. Link:</label> */ \
	0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63, /* ..<input type="c */ \
	0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22, /* heckbox" class=" */ \
	0x73,0x6d,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x61,0x75,0x74,0x63,0x22,0x20, /* sm" name="autc"  */ \
	0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x31,0x22,0x20,0x7e,0x41,0x75,0x74,0x43,0x6f, /* value="1" ~AutCo */ \
	0x6e,0x6e,0x65,0x63,0x74,0x7e,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d, /* nnect~ /></div>. */ \
	0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x41,0x75,0x74, /* .<div><label>Aut */ \
	0x6f,0x2e,0x20,0x52,0x65,0x4c,0x69,0x6e,0x6b,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65, /* o. ReLink:</labe */ \
	0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d, /* l>..<input type= */ \
	0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x63,0x6c,0x61,0x73,0x73, /* "checkbox" class */ \
	0x3d,0x22,0x73,0x6d,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x72,0x65,0x63,0x6f, /* ="sm" name="reco */ \
	0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x31,0x22,0x20,0x7e,0x52,0x65,0x43, /* " value="1" ~ReC */ \
	0x6f,0x6e,0x6e,0x65,0x63,0x74,0x7e,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e  /* onnect~ /></div> */
#define DATACHUNK000018 \
	0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x52,0x65, /* ..<div><label>Re */ \
	0x70,0x65,0x61,0x74,0x65,0x72,0x20,0x41,0x63,0x63,0x65,0x73,0x73,0x3a,0x3c,0x2f, /* peater Access:</ */ \
	0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74, /* label>..<input t */ \
	0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x63, /* ype="checkbox" c */ \
	0x6c,0x61,0x73,0x73,0x3d,0x22,0x73,0x6d,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22, /* lass="sm" name=" */ \
	0x72,0x65,0x70,0x74,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x31,0x22,0x20, /* rept" value="1"  */ \
	0x7e,0x52,0x65,0x70,0x65,0x61,0x74,0x65,0x72,0x7e,0x20,0x2f,0x3e,0x3c,0x2f,0x64, /* ~Repeater~ /></d */ \
	0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c, /* iv>..<div><label */ \
	0x3e,0x4a,0x69,0x74,0x74,0x65,0x72,0x20,0x42,0x75,0x66,0x66,0x65,0x72,0x20,0x57, /* >Jitter Buffer W */ \
	0x61,0x69,0x74,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69, /* ait:</label>..<i */ \
	0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22, /* nput type="text" */ \
	0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6a,0x69,0x74,0x74,0x22,0x20,0x76,0x61,0x6c, /*  name="jitt" val */ \
	0x75,0x65,0x3d,0x22,0x7e,0x4a,0x69,0x74,0x74,0x65,0x72,0x53,0x69,0x7a,0x65,0x7e, /* ue="~JitterSize~ */ \
	0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x32,0x22,0x20,0x63,0x6c,0x61,0x73,0x73, /* " size="2" class */ \
	0x3d,0x22,0x61,0x64,0x31,0x22,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a, /* ="ad1"/></div>.. */ \
	0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x4e,0x54,0x50,0x20, /* <div><label>NTP  */ \
	0x53,0x65,0x72,0x76,0x65,0x72,0x20,0x4e,0x61,0x6d,0x65,0x3a,0x3c,0x2f,0x6c,0x61, /* Server Name:</la */ \
	0x62,0x65,0x6c,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b, /* bel>&nbsp;&nbsp; */ \
	0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73, /* &nbsp;&nbsp;&nbs */ \
	0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e, /* p;&nbsp;&nbsp;&n */ \
	0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x0d,0x0a,0x3c,0x73,0x65,0x6c, /* bsp;&nbsp;..<sel */ \
	0x65,0x63,0x74,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6e,0x74,0x70,0x22,0x3e,0x0d, /* ect name="ntp">. */ \
	0x0a,0x3c,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22, /* .<option value=" */ \
	0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67,0x22,0x3e,0x70,0x6f, /* pool.ntp.org">po */ \
	0x6f,0x6c,0x2e,0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67,0x0d,0x0a,0x3c,0x6f,0x70,0x74, /* ol.ntp.org..<opt */ \
	0x69,0x6f,0x6e,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x65,0x75,0x72,0x6f,0x70, /* ion value="europ */ \
	0x65,0x2e,0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67,0x22,0x3e, /* e.pool.ntp.org"> */ \
	0x65,0x75,0x72,0x6f,0x70,0x65,0x2e,0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74,0x70,0x2e, /* europe.pool.ntp. */ \
	0x6f,0x72,0x67,0x0d,0x0a,0x3c,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x20,0x76,0x61,0x6c, /* org..<option val */ \
	0x75,0x65,0x3d,0x22,0x61,0x73,0x69,0x61,0x2e,0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74, /* ue="asia.pool.nt */ \
	0x70,0x2e,0x6f,0x72,0x67,0x22,0x3e,0x61,0x73,0x69,0x61,0x2e,0x70,0x6f,0x6f,0x6c, /* p.org">asia.pool */ \
	0x2e,0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67,0x0d,0x0a,0x3c,0x6f,0x70,0x74,0x69,0x6f, /* .ntp.org..<optio */ \
	0x6e,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x6f,0x63,0x65,0x61,0x6e,0x69,0x61, /* n value="oceania */ \
	0x2e,0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67,0x22,0x3e,0x6f, /* .pool.ntp.org">o */ \
	0x63,0x65,0x61,0x6e,0x69,0x61,0x2e,0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74,0x70,0x2e, /* ceania.pool.ntp. */ \
	0x6f,0x72,0x67,0x0d,0x0a,0x3c,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x20,0x76,0x61,0x6c, /* org..<option val */ \
	0x75,0x65,0x3d,0x22,0x6e,0x6f,0x72,0x74,0x68,0x2d,0x61,0x6d,0x65,0x72,0x69,0x63, /* ue="north-americ */ \
	0x61,0x2e,0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67,0x22,0x3e, /* a.pool.ntp.org"> */ \
	0x6e,0x6f,0x72,0x74,0x68,0x2d,0x61,0x6d,0x65,0x72,0x69,0x63,0x61,0x2e,0x70,0x6f, /* north-america.po */ \
	0x6f,0x6c,0x2e,0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67,0x0d,0x0a,0x3c,0x6f,0x70,0x74, /* ol.ntp.org..<opt */ \
	0x69,0x6f,0x6e,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x73,0x6f,0x75,0x74,0x68, /* ion value="south */ \
	0x2d,0x61,0x6d,0x65,0x72,0x69,0x63,0x61,0x2e,0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74, /* -america.pool.nt */ \
	0x70,0x2e,0x6f,0x72,0x67,0x22,0x3e,0x73,0x6f,0x75,0x74,0x68,0x2d,0x61,0x6d,0x65, /* p.org">south-ame */ \
	0x72,0x69,0x63,0x61,0x2e,0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74,0x70,0x2e,0x6f,0x72, /* rica.pool.ntp.or */ \
	0x67,0x0d,0x0a,0x3c,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x20,0x76,0x61,0x6c,0x75,0x65, /* g..<option value */ \
	0x3d,0x22,0x61,0x66,0x72,0x69,0x63,0x61,0x2e,0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74, /* ="africa.pool.nt */ \
	0x70,0x2e,0x6f,0x72,0x67,0x22,0x3e,0x61,0x66,0x72,0x69,0x63,0x61,0x2e,0x70,0x6f, /* p.org">africa.po */ \
	0x6f,0x6c,0x2e,0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67,0x0d,0x0a,0x3c,0x2f,0x73,0x65, /* ol.ntp.org..</se */ \
	0x6c,0x65,0x63,0x74,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c, /* lect>..</div>..< */ \
	0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x54,0x69,0x6d,0x65,0x20, /* div><label>Time  */ \
	0x5a,0x6f,0x6e,0x65,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c, /* Zone:</label>..< */ \
	0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74, /* input type="text */ \
	0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x7a,0x6f,0x6e,0x65,0x22,0x20,0x76,0x61, /* " name="zone" va */ \
	0x6c,0x75,0x65,0x3d,0x22,0x7e,0x54,0x69,0x6d,0x65,0x5a,0x6f,0x6e,0x65,0x7e,0x22, /* lue="~TimeZone~" */ \
	0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x20,0x73,0x69,0x7a, /*  class="ad1" siz */ \
	0x65,0x3d,0x22,0x33,0x22,0x2f,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x68,0x6f,0x75, /* e="3"/>&nbsp;hou */ \
	0x72,0x73,0x26,0x6e,0x62,0x73,0x70,0x3b,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74, /* rs&nbsp;..<input */ \
	0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d, /*  type="text" nam */ \
	0x65,0x3d,0x22,0x7a,0x6e,0x65,0x4d,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22, /* e="zneM" value=" */ \
	0x7e,0x54,0x69,0x6d,0x65,0x5a,0x6f,0x6e,0x65,0x4d,0x69,0x6e,0x75,0x74,0x65,0x73, /* ~TimeZoneMinutes */ \
	0x7e,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x33,0x22,0x20,0x73, /* ~" class="ad3" s */ \
	0x69,0x7a,0x65,0x3d,0x22,0x32,0x22,0x2f,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x6d, /* ize="2"/>&nbsp;m */ \
	0x69,0x6e,0x75,0x74,0x65,0x73,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64, /* inutes</div>..<d */ \
	0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x44,0x69,0x73,0x61,0x62,0x6c  /* iv><label>Disabl */
#define DATACHUNK000019 \
	0x65,0x20,0x4c,0x69,0x6e,0x6b,0x2f,0x55,0x6e,0x6c,0x69,0x6e,0x6b,0x20,0x66,0x72, /* e Link/Unlink fr */ \
	0x6f,0x6d,0x20,0x52,0x46,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a, /* om RF:</label>.. */ \
	0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65, /* <input type="che */ \
	0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x73,0x6d, /* ckbox" class="sm */ \
	0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x72,0x66,0x63,0x6d,0x22,0x20,0x76,0x61, /* " name="rfcm" va */ \
	0x6c,0x75,0x65,0x3d,0x22,0x31,0x22,0x20,0x7e,0x44,0x69,0x73,0x61,0x62,0x6c,0x65, /* lue="1" ~Disable */ \
	0x52,0x46,0x63,0x6d,0x64,0x7e,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a, /* RFcmd~/></div>.. */ \
	0x3c,0x62,0x72,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65, /* <br>..<div><labe */ \
	0x6c,0x3e,0x56,0x6f,0x69,0x63,0x65,0x20,0x4d,0x65,0x73,0x73,0x61,0x67,0x65,0x20, /* l>Voice Message  */ \
	0x4f,0x46,0x46,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69, /* OFF:</label>..<i */ \
	0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b, /* nput type="check */ \
	0x62,0x6f,0x78,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x73,0x6d,0x22,0x20, /* box" class="sm"  */ \
	0x6e,0x61,0x6d,0x65,0x3d,0x22,0x76,0x69,0x63,0x65,0x22,0x20,0x76,0x61,0x6c,0x75, /* name="vice" valu */ \
	0x65,0x3d,0x22,0x31,0x22,0x20,0x7e,0x56,0x6f,0x69,0x63,0x65,0x4d,0x73,0x67,0x7e, /* e="1" ~VoiceMsg~ */ \
	0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x64,0x69,0x76, /* /></div>....<div */ \
	0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x64, /* >&nbsp;&nbsp;</d */ \
	0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70, /* iv>..<div>..<inp */ \
	0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f, /* ut type="checkbo */ \
	0x78,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x73,0x6d,0x22,0x20,0x6e,0x61, /* x" class="sm" na */ \
	0x6d,0x65,0x3d,0x22,0x64,0x68,0x63,0x70,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d, /* me="dhcp" value= */ \
	0x22,0x31,0x22,0x20,0x6f,0x6e,0x63,0x6c,0x69,0x63,0x6b,0x3d,0x22,0x63,0x6f,0x6e, /* "1" onclick="con */ \
	0x66,0x69,0x67,0x49,0x50,0x42,0x6f,0x78,0x65,0x73,0x28,0x29,0x22,0x20,0x7e,0x63, /* figIPBoxes()" ~c */ \
	0x6f,0x6e,0x66,0x69,0x67,0x5f,0x64,0x68,0x63,0x70,0x63,0x68,0x65,0x63,0x6b,0x65, /* onfig_dhcpchecke */ \
	0x64,0x7e,0x20,0x2f,0x3e,0x20,0x45,0x6e,0x61,0x62,0x6c,0x65,0x20,0x44,0x48,0x43, /* d~ /> Enable DHC */ \
	0x50,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c, /* P</div>..<div><l */ \
	0x61,0x62,0x65,0x6c,0x3e,0x49,0x50,0x20,0x41,0x64,0x64,0x72,0x65,0x73,0x73,0x3a, /* abel>IP Address: */ \
	0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69, /* </label>..<td><i */ \
	0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22, /* nput type="text" */ \
	0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x69,0x70,0x22,0x20,0x76,0x61,0x6c,0x75,0x65, /*  name="ip" value */ \
	0x3d,0x22,0x7e,0x63,0x6f,0x6e,0x66,0x69,0x67,0x5f,0x69,0x70,0x7e,0x22,0x20,0x2f, /* ="~config_ip~" / */ \
	0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c, /* ></div>..<div><l */ \
	0x61,0x62,0x65,0x6c,0x3e,0x47,0x61,0x74,0x65,0x77,0x61,0x79,0x3a,0x3c,0x2f,0x6c, /* abel>Gateway:</l */ \
	0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75, /* abel>..<td><inpu */ \
	0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61, /* t type="text" na */ \
	0x6d,0x65,0x3d,0x22,0x67,0x77,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e, /* me="gw" value="~ */ \
	0x63,0x6f,0x6e,0x66,0x69,0x67,0x5f,0x67,0x77,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f, /* config_gw~" /></ */ \
	0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65, /* div>..<div><labe */ \
	0x6c,0x3e,0x53,0x75,0x62,0x6e,0x65,0x74,0x20,0x4d,0x61,0x73,0x6b,0x3a,0x3c,0x2f, /* l>Subnet Mask:</ */ \
	0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70, /* label>..<td><inp */ \
	0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e, /* ut type="text" n */ \
	0x61,0x6d,0x65,0x3d,0x22,0x73,0x75,0x62,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d, /* ame="sub" value= */ \
	0x22,0x7e,0x63,0x6f,0x6e,0x66,0x69,0x67,0x5f,0x73,0x75,0x62,0x6e,0x65,0x74,0x7e, /* "~config_subnet~ */ \
	0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76, /* " /></div>..<div */ \
	0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x50,0x72,0x69,0x6d,0x61,0x72,0x79,0x20, /* ><label>Primary  */ \
	0x44,0x4e,0x53,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74, /* DNS:</label>..<t */ \
	0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74, /* d><input type="t */ \
	0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x64,0x6e,0x73,0x31,0x22, /* ext" name="dns1" */ \
	0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x63,0x6f,0x6e,0x66,0x69,0x67,0x5f, /*  value="~config_ */ \
	0x64,0x6e,0x73,0x31,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d, /* dns1~" /></div>. */ \
	0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x53,0x65,0x63, /* .<div><label>Sec */ \
	0x6f,0x6e,0x64,0x61,0x72,0x79,0x20,0x44,0x4e,0x53,0x3a,0x3c,0x2f,0x6c,0x61,0x62, /* ondary DNS:</lab */ \
	0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65, /* el>..<input type */ \
	0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x64,0x6e, /* ="text" name="dn */ \
	0x73,0x32,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x63,0x6f,0x6e,0x66, /* s2" value="~conf */ \
	0x69,0x67,0x5f,0x64,0x6e,0x73,0x32,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69, /* ig_dns2~" /></di */ \
	0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20, /* v>..<div><input  */ \
	0x74,0x79,0x70,0x65,0x3d,0x22,0x73,0x75,0x62,0x6d,0x69,0x74,0x22,0x20,0x63,0x6c, /* type="submit" cl */ \
	0x61,0x73,0x73,0x3d,0x22,0x73,0x6d,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22, /* ass="sm" value=" */ \
	0x53,0x61,0x76,0x65,0x20,0x43,0x6f,0x6e,0x66,0x69,0x67,0x22,0x20,0x2f,0x3e,0x3c, /* Save Config" />< */ \
	0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x69,0x65,0x6c,0x64,0x73,0x65, /* /div>..</fieldse */ \
	0x74,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x6f,0x72,0x6d,0x3e,0x0d,0x0a,0x3c,0x2f,0x64, /* t>..</form>..</d */ \
	0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x6c, /* iv>....<script l */ \
	0x61,0x6e,0x67,0x75,0x61,0x67,0x65,0x3d,0x22,0x6a,0x61,0x76,0x61,0x73,0x63,0x72, /* anguage="javascr */ \
	0x69,0x70,0x74,0x22,0x3e,0x0d,0x0a,0x3c,0x21,0x2d,0x2d,0x0d,0x0a,0x66,0x75,0x6e  /* ipt">..<!--..fun */
#define DATACHUNK00001a \
	0x63,0x74,0x69,0x6f,0x6e,0x20,0x63,0x6f,0x6e,0x66,0x69,0x67,0x49,0x50,0x42,0x6f, /* ction configIPBo */ \
	0x78,0x65,0x73,0x28,0x29,0x20,0x7b,0x0d,0x0a,0x09,0x65,0x20,0x3d,0x20,0x64,0x6f, /* xes() {...e = do */ \
	0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x66,0x6f,0x72,0x6d,0x73,0x2e,0x63,0x6f,0x6e, /* cument.forms.con */ \
	0x66,0x69,0x67,0x3b,0x0d,0x0a,0x09,0x73,0x74,0x20,0x3d,0x20,0x65,0x2e,0x64,0x68, /* fig;...st = e.dh */ \
	0x63,0x70,0x2e,0x63,0x68,0x65,0x63,0x6b,0x65,0x64,0x3b,0x0d,0x0a,0x09,0x65,0x2e, /* cp.checked;...e. */ \
	0x69,0x70,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74, /* ip.disabled = st */ \
	0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x67,0x77,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65, /* ;...e.gw.disable */ \
	0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x73,0x75,0x62,0x2e, /* d = st;...e.sub. */ \
	0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a, /* disabled = st;.. */ \
	0x09,0x65,0x2e,0x64,0x6e,0x73,0x31,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64, /* .e.dns1.disabled */ \
	0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x64,0x6e,0x73,0x32,0x2e, /*  = st;...e.dns2. */ \
	0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a, /* disabled = st;.. */ \
	0x7d,0x0d,0x0a,0x0d,0x0a,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x20,0x63,0x6f, /* }....function co */ \
	0x6e,0x66,0x69,0x67,0x49,0x52,0x43,0x28,0x29,0x20,0x7b,0x0d,0x0a,0x09,0x65,0x20, /* nfigIRC() {...e  */ \
	0x3d,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x66,0x6f,0x72,0x6d,0x73, /* = document.forms */ \
	0x2e,0x63,0x6f,0x6e,0x66,0x69,0x67,0x3b,0x0d,0x0a,0x09,0x73,0x74,0x20,0x3d,0x20, /* .config;...st =  */ \
	0x65,0x2e,0x69,0x72,0x63,0x64,0x2e,0x63,0x68,0x65,0x63,0x6b,0x65,0x64,0x3b,0x0d, /* e.ircd.checked;. */ \
	0x0a,0x09,0x65,0x2e,0x52,0x65,0x66,0x6e,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65, /* ..e.Refn.disable */ \
	0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x62,0x61,0x6e,0x64, /* d = st;...e.band */ \
	0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d, /* .disabled = st;. */ \
	0x0a,0x09,0x65,0x2e,0x69,0x72,0x63,0x74,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65, /* ..e.irct.disable */ \
	0x64,0x20,0x3d,0x20,0x21,0x73,0x74,0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x69,0x72,0x63, /* d = !st;...e.irc */ \
	0x72,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x21,0x73,0x74, /* r.disabled = !st */ \
	0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x69,0x72,0x63,0x62,0x2e,0x64,0x69,0x73,0x61,0x62, /* ;...e.ircb.disab */ \
	0x6c,0x65,0x64,0x20,0x3d,0x20,0x21,0x73,0x74,0x3b,0x0d,0x0a,0x7d,0x0d,0x0a,0x0d, /* led = !st;..}... */ \
	0x0a,0x63,0x6f,0x6e,0x66,0x69,0x67,0x49,0x52,0x43,0x28,0x29,0x3b,0x0d,0x0a,0x0d, /* .configIRC();... */ \
	0x0a,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x66,0x6f,0x72,0x6d,0x73,0x2e, /* .document.forms. */ \
	0x63,0x6f,0x6e,0x66,0x69,0x67,0x2e,0x6d,0x61,0x63,0x2e,0x64,0x69,0x73,0x61,0x62, /* config.mac.disab */ \
	0x6c,0x65,0x64,0x20,0x3d,0x20,0x74,0x72,0x75,0x65,0x3b,0x0d,0x0a,0x64,0x6f,0x63, /* led = true;..doc */ \
	0x75,0x6d,0x65,0x6e,0x74,0x2e,0x66,0x6f,0x72,0x6d,0x73,0x2e,0x63,0x6f,0x6e,0x66, /* ument.forms.conf */ \
	0x69,0x67,0x2e,0x68,0x6f,0x73,0x74,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64, /* ig.host.disabled */ \
	0x20,0x3d,0x20,0x74,0x72,0x75,0x65,0x3b,0x0d,0x0a,0x64,0x6f,0x63,0x75,0x6d,0x65, /*  = true;..docume */ \
	0x6e,0x74,0x2e,0x66,0x6f,0x72,0x6d,0x73,0x2e,0x63,0x6f,0x6e,0x66,0x69,0x67,0x2e, /* nt.forms.config. */ \
	0x64,0x70,0x72,0x74,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20, /* dprt.disabled =  */ \
	0x74,0x72,0x75,0x65,0x3b,0x0d,0x0a,0x0d,0x0a,0x2f,0x2f,0x2d,0x2d,0x3e,0x0d,0x0a, /* true;....//-->.. */ \
	0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74,0x3e,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a, /* </script>..~inc: */ \
	0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x00,0x00,0x00,0x00,0x33, /* footer.inc~....3 */ \
	0x00,0x00,0x00,0xde,0x00,0x00,0x00,0x25,0x00,0x00,0x00,0x53,0x01,0x00,0x00,0xd0, /* .......%...S.... */ \
	0x00,0x00,0x00,0x98,0x01,0x00,0x00,0xd2,0x00,0x00,0x00,0x3e,0x02,0x00,0x00,0xd3, /* ...........>.... */ \
	0x00,0x00,0x00,0x9f,0x02,0x00,0x00,0xd4,0x00,0x00,0x00,0xea,0x02,0x00,0x00,0xc2, /* ................ */ \
	0x00,0x00,0x00,0xfc,0x02,0x00,0x00,0x8d,0x00,0x00,0x00,0x47,0x03,0x00,0x00,0x99, /* ...........G.... */ \
	0x00,0x00,0x00,0xb7,0x03,0x00,0x00,0x4a,0x00,0x00,0x00,0x29,0x04,0x00,0x00,0xa2, /* .......J...).... */ \
	0x00,0x00,0x00,0x9b,0x04,0x00,0x00,0x9a,0x00,0x00,0x00,0x0f,0x05,0x00,0x00,0xa0, /* ................ */ \
	0x00,0x00,0x00,0x73,0x05,0x00,0x00,0x6e,0x00,0x00,0x00,0x04,0x08,0x00,0x00,0x61, /* ...s...n.......a */ \
	0x00,0x00,0x00,0x5f,0x08,0x00,0x00,0x6d,0x00,0x00,0x00,0x07,0x09,0x00,0x00,0xa1, /* ..._...m........ */ \
	0x00,0x00,0x00,0x85,0x09,0x00,0x00,0xa7,0x00,0x00,0x00,0x0d,0x0a,0x00,0x00,0x27, /* ...............' */ \
	0x00,0x00,0x00,0x81,0x0a,0x00,0x00,0x28,0x00,0x00,0x00,0xde,0x0a,0x00,0x00,0x29, /* .......(.......) */ \
	0x00,0x00,0x00,0x40,0x0b,0x00,0x00,0x2a,0x00,0x00,0x00,0xa7,0x0b,0x00,0x00,0x2b, /* ...@...........+ */ \
	0x00,0x00,0x00,0x0a,0x0c,0x00,0x00,0x2c,0x00,0x00,0x00,0xea,0x0e,0x00,0x00,0x02, /* .......,........ */ \
	0x00,0x00,0x00,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69, /* ...~inc:header.i */ \
	0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f, /* nc~..<div id="co */ \
	0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x44, /* ntent">....<h1>D */ \
	0x65,0x62,0x75,0x67,0x20,0x4d,0x6f,0x64,0x65,0x3c,0x2f,0x68,0x31,0x3e,0x0d,0x0a, /* ebug Mode</h1>.. */ \
	0x0d,0x0a,0x3c,0x66,0x6f,0x72,0x6d,0x20,0x6d,0x65,0x74,0x68,0x6f,0x64,0x3d,0x22, /* ..<form method=" */ \
	0x70,0x6f,0x73,0x74,0x22,0x20,0x61,0x63,0x74,0x69,0x6f,0x6e,0x3d,0x22,0x2f,0x70, /* post" action="/p */ \
	0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x64,0x65,0x62,0x75,0x67,0x2e,0x68,0x74,0x6d, /* rotect/debug.htm */ \
	0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x64,0x65,0x62,0x67,0x22,0x3e,0x0d,0x0a, /* " name="debg">.. */ \
	0x3c,0x66,0x69,0x65,0x6c,0x64,0x73,0x65,0x74,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76, /* <fieldset>..<div */ \
	0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x44,0x65,0x62,0x75,0x67,0x20,0x53,0x77, /* ><label>Debug Sw */ \
	0x69,0x74,0x63,0x68,0x20,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x20,0x3c, /* itch :</label> < */ \
	0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63, /* input type="chec */ \
	0x6b,0x62,0x6f,0x78,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x33, /* kbox" class="ad3 */ \
	0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x64,0x62,0x67,0x73,0x22,0x20,0x76,0x61, /* " name="dbgs" va */ \
	0x6c,0x75,0x65,0x3d,0x22,0x31,0x22,0x20,0x20,0x7e,0x44,0x65,0x62,0x75,0x67,0x53  /* lue="1"  ~DebugS */
#define DATACHUNK00001b \
	0x77,0x69,0x74,0x63,0x68,0x7e,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d, /* witch~ /></div>. */ \
	0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70, /* .<div><input typ */ \
	0x65,0x3d,0x22,0x73,0x75,0x62,0x6d,0x69,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d, /* e="submit" name= */ \
	0x22,0x73,0x65,0x6e,0x64,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x53,0x65, /* "send" value="Se */ \
	0x74,0x22,0x20,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x73,0x6d,0x22,0x20,0x2f, /* t"  class="sm" / */ \
	0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x69,0x65,0x6c,0x64, /* ></div>..</field */ \
	0x73,0x65,0x74,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x2f,0x66,0x6f,0x72,0x6d,0x3e,0x0d, /* set>....</form>. */ \
	0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69, /* .</div>....<scri */ \
	0x70,0x74,0x20,0x6c,0x61,0x6e,0x67,0x75,0x61,0x67,0x65,0x3d,0x22,0x6a,0x61,0x76, /* pt language="jav */ \
	0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x2f,0x2f,0x2d, /* ascript">....//- */ \
	0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74,0x3e,0x0d,0x0a,0x7e, /* ->..</script>..~ */ \
	0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x00, /* inc:footer.inc~. */ \
	0x00,0x00,0x00,0x33,0x00,0x00,0x00,0xe6,0x00,0x00,0x00,0xc9,0x00,0x00,0x00,0x9c, /* ...3............ */ \
	0x01,0x00,0x00,0x02,0x00,0x00,0x00,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64, /* .......~inc:head */ \
	0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64, /* er.inc~..<div id */ \
	0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c, /* ="content">....< */ \
	0x68,0x31,0x3e,0x44,0x50,0x52,0x53,0x20,0x43,0x6f,0x6e,0x66,0x69,0x67,0x75,0x72, /* h1>DPRS Configur */ \
	0x61,0x74,0x69,0x6f,0x6e,0x3c,0x2f,0x68,0x31,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x66, /* ation</h1>....<f */ \
	0x6f,0x72,0x6d,0x20,0x6d,0x65,0x74,0x68,0x6f,0x64,0x3d,0x22,0x70,0x6f,0x73,0x74, /* orm method="post */ \
	0x22,0x20,0x61,0x63,0x74,0x69,0x6f,0x6e,0x3d,0x22,0x2f,0x70,0x72,0x6f,0x74,0x65, /* " action="/prote */ \
	0x63,0x74,0x2f,0x64,0x70,0x72,0x73,0x2e,0x68,0x74,0x6d,0x22,0x20,0x6e,0x61,0x6d, /* ct/dprs.htm" nam */ \
	0x65,0x3d,0x22,0x64,0x70,0x72,0x73,0x22,0x3e,0x0d,0x0a,0x3c,0x66,0x69,0x65,0x6c, /* e="dprs">..<fiel */ \
	0x64,0x73,0x65,0x74,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x69,0x6e,0x70, /* dset>..<div><inp */ \
	0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f, /* ut type="checkbo */ \
	0x78,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x73,0x6d,0x22,0x20,0x6e,0x61, /* x" class="sm" na */ \
	0x6d,0x65,0x3d,0x22,0x64,0x70,0x73,0x77,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d, /* me="dpsw" value= */ \
	0x22,0x31,0x22,0x20,0x6f,0x6e,0x63,0x6c,0x69,0x63,0x6b,0x3d,0x22,0x63,0x6f,0x6e, /* "1" onclick="con */ \
	0x66,0x69,0x67,0x44,0x50,0x52,0x53,0x42,0x6f,0x78,0x65,0x73,0x28,0x29,0x22,0x20, /* figDPRSBoxes()"  */ \
	0x7e,0x44,0x50,0x52,0x53,0x5f,0x63,0x68,0x65,0x63,0x6b,0x65,0x64,0x7e,0x20,0x2f, /* ~DPRS_checked~ / */ \
	0x3e,0x20,0x45,0x6e,0x61,0x62,0x6c,0x65,0x20,0x44,0x50,0x52,0x53,0x3c,0x2f,0x64, /* > Enable DPRS</d */ \
	0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c, /* iv>..<div><label */ \
	0x3e,0x44,0x50,0x52,0x53,0x20,0x53,0x65,0x72,0x76,0x65,0x72,0x20,0x49,0x50,0x20, /* >DPRS Server IP  */ \
	0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75, /* :</label>..<inpu */ \
	0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61, /* t type="text" na */ \
	0x6d,0x65,0x3d,0x22,0x64,0x70,0x69,0x70,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d, /* me="dpip" value= */ \
	0x22,0x7e,0x64,0x70,0x72,0x73,0x69,0x70,0x7e,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d, /* "~dprsip~" size= */ \
	0x22,0x32,0x30,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22, /* "20" class="ad1" */ \
	0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c, /* ></div>..<div><l */ \
	0x61,0x62,0x65,0x6c,0x3e,0x44,0x50,0x52,0x53,0x20,0x53,0x65,0x72,0x76,0x65,0x72, /* abel>DPRS Server */ \
	0x20,0x50,0x6f,0x72,0x74,0x20,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d, /*  Port :</label>. */ \
	0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65, /* .<input type="te */ \
	0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x64,0x70,0x70,0x74,0x22,0x20, /* xt" name="dppt"  */ \
	0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x64,0x70,0x72,0x73,0x70,0x6f,0x72,0x74, /* value="~dprsport */ \
	0x7e,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x35,0x22,0x20,0x63,0x6c,0x61,0x73, /* ~" size="5" clas */ \
	0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a, /* s="ad1"></div>.. */ \
	0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x59,0x6f,0x75,0x72, /* <div><label>Your */ \
	0x20,0x43,0x61,0x6c,0x6c,0x73,0x69,0x67,0x6e,0x20,0x3a,0x3c,0x2f,0x6c,0x61,0x62, /*  Callsign :</lab */ \
	0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65, /* el>..<input type */ \
	0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x64,0x70, /* ="text" name="dp */ \
	0x63,0x6c,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x64,0x70,0x72,0x73, /* cl" value="~dprs */ \
	0x63,0x61,0x6c,0x6c,0x7e,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x37,0x22,0x20, /* call~" size="7"  */ \
	0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x3e,0x3c,0x2f,0x64,0x69, /* class="ad1"></di */ \
	0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e, /* v>..<div><label> */ \
	0x44,0x2d,0x53,0x54,0x41,0x52,0x20,0x49,0x44,0x20,0x3a,0x3c,0x2f,0x6c,0x61,0x62, /* D-STAR ID :</lab */ \
	0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65, /* el>..<input type */ \
	0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x64,0x73, /* ="text" name="ds */ \
	0x69,0x64,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x64,0x73,0x74,0x61, /* id" value="~dsta */ \
	0x72,0x69,0x64,0x7e,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x31,0x22,0x20,0x63, /* rid~" size="1" c */ \
	0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x3e,0x3c,0x2f,0x64,0x69,0x76, /* lass="ad1"></div */ \
	0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x41, /* >..<div><label>A */ \
	0x6c,0x74,0x2e,0x20,0x4d,0x73,0x67,0x2e,0x20,0x53,0x53,0x49,0x44,0x20,0x3a,0x3c, /* lt. Msg. SSID :< */ \
	0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20, /* /label>..<input  */ \
	0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65, /* type="text" name */ \
	0x3d,0x22,0x61,0x6c,0x69,0x64,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e  /* ="alid" value="~ */
#define DATACHUNK00001c \
	0x61,0x6c,0x74,0x64,0x73,0x74,0x61,0x72,0x69,0x64,0x7e,0x22,0x20,0x73,0x69,0x7a, /* altdstarid~" siz */ \
	0x65,0x3d,0x22,0x32,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31, /* e="2" class="ad1 */ \
	0x22,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c, /* "></div>..<div>< */ \
	0x6c,0x61,0x62,0x65,0x6c,0x3e,0x56,0x61,0x6c,0x69,0x64,0x61,0x74,0x69,0x6f,0x6e, /* label>Validation */ \
	0x20,0x43,0x6f,0x64,0x65,0x20,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d, /*  Code :</label>. */ \
	0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65, /* .<input type="te */ \
	0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x64,0x70,0x63,0x64,0x22,0x20, /* xt" name="dpcd"  */ \
	0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x64,0x70,0x72,0x73,0x76,0x61,0x6c,0x69, /* value="~dprsvali */ \
	0x64,0x7e,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x37,0x22,0x20,0x63,0x6c,0x61, /* d~" size="7" cla */ \
	0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d, /* ss="ad1"></div>. */ \
	0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x41,0x63,0x63, /* .<div><label>Acc */ \
	0x65,0x70,0x74,0x20,0x66,0x72,0x6f,0x6d,0x20,0x52,0x61,0x64,0x69,0x6f,0x20,0x3a, /* ept from Radio : */ \
	0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74, /* </label><input t */ \
	0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e, /* ype="checkbox" n */ \
	0x61,0x6d,0x65,0x3d,0x22,0x64,0x70,0x72,0x64,0x22,0x20,0x63,0x6c,0x61,0x73,0x73, /* ame="dprd" class */ \
	0x3d,0x22,0x73,0x6d,0x22,0x20,0x7e,0x64,0x70,0x72,0x73,0x52,0x61,0x64,0x69,0x6f, /* ="sm" ~dprsRadio */ \
	0x7e,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x31,0x22,0x20,0x2f,0x3e,0x3c,0x2f, /* ~ value="1" /></ */ \
	0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65, /* div>..<div><labe */ \
	0x6c,0x3e,0x41,0x63,0x63,0x65,0x70,0x74,0x20,0x66,0x72,0x6f,0x6d,0x20,0x49,0x6e, /* l>Accept from In */ \
	0x65,0x74,0x20,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x3c,0x69,0x6e,0x70, /* et :</label><inp */ \
	0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f, /* ut type="checkbo */ \
	0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x64,0x70,0x69,0x74,0x22,0x20,0x63, /* x" name="dpit" c */ \
	0x6c,0x61,0x73,0x73,0x3d,0x22,0x73,0x6d,0x22,0x20,0x7e,0x64,0x70,0x72,0x73,0x49, /* lass="sm" ~dprsI */ \
	0x6e,0x65,0x74,0x7e,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x31,0x22,0x20,0x2f, /* net~ value="1" / */ \
	0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c, /* ></div>..<div><l */ \
	0x61,0x62,0x65,0x6c,0x3e,0x41,0x75,0x74,0x6f,0x2e,0x20,0x4c,0x69,0x6e,0x6b,0x20, /* abel>Auto. Link  */ \
	0x20,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74, /*  :</label><input */ \
	0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22, /*  type="checkbox" */ \
	0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x64,0x70,0x61,0x74,0x22,0x20,0x63,0x6c,0x61, /*  name="dpat" cla */ \
	0x73,0x73,0x3d,0x22,0x73,0x6d,0x22,0x20,0x7e,0x64,0x70,0x72,0x73,0x41,0x75,0x74, /* ss="sm" ~dprsAut */ \
	0x6f,0x4c,0x69,0x6e,0x6b,0x7e,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x31,0x22, /* oLink~ value="1" */ \
	0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e, /*  /></div>..<div> */ \
	0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x41,0x75,0x74,0x6f,0x2e,0x20,0x52,0x65,0x4c, /* <label>Auto. ReL */ \
	0x69,0x6e,0x6b,0x20,0x20,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x3c,0x69, /* ink  :</label><i */ \
	0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b, /* nput type="check */ \
	0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x64,0x70,0x72,0x65,0x22, /* box" name="dpre" */ \
	0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x73,0x6d,0x22,0x20,0x7e,0x64,0x70,0x72, /*  class="sm" ~dpr */ \
	0x73,0x41,0x75,0x74,0x6f,0x52,0x65,0x4c,0x69,0x6e,0x6b,0x7e,0x20,0x76,0x61,0x6c, /* sAutoReLink~ val */ \
	0x75,0x65,0x3d,0x22,0x31,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d, /* ue="1" /></div>. */ \
	0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x43,0x6c,0x69, /* .<div><label>Cli */ \
	0x65,0x6e,0x74,0x20,0x49,0x6e,0x66,0x6f,0x72,0x6d,0x61,0x74,0x69,0x6f,0x6e,0x3c, /* ent Information< */ \
	0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x3c,0x62,0x72, /* /label></div><br */ \
	0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74, /* >..<div><input t */ \
	0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e, /* ype="checkbox" n */ \
	0x61,0x6d,0x65,0x3d,0x22,0x63,0x6c,0x69,0x64,0x22,0x20,0x63,0x6c,0x61,0x73,0x73, /* ame="clid" class */ \
	0x3d,0x22,0x73,0x6d,0x22,0x20,0x7e,0x63,0x6c,0x69,0x65,0x6e,0x74,0x49,0x44,0x7e, /* ="sm" ~clientID~ */ \
	0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x31,0x22,0x20,0x2f,0x3e,0x20,0x4c,0x65, /*  value="1" /> Le */ \
	0x74,0x20,0x43,0x6c,0x69,0x65,0x6e,0x74,0x20,0x49,0x44,0x3c,0x2f,0x64,0x69,0x76, /* t Client ID</div */ \
	0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x4c, /* >..<div><label>L */ \
	0x61,0x74,0x69,0x74,0x75,0x64,0x65,0x20,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c, /* atitude :</label */ \
	0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22, /* >..<input type=" */ \
	0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x70,0x6c,0x61,0x74, /* text" name="plat */ \
	0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x70,0x6c,0x61,0x74,0x7e,0x22, /* " value="~plat~" */ \
	0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x38,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d, /*  size="8" class= */ \
	0x22,0x61,0x64,0x31,0x22,0x3e,0x20,0x28,0x64,0x64,0x2e,0x64,0x64,0x64,0x64,0x20, /* "ad1"> (dd.dddd  */ \
	0x53,0x20,0x6e,0x65,0x67,0x61,0x74,0x69,0x76,0x65,0x29,0x3c,0x2f,0x64,0x69,0x76, /* S negative)</div */ \
	0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x4c, /* >..<div><label>L */ \
	0x6f,0x6e,0x67,0x69,0x74,0x75,0x64,0x65,0x20,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65, /* ongitude :</labe */ \
	0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d, /* l>..<input type= */ \
	0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x70,0x6c,0x6e, /* "text" name="pln */ \
	0x67,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x70,0x6c,0x6f,0x6e,0x67, /* g" value="~plong */ \
	0x7e,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x39,0x22,0x20,0x63,0x6c,0x61,0x73, /* ~" size="9" clas */ \
	0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x3e,0x20,0x28,0x64,0x64,0x64,0x2e,0x64,0x64, /* s="ad1"> (ddd.dd */ \
	0x64,0x64,0x20,0x57,0x20,0x4e,0x65,0x67,0x61,0x74,0x69,0x76,0x65,0x29,0x3c,0x2f  /* dd W Negative)</ */
#define DATACHUNK00001d \
	0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65, /* div>..<div><labe */ \
	0x6c,0x3e,0x43,0x6f,0x6d,0x6d,0x65,0x6e,0x74,0x20,0x3a,0x3c,0x2f,0x6c,0x61,0x62, /* l>Comment :</lab */ \
	0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65, /* el>..<input type */ \
	0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x70,0x63, /* ="text" name="pc */ \
	0x6d,0x74,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x70,0x63,0x6f,0x6d, /* mt" value="~pcom */ \
	0x6d,0x65,0x6e,0x74,0x7e,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x32,0x35,0x22, /* ment~" size="25" */ \
	0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x3e,0x3c,0x2f,0x64, /*  class="ad1"></d */ \
	0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c, /* iv>..<div><label */ \
	0x3e,0x49,0x6e,0x74,0x65,0x72,0x76,0x61,0x6c,0x20,0x3a,0x3c,0x2f,0x6c,0x61,0x62, /* >Interval :</lab */ \
	0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65, /* el>..<input type */ \
	0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x70,0x69, /* ="text" name="pi */ \
	0x6e,0x74,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x70,0x69,0x6e,0x74, /* nt" value="~pint */ \
	0x65,0x72,0x76,0x61,0x6c,0x7e,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x34,0x22, /* erval~" size="4" */ \
	0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x3e,0x20,0x6d,0x69, /*  class="ad1"> mi */ \
	0x6e,0x75,0x74,0x65,0x73,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x0d, /* nutes</div>..... */ \
	0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x53,0x4d,0x54, /* .<div><label>SMT */ \
	0x50,0x20,0x49,0x6e,0x66,0x6f,0x72,0x6d,0x61,0x74,0x69,0x6f,0x6e,0x3c,0x2f,0x6c, /* P Information</l */ \
	0x61,0x62,0x65,0x6c,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x3c,0x62,0x72,0x3e,0x0d, /* abel></div><br>. */ \
	0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x53,0x4d,0x54, /* .<div><label>SMT */ \
	0x50,0x20,0x53,0x65,0x72,0x76,0x65,0x72,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c, /* P Server:</label */ \
	0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22, /* >..<input type=" */ \
	0x74,0x65,0x78,0x74,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x73,0x6d, /* text" value="~sm */ \
	0x74,0x70,0x73,0x65,0x72,0x76,0x65,0x72,0x7e,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d, /* tpserver~" name= */ \
	0x22,0x73,0x6d,0x74,0x73,0x22,0x20,0x73,0x74,0x79,0x6c,0x65,0x3d,0x22,0x77,0x69, /* "smts" style="wi */ \
	0x64,0x74,0x68,0x3a,0x31,0x36,0x35,0x70,0x78,0x22,0x2f,0x3e,0x3c,0x2f,0x64,0x69, /* dth:165px"/></di */ \
	0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e, /* v>..<div><label> */ \
	0x50,0x6f,0x72,0x74,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c, /* Port:</label>..< */ \
	0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74, /* input type="text */ \
	0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x73,0x6d,0x74,0x70,0x22,0x20,0x76,0x61, /* " name="smtp" va */ \
	0x6c,0x75,0x65,0x3d,0x22,0x7e,0x73,0x6d,0x74,0x70,0x70,0x6f,0x72,0x74,0x7e,0x22, /* lue="~smtpport~" */ \
	0x20,0x73,0x74,0x79,0x6c,0x65,0x3d,0x22,0x77,0x69,0x64,0x74,0x68,0x3a,0x32,0x35, /*  style="width:25 */ \
	0x70,0x78,0x3b,0x22,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a, /* px;"/></div>.... */ \
	0x3c,0x64,0x69,0x76,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65, /* <div><input type */ \
	0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x63,0x6c,0x61,0x73, /* ="checkbox" clas */ \
	0x73,0x3d,0x22,0x73,0x6d,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x73,0x6d,0x61, /* s="sm" name="sma */ \
	0x68,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x31,0x22,0x20,0x6f,0x6e,0x63, /* h" value="1" onc */ \
	0x6c,0x69,0x63,0x6b,0x3d,0x22,0x73,0x6d,0x74,0x70,0x41,0x75,0x74,0x68,0x28,0x29, /* lick="smtpAuth() */ \
	0x22,0x20,0x7e,0x73,0x6d,0x74,0x70,0x5f,0x61,0x75,0x74,0x68,0x7e,0x20,0x2f,0x3e, /* " ~smtp_auth~ /> */ \
	0x20,0x45,0x6e,0x61,0x62,0x6c,0x65,0x20,0x41,0x75,0x74,0x68,0x2e,0x20,0x66,0x6f, /*  Enable Auth. fo */ \
	0x72,0x20,0x53,0x4d,0x54,0x50,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64, /* r SMTP</div>..<d */ \
	0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x55,0x73,0x65,0x72,0x3a,0x3c, /* iv><label>User:< */ \
	0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20, /* /label>..<input  */ \
	0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65, /* type="text" name */ \
	0x3d,0x22,0x73,0x6d,0x75,0x73,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e, /* ="smus" value="~ */ \
	0x73,0x6d,0x74,0x70,0x75,0x73,0x65,0x72,0x7e,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d, /* smtpuser~" size= */ \
	0x22,0x32,0x30,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22, /* "20" class="ad1" */ \
	0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e, /*  /></div>..<div> */ \
	0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x50,0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x3a, /* <label>Password: */ \
	0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74, /* </label>..<input */ \
	0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x70,0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x22, /*  type="password" */ \
	0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x73,0x6d,0x70,0x73,0x22,0x20,0x76,0x61,0x6c, /*  name="smps" val */ \
	0x75,0x65,0x3d,0x22,0x7e,0x73,0x6d,0x74,0x70,0x70,0x61,0x73,0x73,0x7e,0x22,0x20, /* ue="~smtppass~"  */ \
	0x73,0x69,0x7a,0x65,0x3d,0x22,0x32,0x30,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d, /* size="20" class= */ \
	0x22,0x61,0x64,0x31,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a, /* "ad1" /></div>.. */ \
	0x3c,0x64,0x69,0x76,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x64,0x69,0x76, /* <div>&nbsp;</div */ \
	0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74, /* >....<div><input */ \
	0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x73,0x75,0x62,0x6d,0x69,0x74,0x22,0x20,0x6e, /*  type="submit" n */ \
	0x61,0x6d,0x65,0x20,0x3d,0x22,0x73,0x75,0x62,0x22,0x20,0x63,0x6c,0x61,0x73,0x73, /* ame ="sub" class */ \
	0x3d,0x22,0x73,0x6d,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x53,0x61,0x76, /* ="sm" value="Sav */ \
	0x65,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x2f,0x66, /* e" /></div>..</f */ \
	0x69,0x65,0x6c,0x64,0x73,0x65,0x74,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x2f,0x66,0x6f, /* ieldset>....</fo */ \
	0x72,0x6d,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c, /* rm>..</div>....< */ \
	0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x6c,0x61,0x6e,0x67,0x75,0x61,0x67,0x65,0x3d, /* script language= */ \
	0x22,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x0d,0x0a,0x66  /* "javascript">..f */
#define DATACHUNK00001e \
	0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x20,0x63,0x6f,0x6e,0x66,0x69,0x67,0x44,0x50, /* unction configDP */ \
	0x52,0x53,0x42,0x6f,0x78,0x65,0x73,0x28,0x29,0x20,0x7b,0x0d,0x0a,0x09,0x65,0x20, /* RSBoxes() {...e  */ \
	0x3d,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x66,0x6f,0x72,0x6d,0x73, /* = document.forms */ \
	0x2e,0x64,0x70,0x72,0x73,0x3b,0x0d,0x0a,0x09,0x69,0x66,0x20,0x28,0x21,0x64,0x6f, /* .dprs;...if (!do */ \
	0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x66,0x6f,0x72,0x6d,0x73,0x2e,0x64,0x70,0x72, /* cument.forms.dpr */ \
	0x73,0x2e,0x64,0x70,0x73,0x77,0x2e,0x63,0x68,0x65,0x63,0x6b,0x65,0x64,0x29,0x0d, /* s.dpsw.checked). */ \
	0x0a,0x09,0x7b,0x0d,0x0a,0x09,0x20,0x20,0x65,0x2e,0x64,0x70,0x69,0x70,0x2e,0x64, /* ..{...  e.dpip.d */ \
	0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x74,0x72,0x75,0x65,0x3b,0x0d, /* isabled = true;. */ \
	0x0a,0x09,0x20,0x20,0x65,0x2e,0x64,0x70,0x70,0x74,0x2e,0x64,0x69,0x73,0x61,0x62, /* ..  e.dppt.disab */ \
	0x6c,0x65,0x64,0x20,0x3d,0x20,0x74,0x72,0x75,0x65,0x3b,0x0d,0x0a,0x09,0x20,0x20, /* led = true;...   */ \
	0x65,0x2e,0x64,0x70,0x63,0x6c,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20, /* e.dpcl.disabled  */ \
	0x3d,0x20,0x74,0x72,0x75,0x65,0x3b,0x0d,0x0a,0x09,0x20,0x20,0x65,0x2e,0x64,0x73, /* = true;...  e.ds */ \
	0x69,0x64,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x74,0x72, /* id.disabled = tr */ \
	0x75,0x65,0x3b,0x0d,0x0a,0x09,0x20,0x20,0x65,0x2e,0x64,0x70,0x63,0x64,0x2e,0x64, /* ue;...  e.dpcd.d */ \
	0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x74,0x72,0x75,0x65,0x3b,0x0d, /* isabled = true;. */ \
	0x0a,0x09,0x7d,0x0d,0x0a,0x09,0x65,0x6c,0x73,0x65,0x0d,0x0a,0x09,0x7b,0x0d,0x0a, /* ..}...else...{.. */ \
	0x09,0x20,0x20,0x65,0x2e,0x64,0x70,0x69,0x70,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c, /* .  e.dpip.disabl */ \
	0x65,0x64,0x20,0x3d,0x20,0x66,0x61,0x6c,0x73,0x65,0x3b,0x0d,0x0a,0x09,0x20,0x20, /* ed = false;...   */ \
	0x65,0x2e,0x64,0x70,0x70,0x74,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20, /* e.dppt.disabled  */ \
	0x3d,0x20,0x66,0x61,0x6c,0x73,0x65,0x3b,0x0d,0x0a,0x09,0x20,0x20,0x65,0x2e,0x64, /* = false;...  e.d */ \
	0x70,0x63,0x6c,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x66, /* pcl.disabled = f */ \
	0x61,0x6c,0x73,0x65,0x3b,0x0d,0x0a,0x09,0x20,0x20,0x65,0x2e,0x64,0x73,0x69,0x64, /* alse;...  e.dsid */ \
	0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x66,0x61,0x6c,0x73, /* .disabled = fals */ \
	0x65,0x3b,0x0d,0x0a,0x09,0x20,0x20,0x65,0x2e,0x64,0x70,0x63,0x64,0x2e,0x64,0x69, /* e;...  e.dpcd.di */ \
	0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x66,0x61,0x6c,0x73,0x65,0x3b,0x0d, /* sabled = false;. */ \
	0x0a,0x09,0x7d,0x0d,0x0a,0x7d,0x0d,0x0a,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e, /* ..}..}..function */ \
	0x20,0x73,0x6d,0x74,0x70,0x41,0x75,0x74,0x68,0x28,0x29,0x20,0x7b,0x0d,0x0a,0x09, /*  smtpAuth() {... */ \
	0x65,0x20,0x3d,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x66,0x6f,0x72, /* e = document.for */ \
	0x6d,0x73,0x2e,0x64,0x70,0x72,0x73,0x3b,0x0d,0x0a,0x09,0x69,0x66,0x20,0x28,0x21, /* ms.dprs;...if (! */ \
	0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x66,0x6f,0x72,0x6d,0x73,0x2e,0x64, /* document.forms.d */ \
	0x70,0x72,0x73,0x2e,0x73,0x6d,0x61,0x68,0x2e,0x63,0x68,0x65,0x63,0x6b,0x65,0x64, /* prs.smah.checked */ \
	0x29,0x0d,0x0a,0x09,0x7b,0x0d,0x0a,0x09,0x20,0x20,0x65,0x2e,0x73,0x6d,0x75,0x73, /* )...{...  e.smus */ \
	0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x74,0x72,0x75,0x65, /* .disabled = true */ \
	0x3b,0x0d,0x0a,0x09,0x20,0x20,0x65,0x2e,0x73,0x6d,0x70,0x73,0x2e,0x64,0x69,0x73, /* ;...  e.smps.dis */ \
	0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x74,0x72,0x75,0x65,0x3b,0x0d,0x0a,0x09, /* abled = true;... */ \
	0x7d,0x0d,0x0a,0x09,0x65,0x6c,0x73,0x65,0x0d,0x0a,0x09,0x7b,0x0d,0x0a,0x09,0x20, /* }...else...{...  */ \
	0x20,0x65,0x2e,0x73,0x6d,0x75,0x73,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64, /*  e.smus.disabled */ \
	0x20,0x3d,0x20,0x66,0x61,0x6c,0x73,0x65,0x3b,0x0d,0x0a,0x09,0x20,0x20,0x65,0x2e, /*  = false;...  e. */ \
	0x73,0x6d,0x70,0x73,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20, /* smps.disabled =  */ \
	0x66,0x61,0x6c,0x73,0x65,0x3b,0x0d,0x0a,0x09,0x7d,0x0d,0x0a,0x7d,0x0d,0x0a,0x0d, /* false;...}..}... */ \
	0x0a,0x63,0x6f,0x6e,0x66,0x69,0x67,0x44,0x50,0x52,0x53,0x42,0x6f,0x78,0x65,0x73, /* .configDPRSBoxes */ \
	0x28,0x29,0x3b,0x0d,0x0a,0x73,0x6d,0x74,0x70,0x41,0x75,0x74,0x68,0x28,0x29,0x3b, /* ();..smtpAuth(); */ \
	0x0d,0x0a,0x2f,0x2f,0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70, /* ..//-->..</scrip */ \
	0x74,0x3e,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e, /* t>..~inc:footer. */ \
	0x69,0x6e,0x63,0x7e,0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0xe9,0x00,0x00,0x00, /* inc~....3....... */ \
	0xb1,0x00,0x00,0x00,0x5a,0x01,0x00,0x00,0xac,0x00,0x00,0x00,0xd0,0x01,0x00,0x00, /* ....Z........... */ \
	0xad,0x00,0x00,0x00,0x44,0x02,0x00,0x00,0xae,0x00,0x00,0x00,0xb4,0x02,0x00,0x00, /* ....D........... */ \
	0xaf,0x00,0x00,0x00,0x28,0x03,0x00,0x00,0xca,0x00,0x00,0x00,0xa0,0x03,0x00,0x00, /* ....(........... */ \
	0xb0,0x00,0x00,0x00,0x1f,0x04,0x00,0x00,0xb2,0x00,0x00,0x00,0x93,0x04,0x00,0x00, /* ................ */ \
	0xb3,0x00,0x00,0x00,0x01,0x05,0x00,0x00,0xba,0x00,0x00,0x00,0x75,0x05,0x00,0x00, /* ............u... */ \
	0xcf,0x00,0x00,0x00,0xff,0x05,0x00,0x00,0xbb,0x00,0x00,0x00,0x72,0x06,0x00,0x00, /* ............r... */ \
	0xb5,0x00,0x00,0x00,0xf3,0x06,0x00,0x00,0xb6,0x00,0x00,0x00,0x74,0x07,0x00,0x00, /* ............t... */ \
	0xb7,0x00,0x00,0x00,0xe4,0x07,0x00,0x00,0xc5,0x00,0x00,0x00,0x86,0x08,0x00,0x00, /* ................ */ \
	0xbc,0x00,0x00,0x00,0xfe,0x08,0x00,0x00,0xbd,0x00,0x00,0x00,0x7b,0x09,0x00,0x00, /* ............{... */ \
	0xbe,0x00,0x00,0x00,0xe8,0x09,0x00,0x00,0xbf,0x00,0x00,0x00,0x5d,0x0a,0x00,0x00, /* ............]... */ \
	0xc0,0x00,0x00,0x00,0xdd,0x0d,0x00,0x00,0x02,0x00,0x00,0x00,0x7e,0x69,0x6e,0x63, /* ............~inc */ \
	0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64, /* :header.inc~..<d */ \
	0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e, /* iv id="content"> */ \
	0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x45,0x64,0x69,0x74,0x20,0x74,0x68,0x65,0x20,0x41, /* ..<h1>Edit the A */ \
	0x50,0x52,0x53,0x20,0x4d,0x73,0x67,0x2e,0x20,0x43,0x6f,0x6e,0x74,0x72,0x6f,0x6c, /* PRS Msg. Control */ \
	0x20,0x46,0x69,0x6c,0x65,0x3c,0x2f,0x68,0x31,0x3e,0x0d,0x0a,0x3c,0x66,0x6f,0x72, /*  File</h1>..<for */ \
	0x6d,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x44,0x70,0x72,0x73,0x45,0x64,0x69,0x74, /* m name="DprsEdit */ \
	0x22,0x20,0x6d,0x65,0x74,0x68,0x6f,0x64,0x3d,0x22,0x70,0x6f,0x73,0x74,0x22,0x20, /* " method="post"  */ \
	0x61,0x63,0x74,0x69,0x6f,0x6e,0x3d,0x22,0x2f,0x70,0x72,0x6f,0x74,0x65,0x63,0x74  /* action="/protect */
#define DATACHUNK00001f \
	0x2f,0x64,0x70,0x72,0x73,0x65,0x64,0x69,0x74,0x2e,0x68,0x74,0x6d,0x22,0x20,0x65, /* /dprsedit.htm" e */ \
	0x6e,0x63,0x74,0x79,0x70,0x65,0x3d,0x22,0x6d,0x75,0x6c,0x74,0x69,0x70,0x61,0x72, /* nctype="multipar */ \
	0x74,0x2f,0x66,0x6f,0x72,0x6d,0x2d,0x64,0x61,0x74,0x61,0x22,0x3e,0x0d,0x0a,0x3c, /* t/form-data">..< */ \
	0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78, /* script type="tex */ \
	0x74,0x2f,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x20,0x6c,0x61, /* t/javascript" la */ \
	0x6e,0x67,0x75,0x61,0x67,0x65,0x3d,0x22,0x4a,0x61,0x76,0x61,0x53,0x63,0x72,0x69, /* nguage="JavaScri */ \
	0x70,0x74,0x22,0x3e,0x0d,0x0a,0x3c,0x21,0x2d,0x2d,0x0d,0x0a,0x0d,0x0a,0x66,0x75, /* pt">..<!--....fu */ \
	0x6e,0x63,0x74,0x69,0x6f,0x6e,0x20,0x64,0x65,0x6c,0x28,0x61,0x29,0x0d,0x0a,0x7b, /* nction del(a)..{ */ \
	0x0d,0x0a,0x20,0x20,0x77,0x69,0x6e,0x64,0x6f,0x77,0x2e,0x6f,0x70,0x65,0x6e,0x65, /* ..  window.opene */ \
	0x72,0x2e,0x63,0x61,0x6c,0x6c,0x73,0x69,0x67,0x6e,0x2e,0x73,0x70,0x6c,0x69,0x63, /* r.callsign.splic */ \
	0x65,0x20,0x28,0x61,0x2c,0x31,0x29,0x3b,0x0d,0x0a,0x20,0x20,0x77,0x69,0x6e,0x64, /* e (a,1);..  wind */ \
	0x6f,0x77,0x2e,0x6f,0x70,0x65,0x6e,0x65,0x72,0x2e,0x61,0x63,0x63,0x65,0x73,0x73, /* ow.opener.access */ \
	0x2e,0x73,0x70,0x6c,0x69,0x63,0x65,0x28,0x61,0x2c,0x31,0x29,0x3b,0x0d,0x0a,0x20, /* .splice(a,1);..  */ \
	0x20,0x77,0x69,0x6e,0x64,0x6f,0x77,0x2e,0x6f,0x70,0x65,0x6e,0x65,0x72,0x2e,0x65, /*  window.opener.e */ \
	0x6d,0x61,0x69,0x6c,0x2e,0x73,0x70,0x6c,0x69,0x63,0x65,0x28,0x61,0x2c,0x31,0x29, /* mail.splice(a,1) */ \
	0x3b,0x0d,0x0a,0x20,0x20,0x6e,0x20,0x3d,0x20,0x77,0x69,0x6e,0x64,0x6f,0x77,0x2e, /* ;..  n = window. */ \
	0x6f,0x70,0x65,0x6e,0x65,0x72,0x2e,0x63,0x61,0x6c,0x6c,0x73,0x69,0x67,0x6e,0x2e, /* opener.callsign. */ \
	0x6c,0x65,0x6e,0x67,0x74,0x68,0x3b,0x0d,0x0a,0x20,0x20,0x6c,0x6f,0x63,0x61,0x74, /* length;..  locat */ \
	0x69,0x6f,0x6e,0x2e,0x72,0x65,0x6c,0x6f,0x61,0x64,0x28,0x29,0x3b,0x0d,0x0a,0x7d, /* ion.reload();..} */ \
	0x0d,0x0a,0x0d,0x0a,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x20,0x63,0x61,0x6e, /* ....function can */ \
	0x63,0x65,0x6c,0x28,0x29,0x0d,0x0a,0x7b,0x0d,0x0a,0x20,0x20,0x6e,0x20,0x3d,0x20, /* cel()..{..  n =  */ \
	0x77,0x69,0x6e,0x64,0x6f,0x77,0x2e,0x6f,0x70,0x65,0x6e,0x65,0x72,0x2e,0x63,0x61, /* window.opener.ca */ \
	0x6c,0x6c,0x73,0x69,0x67,0x6e,0x2e,0x6c,0x65,0x6e,0x67,0x74,0x68,0x3b,0x0d,0x0a, /* llsign.length;.. */ \
	0x20,0x20,0x6c,0x6f,0x63,0x61,0x74,0x69,0x6f,0x6e,0x2e,0x72,0x65,0x6c,0x6f,0x61, /*   location.reloa */ \
	0x64,0x28,0x29,0x3b,0x0d,0x0a,0x7d,0x0d,0x0a,0x0d,0x0a,0x0d,0x0a,0x66,0x75,0x6e, /* d();..}......fun */ \
	0x63,0x74,0x69,0x6f,0x6e,0x20,0x69,0x6e,0x73,0x65,0x72,0x74,0x28,0x29,0x0d,0x0a, /* ction insert().. */ \
	0x7b,0x0d,0x0a,0x20,0x20,0x69,0x66,0x20,0x28,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e, /* {..  if (documen */ \
	0x74,0x2e,0x44,0x70,0x72,0x73,0x45,0x64,0x69,0x74,0x2e,0x63,0x61,0x6c,0x6c,0x73, /* t.DprsEdit.calls */ \
	0x2e,0x76,0x61,0x6c,0x75,0x65,0x2e,0x6c,0x65,0x6e,0x67,0x74,0x68,0x20,0x21,0x3d, /* .value.length != */ \
	0x20,0x30,0x29,0x0d,0x0a,0x20,0x20,0x7b,0x0d,0x0a,0x20,0x20,0x20,0x20,0x69,0x66, /*  0)..  {..    if */ \
	0x20,0x28,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x44,0x70,0x72,0x73,0x45, /*  (document.DprsE */ \
	0x64,0x69,0x74,0x2e,0x63,0x61,0x6c,0x6c,0x73,0x2e,0x76,0x61,0x6c,0x75,0x65,0x2e, /* dit.calls.value. */ \
	0x63,0x68,0x61,0x72,0x41,0x74,0x28,0x30,0x29,0x20,0x3d,0x3d,0x20,0x27,0x2a,0x27, /* charAt(0) == '.' */ \
	0x29,0x0d,0x0a,0x20,0x20,0x20,0x20,0x7b,0x0d,0x0a,0x09,0x77,0x69,0x6e,0x64,0x6f, /* )..    {...windo */ \
	0x77,0x2e,0x61,0x6c,0x65,0x72,0x74,0x20,0x28,0x22,0x44,0x6f,0x20,0x6e,0x6f,0x74, /* w.alert ("Do not */ \
	0x20,0x75,0x73,0x65,0x20,0x27,0x2a,0x27,0x20,0x28,0x61,0x6c,0x6c,0x20,0x43,0x61, /*  use '.' (all Ca */ \
	0x6c,0x6c,0x73,0x69,0x67,0x6e,0x20,0x61,0x63,0x63,0x65,0x70,0x74,0x29,0x21,0x22, /* llsign accept)!" */ \
	0x29,0x3b,0x0d,0x0a,0x09,0x72,0x65,0x74,0x75,0x72,0x6e,0x3b,0x0d,0x0a,0x20,0x20, /* );...return;..   */ \
	0x20,0x20,0x7d,0x0d,0x0a,0x20,0x20,0x7d,0x0d,0x0a,0x20,0x20,0x69,0x66,0x20,0x28, /*   }..  }..  if ( */ \
	0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x44,0x70,0x72,0x73,0x45,0x64,0x69, /* document.DprsEdi */ \
	0x74,0x2e,0x70,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x2e,0x76,0x61,0x6c,0x75,0x65, /* t.position.value */ \
	0x20,0x3d,0x3d,0x20,0x2d,0x31,0x29,0x0d,0x0a,0x20,0x20,0x7b,0x09,0x0d,0x0a,0x20, /*  == -1)..  {...  */ \
	0x20,0x20,0x20,0x20,0x77,0x69,0x6e,0x64,0x6f,0x77,0x2e,0x6f,0x70,0x65,0x6e,0x65, /*     window.opene */ \
	0x72,0x2e,0x63,0x61,0x6c,0x6c,0x73,0x69,0x67,0x6e,0x2e,0x70,0x75,0x73,0x68,0x28, /* r.callsign.push( */ \
	0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x44,0x70,0x72,0x73,0x45,0x64,0x69, /* document.DprsEdi */ \
	0x74,0x2e,0x63,0x61,0x6c,0x6c,0x73,0x2e,0x76,0x61,0x6c,0x75,0x65,0x29,0x3b,0x0d, /* t.calls.value);. */ \
	0x0a,0x20,0x20,0x20,0x20,0x20,0x77,0x69,0x6e,0x64,0x6f,0x77,0x2e,0x6f,0x70,0x65, /* .     window.ope */ \
	0x6e,0x65,0x72,0x2e,0x61,0x63,0x63,0x65,0x73,0x73,0x2e,0x70,0x75,0x73,0x68,0x28, /* ner.access.push( */ \
	0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x44,0x70,0x72,0x73,0x45,0x64,0x69, /* document.DprsEdi */ \
	0x74,0x2e,0x61,0x63,0x63,0x65,0x73,0x2e,0x76,0x61,0x6c,0x75,0x65,0x29,0x3b,0x0d, /* t.acces.value);. */ \
	0x0a,0x20,0x20,0x20,0x20,0x20,0x77,0x69,0x6e,0x64,0x6f,0x77,0x2e,0x6f,0x70,0x65, /* .     window.ope */ \
	0x6e,0x65,0x72,0x2e,0x65,0x6d,0x61,0x69,0x6c,0x2e,0x70,0x75,0x73,0x68,0x28,0x64, /* ner.email.push(d */ \
	0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x44,0x70,0x72,0x73,0x45,0x64,0x69,0x74, /* ocument.DprsEdit */ \
	0x2e,0x6d,0x61,0x69,0x6c,0x73,0x2e,0x76,0x61,0x6c,0x75,0x65,0x29,0x3b,0x0d,0x0a, /* .mails.value);.. */ \
	0x20,0x20,0x7d,0x0d,0x0a,0x20,0x20,0x65,0x6c,0x73,0x65,0x0d,0x0a,0x20,0x20,0x7b, /*   }..  else..  { */ \
	0x0d,0x0a,0x20,0x20,0x20,0x20,0x20,0x77,0x69,0x6e,0x64,0x6f,0x77,0x2e,0x6f,0x70, /* ..     window.op */ \
	0x65,0x6e,0x65,0x72,0x2e,0x63,0x61,0x6c,0x6c,0x73,0x69,0x67,0x6e,0x2e,0x73,0x70, /* ener.callsign.sp */ \
	0x6c,0x69,0x63,0x65,0x20,0x28,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x44, /* lice (document.D */ \
	0x70,0x72,0x73,0x45,0x64,0x69,0x74,0x2e,0x70,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e, /* prsEdit.position */ \
	0x2e,0x76,0x61,0x6c,0x75,0x65,0x2c,0x30,0x2c,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e, /* .value,0,documen */ \
	0x74,0x2e,0x44,0x70,0x72,0x73,0x45,0x64,0x69,0x74,0x2e,0x63,0x61,0x6c,0x6c,0x73, /* t.DprsEdit.calls */ \
	0x2e,0x76,0x61,0x6c,0x75,0x65,0x29,0x3b,0x0d,0x0a,0x20,0x20,0x20,0x20,0x20,0x77, /* .value);..     w */ \
	0x69,0x6e,0x64,0x6f,0x77,0x2e,0x6f,0x70,0x65,0x6e,0x65,0x72,0x2e,0x61,0x63,0x63, /* indow.opener.acc */ \
	0x65,0x73,0x73,0x2e,0x73,0x70,0x6c,0x69,0x63,0x65,0x28,0x64,0x6f,0x63,0x75,0x6d  /* ess.splice(docum */
#define DATACHUNK000020 \
	0x65,0x6e,0x74,0x2e,0x44,0x70,0x72,0x73,0x45,0x64,0x69,0x74,0x2e,0x70,0x6f,0x73, /* ent.DprsEdit.pos */ \
	0x69,0x74,0x69,0x6f,0x6e,0x2e,0x76,0x61,0x6c,0x75,0x65,0x2c,0x30,0x2c,0x64,0x6f, /* ition.value,0,do */ \
	0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x44,0x70,0x72,0x73,0x45,0x64,0x69,0x74,0x2e, /* cument.DprsEdit. */ \
	0x61,0x63,0x63,0x65,0x73,0x2e,0x76,0x61,0x6c,0x75,0x65,0x29,0x3b,0x0d,0x0a,0x20, /* acces.value);..  */ \
	0x20,0x20,0x20,0x20,0x77,0x69,0x6e,0x64,0x6f,0x77,0x2e,0x6f,0x70,0x65,0x6e,0x65, /*     window.opene */ \
	0x72,0x2e,0x65,0x6d,0x61,0x69,0x6c,0x2e,0x73,0x70,0x6c,0x69,0x63,0x65,0x28,0x64, /* r.email.splice(d */ \
	0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x44,0x70,0x72,0x73,0x45,0x64,0x69,0x74, /* ocument.DprsEdit */ \
	0x2e,0x70,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x2e,0x76,0x61,0x6c,0x75,0x65,0x2c, /* .position.value, */ \
	0x30,0x2c,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x44,0x70,0x72,0x73,0x45, /* 0,document.DprsE */ \
	0x64,0x69,0x74,0x2e,0x6d,0x61,0x69,0x6c,0x73,0x2e,0x76,0x61,0x6c,0x75,0x65,0x29, /* dit.mails.value) */ \
	0x3b,0x0d,0x0a,0x20,0x20,0x7d,0x0d,0x0a,0x20,0x20,0x6e,0x20,0x3d,0x20,0x77,0x69, /* ;..  }..  n = wi */ \
	0x6e,0x64,0x6f,0x77,0x2e,0x6f,0x70,0x65,0x6e,0x65,0x72,0x2e,0x63,0x61,0x6c,0x6c, /* ndow.opener.call */ \
	0x73,0x69,0x67,0x6e,0x2e,0x6c,0x65,0x6e,0x67,0x74,0x68,0x3b,0x0d,0x0a,0x20,0x20, /* sign.length;..   */ \
	0x6c,0x6f,0x63,0x61,0x74,0x69,0x6f,0x6e,0x2e,0x72,0x65,0x6c,0x6f,0x61,0x64,0x28, /* location.reload( */ \
	0x29,0x3b,0x0d,0x0a,0x7d,0x0d,0x0a,0x0d,0x0a,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f, /* );..}....functio */ \
	0x6e,0x20,0x61,0x64,0x64,0x28,0x29,0x0d,0x0a,0x7b,0x0d,0x0a,0x20,0x20,0x64,0x6f, /* n add()..{..  do */ \
	0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x44,0x70,0x72,0x73,0x45,0x64,0x69,0x74,0x2e, /* cument.DprsEdit. */ \
	0x70,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x2e,0x76,0x61,0x6c,0x75,0x65,0x20,0x3d, /* position.value = */ \
	0x20,0x2d,0x31,0x3b,0x0d,0x0a,0x20,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74, /*  -1;..  document */ \
	0x2e,0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28, /* .getElementById( */ \
	0x27,0x41,0x44,0x44,0x27,0x29,0x2e,0x73,0x74,0x79,0x6c,0x65,0x2e,0x64,0x69,0x73, /* 'ADD').style.dis */ \
	0x70,0x6c,0x61,0x79,0x20,0x3d,0x20,0x27,0x62,0x6c,0x6f,0x63,0x6b,0x27,0x3b,0x0d, /* play = 'block';. */ \
	0x0a,0x20,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x67,0x65,0x74,0x45, /* .  document.getE */ \
	0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28,0x27,0x45,0x44,0x49,0x54, /* lementById('EDIT */ \
	0x27,0x29,0x2e,0x73,0x74,0x79,0x6c,0x65,0x2e,0x64,0x69,0x73,0x70,0x6c,0x61,0x79, /* ').style.display */ \
	0x20,0x3d,0x20,0x27,0x6e,0x6f,0x6e,0x65,0x27,0x3b,0x0d,0x0a,0x7d,0x0d,0x0a,0x0d, /*  = 'none';..}... */ \
	0x0a,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x20,0x65,0x64,0x74,0x28,0x61,0x29, /* .function edt(a) */ \
	0x0d,0x0a,0x7b,0x0d,0x0a,0x20,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e, /* ..{..  document. */ \
	0x44,0x70,0x72,0x73,0x45,0x64,0x69,0x74,0x2e,0x63,0x61,0x6c,0x6c,0x65,0x2e,0x76, /* DprsEdit.calle.v */ \
	0x61,0x6c,0x75,0x65,0x20,0x3d,0x20,0x77,0x69,0x6e,0x64,0x6f,0x77,0x2e,0x6f,0x70, /* alue = window.op */ \
	0x65,0x6e,0x65,0x72,0x2e,0x63,0x61,0x6c,0x6c,0x73,0x69,0x67,0x6e,0x5b,0x61,0x5d, /* ener.callsign[a] */ \
	0x3b,0x0d,0x0a,0x20,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x44,0x70, /* ;..  document.Dp */ \
	0x72,0x73,0x45,0x64,0x69,0x74,0x2e,0x6d,0x61,0x69,0x6c,0x65,0x2e,0x76,0x61,0x6c, /* rsEdit.maile.val */ \
	0x75,0x65,0x20,0x3d,0x20,0x77,0x69,0x6e,0x64,0x6f,0x77,0x2e,0x6f,0x70,0x65,0x6e, /* ue = window.open */ \
	0x65,0x72,0x2e,0x65,0x6d,0x61,0x69,0x6c,0x5b,0x61,0x5d,0x3b,0x0d,0x0a,0x20,0x20, /* er.email[a];..   */ \
	0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x44,0x70,0x72,0x73,0x45,0x64,0x69, /* document.DprsEdi */ \
	0x74,0x2e,0x70,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x2e,0x76,0x61,0x6c,0x75,0x65, /* t.position.value */ \
	0x20,0x3d,0x20,0x61,0x3b,0x0d,0x0a,0x20,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e, /*  = a;..  documen */ \
	0x74,0x2e,0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64, /* t.getElementById */ \
	0x28,0x27,0x45,0x44,0x49,0x54,0x27,0x29,0x2e,0x73,0x74,0x79,0x6c,0x65,0x2e,0x64, /* ('EDIT').style.d */ \
	0x69,0x73,0x70,0x6c,0x61,0x79,0x20,0x3d,0x20,0x27,0x62,0x6c,0x6f,0x63,0x6b,0x27, /* isplay = 'block' */ \
	0x3b,0x0d,0x0a,0x20,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x67,0x65, /* ;..  document.ge */ \
	0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28,0x27,0x41,0x44, /* tElementById('AD */ \
	0x44,0x27,0x29,0x2e,0x73,0x74,0x79,0x6c,0x65,0x2e,0x64,0x69,0x73,0x70,0x6c,0x61, /* D').style.displa */ \
	0x79,0x20,0x3d,0x20,0x27,0x6e,0x6f,0x6e,0x65,0x27,0x3b,0x0d,0x0a,0x7d,0x0d,0x0a, /* y = 'none';..}.. */ \
	0x0d,0x0a,0x0d,0x0a,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x20,0x69,0x6e,0x73, /* ....function ins */ \
	0x28,0x61,0x29,0x0d,0x0a,0x7b,0x0d,0x0a,0x20,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65, /* (a)..{..  docume */ \
	0x6e,0x74,0x2e,0x44,0x70,0x72,0x73,0x45,0x64,0x69,0x74,0x2e,0x70,0x6f,0x73,0x69, /* nt.DprsEdit.posi */ \
	0x74,0x69,0x6f,0x6e,0x2e,0x76,0x61,0x6c,0x75,0x65,0x20,0x3d,0x20,0x61,0x3b,0x0d, /* tion.value = a;. */ \
	0x0a,0x20,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x67,0x65,0x74,0x45, /* .  document.getE */ \
	0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28,0x27,0x41,0x44,0x44,0x27, /* lementById('ADD' */ \
	0x29,0x2e,0x73,0x74,0x79,0x6c,0x65,0x2e,0x64,0x69,0x73,0x70,0x6c,0x61,0x79,0x20, /* ).style.display  */ \
	0x3d,0x20,0x27,0x62,0x6c,0x6f,0x63,0x6b,0x27,0x3b,0x0d,0x0a,0x20,0x20,0x64,0x6f, /* = 'block';..  do */ \
	0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e, /* cument.getElemen */ \
	0x74,0x42,0x79,0x49,0x64,0x28,0x27,0x45,0x44,0x49,0x54,0x27,0x29,0x2e,0x73,0x74, /* tById('EDIT').st */ \
	0x79,0x6c,0x65,0x2e,0x64,0x69,0x73,0x70,0x6c,0x61,0x79,0x20,0x3d,0x20,0x27,0x6e, /* yle.display = 'n */ \
	0x6f,0x6e,0x65,0x27,0x3b,0x0d,0x0a,0x7d,0x0d,0x0a,0x0d,0x0a,0x66,0x75,0x6e,0x63, /* one';..}....func */ \
	0x74,0x69,0x6f,0x6e,0x20,0x72,0x65,0x70,0x28,0x29,0x0d,0x0a,0x7b,0x0d,0x0a,0x20, /* tion rep()..{..  */ \
	0x20,0x77,0x69,0x6e,0x64,0x6f,0x77,0x2e,0x6f,0x70,0x65,0x6e,0x65,0x72,0x2e,0x63, /*  window.opener.c */ \
	0x61,0x6c,0x6c,0x73,0x69,0x67,0x6e,0x2e,0x73,0x70,0x6c,0x69,0x63,0x65,0x28,0x64, /* allsign.splice(d */ \
	0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x44,0x70,0x72,0x73,0x45,0x64,0x69,0x74, /* ocument.DprsEdit */ \
	0x2e,0x70,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x2e,0x76,0x61,0x6c,0x75,0x65,0x2c, /* .position.value, */ \
	0x31,0x2c,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x44,0x70,0x72,0x73,0x45, /* 1,document.DprsE */ \
	0x64,0x69,0x74,0x2e,0x63,0x61,0x6c,0x6c,0x65,0x2e,0x76,0x61,0x6c,0x75,0x65,0x29  /* dit.calle.value) */
#define DATACHUNK000021 \
	0x3b,0x0d,0x0a,0x20,0x20,0x77,0x69,0x6e,0x64,0x6f,0x77,0x2e,0x6f,0x70,0x65,0x6e, /* ;..  window.open */ \
	0x65,0x72,0x2e,0x61,0x63,0x63,0x65,0x73,0x73,0x2e,0x73,0x70,0x6c,0x69,0x63,0x65, /* er.access.splice */ \
	0x28,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x44,0x70,0x72,0x73,0x45,0x64, /* (document.DprsEd */ \
	0x69,0x74,0x2e,0x70,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x2e,0x76,0x61,0x6c,0x75, /* it.position.valu */ \
	0x65,0x2c,0x31,0x2c,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x44,0x70,0x72, /* e,1,document.Dpr */ \
	0x73,0x45,0x64,0x69,0x74,0x2e,0x61,0x63,0x63,0x65,0x65,0x2e,0x76,0x61,0x6c,0x75, /* sEdit.accee.valu */ \
	0x65,0x29,0x3b,0x0d,0x0a,0x20,0x20,0x77,0x69,0x6e,0x64,0x6f,0x77,0x2e,0x6f,0x70, /* e);..  window.op */ \
	0x65,0x6e,0x65,0x72,0x2e,0x65,0x6d,0x61,0x69,0x6c,0x2e,0x73,0x70,0x6c,0x69,0x63, /* ener.email.splic */ \
	0x65,0x28,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x44,0x70,0x72,0x73,0x45, /* e(document.DprsE */ \
	0x64,0x69,0x74,0x2e,0x70,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x2e,0x76,0x61,0x6c, /* dit.position.val */ \
	0x75,0x65,0x2c,0x31,0x2c,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x44,0x70, /* ue,1,document.Dp */ \
	0x72,0x73,0x45,0x64,0x69,0x74,0x2e,0x6d,0x61,0x69,0x6c,0x65,0x2e,0x76,0x61,0x6c, /* rsEdit.maile.val */ \
	0x75,0x65,0x29,0x3b,0x0d,0x0a,0x20,0x20,0x6e,0x20,0x3d,0x20,0x77,0x69,0x6e,0x64, /* ue);..  n = wind */ \
	0x6f,0x77,0x2e,0x6f,0x70,0x65,0x6e,0x65,0x72,0x2e,0x63,0x61,0x6c,0x6c,0x73,0x69, /* ow.opener.callsi */ \
	0x67,0x6e,0x2e,0x6c,0x65,0x6e,0x67,0x74,0x68,0x3b,0x0d,0x0a,0x20,0x20,0x6c,0x6f, /* gn.length;..  lo */ \
	0x63,0x61,0x74,0x69,0x6f,0x6e,0x2e,0x72,0x65,0x6c,0x6f,0x61,0x64,0x28,0x29,0x3b, /* cation.reload(); */ \
	0x0d,0x0a,0x7d,0x0d,0x0a,0x0d,0x0a,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x20, /* ..}....function  */ \
	0x53,0x61,0x76,0x65,0x43,0x68,0x65,0x63,0x6b,0x28,0x29,0x0d,0x0a,0x7b,0x0d,0x0a, /* SaveCheck()..{.. */ \
	0x20,0x20,0x69,0x66,0x20,0x28,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x44, /*   if (document.D */ \
	0x70,0x72,0x73,0x45,0x64,0x69,0x74,0x2e,0x63,0x61,0x6c,0x6c,0x73,0x2e,0x76,0x61, /* prsEdit.calls.va */ \
	0x6c,0x75,0x65,0x2e,0x6c,0x65,0x6e,0x67,0x74,0x68,0x20,0x21,0x3d,0x20,0x30,0x29, /* lue.length != 0) */ \
	0x0d,0x0a,0x20,0x20,0x7b,0x0d,0x0a,0x20,0x20,0x20,0x20,0x69,0x66,0x20,0x28,0x64, /* ..  {..    if (d */ \
	0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x44,0x70,0x72,0x73,0x45,0x64,0x69,0x74, /* ocument.DprsEdit */ \
	0x2e,0x63,0x61,0x6c,0x6c,0x73,0x2e,0x76,0x61,0x6c,0x75,0x65,0x2e,0x63,0x68,0x61, /* .calls.value.cha */ \
	0x72,0x41,0x74,0x28,0x30,0x29,0x20,0x3d,0x3d,0x20,0x27,0x2a,0x27,0x29,0x0d,0x0a, /* rAt(0) == '.').. */ \
	0x20,0x20,0x20,0x20,0x7b,0x0d,0x0a,0x09,0x77,0x69,0x6e,0x64,0x6f,0x77,0x2e,0x61, /*     {...window.a */ \
	0x6c,0x65,0x72,0x74,0x20,0x28,0x22,0x44,0x6f,0x20,0x6e,0x6f,0x74,0x20,0x75,0x73, /* lert ("Do not us */ \
	0x65,0x20,0x27,0x2a,0x27,0x20,0x28,0x61,0x6c,0x6c,0x20,0x43,0x61,0x6c,0x6c,0x73, /* e '.' (all Calls */ \
	0x69,0x67,0x6e,0x20,0x61,0x63,0x63,0x65,0x70,0x74,0x29,0x21,0x22,0x29,0x3b,0x0d, /* ign accept)!");. */ \
	0x0a,0x09,0x72,0x65,0x74,0x75,0x72,0x6e,0x3b,0x0d,0x0a,0x20,0x20,0x20,0x20,0x7d, /* ..return;..    } */ \
	0x0d,0x0a,0x20,0x20,0x7d,0x0d,0x0a,0x0d,0x0a,0x20,0x20,0x69,0x66,0x20,0x28,0x64, /* ..  }....  if (d */ \
	0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x44,0x70,0x72,0x73,0x45,0x64,0x69,0x74, /* ocument.DprsEdit */ \
	0x2e,0x63,0x61,0x6c,0x6c,0x65,0x2e,0x76,0x61,0x6c,0x75,0x65,0x2e,0x6c,0x65,0x6e, /* .calle.value.len */ \
	0x67,0x74,0x68,0x20,0x21,0x3d,0x20,0x30,0x29,0x0d,0x0a,0x20,0x20,0x7b,0x0d,0x0a, /* gth != 0)..  {.. */ \
	0x20,0x20,0x20,0x20,0x69,0x66,0x20,0x28,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74, /*     if (document */ \
	0x2e,0x44,0x70,0x72,0x73,0x45,0x64,0x69,0x74,0x2e,0x63,0x61,0x6c,0x6c,0x65,0x2e, /* .DprsEdit.calle. */ \
	0x76,0x61,0x6c,0x75,0x65,0x2e,0x63,0x68,0x61,0x72,0x41,0x74,0x28,0x30,0x29,0x20, /* value.charAt(0)  */ \
	0x3d,0x3d,0x20,0x27,0x2a,0x27,0x29,0x0d,0x0a,0x20,0x20,0x20,0x20,0x7b,0x0d,0x0a, /* == '.')..    {.. */ \
	0x09,0x77,0x69,0x6e,0x64,0x6f,0x77,0x2e,0x61,0x6c,0x65,0x72,0x74,0x20,0x28,0x22, /* .window.alert (" */ \
	0x44,0x6f,0x20,0x6e,0x6f,0x74,0x20,0x75,0x73,0x65,0x20,0x27,0x2a,0x27,0x20,0x28, /* Do not use '.' ( */ \
	0x61,0x6c,0x6c,0x20,0x43,0x61,0x6c,0x6c,0x73,0x69,0x67,0x6e,0x20,0x61,0x63,0x63, /* all Callsign acc */ \
	0x65,0x70,0x74,0x29,0x21,0x22,0x29,0x3b,0x0d,0x0a,0x09,0x72,0x65,0x74,0x75,0x72, /* ept)!");...retur */ \
	0x6e,0x3b,0x0d,0x0a,0x20,0x20,0x20,0x20,0x7d,0x0d,0x0a,0x20,0x20,0x7d,0x0d,0x0a, /* n;..    }..  }.. */ \
	0x20,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x44,0x70,0x72,0x73,0x45, /*   document.DprsE */ \
	0x64,0x69,0x74,0x2e,0x73,0x75,0x62,0x6d,0x69,0x74,0x28,0x29,0x3b,0x0d,0x0a,0x7d, /* dit.submit();..} */ \
	0x0d,0x0a,0x2f,0x2f,0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70, /* ..//-->..</scrip */ \
	0x74,0x3e,0x0d,0x0a,0x3c,0x74,0x61,0x62,0x6c,0x65,0x20,0x62,0x6f,0x72,0x64,0x65, /* t>..<table borde */ \
	0x72,0x3d,0x32,0x3e,0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x74,0x79, /* r=2>..<script ty */ \
	0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x2f,0x6a,0x61,0x76,0x61,0x73,0x63,0x72, /* pe="text/javascr */ \
	0x69,0x70,0x74,0x22,0x20,0x6c,0x61,0x6e,0x67,0x75,0x61,0x67,0x65,0x3d,0x22,0x4a, /* ipt" language="J */ \
	0x61,0x76,0x61,0x53,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x0d,0x0a,0x3c,0x21,0x2d, /* avaScript">..<!- */ \
	0x2d,0x0d,0x0a,0x0d,0x0a,0x20,0x6e,0x20,0x3d,0x20,0x77,0x69,0x6e,0x64,0x6f,0x77, /* -.... n = window */ \
	0x2e,0x6f,0x70,0x65,0x6e,0x65,0x72,0x2e,0x63,0x61,0x6c,0x6c,0x73,0x69,0x67,0x6e, /* .opener.callsign */ \
	0x2e,0x6c,0x65,0x6e,0x67,0x74,0x68,0x3b,0x0d,0x0a,0x20,0x69,0x66,0x20,0x28,0x6e, /* .length;.. if (n */ \
	0x20,0x3e,0x20,0x30,0x29,0x0d,0x0a,0x20,0x7b,0x0d,0x0a,0x20,0x20,0x64,0x6f,0x63, /*  > 0).. {..  doc */ \
	0x75,0x6d,0x65,0x6e,0x74,0x2e,0x77,0x72,0x69,0x74,0x65,0x28,0x22,0x3c,0x74,0x72, /* ument.write("<tr */ \
	0x3e,0x3c,0x74,0x64,0x3e,0x43,0x61,0x6c,0x6c,0x53,0x69,0x67,0x6e,0x3c,0x2f,0x74, /* ><td>CallSign</t */ \
	0x64,0x3e,0x3c,0x74,0x64,0x3e,0x52,0x46,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64, /* d><td>RF</td><td */ \
	0x3e,0x45,0x2d,0x6d,0x61,0x69,0x6c,0x20,0x61,0x64,0x64,0x72,0x65,0x73,0x73,0x3c, /* >E-mail address< */ \
	0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x20,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f, /* /td><td> </td></ */ \
	0x74,0x72,0x3e,0x22,0x29,0x3b,0x0d,0x0a,0x20,0x20,0x66,0x6f,0x72,0x28,0x69,0x3d, /* tr>");..  for(i= */ \
	0x30,0x3b,0x20,0x69,0x3c,0x6e,0x3b,0x20,0x69,0x2b,0x2b,0x29,0x7b,0x0d,0x0a,0x20, /* 0; i<n; i++){..  */ \
	0x20,0x20,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x77,0x72,0x69,0x74, /*    document.writ */ \
	0x65,0x28,0x22,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x22,0x29,0x3b,0x0d,0x0a  /* e("<tr><td>");.. */
#define DATACHUNK000022 \
	0x20,0x20,0x20,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x77,0x72,0x69, /*     document.wri */ \
	0x74,0x65,0x28,0x77,0x69,0x6e,0x64,0x6f,0x77,0x2e,0x6f,0x70,0x65,0x6e,0x65,0x72, /* te(window.opener */ \
	0x2e,0x63,0x61,0x6c,0x6c,0x73,0x69,0x67,0x6e,0x5b,0x69,0x5d,0x29,0x3b,0x0d,0x0a, /* .callsign[i]);.. */ \
	0x20,0x20,0x20,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x77,0x72,0x69, /*     document.wri */ \
	0x74,0x65,0x28,0x22,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x22,0x29,0x3b, /* te("</td><td>"); */ \
	0x0d,0x0a,0x20,0x20,0x20,0x20,0x69,0x66,0x20,0x28,0x77,0x69,0x6e,0x64,0x6f,0x77, /* ..    if (window */ \
	0x2e,0x6f,0x70,0x65,0x6e,0x65,0x72,0x2e,0x61,0x63,0x63,0x65,0x73,0x73,0x5b,0x69, /* .opener.access[i */ \
	0x5d,0x20,0x3d,0x3d,0x20,0x22,0x4f,0x4e,0x22,0x29,0x0d,0x0a,0x20,0x20,0x20,0x20, /* ] == "ON")..     */ \
	0x7b,0x20,0x0d,0x0a,0x20,0x20,0x09,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e, /* { ..  .document. */ \
	0x77,0x72,0x69,0x74,0x65,0x28,0x22,0x4f,0x4e,0x22,0x29,0x3b,0x0d,0x0a,0x20,0x20, /* write("ON");..   */ \
	0x20,0x20,0x7d,0x20,0x65,0x6c,0x73,0x65,0x20,0x7b,0x0d,0x0a,0x09,0x64,0x6f,0x63, /*   } else {...doc */ \
	0x75,0x6d,0x65,0x6e,0x74,0x2e,0x77,0x72,0x69,0x74,0x65,0x28,0x22,0x4f,0x46,0x46, /* ument.write("OFF */ \
	0x22,0x29,0x3b,0x0d,0x0a,0x20,0x20,0x20,0x20,0x7d,0x0d,0x0a,0x20,0x20,0x20,0x20, /* ");..    }..     */ \
	0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x77,0x72,0x69,0x74,0x65,0x28,0x22, /* document.write(" */ \
	0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x22,0x29,0x3b,0x0d,0x0a,0x20,0x20, /* </td><td>");..   */ \
	0x20,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x77,0x72,0x69,0x74,0x65, /*   document.write */ \
	0x28,0x77,0x69,0x6e,0x64,0x6f,0x77,0x2e,0x6f,0x70,0x65,0x6e,0x65,0x72,0x2e,0x65, /* (window.opener.e */ \
	0x6d,0x61,0x69,0x6c,0x5b,0x69,0x5d,0x29,0x3b,0x0d,0x0a,0x20,0x20,0x20,0x20,0x64, /* mail[i]);..    d */ \
	0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x77,0x72,0x69,0x74,0x65,0x28,0x22,0x3c, /* ocument.write("< */ \
	0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x22,0x29,0x3b,0x0d,0x0a,0x20,0x20,0x20, /* /td><td>");..    */ \
	0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x77,0x72,0x69,0x74,0x65,0x28, /*  document.write( */ \
	0x22,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x5c,0x22,0x62, /* "<input type=\"b */ \
	0x75,0x74,0x74,0x6f,0x6e,0x5c,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x5c,0x22, /* utton\" value=\" */ \
	0x44,0x65,0x6c,0x5c,0x22,0x20,0x6f,0x6e,0x43,0x6c,0x69,0x63,0x6b,0x3d,0x5c,0x22, /* Del\" onClick=\" */ \
	0x64,0x65,0x6c,0x28,0x22,0x29,0x3b,0x0d,0x0a,0x20,0x20,0x20,0x20,0x64,0x6f,0x63, /* del(");..    doc */ \
	0x75,0x6d,0x65,0x6e,0x74,0x2e,0x77,0x72,0x69,0x74,0x65,0x28,0x69,0x29,0x3b,0x0d, /* ument.write(i);. */ \
	0x0a,0x20,0x20,0x20,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x77,0x72, /* .    document.wr */ \
	0x69,0x74,0x65,0x28,0x22,0x29,0x5c,0x22,0x3e,0x22,0x29,0x3b,0x0d,0x0a,0x20,0x20, /* ite(")\">");..   */ \
	0x20,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x77,0x72,0x69,0x74,0x65, /*   document.write */ \
	0x28,0x22,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x5c,0x22, /* ("<input type=\" */ \
	0x62,0x75,0x74,0x74,0x6f,0x6e,0x5c,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x5c, /* button\" value=\ */ \
	0x22,0x49,0x6e,0x73,0x5c,0x22,0x20,0x6f,0x6e,0x43,0x6c,0x69,0x63,0x6b,0x3d,0x5c, /* "Ins\" onClick=\ */ \
	0x22,0x69,0x6e,0x73,0x28,0x22,0x29,0x3b,0x0d,0x0a,0x20,0x20,0x20,0x20,0x64,0x6f, /* "ins(");..    do */ \
	0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x77,0x72,0x69,0x74,0x65,0x28,0x69,0x29,0x3b, /* cument.write(i); */ \
	0x0d,0x0a,0x20,0x20,0x20,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x77, /* ..    document.w */ \
	0x72,0x69,0x74,0x65,0x28,0x22,0x29,0x5c,0x22,0x3e,0x22,0x29,0x3b,0x0d,0x0a,0x20, /* rite(")\">");..  */ \
	0x20,0x20,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x77,0x72,0x69,0x74, /*    document.writ */ \
	0x65,0x28,0x22,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x5c, /* e("<input type=\ */ \
	0x22,0x62,0x75,0x74,0x74,0x6f,0x6e,0x5c,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d, /* "button\" value= */ \
	0x5c,0x22,0x45,0x64,0x69,0x74,0x5c,0x22,0x20,0x6f,0x6e,0x43,0x6c,0x69,0x63,0x6b, /* \"Edit\" onClick */ \
	0x3d,0x5c,0x22,0x65,0x64,0x74,0x28,0x22,0x29,0x3b,0x0d,0x0a,0x20,0x20,0x20,0x20, /* =\"edt(");..     */ \
	0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x77,0x72,0x69,0x74,0x65,0x28,0x69, /* document.write(i */ \
	0x29,0x3b,0x0d,0x0a,0x20,0x20,0x20,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74, /* );..    document */ \
	0x2e,0x77,0x72,0x69,0x74,0x65,0x28,0x22,0x29,0x5c,0x22,0x3e,0x22,0x29,0x3b,0x0d, /* .write(")\">");. */ \
	0x0a,0x20,0x20,0x20,0x20,0x69,0x66,0x20,0x28,0x69,0x20,0x3d,0x3d,0x20,0x28,0x6e, /* .    if (i == (n */ \
	0x2d,0x31,0x29,0x29,0x0d,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x64,0x6f,0x63,0x75, /* -1))..      docu */ \
	0x6d,0x65,0x6e,0x74,0x2e,0x77,0x72,0x69,0x74,0x65,0x28,0x22,0x3c,0x69,0x6e,0x70, /* ment.write("<inp */ \
	0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x5c,0x22,0x62,0x75,0x74,0x74,0x6f,0x6e, /* ut type=\"button */ \
	0x5c,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x5c,0x22,0x41,0x70,0x70,0x65,0x6e, /* \" value=\"Appen */ \
	0x64,0x5c,0x22,0x20,0x6f,0x6e,0x43,0x6c,0x69,0x63,0x6b,0x3d,0x5c,0x22,0x61,0x64, /* d\" onClick=\"ad */ \
	0x64,0x28,0x29,0x5c,0x22,0x3e,0x22,0x29,0x3b,0x0d,0x0a,0x20,0x20,0x20,0x20,0x64, /* d()\">");..    d */ \
	0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x77,0x72,0x69,0x74,0x65,0x28,0x22,0x3c, /* ocument.write("< */ \
	0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x22,0x29,0x3b,0x0d,0x0a,0x20,0x20, /* /td></tr>");..   */ \
	0x7d,0x0d,0x0a,0x20,0x7d,0x20,0x65,0x6c,0x73,0x65,0x20,0x7b,0x0d,0x0a,0x20,0x20, /* }.. } else {..   */ \
	0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x77,0x72,0x69,0x74,0x65,0x28,0x22, /* document.write(" */ \
	0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x4e,0x6f,0x20,0x45,0x6e,0x74,0x72,0x79, /* <tr><td>No Entry */ \
	0x20,0x28,0x4e,0x6f,0x20,0x41,0x50,0x52,0x53,0x20,0x4d,0x73,0x67,0x2e,0x20,0x41, /*  (No APRS Msg. A */ \
	0x63,0x63,0x65,0x73,0x73,0x20,0x66,0x69,0x6c,0x65,0x29,0x3c,0x2f,0x74,0x64,0x3e, /* ccess file)</td> */ \
	0x3c,0x2f,0x74,0x72,0x3e,0x22,0x29,0x3b,0x0d,0x0a,0x20,0x7d,0x0d,0x0a,0x2f,0x2f, /* </tr>");.. }..// */ \
	0x20,0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74,0x3e,0x0d, /*  -->..</script>. */ \
	0x0a,0x3c,0x2f,0x74,0x61,0x62,0x6c,0x65,0x3e,0x0d,0x0a,0x3c,0x62,0x72,0x3e,0x0d, /* .</table>..<br>. */ \
	0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64, /* .</div>..<div id */ \
	0x3d,0x22,0x53,0x41,0x56,0x45,0x22,0x3e,0x0d,0x0a,0x26,0x6e,0x62,0x73,0x70,0x3b, /* ="SAVE">..&nbsp; */ \
	0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70  /* &nbsp;<input typ */
#define DATACHUNK000023 \
	0x65,0x3d,0x22,0x62,0x75,0x74,0x74,0x6f,0x6e,0x22,0x20,0x76,0x61,0x6c,0x75,0x65, /* e="button" value */ \
	0x3d,0x22,0x43,0x61,0x6e,0x63,0x65,0x6c,0x22,0x20,0x6f,0x6e,0x43,0x6c,0x69,0x63, /* ="Cancel" onClic */ \
	0x6b,0x3d,0x22,0x63,0x61,0x6e,0x63,0x65,0x6c,0x28,0x29,0x22,0x3e,0x20,0x3c,0x69, /* k="cancel()"> <i */ \
	0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x62,0x75,0x74,0x74,0x6f, /* nput type="butto */ \
	0x6e,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x43,0x6c,0x6f,0x73,0x65,0x22, /* n" value="Close" */ \
	0x20,0x6f,0x6e,0x43,0x6c,0x69,0x63,0x6b,0x3d,0x22,0x77,0x69,0x6e,0x64,0x6f,0x77, /*  onClick="window */ \
	0x2e,0x63,0x6c,0x6f,0x73,0x65,0x28,0x29,0x22,0x3e,0x20,0x3c,0x69,0x6e,0x70,0x75, /* .close()"> <inpu */ \
	0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x62,0x75,0x74,0x74,0x6f,0x6e,0x22,0x20, /* t type="button"  */ \
	0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x53,0x61,0x76,0x65,0x22,0x20,0x6f,0x6e,0x43, /* value="Save" onC */ \
	0x6c,0x69,0x63,0x6b,0x3d,0x22,0x53,0x61,0x76,0x65,0x43,0x68,0x65,0x63,0x6b,0x28, /* lick="SaveCheck( */ \
	0x29,0x22,0x20,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64, /* )" >..</div>..<d */ \
	0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x46,0x49,0x52,0x53,0x54,0x22,0x3e,0x0d,0x0a, /* iv id="FIRST">.. */ \
	0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x69,0x6e,0x70, /* &nbsp;&nbsp;<inp */ \
	0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x62,0x75,0x74,0x74,0x6f,0x6e,0x22, /* ut type="button" */ \
	0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x43,0x61,0x6e,0x63,0x65,0x6c,0x22,0x20, /*  value="Cancel"  */ \
	0x6f,0x6e,0x43,0x6c,0x69,0x63,0x6b,0x3d,0x22,0x63,0x61,0x6e,0x63,0x65,0x6c,0x28, /* onClick="cancel( */ \
	0x29,0x22,0x3e,0x20,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d, /* )"> <input type= */ \
	0x22,0x62,0x75,0x74,0x74,0x6f,0x6e,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22, /* "button" value=" */ \
	0x43,0x6c,0x6f,0x73,0x65,0x22,0x20,0x6f,0x6e,0x43,0x6c,0x69,0x63,0x6b,0x3d,0x22, /* Close" onClick=" */ \
	0x77,0x69,0x6e,0x64,0x6f,0x77,0x2e,0x63,0x6c,0x6f,0x73,0x65,0x28,0x29,0x22,0x3e, /* window.close()"> */ \
	0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x62,0x72,0x3e,0x0d,0x0a, /* ..</div>..<br>.. */ \
	0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x41,0x44,0x44,0x22,0x3e,0x0d,0x0a, /* <div id="ADD">.. */ \
	0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x69,0x6e,0x70, /* &nbsp;&nbsp;<inp */ \
	0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e, /* ut type="text" n */ \
	0x61,0x6d,0x65,0x3d,0x22,0x63,0x61,0x6c,0x6c,0x73,0x22,0x20,0x73,0x69,0x7a,0x65, /* ame="calls" size */ \
	0x3d,0x22,0x39,0x22,0x3e,0x0d,0x0a,0x3c,0x73,0x65,0x6c,0x65,0x63,0x74,0x20,0x6e, /* ="9">..<select n */ \
	0x61,0x6d,0x65,0x3d,0x22,0x61,0x63,0x63,0x65,0x73,0x22,0x3e,0x0d,0x0a,0x3c,0x6f, /* ame="acces">..<o */ \
	0x70,0x74,0x69,0x6f,0x6e,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x4f,0x4e,0x22, /* ption value="ON" */ \
	0x3e,0x4f,0x4e,0x0d,0x0a,0x3c,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x20,0x76,0x61,0x6c, /* >ON..<option val */ \
	0x75,0x65,0x3d,0x22,0x4f,0x46,0x46,0x22,0x3e,0x4f,0x46,0x46,0x0d,0x0a,0x3c,0x2f, /* ue="OFF">OFF..</ */ \
	0x73,0x65,0x6c,0x65,0x63,0x74,0x3e,0x0d,0x0a,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26, /* select>..&nbsp;& */ \
	0x6e,0x62,0x73,0x70,0x3b,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65, /* nbsp;<input type */ \
	0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6d,0x61, /* ="text" name="ma */ \
	0x69,0x6c,0x73,0x22,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79, /* ils">..<input ty */ \
	0x70,0x65,0x3d,0x22,0x62,0x75,0x74,0x74,0x6f,0x6e,0x22,0x20,0x76,0x61,0x6c,0x75, /* pe="button" valu */ \
	0x65,0x3d,0x22,0x49,0x6e,0x73,0x65,0x72,0x74,0x2f,0x41,0x70,0x70,0x65,0x6e,0x64, /* e="Insert/Append */ \
	0x22,0x20,0x6f,0x6e,0x43,0x6c,0x69,0x63,0x6b,0x3d,0x22,0x69,0x6e,0x73,0x65,0x72, /* " onClick="inser */ \
	0x74,0x28,0x29,0x22,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79, /* t()">..<input ty */ \
	0x70,0x65,0x3d,0x22,0x62,0x75,0x74,0x74,0x6f,0x6e,0x22,0x20,0x76,0x61,0x6c,0x75, /* pe="button" valu */ \
	0x65,0x3d,0x22,0x43,0x61,0x6e,0x63,0x65,0x6c,0x22,0x20,0x6f,0x6e,0x43,0x6c,0x69, /* e="Cancel" onCli */ \
	0x63,0x6b,0x3d,0x22,0x63,0x61,0x6e,0x63,0x65,0x6c,0x28,0x29,0x22,0x3e,0x0d,0x0a, /* ck="cancel()">.. */ \
	0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69, /* </div>....<div i */ \
	0x64,0x3d,0x22,0x45,0x44,0x49,0x54,0x22,0x3e,0x0d,0x0a,0x26,0x6e,0x62,0x73,0x70, /* d="EDIT">..&nbsp */ \
	0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79, /* ;&nbsp;<input ty */ \
	0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22, /* pe="text" name=" */ \
	0x63,0x61,0x6c,0x6c,0x65,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x39,0x22,0x3e, /* calle" size="9"> */ \
	0x0d,0x0a,0x3c,0x73,0x65,0x6c,0x65,0x63,0x74,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22, /* ..<select name=" */ \
	0x61,0x63,0x63,0x65,0x65,0x22,0x3e,0x0d,0x0a,0x3c,0x6f,0x70,0x74,0x69,0x6f,0x6e, /* accee">..<option */ \
	0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x4f,0x4e,0x22,0x3e,0x4f,0x4e,0x0d,0x0a, /*  value="ON">ON.. */ \
	0x3c,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x4f, /* <option value="O */ \
	0x46,0x46,0x22,0x3e,0x4f,0x46,0x46,0x0d,0x0a,0x3c,0x2f,0x73,0x65,0x6c,0x65,0x63, /* FF">OFF..</selec */ \
	0x74,0x3e,0x0d,0x0a,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b, /* t>..&nbsp;&nbsp; */ \
	0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78, /* <input type="tex */ \
	0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6d,0x61,0x69,0x6c,0x65,0x22,0x3e, /* t" name="maile"> */ \
	0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x62, /* ..<input type="b */ \
	0x75,0x74,0x74,0x6f,0x6e,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x52,0x65, /* utton" value="Re */ \
	0x70,0x6c,0x61,0x63,0x65,0x22,0x20,0x6f,0x6e,0x43,0x6c,0x69,0x63,0x6b,0x3d,0x22, /* place" onClick=" */ \
	0x72,0x65,0x70,0x28,0x29,0x22,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20, /* rep()">..<input  */ \
	0x74,0x79,0x70,0x65,0x3d,0x22,0x62,0x75,0x74,0x74,0x6f,0x6e,0x22,0x20,0x76,0x61, /* type="button" va */ \
	0x6c,0x75,0x65,0x3d,0x22,0x43,0x61,0x6e,0x63,0x65,0x6c,0x22,0x20,0x6f,0x6e,0x43, /* lue="Cancel" onC */ \
	0x6c,0x69,0x63,0x6b,0x3d,0x22,0x63,0x61,0x6e,0x63,0x65,0x6c,0x28,0x29,0x22,0x3e, /* lick="cancel()"> */ \
	0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x68, /* ..<input type="h */ \
	0x69,0x64,0x64,0x65,0x6e,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x70,0x6f,0x73, /* idden" name="pos */ \
	0x69,0x74,0x69,0x6f,0x6e,0x22,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d  /* ition">..</div>. */
#define DATACHUNK000024 \
	0x0a,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x54,0x45,0x58,0x54, /* ...<div id="TEXT */ \
	0x22,0x3e,0x0d,0x0a,0x3c,0x74,0x65,0x78,0x74,0x61,0x72,0x65,0x61,0x20,0x6e,0x61, /* ">..<textarea na */ \
	0x6d,0x65,0x3d,0x22,0x6d,0x73,0x67,0x63,0x22,0x20,0x63,0x6f,0x6c,0x73,0x3d,0x22, /* me="msgc" cols=" */ \
	0x35,0x30,0x22,0x20,0x72,0x6f,0x77,0x73,0x3d,0x22,0x31,0x30,0x22,0x3e,0x0d,0x0a, /* 50" rows="10">.. */ \
	0x3c,0x2f,0x74,0x65,0x78,0x74,0x61,0x72,0x65,0x61,0x3e,0x0d,0x0a,0x3c,0x2f,0x64, /* </textarea>..</d */ \
	0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x74, /* iv>....<script t */ \
	0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x2f,0x6a,0x61,0x76,0x61,0x73,0x63, /* ype="text/javasc */ \
	0x72,0x69,0x70,0x74,0x22,0x20,0x6c,0x61,0x6e,0x67,0x75,0x61,0x67,0x65,0x3d,0x22, /* ript" language=" */ \
	0x4a,0x61,0x76,0x61,0x53,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x0d,0x0a,0x3c,0x21, /* JavaScript">..<! */ \
	0x2d,0x2d,0x0d,0x0a,0x20,0x6e,0x20,0x3d,0x20,0x77,0x69,0x6e,0x64,0x6f,0x77,0x2e, /* --.. n = window. */ \
	0x6f,0x70,0x65,0x6e,0x65,0x72,0x2e,0x63,0x61,0x6c,0x6c,0x73,0x69,0x67,0x6e,0x2e, /* opener.callsign. */ \
	0x6c,0x65,0x6e,0x67,0x74,0x68,0x3b,0x0d,0x0a,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65, /* length;.. docume */ \
	0x6e,0x74,0x2e,0x44,0x70,0x72,0x73,0x45,0x64,0x69,0x74,0x2e,0x6d,0x73,0x67,0x63, /* nt.DprsEdit.msgc */ \
	0x2e,0x76,0x61,0x6c,0x75,0x65,0x20,0x3d,0x20,0x22,0x22,0x3b,0x0d,0x0a,0x20,0x66, /* .value = "";.. f */ \
	0x6f,0x72,0x20,0x28,0x69,0x20,0x3d,0x20,0x30,0x20,0x3b,0x20,0x69,0x20,0x3c,0x20, /* or (i = 0 ; i <  */ \
	0x6e,0x20,0x3b,0x20,0x69,0x2b,0x2b,0x29,0x0d,0x0a,0x20,0x7b,0x0d,0x0a,0x20,0x20, /* n ; i++).. {..   */ \
	0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x44,0x70,0x72,0x73,0x45,0x64, /*  document.DprsEd */ \
	0x69,0x74,0x2e,0x6d,0x73,0x67,0x63,0x2e,0x76,0x61,0x6c,0x75,0x65,0x20,0x2b,0x3d, /* it.msgc.value += */ \
	0x20,0x20,0x77,0x69,0x6e,0x64,0x6f,0x77,0x2e,0x6f,0x70,0x65,0x6e,0x65,0x72,0x2e, /*   window.opener. */ \
	0x63,0x61,0x6c,0x6c,0x73,0x69,0x67,0x6e,0x5b,0x69,0x5d,0x3b,0x0d,0x0a,0x20,0x20, /* callsign[i];..   */ \
	0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x44,0x70,0x72,0x73,0x45,0x64, /*  document.DprsEd */ \
	0x69,0x74,0x2e,0x6d,0x73,0x67,0x63,0x2e,0x76,0x61,0x6c,0x75,0x65,0x20,0x2b,0x3d, /* it.msgc.value += */ \
	0x20,0x20,0x22,0x2c,0x22,0x3b,0x0d,0x0a,0x20,0x20,0x20,0x64,0x6f,0x63,0x75,0x6d, /*   ",";..   docum */ \
	0x65,0x6e,0x74,0x2e,0x44,0x70,0x72,0x73,0x45,0x64,0x69,0x74,0x2e,0x6d,0x73,0x67, /* ent.DprsEdit.msg */ \
	0x63,0x2e,0x76,0x61,0x6c,0x75,0x65,0x20,0x2b,0x3d,0x20,0x20,0x77,0x69,0x6e,0x64, /* c.value +=  wind */ \
	0x6f,0x77,0x2e,0x6f,0x70,0x65,0x6e,0x65,0x72,0x2e,0x61,0x63,0x63,0x65,0x73,0x73, /* ow.opener.access */ \
	0x5b,0x69,0x5d,0x3b,0x0d,0x0a,0x20,0x20,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e, /* [i];..   documen */ \
	0x74,0x2e,0x44,0x70,0x72,0x73,0x45,0x64,0x69,0x74,0x2e,0x6d,0x73,0x67,0x63,0x2e, /* t.DprsEdit.msgc. */ \
	0x76,0x61,0x6c,0x75,0x65,0x20,0x2b,0x3d,0x20,0x20,0x22,0x2c,0x22,0x3b,0x0d,0x0a, /* value +=  ",";.. */ \
	0x20,0x20,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x44,0x70,0x72,0x73, /*    document.Dprs */ \
	0x45,0x64,0x69,0x74,0x2e,0x6d,0x73,0x67,0x63,0x2e,0x76,0x61,0x6c,0x75,0x65,0x20, /* Edit.msgc.value  */ \
	0x2b,0x3d,0x20,0x20,0x77,0x69,0x6e,0x64,0x6f,0x77,0x2e,0x6f,0x70,0x65,0x6e,0x65, /* +=  window.opene */ \
	0x72,0x2e,0x65,0x6d,0x61,0x69,0x6c,0x5b,0x69,0x5d,0x3b,0x0d,0x0a,0x20,0x20,0x20, /* r.email[i];..    */ \
	0x69,0x66,0x20,0x28,0x69,0x20,0x21,0x3d,0x20,0x28,0x6e,0x2d,0x31,0x29,0x29,0x20, /* if (i != (n-1))  */ \
	0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x44,0x70,0x72,0x73,0x45,0x64,0x69, /* document.DprsEdi */ \
	0x74,0x2e,0x6d,0x73,0x67,0x63,0x2e,0x76,0x61,0x6c,0x75,0x65,0x20,0x2b,0x3d,0x20, /* t.msgc.value +=  */ \
	0x20,0x22,0x2c,0x22,0x3b,0x0d,0x0a,0x20,0x20,0x20,0x65,0x6c,0x73,0x65,0x20,0x64, /*  ",";..   else d */ \
	0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x44,0x70,0x72,0x73,0x45,0x64,0x69,0x74, /* ocument.DprsEdit */ \
	0x2e,0x6d,0x73,0x67,0x63,0x2e,0x76,0x61,0x6c,0x75,0x65,0x20,0x2b,0x3d,0x20,0x20, /* .msgc.value +=   */ \
	0x22,0x3b,0x22,0x3b,0x0d,0x0a,0x20,0x7d,0x0d,0x0a,0x64,0x6f,0x63,0x75,0x6d,0x65, /* ";";.. }..docume */ \
	0x6e,0x74,0x2e,0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49, /* nt.getElementByI */ \
	0x64,0x28,0x27,0x45,0x44,0x49,0x54,0x27,0x29,0x2e,0x73,0x74,0x79,0x6c,0x65,0x2e, /* d('EDIT').style. */ \
	0x64,0x69,0x73,0x70,0x6c,0x61,0x79,0x20,0x3d,0x20,0x27,0x6e,0x6f,0x6e,0x65,0x27, /* display = 'none' */ \
	0x3b,0x0d,0x0a,0x69,0x66,0x20,0x28,0x6e,0x20,0x3e,0x20,0x30,0x29,0x20,0x64,0x6f, /* ;..if (n > 0) do */ \
	0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e, /* cument.getElemen */ \
	0x74,0x42,0x79,0x49,0x64,0x28,0x27,0x41,0x44,0x44,0x27,0x29,0x2e,0x73,0x74,0x79, /* tById('ADD').sty */ \
	0x6c,0x65,0x2e,0x64,0x69,0x73,0x70,0x6c,0x61,0x79,0x20,0x3d,0x20,0x27,0x6e,0x6f, /* le.display = 'no */ \
	0x6e,0x65,0x27,0x3b,0x0d,0x0a,0x65,0x6c,0x73,0x65,0x0d,0x0a,0x7b,0x0d,0x0a,0x20, /* ne';..else..{..  */ \
	0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x67,0x65,0x74,0x45,0x6c,0x65, /*  document.getEle */ \
	0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28,0x27,0x41,0x44,0x44,0x27,0x29,0x2e, /* mentById('ADD'). */ \
	0x73,0x74,0x79,0x6c,0x65,0x2e,0x64,0x69,0x73,0x70,0x6c,0x61,0x79,0x20,0x3d,0x20, /* style.display =  */ \
	0x27,0x62,0x6c,0x6f,0x63,0x6b,0x27,0x3b,0x0d,0x0a,0x20,0x20,0x64,0x6f,0x63,0x75, /* 'block';..  docu */ \
	0x6d,0x65,0x6e,0x74,0x2e,0x44,0x70,0x72,0x73,0x45,0x64,0x69,0x74,0x2e,0x70,0x6f, /* ment.DprsEdit.po */ \
	0x73,0x69,0x74,0x69,0x6f,0x6e,0x2e,0x76,0x61,0x6c,0x75,0x65,0x20,0x3d,0x20,0x2d, /* sition.value = - */ \
	0x31,0x3b,0x0d,0x0a,0x7d,0x0d,0x0a,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e, /* 1;..}..document. */ \
	0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28,0x27, /* getElementById(' */ \
	0x54,0x45,0x58,0x54,0x27,0x29,0x2e,0x73,0x74,0x79,0x6c,0x65,0x2e,0x64,0x69,0x73, /* TEXT').style.dis */ \
	0x70,0x6c,0x61,0x79,0x20,0x3d,0x20,0x27,0x6e,0x6f,0x6e,0x65,0x27,0x3b,0x0d,0x0a, /* play = 'none';.. */ \
	0x69,0x66,0x20,0x28,0x6e,0x20,0x3e,0x20,0x30,0x29,0x0d,0x0a,0x7b,0x0d,0x0a,0x20, /* if (n > 0)..{..  */ \
	0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x67,0x65,0x74,0x45,0x6c,0x65,0x6d, /* document.getElem */ \
	0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28,0x27,0x46,0x49,0x52,0x53,0x54,0x27,0x29, /* entById('FIRST') */ \
	0x2e,0x73,0x74,0x79,0x6c,0x65,0x2e,0x64,0x69,0x73,0x70,0x6c,0x61,0x79,0x3d,0x22, /* .style.display=" */ \
	0x6e,0x6f,0x6e,0x65,0x22,0x0d,0x0a,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74, /* none".. document */ \
	0x2e,0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28  /* .getElementById( */
#define DATACHUNK000025 \
	0x27,0x53,0x41,0x56,0x45,0x27,0x29,0x2e,0x73,0x74,0x79,0x6c,0x65,0x2e,0x64,0x69, /* 'SAVE').style.di */ \
	0x73,0x70,0x6c,0x61,0x79,0x3d,0x22,0x62,0x6c,0x6f,0x63,0x6b,0x22,0x0d,0x0a,0x7d, /* splay="block"..} */ \
	0x0d,0x0a,0x65,0x6c,0x73,0x65,0x0d,0x0a,0x7b,0x0d,0x0a,0x20,0x64,0x6f,0x63,0x75, /* ..else..{.. docu */ \
	0x6d,0x65,0x6e,0x74,0x2e,0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42, /* ment.getElementB */ \
	0x79,0x49,0x64,0x28,0x27,0x46,0x49,0x52,0x53,0x54,0x27,0x29,0x2e,0x73,0x74,0x79, /* yId('FIRST').sty */ \
	0x6c,0x65,0x2e,0x64,0x69,0x73,0x70,0x6c,0x61,0x79,0x3d,0x22,0x62,0x6c,0x6f,0x63, /* le.display="bloc */ \
	0x6b,0x22,0x0d,0x0a,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x67,0x65, /* k".. document.ge */ \
	0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28,0x27,0x53,0x41, /* tElementById('SA */ \
	0x56,0x45,0x27,0x29,0x2e,0x73,0x74,0x79,0x6c,0x65,0x2e,0x64,0x69,0x73,0x70,0x6c, /* VE').style.displ */ \
	0x61,0x79,0x3d,0x22,0x6e,0x6f,0x6e,0x65,0x22,0x0d,0x0a,0x7d,0x0d,0x0a,0x0d,0x0a, /* ay="none"..}.... */ \
	0x0d,0x0a,0x2f,0x2f,0x20,0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69, /* ..// -->..</scri */ \
	0x70,0x74,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x6f,0x72,0x6d,0x3e,0x0d,0x0a,0x0d,0x0a, /* pt>..</form>.... */ \
	0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e, /* ~inc:footer.inc~ */ \
	0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0x44,0x19,0x00,0x00,0x02,0x00,0x00,0x00, /* ....3...D....... */ \
	0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e, /* ~inc:header.inc~ */ \
	0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65, /* ..<div id="conte */ \
	0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x41,0x50,0x52,0x53,0x20,0x4d, /* nt">..<h1>APRS M */ \
	0x65,0x73,0x73,0x61,0x67,0x65,0x20,0x43,0x6f,0x6e,0x74,0x72,0x6f,0x6c,0x20,0x46, /* essage Control F */ \
	0x69,0x6c,0x65,0x3c,0x2f,0x68,0x31,0x3e,0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70, /* ile</h1>..<scrip */ \
	0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x2f,0x6a,0x61,0x76, /* t type="text/jav */ \
	0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x20,0x6c,0x61,0x6e,0x67,0x75,0x61,0x67, /* ascript" languag */ \
	0x65,0x3d,0x22,0x4a,0x61,0x76,0x61,0x53,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x0d, /* e="JavaScript">. */ \
	0x0a,0x3c,0x21,0x2d,0x2d,0x0d,0x0a,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x20, /* .<!--..function  */ \
	0x49,0x6e,0x69,0x74,0x56,0x61,0x6c,0x75,0x65,0x53,0x65,0x74,0x28,0x29,0x0d,0x0a, /* InitValueSet().. */ \
	0x7b,0x0d,0x0a,0x63,0x61,0x6c,0x6c,0x73,0x69,0x67,0x6e,0x20,0x3d,0x20,0x6e,0x65, /* {..callsign = ne */ \
	0x77,0x20,0x41,0x72,0x72,0x61,0x79,0x28,0x29,0x3b,0x0d,0x0a,0x61,0x63,0x63,0x65, /* w Array();..acce */ \
	0x73,0x73,0x09,0x20,0x3d,0x20,0x6e,0x65,0x77,0x20,0x41,0x72,0x72,0x61,0x79,0x28, /* ss. = new Array( */ \
	0x29,0x3b,0x0d,0x0a,0x65,0x6d,0x61,0x69,0x6c,0x09,0x20,0x3d,0x20,0x6e,0x65,0x77, /* );..email. = new */ \
	0x20,0x41,0x72,0x72,0x61,0x79,0x28,0x29,0x3b,0x09,0x0d,0x0a,0x7e,0x45,0x6d,0x61, /*  Array();...~Ema */ \
	0x69,0x6c,0x41,0x63,0x63,0x65,0x73,0x73,0x46,0x69,0x72,0x73,0x74,0x7e,0x0d,0x0a, /* ilAccessFirst~.. */ \
	0x7e,0x45,0x6d,0x61,0x69,0x6c,0x41,0x63,0x63,0x65,0x73,0x73,0x7e,0x0d,0x0a,0x7d, /* ~EmailAccess~..} */ \
	0x0d,0x0a,0x0d,0x0a,0x2f,0x2f,0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72, /* ....//-->..</scr */ \
	0x69,0x70,0x74,0x3e,0x0d,0x0a,0x3c,0x66,0x6f,0x72,0x6d,0x20,0x6e,0x61,0x6d,0x65, /* ipt>..<form name */ \
	0x3d,0x22,0x64,0x70,0x72,0x73,0x22,0x3e,0x0d,0x0a,0x3c,0x62,0x72,0x3e,0x0d,0x0a, /* ="dprs">..<br>.. */ \
	0x3c,0x62,0x3e,0x4e,0x6f,0x74,0x65,0x3a,0x20,0x44,0x6f,0x20,0x6e,0x6f,0x74,0x20, /* <b>Note: Do not  */ \
	0x63,0x6c,0x6f,0x73,0x65,0x20,0x74,0x68,0x69,0x73,0x20,0x77,0x69,0x6e,0x64,0x6f, /* close this windo */ \
	0x77,0x20,0x75,0x6e,0x74,0x69,0x6c,0x20,0x63,0x6c,0x6f,0x73,0x69,0x6e,0x67,0x20, /* w until closing  */ \
	0x74,0x68,0x65,0x20,0x65,0x64,0x69,0x74,0x20,0x77,0x69,0x6e,0x64,0x6f,0x77,0x21, /* the edit window! */ \
	0x3c,0x2f,0x62,0x3e,0x3c,0x62,0x72,0x3e,0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70, /* </b><br>..<scrip */ \
	0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x2f,0x6a,0x61,0x76, /* t type="text/jav */ \
	0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x20,0x6c,0x61,0x6e,0x67,0x75,0x61,0x67, /* ascript" languag */ \
	0x65,0x3d,0x22,0x4a,0x61,0x76,0x61,0x53,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x0d, /* e="JavaScript">. */ \
	0x0a,0x3c,0x21,0x2d,0x2d,0x0d,0x0a,0x76,0x61,0x72,0x20,0x77,0x3b,0x0d,0x0a,0x49, /* .<!--..var w;..I */ \
	0x6e,0x69,0x74,0x56,0x61,0x6c,0x75,0x65,0x53,0x65,0x74,0x28,0x29,0x3b,0x0d,0x0a, /* nitValueSet();.. */ \
	0x69,0x66,0x20,0x28,0x21,0x77,0x20,0x7c,0x7c,0x20,0x77,0x2e,0x63,0x6c,0x6f,0x73, /* if (!w || w.clos */ \
	0x65,0x64,0x29,0x20,0x77,0x69,0x6e,0x64,0x6f,0x77,0x2e,0x6f,0x70,0x65,0x6e,0x28, /* ed) window.open( */ \
	0x22,0x2e,0x2f,0x64,0x70,0x72,0x73,0x65,0x64,0x69,0x74,0x2e,0x68,0x74,0x6d,0x22, /* "./dprsedit.htm" */ \
	0x29,0x3b,0x0d,0x0a,0x65,0x6c,0x73,0x65,0x20,0x77,0x2e,0x66,0x6f,0x63,0x75,0x73, /* );..else w.focus */ \
	0x28,0x29,0x3b,0x0d,0x0a,0x2f,0x2f,0x20,0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73, /* ();..// -->..</s */ \
	0x63,0x72,0x69,0x70,0x74,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x6f,0x72,0x6d,0x3e,0x0d, /* cript>..</form>. */ \
	0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a, /* .</div>....~inc: */ \
	0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x00,0x00,0x00,0x00,0x33, /* footer.inc~....3 */ \
	0x00,0x00,0x00,0xec,0x00,0x00,0x00,0xc4,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0xc1, /* ................ */ \
	0x00,0x00,0x00,0x4b,0x02,0x00,0x00,0x02,0x00,0x00,0x00,0x7e,0x69,0x6e,0x63,0x3a, /* ...K.......~inc: */ \
	0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69, /* header.inc~..<di */ \
	0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d, /* v id="content">. */ \
	0x0a,0x3c,0x68,0x31,0x3e,0x45,0x64,0x69,0x74,0x20,0x74,0x68,0x65,0x20,0x41,0x63, /* .<h1>Edit the Ac */ \
	0x63,0x65,0x73,0x73,0x20,0x43,0x6f,0x6e,0x74,0x72,0x6f,0x6c,0x20,0x46,0x69,0x6c, /* cess Control Fil */ \
	0x65,0x3c,0x2f,0x68,0x31,0x3e,0x0d,0x0a,0x3c,0x66,0x6f,0x72,0x6d,0x20,0x6e,0x61, /* e</h1>..<form na */ \
	0x6d,0x65,0x3d,0x22,0x65,0x64,0x69,0x74,0x22,0x20,0x6d,0x65,0x74,0x68,0x6f,0x64, /* me="edit" method */ \
	0x3d,0x22,0x70,0x6f,0x73,0x74,0x22,0x20,0x61,0x63,0x74,0x69,0x6f,0x6e,0x3d,0x22, /* ="post" action=" */ \
	0x2f,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x65,0x64,0x69,0x74,0x2e,0x68,0x74, /* /protect/edit.ht */ \
	0x6d,0x22,0x20,0x65,0x6e,0x63,0x74,0x79,0x70,0x65,0x3d,0x22,0x6d,0x75,0x6c,0x74, /* m" enctype="mult */ \
	0x69,0x70,0x61,0x72,0x74,0x2f,0x66,0x6f,0x72,0x6d,0x2d,0x64,0x61,0x74,0x61,0x22  /* ipart/form-data" */
#define DATACHUNK000026 \
	0x3e,0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x74,0x79,0x70,0x65,0x3d, /* >..<script type= */ \
	0x22,0x74,0x65,0x78,0x74,0x2f,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74, /* "text/javascript */ \
	0x22,0x20,0x6c,0x61,0x6e,0x67,0x75,0x61,0x67,0x65,0x3d,0x22,0x4a,0x61,0x76,0x61, /* " language="Java */ \
	0x53,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x0d,0x0a,0x3c,0x21,0x2d,0x2d,0x0d,0x0a, /* Script">..<!--.. */ \
	0x0d,0x0a,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x20,0x64,0x65,0x6c,0x28,0x61, /* ..function del(a */ \
	0x29,0x0d,0x0a,0x7b,0x0d,0x0a,0x20,0x20,0x77,0x69,0x6e,0x64,0x6f,0x77,0x2e,0x6f, /* )..{..  window.o */ \
	0x70,0x65,0x6e,0x65,0x72,0x2e,0x63,0x61,0x6c,0x6c,0x73,0x69,0x67,0x6e,0x2e,0x73, /* pener.callsign.s */ \
	0x70,0x6c,0x69,0x63,0x65,0x20,0x28,0x61,0x2c,0x31,0x29,0x3b,0x0d,0x0a,0x20,0x20, /* plice (a,1);..   */ \
	0x77,0x69,0x6e,0x64,0x6f,0x77,0x2e,0x6f,0x70,0x65,0x6e,0x65,0x72,0x2e,0x61,0x63, /* window.opener.ac */ \
	0x63,0x65,0x73,0x73,0x2e,0x73,0x70,0x6c,0x69,0x63,0x65,0x28,0x61,0x2c,0x31,0x29, /* cess.splice(a,1) */ \
	0x3b,0x0d,0x0a,0x20,0x20,0x6e,0x20,0x3d,0x20,0x77,0x69,0x6e,0x64,0x6f,0x77,0x2e, /* ;..  n = window. */ \
	0x6f,0x70,0x65,0x6e,0x65,0x72,0x2e,0x63,0x61,0x6c,0x6c,0x73,0x69,0x67,0x6e,0x2e, /* opener.callsign. */ \
	0x6c,0x65,0x6e,0x67,0x74,0x68,0x3b,0x0d,0x0a,0x20,0x20,0x6c,0x6f,0x63,0x61,0x74, /* length;..  locat */ \
	0x69,0x6f,0x6e,0x2e,0x72,0x65,0x6c,0x6f,0x61,0x64,0x28,0x29,0x3b,0x0d,0x0a,0x7d, /* ion.reload();..} */ \
	0x0d,0x0a,0x0d,0x0a,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x20,0x63,0x61,0x6e, /* ....function can */ \
	0x63,0x65,0x6c,0x28,0x29,0x0d,0x0a,0x7b,0x0d,0x0a,0x20,0x20,0x6e,0x20,0x3d,0x20, /* cel()..{..  n =  */ \
	0x77,0x69,0x6e,0x64,0x6f,0x77,0x2e,0x6f,0x70,0x65,0x6e,0x65,0x72,0x2e,0x63,0x61, /* window.opener.ca */ \
	0x6c,0x6c,0x73,0x69,0x67,0x6e,0x2e,0x6c,0x65,0x6e,0x67,0x74,0x68,0x3b,0x0d,0x0a, /* llsign.length;.. */ \
	0x20,0x20,0x6c,0x6f,0x63,0x61,0x74,0x69,0x6f,0x6e,0x2e,0x72,0x65,0x6c,0x6f,0x61, /*   location.reloa */ \
	0x64,0x28,0x29,0x3b,0x0d,0x0a,0x7d,0x0d,0x0a,0x0d,0x0a,0x0d,0x0a,0x66,0x75,0x6e, /* d();..}......fun */ \
	0x63,0x74,0x69,0x6f,0x6e,0x20,0x69,0x6e,0x73,0x65,0x72,0x74,0x28,0x29,0x0d,0x0a, /* ction insert().. */ \
	0x7b,0x0d,0x0a,0x20,0x20,0x69,0x66,0x20,0x28,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e, /* {..  if (documen */ \
	0x74,0x2e,0x65,0x64,0x69,0x74,0x2e,0x70,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x2e, /* t.edit.position. */ \
	0x76,0x61,0x6c,0x75,0x65,0x20,0x3d,0x3d,0x20,0x2d,0x31,0x29,0x0d,0x0a,0x20,0x20, /* value == -1)..   */ \
	0x7b,0x09,0x0d,0x0a,0x20,0x20,0x20,0x20,0x20,0x77,0x69,0x6e,0x64,0x6f,0x77,0x2e, /* {...     window. */ \
	0x6f,0x70,0x65,0x6e,0x65,0x72,0x2e,0x63,0x61,0x6c,0x6c,0x73,0x69,0x67,0x6e,0x2e, /* opener.callsign. */ \
	0x70,0x75,0x73,0x68,0x28,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x65,0x64, /* push(document.ed */ \
	0x69,0x74,0x2e,0x63,0x61,0x6c,0x6c,0x73,0x2e,0x76,0x61,0x6c,0x75,0x65,0x29,0x3b, /* it.calls.value); */ \
	0x0d,0x0a,0x20,0x20,0x20,0x20,0x20,0x77,0x69,0x6e,0x64,0x6f,0x77,0x2e,0x6f,0x70, /* ..     window.op */ \
	0x65,0x6e,0x65,0x72,0x2e,0x61,0x63,0x63,0x65,0x73,0x73,0x2e,0x70,0x75,0x73,0x68, /* ener.access.push */ \
	0x28,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x65,0x64,0x69,0x74,0x2e,0x61, /* (document.edit.a */ \
	0x63,0x63,0x65,0x73,0x2e,0x76,0x61,0x6c,0x75,0x65,0x29,0x3b,0x0d,0x0a,0x20,0x20, /* cces.value);..   */ \
	0x7d,0x0d,0x0a,0x20,0x20,0x65,0x6c,0x73,0x65,0x0d,0x0a,0x20,0x20,0x7b,0x0d,0x0a, /* }..  else..  {.. */ \
	0x20,0x20,0x20,0x20,0x20,0x77,0x69,0x6e,0x64,0x6f,0x77,0x2e,0x6f,0x70,0x65,0x6e, /*      window.open */ \
	0x65,0x72,0x2e,0x63,0x61,0x6c,0x6c,0x73,0x69,0x67,0x6e,0x2e,0x73,0x70,0x6c,0x69, /* er.callsign.spli */ \
	0x63,0x65,0x20,0x28,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x65,0x64,0x69, /* ce (document.edi */ \
	0x74,0x2e,0x70,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x2e,0x76,0x61,0x6c,0x75,0x65, /* t.position.value */ \
	0x2c,0x30,0x2c,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x65,0x64,0x69,0x74, /* ,0,document.edit */ \
	0x2e,0x63,0x61,0x6c,0x6c,0x73,0x2e,0x76,0x61,0x6c,0x75,0x65,0x29,0x3b,0x0d,0x0a, /* .calls.value);.. */ \
	0x20,0x20,0x20,0x20,0x20,0x77,0x69,0x6e,0x64,0x6f,0x77,0x2e,0x6f,0x70,0x65,0x6e, /*      window.open */ \
	0x65,0x72,0x2e,0x61,0x63,0x63,0x65,0x73,0x73,0x2e,0x73,0x70,0x6c,0x69,0x63,0x65, /* er.access.splice */ \
	0x28,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x65,0x64,0x69,0x74,0x2e,0x70, /* (document.edit.p */ \
	0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x2e,0x76,0x61,0x6c,0x75,0x65,0x2c,0x30,0x2c, /* osition.value,0, */ \
	0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x65,0x64,0x69,0x74,0x2e,0x61,0x63, /* document.edit.ac */ \
	0x63,0x65,0x73,0x2e,0x76,0x61,0x6c,0x75,0x65,0x29,0x3b,0x0d,0x0a,0x20,0x20,0x7d, /* ces.value);..  } */ \
	0x0d,0x0a,0x20,0x20,0x6e,0x20,0x3d,0x20,0x77,0x69,0x6e,0x64,0x6f,0x77,0x2e,0x6f, /* ..  n = window.o */ \
	0x70,0x65,0x6e,0x65,0x72,0x2e,0x63,0x61,0x6c,0x6c,0x73,0x69,0x67,0x6e,0x2e,0x6c, /* pener.callsign.l */ \
	0x65,0x6e,0x67,0x74,0x68,0x3b,0x0d,0x0a,0x20,0x20,0x6c,0x6f,0x63,0x61,0x74,0x69, /* ength;..  locati */ \
	0x6f,0x6e,0x2e,0x72,0x65,0x6c,0x6f,0x61,0x64,0x28,0x29,0x3b,0x0d,0x0a,0x7d,0x0d, /* on.reload();..}. */ \
	0x0a,0x0d,0x0a,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x20,0x61,0x64,0x64,0x28, /* ...function add( */ \
	0x29,0x0d,0x0a,0x7b,0x0d,0x0a,0x20,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74, /* )..{..  document */ \
	0x2e,0x65,0x64,0x69,0x74,0x2e,0x70,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x2e,0x76, /* .edit.position.v */ \
	0x61,0x6c,0x75,0x65,0x20,0x3d,0x20,0x2d,0x31,0x3b,0x0d,0x0a,0x20,0x20,0x64,0x6f, /* alue = -1;..  do */ \
	0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e, /* cument.getElemen */ \
	0x74,0x42,0x79,0x49,0x64,0x28,0x27,0x41,0x44,0x44,0x27,0x29,0x2e,0x73,0x74,0x79, /* tById('ADD').sty */ \
	0x6c,0x65,0x2e,0x64,0x69,0x73,0x70,0x6c,0x61,0x79,0x20,0x3d,0x20,0x27,0x62,0x6c, /* le.display = 'bl */ \
	0x6f,0x63,0x6b,0x27,0x3b,0x0d,0x0a,0x20,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e, /* ock';..  documen */ \
	0x74,0x2e,0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64, /* t.getElementById */ \
	0x28,0x27,0x45,0x44,0x49,0x54,0x27,0x29,0x2e,0x73,0x74,0x79,0x6c,0x65,0x2e,0x64, /* ('EDIT').style.d */ \
	0x69,0x73,0x70,0x6c,0x61,0x79,0x20,0x3d,0x20,0x27,0x6e,0x6f,0x6e,0x65,0x27,0x3b, /* isplay = 'none'; */ \
	0x0d,0x0a,0x7d,0x0d,0x0a,0x0d,0x0a,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x20, /* ..}....function  */ \
	0x65,0x64,0x74,0x28,0x61,0x29,0x0d,0x0a,0x7b,0x0d,0x0a,0x20,0x20,0x64,0x6f,0x63, /* edt(a)..{..  doc */ \
	0x75,0x6d,0x65,0x6e,0x74,0x2e,0x65,0x64,0x69,0x74,0x2e,0x63,0x61,0x6c,0x6c,0x65, /* ument.edit.calle */ \
	0x2e,0x76,0x61,0x6c,0x75,0x65,0x20,0x3d,0x20,0x77,0x69,0x6e,0x64,0x6f,0x77,0x2e  /* .value = window. */
#define DATACHUNK000027 \
	0x6f,0x70,0x65,0x6e,0x65,0x72,0x2e,0x63,0x61,0x6c,0x6c,0x73,0x69,0x67,0x6e,0x5b, /* opener.callsign[ */ \
	0x61,0x5d,0x3b,0x0d,0x0a,0x20,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e, /* a];..  document. */ \
	0x65,0x64,0x69,0x74,0x2e,0x70,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x2e,0x76,0x61, /* edit.position.va */ \
	0x6c,0x75,0x65,0x20,0x3d,0x20,0x61,0x3b,0x0d,0x0a,0x20,0x20,0x64,0x6f,0x63,0x75, /* lue = a;..  docu */ \
	0x6d,0x65,0x6e,0x74,0x2e,0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42, /* ment.getElementB */ \
	0x79,0x49,0x64,0x28,0x27,0x45,0x44,0x49,0x54,0x27,0x29,0x2e,0x73,0x74,0x79,0x6c, /* yId('EDIT').styl */ \
	0x65,0x2e,0x64,0x69,0x73,0x70,0x6c,0x61,0x79,0x20,0x3d,0x20,0x27,0x62,0x6c,0x6f, /* e.display = 'blo */ \
	0x63,0x6b,0x27,0x3b,0x0d,0x0a,0x20,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74, /* ck';..  document */ \
	0x2e,0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28, /* .getElementById( */ \
	0x27,0x41,0x44,0x44,0x27,0x29,0x2e,0x73,0x74,0x79,0x6c,0x65,0x2e,0x64,0x69,0x73, /* 'ADD').style.dis */ \
	0x70,0x6c,0x61,0x79,0x20,0x3d,0x20,0x27,0x6e,0x6f,0x6e,0x65,0x27,0x3b,0x0d,0x0a, /* play = 'none';.. */ \
	0x7d,0x0d,0x0a,0x0d,0x0a,0x0d,0x0a,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x20, /* }......function  */ \
	0x69,0x6e,0x73,0x28,0x61,0x29,0x0d,0x0a,0x7b,0x0d,0x0a,0x20,0x20,0x64,0x6f,0x63, /* ins(a)..{..  doc */ \
	0x75,0x6d,0x65,0x6e,0x74,0x2e,0x65,0x64,0x69,0x74,0x2e,0x70,0x6f,0x73,0x69,0x74, /* ument.edit.posit */ \
	0x69,0x6f,0x6e,0x2e,0x76,0x61,0x6c,0x75,0x65,0x20,0x3d,0x20,0x61,0x3b,0x0d,0x0a, /* ion.value = a;.. */ \
	0x20,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x67,0x65,0x74,0x45,0x6c, /*   document.getEl */ \
	0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28,0x27,0x41,0x44,0x44,0x27,0x29, /* ementById('ADD') */ \
	0x2e,0x73,0x74,0x79,0x6c,0x65,0x2e,0x64,0x69,0x73,0x70,0x6c,0x61,0x79,0x20,0x3d, /* .style.display = */ \
	0x20,0x27,0x62,0x6c,0x6f,0x63,0x6b,0x27,0x3b,0x0d,0x0a,0x20,0x20,0x64,0x6f,0x63, /*  'block';..  doc */ \
	0x75,0x6d,0x65,0x6e,0x74,0x2e,0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74, /* ument.getElement */ \
	0x42,0x79,0x49,0x64,0x28,0x27,0x45,0x44,0x49,0x54,0x27,0x29,0x2e,0x73,0x74,0x79, /* ById('EDIT').sty */ \
	0x6c,0x65,0x2e,0x64,0x69,0x73,0x70,0x6c,0x61,0x79,0x20,0x3d,0x20,0x27,0x6e,0x6f, /* le.display = 'no */ \
	0x6e,0x65,0x27,0x3b,0x0d,0x0a,0x7d,0x0d,0x0a,0x0d,0x0a,0x66,0x75,0x6e,0x63,0x74, /* ne';..}....funct */ \
	0x69,0x6f,0x6e,0x20,0x72,0x65,0x70,0x28,0x29,0x0d,0x0a,0x7b,0x0d,0x0a,0x20,0x20, /* ion rep()..{..   */ \
	0x77,0x69,0x6e,0x64,0x6f,0x77,0x2e,0x6f,0x70,0x65,0x6e,0x65,0x72,0x2e,0x63,0x61, /* window.opener.ca */ \
	0x6c,0x6c,0x73,0x69,0x67,0x6e,0x2e,0x73,0x70,0x6c,0x69,0x63,0x65,0x28,0x64,0x6f, /* llsign.splice(do */ \
	0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x65,0x64,0x69,0x74,0x2e,0x70,0x6f,0x73,0x69, /* cument.edit.posi */ \
	0x74,0x69,0x6f,0x6e,0x2e,0x76,0x61,0x6c,0x75,0x65,0x2c,0x31,0x2c,0x64,0x6f,0x63, /* tion.value,1,doc */ \
	0x75,0x6d,0x65,0x6e,0x74,0x2e,0x65,0x64,0x69,0x74,0x2e,0x63,0x61,0x6c,0x6c,0x65, /* ument.edit.calle */ \
	0x2e,0x76,0x61,0x6c,0x75,0x65,0x29,0x3b,0x0d,0x0a,0x20,0x20,0x77,0x69,0x6e,0x64, /* .value);..  wind */ \
	0x6f,0x77,0x2e,0x6f,0x70,0x65,0x6e,0x65,0x72,0x2e,0x61,0x63,0x63,0x65,0x73,0x73, /* ow.opener.access */ \
	0x2e,0x73,0x70,0x6c,0x69,0x63,0x65,0x28,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74, /* .splice(document */ \
	0x2e,0x65,0x64,0x69,0x74,0x2e,0x70,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x2e,0x76, /* .edit.position.v */ \
	0x61,0x6c,0x75,0x65,0x2c,0x31,0x2c,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e, /* alue,1,document. */ \
	0x65,0x64,0x69,0x74,0x2e,0x61,0x63,0x63,0x65,0x65,0x2e,0x76,0x61,0x6c,0x75,0x65, /* edit.accee.value */ \
	0x29,0x3b,0x0d,0x0a,0x20,0x20,0x6e,0x20,0x3d,0x20,0x77,0x69,0x6e,0x64,0x6f,0x77, /* );..  n = window */ \
	0x2e,0x6f,0x70,0x65,0x6e,0x65,0x72,0x2e,0x63,0x61,0x6c,0x6c,0x73,0x69,0x67,0x6e, /* .opener.callsign */ \
	0x2e,0x6c,0x65,0x6e,0x67,0x74,0x68,0x3b,0x0d,0x0a,0x20,0x20,0x6c,0x6f,0x63,0x61, /* .length;..  loca */ \
	0x74,0x69,0x6f,0x6e,0x2e,0x72,0x65,0x6c,0x6f,0x61,0x64,0x28,0x29,0x3b,0x0d,0x0a, /* tion.reload();.. */ \
	0x7d,0x0d,0x0a,0x0d,0x0a,0x2f,0x2f,0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63, /* }....//-->..</sc */ \
	0x72,0x69,0x70,0x74,0x3e,0x0d,0x0a,0x3c,0x74,0x61,0x62,0x6c,0x65,0x20,0x62,0x6f, /* ript>..<table bo */ \
	0x72,0x64,0x65,0x72,0x3d,0x32,0x3e,0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74, /* rder=2>..<script */ \
	0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x2f,0x6a,0x61,0x76,0x61, /*  type="text/java */ \
	0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x20,0x6c,0x61,0x6e,0x67,0x75,0x61,0x67,0x65, /* script" language */ \
	0x3d,0x22,0x4a,0x61,0x76,0x61,0x53,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x0d,0x0a, /* ="JavaScript">.. */ \
	0x3c,0x21,0x2d,0x2d,0x0d,0x0a,0x0d,0x0a,0x20,0x6e,0x20,0x3d,0x20,0x77,0x69,0x6e, /* <!--.... n = win */ \
	0x64,0x6f,0x77,0x2e,0x6f,0x70,0x65,0x6e,0x65,0x72,0x2e,0x63,0x61,0x6c,0x6c,0x73, /* dow.opener.calls */ \
	0x69,0x67,0x6e,0x2e,0x6c,0x65,0x6e,0x67,0x74,0x68,0x3b,0x0d,0x0a,0x20,0x69,0x66, /* ign.length;.. if */ \
	0x20,0x28,0x6e,0x20,0x3e,0x20,0x30,0x29,0x0d,0x0a,0x20,0x7b,0x0d,0x0a,0x20,0x20, /*  (n > 0).. {..   */ \
	0x66,0x6f,0x72,0x28,0x69,0x3d,0x30,0x3b,0x20,0x69,0x3c,0x6e,0x3b,0x20,0x69,0x2b, /* for(i=0; i<n; i+ */ \
	0x2b,0x29,0x7b,0x0d,0x0a,0x20,0x20,0x20,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e, /* +){..    documen */ \
	0x74,0x2e,0x77,0x72,0x69,0x74,0x65,0x28,0x22,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64, /* t.write("<tr><td */ \
	0x3e,0x22,0x29,0x3b,0x0d,0x0a,0x20,0x20,0x20,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65, /* >");..    docume */ \
	0x6e,0x74,0x2e,0x77,0x72,0x69,0x74,0x65,0x28,0x77,0x69,0x6e,0x64,0x6f,0x77,0x2e, /* nt.write(window. */ \
	0x6f,0x70,0x65,0x6e,0x65,0x72,0x2e,0x63,0x61,0x6c,0x6c,0x73,0x69,0x67,0x6e,0x5b, /* opener.callsign[ */ \
	0x69,0x5d,0x29,0x3b,0x0d,0x0a,0x20,0x20,0x20,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65, /* i]);..    docume */ \
	0x6e,0x74,0x2e,0x77,0x72,0x69,0x74,0x65,0x28,0x22,0x3c,0x2f,0x74,0x64,0x3e,0x3c, /* nt.write("</td>< */ \
	0x74,0x64,0x3e,0x22,0x29,0x3b,0x0d,0x0a,0x20,0x20,0x20,0x20,0x69,0x66,0x20,0x28, /* td>");..    if ( */ \
	0x77,0x69,0x6e,0x64,0x6f,0x77,0x2e,0x6f,0x70,0x65,0x6e,0x65,0x72,0x2e,0x61,0x63, /* window.opener.ac */ \
	0x63,0x65,0x73,0x73,0x5b,0x69,0x5d,0x20,0x3d,0x3d,0x20,0x22,0x41,0x4c,0x4c,0x4f, /* cess[i] == "ALLO */ \
	0x57,0x22,0x29,0x0d,0x0a,0x20,0x20,0x20,0x20,0x7b,0x20,0x0d,0x0a,0x20,0x20,0x09, /* W")..    { ..  . */ \
	0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x77,0x72,0x69,0x74,0x65,0x28,0x22, /* document.write(" */ \
	0x41,0x4c,0x4c,0x4f,0x57,0x22,0x29,0x3b,0x0d,0x0a,0x20,0x20,0x20,0x20,0x7d,0x20, /* ALLOW");..    }  */ \
	0x65,0x6c,0x73,0x65,0x20,0x7b,0x0d,0x0a,0x09,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e  /* else {...documen */
#define DATACHUNK000028 \
	0x74,0x2e,0x77,0x72,0x69,0x74,0x65,0x28,0x22,0x44,0x45,0x4e,0x59,0x22,0x29,0x3b, /* t.write("DENY"); */ \
	0x0d,0x0a,0x20,0x20,0x20,0x20,0x7d,0x0d,0x0a,0x20,0x20,0x20,0x20,0x64,0x6f,0x63, /* ..    }..    doc */ \
	0x75,0x6d,0x65,0x6e,0x74,0x2e,0x77,0x72,0x69,0x74,0x65,0x28,0x22,0x3c,0x2f,0x74, /* ument.write("</t */ \
	0x64,0x3e,0x3c,0x74,0x64,0x3e,0x22,0x29,0x3b,0x0d,0x0a,0x20,0x20,0x20,0x20,0x64, /* d><td>");..    d */ \
	0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x77,0x72,0x69,0x74,0x65,0x28,0x22,0x3c, /* ocument.write("< */ \
	0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x5c,0x22,0x62,0x75,0x74, /* input type=\"but */ \
	0x74,0x6f,0x6e,0x5c,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x5c,0x22,0x44,0x65, /* ton\" value=\"De */ \
	0x6c,0x5c,0x22,0x20,0x6f,0x6e,0x43,0x6c,0x69,0x63,0x6b,0x3d,0x5c,0x22,0x64,0x65, /* l\" onClick=\"de */ \
	0x6c,0x28,0x22,0x29,0x3b,0x0d,0x0a,0x20,0x20,0x20,0x20,0x64,0x6f,0x63,0x75,0x6d, /* l(");..    docum */ \
	0x65,0x6e,0x74,0x2e,0x77,0x72,0x69,0x74,0x65,0x28,0x69,0x29,0x3b,0x0d,0x0a,0x20, /* ent.write(i);..  */ \
	0x20,0x20,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x77,0x72,0x69,0x74, /*    document.writ */ \
	0x65,0x28,0x22,0x29,0x5c,0x22,0x3e,0x22,0x29,0x3b,0x0d,0x0a,0x20,0x20,0x20,0x20, /* e(")\">");..     */ \
	0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x77,0x72,0x69,0x74,0x65,0x28,0x22, /* document.write(" */ \
	0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x5c,0x22,0x62,0x75, /* <input type=\"bu */ \
	0x74,0x74,0x6f,0x6e,0x5c,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x5c,0x22,0x49, /* tton\" value=\"I */ \
	0x6e,0x73,0x5c,0x22,0x20,0x6f,0x6e,0x43,0x6c,0x69,0x63,0x6b,0x3d,0x5c,0x22,0x69, /* ns\" onClick=\"i */ \
	0x6e,0x73,0x28,0x22,0x29,0x3b,0x0d,0x0a,0x20,0x20,0x20,0x20,0x64,0x6f,0x63,0x75, /* ns(");..    docu */ \
	0x6d,0x65,0x6e,0x74,0x2e,0x77,0x72,0x69,0x74,0x65,0x28,0x69,0x29,0x3b,0x0d,0x0a, /* ment.write(i);.. */ \
	0x20,0x20,0x20,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x77,0x72,0x69, /*     document.wri */ \
	0x74,0x65,0x28,0x22,0x29,0x5c,0x22,0x3e,0x22,0x29,0x3b,0x0d,0x0a,0x20,0x20,0x20, /* te(")\">");..    */ \
	0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x77,0x72,0x69,0x74,0x65,0x28, /*  document.write( */ \
	0x22,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x5c,0x22,0x62, /* "<input type=\"b */ \
	0x75,0x74,0x74,0x6f,0x6e,0x5c,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x5c,0x22, /* utton\" value=\" */ \
	0x45,0x64,0x69,0x74,0x5c,0x22,0x20,0x6f,0x6e,0x43,0x6c,0x69,0x63,0x6b,0x3d,0x5c, /* Edit\" onClick=\ */ \
	0x22,0x65,0x64,0x74,0x28,0x22,0x29,0x3b,0x0d,0x0a,0x20,0x20,0x20,0x20,0x64,0x6f, /* "edt(");..    do */ \
	0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x77,0x72,0x69,0x74,0x65,0x28,0x69,0x29,0x3b, /* cument.write(i); */ \
	0x0d,0x0a,0x20,0x20,0x20,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x77, /* ..    document.w */ \
	0x72,0x69,0x74,0x65,0x28,0x22,0x29,0x5c,0x22,0x3e,0x22,0x29,0x3b,0x0d,0x0a,0x20, /* rite(")\">");..  */ \
	0x20,0x20,0x20,0x69,0x66,0x20,0x28,0x69,0x20,0x3d,0x3d,0x20,0x28,0x6e,0x2d,0x31, /*    if (i == (n-1 */ \
	0x29,0x29,0x0d,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65, /* ))..      docume */ \
	0x6e,0x74,0x2e,0x77,0x72,0x69,0x74,0x65,0x28,0x22,0x3c,0x69,0x6e,0x70,0x75,0x74, /* nt.write("<input */ \
	0x20,0x74,0x79,0x70,0x65,0x3d,0x5c,0x22,0x62,0x75,0x74,0x74,0x6f,0x6e,0x5c,0x22, /*  type=\"button\" */ \
	0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x5c,0x22,0x41,0x70,0x70,0x65,0x6e,0x64,0x5c, /*  value=\"Append\ */ \
	0x22,0x20,0x6f,0x6e,0x43,0x6c,0x69,0x63,0x6b,0x3d,0x5c,0x22,0x61,0x64,0x64,0x28, /* " onClick=\"add( */ \
	0x29,0x5c,0x22,0x3e,0x22,0x29,0x3b,0x0d,0x0a,0x20,0x20,0x20,0x20,0x64,0x6f,0x63, /* )\">");..    doc */ \
	0x75,0x6d,0x65,0x6e,0x74,0x2e,0x77,0x72,0x69,0x74,0x65,0x28,0x22,0x3c,0x2f,0x74, /* ument.write("</t */ \
	0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x22,0x29,0x3b,0x0d,0x0a,0x20,0x20,0x7d,0x0d, /* d></tr>");..  }. */ \
	0x0a,0x20,0x7d,0x20,0x65,0x6c,0x73,0x65,0x20,0x7b,0x0d,0x0a,0x20,0x20,0x64,0x6f, /* . } else {..  do */ \
	0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x77,0x72,0x69,0x74,0x65,0x28,0x22,0x3c,0x74, /* cument.write("<t */ \
	0x72,0x3e,0x3c,0x74,0x64,0x3e,0x4e,0x6f,0x20,0x45,0x6e,0x74,0x72,0x79,0x20,0x28, /* r><td>No Entry ( */ \
	0x4e,0x6f,0x20,0x41,0x63,0x63,0x65,0x73,0x73,0x20,0x66,0x69,0x6c,0x65,0x29,0x3c, /* No Access file)< */ \
	0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x22,0x29,0x3b,0x0d,0x0a,0x20,0x7d, /* /td></tr>");.. } */ \
	0x0d,0x0a,0x2f,0x2f,0x20,0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69, /* ..// -->..</scri */ \
	0x70,0x74,0x3e,0x0d,0x0a,0x3c,0x2f,0x74,0x61,0x62,0x6c,0x65,0x3e,0x0d,0x0a,0x3c, /* pt>..</table>..< */ \
	0x62,0x72,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69, /* br>..</div>..<di */ \
	0x76,0x20,0x69,0x64,0x3d,0x22,0x53,0x41,0x56,0x45,0x22,0x3e,0x0d,0x0a,0x26,0x6e, /* v id="SAVE">..&n */ \
	0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x69,0x6e,0x70,0x75,0x74, /* bsp;&nbsp;<input */ \
	0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x62,0x75,0x74,0x74,0x6f,0x6e,0x22,0x20,0x76, /*  type="button" v */ \
	0x61,0x6c,0x75,0x65,0x3d,0x22,0x43,0x61,0x6e,0x63,0x65,0x6c,0x22,0x20,0x6f,0x6e, /* alue="Cancel" on */ \
	0x43,0x6c,0x69,0x63,0x6b,0x3d,0x22,0x63,0x61,0x6e,0x63,0x65,0x6c,0x28,0x29,0x22, /* Click="cancel()" */ \
	0x3e,0x20,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x62, /* > <input type="b */ \
	0x75,0x74,0x74,0x6f,0x6e,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x43,0x6c, /* utton" value="Cl */ \
	0x6f,0x73,0x65,0x22,0x20,0x6f,0x6e,0x43,0x6c,0x69,0x63,0x6b,0x3d,0x22,0x77,0x69, /* ose" onClick="wi */ \
	0x6e,0x64,0x6f,0x77,0x2e,0x63,0x6c,0x6f,0x73,0x65,0x28,0x29,0x22,0x3e,0x20,0x3c, /* ndow.close()"> < */ \
	0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x73,0x75,0x62,0x6d, /* input type="subm */ \
	0x69,0x74,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x53,0x61,0x76,0x65,0x22, /* it" value="Save" */ \
	0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20, /* >..</div>..<div  */ \
	0x69,0x64,0x3d,0x22,0x46,0x49,0x52,0x53,0x54,0x22,0x3e,0x0d,0x0a,0x26,0x6e,0x62, /* id="FIRST">..&nb */ \
	0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20, /* sp;&nbsp;<input  */ \
	0x74,0x79,0x70,0x65,0x3d,0x22,0x62,0x75,0x74,0x74,0x6f,0x6e,0x22,0x20,0x76,0x61, /* type="button" va */ \
	0x6c,0x75,0x65,0x3d,0x22,0x43,0x61,0x6e,0x63,0x65,0x6c,0x22,0x20,0x6f,0x6e,0x43, /* lue="Cancel" onC */ \
	0x6c,0x69,0x63,0x6b,0x3d,0x22,0x63,0x61,0x6e,0x63,0x65,0x6c,0x28,0x29,0x22,0x3e, /* lick="cancel()"> */ \
	0x20,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x62,0x75, /*  <input type="bu */ \
	0x74,0x74,0x6f,0x6e,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x43,0x6c,0x6f  /* tton" value="Clo */
#define DATACHUNK000029 \
	0x73,0x65,0x22,0x20,0x6f,0x6e,0x43,0x6c,0x69,0x63,0x6b,0x3d,0x22,0x77,0x69,0x6e, /* se" onClick="win */ \
	0x64,0x6f,0x77,0x2e,0x63,0x6c,0x6f,0x73,0x65,0x28,0x29,0x22,0x3e,0x0d,0x0a,0x3c, /* dow.close()">..< */ \
	0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x62,0x72,0x3e,0x0d,0x0a,0x3c,0x64,0x69, /* /div>..<br>..<di */ \
	0x76,0x20,0x69,0x64,0x3d,0x22,0x41,0x44,0x44,0x22,0x3e,0x0d,0x0a,0x26,0x6e,0x62, /* v id="ADD">..&nb */ \
	0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20, /* sp;&nbsp;<input  */ \
	0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65, /* type="text" name */ \
	0x3d,0x22,0x63,0x61,0x6c,0x6c,0x73,0x22,0x3e,0x0d,0x0a,0x3c,0x73,0x65,0x6c,0x65, /* ="calls">..<sele */ \
	0x63,0x74,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x61,0x63,0x63,0x65,0x73,0x22,0x3e, /* ct name="acces"> */ \
	0x0d,0x0a,0x3c,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d, /* ..<option value= */ \
	0x22,0x41,0x4c,0x4c,0x4f,0x57,0x22,0x3e,0x41,0x4c,0x4c,0x4f,0x57,0x0d,0x0a,0x3c, /* "ALLOW">ALLOW..< */ \
	0x6f,0x70,0x74,0x69,0x6f,0x6e,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x44,0x45, /* option value="DE */ \
	0x4e,0x59,0x22,0x3e,0x44,0x45,0x4e,0x59,0x0d,0x0a,0x3c,0x2f,0x73,0x65,0x6c,0x65, /* NY">DENY..</sele */ \
	0x63,0x74,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65, /* ct>..<input type */ \
	0x3d,0x22,0x62,0x75,0x74,0x74,0x6f,0x6e,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d, /* ="button" value= */ \
	0x22,0x49,0x6e,0x73,0x65,0x72,0x74,0x2f,0x41,0x70,0x70,0x65,0x6e,0x64,0x22,0x20, /* "Insert/Append"  */ \
	0x6f,0x6e,0x43,0x6c,0x69,0x63,0x6b,0x3d,0x22,0x69,0x6e,0x73,0x65,0x72,0x74,0x28, /* onClick="insert( */ \
	0x29,0x22,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65, /* )">..<input type */ \
	0x3d,0x22,0x62,0x75,0x74,0x74,0x6f,0x6e,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d, /* ="button" value= */ \
	0x22,0x43,0x61,0x6e,0x63,0x65,0x6c,0x22,0x20,0x6f,0x6e,0x43,0x6c,0x69,0x63,0x6b, /* "Cancel" onClick */ \
	0x3d,0x22,0x63,0x61,0x6e,0x63,0x65,0x6c,0x28,0x29,0x22,0x3e,0x0d,0x0a,0x3c,0x2f, /* ="cancel()">..</ */ \
	0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d, /* div>....<div id= */ \
	0x22,0x45,0x44,0x49,0x54,0x22,0x3e,0x0d,0x0a,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26, /* "EDIT">..&nbsp;& */ \
	0x6e,0x62,0x73,0x70,0x3b,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65, /* nbsp;<input type */ \
	0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x63,0x61, /* ="text" name="ca */ \
	0x6c,0x6c,0x65,0x22,0x3e,0x0d,0x0a,0x3c,0x73,0x65,0x6c,0x65,0x63,0x74,0x20,0x6e, /* lle">..<select n */ \
	0x61,0x6d,0x65,0x3d,0x22,0x61,0x63,0x63,0x65,0x65,0x22,0x3e,0x0d,0x0a,0x3c,0x6f, /* ame="accee">..<o */ \
	0x70,0x74,0x69,0x6f,0x6e,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x41,0x4c,0x4c, /* ption value="ALL */ \
	0x4f,0x57,0x22,0x3e,0x41,0x4c,0x4c,0x4f,0x57,0x0d,0x0a,0x3c,0x6f,0x70,0x74,0x69, /* OW">ALLOW..<opti */ \
	0x6f,0x6e,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x44,0x45,0x4e,0x59,0x22,0x3e, /* on value="DENY"> */ \
	0x44,0x45,0x4e,0x59,0x0d,0x0a,0x3c,0x2f,0x73,0x65,0x6c,0x65,0x63,0x74,0x3e,0x0d, /* DENY..</select>. */ \
	0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x62,0x75, /* .<input type="bu */ \
	0x74,0x74,0x6f,0x6e,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x52,0x65,0x70, /* tton" value="Rep */ \
	0x6c,0x61,0x63,0x65,0x22,0x20,0x6f,0x6e,0x43,0x6c,0x69,0x63,0x6b,0x3d,0x22,0x72, /* lace" onClick="r */ \
	0x65,0x70,0x28,0x29,0x22,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74, /* ep()">..<input t */ \
	0x79,0x70,0x65,0x3d,0x22,0x62,0x75,0x74,0x74,0x6f,0x6e,0x22,0x20,0x76,0x61,0x6c, /* ype="button" val */ \
	0x75,0x65,0x3d,0x22,0x43,0x61,0x6e,0x63,0x65,0x6c,0x22,0x20,0x6f,0x6e,0x43,0x6c, /* ue="Cancel" onCl */ \
	0x69,0x63,0x6b,0x3d,0x22,0x63,0x61,0x6e,0x63,0x65,0x6c,0x28,0x29,0x22,0x3e,0x0d, /* ick="cancel()">. */ \
	0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x68,0x69, /* .<input type="hi */ \
	0x64,0x64,0x65,0x6e,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x70,0x6f,0x73,0x69, /* dden" name="posi */ \
	0x74,0x69,0x6f,0x6e,0x22,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a, /* tion">..</div>.. */ \
	0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x54,0x45,0x58,0x54,0x22, /* ..<div id="TEXT" */ \
	0x3e,0x0d,0x0a,0x3c,0x74,0x65,0x78,0x74,0x61,0x72,0x65,0x61,0x20,0x6e,0x61,0x6d, /* >..<textarea nam */ \
	0x65,0x3d,0x22,0x61,0x63,0x63,0x74,0x22,0x20,0x63,0x6f,0x6c,0x73,0x3d,0x22,0x35, /* e="acct" cols="5 */ \
	0x30,0x22,0x20,0x72,0x6f,0x77,0x73,0x3d,0x22,0x31,0x30,0x22,0x3e,0x0d,0x0a,0x3c, /* 0" rows="10">..< */ \
	0x2f,0x74,0x65,0x78,0x74,0x61,0x72,0x65,0x61,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69, /* /textarea>..</di */ \
	0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x74,0x79, /* v>....<script ty */ \
	0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x2f,0x6a,0x61,0x76,0x61,0x73,0x63,0x72, /* pe="text/javascr */ \
	0x69,0x70,0x74,0x22,0x20,0x6c,0x61,0x6e,0x67,0x75,0x61,0x67,0x65,0x3d,0x22,0x4a, /* ipt" language="J */ \
	0x61,0x76,0x61,0x53,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x0d,0x0a,0x3c,0x21,0x2d, /* avaScript">..<!- */ \
	0x2d,0x0d,0x0a,0x20,0x6e,0x20,0x3d,0x20,0x77,0x69,0x6e,0x64,0x6f,0x77,0x2e,0x6f, /* -.. n = window.o */ \
	0x70,0x65,0x6e,0x65,0x72,0x2e,0x63,0x61,0x6c,0x6c,0x73,0x69,0x67,0x6e,0x2e,0x6c, /* pener.callsign.l */ \
	0x65,0x6e,0x67,0x74,0x68,0x3b,0x0d,0x0a,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e, /* ength;.. documen */ \
	0x74,0x2e,0x65,0x64,0x69,0x74,0x2e,0x61,0x63,0x63,0x74,0x2e,0x76,0x61,0x6c,0x75, /* t.edit.acct.valu */ \
	0x65,0x20,0x3d,0x20,0x22,0x22,0x3b,0x0d,0x0a,0x20,0x66,0x6f,0x72,0x20,0x28,0x69, /* e = "";.. for (i */ \
	0x20,0x3d,0x20,0x30,0x20,0x3b,0x20,0x69,0x20,0x3c,0x20,0x6e,0x20,0x3b,0x20,0x69, /*  = 0 ; i < n ; i */ \
	0x2b,0x2b,0x29,0x0d,0x0a,0x20,0x7b,0x0d,0x0a,0x20,0x20,0x20,0x64,0x6f,0x63,0x75, /* ++).. {..   docu */ \
	0x6d,0x65,0x6e,0x74,0x2e,0x65,0x64,0x69,0x74,0x2e,0x61,0x63,0x63,0x74,0x2e,0x76, /* ment.edit.acct.v */ \
	0x61,0x6c,0x75,0x65,0x20,0x2b,0x3d,0x20,0x20,0x77,0x69,0x6e,0x64,0x6f,0x77,0x2e, /* alue +=  window. */ \
	0x6f,0x70,0x65,0x6e,0x65,0x72,0x2e,0x63,0x61,0x6c,0x6c,0x73,0x69,0x67,0x6e,0x5b, /* opener.callsign[ */ \
	0x69,0x5d,0x3b,0x0d,0x0a,0x20,0x20,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74, /* i];..   document */ \
	0x2e,0x65,0x64,0x69,0x74,0x2e,0x61,0x63,0x63,0x74,0x2e,0x76,0x61,0x6c,0x75,0x65, /* .edit.acct.value */ \
	0x20,0x2b,0x3d,0x20,0x20,0x22,0x2c,0x22,0x3b,0x0d,0x0a,0x20,0x20,0x20,0x64,0x6f, /*  +=  ",";..   do */ \
	0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x65,0x64,0x69,0x74,0x2e,0x61,0x63,0x63,0x74, /* cument.edit.acct */ \
	0x2e,0x76,0x61,0x6c,0x75,0x65,0x20,0x2b,0x3d,0x20,0x20,0x77,0x69,0x6e,0x64,0x6f  /* .value +=  windo */
#define DATACHUNK00002a \
	0x77,0x2e,0x6f,0x70,0x65,0x6e,0x65,0x72,0x2e,0x61,0x63,0x63,0x65,0x73,0x73,0x5b, /* w.opener.access[ */ \
	0x69,0x5d,0x3b,0x0d,0x0a,0x20,0x20,0x20,0x69,0x66,0x20,0x28,0x69,0x20,0x21,0x3d, /* i];..   if (i != */ \
	0x20,0x28,0x6e,0x2d,0x31,0x29,0x29,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74, /*  (n-1)) document */ \
	0x2e,0x65,0x64,0x69,0x74,0x2e,0x61,0x63,0x63,0x74,0x2e,0x76,0x61,0x6c,0x75,0x65, /* .edit.acct.value */ \
	0x20,0x2b,0x3d,0x20,0x20,0x22,0x2c,0x22,0x3b,0x0d,0x0a,0x20,0x20,0x20,0x65,0x6c, /*  +=  ",";..   el */ \
	0x73,0x65,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x65,0x64,0x69,0x74, /* se document.edit */ \
	0x2e,0x61,0x63,0x63,0x74,0x2e,0x76,0x61,0x6c,0x75,0x65,0x20,0x2b,0x3d,0x20,0x20, /* .acct.value +=   */ \
	0x22,0x3b,0x22,0x3b,0x0d,0x0a,0x20,0x7d,0x0d,0x0a,0x64,0x6f,0x63,0x75,0x6d,0x65, /* ";";.. }..docume */ \
	0x6e,0x74,0x2e,0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49, /* nt.getElementByI */ \
	0x64,0x28,0x27,0x45,0x44,0x49,0x54,0x27,0x29,0x2e,0x73,0x74,0x79,0x6c,0x65,0x2e, /* d('EDIT').style. */ \
	0x64,0x69,0x73,0x70,0x6c,0x61,0x79,0x20,0x3d,0x20,0x27,0x6e,0x6f,0x6e,0x65,0x27, /* display = 'none' */ \
	0x3b,0x0d,0x0a,0x69,0x66,0x20,0x28,0x6e,0x20,0x3e,0x20,0x30,0x29,0x20,0x64,0x6f, /* ;..if (n > 0) do */ \
	0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e, /* cument.getElemen */ \
	0x74,0x42,0x79,0x49,0x64,0x28,0x27,0x41,0x44,0x44,0x27,0x29,0x2e,0x73,0x74,0x79, /* tById('ADD').sty */ \
	0x6c,0x65,0x2e,0x64,0x69,0x73,0x70,0x6c,0x61,0x79,0x20,0x3d,0x20,0x27,0x6e,0x6f, /* le.display = 'no */ \
	0x6e,0x65,0x27,0x3b,0x0d,0x0a,0x65,0x6c,0x73,0x65,0x0d,0x0a,0x7b,0x0d,0x0a,0x20, /* ne';..else..{..  */ \
	0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x67,0x65,0x74,0x45,0x6c,0x65, /*  document.getEle */ \
	0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28,0x27,0x41,0x44,0x44,0x27,0x29,0x2e, /* mentById('ADD'). */ \
	0x73,0x74,0x79,0x6c,0x65,0x2e,0x64,0x69,0x73,0x70,0x6c,0x61,0x79,0x20,0x3d,0x20, /* style.display =  */ \
	0x27,0x62,0x6c,0x6f,0x63,0x6b,0x27,0x3b,0x0d,0x0a,0x20,0x20,0x64,0x6f,0x63,0x75, /* 'block';..  docu */ \
	0x6d,0x65,0x6e,0x74,0x2e,0x65,0x64,0x69,0x74,0x2e,0x70,0x6f,0x73,0x69,0x74,0x69, /* ment.edit.positi */ \
	0x6f,0x6e,0x2e,0x76,0x61,0x6c,0x75,0x65,0x20,0x3d,0x20,0x2d,0x31,0x3b,0x0d,0x0a, /* on.value = -1;.. */ \
	0x7d,0x0d,0x0a,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x67,0x65,0x74,0x45, /* }..document.getE */ \
	0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28,0x27,0x54,0x45,0x58,0x54, /* lementById('TEXT */ \
	0x27,0x29,0x2e,0x73,0x74,0x79,0x6c,0x65,0x2e,0x64,0x69,0x73,0x70,0x6c,0x61,0x79, /* ').style.display */ \
	0x20,0x3d,0x20,0x27,0x6e,0x6f,0x6e,0x65,0x27,0x3b,0x0d,0x0a,0x69,0x66,0x20,0x28, /*  = 'none';..if ( */ \
	0x6e,0x20,0x3e,0x20,0x30,0x29,0x0d,0x0a,0x7b,0x0d,0x0a,0x20,0x64,0x6f,0x63,0x75, /* n > 0)..{.. docu */ \
	0x6d,0x65,0x6e,0x74,0x2e,0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42, /* ment.getElementB */ \
	0x79,0x49,0x64,0x28,0x27,0x46,0x49,0x52,0x53,0x54,0x27,0x29,0x2e,0x73,0x74,0x79, /* yId('FIRST').sty */ \
	0x6c,0x65,0x2e,0x64,0x69,0x73,0x70,0x6c,0x61,0x79,0x3d,0x22,0x6e,0x6f,0x6e,0x65, /* le.display="none */ \
	0x22,0x0d,0x0a,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x67,0x65,0x74, /* ".. document.get */ \
	0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28,0x27,0x53,0x41,0x56, /* ElementById('SAV */ \
	0x45,0x27,0x29,0x2e,0x73,0x74,0x79,0x6c,0x65,0x2e,0x64,0x69,0x73,0x70,0x6c,0x61, /* E').style.displa */ \
	0x79,0x3d,0x22,0x62,0x6c,0x6f,0x63,0x6b,0x22,0x0d,0x0a,0x7d,0x0d,0x0a,0x65,0x6c, /* y="block"..}..el */ \
	0x73,0x65,0x0d,0x0a,0x7b,0x0d,0x0a,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74, /* se..{.. document */ \
	0x2e,0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28, /* .getElementById( */ \
	0x27,0x46,0x49,0x52,0x53,0x54,0x27,0x29,0x2e,0x73,0x74,0x79,0x6c,0x65,0x2e,0x64, /* 'FIRST').style.d */ \
	0x69,0x73,0x70,0x6c,0x61,0x79,0x3d,0x22,0x62,0x6c,0x6f,0x63,0x6b,0x22,0x0d,0x0a, /* isplay="block".. */ \
	0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x67,0x65,0x74,0x45,0x6c,0x65, /*  document.getEle */ \
	0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28,0x27,0x53,0x41,0x56,0x45,0x27,0x29, /* mentById('SAVE') */ \
	0x2e,0x73,0x74,0x79,0x6c,0x65,0x2e,0x64,0x69,0x73,0x70,0x6c,0x61,0x79,0x3d,0x22, /* .style.display=" */ \
	0x6e,0x6f,0x6e,0x65,0x22,0x0d,0x0a,0x7d,0x0d,0x0a,0x2f,0x2f,0x20,0x2d,0x2d,0x3e, /* none"..}..// --> */ \
	0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74,0x3e,0x0d,0x0a,0x3c,0x2f,0x66, /* ..</script>..</f */ \
	0x6f,0x72,0x6d,0x3e,0x0d,0x0a,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f, /* orm>....~inc:foo */ \
	0x74,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00, /* ter.inc~....3... */ \
	0x5d,0x13,0x00,0x00,0x02,0x00,0x00,0x00,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61, /* ].......~inc:hea */ \
	0x64,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69, /* der.inc~..<div i */ \
	0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a, /* d="content">.... */ \
	0x3c,0x68,0x31,0x3e,0x47,0x61,0x74,0x65,0x77,0x61,0x79,0x20,0x41,0x75,0x74,0x68, /* <h1>Gateway Auth */ \
	0x20,0x43,0x61,0x6c,0x6c,0x73,0x69,0x67,0x6e,0x3c,0x2f,0x68,0x31,0x3e,0x0d,0x0a, /*  Callsign</h1>.. */ \
	0x0d,0x0a,0x3c,0x66,0x6f,0x72,0x6d,0x20,0x6d,0x65,0x74,0x68,0x6f,0x64,0x3d,0x22, /* ..<form method=" */ \
	0x70,0x6f,0x73,0x74,0x22,0x20,0x61,0x63,0x74,0x69,0x6f,0x6e,0x3d,0x22,0x2f,0x70, /* post" action="/p */ \
	0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x67,0x61,0x74,0x65,0x77,0x61,0x79,0x61,0x75, /* rotect/gatewayau */ \
	0x74,0x68,0x2e,0x68,0x74,0x6d,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x61,0x75, /* th.htm" name="au */ \
	0x74,0x68,0x22,0x3e,0x0d,0x0a,0x3c,0x66,0x69,0x65,0x6c,0x64,0x73,0x65,0x74,0x3e, /* th">..<fieldset> */ \
	0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x4e,0x6f, /* ..<div><label>No */ \
	0x64,0x65,0x20,0x43,0x61,0x6c,0x6c,0x73,0x69,0x67,0x6e,0x3a,0x3c,0x2f,0x6c,0x61, /* de Callsign:</la */ \
	0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70, /* bel>..<input typ */ \
	0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6e, /* e="text" name="n */ \
	0x6f,0x64,0x65,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22, /* ode" class="ad1" */ \
	0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x31,0x30,0x22,0x20,0x76,0x61,0x6c,0x75,0x65, /*  size="10" value */ \
	0x3d,0x22,0x7e,0x4e,0x6f,0x64,0x65,0x4e,0x61,0x6d,0x65,0x7e,0x22,0x20,0x2f,0x3e, /* ="~NodeName~" /> */ \
	0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61, /* </div>..<div><la */ \
	0x62,0x65,0x6c,0x3e,0x41,0x75,0x74,0x68,0x20,0x43,0x61,0x6c,0x6c,0x73,0x69,0x67  /* bel>Auth Callsig */
#define DATACHUNK00002b \
	0x6e,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70, /* n:</label>..<inp */ \
	0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e, /* ut type="text" n */ \
	0x61,0x6d,0x65,0x3d,0x22,0x61,0x75,0x74,0x68,0x22,0x20,0x63,0x6c,0x61,0x73,0x73, /* ame="auth" class */ \
	0x3d,0x22,0x61,0x64,0x31,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x31,0x30,0x22, /* ="ad1" size="10" */ \
	0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x61,0x75,0x74,0x68,0x5f,0x63,0x61, /*  value="~auth_ca */ \
	0x6c,0x6c,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c, /* ll~" /></div>..< */ \
	0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x50,0x49,0x4e,0x3a,0x3c, /* div><label>PIN:< */ \
	0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20, /* /label>..<input  */ \
	0x74,0x79,0x70,0x65,0x3d,0x22,0x70,0x69,0x6e,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d, /* type="pin" name= */ \
	0x22,0x70,0x69,0x6e,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31, /* "pin" class="ad1 */ \
	0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x31,0x30,0x22,0x20,0x76,0x61,0x6c,0x75, /* " size="10" valu */ \
	0x65,0x3d,0x22,0x7e,0x70,0x69,0x6e,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69, /* e="~pin~" /></di */ \
	0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20, /* v>..<div><input  */ \
	0x74,0x79,0x70,0x65,0x3d,0x22,0x62,0x75,0x74,0x74,0x6f,0x6e,0x22,0x20,0x20,0x63, /* type="button"  c */ \
	0x6c,0x61,0x73,0x73,0x3d,0x22,0x73,0x6d,0x22,0x20,0x20,0x76,0x61,0x6c,0x75,0x65, /* lass="sm"  value */ \
	0x3d,0x22,0x53,0x61,0x76,0x65,0x20,0x41,0x75,0x74,0x68,0x20,0x43,0x61,0x6c,0x6c, /* ="Save Auth Call */ \
	0x20,0x26,0x20,0x50,0x49,0x4e,0x22,0x20,0x6f,0x6e,0x43,0x6c,0x69,0x63,0x6b,0x3d, /*  & PIN" onClick= */ \
	0x22,0x43,0x68,0x65,0x63,0x6b,0x46,0x69,0x65,0x6c,0x64,0x28,0x29,0x22,0x2f,0x3e, /* "CheckField()"/> */ \
	0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x69,0x65,0x6c,0x64,0x73, /* </div>..</fields */ \
	0x65,0x74,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x6f,0x72,0x6d,0x3e,0x0d,0x0a,0x3c,0x2f, /* et>..</form>..</ */ \
	0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20, /* div>....<script  */ \
	0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x2f,0x6a,0x61,0x76,0x61,0x73, /* type="text/javas */ \
	0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x0d,0x0a,0x3c,0x21,0x2d,0x2d,0x0d,0x0a,0x66, /* cript">..<!--..f */ \
	0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x20,0x43,0x68,0x65,0x63,0x6b,0x46,0x69,0x65, /* unction CheckFie */ \
	0x6c,0x64,0x28,0x29,0x0d,0x0a,0x7b,0x0d,0x0a,0x20,0x20,0x69,0x66,0x20,0x28,0x64, /* ld()..{..  if (d */ \
	0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x66,0x6f,0x72,0x6d,0x73,0x2e,0x61,0x75, /* ocument.forms.au */ \
	0x74,0x68,0x2e,0x6e,0x6f,0x64,0x65,0x2e,0x76,0x61,0x6c,0x75,0x65,0x2e,0x6c,0x65, /* th.node.value.le */ \
	0x6e,0x67,0x74,0x68,0x20,0x3d,0x3d,0x20,0x30,0x29,0x0d,0x0a,0x20,0x20,0x7b,0x0d, /* ngth == 0)..  {. */ \
	0x0a,0x20,0x20,0x20,0x20,0x77,0x69,0x6e,0x64,0x6f,0x77,0x2e,0x61,0x6c,0x65,0x72, /* .    window.aler */ \
	0x74,0x28,0x22,0x4e,0x6f,0x64,0x65,0x20,0x43,0x61,0x6c,0x6c,0x53,0x69,0x67,0x6e, /* t("Node CallSign */ \
	0x20,0x69,0x73,0x20,0x65,0x6d,0x70,0x74,0x79,0x21,0x22,0x29,0x3b,0x0d,0x0a,0x20, /*  is empty!");..  */ \
	0x20,0x20,0x20,0x72,0x65,0x74,0x75,0x72,0x6e,0x3b,0x0d,0x0a,0x20,0x20,0x7d,0x0d, /*    return;..  }. */ \
	0x0a,0x20,0x20,0x69,0x66,0x20,0x28,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e, /* .  if (document. */ \
	0x66,0x6f,0x72,0x6d,0x73,0x2e,0x61,0x75,0x74,0x68,0x2e,0x61,0x75,0x74,0x68,0x2e, /* forms.auth.auth. */ \
	0x76,0x61,0x6c,0x75,0x65,0x2e,0x6c,0x65,0x6e,0x67,0x74,0x68,0x20,0x3d,0x3d,0x20, /* value.length ==  */ \
	0x30,0x29,0x0d,0x0a,0x20,0x20,0x7b,0x0d,0x0a,0x20,0x20,0x20,0x20,0x77,0x69,0x6e, /* 0)..  {..    win */ \
	0x64,0x6f,0x77,0x2e,0x61,0x6c,0x65,0x72,0x74,0x28,0x22,0x41,0x75,0x74,0x68,0x2e, /* dow.alert("Auth. */ \
	0x20,0x43,0x61,0x6c,0x6c,0x53,0x69,0x67,0x6e,0x20,0x69,0x73,0x20,0x65,0x6d,0x70, /*  CallSign is emp */ \
	0x74,0x79,0x21,0x22,0x29,0x3b,0x0d,0x0a,0x20,0x20,0x20,0x20,0x72,0x65,0x74,0x75, /* ty!");..    retu */ \
	0x72,0x6e,0x3b,0x0d,0x0a,0x20,0x20,0x7d,0x0d,0x0a,0x20,0x20,0x20,0x20,0x20,0x64, /* rn;..  }..     d */ \
	0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x66,0x6f,0x72,0x6d,0x73,0x2e,0x61,0x75, /* ocument.forms.au */ \
	0x74,0x68,0x2e,0x73,0x75,0x62,0x6d,0x69,0x74,0x28,0x29,0x3b,0x20,0x0d,0x0a,0x7d, /* th.submit(); ..} */ \
	0x0d,0x0a,0x2f,0x2f,0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70, /* ..//-->..</scrip */ \
	0x74,0x3e,0x0d,0x0a,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65, /* t>....~inc:foote */ \
	0x72,0x2e,0x69,0x6e,0x63,0x7e,0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0xfa,0x00, /* r.inc~....3..... */ \
	0x00,0x00,0x4e,0x00,0x00,0x00,0x70,0x01,0x00,0x00,0x8b,0x00,0x00,0x00,0xdb,0x01, /* ..N...p......... */ \
	0x00,0x00,0x8c,0x00,0x00,0x00,0xde,0x03,0x00,0x00,0x02,0x00,0x00,0x00,0x7e,0x69, /* ..............~i */ \
	0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0a,0x3c, /* nc:header.inc~.< */ \
	0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x22, /* div id="content" */ \
	0x3e,0x0a,0x0a,0x3c,0x68,0x31,0x3e,0x4c,0x6f,0x67,0x69,0x6e,0x20,0x53,0x75,0x63, /* >..<h1>Login Suc */ \
	0x63,0x65,0x73,0x73,0x66,0x75,0x6c,0x3c,0x2f,0x68,0x31,0x3e,0x0a,0x0a,0x3c,0x70, /* cessful</h1>..<p */ \
	0x3e,0x59,0x6f,0x75,0x20,0x68,0x61,0x76,0x65,0x20,0x73,0x75,0x63,0x63,0x65,0x73, /* >You have succes */ \
	0x73,0x66,0x75,0x6c,0x6c,0x79,0x20,0x6c,0x6f,0x67,0x67,0x65,0x64,0x20,0x69,0x6e, /* sfully logged in */ \
	0x20,0x74,0x6f,0x20,0x74,0x68,0x65,0x20,0x77,0x65,0x62,0x20,0x73,0x65,0x72,0x76, /*  to the web serv */ \
	0x65,0x72,0x2e,0x20,0x20,0x54,0x68,0x69,0x73,0x20,0x61,0x75,0x74,0x68,0x65,0x6e, /* er.  This authen */ \
	0x74,0x69,0x63,0x61,0x74,0x69,0x6f,0x6e,0x20,0x0a,0x69,0x73,0x20,0x76,0x61,0x6c, /* tication .is val */ \
	0x69,0x64,0x20,0x75,0x6e,0x74,0x69,0x6c,0x20,0x79,0x6f,0x75,0x20,0x63,0x6c,0x6f, /* id until you clo */ \
	0x73,0x65,0x20,0x79,0x6f,0x75,0x72,0x20,0x62,0x72,0x6f,0x77,0x73,0x65,0x72,0x2e, /* se your browser. */ \
	0x3c,0x2f,0x70,0x3e,0x0a,0x0a,0x3c,0x70,0x3e,0x43,0x72,0x65,0x64,0x65,0x6e,0x74, /* </p>..<p>Credent */ \
	0x69,0x61,0x6c,0x73,0x20,0x61,0x72,0x65,0x20,0x76,0x65,0x72,0x69,0x66,0x69,0x65, /* ials are verifie */ \
	0x64,0x20,0x69,0x6e,0x20,0x79,0x6f,0x75,0x72,0x20,0x6f,0x77,0x6e,0x20,0x63,0x75, /* d in your own cu */ \
	0x73,0x74,0x6f,0x6d,0x20,0x63,0x61,0x6c,0x6c,0x62,0x61,0x63,0x6b,0x20,0x66,0x75, /* stom callback fu */ \
	0x6e,0x63,0x74,0x69,0x6f,0x6e,0x20,0x63,0x61,0x6c,0x6c,0x65,0x64,0x20,0x0a,0x3c, /* nction called .< */ \
	0x63,0x6f,0x64,0x65,0x3e,0x48,0x54,0x54,0x50,0x41,0x75,0x74,0x68,0x65,0x6e,0x74  /* code>HTTPAuthent */
#define DATACHUNK00002c \
	0x69,0x63,0x61,0x74,0x65,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x2e,0x20,0x20,0x49, /* icate</code>.  I */ \
	0x6e,0x20,0x68,0x65,0x72,0x65,0x2c,0x20,0x79,0x6f,0x75,0x20,0x63,0x61,0x6e,0x20, /* n here, you can  */ \
	0x64,0x65,0x74,0x65,0x72,0x6d,0x69,0x6e,0x65,0x20,0x69,0x66,0x20,0x74,0x68,0x65, /* determine if the */ \
	0x20,0x73,0x75,0x70,0x70,0x6c,0x69,0x65,0x64,0x0a,0x75,0x73,0x65,0x72,0x20,0x6e, /*  supplied.user n */ \
	0x61,0x6d,0x65,0x20,0x61,0x6e,0x64,0x20,0x70,0x61,0x73,0x73,0x77,0x6f,0x72,0x64, /* ame and password */ \
	0x20,0x61,0x72,0x65,0x20,0x76,0x61,0x6c,0x69,0x64,0x20,0x66,0x6f,0x72,0x20,0x61, /*  are valid for a */ \
	0x63,0x63,0x65,0x73,0x73,0x20,0x74,0x6f,0x20,0x74,0x68,0x65,0x20,0x72,0x65,0x71, /* ccess to the req */ \
	0x75,0x65,0x73,0x74,0x65,0x64,0x20,0x70,0x61,0x67,0x65,0x2e,0x20,0x20,0x59,0x6f, /* uested page.  Yo */ \
	0x75,0x20,0x63,0x61,0x6e,0x20,0x0a,0x61,0x64,0x64,0x20,0x6d,0x75,0x6c,0x74,0x69, /* u can .add multi */ \
	0x70,0x6c,0x65,0x20,0x75,0x73,0x65,0x72,0x73,0x20,0x61,0x6e,0x64,0x20,0x72,0x65, /* ple users and re */ \
	0x73,0x74,0x72,0x69,0x63,0x74,0x20,0x64,0x69,0x66,0x66,0x65,0x72,0x65,0x6e,0x74, /* strict different */ \
	0x20,0x75,0x73,0x65,0x72,0x73,0x20,0x74,0x6f,0x20,0x64,0x69,0x66,0x66,0x65,0x72, /*  users to differ */ \
	0x65,0x6e,0x74,0x20,0x70,0x61,0x67,0x65,0x73,0x2e,0x3c,0x2f,0x70,0x3e,0x0a,0x0a, /* ent pages.</p>.. */ \
	0x3c,0x70,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x65,0x78,0x65,0x72,0x63,0x69, /* <p class="exerci */ \
	0x73,0x65,0x22,0x3e,0x3c,0x62,0x3e,0x45,0x78,0x65,0x72,0x63,0x69,0x73,0x65,0x3a, /* se"><b>Exercise: */ \
	0x3c,0x2f,0x62,0x3e,0x20,0x43,0x68,0x61,0x6e,0x67,0x65,0x20,0x74,0x68,0x65,0x20, /* </b> Change the  */ \
	0x75,0x73,0x65,0x72,0x20,0x6e,0x61,0x6d,0x65,0x20,0x61,0x6e,0x64,0x20,0x70,0x61, /* user name and pa */ \
	0x73,0x73,0x77,0x6f,0x72,0x64,0x20,0x69,0x6e,0x0a,0x3c,0x63,0x6f,0x64,0x65,0x3e, /* ssword in.<code> */ \
	0x48,0x54,0x54,0x50,0x41,0x75,0x74,0x68,0x65,0x6e,0x74,0x69,0x63,0x61,0x74,0x65, /* HTTPAuthenticate */ \
	0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x20,0x74,0x6f,0x20,0x6f,0x6e,0x65,0x20,0x6f, /* </code> to one o */ \
	0x66,0x20,0x79,0x6f,0x75,0x72,0x20,0x63,0x68,0x6f,0x6f,0x73,0x69,0x6e,0x67,0x2e, /* f your choosing. */ \
	0x20,0x20,0x28,0x54,0x68,0x65,0x20,0x63,0x61,0x6c,0x6c,0x62,0x61,0x63,0x6b,0x20, /*   (The callback  */ \
	0x69,0x73,0x20,0x0a,0x6c,0x6f,0x63,0x61,0x74,0x65,0x64,0x20,0x69,0x6e,0x20,0x3c, /* is .located in < */ \
	0x63,0x6f,0x64,0x65,0x3e,0x43,0x75,0x73,0x74,0x6f,0x6d,0x48,0x54,0x54,0x50,0x41, /* code>CustomHTTPA */ \
	0x70,0x70,0x2e,0x63,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x2e,0x29,0x3c,0x2f,0x70, /* pp.c</code>.)</p */ \
	0x3e,0x0a,0x0a,0x3c,0x64,0x69,0x76,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x65, /* >..<div class="e */ \
	0x78,0x61,0x6d,0x70,0x6c,0x65,0x62,0x6f,0x78,0x22,0x3e,0x0a,0x57,0x68,0x65,0x6e, /* xamplebox">.When */ \
	0x20,0x79,0x6f,0x75,0x20,0x66,0x69,0x6e,0x69,0x73,0x68,0x2c,0x20,0x72,0x65,0x66, /*  you finish, ref */ \
	0x72,0x65,0x73,0x68,0x20,0x74,0x68,0x69,0x73,0x20,0x70,0x61,0x67,0x65,0x20,0x74, /* resh this page t */ \
	0x6f,0x20,0x74,0x65,0x73,0x74,0x20,0x79,0x6f,0x75,0x72,0x20,0x6e,0x65,0x77,0x20, /* o test your new  */ \
	0x75,0x73,0x65,0x72,0x20,0x6e,0x61,0x6d,0x65,0x20,0x61,0x6e,0x64,0x20,0x70,0x61, /* user name and pa */ \
	0x73,0x73,0x77,0x6f,0x72,0x64,0x20,0x0a,0x63,0x6f,0x6d,0x62,0x69,0x6e,0x61,0x74, /* ssword .combinat */ \
	0x69,0x6f,0x6e,0x2e,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0a,0x0a,0x3c,0x2f,0x64, /* ion..</div>..</d */ \
	0x69,0x76,0x3e,0x0a,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x74,0x79,0x70, /* iv>..<script typ */ \
	0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x2f,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69, /* e="text/javascri */ \
	0x70,0x74,0x22,0x3e,0x0a,0x3c,0x21,0x2d,0x2d,0x0a,0x64,0x6f,0x63,0x75,0x6d,0x65, /* pt">.<!--.docume */ \
	0x6e,0x74,0x2e,0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49, /* nt.getElementByI */ \
	0x64,0x28,0x27,0x68,0x65,0x6c,0x6c,0x6f,0x27,0x29,0x2e,0x69,0x6e,0x6e,0x65,0x72, /* d('hello').inner */ \
	0x48,0x54,0x4d,0x4c,0x20,0x3d,0x20,0x22,0x7e,0x68,0x65,0x6c,0x6c,0x6f,0x6d,0x73, /* HTML = "~helloms */ \
	0x67,0x7e,0x22,0x3b,0x0a,0x2f,0x2f,0x2d,0x2d,0x3e,0x0a,0x3c,0x2f,0x73,0x63,0x72, /* g~";.//-->.</scr */ \
	0x69,0x70,0x74,0x3e,0x0a,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65, /* ipt>..~inc:foote */ \
	0x72,0x2e,0x69,0x6e,0x63,0x7e,0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0x7a,0x03, /* r.inc~....3...z. */ \
	0x00,0x00,0x01,0x00,0x00,0x00,0x98,0x03,0x00,0x00,0x02,0x00,0x00,0x00,0x7e,0x72, /* ..............~r */ \
	0x65,0x62,0x6f,0x6f,0x74,0x7e,0x00,0x00,0x00,0x00,0x2d,0x00,0x00,0x00,0x7e,0x69, /* eboot~....-...~i */ \
	0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a, /* nc:header.inc~.. */ \
	0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74, /* <div id="content */ \
	0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x52,0x65,0x62,0x6f,0x6f,0x74, /* ">....<h1>Reboot */ \
	0x20,0x49,0x6e,0x20,0x50,0x72,0x6f,0x67,0x72,0x65,0x73,0x73,0x2e,0x2e,0x2e,0x3c, /*  In Progress...< */ \
	0x2f,0x68,0x31,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x3e,0x59,0x6f,0x75,0x72,0x20, /* /h1>....<p>Your  */ \
	0x73,0x65,0x74,0x74,0x69,0x6e,0x67,0x73,0x20,0x77,0x65,0x72,0x65,0x20,0x73,0x75, /* settings were su */ \
	0x63,0x63,0x65,0x73,0x73,0x66,0x75,0x6c,0x6c,0x79,0x20,0x73,0x61,0x76,0x65,0x64, /* ccessfully saved */ \
	0x2c,0x20,0x61,0x6e,0x64,0x20,0x74,0x68,0x65,0x20,0x62,0x6f,0x61,0x72,0x64,0x20, /* , and the board  */ \
	0x69,0x73,0x20,0x6e,0x6f,0x77,0x20,0x72,0x65,0x62,0x6f,0x6f,0x74,0x69,0x6e,0x67, /* is now rebooting */ \
	0x20,0x0d,0x0a,0x74,0x6f,0x20,0x63,0x6f,0x6e,0x66,0x69,0x67,0x75,0x72,0x65,0x20, /*  ..to configure  */ \
	0x69,0x74,0x73,0x65,0x6c,0x66,0x20,0x77,0x69,0x74,0x68,0x20,0x74,0x68,0x65,0x20, /* itself with the  */ \
	0x6e,0x65,0x77,0x20,0x73,0x65,0x74,0x74,0x69,0x6e,0x67,0x73,0x2e,0x3c,0x2f,0x70, /* new settings.</p */ \
	0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x20,0x61,0x6c,0x69,0x67,0x6e,0x3d,0x22,0x63, /* >....<p align="c */ \
	0x65,0x6e,0x74,0x65,0x72,0x22,0x3e,0x3c,0x62,0x3e,0x59,0x6f,0x75,0x72,0x20,0x62, /* enter"><b>Your b */ \
	0x6f,0x61,0x72,0x64,0x20,0x69,0x73,0x20,0x6e,0x6f,0x77,0x20,0x6c,0x6f,0x63,0x61, /* oard is now loca */ \
	0x74,0x65,0x64,0x20,0x61,0x74,0x3a,0x20,0x0d,0x0a,0x3c,0x61,0x20,0x68,0x72,0x65, /* ted at: ..<a hre */ \
	0x66,0x3d,0x22,0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,0x7e,0x72,0x65,0x62,0x6f,0x6f, /* f="http://~reboo */ \
	0x74,0x61,0x64,0x64,0x72,0x7e,0x2f,0x22,0x3e,0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f, /* taddr~/">http:// */ \
	0x7e,0x72,0x65,0x62,0x6f,0x6f,0x74,0x61,0x64,0x64,0x72,0x7e,0x2f,0x3c,0x2f,0x61, /* ~rebootaddr~/</a */ \
	0x3e,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x3c,0x6d,0x65,0x74,0x61  /* ></b></p>..<meta */
#define DATACHUNK00002d \
	0x20,0x68,0x74,0x74,0x70,0x2d,0x65,0x71,0x75,0x69,0x76,0x3d,0x22,0x72,0x65,0x66, /*  http-equiv="ref */ \
	0x72,0x65,0x73,0x68,0x22,0x20,0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x3d,0x22,0x35, /* resh" content="5 */ \
	0x3b,0x75,0x72,0x6c,0x3d,0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,0x7e,0x72,0x65,0x62, /* ;url=http://~reb */ \
	0x6f,0x6f,0x74,0x61,0x64,0x64,0x72,0x7e,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68, /* ootaddr~">....<h */ \
	0x36,0x3e,0x3c,0x2f,0x68,0x36,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76, /* 6></h6>....</div */ \
	0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x6c,0x61,0x6e, /* >....<script lan */ \
	0x67,0x75,0x61,0x67,0x65,0x3d,0x22,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70, /* guage="javascrip */ \
	0x74,0x22,0x3e,0x0d,0x0a,0x3c,0x21,0x2d,0x2d,0x0d,0x0a,0x66,0x75,0x6e,0x63,0x74, /* t">..<!--..funct */ \
	0x69,0x6f,0x6e,0x20,0x72,0x65,0x62,0x6f,0x6f,0x74,0x44,0x75,0x6d,0x6d,0x79,0x28, /* ion rebootDummy( */ \
	0x78,0x29,0x7b,0x7d,0x0d,0x0a,0x73,0x65,0x74,0x54,0x69,0x6d,0x65,0x6f,0x75,0x74, /* x){}..setTimeout */ \
	0x28,0x22,0x6e,0x65,0x77,0x41,0x4a,0x41,0x58,0x43,0x6f,0x6d,0x6d,0x61,0x6e,0x64, /* ("newAJAXCommand */ \
	0x28,0x27,0x2f,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x72,0x65,0x62,0x6f,0x6f, /* ('/protect/reboo */ \
	0x74,0x2e,0x63,0x67,0x69,0x27,0x2c,0x72,0x65,0x62,0x6f,0x6f,0x74,0x44,0x75,0x6d, /* t.cgi',rebootDum */ \
	0x6d,0x79,0x2c,0x66,0x61,0x6c,0x73,0x65,0x29,0x3b,0x22,0x2c,0x35,0x30,0x30,0x29, /* my,false);",500) */ \
	0x3b,0x0d,0x0a,0x2f,0x2f,0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69, /* ;..//-->..</scri */ \
	0x70,0x74,0x3e,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72, /* pt>..~inc:footer */ \
	0x2e,0x69,0x6e,0x63,0x7e,0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0x0c,0x01,0x00, /* .inc~....3...... */ \
	0x00,0x2e,0x00,0x00,0x00,0x22,0x01,0x00,0x00,0x2e,0x00,0x00,0x00,0x6e,0x01,0x00, /* .....".......n.. */ \
	0x00,0x2e,0x00,0x00,0x00,0x37,0x02,0x00,0x00,0x02,0x00,0x00,0x00,0x7e,0x69,0x6e, /* .....7.......~in */ \
	0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x3c, /* c:header.inc~..< */ \
	0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x22, /* div id="content" */ \
	0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x46,0x69,0x72,0x6d,0x77,0x61,0x72, /* >....<h1>Firmwar */ \
	0x65,0x20,0x55,0x70,0x64,0x61,0x74,0x65,0x3c,0x2f,0x68,0x31,0x3e,0x0d,0x0a,0x3c, /* e Update</h1>..< */ \
	0x66,0x6f,0x72,0x6d,0x20,0x6d,0x65,0x74,0x68,0x6f,0x64,0x3d,0x22,0x70,0x6f,0x73, /* form method="pos */ \
	0x74,0x22,0x20,0x61,0x63,0x74,0x69,0x6f,0x6e,0x3d,0x22,0x2f,0x70,0x72,0x6f,0x74, /* t" action="/prot */ \
	0x65,0x63,0x74,0x2f,0x75,0x70,0x64,0x61,0x74,0x65,0x2e,0x68,0x74,0x6d,0x22,0x20, /* ect/update.htm"  */ \
	0x6e,0x61,0x6d,0x65,0x3d,0x22,0x55,0x70,0x6c,0x6f,0x61,0x64,0x22,0x20,0x65,0x6e, /* name="Upload" en */ \
	0x63,0x74,0x79,0x70,0x65,0x3d,0x22,0x6d,0x75,0x6c,0x74,0x69,0x70,0x61,0x72,0x74, /* ctype="multipart */ \
	0x2f,0x66,0x6f,0x72,0x6d,0x2d,0x64,0x61,0x74,0x61,0x22,0x3e,0x0d,0x0a,0x3c,0x70, /* /form-data">..<p */ \
	0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22, /* >..<input type=" */ \
	0x66,0x69,0x6c,0x65,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x66,0x69,0x6c,0x65, /* file" name="file */ \
	0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x35,0x30,0x22,0x3e,0x0d,0x0a,0x26,0x6e, /* " size="50">..&n */ \
	0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b, /* bsp;&nbsp;&nbsp; */ \
	0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x73, /* ..<input type="s */ \
	0x75,0x62,0x6d,0x69,0x74,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x55,0x70, /* ubmit" value="Up */ \
	0x64,0x61,0x74,0x65,0x22,0x20,0x6f,0x6e,0x63,0x6c,0x69,0x63,0x6b,0x3d,0x22,0x72, /* date" onclick="r */ \
	0x65,0x74,0x75,0x72,0x6e,0x20,0x63,0x6f,0x6e,0x66,0x69,0x72,0x6d,0x28,0x27,0x41, /* eturn confirm('A */ \
	0x72,0x65,0x20,0x79,0x6f,0x75,0x20,0x73,0x75,0x72,0x65,0x3f,0x27,0x29,0x22,0x20, /* re you sure?')"  */ \
	0x6f,0x6e,0x75,0x6e,0x6c,0x6f,0x61,0x64,0x3d,0x22,0x72,0x65,0x74,0x75,0x72,0x6e, /* onunload="return */ \
	0x20,0x63,0x6f,0x6e,0x66,0x69,0x72,0x6d,0x28,0x27,0x44,0x6f,0x20,0x79,0x6f,0x75, /*  confirm('Do you */ \
	0x20,0x61,0x62,0x6f,0x72,0x74,0x20,0x74,0x68,0x65,0x20,0x75,0x70,0x64,0x61,0x74, /*  abort the updat */ \
	0x69,0x6e,0x67,0x3f,0x27,0x29,0x22,0x3e,0x0d,0x0a,0x3c,0x2f,0x70,0x3e,0x0d,0x0a, /* ing?')">..</p>.. */ \
	0x3c,0x70,0x3e,0x0d,0x0a,0x7e,0x75,0x70,0x6c,0x6f,0x61,0x64,0x65,0x64,0x7e,0x0d, /* <p>..~uploaded~. */ \
	0x0a,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x3c,0x62,0x3e,0x4e,0x6f,0x74,0x65,0x3a,0x20, /* .</p>..<b>Note:  */ \
	0x4e,0x65,0x65,0x64,0x20,0x61,0x62,0x6f,0x75,0x74,0x20,0x36,0x30,0x20,0x2d,0x31, /* Need about 60 -1 */ \
	0x38,0x30,0x20,0x73,0x65,0x63,0x6f,0x6e,0x64,0x73,0x20,0x66,0x6f,0x72,0x20,0x75, /* 80 seconds for u */ \
	0x70,0x64,0x61,0x74,0x69,0x6e,0x67,0x3c,0x2f,0x62,0x3e,0x0d,0x0a,0x3c,0x2f,0x66, /* pdating</b>..</f */ \
	0x6f,0x72,0x6d,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a, /* orm>..</div>.... */ \
	0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65, /* <script type="te */ \
	0x78,0x74,0x2f,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x0d, /* xt/javascript">. */ \
	0x0a,0x3c,0x21,0x2d,0x2d,0x0d,0x0a,0x2f,0x2f,0x2d,0x2d,0x3e,0x0d,0x0a,0x0d,0x0a, /* .<!--..//-->.... */ \
	0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74,0x3e,0x0d,0x0a,0x0d,0x0a,0x7e,0x69,0x6e, /* </script>....~in */ \
	0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x00,0x00,0x00, /* c:footer.inc~... */ \
	0x00,0x33,0x00,0x00,0x00,0x78,0x01,0x00,0x00,0xa9,0x00,0x00,0x00,0x10,0x02,0x00, /* .3...x.......... */ \
	0x00,0x02,0x00,0x00,0x00,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72, /* .....~inc:header */ \
	0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22, /* .inc~..<div id=" */ \
	0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31, /* content">....<h1 */ \
	0x3e,0x55,0x73,0x65,0x72,0x20,0x49,0x44,0x20,0x61,0x6e,0x64,0x20,0x50,0x61,0x73, /* >User ID and Pas */ \
	0x73,0x77,0x6f,0x72,0x64,0x20,0x53,0x65,0x74,0x74,0x69,0x6e,0x67,0x3c,0x2f,0x68, /* sword Setting</h */ \
	0x31,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x66,0x6f,0x72,0x6d,0x20,0x6d,0x65,0x74,0x68, /* 1>....<form meth */ \
	0x6f,0x64,0x3d,0x22,0x70,0x6f,0x73,0x74,0x22,0x20,0x61,0x63,0x74,0x69,0x6f,0x6e, /* od="post" action */ \
	0x3d,0x22,0x2f,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x75,0x73,0x65,0x72,0x2e, /* ="/protect/user. */ \
	0x68,0x74,0x6d,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x75,0x73,0x65,0x72,0x22, /* htm" name="user" */ \
	0x3e,0x0d,0x0a,0x3c,0x66,0x69,0x65,0x6c,0x64,0x73,0x65,0x74,0x3e,0x0d,0x0a,0x3c  /* >..<fieldset>..< */
#define DATACHUNK00002e \
	0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x55,0x73,0x65,0x72,0x20, /* div><label>User  */ \
	0x49,0x44,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e, /* ID:</label>..<in */ \
	0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20, /* put type="text"  */ \
	0x6e,0x61,0x6d,0x65,0x3d,0x22,0x75,0x73,0x65,0x72,0x22,0x20,0x76,0x61,0x6c,0x75, /* name="user" valu */ \
	0x65,0x3d,0x22,0x7e,0x75,0x73,0x65,0x72,0x5f,0x69,0x64,0x7e,0x22,0x20,0x2f,0x3e, /* e="~user_id~" /> */ \
	0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61, /* </div>..<div><la */ \
	0x62,0x65,0x6c,0x3e,0x50,0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x3a,0x3c,0x2f,0x6c, /* bel>Password:</l */ \
	0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79, /* abel>..<input ty */ \
	0x70,0x65,0x3d,0x22,0x70,0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x22,0x20,0x6e,0x61, /* pe="password" na */ \
	0x6d,0x65,0x3d,0x22,0x70,0x77,0x64,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22, /* me="pwd" value=" */ \
	0x7e,0x75,0x73,0x65,0x72,0x5f,0x70,0x61,0x73,0x73,0x7e,0x22,0x20,0x2f,0x3e,0x3c, /* ~user_pass~" />< */ \
	0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62, /* /div>..<div><lab */ \
	0x65,0x6c,0x3e,0x50,0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x28,0x43,0x6f,0x6e,0x66, /* el>Password(Conf */ \
	0x69,0x72,0x6d,0x29,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c, /* irm):</label>..< */ \
	0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x70,0x61,0x73,0x73, /* input type="pass */ \
	0x77,0x6f,0x72,0x64,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x70,0x77,0x64,0x43, /* word" name="pwdC */ \
	0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x75,0x73,0x65,0x72,0x5f,0x70, /* " value="~user_p */ \
	0x61,0x73,0x73,0x43,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d, /* assC~" /></div>. */ \
	0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70, /* .<div><input typ */ \
	0x65,0x3d,0x22,0x62,0x75,0x74,0x74,0x6f,0x6e,0x22,0x20,0x20,0x6f,0x6e,0x43,0x6c, /* e="button"  onCl */ \
	0x69,0x63,0x6b,0x3d,0x22,0x70,0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x43,0x68,0x65, /* ick="passwordChe */ \
	0x63,0x6b,0x28,0x29,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31, /* ck()" class="ad1 */ \
	0x62,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x53,0x61,0x76,0x65,0x20,0x49, /* b" value="Save I */ \
	0x44,0x20,0x26,0x20,0x50,0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x22,0x2f,0x3e,0x3c, /* D & Password"/>< */ \
	0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x69,0x65,0x6c,0x64,0x73,0x65, /* /div>..</fieldse */ \
	0x74,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x6f,0x72,0x6d,0x3e,0x0d,0x0a,0x3c,0x2f,0x64, /* t>..</form>..</d */ \
	0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x74, /* iv>....<script t */ \
	0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x2f,0x6a,0x61,0x76,0x61,0x73,0x63, /* ype="text/javasc */ \
	0x72,0x69,0x70,0x74,0x22,0x3e,0x0d,0x0a,0x3c,0x21,0x2d,0x2d,0x0d,0x0a,0x2f,0x2f, /* ript">..<!--..// */ \
	0x2d,0x2d,0x3e,0x0d,0x0a,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x67,0x65, /* -->..document.ge */ \
	0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28,0x27,0x68,0x65, /* tElementById('he */ \
	0x6c,0x6c,0x6f,0x27,0x29,0x2e,0x69,0x6e,0x6e,0x65,0x72,0x48,0x54,0x4d,0x4c,0x20, /* llo').innerHTML  */ \
	0x3d,0x20,0x22,0x7e,0x68,0x65,0x6c,0x6c,0x6f,0x6d,0x73,0x67,0x7e,0x22,0x3b,0x0d, /* = "~hellomsg~";. */ \
	0x0a,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x20,0x70,0x61,0x73,0x73,0x77,0x6f, /* .function passwo */ \
	0x72,0x64,0x43,0x68,0x65,0x63,0x6b,0x28,0x29,0x0d,0x0a,0x7b,0x0d,0x0a,0x09,0x69, /* rdCheck()..{...i */ \
	0x66,0x20,0x28,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x75,0x73,0x65,0x72, /* f (document.user */ \
	0x2e,0x70,0x77,0x64,0x2e,0x76,0x61,0x6c,0x75,0x65,0x20,0x21,0x3d,0x20,0x64,0x6f, /* .pwd.value != do */ \
	0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x75,0x73,0x65,0x72,0x2e,0x70,0x77,0x64,0x43, /* cument.user.pwdC */ \
	0x2e,0x76,0x61,0x6c,0x75,0x65,0x29,0x0d,0x0a,0x09,0x7b,0x0d,0x0a,0x09,0x09,0x61, /* .value)...{....a */ \
	0x6c,0x65,0x72,0x74,0x20,0x28,0x22,0x50,0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x20, /* lert ("Password  */ \
	0x4d,0x69,0x73,0x73,0x6d,0x61,0x74,0x63,0x68,0x21,0x22,0x29,0x3b,0x0d,0x0a,0x09, /* Missmatch!");... */ \
	0x09,0x72,0x65,0x74,0x75,0x72,0x6e,0x3b,0x0d,0x0a,0x09,0x7d,0x0d,0x0a,0x09,0x64, /* .return;...}...d */ \
	0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x75,0x73,0x65,0x72,0x2e,0x73,0x75,0x62, /* ocument.user.sub */ \
	0x6d,0x69,0x74,0x28,0x29,0x3b,0x0d,0x0a,0x0d,0x0a,0x7d,0x0d,0x0a,0x3c,0x2f,0x73, /* mit();....}..</s */ \
	0x63,0x72,0x69,0x70,0x74,0x3e,0x0d,0x0a,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66, /* cript>....~inc:f */ \
	0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x00,0x00,0x00,0x00,0x33,0x00, /* ooter.inc~....3. */ \
	0x00,0x00,0xde,0x00,0x00,0x00,0x6a,0x00,0x00,0x00,0x3b,0x01,0x00,0x00,0x6b,0x00, /* ......j...;...k. */ \
	0x00,0x00,0xa4,0x01,0x00,0x00,0x6c,0x00,0x00,0x00,0x9e,0x02,0x00,0x00,0x01,0x00, /* ......l......... */ \
	0x00,0x00,0x65,0x03,0x00,0x00,0x02,0x00,0x00,0x00                                /* ..e.......       */


/**************************************
 * MPFS2 C linkable symbols
 **************************************/
// For C18, these are split into seperate arrays because it speeds up compilation a lot.  
// For other compilers, the entire data array must be defined as a single variable to 
// ensure that the linker does not reorder the data chunks in Flash when compiler 
// optimizations are turned on.
#if defined(__18CXX)
	ROM BYTE MPFS_Start[] = {DATACHUNK000000};
	ROM BYTE MPFS_000001[] = {DATACHUNK000001};
	ROM BYTE MPFS_000002[] = {DATACHUNK000002};
	ROM BYTE MPFS_000003[] = {DATACHUNK000003};
	ROM BYTE MPFS_000004[] = {DATACHUNK000004};
	ROM BYTE MPFS_000005[] = {DATACHUNK000005};
	ROM BYTE MPFS_000006[] = {DATACHUNK000006};
	ROM BYTE MPFS_000007[] = {DATACHUNK000007};
	ROM BYTE MPFS_000008[] = {DATACHUNK000008};
	ROM BYTE MPFS_000009[] = {DATACHUNK000009};
	ROM BYTE MPFS_00000a[] = {DATACHUNK00000a};
	ROM BYTE MPFS_00000b[] = {DATACHUNK00000b};
	ROM BYTE MPFS_00000c[] = {DATACHUNK00000c};
	ROM BYTE MPFS_00000d[] = {DATACHUNK00000d};
	ROM BYTE MPFS_00000e[] = {DATACHUNK00000e};
	ROM BYTE MPFS_00000f[] = {DATACHUNK00000f};
	ROM BYTE MPFS_000010[] = {DATACHUNK000010};
	ROM BYTE MPFS_000011[] = {DATACHUNK000011};
	ROM BYTE MPFS_000012[] = {DATACHUNK000012};
	ROM BYTE MPFS_000013[] = {DATACHUNK000013};
	ROM BYTE MPFS_000014[] = {DATACHUNK000014};
	ROM BYTE MPFS_000015[] = {DATACHUNK000015};
	ROM BYTE MPFS_000016[] = {DATACHUNK000016};
	ROM BYTE MPFS_000017[] = {DATACHUNK000017};
	ROM BYTE MPFS_000018[] = {DATACHUNK000018};
	ROM BYTE MPFS_000019[] = {DATACHUNK000019};
	ROM BYTE MPFS_00001a[] = {DATACHUNK00001a};
	ROM BYTE MPFS_00001b[] = {DATACHUNK00001b};
	ROM BYTE MPFS_00001c[] = {DATACHUNK00001c};
	ROM BYTE MPFS_00001d[] = {DATACHUNK00001d};
	ROM BYTE MPFS_00001e[] = {DATACHUNK00001e};
	ROM BYTE MPFS_00001f[] = {DATACHUNK00001f};
	ROM BYTE MPFS_000020[] = {DATACHUNK000020};
	ROM BYTE MPFS_000021[] = {DATACHUNK000021};
	ROM BYTE MPFS_000022[] = {DATACHUNK000022};
	ROM BYTE MPFS_000023[] = {DATACHUNK000023};
	ROM BYTE MPFS_000024[] = {DATACHUNK000024};
	ROM BYTE MPFS_000025[] = {DATACHUNK000025};
	ROM BYTE MPFS_000026[] = {DATACHUNK000026};
	ROM BYTE MPFS_000027[] = {DATACHUNK000027};
	ROM BYTE MPFS_000028[] = {DATACHUNK000028};
	ROM BYTE MPFS_000029[] = {DATACHUNK000029};
	ROM BYTE MPFS_00002a[] = {DATACHUNK00002a};
	ROM BYTE MPFS_00002b[] = {DATACHUNK00002b};
	ROM BYTE MPFS_00002c[] = {DATACHUNK00002c};
	ROM BYTE MPFS_00002d[] = {DATACHUNK00002d};
	ROM BYTE MPFS_00002e[] = {DATACHUNK00002e};
#else
	ROM BYTE MPFS_Start[] = {DATACHUNK000000, DATACHUNK000001, DATACHUNK000002, DATACHUNK000003, DATACHUNK000004, DATACHUNK000005, DATACHUNK000006, DATACHUNK000007, DATACHUNK000008, DATACHUNK000009, DATACHUNK00000a, DATACHUNK00000b, DATACHUNK00000c, DATACHUNK00000d, DATACHUNK00000e, DATACHUNK00000f, DATACHUNK000010, DATACHUNK000011, DATACHUNK000012, DATACHUNK000013, DATACHUNK000014, DATACHUNK000015, DATACHUNK000016, DATACHUNK000017, DATACHUNK000018, DATACHUNK000019, DATACHUNK00001a, DATACHUNK00001b, DATACHUNK00001c, DATACHUNK00001d, DATACHUNK00001e, DATACHUNK00001f, DATACHUNK000020, DATACHUNK000021, DATACHUNK000022, DATACHUNK000023, DATACHUNK000024, DATACHUNK000025, DATACHUNK000026, DATACHUNK000027, DATACHUNK000028, DATACHUNK000029, DATACHUNK00002a, DATACHUNK00002b, DATACHUNK00002c, DATACHUNK00002d, DATACHUNK00002e};
#endif


/**************************************************************
 * End of MPFS
 **************************************************************/
#endif // #if defined(STACK_USE_MPFS2)
#endif // #if !defined(MPFS_USE_EEPROM) && !defined(MPFS_USE_SPI_FLASH)
