/***************************************************************
 * MPFSImg2.c
 * Defines an MPFS2 image to be stored in program memory.
 *
 * NOT FOR HAND MODIFICATION
 * This file is automatically generated by the MPFS2 Utility
 * ALL MODIFICATIONS WILL BE OVERWRITTEN BY THE MPFS2 GENERATOR
 * Generated  8 09 2012 01:19:00 
 ***************************************************************/

#define __MPFSIMG2_C

#include "TCPIPConfig.h"
#if !defined(MPFS_USE_EEPROM) && !defined(MPFS_USE_SPI_FLASH)

#include "TCPIP Stack/TCPIP.h"
#if defined(STACK_USE_MPFS2)


/**************************************
 * MPFS2 Image Data
 **************************************/
#define DATACHUNK000000 \
	0x4d,0x50,0x46,0x53,0x02,0x01,0x2e,0x00,0x6a,0x55,0x5e,0x2a,0xea,0x87,0xff,0xff, /* MPFS....jU^..... */ \
	0xaa,0xcf,0xff,0xff,0x26,0x4f,0x26,0x2d,0x0a,0xa3,0xff,0xff,0x8a,0x24,0xff,0xff, /* ....&O&-.....$.. */ \
	0x6a,0x83,0xff,0xff,0xea,0x72,0xff,0xff,0x4a,0xe3,0xff,0xff,0x6a,0xe3,0xff,0xff, /* j....r..J...j... */ \
	0x6a,0x6b,0xff,0xff,0xea,0x92,0xff,0xff,0xea,0x3c,0xff,0xff,0xaa,0xa5,0xff,0xff, /* jk.......<...... */ \
	0x8a,0x96,0xff,0xff,0xca,0x21,0xff,0xff,0x8a,0x9e,0xff,0xff,0x4a,0x8c,0xff,0xff, /* .....!......J... */ \
	0x0a,0x4f,0xff,0xff,0x26,0xb6,0xff,0xff,0x8a,0xb6,0xff,0xff,0xea,0xd2,0xff,0xff, /* .O..&........... */ \
	0xca,0xb4,0xff,0xff,0x58,0x04,0x00,0x00,0x12,0x06,0x00,0x00,0xda,0x03,0x00,0x00, /* ....X........... */ \
	0x74,0x78,0x44,0x4f,0x00,0x00,0x00,0x00,0x01,0x00,0x63,0x04,0x00,0x00,0xec,0x09, /* txDO......c..... */ \
	0x00,0x00,0xb2,0x05,0x00,0x00,0x8c,0x47,0x0a,0x4f,0x00,0x00,0x00,0x00,0x01,0x00, /* .......G.O...... */ \
	0x6d,0x04,0x00,0x00,0x9e,0x0f,0x00,0x00,0x23,0x08,0x00,0x00,0x8d,0xf0,0x09,0x50, /* m.......#......P */ \
	0x00,0x00,0x00,0x00,0x02,0x00,0x79,0x04,0x00,0x00,0xc1,0x17,0x00,0x00,0x48,0x00, /* ......y.......H. */ \
	0x00,0x00,0x8d,0xf0,0x09,0x50,0x00,0x00,0x00,0x00,0x00,0x00,0x7a,0x04,0x00,0x00, /* .....P......z... */ \
	0x09,0x18,0x00,0x00,0xf2,0x07,0x00,0x00,0x71,0xf0,0x09,0x50,0x00,0x00,0x00,0x00, /* ........q..P.... */ \
	0x02,0x00,0x83,0x04,0x00,0x00,0xfb,0x1f,0x00,0x00,0x68,0x00,0x00,0x00,0x71,0xf0, /* ..........h...q. */ \
	0x09,0x50,0x00,0x00,0x00,0x00,0x00,0x00,0x84,0x04,0x00,0x00,0x63,0x20,0x00,0x00, /* .P..........c .. */ \
	0x9f,0x00,0x00,0x00,0x8c,0x47,0x0a,0x4f,0x00,0x00,0x00,0x00,0x00,0x00,0x8f,0x04, /* .....G.O........ */ \
	0x00,0x00,0x02,0x21,0x00,0x00,0xb4,0x07,0x00,0x00,0x25,0x91,0x22,0x50,0x00,0x00, /* ...!......%."P.. */ \
	0x00,0x00,0x00,0x00,0x9a,0x04,0x00,0x00,0xb6,0x28,0x00,0x00,0x63,0x06,0x00,0x00, /* .........(..c... */ \
	0x5f,0x16,0x0a,0x50,0x00,0x00,0x00,0x00,0x02,0x00,0xa4,0x04,0x00,0x00,0x19,0x2f, /* _..P.........../ */ \
	0x00,0x00,0x88,0x00,0x00,0x00,0x5f,0x16,0x0a,0x50,0x00,0x00,0x00,0x00,0x00,0x00, /* ......_..P...... */ \
	0xa5,0x04,0x00,0x00,0xa1,0x2f,0x00,0x00,0x5a,0x04,0x00,0x00,0x4c,0x45,0x0a,0x50, /* ...../..Z...LE.P */ \
	0x00,0x00,0x00,0x00,0x02,0x00,0xb3,0x04,0x00,0x00,0xfb,0x33,0x00,0x00,0x38,0x00, /* ...........3..8. */ \
	0x00,0x00,0x4c,0x45,0x0a,0x50,0x00,0x00,0x00,0x00,0x00,0x00,0xb4,0x04,0x00,0x00, /* ..LE.P.......... */ \
	0x33,0x34,0x00,0x00,0x4c,0x0b,0x00,0x00,0x0e,0x61,0x09,0x50,0x00,0x00,0x00,0x00, /* 34..L....a.P.... */ \
	0x02,0x00,0xbf,0x04,0x00,0x00,0x7f,0x3f,0x00,0x00,0x98,0x00,0x00,0x00,0x0e,0x61, /* .......?.......a */ \
	0x09,0x50,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x04,0x00,0x00,0x17,0x40,0x00,0x00, /* .P...........@.. */ \
	0xf6,0x08,0x00,0x00,0x38,0xf0,0x09,0x50,0x00,0x00,0x00,0x00,0x02,0x00,0xd7,0x04, /* ....8..P........ */ \
	0x00,0x00,0x0d,0x49,0x00,0x00,0x80,0x00,0x00,0x00,0x38,0xf0,0x09,0x50,0x00,0x00, /* ...I......8..P.. */ \
	0x00,0x00,0x00,0x00,0xd8,0x04,0x00,0x00,0x8d,0x49,0x00,0x00,0x7a,0x02,0x00,0x00, /* .........I..z... */ \
	0x42,0x5d,0x16,0x4f,0x00,0x00,0x00,0x00,0x02,0x00,0xf0,0x04,0x00,0x00,0x07,0x4c, /* B].O...........L */ \
	0x00,0x00,0x28,0x00,0x00,0x00,0x42,0x5d,0x16,0x4f,0x00,0x00,0x00,0x00,0x00,0x00, /* ..(...B].O...... */ \
	0xf1,0x04,0x00,0x00,0x2f,0x4c,0x00,0x00,0x52,0x0a,0x00,0x00,0x8c,0x47,0x0a,0x4f, /* ..../L..R....G.O */ \
	0x00,0x00,0x00,0x00,0x02,0x00,0x09,0x05,0x00,0x00,0x81,0x56,0x00,0x00,0xb0,0x00, /* ...........V.... */ \
	0x00,0x00,0x8c,0x47,0x0a,0x4f,0x00,0x00,0x00,0x00,0x00,0x00,0x0a,0x05,0x00,0x00, /* ...G.O.......... */ \
	0x31,0x57,0x00,0x00,0x2f,0x02,0x00,0x00,0xc2,0x8a,0x61,0x4f,0x00,0x00,0x00,0x00, /* 1W../.....aO.... */ \
	0x02,0x00,0x1d,0x05,0x00,0x00,0x60,0x59,0x00,0x00,0x20,0x00,0x00,0x00,0xc2,0x8a, /* ......`Y.. ..... */ \
	0x61,0x4f,0x00,0x00,0x00,0x00,0x00,0x00,0x1e,0x05,0x00,0x00,0x80,0x59,0x00,0x00, /* aO...........Y.. */ \
	0x3d,0x0d,0x00,0x00,0x7e,0x16,0x0a,0x50,0x00,0x00,0x00,0x00,0x02,0x00,0x31,0x05, /* =...~..P......1. */ \
	0x00,0x00,0xbd,0x66,0x00,0x00,0xb0,0x00,0x00,0x00,0x7e,0x16,0x0a,0x50,0x00,0x00, /* ...f......~..P.. */ \
	0x00,0x00,0x00,0x00,0x32,0x05,0x00,0x00,0x6d,0x67,0x00,0x00,0xac,0x01,0x00,0x00, /* ....2...mg...... */ \
	0xa9,0xf0,0x09,0x50,0x00,0x00,0x00,0x00,0x02,0x00,0x44,0x05,0x00,0x00,0x19,0x69, /* ...P......D....i */ \
	0x00,0x00,0x18,0x00,0x00,0x00,0xa9,0xf0,0x09,0x50,0x00,0x00,0x00,0x00,0x00,0x00, /* .........P...... */ \
	0x45,0x05,0x00,0x00,0x31,0x69,0x00,0x00,0xed,0x0d,0x00,0x00,0xcf,0xf0,0x09,0x50, /* E...1i.........P */ \
	0x00,0x00,0x00,0x00,0x02,0x00,0x56,0x05,0x00,0x00,0x1e,0x77,0x00,0x00,0xb8,0x00, /* ......V....w.... */ \
	0x00,0x00,0xcf,0xf0,0x09,0x50,0x00,0x00,0x00,0x00,0x00,0x00,0x57,0x05,0x00,0x00, /* .....P......W... */ \
	0xd6,0x77,0x00,0x00,0x54,0x19,0x00,0x00,0x85,0xe7,0x6f,0x4f,0x00,0x00,0x00,0x00, /* .w..T.....oO.... */ \
	0x02,0x00,0x6c,0x05,0x00,0x00,0x2a,0x91,0x00,0x00,0x10,0x00,0x00,0x00,0x85,0xe7, /* ..l............. */ \
	0x6f,0x4f,0x00,0x00,0x00,0x00,0x00,0x00,0x6d,0x05,0x00,0x00,0x3a,0x91,0x00,0x00, /* oO......m...:... */ \
	0x5b,0x02,0x00,0x00,0x90,0x8a,0x61,0x4f,0x00,0x00,0x00,0x00,0x02,0x00,0x85,0x05, /* [.....aO........ */ \
	0x00,0x00,0x95,0x93,0x00,0x00,0x20,0x00,0x00,0x00,0x90,0x8a,0x61,0x4f,0x00,0x00, /* ...... .....aO.. */ \
	0x00,0x00,0x00,0x00,0x86,0x05,0x00,0x00,0xb5,0x93,0x00,0x00,0x6d,0x13,0x00,0x00, /* ............m... */ \
	0x66,0xf6,0x42,0x4f,0x00,0x00,0x00,0x00,0x02,0x00,0x97,0x05,0x00,0x00,0x22,0xa7, /* f.BO..........". */ \
	0x00,0x00,0x10,0x00,0x00,0x00,0x66,0xf6,0x42,0x4f,0x00,0x00,0x00,0x00,0x00,0x00, /* ......f.BO...... */ \
	0x98,0x05,0x00,0x00,0x32,0xa7,0x00,0x00,0xee,0x03,0x00,0x00,0xcc,0x65,0x0a,0x50, /* ....2........e.P */ \
	0x00,0x00,0x00,0x00,0x02,0x00,0xb0,0x05,0x00,0x00,0x20,0xab,0x00,0x00,0x28,0x00, /* .......... ...(. */ \
	0x00,0x00,0xcc,0x65,0x0a,0x50,0x00,0x00,0x00,0x00,0x00,0x00,0xb1,0x05,0x00,0x00, /* ...e.P.......... */ \
	0x48,0xab,0x00,0x00,0xa8,0x03,0x00,0x00,0x8c,0x47,0x0a,0x4f,0x00,0x00,0x00,0x00, /* H........G.O.... */ \
	0x02,0x00,0xc3,0x05,0x00,0x00,0xf0,0xae,0x00,0x00,0x18,0x00,0x00,0x00,0x8c,0x47, /* ...............G */ \
	0x0a,0x4f,0x00,0x00,0x00,0x00,0x00,0x00,0xc4,0x05,0x00,0x00,0x08,0xaf,0x00,0x00, /* .O.............. */ \
	0x08,0x00,0x00,0x00,0x8c,0x47,0x0a,0x4f,0x00,0x00,0x00,0x00,0x02,0x00,0xd7,0x05, /* .....G.O........ */ \
	0x00,0x00,0x10,0xaf,0x00,0x00,0x08,0x00,0x00,0x00,0x8c,0x47,0x0a,0x4f,0x00,0x00, /* ...........G.O.. */ \
	0x00,0x00,0x00,0x00,0xd8,0x05,0x00,0x00,0x18,0xaf,0x00,0x00,0x47,0x02,0x00,0x00, /* ............G... */ \
	0xa4,0x82,0x43,0x4f,0x00,0x00,0x00,0x00,0x02,0x00,0xeb,0x05,0x00,0x00,0x5f,0xb1, /* ..CO.........._. */ \
	0x00,0x00,0x28,0x00,0x00,0x00,0xa4,0x82,0x43,0x4f,0x00,0x00,0x00,0x00,0x00,0x00  /* ..(.....CO...... */
#define DATACHUNK000001 \
	0xec,0x05,0x00,0x00,0x87,0xb1,0x00,0x00,0x20,0x02,0x00,0x00,0xd0,0x43,0x51,0x4f, /* ........ ....CQO */ \
	0x00,0x00,0x00,0x00,0x02,0x00,0xff,0x05,0x00,0x00,0xa7,0xb3,0x00,0x00,0x18,0x00, /* ................ */ \
	0x00,0x00,0xd0,0x43,0x51,0x4f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x00,0x00, /* ...CQO.......... */ \
	0xbf,0xb3,0x00,0x00,0x75,0x03,0x00,0x00,0xa8,0xf3,0x1d,0x4f,0x00,0x00,0x00,0x00, /* ....u......O.... */ \
	0x02,0x00,0x11,0x06,0x00,0x00,0x34,0xb7,0x00,0x00,0x30,0x00,0x00,0x00,0xa8,0xf3, /* ......4...0..... */ \
	0x1d,0x4f,0x00,0x00,0x00,0x00,0x00,0x00,0x37,0x6d,0x33,0x74,0x6a,0x7a,0x2e,0x63, /* .O......7m3tjz.c */ \
	0x73,0x73,0x00,0x37,0x6d,0x33,0x74,0x6a,0x7a,0x2e,0x6a,0x73,0x00,0x61,0x70,0x72, /* ss.7m3tjz.js.apr */ \
	0x73,0x6d,0x73,0x67,0x2e,0x68,0x74,0x6d,0x00,0x00,0x64,0x70,0x72,0x73,0x2e,0x68, /* smsg.htm..dprs.h */ \
	0x74,0x6d,0x00,0x00,0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e,0x63,0x00,0x68, /* tm..footer.inc.h */ \
	0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63,0x00,0x69,0x6e,0x64,0x65,0x78,0x2e, /* eader.inc.index. */ \
	0x68,0x74,0x6d,0x00,0x00,0x72,0x65,0x66,0x73,0x65,0x6c,0x65,0x63,0x74,0x2e,0x68, /* htm..refselect.h */ \
	0x74,0x6d,0x00,0x00,0x73,0x74,0x61,0x74,0x75,0x73,0x2e,0x68,0x74,0x6d,0x00,0x00, /* tm..status.htm.. */ \
	0x6e,0x6f,0x64,0x65,0x61,0x64,0x61,0x70,0x74,0x65,0x72,0x2f,0x63,0x6f,0x6e,0x66, /* nodeadapter/conf */ \
	0x69,0x67,0x2e,0x68,0x74,0x6d,0x00,0x00,0x6e,0x6f,0x64,0x65,0x61,0x64,0x61,0x70, /* ig.htm..nodeadap */ \
	0x74,0x65,0x72,0x2f,0x63,0x6f,0x6e,0x66,0x69,0x67,0x32,0x2e,0x68,0x74,0x6d,0x00, /* ter/config2.htm. */ \
	0x00,0x6e,0x6f,0x64,0x65,0x61,0x64,0x61,0x70,0x74,0x65,0x72,0x2f,0x63,0x6f,0x6e, /* .nodeadapter/con */ \
	0x66,0x69,0x67,0x33,0x2e,0x68,0x74,0x6d,0x00,0x00,0x70,0x72,0x6f,0x74,0x65,0x63, /* fig3.htm..protec */ \
	0x74,0x2f,0x61,0x63,0x63,0x65,0x73,0x73,0x2e,0x68,0x74,0x6d,0x00,0x00,0x70,0x72, /* t/access.htm..pr */ \
	0x6f,0x74,0x65,0x63,0x74,0x2f,0x63,0x6f,0x6e,0x66,0x69,0x67,0x2e,0x68,0x74,0x6d, /* otect/config.htm */ \
	0x00,0x00,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x64,0x65,0x62,0x75,0x67,0x2e, /* ..protect/debug. */ \
	0x68,0x74,0x6d,0x00,0x00,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x64,0x70,0x72, /* htm..protect/dpr */ \
	0x73,0x2e,0x68,0x74,0x6d,0x00,0x00,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x64, /* s.htm..protect/d */ \
	0x70,0x72,0x73,0x65,0x64,0x69,0x74,0x2e,0x68,0x74,0x6d,0x00,0x00,0x70,0x72,0x6f, /* prsedit.htm..pro */ \
	0x74,0x65,0x63,0x74,0x2f,0x44,0x70,0x72,0x73,0x4d,0x73,0x67,0x43,0x74,0x72,0x6c, /* tect/DprsMsgCtrl */ \
	0x2e,0x68,0x74,0x6d,0x00,0x00,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x65,0x64, /* .htm..protect/ed */ \
	0x69,0x74,0x2e,0x68,0x74,0x6d,0x00,0x00,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f, /* it.htm..protect/ */ \
	0x67,0x61,0x74,0x65,0x77,0x61,0x79,0x61,0x75,0x74,0x68,0x2e,0x68,0x74,0x6d,0x00, /* gatewayauth.htm. */ \
	0x00,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x69,0x6e,0x64,0x65,0x78,0x2e,0x68, /* .protect/index.h */ \
	0x74,0x6d,0x00,0x00,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x72,0x65,0x62,0x6f, /* tm..protect/rebo */ \
	0x6f,0x74,0x2e,0x63,0x67,0x69,0x00,0x00,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f, /* ot.cgi..protect/ */ \
	0x72,0x65,0x62,0x6f,0x6f,0x74,0x2e,0x68,0x74,0x6d,0x00,0x00,0x70,0x72,0x6f,0x74, /* reboot.htm..prot */ \
	0x65,0x63,0x74,0x2f,0x75,0x70,0x64,0x61,0x74,0x65,0x2e,0x68,0x74,0x6d,0x00,0x00, /* ect/update.htm.. */ \
	0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x75,0x73,0x65,0x72,0x2e,0x68,0x74,0x6d, /* protect/user.htm */ \
	0x00,0x00,0x1f,0x8b,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xd5,0x57,0x4d,0x6f, /* .............WMo */ \
	0xdb,0x38,0x10,0x3d,0x27,0x80,0xff,0x83,0x80,0x5c,0x23,0x43,0x1f,0x96,0xdb,0x2a, /* .8.='....\#C.... */ \
	0xa7,0xc5,0x9e,0xb7,0xc7,0xbd,0x53,0xe2,0xd0,0x22,0x42,0x8b,0x02,0x45,0xd5,0x6e, /* ......S.."B..E.n */ \
	0x8b,0xfe,0xf7,0x25,0x29,0x4a,0xa4,0x24,0x3a,0x69,0xda,0x00,0x8b,0x42,0x40,0x1b, /* ...%)J.$:i...B@. */ \
	0x53,0x9c,0x79,0x8f,0x6f,0x3e,0x38,0xaa,0x38,0xfe,0x1a,0x7d,0xdf,0xdd,0xdf,0x11, /* S.y.o>8.8..}.... */ \
	0xde,0xca,0x98,0xa0,0x33,0x65,0x5f,0xcb,0xe8,0x5f,0x10,0x18,0xb5,0xe8,0x31,0xfa, /* ....3e_.._....1. */ \
	0x4b,0x50,0xc4,0x1e,0xa3,0x1e,0xb5,0x7d,0xdc,0x83,0xa0,0xe4,0x49,0x6d,0xad,0x50, /* KP.....}....Im.P */ \
	0xfd,0x7c,0x12,0x7c,0x68,0x71,0x19,0x3d,0x14,0x95,0x7e,0xf4,0xf2,0x19,0x89,0x13, /* .|.|hq.=..~..... */ \
	0x6d,0xcb,0x28,0xe9,0xae,0x11,0x1a,0x24,0xd7,0x6b,0x1d,0xc2,0x98,0xb6,0x27,0xb5, /* m.(....$.k....'. */ \
	0xa8,0x9e,0x4c,0xbf,0x49,0xd4,0xf2,0x8f,0xdd,0xfd,0xee,0xfe,0xa1,0x6f,0x10,0xe6, /* ..L.I........o.. */ \
	0x97,0x98,0xb7,0x60,0x08,0x5c,0x28,0x96,0x4d,0x19,0x7d,0x38,0xaa,0x5d,0x06,0x85, /* ...`.\(.M.}8.].. */ \
	0x0b,0x0c,0xa2,0x8c,0x52,0x65,0xd4,0x73,0x46,0xb1,0xc2,0x2a,0x0a,0xf7,0x26,0x96, /* ....Re.sF.....&. */ \
	0xbc,0x2b,0x8d,0xbb,0x10,0xf2,0x0f,0x07,0x20,0x2f,0xdc,0x00,0x04,0x1c,0x1e,0x2a, /* .+...... /...... */ \
	0xfd,0x84,0x7c,0xfa,0xf6,0x8d,0x00,0xb8,0xe9,0xe1,0x70,0x78,0xc5,0x9c,0xf0,0x41, /* ..|.......px...A */ \
	0xdc,0xb2,0xce,0x91,0x7e,0x6e,0x38,0x50,0x2e,0x3a,0x74,0xba,0x89,0x9c,0xe7,0xf9, /* ....~n8P.:t..... */ \
	0x26,0x18,0x84,0x90,0xa0,0x40,0x73,0x18,0x32,0x2b,0xae,0x89,0x76,0x4f,0xbf,0x81, /* &....@s.2+..vO.. */ \
	0x72,0x99,0x74,0x72,0x09,0x28,0xb1,0xcb,0x88,0xc0,0x1e,0x49,0x25,0xb3,0xac,0x7c, /* r.tr.(.....I%..| */ \
	0xec,0x24,0x21,0x64,0xa4,0x34,0xa3,0x1d,0x3c,0xb0,0x0b,0xd0,0x53,0x23,0xcb,0xa8, /* .$!d.4..<...S#.. */ \
	0xe2,0x0c,0xeb,0xc5,0x9a,0x33,0x2e,0x1c,0xe5,0x31,0x84,0x71,0xc5,0xa5,0xe4,0x67, /* .....3...1.q...g */ \
	0x05,0x58,0x8c,0xa6,0x8d,0xb5,0x4a,0x8f,0xe6,0xb7,0x4f,0x60,0x2f,0xf4,0xab,0x91, /* .X....J...O`/... */ \
	0x29,0xe3,0x48,0x6d,0x32,0x0b,0x4f,0x2e,0x95,0x0e,0x89,0x3d,0xad,0x84,0xab,0x8c, /* ).Hm2.O....=.... */ \
	0x11,0xa3,0xa7,0xd6,0x6d,0x1a,0x5d,0x9d,0xa1,0x1d,0x7c,0x17,0x0c,0x88,0xef,0x21, /* ....m.]...|....! */ \
	0x2d,0xac,0x07,0x7b,0xa4,0x58,0x8c,0x74,0xac,0x8c,0x9e,0x0f,0xe4,0xe7,0x70,0x7a, /* -..{.X.t......pz */ \
	0xb0,0x66,0x98,0xf6,0x1d,0x43,0xaa,0xa0,0x2a,0xc6,0xeb,0xe7,0x4d,0xb8,0x9c,0x64, /* .f...C......M..d */ \
	0x56,0x8d,0x4b,0x43,0x25,0x2c,0x24,0xfc,0xf8,0x82,0x84,0x36,0xcc,0xb3,0x66,0x2e, /* V.KC%,$....6..f. */ \
	0x37,0xac,0xa8,0xe6,0xdc,0x18,0x6a,0x2e,0x90,0xa4,0x5c,0x1d,0xbe,0x55,0xc5,0xb6, /* 7.....j...\..U.. */ \
	0xe2,0x5d,0x36,0xfc,0x0b,0x88,0x6d,0x38,0xb1,0x21,0x66,0x05,0x57,0x05,0xf0,0x8f, /* .]6...m8.!f.W... */ \
	0xda,0x9d,0xfe,0xae,0x54,0xce,0xd1,0x2f,0xeb,0x55,0xd7,0xff,0x97,0x5e,0x1e,0xf9, /* ....T../.U...^.. */ \
	0xb7,0x88,0x96,0xbd,0x97,0x68,0xd9,0x9f,0x2c,0x5a,0xf6,0x36,0xd1,0xf2,0xf7,0x12, /* .....h..,Z.6.... */ \
	0x2d,0xff,0x93,0x45,0xcb,0x7f,0x4a,0x34,0x65,0x50,0x2b,0x12,0xd0,0x4a,0xff,0xa4, /* -..E..J4eP+..J.. */ \
	0x45,0x66,0x5b,0xe8,0xba,0x39,0xae,0x54,0x4b,0x7d,0xd5,0x26,0x3f,0xa3,0x66,0x53  /* Ef[..9.TK}.&?.fS */
#define DATACHUNK000002 \
	0x8b,0xae,0x93,0xe4,0x75,0xce,0xb3,0xa9,0xc7,0x78,0x72,0x30,0x92,0xdd,0x3a,0x50, /* ....u....xr0..:P */ \
	0x47,0x01,0xc1,0x68,0xc0,0x4b,0x33,0xb6,0x1a,0x7b,0x2b,0x8c,0x17,0x99,0xe3,0xb9, /* G..h.K3..{+..... */ \
	0xef,0x3b,0x54,0x4f,0x18,0x0c,0x90,0xd0,0xca,0xcb,0x66,0xf6,0x42,0x38,0x97,0xf6, /* .;TO......f.B8.. */ \
	0xb5,0x77,0x89,0x25,0xfb,0x8f,0x70,0xf6,0xaf,0x9e,0xe3,0xf1,0xb8,0xbe,0x1d,0x6a, /* .w.%..p........j */ \
	0x05,0x0e,0xc2,0x9f,0x29,0xb4,0x3e,0x51,0x61,0x26,0x97,0x68,0x9d,0x78,0x86,0x57, /* ....).>Qa&.h.x.W */ \
	0xba,0x98,0x57,0xec,0x9a,0xda,0x8e,0x55,0xf0,0x01,0x4f,0x28,0x76,0xe4,0x91,0x48, /* ..W....U..O(v..H */ \
	0x0e,0xfd,0x22,0x21,0x3f,0xbc,0x1c,0x26,0xe7,0xdf,0x27,0xb4,0x9e,0x8f,0x96,0x58, /* .."!?..&..'....X */ \
	0xc1,0x9c,0x5c,0x10,0xe8,0x0c,0x85,0x19,0xa2,0x18,0x4f,0xa7,0xfe,0x4d,0xfd,0x1b, /* ..\.......O..M.. */ \
	0x93,0xaa,0xf0,0xb4,0xca,0x43,0xbc,0xa6,0x30,0x0f,0x28,0x7b,0xb8,0xa2,0x73,0xc7, /* .....C..0.({..s. */ \
	0xa0,0xe2,0x57,0x2f,0x5e,0xa5,0xd1,0x4c,0x57,0x5a,0x34,0xff,0x15,0x2a,0x9d,0xd0, /* ..W/^..LWZ4..... */ \
	0x09,0x72,0x2f,0x55,0xc6,0x98,0xb8,0x90,0x78,0x05,0xf0,0x80,0xf1,0x7c,0xa8,0x7d, /* .r/U....x....|.} */ \
	0xcd,0x31,0x6c,0x67,0xd8,0xbf,0xd5,0xdc,0x45,0x55,0x16,0x7c,0x86,0xcb,0xe3,0xf4, /* .1lg....EU.|.... */ \
	0xe3,0x31,0x22,0xf4,0x0a,0x38,0x36,0xe2,0xdb,0x1f,0xde,0x59,0x40,0xd4,0xb4,0x0f, /* .1"..86....Y@... */ \
	0x8c,0x36,0x04,0x3e,0x3d,0xad,0xf4,0xf2,0x66,0x16,0xdd,0x9e,0x36,0x69,0x30,0x2e, /* .6.>=...f...6i0. */ \
	0x66,0xae,0xf0,0xa1,0xca,0x1d,0x92,0x10,0x5c,0xf8,0x09,0xbe,0x74,0xb1,0x09,0xfd, /* f.......\...t... */ \
	0x92,0x0c,0xc6,0x2f,0xe1,0x7c,0x4a,0xdc,0xf8,0x38,0x57,0xd3,0xd1,0x1b,0x22,0xbd, /* .../.|J..8W...". */ \
	0x0c,0x45,0x7d,0xe3,0x69,0x3e,0x27,0x58,0xb1,0xa2,0x91,0xac,0x66,0x31,0xaf,0x10, /* .E}.i>'X....f1.. */ \
	0xbd,0xf8,0xdb,0xa9,0xd1,0x8b,0xdc,0xd4,0xb7,0xd7,0x1d,0xa7,0x70,0x0e,0x08,0x05, /* ............p... */ \
	0x86,0x7b,0x90,0xef,0x9b,0x3d,0x37,0x12,0x65,0x06,0xc3,0xf4,0xcb,0xb2,0x00,0xb4, /* .{...=7.e....... */ \
	0x7e,0x1a,0x4b,0xff,0x3f,0x5d,0x2f,0x5b,0x13,0x86,0x2a,0x60,0xdb,0xb0,0xc5,0xe9, /* ~.K.?]/[...`.... */ \
	0x21,0xd4,0x17,0xb2,0x71,0x6d,0xaa,0xf3,0xe9,0xb3,0x26,0x78,0x5f,0x74,0xbc,0xa7, /* !...qm....&x_t.. */ \
	0x63,0x4b,0x44,0x95,0x8a,0xe3,0x20,0x61,0x43,0x80,0xb6,0xdd,0x20,0xb7,0xe0,0x53, /* cKD... aC... ..S */ \
	0x4b,0x9a,0x60,0xb2,0x10,0x79,0x63,0xbb,0xef,0xcf,0x7e,0xe3,0x71,0xdf,0x49,0x9b, /* K.`..yc...~.q.I. */ \
	0x8d,0x08,0xa7,0x81,0x9d,0x8b,0x3e,0x69,0x43,0xbb,0xb4,0xae,0x06,0x75,0xdd,0xb5, /* ......>iC....u.. */ \
	0xda,0xbc,0x7a,0xcd,0x7e,0x31,0x85,0xcf,0x0e,0xf4,0x0e,0x24,0x60,0x71,0x63,0x67, /* ..z.~1.....$`qcg */ \
	0xc1,0x70,0x4c,0x44,0xf3,0x10,0x90,0xf7,0x39,0xf8,0x22,0xee,0x5e,0x40,0x3f,0x30, /* .pLD....9.".^@?0 */ \
	0xb9,0xbb,0xff,0xbe,0x5b,0xf5,0xfb,0xb7,0x65,0xdf,0xf2,0x83,0x2c,0x7c,0x9d,0x84, /* ....[...e...,|.. */ \
	0xc7,0x04,0xbf,0xae,0x01,0xe6,0xa0,0xdf,0xed,0xf9,0xb3,0x39,0xd8,0x54,0xb2,0xf3, /* ...........9.T.. */ \
	0x8d,0x55,0x99,0xfe,0xbe,0x32,0x24,0x66,0x30,0x51,0x96,0x77,0xda,0x94,0x20,0xca, /* .U...2$f0Q.w.. . */ \
	0x82,0xc6,0xd5,0x31,0x60,0x4c,0x60,0x61,0x3c,0xb4,0x61,0xe0,0xba,0x0e,0xd9,0x12, /* ...1`L`a<.a..... */ \
	0x6c,0x6d,0xff,0x03,0x23,0xf3,0xfb,0x9f,0x46,0x10,0x00,0x00,0x1f,0x8b,0x08,0x00, /* lm..#...F....... */ \
	0x00,0x00,0x00,0x00,0x00,0x00,0xcd,0x57,0x4d,0x6f,0xdb,0x46,0x10,0x3d,0x93,0xbf, /* .......WMo.F.=.. */ \
	0x62,0xaa,0x43,0x4c,0x01,0xb2,0x2c,0x07,0x4d,0x0f,0x31,0x94,0xc2,0xb1,0x83,0xd6, /* b.CL..,.M.1..... */ \
	0x85,0x53,0x1b,0xb6,0x52,0x04,0x68,0x7b,0x58,0x93,0x23,0x6b,0x63,0x8a,0xcb,0xec, /* .S..R.h{X.#kc... */ \
	0x2e,0xa5,0x08,0x81,0x7f,0x50,0xff,0x65,0xdf,0x2c,0x3f,0x44,0x2b,0x4e,0xda,0x22, /* .....P.e.,?D+N." */ \
	0x39,0xd4,0x07,0x4b,0xe4,0xec,0xbe,0x9d,0x7d,0xf3,0xe6,0x43,0x07,0x07,0x74,0x62, /* 9..K....}..C..tb */ \
	0xca,0x8d,0xd5,0xb7,0x0b,0x4f,0x7f,0xd1,0xd3,0xc9,0xe4,0xe9,0xfe,0xd3,0xc9,0xe1, /* .....O.......... */ \
	0x84,0x5e,0xeb,0xd4,0x9a,0x74,0xa1,0x4b,0x9a,0x71,0xba,0x28,0x4c,0x6e,0x6e,0x37, /* .^...t.K.q.(Lnn7 */ \
	0x74,0x56,0xa4,0x63,0xa2,0xe3,0x3c,0xa7,0xb0,0xc1,0x91,0x65,0xc7,0x76,0xc5,0xd9, /* tV.c..<....e.v.. */ \
	0x38,0x3e,0x38,0xa0,0x6b,0xe6,0xfe,0xb6,0x93,0xcb,0x83,0xb3,0x4b,0xba,0xf6,0x2a, /* 8>8.k.......K... */ \
	0xbd,0xa3,0xcc,0xa4,0xd5,0x92,0x0b,0xaf,0xbc,0x36,0x05,0xcd,0x8d,0xa5,0x5c,0xa7, /* .........6....\. */ \
	0x5c,0x38,0x26,0x5d,0xe0,0x69,0x19,0xde,0x8f,0xe3,0x58,0x60,0x4e,0xd9,0xb3,0x5d, /* \8&].i....X`N..] */ \
	0xea,0x82,0x1d,0xad,0x17,0x5c,0x90,0xc2,0x29,0xef,0x2b,0x76,0x9e,0xb4,0xa3,0xd4, /* .....\..).+v.... */ \
	0x14,0x4e,0x67,0x6c,0x39,0xa3,0x81,0xd7,0x4b,0x7c,0x98,0xca,0x0f,0xe2,0x95,0xb2, /* .Ngl9...K|...... */ \
	0x24,0x8f,0x17,0x95,0x7f,0x7d,0x4d,0x53,0x7a,0x36,0x99,0x4c,0x8e,0xe8,0xe0,0x60, /* $....}MSz6.L...` */ \
	0xe9,0x62,0x0a,0xae,0x79,0x03,0x57,0x01,0x05,0xa0,0x8a,0xc9,0xcc,0xe9,0xf8,0x97, /* .b..y.W......... */ \
	0xe3,0xb7,0xc4,0x2b,0xf8,0xe4,0xc8,0x1b,0x2a,0xe1,0x35,0x3b,0x17,0x80,0xd4,0x3b, /* ...+......5;...; */ \
	0xf5,0xe1,0x5c,0xe3,0xbc,0x29,0x15,0xbc,0xa6,0x63,0x6b,0xd5,0x26,0x19,0x1e,0x05, /* ..\..)...ck.&... */ \
	0xe7,0xce,0x0a,0xed,0xb5,0xf2,0x01,0x2b,0x18,0x05,0x26,0x35,0xcb,0xa5,0x2a,0x32, /* .......+..&5...2 */ \
	0xd8,0xa3,0xca,0xe6,0xcf,0xc9,0x2f,0x98,0xf0,0x45,0x70,0x55,0x1a,0x60,0x61,0x81, /* ....../..EpU.`a. */ \
	0xe7,0x5e,0xe1,0x56,0xb6,0xb6,0xb7,0x8c,0xd0,0xd9,0xa9,0xac,0x9b,0xeb,0x3c,0x1f, /* .^.V..........<. */ \
	0x11,0x78,0x51,0x34,0xaf,0x8a,0x34,0xd0,0x84,0xd7,0xa9,0x02,0xd7,0x6b,0xed,0x17, /* .xQ4..4......k.. */ \
	0xc2,0x74,0x69,0x84,0xb0,0xb7,0xaf,0xcf,0x29,0x31,0xa5,0xac,0x50,0xf9,0x50,0x90, /* .ti.....)1..P.P. */ \
	0x2d,0x97,0xac,0x3c,0x60,0x2d,0xae,0x86,0x4d,0xf5,0x33,0x4e,0x11,0xbe,0x04,0x40, /* -..<`-..M.3N...@ */ \
	0x17,0x19,0xcf,0x35,0x3c,0xe7,0x7c,0xb3,0xb3,0x37,0x53,0x5e,0x3d,0x27,0x55,0xd0, /* ...5<.|..7S^='U. */ \
	0x9b,0xab,0x73,0xe2,0x22,0x35,0x19,0x28,0x75,0xde,0xea,0xe2,0x56,0xa0,0x6e,0x98, /* ..s."5.(u...V.n. */ \
	0x5c,0x75,0xb3,0xd4,0xde,0xe3,0xb5,0x72,0x74,0x79,0x71,0x3d,0x23,0xd9,0xd3,0x87, /* \u.....rtyq=#... */ \
	0xe9,0x1c,0x06,0x21,0xc2,0xc7,0x49,0x4d,0x47,0x02,0x0a,0x46,0xd4,0x5d,0x7b,0xd4, /* ...!..IMG..F.]{. */ \
	0xf8,0x35,0x0a,0xfb,0x87,0xf1,0xc7,0x38,0x0a,0x9a,0xf1,0x54,0x95,0x08,0xa2,0x25, /* .5.....8...T...% */ \
	0x73,0xf3,0x8e,0x53,0x1f,0x47,0x12,0x02,0x41,0x42,0x14,0x9a,0x08,0x5c,0x04,0x8b, /* s..S.G..AB...\.. */ \
	0x84,0x20,0x18,0x41,0xdf,0x0c,0xb1,0xb6,0x8d,0xf5,0x14,0xe1,0x08,0xb6,0x66,0xd3, /* . .A..........f. */ \
	0x58,0xa8,0x9f,0x4a,0x00,0x7a,0xef,0x3a,0x37,0x60,0xe9,0xbe,0xf7,0xec,0x0d,0x67, /* X..J.z.:7`.....g */ \
	0xd3,0xc6,0xc9,0x9e,0x45,0xd4,0x70,0xc5,0xef,0xe5,0xb0,0x2a,0x17,0xc8,0xe0,0xf7, /* ....E.p......... */ \
	0x89,0xc5,0x2a,0x06,0x71,0x60,0x8b,0xf1,0x4f,0x42,0xda,0xc8,0x34,0x8e,0xf4,0x3c  /* ....q`..OB..4..< */
#define DATACHUNK000003 \
	0x59,0x83,0x73,0xb3,0x1e,0x23,0x58,0x3f,0x7b,0x5f,0x5e,0xd5,0x96,0x21,0x7d,0x8c, /* Y.s..#X?{_^..!}. */ \
	0xa9,0xf9,0x7b,0x04,0x1e,0x77,0x79,0xb8,0x5e,0x6e,0xf5,0x99,0xf5,0x63,0x53,0x72, /* ..{..wy.^n...cSr */ \
	0x91,0x24,0x42,0xe5,0x74,0x2a,0x8e,0x0d,0x7f,0x1c,0xfc,0xf4,0x6a,0x36,0x78,0x3e, /* .$B.t.......j6x> */ \
	0x90,0x10,0x0d,0x46,0xd4,0x23,0x63,0x14,0x94,0xf1,0x05,0x2c,0xb9,0x41,0x80,0x6a, /* ...F.#c....,.A.j */ \
	0xd6,0x88,0xce,0xe7,0xb4,0xe6,0x3d,0x0b,0x1d,0x3b,0x91,0xc2,0xd9,0xab,0x1f,0xa0, /* ......=..;...... */ \
	0x8a,0x4d,0xce,0x94,0x2c,0xd5,0x06,0xaa,0x78,0x36,0x7e,0x26,0xb2,0x2f,0x91,0xb8, /* .M..,...x6~&./.. */ \
	0x37,0xb9,0xa8,0xce,0x0c,0xc3,0xd6,0x7b,0xe2,0x5c,0xb2,0xba,0x63,0xe0,0x18,0xd2, /* 7......{.\..c... */ \
	0x58,0xf1,0xdb,0x3a,0x84,0xff,0x4c,0xc0,0x83,0xe5,0xc9,0x20,0x94,0x13,0x67,0xe6, /* X..:..L.... ..g. */ \
	0x3e,0x30,0x39,0x9b,0x5d,0x0e,0x7a,0xd7,0xc0,0x21,0x3b,0x20,0x7d,0xfc,0x6f,0x4d, /* >09.].z..!; }.oM */ \
	0xda,0xbf,0x21,0x2e,0x30,0x10,0x6f,0xff,0xc7,0xfd,0x4d,0xb9,0x72,0xfe,0x04,0xe9, /* ..!.0.o...M.r... */ \
	0x88,0x4c,0x9a,0x76,0x1a,0x1e,0xdf,0xb2,0x97,0x2f,0x6d,0xa8,0x5b,0xfe,0x43,0xc1, /* .L.v...../m.[.C. */ \
	0x42,0xe2,0x86,0xcc,0x50,0x52,0x81,0x82,0xa5,0x2d,0x4d,0xe3,0xb2,0x72,0x8b,0xf6, /* B...PR...-M..r.. */ \
	0xf6,0xd8,0x7a,0x1f,0x8a,0xd3,0xb9,0x31,0xa5,0x23,0xb3,0x82,0xca,0x25,0xed,0x71, /* ..z....1.#...%.q */ \
	0xd9,0x4c,0x82,0xb7,0x53,0xea,0xb2,0xb6,0xbe,0x82,0x40,0x08,0x78,0x83,0x1a,0x15, /* .L..S.....@.x... */ \
	0xb2,0x57,0xbb,0xa0,0x60,0x8d,0xda,0xba,0x4d,0xe9,0xd2,0xe4,0xb9,0xec,0x4f,0x40, /* .W..`...M.....O@ */ \
	0x6d,0x54,0xa7,0x5f,0x5a,0xd9,0xff,0x9e,0x9b,0x62,0xe3,0x5c,0x95,0x8e,0xb3,0x36, /* mT._Z....b.\...6 */ \
	0x85,0xae,0x58,0xa1,0x7a,0xcf,0xe7,0x21,0x77,0xba,0x9a,0x5b,0x57,0x01,0xdc,0x02, /* ..X.z..!w..[W... */ \
	0xfe,0xdd,0x6c,0xe4,0x23,0x8e,0xd0,0x21,0x12,0x0d,0xc4,0xee,0xf6,0x39,0x17,0xb7, /* ..l.#..!.....9.. */ \
	0x7e,0x71,0x44,0x9a,0x5e,0x10,0xea,0xbc,0xde,0xdf,0x1f,0xc6,0x11,0x0a,0x4a,0xb4, /* ~qD.^.........J. */ \
	0xf5,0xad,0x5b,0xeb,0x16,0x7a,0x5e,0xfb,0x27,0x79,0xf9,0x5d,0xb3,0x02,0xeb,0xa3, /* ..[..z^.'y.].... */ \
	0x50,0x92,0x75,0x51,0xb1,0xd8,0x1a,0xe7,0x1e,0x0d,0x0d,0xed,0xb7,0x97,0xee,0x05, /* P.uQ............ */ \
	0x51,0x36,0x45,0xb8,0x49,0xd4,0x66,0x0b,0x2a,0x65,0xca,0x8c,0xfa,0x59,0x9f,0xd4, /* Q6E.I.f..e...Y.. */ \
	0xee,0x68,0xb5,0x82,0x82,0x91,0x6d,0xd0,0x0d,0x51,0x35,0xa6,0x53,0xfa,0x9e,0x9e, /* .h....m..Q5.S... */ \
	0x3c,0xa1,0xdd,0x25,0x0e,0xd6,0xca,0x89,0x19,0x7d,0x58,0xb4,0x1c,0xb5,0xe8,0xda, /* <..%.....}X..... */ \
	0xd3,0x42,0x49,0xcf,0xe9,0x95,0xd3,0xb5,0x45,0x41,0x6f,0x0a,0x8f,0xab,0x72,0x2f, /* .BI.....EAo...r/ */ \
	0xab,0x71,0xae,0xdf,0x94,0x6c,0xb6,0xc7,0x77,0x1b,0x86,0x82,0xbb,0xd7,0x06,0x76, /* .q...l..w......v */ \
	0x6f,0x18,0xd0,0xa3,0x4f,0x96,0x3d,0xe2,0x77,0xdd,0x78,0x90,0x80,0xe3,0xb6,0x69, /* o...O.=.w.x....i */ \
	0xbd,0xca,0x59,0x3e,0x02,0xa9,0xd1,0x36,0xe5,0xbf,0x7c,0x74,0xdd,0x55,0xf6,0x9a, /* ..Y>...6..|t.U.. */ \
	0x7b,0x45,0x2d,0x96,0xd0,0xdc,0xe0,0xbd,0xdc,0x9c,0x65,0x8f,0xec,0x1e,0xeb,0x02, /* {E-.......e..... */ \
	0x1f,0x3f,0xcf,0xd0,0xf8,0xa6,0x9f,0x70,0xd6,0xba,0x37,0xe3,0x0f,0xbe,0x71,0x07, /* .?.....p..7...q. */ \
	0x94,0x25,0x06,0xbc,0xd8,0xb5,0x76,0xd2,0x68,0xa9,0xc0,0x93,0x24,0x82,0xcc,0x1d, /* .%....v.h...$... */ \
	0x92,0xf6,0xb4,0x52,0x39,0xea,0x6b,0xd0,0x40,0x1c,0x49,0x5e,0x45,0xbb,0xb0,0xea, /* ...R9.k.@.I^E... */ \
	0xc6,0xd8,0x5a,0x35,0x8f,0x99,0xbb,0x66,0xd0,0x8f,0xd0,0x9e,0x0b,0xa3,0x8a,0xb4, /* ..Z5...f........ */ \
	0x0f,0x25,0x35,0xb1,0x69,0x07,0x23,0x09,0x51,0x21,0x6e,0x38,0xd3,0x84,0xa8,0x45, /* .%5.i.#.Q!n8...E */ \
	0xab,0x17,0x07,0x37,0xa2,0x9d,0xde,0xd9,0x2e,0xa9,0x7b,0xe8,0x2e,0x25,0xdb,0x57, /* ...7......{..%.W */ \
	0x0d,0xc4,0xd1,0xae,0x9c,0xef,0xe3,0x07,0xda,0xdc,0x5b,0x31,0xad,0x95,0x96,0x2e, /* ..........[1.... */ \
	0x1e,0xca,0xc3,0x21,0xba,0x16,0x96,0x67,0x8d,0x73,0x10,0x6f,0x37,0x4c,0xd5,0xea, /* ...!...g.s.o7L.. */ \
	0x6d,0xd3,0xe1,0xc5,0x76,0xac,0xea,0x09,0xb2,0x58,0x99,0xbb,0x5a,0x7a,0x15,0xe6, /* m...v....X..Zz.. */ \
	0xbf,0xed,0xc4,0x12,0x26,0x95,0xc0,0xb0,0x2e,0xca,0xea,0x5b,0x29,0x32,0x54,0xea, /* ....&......[)2T. */ \
	0xbe,0xd4,0xea,0x85,0x70,0xe4,0x38,0x67,0xeb,0x3b,0x3f,0xc2,0x5b,0x25,0xaf,0x92, /* ....p.8g.;?.[%.. */ \
	0x41,0xc3,0x23,0xcd,0x95,0x46,0xae,0x8e,0xff,0x28,0x4e,0x0c,0x44,0xd4,0xcd,0x55, /* A.#..F...(N.D..U */ \
	0x19,0xca,0x61,0x6e,0xca,0x30,0x80,0xdd,0x18,0x65,0x33,0xb0,0xe3,0x28,0x37,0xa8, /* ..an.0...e3..(7. */ \
	0x17,0x83,0xe6,0xa8,0xf8,0xeb,0x94,0x51,0xd7,0x86,0xff,0xbb,0x38,0x2e,0xda,0x34, /* .......Q....8..4 */ \
	0x19,0xd1,0xbb,0x0a,0xd5,0xf7,0x8e,0xb9,0x0c,0x42,0x41,0xba,0x60,0xc5,0xc3,0x76, /* .........BA.`..v */ \
	0xd3,0x96,0x4e,0x40,0xdc,0xb7,0x63,0x90,0xf4,0x19,0xb4,0x28,0xc7,0xf9,0x4a,0x66, /* ..N@..c....(..Jf */ \
	0xe2,0x5b,0x78,0x20,0x5d,0xeb,0x70,0x82,0xc9,0x3b,0x72,0x75,0x01,0x85,0xa8,0x92, /* .[x ].p..;ru.... */ \
	0xc1,0xb6,0x91,0x0c,0x46,0x87,0x13,0xc1,0x88,0xef,0x03,0x49,0x40,0xb9,0x54,0x00, /* ....F......I@.T. */ \
	0x70,0x21,0x8e,0x1f,0x96,0xf9,0x55,0x3b,0xe9,0x5a,0xf6,0x95,0x2d,0x20,0x42,0xf4, /* p!....U;.Z..- B. */ \
	0x01,0x4c,0xa8,0xcd,0x04,0xd0,0xcc,0x46,0xed,0xb8,0x88,0x19,0x16,0x7b,0x4e,0xc3, /* .L.....F.....{N. */ \
	0x18,0xdb,0x00,0xc8,0x43,0xb7,0x59,0xf0,0x31,0x5d,0x73,0x9e,0xd5,0xf6,0xf0,0x55, /* ....C.Y.1]s....U */ \
	0x24,0xe0,0x58,0xd9,0x74,0x21,0x35,0x61,0xdb,0xed,0x50,0x8a,0x70,0xca,0x6f,0x52, /* $.X.t!5a..P.p.oR */ \
	0x1d,0x92,0x06,0x68,0x54,0xef,0x08,0xe2,0xf7,0x76,0x13,0xb4,0x87,0x28,0x35,0xd6, /* ...hT....v...(5. */ \
	0x5e,0xf1,0x72,0x2f,0x37,0x33,0x75,0xfb,0xab,0x42,0xc3,0xa8,0x77,0xfc,0x3e,0xf9, /* ^.r/73u..B..w.>. */ \
	0x73,0x3c,0xd7,0x16,0xfd,0x62,0xa1,0xf3,0x6c,0x5c,0x60,0xb4,0x0e,0xc8,0x21,0xa4, /* s<...b..l\`...!. */ \
	0xb5,0x7b,0xf4,0x15,0x30,0x75,0xd3,0x72,0xdc,0x43,0x6b,0x94,0x77,0x8f,0xa9,0xdf, /* .{..0u.r.Ck.w... */ \
	0xa7,0x8b,0x84,0x2d,0x52,0xec,0x23,0xf5,0x8d,0x98,0x4b,0xc2,0xa8,0x70,0xa7,0xf1, /* ...-R.#...K..p.. */ \
	0xa3,0xac,0xed,0xbd,0x61,0x3e,0x78,0x53,0x62,0x8e,0x41,0x0e,0x7d,0x2e,0x66,0xf8, /* ....a>xSb.A.}.f. */ \
	0x45,0x25,0x3f,0x81,0xfe,0x06,0xc4,0xdd,0x52,0x7e,0x30,0x0e,0x00,0x00,0x7e,0x69, /* E%?.....R~0...~i */ \
	0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a, /* nc:header.inc~.. */ \
	0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74, /* <div id="content */ \
	0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x41,0x50,0x52,0x53,0x20,0x4d, /* ">....<h1>APRS M */ \
	0x65,0x73,0x73,0x61,0x67,0x65,0x20,0x53,0x65,0x6e,0x64,0x3c,0x2f,0x68,0x31,0x3e, /* essage Send</h1> */ \
	0x0d,0x0a,0x0d,0x0a,0x3c,0x66,0x6f,0x72,0x6d,0x20,0x6d,0x65,0x74,0x68,0x6f,0x64, /* ....<form method */ \
	0x3d,0x22,0x70,0x6f,0x73,0x74,0x22,0x20,0x61,0x63,0x74,0x69,0x6f,0x6e,0x3d,0x22  /* ="post" action=" */
#define DATACHUNK000004 \
	0x2f,0x61,0x70,0x72,0x73,0x6d,0x73,0x67,0x2e,0x68,0x74,0x6d,0x22,0x20,0x6e,0x61, /* /aprsmsg.htm" na */ \
	0x6d,0x65,0x3d,0x22,0x6d,0x65,0x73,0x73,0x61,0x67,0x65,0x22,0x3e,0x0d,0x0a,0x3c, /* me="message">..< */ \
	0x66,0x69,0x65,0x6c,0x64,0x73,0x65,0x74,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e, /* fieldset>..<div> */ \
	0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x53,0x65,0x6e,0x64,0x65,0x72,0x20,0x43,0x61, /* <label>Sender Ca */ \
	0x6c,0x6c,0x73,0x69,0x67,0x6e,0x20,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e, /* llsign :</label> */ \
	0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73, /* &nbsp;&nbsp;&nbs */ \
	0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e, /* p;&nbsp;&nbsp;&n */ \
	0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b, /* bsp;&nbsp;&nbsp; */ \
	0x26,0x6e,0x62,0x73,0x70,0x3b,0x0d,0x0a,0x3c,0x73,0x65,0x6c,0x65,0x63,0x74,0x20, /* &nbsp;..<select  */ \
	0x6e,0x61,0x6d,0x65,0x3d,0x22,0x73,0x63,0x61,0x6c,0x22,0x3e,0x0d,0x0a,0x7e,0x6f, /* name="scal">..~o */ \
	0x72,0x67,0x53,0x53,0x49,0x44,0x7e,0x0d,0x0a,0x7e,0x61,0x6c,0x74,0x53,0x53,0x49, /* rgSSID~..~altSSI */ \
	0x44,0x7e,0x0d,0x0a,0x3c,0x2f,0x73,0x65,0x6c,0x65,0x63,0x74,0x3e,0x0d,0x0a,0x3c, /* D~..</select>..< */ \
	0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62, /* /div>..<div><lab */ \
	0x65,0x6c,0x3e,0x44,0x65,0x73,0x74,0x69,0x6e,0x61,0x74,0x69,0x6f,0x6e,0x20,0x3a, /* el>Destination : */ \
	0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74, /* </label>..<input */ \
	0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d, /*  type="text" nam */ \
	0x65,0x3d,0x22,0x64,0x65,0x73,0x74,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22, /* e="dest" value=" */ \
	0x7e,0x64,0x65,0x73,0x74,0x69,0x6e,0x61,0x74,0x69,0x6f,0x6e,0x7e,0x22,0x20,0x73, /* ~destination~" s */ \
	0x69,0x7a,0x65,0x3d,0x22,0x31,0x30,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22, /* ize="10" class=" */ \
	0x61,0x64,0x31,0x22,0x2f,0x3e,0x0d,0x0a,0x20,0x41,0x63,0x6b,0x20,0x52,0x65,0x63, /* ad1"/>.. Ack Rec */ \
	0x65,0x69,0x76,0x65,0x64,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65, /* eived<input type */ \
	0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65, /* ="checkbox" name */ \
	0x3d,0x22,0x61,0x63,0x6b,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x31,0x22, /* ="ack" value="1" */ \
	0x20,0x7e,0x61,0x63,0x6b,0x7e,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x31,0x22,0x20, /*  ~ack~ size="1"  */ \
	0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x33,0x22,0x20,0x64,0x69,0x73,0x61, /* class="ad3" disa */ \
	0x62,0x6c,0x65,0x64,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c, /* bled /></div>..< */ \
	0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x4d,0x65,0x73,0x73,0x61, /* div><label>Messa */ \
	0x67,0x65,0x20,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69, /* ge :</label>..<i */ \
	0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22, /* nput type="text" */ \
	0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6d,0x65,0x73,0x67,0x22,0x20,0x76,0x61,0x6c, /*  name="mesg" val */ \
	0x75,0x65,0x3d,0x22,0x7e,0x6d,0x65,0x73,0x67,0x42,0x6f,0x64,0x79,0x7e,0x22,0x20, /* ue="~mesgBody~"  */ \
	0x73,0x69,0x7a,0x65,0x3d,0x22,0x34,0x30,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d, /* size="40" class= */ \
	0x22,0x61,0x64,0x31,0x22,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c, /* "ad1"/></div>..< */ \
	0x64,0x69,0x76,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d, /* div><input type= */ \
	0x22,0x62,0x75,0x74,0x74,0x6f,0x6e,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x73, /* "button" name="s */ \
	0x65,0x6e,0x64,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x53,0x65,0x6e,0x64, /* end" value="Send */ \
	0x22,0x20,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x33,0x22,0x20,0x6f, /* "  class="ad3" o */ \
	0x6e,0x43,0x6c,0x69,0x63,0x6b,0x3d,0x22,0x66,0x69,0x65,0x6c,0x64,0x63,0x68,0x65, /* nClick="fieldche */ \
	0x63,0x6b,0x28,0x29,0x22,0x20,0x20,0x2f,0x3e,0x0d,0x0a,0x26,0x6e,0x62,0x73,0x70, /* ck()"  />..&nbsp */ \
	0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79, /* ;&nbsp;<input ty */ \
	0x70,0x65,0x3d,0x22,0x62,0x75,0x74,0x74,0x6f,0x6e,0x22,0x20,0x6e,0x61,0x6d,0x65, /* pe="button" name */ \
	0x3d,0x22,0x66,0x72,0x65,0x73,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x52, /* ="fres" value="R */ \
	0x65,0x66,0x72,0x65,0x73,0x68,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61, /* efresh" class="a */ \
	0x64,0x33,0x22,0x20,0x6f,0x6e,0x43,0x6c,0x69,0x63,0x6b,0x3d,0x22,0x66,0x69,0x65, /* d3" onClick="fie */ \
	0x6c,0x64,0x72,0x65,0x6c,0x6f,0x61,0x64,0x28,0x29,0x22,0x20,0x2f,0x3e,0x0d,0x0a, /* ldreload()" />.. */ \
	0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x69,0x6e,0x70, /* &nbsp;&nbsp;<inp */ \
	0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x62,0x75,0x74,0x74,0x6f,0x6e,0x22, /* ut type="button" */ \
	0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x63,0x6c,0x61,0x72,0x22,0x20,0x76,0x61,0x6c, /*  name="clar" val */ \
	0x75,0x65,0x3d,0x22,0x43,0x6c,0x65,0x61,0x72,0x22,0x20,0x63,0x6c,0x61,0x73,0x73, /* ue="Clear" class */ \
	0x3d,0x22,0x61,0x64,0x33,0x22,0x20,0x6f,0x6e,0x43,0x6c,0x69,0x63,0x6b,0x3d,0x22, /* ="ad3" onClick=" */ \
	0x66,0x69,0x65,0x6c,0x64,0x63,0x6c,0x65,0x61,0x72,0x28,0x29,0x22,0x20,0x20,0x2f, /* fieldclear()"  / */ \
	0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x62,0x72,0x3e,0x0d, /* >..</div>..<br>. */ \
	0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x4c,0x61,0x73, /* .<div><label>Las */ \
	0x74,0x20,0x52,0x65,0x63,0x76,0x2e,0x20,0x4d,0x65,0x73,0x2e,0x20,0x49,0x6e,0x66, /* t Recv. Mes. Inf */ \
	0x6f,0x2e,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e, /* o.</label></div> */ \
	0x3c,0x62,0x72,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61, /* <br>....<div><la */ \
	0x62,0x65,0x6c,0x3e,0x53,0x65,0x6e,0x64,0x65,0x72,0x20,0x43,0x61,0x6c,0x6c,0x73, /* bel>Sender Calls */ \
	0x69,0x67,0x6e,0x20,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c, /* ign :</label>..< */ \
	0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74, /* input type="text */ \
	0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6c,0x63,0x61,0x6c,0x22,0x20,0x76,0x61, /* " name="lcal" va */ \
	0x6c,0x75,0x65,0x3d,0x22,0x7e,0x73,0x65,0x6e,0x64,0x65,0x72,0x63,0x61,0x6c,0x6c, /* lue="~sendercall */ \
	0x7e,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x31,0x30,0x22,0x20,0x63,0x6c,0x61, /* ~" size="10" cla */ \
	0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x20,0x72,0x65,0x61,0x64,0x6f,0x6e,0x6c, /* ss="ad1" readonl */ \
	0x79,0x20,0x6f,0x6e,0x43,0x6c,0x69,0x63,0x6b,0x3d,0x22,0x43,0x70,0x79,0x53,0x65  /* y onClick="CpySe */
#define DATACHUNK000005 \
	0x6e,0x64,0x65,0x72,0x43,0x61,0x6c,0x6c,0x28,0x29,0x22,0x2f,0x3e,0x3c,0x2f,0x64, /* nderCall()"/></d */ \
	0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c, /* iv>..<div><label */ \
	0x3e,0x52,0x65,0x63,0x65,0x69,0x76,0x65,0x64,0x20,0x4d,0x65,0x73,0x73,0x61,0x67, /* >Received Messag */ \
	0x65,0x20,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e, /* e :</label>..<in */ \
	0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20, /* put type="text"  */ \
	0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6c,0x6d,0x73,0x67,0x22,0x20,0x76,0x61,0x6c,0x75, /* name="lmsg" valu */ \
	0x65,0x3d,0x22,0x7e,0x4c,0x61,0x73,0x74,0x4d,0x73,0x67,0x7e,0x22,0x20,0x73,0x69, /* e="~LastMsg~" si */ \
	0x7a,0x65,0x3d,0x22,0x34,0x30,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61, /* ze="40" class="a */ \
	0x64,0x31,0x22,0x20,0x72,0x65,0x61,0x64,0x6f,0x6e,0x6c,0x79,0x20,0x6f,0x6e,0x43, /* d1" readonly onC */ \
	0x6c,0x69,0x63,0x6b,0x3d,0x22,0x43,0x70,0x79,0x4d,0x73,0x67,0x28,0x29,0x22,0x2f, /* lick="CpyMsg()"/ */ \
	0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x2f,0x66,0x69,0x65, /* ></div>....</fie */ \
	0x6c,0x64,0x73,0x65,0x74,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x6f,0x72,0x6d,0x3e,0x0d, /* ldset>..</form>. */ \
	0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74, /* .</div>..<script */ \
	0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x2f,0x6a,0x61,0x76,0x61, /*  type="text/java */ \
	0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x0d,0x0a,0x3c,0x21,0x2d,0x2d,0x0d,0x0a, /* script">..<!--.. */ \
	0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x20,0x66,0x69,0x65,0x6c,0x64,0x63,0x68, /* function fieldch */ \
	0x65,0x63,0x6b,0x28,0x29,0x0d,0x0a,0x7b,0x0d,0x0a,0x20,0x69,0x66,0x20,0x28,0x64, /* eck()..{.. if (d */ \
	0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x66,0x6f,0x72,0x6d,0x73,0x2e,0x6d,0x65, /* ocument.forms.me */ \
	0x73,0x73,0x61,0x67,0x65,0x2e,0x64,0x65,0x73,0x74,0x2e,0x76,0x61,0x6c,0x75,0x65, /* ssage.dest.value */ \
	0x2e,0x6c,0x65,0x6e,0x67,0x74,0x68,0x20,0x3d,0x3d,0x20,0x30,0x29,0x0d,0x0a,0x20, /* .length == 0)..  */ \
	0x7b,0x0d,0x0a,0x20,0x20,0x20,0x77,0x69,0x6e,0x64,0x6f,0x77,0x2e,0x61,0x6c,0x65, /* {..   window.ale */ \
	0x72,0x74,0x20,0x28,0x22,0x44,0x65,0x73,0x74,0x69,0x6e,0x61,0x74,0x69,0x6f,0x6e, /* rt ("Destination */ \
	0x20,0x69,0x73,0x20,0x65,0x6d,0x70,0x74,0x79,0x21,0x22,0x29,0x3b,0x0d,0x0a,0x20, /*  is empty!");..  */ \
	0x20,0x20,0x72,0x65,0x74,0x75,0x72,0x6e,0x3b,0x0d,0x0a,0x20,0x7d,0x20,0x0d,0x0a, /*   return;.. } .. */ \
	0x20,0x69,0x66,0x20,0x28,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x66,0x6f, /*  if (document.fo */ \
	0x72,0x6d,0x73,0x2e,0x6d,0x65,0x73,0x73,0x61,0x67,0x65,0x2e,0x6d,0x65,0x73,0x67, /* rms.message.mesg */ \
	0x2e,0x76,0x61,0x6c,0x75,0x65,0x2e,0x6c,0x65,0x6e,0x67,0x74,0x68,0x20,0x3d,0x3d, /* .value.length == */ \
	0x20,0x30,0x29,0x0d,0x0a,0x20,0x7b,0x0d,0x0a,0x20,0x20,0x20,0x77,0x69,0x6e,0x64, /*  0).. {..   wind */ \
	0x6f,0x77,0x2e,0x61,0x6c,0x65,0x72,0x74,0x20,0x28,0x22,0x4d,0x65,0x73,0x73,0x61, /* ow.alert ("Messa */ \
	0x67,0x65,0x20,0x69,0x73,0x20,0x65,0x6d,0x70,0x74,0x79,0x21,0x22,0x29,0x3b,0x0d, /* ge is empty!");. */ \
	0x0a,0x20,0x20,0x20,0x72,0x65,0x74,0x75,0x72,0x6e,0x3b,0x0d,0x0a,0x20,0x7d,0x0d, /* .   return;.. }. */ \
	0x0a,0x20,0x20,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x66,0x6f,0x72, /* .   document.for */ \
	0x6d,0x73,0x2e,0x6d,0x65,0x73,0x73,0x61,0x67,0x65,0x2e,0x73,0x75,0x62,0x6d,0x69, /* ms.message.submi */ \
	0x74,0x28,0x29,0x3b,0x20,0x0d,0x0a,0x7d,0x0d,0x0a,0x0d,0x0a,0x66,0x75,0x6e,0x63, /* t(); ..}....func */ \
	0x74,0x69,0x6f,0x6e,0x20,0x66,0x69,0x65,0x6c,0x64,0x63,0x6c,0x65,0x61,0x72,0x28, /* tion fieldclear( */ \
	0x29,0x0d,0x0a,0x7b,0x0d,0x0a,0x20,0x20,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e, /* )..{..   documen */ \
	0x74,0x2e,0x66,0x6f,0x72,0x6d,0x73,0x2e,0x6d,0x65,0x73,0x73,0x61,0x67,0x65,0x2e, /* t.forms.message. */ \
	0x64,0x65,0x73,0x74,0x2e,0x76,0x61,0x6c,0x75,0x65,0x20,0x3d,0x20,0x22,0x22,0x3b, /* dest.value = ""; */ \
	0x0d,0x0a,0x20,0x20,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x66,0x6f, /* ..   document.fo */ \
	0x72,0x6d,0x73,0x2e,0x6d,0x65,0x73,0x73,0x61,0x67,0x65,0x2e,0x6d,0x65,0x73,0x67, /* rms.message.mesg */ \
	0x2e,0x76,0x61,0x6c,0x75,0x65,0x20,0x3d,0x20,0x22,0x22,0x3b,0x0d,0x0a,0x7d,0x0d, /* .value = "";..}. */ \
	0x0a,0x0d,0x0a,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x20,0x66,0x69,0x65,0x6c, /* ...function fiel */ \
	0x64,0x72,0x65,0x6c,0x6f,0x61,0x64,0x28,0x29,0x0d,0x0a,0x7b,0x0d,0x0a,0x20,0x20, /* dreload()..{..   */ \
	0x20,0x6c,0x6f,0x63,0x61,0x74,0x69,0x6f,0x6e,0x2e,0x72,0x65,0x6c,0x6f,0x61,0x64, /*  location.reload */ \
	0x28,0x74,0x72,0x75,0x65,0x29,0x3b,0x0d,0x0a,0x7d,0x0d,0x0a,0x0d,0x0a,0x66,0x75, /* (true);..}....fu */ \
	0x6e,0x63,0x74,0x69,0x6f,0x6e,0x20,0x43,0x70,0x79,0x4d,0x73,0x67,0x28,0x29,0x0d, /* nction CpyMsg(). */ \
	0x0a,0x7b,0x0d,0x0a,0x20,0x20,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e, /* .{..   document. */ \
	0x66,0x6f,0x72,0x6d,0x73,0x2e,0x6d,0x65,0x73,0x73,0x61,0x67,0x65,0x2e,0x6d,0x65, /* forms.message.me */ \
	0x73,0x67,0x2e,0x76,0x61,0x6c,0x75,0x65,0x20,0x3d,0x20,0x64,0x6f,0x63,0x75,0x6d, /* sg.value = docum */ \
	0x65,0x6e,0x74,0x2e,0x66,0x6f,0x72,0x6d,0x73,0x2e,0x6d,0x65,0x73,0x73,0x61,0x67, /* ent.forms.messag */ \
	0x65,0x2e,0x6c,0x6d,0x73,0x67,0x2e,0x76,0x61,0x6c,0x75,0x65,0x3b,0x0d,0x0a,0x7d, /* e.lmsg.value;..} */ \
	0x0d,0x0a,0x0d,0x0a,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x20,0x43,0x70,0x79, /* ....function Cpy */ \
	0x53,0x65,0x6e,0x64,0x65,0x72,0x43,0x61,0x6c,0x6c,0x28,0x29,0x0d,0x0a,0x7b,0x0d, /* SenderCall()..{. */ \
	0x0a,0x20,0x20,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x66,0x6f,0x72, /* .   document.for */ \
	0x6d,0x73,0x2e,0x6d,0x65,0x73,0x73,0x61,0x67,0x65,0x2e,0x64,0x65,0x73,0x74,0x2e, /* ms.message.dest. */ \
	0x76,0x61,0x6c,0x75,0x65,0x20,0x3d,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74, /* value = document */ \
	0x2e,0x66,0x6f,0x72,0x6d,0x73,0x2e,0x6d,0x65,0x73,0x73,0x61,0x67,0x65,0x2e,0x6c, /* .forms.message.l */ \
	0x63,0x61,0x6c,0x2e,0x76,0x61,0x6c,0x75,0x65,0x3b,0x0d,0x0a,0x7d,0x0d,0x0a,0x2f, /* cal.value;..}../ */ \
	0x2f,0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74,0x3e,0x0d, /* /-->..</script>. */ \
	0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e,0x63, /* .~inc:footer.inc */ \
	0x7e,0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0xcb,0x00,0x00, /* ~....3.......... */ \
	0x00,0x0b,0x01,0x00,0x00,0xcc,0x00,0x00,0x00,0x72,0x01,0x00,0x00,0xb8,0x00,0x00, /* .........r...... */ \
	0x00,0xd3,0x01,0x00,0x00,0xc8,0x00,0x00,0x00,0x46,0x02,0x00,0x00,0xb9,0x00,0x00, /* .........F...... */ \
	0x00,0x27,0x04,0x00,0x00,0xcd,0x00,0x00,0x00,0xc5,0x04,0x00,0x00,0xce,0x00,0x00  /* .'.............. */
#define DATACHUNK000006 \
	0x00,0x13,0x08,0x00,0x00,0x02,0x00,0x00,0x00,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65, /* .........~inc:he */ \
	0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20, /* ader.inc~..<div  */ \
	0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d, /* id="content">... */ \
	0x0a,0x3c,0x68,0x31,0x3e,0x44,0x50,0x52,0x53,0x20,0x43,0x6f,0x6e,0x66,0x69,0x67, /* .<h1>DPRS Config */ \
	0x75,0x72,0x61,0x74,0x69,0x6f,0x6e,0x3c,0x2f,0x68,0x31,0x3e,0x0d,0x0a,0x0d,0x0a, /* uration</h1>.... */ \
	0x3c,0x66,0x6f,0x72,0x6d,0x20,0x6d,0x65,0x74,0x68,0x6f,0x64,0x3d,0x22,0x70,0x6f, /* <form method="po */ \
	0x73,0x74,0x22,0x20,0x61,0x63,0x74,0x69,0x6f,0x6e,0x3d,0x22,0x2f,0x64,0x70,0x72, /* st" action="/dpr */ \
	0x73,0x2e,0x68,0x74,0x6d,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x64,0x70,0x72, /* s.htm" name="dpr */ \
	0x73,0x22,0x3e,0x0d,0x0a,0x3c,0x66,0x69,0x65,0x6c,0x64,0x73,0x65,0x74,0x3e,0x0d, /* s">..<fieldset>. */ \
	0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70, /* .<div><input typ */ \
	0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x63,0x6c,0x61, /* e="checkbox" cla */ \
	0x73,0x73,0x3d,0x22,0x73,0x6d,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x64,0x70, /* ss="sm" name="dp */ \
	0x73,0x77,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x31,0x22,0x20,0x6f,0x6e, /* sw" value="1" on */ \
	0x63,0x6c,0x69,0x63,0x6b,0x3d,0x22,0x63,0x6f,0x6e,0x66,0x69,0x67,0x44,0x50,0x52, /* click="configDPR */ \
	0x53,0x42,0x6f,0x78,0x65,0x73,0x28,0x29,0x22,0x20,0x7e,0x44,0x50,0x52,0x53,0x5f, /* SBoxes()" ~DPRS_ */ \
	0x63,0x68,0x65,0x63,0x6b,0x65,0x64,0x7e,0x20,0x2f,0x3e,0x20,0x45,0x6e,0x61,0x62, /* checked~ /> Enab */ \
	0x6c,0x65,0x20,0x44,0x50,0x52,0x53,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c, /* le DPRS</div>..< */ \
	0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x44,0x50,0x52,0x53,0x20, /* div><label>DPRS  */ \
	0x53,0x65,0x72,0x76,0x65,0x72,0x20,0x49,0x50,0x20,0x3a,0x3c,0x2f,0x6c,0x61,0x62, /* Server IP :</lab */ \
	0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65, /* el>..<input type */ \
	0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x64,0x70, /* ="text" name="dp */ \
	0x69,0x70,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x64,0x70,0x72,0x73, /* ip" value="~dprs */ \
	0x69,0x70,0x7e,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x32,0x30,0x22,0x20,0x63, /* ip~" size="20" c */ \
	0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x3e,0x3c,0x2f,0x64,0x69,0x76, /* lass="ad1"></div */ \
	0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x44, /* >..<div><label>D */ \
	0x50,0x52,0x53,0x20,0x53,0x65,0x72,0x76,0x65,0x72,0x20,0x50,0x6f,0x72,0x74,0x20, /* PRS Server Port  */ \
	0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75, /* :</label>..<inpu */ \
	0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61, /* t type="text" na */ \
	0x6d,0x65,0x3d,0x22,0x64,0x70,0x70,0x74,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d, /* me="dppt" value= */ \
	0x22,0x7e,0x64,0x70,0x72,0x73,0x70,0x6f,0x72,0x74,0x7e,0x22,0x20,0x73,0x69,0x7a, /* "~dprsport~" siz */ \
	0x65,0x3d,0x22,0x35,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31, /* e="5" class="ad1 */ \
	0x22,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c, /* "></div>..<div>< */ \
	0x6c,0x61,0x62,0x65,0x6c,0x3e,0x59,0x6f,0x75,0x72,0x20,0x43,0x61,0x6c,0x6c,0x73, /* label>Your Calls */ \
	0x69,0x67,0x6e,0x20,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c, /* ign :</label>..< */ \
	0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74, /* input type="text */ \
	0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x64,0x70,0x63,0x6c,0x22,0x20,0x76,0x61, /* " name="dpcl" va */ \
	0x6c,0x75,0x65,0x3d,0x22,0x7e,0x64,0x70,0x72,0x73,0x63,0x61,0x6c,0x6c,0x7e,0x22, /* lue="~dprscall~" */ \
	0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x37,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d, /*  size="7" class= */ \
	0x22,0x61,0x64,0x31,0x22,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64, /* "ad1"></div>..<d */ \
	0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x44,0x2d,0x53,0x54,0x41,0x52, /* iv><label>D-STAR */ \
	0x20,0x49,0x44,0x20,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c, /*  ID :</label>..< */ \
	0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74, /* input type="text */ \
	0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x64,0x73,0x69,0x64,0x22,0x20,0x76,0x61, /* " name="dsid" va */ \
	0x6c,0x75,0x65,0x3d,0x22,0x7e,0x64,0x73,0x74,0x61,0x72,0x69,0x64,0x7e,0x22,0x20, /* lue="~dstarid~"  */ \
	0x73,0x69,0x7a,0x65,0x3d,0x22,0x31,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22, /* size="1" class=" */ \
	0x61,0x64,0x31,0x22,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69, /* ad1"></div>..<di */ \
	0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x56,0x61,0x6c,0x69,0x64,0x61,0x74, /* v><label>Validat */ \
	0x69,0x6f,0x6e,0x20,0x43,0x6f,0x64,0x65,0x20,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65, /* ion Code :</labe */ \
	0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d, /* l>..<input type= */ \
	0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x64,0x70,0x63, /* "text" name="dpc */ \
	0x64,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x64,0x70,0x72,0x73,0x76, /* d" value="~dprsv */ \
	0x61,0x6c,0x69,0x64,0x7e,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x37,0x22,0x20, /* alid~" size="7"  */ \
	0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x3e,0x3c,0x2f,0x64,0x69, /* class="ad1"></di */ \
	0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e, /* v>..<div><label> */ \
	0x43,0x6c,0x69,0x65,0x6e,0x74,0x20,0x49,0x6e,0x66,0x6f,0x6d,0x61,0x74,0x69,0x6f, /* Client Infomatio */ \
	0x6e,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x3c, /* n</label></div>< */ \
	0x62,0x72,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c, /* br>..<div><label */ \
	0x3e,0x4c,0x61,0x74,0x69,0x74,0x75,0x64,0x65,0x20,0x3a,0x3c,0x2f,0x6c,0x61,0x62, /* >Latitude :</lab */ \
	0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65, /* el>..<input type */ \
	0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x70,0x6c, /* ="text" name="pl */ \
	0x61,0x74,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x70,0x6c,0x61,0x74, /* at" value="~plat */ \
	0x7e,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x38,0x22,0x20,0x63,0x6c,0x61,0x73, /* ~" size="8" clas */ \
	0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a, /* s="ad1"></div>.. */ \
	0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x4c,0x6f,0x6e,0x67  /* <div><label>Long */
#define DATACHUNK000007 \
	0x69,0x74,0x75,0x64,0x65,0x20,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d, /* itude :</label>. */ \
	0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65, /* .<input type="te */ \
	0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x70,0x6c,0x6e,0x67,0x22,0x20, /* xt" name="plng"  */ \
	0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x70,0x6c,0x6f,0x6e,0x67,0x7e,0x22,0x20, /* value="~plong~"  */ \
	0x73,0x69,0x7a,0x65,0x3d,0x22,0x39,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22, /* size="9" class=" */ \
	0x61,0x64,0x31,0x22,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69, /* ad1"></div>..<di */ \
	0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x43,0x6f,0x6d,0x6d,0x65,0x6e,0x74, /* v><label>Comment */ \
	0x20,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70, /*  :</label>..<inp */ \
	0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e, /* ut type="text" n */ \
	0x61,0x6d,0x65,0x3d,0x22,0x70,0x63,0x6d,0x74,0x22,0x20,0x76,0x61,0x6c,0x75,0x65, /* ame="pcmt" value */ \
	0x3d,0x22,0x7e,0x70,0x63,0x6f,0x6d,0x6d,0x65,0x6e,0x74,0x7e,0x22,0x20,0x73,0x69, /* ="~pcomment~" si */ \
	0x7a,0x65,0x3d,0x22,0x32,0x30,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61, /* ze="20" class="a */ \
	0x64,0x31,0x22,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x64, /* d1"></div>....<d */ \
	0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x41,0x63,0x63,0x65,0x70,0x74, /* iv><label>Accept */ \
	0x20,0x66,0x72,0x6f,0x6d,0x20,0x52,0x61,0x64,0x69,0x6f,0x20,0x3a,0x3c,0x2f,0x6c, /*  from Radio :</l */ \
	0x61,0x62,0x65,0x6c,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65, /* abel><input type */ \
	0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65, /* ="checkbox" name */ \
	0x3d,0x22,0x64,0x70,0x72,0x64,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x73, /* ="dprd" class="s */ \
	0x6d,0x22,0x20,0x7e,0x64,0x70,0x72,0x73,0x52,0x61,0x64,0x69,0x6f,0x7e,0x20,0x76, /* m" ~dprsRadio~ v */ \
	0x61,0x6c,0x75,0x65,0x3d,0x22,0x31,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76, /* alue="1" /></div */ \
	0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x41, /* >..<div><label>A */ \
	0x63,0x63,0x65,0x70,0x74,0x20,0x66,0x72,0x6f,0x6d,0x20,0x49,0x6e,0x65,0x74,0x20, /* ccept from Inet  */ \
	0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20, /* :</label><input  */ \
	0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20, /* type="checkbox"  */ \
	0x6e,0x61,0x6d,0x65,0x3d,0x22,0x64,0x70,0x69,0x74,0x22,0x20,0x63,0x6c,0x61,0x73, /* name="dpit" clas */ \
	0x73,0x3d,0x22,0x73,0x6d,0x22,0x20,0x7e,0x64,0x70,0x72,0x73,0x49,0x6e,0x65,0x74, /* s="sm" ~dprsInet */ \
	0x7e,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x31,0x22,0x20,0x2f,0x3e,0x3c,0x2f, /* ~ value="1" /></ */ \
	0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x69,0x6e,0x70,0x75, /* div>..<div><inpu */ \
	0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x73,0x75,0x62,0x6d,0x69,0x74,0x22,0x20, /* t type="submit"  */ \
	0x6e,0x61,0x6d,0x65,0x20,0x3d,0x22,0x73,0x75,0x62,0x22,0x20,0x63,0x6c,0x61,0x73, /* name ="sub" clas */ \
	0x73,0x3d,0x22,0x73,0x6d,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x53,0x61, /* s="sm" value="Sa */ \
	0x76,0x65,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x2f, /* ve" /></div>..</ */ \
	0x66,0x69,0x65,0x6c,0x64,0x73,0x65,0x74,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x2f,0x66, /* fieldset>....</f */ \
	0x6f,0x72,0x6d,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a, /* orm>..</div>.... */ \
	0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x6c,0x61,0x6e,0x67,0x75,0x61,0x67,0x65, /* <script language */ \
	0x3d,0x22,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x0d,0x0a, /* ="javascript">.. */ \
	0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x20,0x63,0x6f,0x6e,0x66,0x69,0x67,0x44, /* function configD */ \
	0x50,0x52,0x53,0x42,0x6f,0x78,0x65,0x73,0x28,0x29,0x20,0x7b,0x0d,0x0a,0x09,0x65, /* PRSBoxes() {...e */ \
	0x20,0x3d,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x66,0x6f,0x72,0x6d, /*  = document.form */ \
	0x73,0x2e,0x64,0x70,0x72,0x73,0x3b,0x0d,0x0a,0x09,0x69,0x66,0x20,0x28,0x21,0x64, /* s.dprs;...if (!d */ \
	0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x66,0x6f,0x72,0x6d,0x73,0x2e,0x64,0x70, /* ocument.forms.dp */ \
	0x72,0x73,0x2e,0x64,0x70,0x73,0x77,0x2e,0x63,0x68,0x65,0x63,0x6b,0x65,0x64,0x29, /* rs.dpsw.checked) */ \
	0x0d,0x0a,0x09,0x7b,0x0d,0x0a,0x09,0x20,0x20,0x65,0x2e,0x64,0x70,0x69,0x70,0x2e, /* ...{...  e.dpip. */ \
	0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x74,0x72,0x75,0x65,0x3b, /* disabled = true; */ \
	0x0d,0x0a,0x09,0x20,0x20,0x65,0x2e,0x64,0x70,0x70,0x74,0x2e,0x64,0x69,0x73,0x61, /* ...  e.dppt.disa */ \
	0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x74,0x72,0x75,0x65,0x3b,0x0d,0x0a,0x09,0x20, /* bled = true;...  */ \
	0x20,0x65,0x2e,0x64,0x70,0x63,0x6c,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64, /*  e.dpcl.disabled */ \
	0x20,0x3d,0x20,0x74,0x72,0x75,0x65,0x3b,0x0d,0x0a,0x09,0x20,0x20,0x65,0x2e,0x64, /*  = true;...  e.d */ \
	0x73,0x69,0x64,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x74, /* sid.disabled = t */ \
	0x72,0x75,0x65,0x3b,0x0d,0x0a,0x09,0x20,0x20,0x65,0x2e,0x64,0x70,0x63,0x64,0x2e, /* rue;...  e.dpcd. */ \
	0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x74,0x72,0x75,0x65,0x3b, /* disabled = true; */ \
	0x0d,0x0a,0x09,0x7d,0x0d,0x0a,0x09,0x65,0x6c,0x73,0x65,0x0d,0x0a,0x09,0x7b,0x0d, /* ...}...else...{. */ \
	0x0a,0x09,0x20,0x20,0x65,0x2e,0x64,0x70,0x69,0x70,0x2e,0x64,0x69,0x73,0x61,0x62, /* ..  e.dpip.disab */ \
	0x6c,0x65,0x64,0x20,0x3d,0x20,0x66,0x61,0x6c,0x73,0x65,0x3b,0x0d,0x0a,0x09,0x20, /* led = false;...  */ \
	0x20,0x65,0x2e,0x64,0x70,0x70,0x74,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64, /*  e.dppt.disabled */ \
	0x20,0x3d,0x20,0x66,0x61,0x6c,0x73,0x65,0x3b,0x0d,0x0a,0x09,0x20,0x20,0x65,0x2e, /*  = false;...  e. */ \
	0x64,0x70,0x63,0x6c,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20, /* dpcl.disabled =  */ \
	0x66,0x61,0x6c,0x73,0x65,0x3b,0x0d,0x0a,0x09,0x20,0x20,0x65,0x2e,0x64,0x73,0x69, /* false;...  e.dsi */ \
	0x64,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x66,0x61,0x6c, /* d.disabled = fal */ \
	0x73,0x65,0x3b,0x0d,0x0a,0x09,0x20,0x20,0x65,0x2e,0x64,0x70,0x63,0x64,0x2e,0x64, /* se;...  e.dpcd.d */ \
	0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x66,0x61,0x6c,0x73,0x65,0x3b, /* isabled = false; */ \
	0x0d,0x0a,0x09,0x7d,0x0d,0x0a,0x7d,0x0d,0x0a,0x2f,0x2f,0x2d,0x2d,0x3e,0x0d,0x0a, /* ...}..}..//-->.. */ \
	0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74,0x3e,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a, /* </script>..~inc: */ \
	0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x00,0x00,0x00,0x00,0x33  /* footer.inc~....3 */
#define DATACHUNK000008 \
	0x00,0x00,0x00,0xe1,0x00,0x00,0x00,0xb1,0x00,0x00,0x00,0x52,0x01,0x00,0x00,0xac, /* ...........R.... */ \
	0x00,0x00,0x00,0xc8,0x01,0x00,0x00,0xad,0x00,0x00,0x00,0x3c,0x02,0x00,0x00,0xae, /* ...........<.... */ \
	0x00,0x00,0x00,0xac,0x02,0x00,0x00,0xaf,0x00,0x00,0x00,0x21,0x03,0x00,0x00,0xb0, /* ...........!.... */ \
	0x00,0x00,0x00,0xc2,0x03,0x00,0x00,0xb5,0x00,0x00,0x00,0x2e,0x04,0x00,0x00,0xb6, /* ................ */ \
	0x00,0x00,0x00,0x99,0x04,0x00,0x00,0xb7,0x00,0x00,0x00,0x1a,0x05,0x00,0x00,0xb2, /* ................ */ \
	0x00,0x00,0x00,0x8e,0x05,0x00,0x00,0xb3,0x00,0x00,0x00,0xe2,0x07,0x00,0x00,0x02, /* ................ */ \
	0x00,0x00,0x00,0x3c,0x64,0x69,0x76,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x73, /* ...<div class="s */ \
	0x70,0x61,0x63,0x65,0x72,0x22,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x64, /* pacer">&nbsp;</d */ \
	0x69,0x76,0x3e,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x66,0x6f,0x6f, /* iv>.<div id="foo */ \
	0x74,0x65,0x72,0x22,0x3e,0x43,0x6f,0x70,0x79,0x72,0x69,0x67,0x68,0x74,0x20,0x26, /* ter">Copyright & */ \
	0x63,0x6f,0x70,0x79,0x3b,0x20,0x32,0x30,0x31,0x31,0x2d,0x32,0x30,0x31,0x32,0x20, /* copy; 2011-2012  */ \
	0x53,0x61,0x74,0x6f,0x73,0x68,0x69,0x20,0x59,0x61,0x73,0x75,0x64,0x61,0x20,0x37, /* Satoshi Yasuda 7 */ \
	0x6d,0x33,0x74,0x6a,0x7a,0x2f,0x61,0x64,0x36,0x67,0x7a,0x3c,0x2f,0x64,0x69,0x76, /* m3tjz/ad6gz</div */ \
	0x3e,0x0a,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x3c, /* >..</div></div>< */ \
	0x2f,0x64,0x69,0x76,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x3c,0x2f,0x64,0x69,0x76, /* /div></div></div */ \
	0x3e,0x0a,0x0a,0x3c,0x2f,0x62,0x6f,0x64,0x79,0x3e,0x0a,0x3c,0x2f,0x68,0x74,0x6d, /* >..</body>.</htm */ \
	0x6c,0x3e,0x3c,0x21,0x44,0x4f,0x43,0x54,0x59,0x50,0x45,0x20,0x68,0x74,0x6d,0x6c, /* l><!DOCTYPE html */ \
	0x20,0x50,0x55,0x42,0x4c,0x49,0x43,0x20,0x22,0x2d,0x2f,0x2f,0x57,0x33,0x43,0x2f, /*  PUBLIC "-//W3C/ */ \
	0x2f,0x44,0x54,0x44,0x20,0x58,0x48,0x54,0x4d,0x4c,0x20,0x31,0x2e,0x30,0x20,0x53, /* /DTD XHTML 1.0 S */ \
	0x74,0x72,0x69,0x63,0x74,0x2f,0x2f,0x45,0x4e,0x22,0x0d,0x0a,0x20,0x20,0x22,0x68, /* trict//EN"..  "h */ \
	0x74,0x74,0x70,0x3a,0x2f,0x2f,0x77,0x77,0x77,0x2e,0x77,0x33,0x2e,0x6f,0x72,0x67, /* ttp://www.w3.org */ \
	0x2f,0x54,0x52,0x2f,0x78,0x68,0x74,0x6d,0x6c,0x31,0x2f,0x44,0x54,0x44,0x2f,0x78, /* /TR/xhtml1/DTD/x */ \
	0x68,0x74,0x6d,0x6c,0x31,0x2d,0x73,0x74,0x72,0x69,0x63,0x74,0x2e,0x64,0x74,0x64, /* html1-strict.dtd */ \
	0x22,0x3e,0x0d,0x0a,0x3c,0x68,0x74,0x6d,0x6c,0x20,0x78,0x6d,0x6c,0x6e,0x73,0x3d, /* ">..<html xmlns= */ \
	0x22,0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,0x77,0x77,0x77,0x2e,0x77,0x33,0x2e,0x6f, /* "http://www.w3.o */ \
	0x72,0x67,0x2f,0x31,0x39,0x39,0x39,0x2f,0x78,0x68,0x74,0x6d,0x6c,0x22,0x20,0x78, /* rg/1999/xhtml" x */ \
	0x6d,0x6c,0x3a,0x6c,0x61,0x6e,0x67,0x3d,0x22,0x65,0x6e,0x22,0x20,0x6c,0x61,0x6e, /* ml:lang="en" lan */ \
	0x67,0x3d,0x22,0x65,0x6e,0x22,0x3e,0x0d,0x0a,0x3c,0x68,0x65,0x61,0x64,0x3e,0x0d, /* g="en">..<head>. */ \
	0x0a,0x3c,0x74,0x69,0x74,0x6c,0x65,0x3e,0x53,0x74,0x61,0x6e,0x64,0x20,0x41,0x6c, /* .<title>Stand Al */ \
	0x6f,0x6e,0x65,0x20,0x41,0x63,0x63,0x65,0x73,0x73,0x20,0x50,0x6f,0x69,0x6e,0x74, /* one Access Point */ \
	0x3c,0x2f,0x74,0x69,0x74,0x6c,0x65,0x3e,0x0d,0x0a,0x3c,0x6c,0x69,0x6e,0x6b,0x20, /* </title>..<link  */ \
	0x68,0x72,0x65,0x66,0x3d,0x22,0x2f,0x37,0x6d,0x33,0x74,0x6a,0x7a,0x2e,0x63,0x73, /* href="/7m3tjz.cs */ \
	0x73,0x22,0x20,0x72,0x65,0x6c,0x3d,0x22,0x73,0x74,0x79,0x6c,0x65,0x73,0x68,0x65, /* s" rel="styleshe */ \
	0x65,0x74,0x22,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x2f,0x63, /* et" type="text/c */ \
	0x73,0x73,0x22,0x20,0x2f,0x3e,0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20, /* ss" />..<script  */ \
	0x73,0x72,0x63,0x3d,0x22,0x2f,0x37,0x6d,0x33,0x74,0x6a,0x7a,0x2e,0x6a,0x73,0x22, /* src="/7m3tjz.js" */ \
	0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x2f,0x6a,0x61,0x76,0x61, /*  type="text/java */ \
	0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74, /* script"></script */ \
	0x3e,0x0d,0x0a,0x3c,0x2f,0x68,0x65,0x61,0x64,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x73, /* >..</head>....<s */ \
	0x63,0x72,0x69,0x70,0x74,0x20,0x6c,0x61,0x6e,0x67,0x75,0x61,0x67,0x65,0x3d,0x22, /* cript language=" */ \
	0x4a,0x61,0x76,0x61,0x53,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x0d,0x0a,0x3c,0x21, /* JavaScript">..<! */ \
	0x2d,0x2d,0x0d,0x0a,0x2f,0x2f,0x20,0x74,0x72,0x65,0x65,0x20,0x6d,0x65,0x6e,0x75, /* --..// tree menu */ \
	0x0d,0x0a,0x66,0x6c,0x61,0x67,0x20,0x3d,0x20,0x66,0x61,0x6c,0x73,0x65,0x3b,0x0d, /* ..flag = false;. */ \
	0x0a,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x20,0x74,0x72,0x65,0x65,0x4d,0x65, /* .function treeMe */ \
	0x6e,0x75,0x28,0x74,0x4e,0x61,0x6d,0x65,0x29,0x20,0x7b,0x0d,0x0a,0x20,0x20,0x74, /* nu(tName) {..  t */ \
	0x4d,0x65,0x6e,0x75,0x20,0x3d,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e, /* Menu = document. */ \
	0x61,0x6c,0x6c,0x5b,0x74,0x4e,0x61,0x6d,0x65,0x5d,0x2e,0x73,0x74,0x79,0x6c,0x65, /* all[tName].style */ \
	0x3b,0x0d,0x0a,0x20,0x20,0x69,0x66,0x28,0x74,0x4d,0x65,0x6e,0x75,0x2e,0x64,0x69, /* ;..  if(tMenu.di */ \
	0x73,0x70,0x6c,0x61,0x79,0x20,0x3d,0x3d,0x20,0x27,0x6e,0x6f,0x6e,0x65,0x27,0x29, /* splay == 'none') */ \
	0x20,0x74,0x4d,0x65,0x6e,0x75,0x2e,0x64,0x69,0x73,0x70,0x6c,0x61,0x79,0x20,0x3d, /*  tMenu.display = */ \
	0x20,0x22,0x62,0x6c,0x6f,0x63,0x6b,0x22,0x3b,0x0d,0x0a,0x20,0x20,0x65,0x6c,0x73, /*  "block";..  els */ \
	0x65,0x20,0x74,0x4d,0x65,0x6e,0x75,0x2e,0x64,0x69,0x73,0x70,0x6c,0x61,0x79,0x20, /* e tMenu.display  */ \
	0x3d,0x20,0x22,0x6e,0x6f,0x6e,0x65,0x22,0x3b,0x0d,0x0a,0x7d,0x0d,0x0a,0x2f,0x2f, /* = "none";..}..// */ \
	0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74,0x3e,0x0d,0x0a, /* -->..</script>.. */ \
	0x0d,0x0a,0x3c,0x62,0x6f,0x64,0x79,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69, /* ..<body>..<div i */ \
	0x64,0x3d,0x22,0x73,0x68,0x61,0x64,0x6f,0x77,0x2d,0x6f,0x6e,0x65,0x22,0x3e,0x3c, /* d="shadow-one">< */ \
	0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x73,0x68,0x61,0x64,0x6f,0x77,0x2d,0x74, /* div id="shadow-t */ \
	0x77,0x6f,0x22,0x3e,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x73,0x68,0x61, /* wo"><div id="sha */ \
	0x64,0x6f,0x77,0x2d,0x74,0x68,0x72,0x65,0x65,0x22,0x3e,0x3c,0x64,0x69,0x76,0x20, /* dow-three"><div  */ \
	0x69,0x64,0x3d,0x22,0x73,0x68,0x61,0x64,0x6f,0x77,0x2d,0x66,0x6f,0x75,0x72,0x22, /* id="shadow-four" */ \
	0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x70,0x61,0x67,0x65, /* >..<div id="page */ \
	0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x74, /* ">....<div id="t */ \
	0x69,0x74,0x6c,0x65,0x22,0x3e,0x3c,0x64,0x69,0x76,0x20,0x63,0x6c,0x61,0x73,0x73, /* itle"><div class */ \
	0x3d,0x22,0x72,0x69,0x67,0x68,0x74,0x22,0x3e,0x64,0x53,0x71,0x75,0x61,0x72,0x65  /* ="right">dSquare */
#define DATACHUNK000009 \
	0x20,0x53,0x74,0x61,0x6e,0x64,0x20,0x41,0x6c,0x6f,0x6e,0x65,0x20,0x41,0x63,0x63, /*  Stand Alone Acc */ \
	0x65,0x73,0x73,0x20,0x50,0x6f,0x69,0x6e,0x74,0x20,0x56,0x30,0x30,0x2e,0x33,0x32, /* ess Point V00.32 */ \
	0x3c,0x2f,0x64,0x69,0x76,0x3e,0x3c,0x73,0x70,0x61,0x6e,0x20,0x69,0x64,0x3d,0x22, /* </div><span id=" */ \
	0x68,0x65,0x6c,0x6c,0x6f,0x22,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x73, /* hello">&nbsp;</s */ \
	0x70,0x61,0x6e,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76, /* pan></div>..<div */ \
	0x20,0x69,0x64,0x3d,0x22,0x6d,0x65,0x6e,0x75,0x22,0x3e,0x0d,0x0a,0x3c,0x61,0x20, /*  id="menu">..<a  */ \
	0x68,0x72,0x65,0x66,0x3d,0x22,0x2f,0x69,0x6e,0x64,0x65,0x78,0x2e,0x68,0x74,0x6d, /* href="/index.htm */ \
	0x22,0x3e,0x4f,0x76,0x65,0x72,0x76,0x69,0x65,0x77,0x3c,0x2f,0x61,0x3e,0x0d,0x0a, /* ">Overview</a>.. */ \
	0x3c,0x61,0x20,0x68,0x72,0x65,0x66,0x3d,0x22,0x2f,0x73,0x74,0x61,0x74,0x75,0x73, /* <a href="/status */ \
	0x2e,0x68,0x74,0x6d,0x22,0x3e,0x43,0x75,0x72,0x72,0x65,0x6e,0x74,0x20,0x53,0x74, /* .htm">Current St */ \
	0x61,0x74,0x75,0x73,0x3c,0x2f,0x61,0x3e,0x0d,0x0a,0x3c,0x61,0x20,0x68,0x72,0x65, /* atus</a>..<a hre */ \
	0x66,0x3d,0x22,0x2f,0x61,0x70,0x72,0x73,0x6d,0x73,0x67,0x2e,0x68,0x74,0x6d,0x22, /* f="/aprsmsg.htm" */ \
	0x3e,0x41,0x50,0x52,0x53,0x20,0x4d,0x73,0x67,0x2e,0x20,0x53,0x65,0x6e,0x64,0x3c, /* >APRS Msg. Send< */ \
	0x2f,0x61,0x3e,0x0d,0x0a,0x3c,0x41,0x20,0x68,0x72,0x65,0x66,0x3d,0x22,0x6a,0x61, /* /a>..<A href="ja */ \
	0x76,0x61,0x53,0x63,0x72,0x69,0x70,0x74,0x3a,0x74,0x72,0x65,0x65,0x4d,0x65,0x6e, /* vaScript:treeMen */ \
	0x75,0x28,0x27,0x74,0x72,0x65,0x65,0x4d,0x65,0x6e,0x75,0x31,0x27,0x29,0x22,0x3e, /* u('treeMenu1')"> */ \
	0x2b,0x20,0x53,0x41,0x41,0x50,0x20,0x53,0x65,0x74,0x74,0x69,0x6e,0x67,0x3c,0x2f, /* + SAAP Setting</ */ \
	0x61,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x74,0x72,0x65, /* a>..<div id="tre */ \
	0x65,0x4d,0x65,0x6e,0x75,0x31,0x22,0x20,0x73,0x74,0x79,0x6c,0x65,0x3d,0x22,0x64, /* eMenu1" style="d */ \
	0x69,0x73,0x70,0x6c,0x61,0x79,0x3a,0x6e,0x6f,0x6e,0x65,0x22,0x3e,0x0d,0x0a,0x3c, /* isplay:none">..< */ \
	0x61,0x20,0x68,0x72,0x65,0x66,0x3d,0x22,0x2f,0x70,0x72,0x6f,0x74,0x65,0x63,0x74, /* a href="/protect */ \
	0x2f,0x63,0x6f,0x6e,0x66,0x69,0x67,0x2e,0x68,0x74,0x6d,0x22,0x3e,0x4e,0x65,0x74, /* /config.htm">Net */ \
	0x77,0x6f,0x72,0x6b,0x20,0x43,0x6f,0x6e,0x66,0x69,0x67,0x75,0x72,0x61,0x74,0x69, /* work Configurati */ \
	0x6f,0x6e,0x3c,0x2f,0x61,0x3e,0x0d,0x0a,0x3c,0x61,0x20,0x68,0x72,0x65,0x66,0x3d, /* on</a>..<a href= */ \
	0x22,0x2f,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x67,0x61,0x74,0x65,0x77,0x61, /* "/protect/gatewa */ \
	0x79,0x61,0x75,0x74,0x68,0x2e,0x68,0x74,0x6d,0x22,0x3e,0x47,0x61,0x74,0x65,0x77, /* yauth.htm">Gatew */ \
	0x61,0x79,0x20,0x41,0x75,0x74,0x68,0x2e,0x20,0x43,0x61,0x6c,0x6c,0x73,0x69,0x67, /* ay Auth. Callsig */ \
	0x6e,0x3c,0x2f,0x61,0x3e,0x0d,0x0a,0x3c,0x61,0x20,0x68,0x72,0x65,0x66,0x3d,0x22, /* n</a>..<a href=" */ \
	0x2f,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x75,0x73,0x65,0x72,0x2e,0x68,0x74, /* /protect/user.ht */ \
	0x6d,0x22,0x3e,0x55,0x73,0x65,0x72,0x20,0x49,0x44,0x20,0x26,0x20,0x50,0x61,0x73, /* m">User ID & Pas */ \
	0x73,0x77,0x6f,0x72,0x64,0x20,0x73,0x65,0x74,0x74,0x69,0x6e,0x67,0x3c,0x2f,0x61, /* sword setting</a */ \
	0x3e,0x0d,0x0a,0x3c,0x61,0x20,0x68,0x72,0x65,0x66,0x3d,0x22,0x2f,0x70,0x72,0x6f, /* >..<a href="/pro */ \
	0x74,0x65,0x63,0x74,0x2f,0x75,0x70,0x64,0x61,0x74,0x65,0x2e,0x68,0x74,0x6d,0x22, /* tect/update.htm" */ \
	0x3e,0x46,0x69,0x72,0x6d,0x77,0x61,0x72,0x65,0x20,0x55,0x70,0x64,0x61,0x74,0x65, /* >Firmware Update */ \
	0x3c,0x2f,0x61,0x3e,0x0d,0x0a,0x3c,0x61,0x20,0x68,0x72,0x65,0x66,0x3d,0x22,0x2f, /* </a>..<a href="/ */ \
	0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x61,0x63,0x63,0x65,0x73,0x73,0x2e,0x68, /* protect/access.h */ \
	0x74,0x6d,0x22,0x3e,0x41,0x63,0x63,0x65,0x73,0x73,0x20,0x43,0x6f,0x6e,0x74,0x72, /* tm">Access Contr */ \
	0x6f,0x6c,0x20,0x46,0x69,0x6c,0x65,0x3c,0x2f,0x61,0x3e,0x0d,0x0a,0x3c,0x61,0x20, /* ol File</a>..<a  */ \
	0x68,0x72,0x65,0x66,0x3d,0x22,0x2f,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x72, /* href="/protect/r */ \
	0x65,0x62,0x6f,0x6f,0x74,0x2e,0x68,0x74,0x6d,0x22,0x3e,0x52,0x65,0x62,0x6f,0x6f, /* eboot.htm">Reboo */ \
	0x74,0x3c,0x2f,0x61,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c, /* t</a>..</div>..< */ \
	0x41,0x20,0x68,0x72,0x65,0x66,0x3d,0x22,0x6a,0x61,0x76,0x61,0x53,0x63,0x72,0x69, /* A href="javaScri */ \
	0x70,0x74,0x3a,0x74,0x72,0x65,0x65,0x4d,0x65,0x6e,0x75,0x28,0x27,0x74,0x72,0x65, /* pt:treeMenu('tre */ \
	0x65,0x4d,0x65,0x6e,0x75,0x32,0x27,0x29,0x22,0x3e,0x2b,0x20,0x4e,0x6f,0x64,0x65, /* eMenu2')">+ Node */ \
	0x20,0x41,0x64,0x61,0x70,0x74,0x65,0x72,0x20,0x53,0x65,0x74,0x74,0x69,0x6e,0x67, /*  Adapter Setting */ \
	0x3c,0x2f,0x61,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x74, /* </a>..<div id="t */ \
	0x72,0x65,0x65,0x4d,0x65,0x6e,0x75,0x32,0x22,0x20,0x73,0x74,0x79,0x6c,0x65,0x3d, /* reeMenu2" style= */ \
	0x22,0x64,0x69,0x73,0x70,0x6c,0x61,0x79,0x3a,0x6e,0x6f,0x6e,0x65,0x22,0x3e,0x0d, /* "display:none">. */ \
	0x0a,0x3c,0x61,0x20,0x68,0x72,0x65,0x66,0x3d,0x22,0x2f,0x6e,0x6f,0x64,0x65,0x61, /* .<a href="/nodea */ \
	0x64,0x61,0x70,0x74,0x65,0x72,0x2f,0x63,0x6f,0x6e,0x66,0x69,0x67,0x2e,0x68,0x74, /* dapter/config.ht */ \
	0x6d,0x22,0x3e,0x4e,0x6f,0x64,0x65,0x20,0x41,0x64,0x61,0x70,0x74,0x65,0x72,0x20, /* m">Node Adapter  */ \
	0x43,0x6f,0x6e,0x66,0x69,0x67,0x75,0x72,0x61,0x74,0x69,0x6f,0x6e,0x3c,0x2f,0x61, /* Configuration</a */ \
	0x3e,0x0d,0x0a,0x3c,0x61,0x20,0x68,0x72,0x65,0x66,0x3d,0x22,0x2f,0x6e,0x6f,0x64, /* >..<a href="/nod */ \
	0x65,0x61,0x64,0x61,0x70,0x74,0x65,0x72,0x2f,0x63,0x6f,0x6e,0x66,0x69,0x67,0x32, /* eadapter/config2 */ \
	0x2e,0x68,0x74,0x6d,0x22,0x3e,0x42,0x65,0x61,0x63,0x6f,0x6e,0x20,0x43,0x6f,0x6e, /* .htm">Beacon Con */ \
	0x66,0x69,0x67,0x75,0x72,0x61,0x74,0x69,0x6f,0x6e,0x3c,0x2f,0x61,0x3e,0x0d,0x0a, /* figuration</a>.. */ \
	0x3c,0x61,0x20,0x68,0x72,0x65,0x66,0x3d,0x22,0x2f,0x6e,0x6f,0x64,0x65,0x61,0x64, /* <a href="/nodead */ \
	0x61,0x70,0x74,0x65,0x72,0x2f,0x63,0x6f,0x6e,0x66,0x69,0x67,0x33,0x2e,0x68,0x74, /* apter/config3.ht */ \
	0x6d,0x22,0x3e,0x54,0x58,0x20,0x48,0x65,0x61,0x64,0x65,0x72,0x20,0x52,0x65,0x70, /* m">TX Header Rep */ \
	0x6c,0x61,0x63,0x65,0x20,0x43,0x6f,0x6e,0x66,0x69,0x67,0x75,0x72,0x61,0x74,0x69, /* lace Configurati */ \
	0x6f,0x6e,0x3c,0x2f,0x61,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a, /* on</a>..</div>.. */ \
	0x3c,0x41,0x20,0x68,0x72,0x65,0x66,0x3d,0x22,0x6a,0x61,0x76,0x61,0x53,0x63,0x72, /* <A href="javaScr */ \
	0x69,0x70,0x74,0x3a,0x74,0x72,0x65,0x65,0x4d,0x65,0x6e,0x75,0x28,0x27,0x74,0x72, /* ipt:treeMenu('tr */ \
	0x65,0x65,0x4d,0x65,0x6e,0x75,0x33,0x27,0x29,0x22,0x3e,0x2b,0x20,0x44,0x50,0x52  /* eeMenu3')">+ DPR */
#define DATACHUNK00000a \
	0x53,0x20,0x53,0x65,0x74,0x74,0x69,0x6e,0x67,0x3c,0x2f,0x61,0x3e,0x0d,0x0a,0x3c, /* S Setting</a>..< */ \
	0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x74,0x72,0x65,0x65,0x4d,0x65,0x6e,0x75, /* div id="treeMenu */ \
	0x33,0x22,0x20,0x73,0x74,0x79,0x6c,0x65,0x3d,0x22,0x64,0x69,0x73,0x70,0x6c,0x61, /* 3" style="displa */ \
	0x79,0x3a,0x6e,0x6f,0x6e,0x65,0x22,0x3e,0x0d,0x0a,0x3c,0x61,0x20,0x68,0x72,0x65, /* y:none">..<a hre */ \
	0x66,0x3d,0x22,0x2f,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x64,0x70,0x72,0x73, /* f="/protect/dprs */ \
	0x2e,0x68,0x74,0x6d,0x22,0x3e,0x44,0x50,0x52,0x53,0x20,0x43,0x6f,0x6e,0x66,0x69, /* .htm">DPRS Confi */ \
	0x67,0x75,0x72,0x61,0x74,0x69,0x6f,0x6e,0x3c,0x2f,0x61,0x3e,0x0d,0x0a,0x3c,0x61, /* guration</a>..<a */ \
	0x20,0x68,0x72,0x65,0x66,0x3d,0x22,0x2f,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f, /*  href="/protect/ */ \
	0x44,0x70,0x72,0x73,0x4d,0x73,0x67,0x43,0x74,0x72,0x6c,0x2e,0x68,0x74,0x6d,0x22, /* DprsMsgCtrl.htm" */ \
	0x3e,0x41,0x50,0x52,0x53,0x20,0x4d,0x73,0x67,0x2e,0x20,0x43,0x6f,0x6e,0x74,0x72, /* >APRS Msg. Contr */ \
	0x6f,0x6c,0x3c,0x2f,0x61,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a, /* ol</a>..</div>.. */ \
	0x3c,0x2f,0x64,0x69,0x76,0x3e,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65, /* </div>~inc:heade */ \
	0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d, /* r.inc~..<div id= */ \
	0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68, /* "content">....<h */ \
	0x31,0x3e,0x53,0x74,0x61,0x6e,0x64,0x20,0x41,0x6c,0x6f,0x6e,0x65,0x20,0x41,0x63, /* 1>Stand Alone Ac */ \
	0x63,0x65,0x73,0x73,0x20,0x50,0x6f,0x69,0x6e,0x74,0x3c,0x2f,0x68,0x31,0x3e,0x0d, /* cess Point</h1>. */ \
	0x0a,0x3c,0x74,0x61,0x62,0x6c,0x65,0x20,0x73,0x74,0x79,0x6c,0x65,0x3d,0x22,0x70, /* .<table style="p */ \
	0x61,0x64,0x64,0x69,0x6e,0x67,0x2d,0x6c,0x65,0x66,0x74,0x3a,0x20,0x31,0x30,0x70, /* adding-left: 10p */ \
	0x78,0x3b,0x22,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62, /* x;">..<tr><td><b */ \
	0x3e,0x4e,0x6f,0x64,0x65,0x20,0x43,0x61,0x6c,0x6c,0x73,0x69,0x67,0x6e,0x20,0x3a, /* >Node Callsign : */ \
	0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62, /* </b></td><td>&nb */ \
	0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x4e,0x6f,0x64, /* sp;</td><td>~Nod */ \
	0x65,0x4e,0x61,0x6d,0x65,0x7e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e, /* eName~</td></tr> */ \
	0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x69,0x72,0x63, /* ..<tr><td><b>irc */ \
	0x44,0x44,0x42,0x20,0x44,0x4e,0x53,0x20,0x75,0x73,0x65,0x20,0x3a,0x3c,0x2f,0x62, /* DDB DNS use :</b */ \
	0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b, /* ></td><td>&nbsp; */ \
	0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75, /* </td><td>..<inpu */ \
	0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78, /* t type="checkbox */ \
	0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x73,0x6d,0x22,0x20,0x7e,0x69,0x72, /* " class="sm" ~ir */ \
	0x63,0x44,0x44,0x42,0x7e,0x20,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x2f, /* cDDB~ disabled / */ \
	0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x7e,0x69,0x72,0x63,0x44,0x44,0x42,0x74,0x79, /* >&nbsp;~ircDDBty */ \
	0x70,0x65,0x7e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c, /* pe~</td></tr>..< */ \
	0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x52,0x65,0x70,0x65,0x61,0x74, /* tr><td><b>Repeat */ \
	0x65,0x72,0x2f,0x52,0x65,0x66,0x6c,0x65,0x63,0x74,0x6f,0x72,0x20,0x4e,0x61,0x6d, /* er/Reflector Nam */ \
	0x65,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e, /* e :</b></td><td> */ \
	0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e, /* &nbsp;</td><td>~ */ \
	0x52,0x65,0x66,0x4e,0x61,0x6d,0x65,0x7e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74, /* RefName~</td></t */ \
	0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x44, /* r>..<tr><td><b>D */ \
	0x50,0x6c,0x75,0x73,0x20,0x47,0x61,0x74,0x65,0x2f,0x52,0x65,0x66,0x2e,0x20,0x49, /* Plus Gate/Ref. I */ \
	0x50,0x20,0x61,0x64,0x64,0x72,0x65,0x73,0x73,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c, /* P address :</b>< */ \
	0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f, /* /td><td>&nbsp;</ */ \
	0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x73,0x65,0x72,0x76,0x65,0x72,0x5f,0x6e, /* td><td>~server_n */ \
	0x61,0x6d,0x65,0x7e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a, /* ame~</td></tr>.. */ \
	0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x41,0x75,0x74,0x6f,0x2e, /* <tr><td><b>Auto. */ \
	0x20,0x4c,0x69,0x6e,0x6b,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e, /*  Link :</b></td> */ \
	0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c, /* <td>&nbsp;</td>< */ \
	0x74,0x64,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65, /* td>..<input type */ \
	0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x63,0x6c,0x61,0x73, /* ="checkbox" clas */ \
	0x73,0x3d,0x22,0x73,0x6d,0x22,0x20,0x7e,0x41,0x75,0x74,0x43,0x6f,0x6e,0x6e,0x65, /* s="sm" ~AutConne */ \
	0x63,0x74,0x7e,0x20,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x2f,0x3e,0x3c, /* ct~ disabled />< */ \
	0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c, /* /td></tr>..<tr>< */ \
	0x74,0x64,0x3e,0x3c,0x62,0x3e,0x41,0x75,0x74,0x6f,0x2e,0x20,0x52,0x65,0x4c,0x69, /* td><b>Auto. ReLi */ \
	0x6e,0x6b,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64, /* nk :</b></td><td */ \
	0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e, /* >&nbsp;</td><td> */ \
	0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63, /* ..<input type="c */ \
	0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22, /* heckbox" class=" */ \
	0x73,0x6d,0x22,0x20,0x7e,0x52,0x65,0x43,0x6f,0x6e,0x6e,0x65,0x63,0x74,0x7e,0x20, /* sm" ~ReConnect~  */ \
	0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x2f,0x3e,0x3c,0x2f,0x74,0x64,0x3e, /* disabled /></td> */ \
	0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c, /* </tr>..<tr><td>< */ \
	0x62,0x3e,0x52,0x65,0x70,0x65,0x61,0x74,0x65,0x72,0x20,0x41,0x63,0x63,0x65,0x73, /* b>Repeater Acces */ \
	0x73,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e, /* s :</b></td><td> */ \
	0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x0d, /* &nbsp;</td><td>. */ \
	0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68, /* .<input type="ch */ \
	0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x73  /* eckbox" class="s */
#define DATACHUNK00000b \
	0x6d,0x22,0x20,0x7e,0x52,0x65,0x70,0x65,0x61,0x74,0x65,0x72,0x7e,0x20,0x64,0x69, /* m" ~Repeater~ di */ \
	0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x2f,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f, /* sabled /></td></ */ \
	0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e, /* tr>..<tr><td><b> */ \
	0x4e,0x54,0x50,0x20,0x53,0x65,0x72,0x76,0x65,0x72,0x20,0x44,0x6f,0x6d,0x61,0x69, /* NTP Server Domai */ \
	0x6e,0x20,0x4e,0x61,0x6d,0x65,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64, /* n Name :</b></td */ \
	0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e, /* ><td>&nbsp;</td> */ \
	0x3c,0x74,0x64,0x3e,0x7e,0x4e,0x74,0x70,0x4e,0x61,0x6d,0x65,0x7e,0x3c,0x2f,0x74, /* <td>~NtpName~</t */ \
	0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64, /* d></tr>..<tr><td */ \
	0x3e,0x3c,0x62,0x3e,0x54,0x69,0x6d,0x65,0x20,0x5a,0x6f,0x6e,0x65,0x20,0x3a,0x3c, /* ><b>Time Zone :< */ \
	0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73, /* /b></td><td>&nbs */ \
	0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x54,0x69,0x6d,0x65, /* p;</td><td>~Time */ \
	0x5a,0x6f,0x6e,0x65,0x7e,0x20,0x26,0x6e,0x62,0x73,0x70,0x3b,0x68,0x6f,0x75,0x72, /* Zone~ &nbsp;hour */ \
	0x73,0x26,0x6e,0x62,0x73,0x70,0x3b,0x7e,0x54,0x69,0x6d,0x65,0x5a,0x6f,0x6e,0x65, /* s&nbsp;~TimeZone */ \
	0x4d,0x69,0x6e,0x75,0x74,0x65,0x73,0x7e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x6d,0x69, /* Minutes~&nbsp;mi */ \
	0x6e,0x75,0x74,0x65,0x73,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d, /* nutes</td></tr>. */ \
	0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x4a,0x69,0x74,0x74, /* .<tr><td><b>Jitt */ \
	0x65,0x72,0x20,0x42,0x75,0x66,0x66,0x65,0x72,0x20,0x57,0x61,0x69,0x74,0x20,0x50, /* er Buffer Wait P */ \
	0x61,0x63,0x6b,0x65,0x74,0x73,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64, /* ackets :</b></td */ \
	0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e, /* ><td>&nbsp;</td> */ \
	0x3c,0x74,0x64,0x3e,0x7e,0x4a,0x69,0x74,0x74,0x65,0x72,0x53,0x69,0x7a,0x65,0x7e, /* <td>~JitterSize~ */ \
	0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e, /* </td></tr>..<tr> */ \
	0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x44,0x69,0x73,0x61,0x62,0x6c,0x65,0x20,0x4c, /* <td><b>Disable L */ \
	0x69,0x6e,0x6b,0x2f,0x55,0x6e,0x6c,0x69,0x6e,0x6b,0x20,0x66,0x72,0x6f,0x6d,0x20, /* ink/Unlink from  */ \
	0x52,0x46,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64, /* RF :</b></td><td */ \
	0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e, /* >&nbsp;</td><td> */ \
	0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63, /* ..<input type="c */ \
	0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22, /* heckbox" class=" */ \
	0x73,0x6d,0x22,0x20,0x7e,0x44,0x69,0x73,0x61,0x62,0x6c,0x65,0x52,0x46,0x63,0x6d, /* sm" ~DisableRFcm */ \
	0x64,0x7e,0x20,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x2f,0x3e,0x3c,0x2f, /* d~ disabled /></ */ \
	0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x62,0x72,0x3e,0x0d,0x0a, /* td></tr>..<br>.. */ \
	0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x56,0x6f,0x69,0x63,0x65, /* <tr><td><b>Voice */ \
	0x20,0x4d,0x65,0x73,0x73,0x61,0x67,0x65,0x20,0x4f,0x46,0x46,0x20,0x3a,0x3c,0x2f, /*  Message OFF :</ */ \
	0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73,0x70, /* b></td><td>&nbsp */ \
	0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70, /* ;</td><td>..<inp */ \
	0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f, /* ut type="checkbo */ \
	0x78,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x73,0x6d,0x22,0x20,0x20,0x7e, /* x" class="sm"  ~ */ \
	0x56,0x6f,0x69,0x63,0x65,0x4d,0x73,0x67,0x7e,0x20,0x64,0x69,0x73,0x61,0x62,0x6c, /* VoiceMsg~ disabl */ \
	0x65,0x64,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x0d, /* ed /></div>..... */ \
	0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x47,0x61,0x74,0x65, /* .<tr><td><b>Gate */ \
	0x2f,0x52,0x65,0x66,0x2e,0x20,0x46,0x69,0x6c,0x65,0x20,0x44,0x61,0x74,0x65,0x20, /* /Ref. File Date  */ \
	0x26,0x20,0x54,0x69,0x6d,0x65,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64, /* & Time :</b></td */ \
	0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e, /* ><td>&nbsp;</td> */ \
	0x3c,0x74,0x64,0x3e,0x7e,0x44,0x61,0x74,0x65,0x54,0x69,0x6d,0x65,0x7e,0x3c,0x2f, /* <td>~DateTime~</ */ \
	0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x2f,0x74,0x61,0x62,0x6c, /* td></tr>..</tabl */ \
	0x65,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x73,0x63,0x72, /* e>..</div>..<scr */ \
	0x69,0x70,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x2f,0x6a, /* ipt type="text/j */ \
	0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x0d,0x0a,0x3c,0x21,0x2d, /* avascript">..<!- */ \
	0x2d,0x0d,0x0a,0x2f,0x2f,0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69, /* -..//-->..</scri */ \
	0x70,0x74,0x3e,0x0d,0x0a,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74, /* pt>....~inc:foot */ \
	0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x00,0x00,0x00,0x00,0x33,0x00,0x00, /* er.inc~......3.. */ \
	0x00,0xa6,0x00,0x00,0x00,0x4e,0x00,0x00,0x00,0x17,0x01,0x00,0x00,0xd0,0x00,0x00, /* .....N.......... */ \
	0x00,0x31,0x01,0x00,0x00,0xd1,0x00,0x00,0x00,0x89,0x01,0x00,0x00,0x8a,0x00,0x00, /* .1.............. */ \
	0x00,0xe1,0x01,0x00,0x00,0x4a,0x00,0x00,0x00,0x51,0x02,0x00,0x00,0xa2,0x00,0x00, /* .....J...Q...... */ \
	0x00,0xce,0x02,0x00,0x00,0x9a,0x00,0x00,0x00,0x4d,0x03,0x00,0x00,0xa0,0x00,0x00, /* .........M...... */ \
	0x00,0xae,0x03,0x00,0x00,0x60,0x00,0x00,0x00,0xf5,0x03,0x00,0x00,0x61,0x00,0x00, /* .....`.......a.. */ \
	0x00,0x11,0x04,0x00,0x00,0x6d,0x00,0x00,0x00,0x7e,0x04,0x00,0x00,0x6e,0x00,0x00, /* .....m...~...n.. */ \
	0x00,0xfe,0x04,0x00,0x00,0xa1,0x00,0x00,0x00,0x89,0x05,0x00,0x00,0xa7,0x00,0x00, /* ................ */ \
	0x00,0xee,0x05,0x00,0x00,0xa6,0x00,0x00,0x00,0x51,0x06,0x00,0x00,0x02,0x00,0x00, /* .........Q...... */ \
	0x00,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63, /* .~inc:header.inc */ \
	0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74, /* ~..<div id="cont */ \
	0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x47,0x61,0x74, /* ent">....<h1>Gat */ \
	0x65,0x77,0x61,0x79,0x2f,0x52,0x65,0x66,0x6c,0x65,0x63,0x74,0x6f,0x72,0x20,0x53, /* eway/Reflector S */ \
	0x65,0x6c,0x65,0x63,0x74,0x3c,0x2f,0x68,0x31,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x66, /* elect</h1>....<f */ \
	0x6f,0x72,0x6d,0x20,0x6d,0x65,0x74,0x68,0x6f,0x64,0x3d,0x22,0x70,0x6f,0x73,0x74  /* orm method="post */
#define DATACHUNK00000c \
	0x22,0x20,0x61,0x63,0x74,0x69,0x6f,0x6e,0x3d,0x22,0x2f,0x72,0x65,0x66,0x73,0x65, /* " action="/refse */ \
	0x6c,0x65,0x63,0x74,0x2e,0x68,0x74,0x6d,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22, /* lect.htm" name=" */ \
	0x72,0x65,0x66,0x73,0x65,0x6c,0x22,0x3e,0x0d,0x0a,0x3c,0x66,0x69,0x65,0x6c,0x64, /* refsel">..<field */ \
	0x73,0x65,0x74,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65, /* set>..<div><labe */ \
	0x6c,0x3e,0x52,0x65,0x70,0x65,0x61,0x74,0x65,0x72,0x2f,0x52,0x65,0x66,0x6c,0x65, /* l>Repeater/Refle */ \
	0x63,0x74,0x6f,0x72,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x7e, /* ctor:</label>..~ */ \
	0x52,0x65,0x66,0x53,0x65,0x6c,0x65,0x63,0x74,0x46,0x69,0x72,0x73,0x74,0x7e,0x0d, /* RefSelectFirst~. */ \
	0x0a,0x7e,0x52,0x65,0x66,0x53,0x65,0x6c,0x65,0x63,0x74,0x7e,0x0d,0x0a,0x26,0x6e, /* .~RefSelect~..&n */ \
	0x62,0x73,0x70,0x3b,0x42,0x61,0x6e,0x64,0x26,0x6e,0x62,0x73,0x70,0x3b,0x0d,0x0a, /* bsp;Band&nbsp;.. */ \
	0x3c,0x73,0x65,0x6c,0x65,0x63,0x74,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x62,0x61, /* <select name="ba */ \
	0x6e,0x64,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x33,0x22,0x20, /* nd" class="ad3"  */ \
	0x73,0x69,0x7a,0x65,0x3d,0x22,0x31,0x22,0x2f,0x3e,0x0d,0x0a,0x7e,0x42,0x61,0x6e, /* size="1"/>..~Ban */ \
	0x64,0x53,0x65,0x6c,0x65,0x63,0x74,0x7e,0x0d,0x0a,0x3c,0x2f,0x73,0x65,0x6c,0x65, /* dSelect~..</sele */ \
	0x63,0x74,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69, /* ct>..</div>..<di */ \
	0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x69,0x72,0x63,0x44,0x44,0x42,0x20, /* v><label>ircDDB  */ \
	0x44,0x4e,0x53,0x20,0x75,0x73,0x65,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e, /* DNS use:</label> */ \
	0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63, /* ..<input type="c */ \
	0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22, /* heckbox" class=" */ \
	0x73,0x6d,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x69,0x72,0x63,0x64,0x22,0x20, /* sm" name="ircd"  */ \
	0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x31,0x22,0x20,0x7e,0x69,0x72,0x63,0x44,0x44, /* value="1" ~ircDD */ \
	0x42,0x7e,0x20,0x2f,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x0d,0x0a,0x54,0x79,0x70, /* B~ />&nbsp;..Typ */ \
	0x65,0x20,0x3a,0x3c,0x73,0x65,0x6c,0x65,0x63,0x74,0x20,0x6e,0x61,0x6d,0x65,0x3d, /* e :<select name= */ \
	0x22,0x69,0x72,0x63,0x74,0x22,0x3e,0x0d,0x0a,0x3c,0x6f,0x70,0x74,0x69,0x6f,0x6e, /* "irct">..<option */ \
	0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x30,0x22,0x3e,0x52,0x65,0x66,0x6c,0x65, /*  value="0">Refle */ \
	0x63,0x74,0x6f,0x72,0x0d,0x0a,0x3c,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x20,0x76,0x61, /* ctor..<option va */ \
	0x6c,0x75,0x65,0x3d,0x22,0x31,0x22,0x3e,0x44,0x63,0x73,0x0d,0x0a,0x3c,0x6f,0x70, /* lue="1">Dcs..<op */ \
	0x74,0x69,0x6f,0x6e,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x32,0x22,0x3e,0x44, /* tion value="2">D */ \
	0x78,0x74,0x72,0x61,0x0d,0x0a,0x3c,0x2f,0x73,0x65,0x6c,0x65,0x63,0x74,0x3e,0x0d, /* xtra..</select>. */ \
	0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x62,0x72,0x3e,0x0d,0x0a,0x3c, /* .</div>..<br>..< */ \
	0x62,0x72,0x3e,0x0d,0x0a,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70, /* br>..&nbsp;&nbsp */ \
	0x3b,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x73,0x75, /* ;<input type="su */ \
	0x62,0x6d,0x69,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6c,0x6e,0x6b,0x69, /* bmit" name="lnki */ \
	0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x4c,0x69,0x6e,0x6b,0x20,0x49,0x6d, /* " value="Link Im */ \
	0x6d,0x65,0x64,0x69,0x61,0x74,0x65,0x6c,0x79,0x22,0x20,0x63,0x6c,0x61,0x73,0x73, /* mediately" class */ \
	0x3d,0x22,0x61,0x64,0x33,0x22,0x20,0x2f,0x3e,0x0d,0x0a,0x26,0x6e,0x62,0x73,0x70, /* ="ad3" />..&nbsp */ \
	0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62, /* ;&nbsp;&nbsp;&nb */ \
	0x73,0x70,0x3b,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22, /* sp;<input type=" */ \
	0x73,0x75,0x62,0x6d,0x69,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6c,0x6e, /* submit" name="ln */ \
	0x6b,0x77,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x4c,0x69,0x6e,0x6b,0x20, /* kw" value="Link  */ \
	0x49,0x6d,0x6d,0x65,0x64,0x69,0x61,0x74,0x65,0x6c,0x79,0x20,0x77,0x69,0x74,0x68, /* Immediately with */ \
	0x6f,0x75,0x74,0x20,0x56,0x6f,0x69,0x63,0x65,0x20,0x4d,0x73,0x67,0x2e,0x22,0x20, /* out Voice Msg."  */ \
	0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x33,0x22,0x20,0x2f,0x3e,0x0d,0x0a, /* class="ad3" />.. */ \
	0x3c,0x62,0x72,0x3e,0x3c,0x62,0x72,0x3e,0x0d,0x0a,0x26,0x6e,0x62,0x73,0x70,0x3b, /* <br><br>..&nbsp; */ \
	0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70, /* &nbsp;<input typ */ \
	0x65,0x3d,0x22,0x73,0x75,0x62,0x6d,0x69,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d, /* e="submit" name= */ \
	0x22,0x72,0x65,0x66,0x66,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x52,0x65, /* "reff" value="Re */ \
	0x66,0x72,0x65,0x73,0x68,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64, /* fresh" class="ad */ \
	0x33,0x22,0x20,0x2f,0x3e,0x0d,0x0a,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62, /* 3" />..&nbsp;&nb */ \
	0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c, /* sp;&nbsp;&nbsp;< */ \
	0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x73,0x75,0x62,0x6d, /* input type="subm */ \
	0x69,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x63,0x61,0x6e,0x63,0x22,0x20, /* it" name="canc"  */ \
	0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x43,0x61,0x6e,0x63,0x65,0x6c,0x22,0x20,0x63, /* value="Cancel" c */ \
	0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x33,0x22,0x20,0x2f,0x3e,0x0d,0x0a,0x3c, /* lass="ad3" />..< */ \
	0x62,0x72,0x3e,0x3c,0x62,0x72,0x3e,0x0d,0x0a,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26, /* br><br>..&nbsp;& */ \
	0x6e,0x62,0x73,0x70,0x3b,0x3c,0x66,0x6f,0x6e,0x74,0x20,0x63,0x6f,0x6c,0x6f,0x72, /* nbsp;<font color */ \
	0x3d,0x72,0x65,0x64,0x3e,0x3c,0x62,0x3e,0x0d,0x0a,0x7e,0x4e,0x6f,0x74,0x69,0x63, /* =red><b>..~Notic */ \
	0x65,0x7e,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x66,0x6f,0x6e,0x74,0x3e,0x0d,0x0a,0x3c, /* e~</b></font>..< */ \
	0x62,0x72,0x3e,0x3c,0x62,0x72,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x69,0x65,0x6c,0x64, /* br><br>..</field */ \
	0x73,0x65,0x74,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x6f,0x72,0x6d,0x3e,0x0d,0x0a,0x3c, /* set>..</form>..< */ \
	0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74, /* /div>....<script */ \
	0x20,0x6c,0x61,0x6e,0x67,0x75,0x61,0x67,0x65,0x3d,0x22,0x6a,0x61,0x76,0x61,0x73, /*  language="javas */ \
	0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x0d,0x0a,0x2f,0x2f,0x2d,0x2d,0x3e,0x0d,0x0a, /* cript">..//-->.. */ \
	0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74,0x3e,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a, /* </script>..~inc: */ \
	0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x00,0x00,0x00,0x00,0x33  /* footer.inc~....3 */
#define DATACHUNK00000d \
	0x00,0x00,0x00,0xbe,0x00,0x00,0x00,0xc2,0x00,0x00,0x00,0xd0,0x00,0x00,0x00,0x8d, /* ................ */ \
	0x00,0x00,0x00,0x1b,0x01,0x00,0x00,0x99,0x00,0x00,0x00,0x99,0x01,0x00,0x00,0xd0, /* ................ */ \
	0x00,0x00,0x00,0xd9,0x03,0x00,0x00,0xa5,0x00,0x00,0x00,0x4a,0x04,0x00,0x00,0x02, /* ...........J.... */ \
	0x00,0x00,0x00,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69, /* ...~inc:header.i */ \
	0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x2f,0x62,0x6f,0x64,0x79,0x3e,0x0d,0x0a,0x3c,0x62, /* nc~..</body>..<b */ \
	0x6f,0x64,0x79,0x20,0x6f,0x6e,0x4c,0x6f,0x61,0x64,0x3d,0x22,0x74,0x69,0x6d,0x65, /* ody onLoad="time */ \
	0x5f,0x73,0x65,0x74,0x28,0x29,0x22,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69, /* _set()">..<div i */ \
	0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a, /* d="content">.... */ \
	0x3c,0x68,0x31,0x3e,0x53,0x74,0x61,0x6e,0x64,0x20,0x41,0x6c,0x6f,0x6e,0x65,0x20, /* <h1>Stand Alone  */ \
	0x41,0x63,0x63,0x65,0x73,0x73,0x20,0x50,0x6f,0x69,0x6e,0x74,0x3c,0x2f,0x68,0x31, /* Access Point</h1 */ \
	0x3e,0x0d,0x0a,0x3c,0x66,0x6f,0x72,0x6d,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x73, /* >..<form name="s */ \
	0x74,0x61,0x74,0x75,0x73,0x22,0x20,0x6d,0x65,0x74,0x68,0x6f,0x64,0x3d,0x22,0x70, /* tatus" method="p */ \
	0x6f,0x73,0x74,0x22,0x20,0x61,0x63,0x74,0x69,0x6f,0x6e,0x3d,0x22,0x73,0x74,0x61, /* ost" action="sta */ \
	0x74,0x75,0x73,0x2e,0x68,0x74,0x6d,0x22,0x3e,0x0d,0x0a,0x3c,0x74,0x61,0x62,0x6c, /* tus.htm">..<tabl */ \
	0x65,0x20,0x73,0x74,0x79,0x6c,0x65,0x3d,0x22,0x70,0x61,0x64,0x64,0x69,0x6e,0x67, /* e style="padding */ \
	0x2d,0x6c,0x65,0x66,0x74,0x3a,0x20,0x31,0x30,0x70,0x78,0x3b,0x22,0x3e,0x0d,0x0a, /* -left: 10px;">.. */ \
	0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x44,0x61,0x74,0x65,0x20, /* <tr><td><b>Date  */ \
	0x3a,0x20,0x3c,0x2f,0x62,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x7e,0x43,0x75,0x72, /* : </b>&nbsp;~Cur */ \
	0x44,0x61,0x74,0x65,0x7e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70, /* Date~&nbsp;&nbsp */ \
	0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x54, /* ;</td>..<td><b>T */ \
	0x69,0x6d,0x65,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x7e, /* ime :</b>&nbsp;~ */ \
	0x43,0x75,0x72,0x54,0x69,0x6d,0x65,0x7e,0x20,0x28,0x3c,0x69,0x6e,0x70,0x75,0x74, /* CurTime~ (<input */ \
	0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d, /*  type="text" nam */ \
	0x65,0x3d,0x22,0x63,0x75,0x74,0x6d,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x38, /* e="cutm" size="8 */ \
	0x22,0x3e,0x29,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c, /* ">)</td></tr>..< */ \
	0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x69,0x72,0x63,0x44,0x44,0x42, /* tr><td><b>ircDDB */ \
	0x20,0x44,0x4e,0x53,0x20,0x75,0x73,0x65,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f, /*  DNS use :</b></ */ \
	0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20, /* td><td>..<input  */ \
	0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20, /* type="checkbox"  */ \
	0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x73,0x6d,0x22,0x20,0x7e,0x69,0x72,0x63,0x44, /* class="sm" ~ircD */ \
	0x44,0x42,0x7e,0x20,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x2f,0x3e,0x26, /* DB~ disabled />& */ \
	0x6e,0x62,0x73,0x70,0x3b,0x7e,0x69,0x72,0x63,0x44,0x44,0x42,0x74,0x79,0x70,0x65, /* nbsp;~ircDDBtype */ \
	0x7e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72, /* ~</td></tr>..<tr */ \
	0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x47,0x61,0x74,0x65,0x2f,0x52,0x65,0x66, /* ><td><b>Gate/Ref */ \
	0x6c,0x65,0x63,0x74,0x6f,0x72,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64, /* lector :</b></td */ \
	0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x43,0x75,0x72,0x52,0x65,0x66,0x7e,0x26,0x6e,0x62, /* ><td>~CurRef~&nb */ \
	0x73,0x70,0x3b,0x28,0x7e,0x52,0x65,0x66,0x4e,0x61,0x6d,0x65,0x7e,0x29,0x3c,0x2f, /* sp;(~RefName~)</ */ \
	0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74, /* td></tr>..<tr><t */ \
	0x64,0x3e,0x3c,0x62,0x3e,0x50,0x54,0x54,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x26,0x6e, /* d><b>PTT :</b>&n */ \
	0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x7e,0x43,0x75,0x72,0x50,0x54, /* bsp;&nbsp;~CurPT */ \
	0x54,0x7e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f, /* T~&nbsp;&nbsp;</ */ \
	0x74,0x64,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x43,0x4f,0x53,0x20, /* td>..<td><b>COS  */ \
	0x3a,0x3c,0x2f,0x62,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70, /* :</b>&nbsp;&nbsp */ \
	0x3b,0x7e,0x43,0x75,0x72,0x43,0x4f,0x53,0x7e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f, /* ;~CurCOS~</td></ */ \
	0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e, /* tr>..<tr><td><b> */ \
	0x4e,0x6f,0x64,0x65,0x20,0x55,0x73,0x65,0x72,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x26, /* Node User :</b>& */ \
	0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x7e,0x43,0x75,0x72,0x55, /* nbsp;&nbsp;~CurU */ \
	0x73,0x65,0x72,0x7e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b, /* ser~&nbsp;&nbsp; */ \
	0x3c,0x2f,0x74,0x64,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x53,0x53, /* </td>..<td><b>SS */ \
	0x4e,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62, /* N :</b>&nbsp;&nb */ \
	0x73,0x70,0x3b,0x7e,0x43,0x75,0x72,0x53,0x53,0x4e,0x7e,0x3c,0x2f,0x74,0x64,0x3e, /* sp;~CurSSN~</td> */ \
	0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x2f,0x74,0x61,0x62,0x6c,0x65,0x3e,0x0d, /* </tr>..</table>. */ \
	0x0a,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62, /* .&nbsp;&nbsp;&nb */ \
	0x73,0x70,0x3b,0x3c,0x62,0x3e,0x47,0x61,0x74,0x65,0x2f,0x52,0x65,0x66,0x2e,0x20, /* sp;<b>Gate/Ref.  */ \
	0x46,0x69,0x6c,0x65,0x20,0x44,0x61,0x74,0x65,0x20,0x26,0x20,0x54,0x69,0x6d,0x65, /* File Date & Time */ \
	0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73, /*  :</b>&nbsp;&nbs */ \
	0x70,0x3b,0x7e,0x44,0x61,0x74,0x65,0x54,0x69,0x6d,0x65,0x7e,0x3c,0x62,0x72,0x3e, /* p;~DateTime~<br> */ \
	0x0d,0x0a,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e, /* ..&nbsp;&nbsp;&n */ \
	0x62,0x73,0x70,0x3b,0x3c,0x62,0x3e,0x57,0x65,0x62,0x20,0x53,0x69,0x74,0x65,0x20, /* bsp;<b>Web Site  */ \
	0x3a,0x3c,0x2f,0x62,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70, /* :</b>&nbsp;&nbsp */ \
	0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x7e,0x68,0x74,0x74,0x70,0x7e,0x0d,0x0a,0x3c, /* ;&nbsp;~http~..< */ \
	0x62,0x72,0x3e,0x0d,0x0a,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70, /* br>..&nbsp;&nbsp */ \
	0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79, /* ;&nbsp;<input ty */ \
	0x70,0x65,0x3d,0x22,0x62,0x75,0x74,0x74,0x6f,0x6e,0x22,0x20,0x6e,0x61,0x6d,0x65  /* pe="button" name */
#define DATACHUNK00000e \
	0x3d,0x22,0x66,0x72,0x65,0x73,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x52, /* ="fres" value="R */ \
	0x65,0x66,0x72,0x65,0x73,0x68,0x22,0x20,0x6f,0x6e,0x43,0x6c,0x69,0x63,0x6b,0x3d, /* efresh" onClick= */ \
	0x22,0x72,0x65,0x66,0x72,0x65,0x73,0x68,0x28,0x29,0x22,0x20,0x2f,0x3e,0x0d,0x0a, /* "refresh()" />.. */ \
	0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x69,0x6e,0x70, /* &nbsp;&nbsp;<inp */ \
	0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x73,0x75,0x62,0x6d,0x69,0x74,0x22, /* ut type="submit" */ \
	0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6c,0x69,0x6e,0x6b,0x22,0x20,0x76,0x61,0x6c, /*  name="link" val */ \
	0x75,0x65,0x3d,0x22,0x4c,0x69,0x6e,0x6b,0x22,0x20,0x2f,0x3e,0x0d,0x0a,0x26,0x6e, /* ue="Link" />..&n */ \
	0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x69,0x6e,0x70,0x75,0x74, /* bsp;&nbsp;<input */ \
	0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x73,0x75,0x62,0x6d,0x69,0x74,0x22,0x20,0x6e, /*  type="submit" n */ \
	0x61,0x6d,0x65,0x3d,0x22,0x75,0x6c,0x6e,0x6b,0x22,0x20,0x76,0x61,0x6c,0x75,0x65, /* ame="ulnk" value */ \
	0x3d,0x22,0x55,0x6e,0x4c,0x69,0x6e,0x6b,0x22,0x20,0x2f,0x3e,0x0d,0x0a,0x26,0x6e, /* ="UnLink" />..&n */ \
	0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x69,0x6e,0x70,0x75,0x74, /* bsp;&nbsp;<input */ \
	0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x73,0x75,0x62,0x6d,0x69,0x74,0x22,0x20,0x6e, /*  type="submit" n */ \
	0x61,0x6d,0x65,0x3d,0x22,0x72,0x65,0x6c,0x64,0x22,0x20,0x76,0x61,0x6c,0x75,0x65, /* ame="reld" value */ \
	0x3d,0x22,0x52,0x65,0x4c,0x6f,0x61,0x64,0x20,0x47,0x61,0x74,0x65,0x2f,0x52,0x65, /* ="ReLoad Gate/Re */ \
	0x66,0x20,0x4c,0x69,0x73,0x74,0x22,0x20,0x2f,0x3e,0x0d,0x0a,0x26,0x6e,0x62,0x73, /* f List" />..&nbs */ \
	0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74, /* p;&nbsp;<input t */ \
	0x79,0x70,0x65,0x3d,0x22,0x62,0x75,0x74,0x74,0x6f,0x6e,0x22,0x20,0x6e,0x61,0x6d, /* ype="button" nam */ \
	0x65,0x3d,0x22,0x73,0x65,0x6c,0x72,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22, /* e="selr" value=" */ \
	0x53,0x65,0x6c,0x65,0x63,0x74,0x20,0x47,0x61,0x74,0x65,0x2f,0x52,0x65,0x66,0x22, /* Select Gate/Ref" */ \
	0x20,0x6f,0x6e,0x63,0x6c,0x69,0x63,0x6b,0x3d,0x22,0x72,0x65,0x66,0x73,0x65,0x6c, /*  onclick="refsel */ \
	0x65,0x63,0x74,0x28,0x29,0x22,0x20,0x2f,0x3e,0x0d,0x0a,0x3c,0x74,0x61,0x62,0x6c, /* ect()" />..<tabl */ \
	0x65,0x20,0x73,0x74,0x79,0x6c,0x65,0x3d,0x22,0x70,0x61,0x64,0x64,0x69,0x6e,0x67, /* e style="padding */ \
	0x2d,0x6c,0x65,0x66,0x74,0x3a,0x20,0x31,0x30,0x70,0x78,0x3b,0x22,0x3e,0x0d,0x0a, /* -left: 10px;">.. */ \
	0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x41,0x50,0x52,0x53,0x20, /* <tr><td><b>APRS  */ \
	0x53,0x65,0x72,0x76,0x65,0x72,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64, /* Server :</b></td */ \
	0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e, /* ><td>&nbsp;</td> */ \
	0x3c,0x74,0x64,0x3e,0x7e,0x43,0x75,0x72,0x41,0x50,0x52,0x53,0x7e,0x3c,0x2f,0x74, /* <td>~CurAPRS~</t */ \
	0x64,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e, /* d>..<td>&nbsp;&n */ \
	0x62,0x73,0x70,0x3b,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d, /* bsp;<input type= */ \
	0x22,0x73,0x75,0x62,0x6d,0x69,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6c, /* "submit" name="l */ \
	0x61,0x70,0x72,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x4c,0x69,0x6e,0x6b, /* apr" value="Link */ \
	0x22,0x20,0x2f,0x3e,0x0d,0x0a,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73, /* " />..&nbsp;&nbs */ \
	0x70,0x3b,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x73, /* p;<input type="s */ \
	0x75,0x62,0x6d,0x69,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x75,0x61,0x70, /* ubmit" name="uap */ \
	0x72,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x55,0x6e,0x4c,0x69,0x6e,0x6b, /* r" value="UnLink */ \
	0x22,0x20,0x2f,0x3e,0x0d,0x0a,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73, /* " />..&nbsp;&nbs */ \
	0x70,0x3b,0x3c,0x62,0x3e,0x57,0x65,0x62,0x20,0x53,0x69,0x74,0x65,0x20,0x3a,0x20, /* p;<b>Web Site :  */ \
	0x3c,0x61,0x20,0x68,0x72,0x65,0x66,0x3d,0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,0x61, /* <a href=http://a */ \
	0x70,0x72,0x73,0x2e,0x66,0x69,0x20,0x74,0x61,0x72,0x67,0x65,0x74,0x3d,0x5f,0x62, /* prs.fi target=_b */ \
	0x6c,0x61,0x6e,0x6b,0x3e,0x61,0x70,0x72,0x73,0x2e,0x66,0x69,0x3c,0x2f,0x61,0x3e, /* lank>aprs.fi</a> */ \
	0x3c,0x2f,0x62,0x3e,0x0d,0x0a,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e, /* </b>..</td></tr> */ \
	0x0d,0x0a,0x3c,0x2f,0x74,0x61,0x62,0x6c,0x65,0x3e,0x0d,0x0a,0x26,0x6e,0x62,0x73, /* ..</table>..&nbs */ \
	0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x62,0x3e,0x53,0x65,0x6e,0x64,0x65, /* p;&nbsp;<b>Sende */ \
	0x72,0x3a,0x3c,0x2f,0x62,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73, /* r:</b>&nbsp;&nbs */ \
	0x70,0x3b,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74, /* p;<input type="t */ \
	0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6c,0x63,0x61,0x6c,0x22, /* ext" name="lcal" */ \
	0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x31,0x30,0x22,0x20,0x76,0x61,0x6c,0x75,0x65, /*  size="10" value */ \
	0x3d,0x22,0x7e,0x73,0x65,0x6e,0x64,0x65,0x72,0x63,0x61,0x6c,0x6c,0x7e,0x22,0x20, /* ="~sendercall~"  */ \
	0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x20,0x72,0x65,0x61,0x64, /* class="ad1" read */ \
	0x6f,0x6e,0x6c,0x79,0x20,0x6f,0x6e,0x43,0x6c,0x69,0x63,0x6b,0x3d,0x22,0x6a,0x75, /* only onClick="ju */ \
	0x6d,0x70,0x28,0x29,0x22,0x20,0x2f,0x3e,0x0d,0x0a,0x26,0x6e,0x62,0x73,0x70,0x3b, /* mp()" />..&nbsp; */ \
	0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x62,0x3e,0x52,0x63,0x76,0x2e,0x20,0x4d,0x73, /* &nbsp;<b>Rcv. Ms */ \
	0x67,0x2e,0x3a,0x3c,0x2f,0x62,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62, /* g.:</b>&nbsp;&nb */ \
	0x73,0x70,0x3b,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22, /* sp;<input type=" */ \
	0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6c,0x6d,0x73,0x67, /* text" name="lmsg */ \
	0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x4c,0x61,0x73,0x74,0x4d,0x73, /* " value="~LastMs */ \
	0x67,0x7e,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x34,0x30,0x22,0x20,0x63,0x6c, /* g~" size="40" cl */ \
	0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x20,0x72,0x65,0x61,0x64,0x6f,0x6e, /* ass="ad1" readon */ \
	0x6c,0x79,0x2f,0x20,0x6f,0x6e,0x43,0x6c,0x69,0x63,0x6b,0x3d,0x22,0x6a,0x75,0x6d, /* ly/ onClick="jum */ \
	0x70,0x28,0x29,0x22,0x20,0x2f,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x62,0x72,0x3e,0x0d, /* p()" />....<br>. */ \
	0x0a,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x66,0x6f, /* .&nbsp;&nbsp;<fo */ \
	0x6e,0x74,0x20,0x63,0x6f,0x6c,0x6f,0x72,0x3d,0x72,0x65,0x64,0x3e,0x3c,0x62,0x3e, /* nt color=red><b> */ \
	0x0d,0x0a,0x7e,0x4e,0x6f,0x74,0x69,0x63,0x65,0x7e,0x3c,0x2f,0x62,0x3e,0x3c,0x2f  /* ..~Notice~</b></ */
#define DATACHUNK00000f \
	0x66,0x6f,0x6e,0x74,0x3e,0x0d,0x0a,0x3c,0x62,0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x61, /* font>..<br>..<ta */ \
	0x62,0x6c,0x65,0x20,0x73,0x74,0x79,0x6c,0x65,0x3d,0x22,0x70,0x61,0x64,0x64,0x69, /* ble style="paddi */ \
	0x6e,0x67,0x2d,0x6c,0x65,0x66,0x74,0x3a,0x20,0x31,0x30,0x70,0x78,0x3b,0x22,0x3e, /* ng-left: 10px;"> */ \
	0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x43,0x75,0x72, /* ..<tr><td><b>Cur */ \
	0x72,0x65,0x6e,0x74,0x20,0x53,0x75,0x62,0x20,0x43,0x6c,0x69,0x65,0x6e,0x74,0x20, /* rent Sub Client  */ \
	0x55,0x73,0x65,0x72,0x20,0x4e,0x61,0x6d,0x65,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c, /* User Name :</b>< */ \
	0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x7e,0x43,0x6f,0x6e,0x6e, /* /td></tr>..~Conn */ \
	0x65,0x63,0x74,0x55,0x73,0x65,0x72,0x7e,0x0d,0x0a,0x3c,0x2f,0x74,0x61,0x62,0x6c, /* ectUser~..</tabl */ \
	0x65,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x6f,0x72,0x6d,0x3e,0x0d,0x0a,0x3c,0x2f,0x64, /* e>..</form>..</d */ \
	0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x2f,0x62,0x6f,0x64,0x79,0x3e,0x0d,0x0a, /* iv>....</body>.. */ \
	0x3c,0x6d,0x65,0x74,0x61,0x20,0x68,0x74,0x74,0x70,0x2d,0x65,0x71,0x75,0x69,0x76, /* <meta http-equiv */ \
	0x3d,0x22,0x72,0x65,0x66,0x72,0x65,0x73,0x68,0x22,0x20,0x63,0x6f,0x6e,0x74,0x65, /* ="refresh" conte */ \
	0x6e,0x74,0x3d,0x22,0x31,0x30,0x22,0x3e,0x0d,0x0a,0x3c,0x62,0x6f,0x64,0x79,0x3e, /* nt="10">..<body> */ \
	0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22, /* ..<script type=" */ \
	0x74,0x65,0x78,0x74,0x2f,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22, /* text/javascript" */ \
	0x3e,0x0d,0x0a,0x3c,0x21,0x2d,0x2d,0x0d,0x0a,0x0d,0x0a,0x66,0x75,0x6e,0x63,0x74, /* >..<!--....funct */ \
	0x69,0x6f,0x6e,0x20,0x74,0x69,0x6d,0x65,0x5f,0x73,0x65,0x74,0x28,0x29,0x7b,0x0d, /* ion time_set(){. */ \
	0x0a,0x20,0x20,0x6d,0x79,0x44,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x3d,0x20,0x6e, /* .  myD       = n */ \
	0x65,0x77,0x20,0x44,0x61,0x74,0x65,0x28,0x29,0x3b,0x0d,0x0a,0x20,0x20,0x6d,0x79, /* ew Date();..  my */ \
	0x48,0x6f,0x75,0x72,0x73,0x20,0x20,0x20,0x3d,0x20,0x6d,0x79,0x44,0x2e,0x67,0x65, /* Hours   = myD.ge */ \
	0x74,0x48,0x6f,0x75,0x72,0x73,0x28,0x29,0x3b,0x0d,0x0a,0x20,0x20,0x69,0x66,0x20, /* tHours();..  if  */ \
	0x28,0x6d,0x79,0x48,0x6f,0x75,0x72,0x73,0x20,0x3c,0x20,0x31,0x30,0x29,0x20,0x6d, /* (myHours < 10) m */ \
	0x79,0x48,0x6f,0x75,0x72,0x73,0x20,0x3d,0x20,0x22,0x30,0x22,0x20,0x2b,0x20,0x6d, /* yHours = "0" + m */ \
	0x79,0x48,0x6f,0x75,0x72,0x73,0x3b,0x0d,0x0a,0x20,0x20,0x6d,0x79,0x4d,0x69,0x6e, /* yHours;..  myMin */ \
	0x75,0x74,0x65,0x73,0x20,0x3d,0x20,0x6d,0x79,0x44,0x2e,0x67,0x65,0x74,0x4d,0x69, /* utes = myD.getMi */ \
	0x6e,0x75,0x74,0x65,0x73,0x28,0x29,0x3b,0x0d,0x0a,0x20,0x20,0x69,0x66,0x20,0x28, /* nutes();..  if ( */ \
	0x6d,0x79,0x4d,0x69,0x6e,0x75,0x74,0x65,0x73,0x20,0x3c,0x20,0x31,0x30,0x29,0x20, /* myMinutes < 10)  */ \
	0x6d,0x79,0x4d,0x69,0x6e,0x75,0x74,0x65,0x73,0x20,0x3d,0x20,0x22,0x30,0x22,0x20, /* myMinutes = "0"  */ \
	0x2b,0x20,0x6d,0x79,0x4d,0x69,0x6e,0x75,0x74,0x65,0x73,0x3b,0x0d,0x0a,0x20,0x20, /* + myMinutes;..   */ \
	0x6d,0x79,0x53,0x65,0x63,0x6f,0x6e,0x64,0x73,0x20,0x3d,0x20,0x6d,0x79,0x44,0x2e, /* mySeconds = myD. */ \
	0x67,0x65,0x74,0x53,0x65,0x63,0x6f,0x6e,0x64,0x73,0x28,0x29,0x3b,0x0d,0x0a,0x20, /* getSeconds();..  */ \
	0x20,0x69,0x66,0x20,0x28,0x6d,0x79,0x53,0x65,0x63,0x6f,0x6e,0x64,0x73,0x20,0x3c, /*  if (mySeconds < */ \
	0x20,0x31,0x30,0x29,0x20,0x6d,0x79,0x53,0x65,0x63,0x6f,0x6e,0x64,0x73,0x20,0x3d, /*  10) mySeconds = */ \
	0x20,0x22,0x30,0x22,0x20,0x2b,0x20,0x6d,0x79,0x53,0x65,0x63,0x6f,0x6e,0x64,0x73, /*  "0" + mySeconds */ \
	0x3b,0x0d,0x0a,0x0d,0x0a,0x20,0x20,0x6d,0x79,0x4d,0x65,0x73,0x73,0x20,0x3d,0x20, /* ;....  myMess =  */ \
	0x6d,0x79,0x48,0x6f,0x75,0x72,0x73,0x20,0x2b,0x20,0x22,0x3a,0x22,0x20,0x2b,0x20, /* myHours + ":" +  */ \
	0x6d,0x79,0x4d,0x69,0x6e,0x75,0x74,0x65,0x73,0x20,0x2b,0x20,0x22,0x3a,0x22,0x20, /* myMinutes + ":"  */ \
	0x2b,0x20,0x6d,0x79,0x53,0x65,0x63,0x6f,0x6e,0x64,0x73,0x3b,0x0d,0x0a,0x20,0x20, /* + mySeconds;..   */ \
	0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x73,0x74,0x61,0x74,0x75,0x73,0x2e, /* document.status. */ \
	0x63,0x75,0x74,0x6d,0x2e,0x76,0x61,0x6c,0x75,0x65,0x20,0x3d,0x20,0x6d,0x79,0x4d, /* cutm.value = myM */ \
	0x65,0x73,0x73,0x3b,0x0d,0x0a,0x20,0x20,0x73,0x65,0x74,0x54,0x69,0x6d,0x65,0x6f, /* ess;..  setTimeo */ \
	0x75,0x74,0x20,0x28,0x22,0x74,0x69,0x6d,0x65,0x5f,0x73,0x65,0x74,0x28,0x29,0x22, /* ut ("time_set()" */ \
	0x2c,0x20,0x31,0x30,0x30,0x30,0x29,0x3b,0x0d,0x0a,0x7d,0x0d,0x0a,0x0d,0x0a,0x66, /* , 1000);..}....f */ \
	0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x20,0x72,0x65,0x66,0x72,0x65,0x73,0x68,0x28, /* unction refresh( */ \
	0x29,0x0d,0x0a,0x7b,0x0d,0x0a,0x20,0x20,0x20,0x6c,0x6f,0x63,0x61,0x74,0x69,0x6f, /* )..{..   locatio */ \
	0x6e,0x2e,0x72,0x65,0x6c,0x6f,0x61,0x64,0x28,0x74,0x72,0x75,0x65,0x29,0x3b,0x0d, /* n.reload(true);. */ \
	0x0a,0x7d,0x0d,0x0a,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x20,0x6a,0x75,0x6d, /* .}..function jum */ \
	0x70,0x28,0x29,0x0d,0x0a,0x7b,0x0d,0x0a,0x20,0x20,0x20,0x6c,0x6f,0x63,0x61,0x74, /* p()..{..   locat */ \
	0x69,0x6f,0x6e,0x2e,0x68,0x72,0x65,0x66,0x3d,0x22,0x61,0x70,0x72,0x73,0x6d,0x73, /* ion.href="aprsms */ \
	0x67,0x2e,0x68,0x74,0x6d,0x22,0x3b,0x0d,0x0a,0x7d,0x0d,0x0a,0x66,0x75,0x6e,0x63, /* g.htm";..}..func */ \
	0x74,0x69,0x6f,0x6e,0x20,0x72,0x65,0x66,0x73,0x65,0x6c,0x65,0x63,0x74,0x28,0x29, /* tion refselect() */ \
	0x0d,0x0a,0x7b,0x0d,0x0a,0x20,0x20,0x20,0x6c,0x6f,0x63,0x61,0x74,0x69,0x6f,0x6e, /* ..{..   location */ \
	0x2e,0x68,0x72,0x65,0x66,0x3d,0x22,0x72,0x65,0x66,0x73,0x65,0x6c,0x65,0x63,0x74, /* .href="refselect */ \
	0x2e,0x68,0x74,0x6d,0x22,0x3b,0x0d,0x0a,0x7d,0x0d,0x0a,0x2f,0x2f,0x2d,0x2d,0x3e, /* .htm";..}..//--> */ \
	0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74,0x3e,0x0d,0x0a,0x7e,0x69,0x6e, /* ..</script>..~in */ \
	0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x00, /* c:footer.inc~... */ \
	0x00,0x00,0x00,0x33,0x00,0x00,0x00,0xe9,0x00,0x00,0x00,0x63,0x00,0x00,0x00,0x1c, /* ...3.......c.... */ \
	0x01,0x00,0x00,0x64,0x00,0x00,0x00,0xa8,0x01,0x00,0x00,0xd0,0x00,0x00,0x00,0xc2, /* ...d............ */ \
	0x01,0x00,0x00,0xd1,0x00,0x00,0x00,0x02,0x02,0x00,0x00,0xa3,0x00,0x00,0x00,0x11, /* ................ */ \
	0x02,0x00,0x00,0x8a,0x00,0x00,0x00,0x47,0x02,0x00,0x00,0x66,0x00,0x00,0x00,0x7e, /* .......G...f...~ */ \
	0x02,0x00,0x00,0x67,0x00,0x00,0x00,0xb8,0x02,0x00,0x00,0x69,0x00,0x00,0x00,0xf0, /* ...g.......i.... */ \
	0x02,0x00,0x00,0x68,0x00,0x00,0x00,0x4f,0x03,0x00,0x00,0xa6,0x00,0x00,0x00,0x94, /* ...h...O........ */ \
	0x03,0x00,0x00,0xa8,0x00,0x00,0x00,0x81,0x05,0x00,0x00,0xb4,0x00,0x00,0x00,0xcf, /* ................ */ \
	0x06,0x00,0x00,0xcd,0x00,0x00,0x00,0x56,0x07,0x00,0x00,0xce,0x00,0x00,0x00,0xbf  /* .......V........ */
#define DATACHUNK000010 \
	0x07,0x00,0x00,0xa5,0x00,0x00,0x00,0x38,0x08,0x00,0x00,0x9d,0x00,0x00,0x00,0x3a, /* .......8.......: */ \
	0x0b,0x00,0x00,0x02,0x00,0x00,0x00,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64, /* .......~inc:head */ \
	0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64, /* er.inc~..<div id */ \
	0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c, /* ="content">....< */ \
	0x68,0x31,0x3e,0x4e,0x6f,0x64,0x65,0x20,0x41,0x64,0x61,0x70,0x74,0x65,0x72,0x20, /* h1>Node Adapter  */ \
	0x43,0x6f,0x6e,0x66,0x69,0x67,0x75,0x72,0x61,0x74,0x69,0x6f,0x6e,0x3c,0x2f,0x68, /* Configuration</h */ \
	0x31,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x66,0x6f,0x72,0x6d,0x20,0x6d,0x65,0x74,0x68, /* 1>....<form meth */ \
	0x6f,0x64,0x3d,0x22,0x70,0x6f,0x73,0x74,0x22,0x20,0x61,0x63,0x74,0x69,0x6f,0x6e, /* od="post" action */ \
	0x3d,0x22,0x2f,0x6e,0x6f,0x64,0x65,0x61,0x64,0x61,0x70,0x74,0x65,0x72,0x2f,0x63, /* ="/nodeadapter/c */ \
	0x6f,0x6e,0x66,0x69,0x67,0x2e,0x68,0x74,0x6d,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d, /* onfig.htm" name= */ \
	0x22,0x6e,0x6f,0x64,0x65,0x63,0x66,0x67,0x22,0x3e,0x0d,0x0a,0x3c,0x66,0x69,0x65, /* "nodecfg">..<fie */ \
	0x6c,0x64,0x73,0x65,0x74,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61, /* ldset>..<div><la */ \
	0x62,0x65,0x6c,0x3e,0x54,0x58,0x20,0x44,0x65,0x6c,0x61,0x79,0x20,0x54,0x69,0x6d, /* bel>TX Delay Tim */ \
	0x65,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70, /* e:</label>..<inp */ \
	0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e, /* ut type="text" n */ \
	0x61,0x6d,0x65,0x3d,0x22,0x64,0x65,0x6c,0x79,0x22,0x20,0x76,0x61,0x6c,0x75,0x65, /* ame="dely" value */ \
	0x3d,0x22,0x7e,0x64,0x65,0x6c,0x61,0x79,0x5f,0x74,0x69,0x6d,0x65,0x7e,0x22,0x20, /* ="~delay_time~"  */ \
	0x73,0x69,0x7a,0x65,0x3d,0x22,0x34,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22, /* size="4" class=" */ \
	0x61,0x64,0x31,0x22,0x20,0x2f,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x6d,0x53,0x65, /* ad1" />&nbsp;mSe */ \
	0x63,0x2e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c, /* c.</div>..<div>< */ \
	0x6c,0x61,0x62,0x65,0x6c,0x3e,0x54,0x58,0x20,0x54,0x69,0x6d,0x65,0x20,0x6f,0x75, /* label>TX Time ou */ \
	0x74,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70, /* t:</label>..<inp */ \
	0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e, /* ut type="text" n */ \
	0x61,0x6d,0x65,0x3d,0x22,0x74,0x6f,0x75,0x74,0x22,0x20,0x76,0x61,0x6c,0x75,0x65, /* ame="tout" value */ \
	0x3d,0x22,0x7e,0x74,0x69,0x6d,0x65,0x5f,0x6f,0x75,0x74,0x7e,0x22,0x20,0x73,0x69, /* ="~time_out~" si */ \
	0x7a,0x65,0x3d,0x22,0x34,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64, /* ze="4" class="ad */ \
	0x31,0x22,0x2f,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x53,0x65,0x63,0x2e,0x3c,0x2f, /* 1"/>&nbsp;Sec.</ */ \
	0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65, /* div>..<div><labe */ \
	0x6c,0x3e,0x52,0x58,0x20,0x4b,0x65,0x65,0x70,0x20,0x41,0x6c,0x69,0x76,0x65,0x3a, /* l>RX Keep Alive: */ \
	0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74, /* </label>..<input */ \
	0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d, /*  type="text" nam */ \
	0x65,0x3d,0x22,0x6b,0x65,0x65,0x70,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22, /* e="keep" value=" */ \
	0x7e,0x6b,0x65,0x65,0x70,0x5f,0x61,0x6c,0x69,0x76,0x65,0x7e,0x22,0x20,0x73,0x69, /* ~keep_alive~" si */ \
	0x7a,0x65,0x3d,0x22,0x34,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64, /* ze="4" class="ad */ \
	0x31,0x22,0x2f,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x6d,0x53,0x65,0x63,0x2e,0x3c, /* 1"/>&nbsp;mSec.< */ \
	0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62, /* /div>..<div><lab */ \
	0x65,0x6c,0x3e,0x4a,0x69,0x74,0x74,0x65,0x72,0x20,0x42,0x75,0x66,0x66,0x65,0x72, /* el>Jitter Buffer */ \
	0x20,0x73,0x69,0x7a,0x65,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a, /*  size:</label>.. */ \
	0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78, /* <input type="tex */ \
	0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6a,0x69,0x74,0x74,0x22,0x20,0x76, /* t" name="jitt" v */ \
	0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x6a,0x69,0x74,0x74,0x74,0x65,0x72,0x5f,0x73, /* alue="~jittter_s */ \
	0x69,0x7a,0x65,0x7e,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x33,0x22,0x20,0x63, /* ize~" size="3" c */ \
	0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x2f,0x3e,0x26,0x6e,0x62,0x73, /* lass="ad1"/>&nbs */ \
	0x70,0x3b,0x30,0x3a,0x20,0x6e,0x6f,0x74,0x20,0x65,0x66,0x66,0x65,0x63,0x74,0x3c, /* p;0: not effect< */ \
	0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62, /* /div>..<div><lab */ \
	0x65,0x6c,0x3e,0x52,0x58,0x20,0x41,0x75,0x74,0x6f,0x20,0x50,0x6f,0x6c,0x61,0x72, /* el>RX Auto Polar */ \
	0x69,0x74,0x79,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69, /* ity:</label>..<i */ \
	0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b, /* nput type="check */ \
	0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x72,0x78,0x70,0x6c,0x22, /* box" name="rxpl" */ \
	0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x52,0x58,0x5f,0x41,0x75, /*  value="" ~RX_Au */ \
	0x74,0x6f,0x50,0x6f,0x6c,0x61,0x72,0x69,0x74,0x79,0x7e,0x20,0x63,0x6c,0x61,0x73, /* toPolarity~ clas */ \
	0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d, /* s="ad1"/></div>. */ \
	0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x52,0x58,0x20, /* .<div><label>RX  */ \
	0x50,0x6f,0x6c,0x61,0x72,0x69,0x74,0x79,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c, /* Polarity:</label */ \
	0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22, /* >..<input type=" */ \
	0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22, /* checkbox" name=" */ \
	0x72,0x78,0x70,0x6f,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e, /* rxpo" value="" ~ */ \
	0x52,0x58,0x5f,0x50,0x6f,0x6c,0x61,0x72,0x69,0x74,0x79,0x7e,0x20,0x20,0x63,0x6c, /* RX_Polarity~  cl */ \
	0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76, /* ass="ad1"/></div */ \
	0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x54, /* >..<div><label>T */ \
	0x58,0x20,0x50,0x6f,0x6c,0x61,0x72,0x69,0x74,0x79,0x3a,0x3c,0x2f,0x6c,0x61,0x62, /* X Polarity:</lab */ \
	0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20, /* el>..<td><input  */ \
	0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20, /* type="checkbox"  */ \
	0x6e,0x61,0x6d,0x65,0x3d,0x22,0x74,0x78,0x70,0x6f,0x22,0x20,0x76,0x61,0x6c,0x75  /* name="txpo" valu */
#define DATACHUNK000011 \
	0x65,0x3d,0x22,0x22,0x20,0x7e,0x54,0x58,0x5f,0x50,0x6f,0x6c,0x61,0x72,0x69,0x74, /* e="" ~TX_Polarit */ \
	0x79,0x7e,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x20,0x2f, /* y~ class="ad1" / */ \
	0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c, /* ></div>..<div><l */ \
	0x61,0x62,0x65,0x6c,0x3e,0x43,0x4f,0x53,0x20,0x43,0x68,0x65,0x63,0x6b,0x3a,0x3c, /* abel>COS Check:< */ \
	0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e, /* /label>..<td><in */ \
	0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62, /* put type="checkb */ \
	0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x63,0x6f,0x73,0x22,0x20,0x76, /* ox" name="cos" v */ \
	0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x43,0x4f,0x53,0x5f,0x43,0x68,0x65, /* alue="" ~COS_Che */ \
	0x63,0x6b,0x7e,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x20, /* ck~ class="ad1"  */ \
	0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c, /* /></div>..<div>< */ \
	0x6c,0x61,0x62,0x65,0x6c,0x3e,0x53,0x2f,0x4e,0x20,0x53,0x71,0x75,0x65,0x6c,0x63, /* label>S/N Squelc */ \
	0x68,0x20,0x56,0x61,0x6c,0x75,0x65,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e, /* h Value:</label> */ \
	0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70, /* ..<td><input typ */ \
	0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x73, /* e="text" name="s */ \
	0x6e,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x53,0x4e,0x5f,0x53,0x71, /* n" value="~SN_Sq */ \
	0x75,0x65,0x6c,0x63,0x68,0x7e,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x35,0x22, /* uelch~" size="5" */ \
	0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x2f,0x3e,0x26,0x6e, /*  class="ad1"/>&n */ \
	0x62,0x73,0x70,0x3b,0x30,0x3a,0x20,0x6e,0x6f,0x74,0x20,0x65,0x66,0x66,0x65,0x63, /* bsp;0: not effec */ \
	0x74,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c, /* t</div>..<div><l */ \
	0x61,0x62,0x65,0x6c,0x3e,0x43,0x52,0x43,0x20,0x43,0x68,0x65,0x63,0x6b,0x3a,0x3c, /* abel>CRC Check:< */ \
	0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e, /* /label>..<td><in */ \
	0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62, /* put type="checkb */ \
	0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x63,0x72,0x63,0x22,0x20,0x76, /* ox" name="crc" v */ \
	0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x43,0x52,0x43,0x5f,0x43,0x68,0x65, /* alue="" ~CRC_Che */ \
	0x63,0x6b,0x7e,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x2f, /* ck~ class="ad1"/ */ \
	0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c, /* ></div>..<div><l */ \
	0x61,0x62,0x65,0x6c,0x3e,0x4c,0x61,0x73,0x74,0x20,0x46,0x72,0x61,0x6d,0x65,0x20, /* abel>Last Frame  */ \
	0x53,0x65,0x6e,0x64,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c, /* Send:</label>..< */ \
	0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22, /* td><input type=" */ \
	0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22, /* checkbox" name=" */ \
	0x6c,0x61,0x73,0x74,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e, /* last" value="" ~ */ \
	0x4c,0x61,0x73,0x74,0x46,0x72,0x61,0x6d,0x65,0x7e,0x20,0x63,0x6c,0x61,0x73,0x73, /* LastFrame~ class */ \
	0x3d,0x22,0x61,0x64,0x31,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d, /* ="ad1" /></div>. */ \
	0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x48,0x65,0x61, /* .<div><label>Hea */ \
	0x64,0x65,0x72,0x20,0x47,0x65,0x6e,0x65,0x72,0x61,0x74,0x69,0x6f,0x6e,0x3a,0x3c, /* der Generation:< */ \
	0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e, /* /label>..<td><in */ \
	0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62, /* put type="checkb */ \
	0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x68,0x64,0x72,0x67,0x22,0x20, /* ox" name="hdrg"  */ \
	0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x48,0x65,0x61,0x64,0x65,0x72, /* value="" ~Header */ \
	0x47,0x65,0x6e,0x7e,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22, /* Gen~ class="ad1" */ \
	0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e, /*  /></div>..<div> */ \
	0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x48,0x65,0x61,0x64,0x65,0x72,0x20,0x47,0x65, /* <label>Header Ge */ \
	0x6e,0x2e,0x20,0x54,0x79,0x70,0x65,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e, /* n. Type:</label> */ \
	0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70, /* ..<td><input typ */ \
	0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d, /* e="checkbox" nam */ \
	0x65,0x3d,0x22,0x68,0x64,0x72,0x74,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22, /* e="hdrt" value=" */ \
	0x22,0x20,0x7e,0x48,0x65,0x61,0x64,0x65,0x72,0x47,0x65,0x6e,0x54,0x79,0x70,0x65, /* " ~HeaderGenType */ \
	0x7e,0x20,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x2f,0x3e, /* ~  class="ad1"/> */ \
	0x26,0x6e,0x62,0x73,0x70,0x3b,0x43,0x68,0x65,0x63,0x6b,0x65,0x64,0x3a,0x20,0x53, /* &nbsp;Checked: S */ \
	0x70,0x61,0x63,0x65,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76, /* pace</div>..<div */ \
	0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62, /* >&nbsp;&nbsp;&nb */ \
	0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26, /* sp;&nbsp;&nbsp;& */ \
	0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70, /* nbsp;&nbsp;&nbsp */ \
	0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x0d,0x26,0x6e, /* ;&nbsp;&nbsp;.&n */ \
	0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b, /* bsp;&nbsp;&nbsp; */ \
	0x0a,0x55,0x6e,0x63,0x68,0x65,0x63,0x6b,0x65,0x64,0x3a,0x20,0x4c,0x61,0x73,0x74, /* .Unchecked: Last */ \
	0x20,0x52,0x46,0x20,0x48,0x65,0x61,0x64,0x65,0x72,0x3c,0x2f,0x64,0x69,0x76,0x3e, /*  RF Header</div> */ \
	0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x48,0x61, /* ..<div><label>Ha */ \
	0x6c,0x66,0x2f,0x46,0x75,0x6c,0x6c,0x20,0x44,0x75,0x70,0x6c,0x65,0x78,0x3a,0x3c, /* lf/Full Duplex:< */ \
	0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e, /* /label>..<td><in */ \
	0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62, /* put type="checkb */ \
	0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x68,0x5f,0x66,0x22,0x20,0x76, /* ox" name="h_f" v */ \
	0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x48,0x61,0x6c,0x66,0x46,0x75,0x6c, /* alue="" ~HalfFul */ \
	0x6c,0x7e,0x20,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x2f  /* l~  class="ad1"/ */
#define DATACHUNK000012 \
	0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x43,0x68,0x65,0x63,0x6b,0x65,0x64,0x3a,0x26, /* >&nbsp;Checked:& */ \
	0x6e,0x62,0x73,0x70,0x3b,0x48,0x61,0x6c,0x66,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d, /* nbsp;Half</div>. */ \
	0x0a,0x3c,0x64,0x69,0x76,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73, /* .<div>&nbsp;&nbs */ \
	0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e, /* p;&nbsp;&nbsp;&n */ \
	0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b, /* bsp;&nbsp;&nbsp; */ \
	0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73, /* &nbsp;&nbsp;&nbs */ \
	0x70,0x3b,0x0d,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26, /* p;.&nbsp;&nbsp;& */ \
	0x6e,0x62,0x73,0x70,0x3b,0x0a,0x55,0x6e,0x63,0x68,0x65,0x63,0x6b,0x65,0x64,0x3a, /* nbsp;.Unchecked: */ \
	0x20,0x46,0x75,0x6c,0x6c,0x20,0x44,0x75,0x70,0x6c,0x65,0x78,0x3c,0x2f,0x64,0x69, /*  Full Duplex</di */ \
	0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x69,0x6e,0x70,0x75, /* v>....<div><inpu */ \
	0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x73,0x75,0x62,0x6d,0x69,0x74,0x22,0x20, /* t type="submit"  */ \
	0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x70,0x31,0x22,0x20,0x76,0x61,0x6c,0x75, /* class="ap1" valu */ \
	0x65,0x3d,0x22,0x53,0x61,0x76,0x65,0x20,0x42,0x61,0x73,0x69,0x63,0x20,0x49,0x6e, /* e="Save Basic In */ \
	0x66,0x6f,0x2e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c, /* fo." /></div>..< */ \
	0x2f,0x66,0x69,0x65,0x6c,0x64,0x73,0x65,0x74,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x6f, /* /fieldset>..</fo */ \
	0x72,0x6d,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x7e,0x69,0x6e, /* rm>..</div>..~in */ \
	0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x00,0x00,0x00, /* c:footer.inc~... */ \
	0x00,0x33,0x00,0x00,0x00,0xeb,0x00,0x00,0x00,0x51,0x00,0x00,0x00,0x6b,0x01,0x00, /* .3.......Q...k.. */ \
	0x00,0x52,0x00,0x00,0x00,0xe9,0x01,0x00,0x00,0x53,0x00,0x00,0x00,0x6f,0x02,0x00, /* .R.......S...o.. */ \
	0x00,0x54,0x00,0x00,0x00,0x03,0x03,0x00,0x00,0x55,0x00,0x00,0x00,0x78,0x03,0x00, /* .T.......U...x.. */ \
	0x00,0x5e,0x00,0x00,0x00,0xee,0x03,0x00,0x00,0x56,0x00,0x00,0x00,0x61,0x04,0x00, /* .^.......V...a.. */ \
	0x00,0x57,0x00,0x00,0x00,0xd3,0x04,0x00,0x00,0x58,0x00,0x00,0x00,0x61,0x05,0x00, /* .W.......X...a.. */ \
	0x00,0x59,0x00,0x00,0x00,0xd8,0x05,0x00,0x00,0x5a,0x00,0x00,0x00,0x52,0x06,0x00, /* .Y.......Z...R.. */ \
	0x00,0x5b,0x00,0x00,0x00,0xcb,0x06,0x00,0x00,0x5c,0x00,0x00,0x00,0xd1,0x07,0x00, /* .[.......\...... */ \
	0x00,0x5d,0x00,0x00,0x00,0xe6,0x08,0x00,0x00,0x02,0x00,0x00,0x00,0x7e,0x69,0x6e, /* .]...........~in */ \
	0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x3c, /* c:header.inc~..< */ \
	0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x22, /* div id="content" */ \
	0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x42,0x65,0x61,0x63,0x6f,0x6e,0x20, /* >....<h1>Beacon  */ \
	0x43,0x6f,0x6e,0x66,0x69,0x67,0x75,0x72,0x61,0x74,0x69,0x6f,0x6e,0x3c,0x2f,0x68, /* Configuration</h */ \
	0x31,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x66,0x6f,0x72,0x6d,0x20,0x6d,0x65,0x74,0x68, /* 1>....<form meth */ \
	0x6f,0x64,0x3d,0x22,0x70,0x6f,0x73,0x74,0x22,0x20,0x61,0x63,0x74,0x69,0x6f,0x6e, /* od="post" action */ \
	0x3d,0x22,0x2f,0x6e,0x6f,0x64,0x65,0x61,0x64,0x61,0x70,0x74,0x65,0x72,0x2f,0x63, /* ="/nodeadapter/c */ \
	0x6f,0x6e,0x66,0x69,0x67,0x32,0x2e,0x68,0x74,0x6d,0x22,0x20,0x6e,0x61,0x6d,0x65, /* onfig2.htm" name */ \
	0x3d,0x22,0x62,0x65,0x61,0x63,0x6f,0x6e,0x22,0x3e,0x0d,0x0a,0x3c,0x66,0x69,0x65, /* ="beacon">..<fie */ \
	0x6c,0x64,0x73,0x65,0x74,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61, /* ldset>..<div><la */ \
	0x62,0x65,0x6c,0x3e,0x42,0x65,0x61,0x63,0x6f,0x6e,0x20,0x4d,0x65,0x73,0x73,0x61, /* bel>Beacon Messa */ \
	0x67,0x65,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e, /* ge:</label>..<in */ \
	0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20, /* put type="text"  */ \
	0x6e,0x61,0x6d,0x65,0x3d,0x22,0x62,0x65,0x61,0x63,0x22,0x20,0x76,0x61,0x6c,0x75, /* name="beac" valu */ \
	0x65,0x3d,0x22,0x7e,0x42,0x65,0x61,0x63,0x6f,0x6e,0x4d,0x7e,0x22,0x20,0x73,0x69, /* e="~BeaconM~" si */ \
	0x7a,0x65,0x3d,0x22,0x32,0x30,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x73, /* ze="20" class="s */ \
	0x6d,0x22,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76, /* m"/></div>..<div */ \
	0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x49,0x6e,0x65,0x72,0x76,0x61,0x6c,0x3a, /* ><label>Inerval: */ \
	0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74, /* </label>..<input */ \
	0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d, /*  type="text" nam */ \
	0x65,0x3d,0x22,0x69,0x6e,0x74,0x76,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22, /* e="intv" value=" */ \
	0x7e,0x42,0x65,0x61,0x63,0x6f,0x6e,0x49,0x6e,0x74,0x76,0x7e,0x22,0x20,0x73,0x69, /* ~BeaconIntv~" si */ \
	0x7a,0x65,0x3d,0x22,0x33,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64, /* ze="3" class="ad */ \
	0x31,0x22,0x2f,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x53,0x65,0x63,0x2e,0x3c,0x2f, /* 1"/>&nbsp;Sec.</ */ \
	0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65, /* div>..<div><labe */ \
	0x6c,0x3e,0x42,0x65,0x61,0x63,0x6f,0x6e,0x20,0x43,0x61,0x6c,0x6c,0x53,0x69,0x67, /* l>Beacon CallSig */ \
	0x6e,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70, /* n:</label>..<inp */ \
	0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e, /* ut type="text" n */ \
	0x61,0x6d,0x65,0x3d,0x22,0x62,0x63,0x61,0x6c,0x22,0x20,0x76,0x61,0x6c,0x75,0x65, /* ame="bcal" value */ \
	0x3d,0x22,0x7e,0x42,0x65,0x61,0x63,0x6f,0x6e,0x43,0x61,0x6c,0x6c,0x7e,0x22,0x20, /* ="~BeaconCall~"  */ \
	0x73,0x69,0x7a,0x65,0x3d,0x22,0x38,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22, /* size="8" class=" */ \
	0x73,0x6d,0x22,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c, /* sm"/></div>....< */ \
	0x64,0x69,0x76,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d, /* div><input type= */ \
	0x22,0x73,0x75,0x62,0x6d,0x69,0x74,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22, /* "submit" class=" */ \
	0x61,0x70,0x31,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x53,0x61,0x76,0x65, /* ap1" value="Save */ \
	0x20,0x42,0x65,0x61,0x63,0x6f,0x6e,0x20,0x49,0x6e,0x66,0x6f,0x2e,0x22,0x20,0x2f, /*  Beacon Info." / */ \
	0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x69,0x65,0x6c,0x64, /* ></div>..</field */ \
	0x73,0x65,0x74,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x6f,0x72,0x6d,0x3e,0x0d,0x0a,0x3c, /* set>..</form>..< */ \
	0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74  /* /div>..~inc:foot */
#define DATACHUNK000013 \
	0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0xe6, /* er.inc~....3.... */ \
	0x00,0x00,0x00,0x71,0x00,0x00,0x00,0x53,0x01,0x00,0x00,0x72,0x00,0x00,0x00,0xd5, /* ...q...S...r.... */ \
	0x01,0x00,0x00,0x9f,0x00,0x00,0x00,0x6a,0x02,0x00,0x00,0x02,0x00,0x00,0x00,0x7e, /* .......j.......~ */ \
	0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0a, /* inc:header.inc~. */ \
	0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74, /* <div id="content */ \
	0x22,0x3e,0x0a,0x0a,0x3c,0x68,0x31,0x3e,0x54,0x58,0x20,0x48,0x65,0x61,0x64,0x65, /* ">..<h1>TX Heade */ \
	0x72,0x20,0x52,0x65,0x70,0x6c,0x61,0x63,0x65,0x20,0x43,0x6f,0x6e,0x66,0x69,0x67, /* r Replace Config */ \
	0x75,0x72,0x61,0x74,0x69,0x6f,0x6e,0x3c,0x2f,0x68,0x31,0x3e,0x0a,0x0a,0x3c,0x66, /* uration</h1>..<f */ \
	0x6f,0x72,0x6d,0x20,0x6d,0x65,0x74,0x68,0x6f,0x64,0x3d,0x22,0x70,0x6f,0x73,0x74, /* orm method="post */ \
	0x22,0x20,0x61,0x63,0x74,0x69,0x6f,0x6e,0x3d,0x22,0x2f,0x6e,0x6f,0x64,0x65,0x61, /* " action="/nodea */ \
	0x64,0x61,0x70,0x74,0x65,0x72,0x2f,0x63,0x6f,0x6e,0x66,0x69,0x67,0x33,0x2e,0x68, /* dapter/config3.h */ \
	0x74,0x6d,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x68,0x65,0x61,0x64,0x65,0x72, /* tm" name="header */ \
	0x63,0x66,0x67,0x22,0x3e,0x0a,0x3c,0x66,0x69,0x65,0x6c,0x64,0x73,0x65,0x74,0x3e, /* cfg">.<fieldset> */ \
	0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x54,0x58,0x20, /* .<div><label>TX  */ \
	0x48,0x65,0x61,0x64,0x65,0x72,0x20,0x52,0x65,0x70,0x6c,0x61,0x63,0x65,0x3a,0x3c, /* Header Replace:< */ \
	0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74, /* /label>.<input t */ \
	0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e, /* ype="checkbox" n */ \
	0x61,0x6d,0x65,0x3d,0x22,0x74,0x78,0x68,0x72,0x22,0x20,0x76,0x61,0x6c,0x75,0x65, /* ame="txhr" value */ \
	0x3d,0x22,0x22,0x20,0x7e,0x48,0x65,0x61,0x64,0x65,0x72,0x52,0x65,0x70,0x7e,0x20, /* ="" ~HeaderRep~  */ \
	0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x20,0x6f,0x6e,0x63,0x6c, /* class="ad1" oncl */ \
	0x69,0x63,0x6b,0x3d,0x22,0x63,0x6f,0x6e,0x66,0x69,0x67,0x48,0x65,0x61,0x64,0x65, /* ick="configHeade */ \
	0x72,0x28,0x29,0x22,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0a,0x3c,0x62,0x72, /* r()"/></div>.<br */ \
	0x3e,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x41,0x6c, /* >.<div><label>Al */ \
	0x74,0x65,0x72,0x20,0x4d,0x79,0x43,0x61,0x6c,0x6c,0x3a,0x3c,0x2f,0x6c,0x61,0x62, /* ter MyCall:</lab */ \
	0x65,0x6c,0x3e,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d, /* el>.<input type= */ \
	0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6d,0x79,0x63, /* "text" name="myc */ \
	0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x61,0x6c,0x74,0x5f,0x6d,0x79, /* " value="~alt_my */ \
	0x63,0x61,0x6c,0x6c,0x7e,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x38,0x22,0x20, /* call~" size="8"  */ \
	0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x2f,0x3e,0x0a,0x3c,0x69, /* class="ad1"/>.<i */ \
	0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b, /* nput type="check */ \
	0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x61,0x6d,0x79,0x63,0x22, /* box" name="amyc" */ \
	0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x61,0x5f,0x6d,0x79,0x63, /*  value="" ~a_myc */ \
	0x61,0x6c,0x6c,0x7e,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x33,0x22, /* all~ class="ad3" */ \
	0x20,0x2f,0x3e,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0a,0x3c,0x64,0x69,0x76,0x3e, /*  />.</div>.<div> */ \
	0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x41,0x6c,0x74,0x65,0x72,0x20,0x4d,0x79,0x43, /* <label>Alter MyC */ \
	0x61,0x6c,0x6c,0x32,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0a,0x3c,0x69, /* all2:</label>.<i */ \
	0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22, /* nput type="text" */ \
	0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6d,0x79,0x63,0x32,0x22,0x20,0x76,0x61,0x6c, /*  name="myc2" val */ \
	0x75,0x65,0x3d,0x22,0x7e,0x61,0x6c,0x74,0x5f,0x6d,0x79,0x63,0x61,0x6c,0x6c,0x32, /* ue="~alt_mycall2 */ \
	0x7e,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x34,0x22,0x20,0x63,0x6c,0x61,0x73, /* ~" size="4" clas */ \
	0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x2f,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26, /* s="ad1"/>&nbsp;& */ \
	0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70, /* nbsp;&nbsp;&nbsp */ \
	0x3b,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63, /* ;.<input type="c */ \
	0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x61, /* heckbox" name="a */ \
	0x6d,0x79,0x32,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x61, /* my2" value="" ~a */ \
	0x5f,0x6d,0x79,0x63,0x61,0x6c,0x6c,0x32,0x7e,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d, /* _mycall2~ class= */ \
	0x22,0x61,0x64,0x33,0x22,0x20,0x2f,0x3e,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0a, /* "ad3" />.</div>. */ \
	0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x41,0x6c,0x74,0x65, /* <div><label>Alte */ \
	0x72,0x20,0x59,0x6f,0x75,0x72,0x43,0x61,0x6c,0x6c,0x3a,0x3c,0x2f,0x6c,0x61,0x62, /* r YourCall:</lab */ \
	0x65,0x6c,0x3e,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d, /* el>.<input type= */ \
	0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x79,0x72,0x63, /* "text" name="yrc */ \
	0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x61,0x6c,0x74,0x5f,0x79,0x6f, /* " value="~alt_yo */ \
	0x75,0x72,0x63,0x61,0x6c,0x6c,0x7e,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x38, /* urcall~" size="8 */ \
	0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x2f,0x3e,0x0a, /* " class="ad1"/>. */ \
	0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65, /* <input type="che */ \
	0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x61,0x79,0x72, /* ckbox" name="ayr */ \
	0x63,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x61,0x5f,0x79, /* c" value="" ~a_y */ \
	0x6f,0x75,0x72,0x63,0x61,0x6c,0x6c,0x7e,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22, /* ourcall~ class=" */ \
	0x61,0x64,0x33,0x22,0x20,0x2f,0x3e,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0a,0x3c, /* ad3" />.</div>.< */ \
	0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x41,0x6c,0x74,0x65,0x72, /* div><label>Alter */ \
	0x20,0x52,0x50,0x54,0x31,0x20,0x43,0x61,0x6c,0x6c,0x3a,0x3c,0x2f,0x6c,0x61,0x62, /*  RPT1 Call:</lab */ \
	0x65,0x6c,0x3e,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d, /* el>.<input type= */ \
	0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x72,0x70,0x74, /* "text" name="rpt */ \
	0x31,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x61,0x6c,0x74,0x5f,0x72  /* 1" value="~alt_r */
#define DATACHUNK000014 \
	0x70,0x74,0x31,0x63,0x61,0x6c,0x6c,0x7e,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22, /* pt1call~" size=" */ \
	0x38,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x2f,0x3e, /* 8" class="ad1"/> */ \
	0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68, /* .<input type="ch */ \
	0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x61,0x72, /* eckbox" name="ar */ \
	0x74,0x31,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x61,0x5f, /* t1" value="" ~a_ */ \
	0x72,0x70,0x74,0x31,0x63,0x61,0x6c,0x6c,0x7e,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d, /* rpt1call~ class= */ \
	0x22,0x61,0x64,0x33,0x22,0x20,0x2f,0x3e,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0a, /* "ad3" />.</div>. */ \
	0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x41,0x6c,0x74,0x65, /* <div><label>Alte */ \
	0x72,0x20,0x52,0x50,0x54,0x32,0x20,0x43,0x61,0x6c,0x6c,0x3a,0x3c,0x2f,0x6c,0x61, /* r RPT2 Call:</la */ \
	0x62,0x65,0x6c,0x3e,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65, /* bel>.<input type */ \
	0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x72,0x70, /* ="text" name="rp */ \
	0x74,0x32,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x61,0x6c,0x74,0x5f, /* t2" value="~alt_ */ \
	0x72,0x70,0x74,0x32,0x63,0x61,0x6c,0x6c,0x7e,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d, /* rpt2call~" size= */ \
	0x22,0x38,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x2f, /* "8" class="ad1"/ */ \
	0x3e,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63, /* >.<input type="c */ \
	0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x61, /* heckbox" name="a */ \
	0x72,0x74,0x32,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x61, /* rt2" value="" ~a */ \
	0x5f,0x72,0x70,0x74,0x32,0x63,0x61,0x6c,0x6c,0x7e,0x20,0x63,0x6c,0x61,0x73,0x73, /* _rpt2call~ class */ \
	0x3d,0x22,0x61,0x64,0x33,0x22,0x20,0x2f,0x3e,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e, /* ="ad3" />.</div> */ \
	0x0a,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x41,0x6c, /* ..<div><label>Al */ \
	0x74,0x2e,0x20,0x54,0x58,0x20,0x48,0x65,0x61,0x64,0x65,0x72,0x20,0x46,0x6c,0x61, /* t. TX Header Fla */ \
	0x67,0x73,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0a,0x3c,0x69,0x6e,0x70, /* gs:</label>.<inp */ \
	0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f, /* ut type="checkbo */ \
	0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x66,0x6c,0x67,0x37,0x22,0x20,0x76, /* x" name="flg7" v */ \
	0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x66,0x6c,0x61,0x67,0x37,0x7e,0x20, /* alue="" ~flag7~  */ \
	0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x20,0x64,0x69,0x73,0x61, /* class="ad1" disa */ \
	0x62,0x6c,0x65,0x64,0x2f,0x3e,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79, /* bled/>.<input ty */ \
	0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61, /* pe="checkbox" na */ \
	0x6d,0x65,0x3d,0x22,0x66,0x6c,0x67,0x36,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d, /* me="flg6" value= */ \
	0x22,0x22,0x20,0x7e,0x66,0x6c,0x61,0x67,0x36,0x7e,0x20,0x63,0x6c,0x61,0x73,0x73, /* "" ~flag6~ class */ \
	0x3d,0x22,0x61,0x64,0x33,0x22,0x20,0x2f,0x3e,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74, /* ="ad3" />.<input */ \
	0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22, /*  type="checkbox" */ \
	0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x66,0x6c,0x67,0x35,0x22,0x20,0x76,0x61,0x6c, /*  name="flg5" val */ \
	0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x66,0x6c,0x61,0x67,0x35,0x7e,0x20,0x63,0x6c, /* ue="" ~flag5~ cl */ \
	0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x33,0x22,0x20,0x2f,0x3e,0x0a,0x3c,0x69,0x6e, /* ass="ad3" />.<in */ \
	0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62, /* put type="checkb */ \
	0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x66,0x6c,0x67,0x34,0x22,0x20, /* ox" name="flg4"  */ \
	0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x66,0x6c,0x61,0x67,0x34,0x7e, /* value="" ~flag4~ */ \
	0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x33,0x22,0x20,0x2f,0x3e,0x0a, /*  class="ad3" />. */ \
	0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65, /* <input type="che */ \
	0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x66,0x6c,0x67, /* ckbox" name="flg */ \
	0x33,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e,0x66,0x6c,0x61, /* 3" value="" ~fla */ \
	0x67,0x33,0x7e,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x33,0x22,0x20, /* g3~ class="ad3"  */ \
	0x2f,0x3e,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22, /* />.<input type=" */ \
	0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22, /* checkbox" name=" */ \
	0x66,0x6c,0x67,0x32,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x22,0x20,0x7e, /* flg2" value="" ~ */ \
	0x66,0x6c,0x61,0x67,0x32,0x7e,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64, /* flag2~ class="ad */ \
	0x33,0x22,0x20,0x2f,0x3e,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70, /* 3" />.<input typ */ \
	0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d, /* e="checkbox" nam */ \
	0x65,0x3d,0x22,0x66,0x6c,0x67,0x31,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22, /* e="flg1" value=" */ \
	0x22,0x20,0x7e,0x66,0x6c,0x61,0x67,0x31,0x7e,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d, /* " ~flag1~ class= */ \
	0x22,0x61,0x64,0x33,0x22,0x20,0x2f,0x3e,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20, /* "ad3" />.<input  */ \
	0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20, /* type="checkbox"  */ \
	0x6e,0x61,0x6d,0x65,0x3d,0x22,0x66,0x6c,0x67,0x30,0x22,0x20,0x76,0x61,0x6c,0x75, /* name="flg0" valu */ \
	0x65,0x3d,0x22,0x22,0x20,0x7e,0x66,0x6c,0x61,0x67,0x30,0x7e,0x20,0x63,0x6c,0x61, /* e="" ~flag0~ cla */ \
	0x73,0x73,0x3d,0x22,0x61,0x64,0x33,0x22,0x20,0x2f,0x3e,0x26,0x6e,0x62,0x73,0x70, /* ss="ad3" />&nbsp */ \
	0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74, /* ;&nbsp;.<input t */ \
	0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e, /* ype="checkbox" n */ \
	0x61,0x6d,0x65,0x3d,0x22,0x61,0x66,0x6c,0x67,0x22,0x20,0x76,0x61,0x6c,0x75,0x65, /* ame="aflg" value */ \
	0x3d,0x22,0x22,0x20,0x7e,0x41,0x66,0x6c,0x61,0x67,0x7e,0x20,0x63,0x6c,0x61,0x73, /* ="" ~Aflag~ clas */ \
	0x73,0x3d,0x22,0x61,0x64,0x33,0x22,0x20,0x2f,0x3e,0x0a,0x3c,0x2f,0x64,0x69,0x76, /* s="ad3" />.</div */ \
	0x3e,0x0a,0x0a,0x0a,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74, /* >....<div><input */ \
	0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x73,0x75,0x62,0x6d,0x69,0x74,0x22,0x20,0x63, /*  type="submit" c */ \
	0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x70,0x31,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d  /* lass="ap1" name= */
#define DATACHUNK000015 \
	0x22,0x68,0x64,0x72,0x73,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x53,0x61, /* "hdrs" value="Sa */ \
	0x76,0x65,0x20,0x48,0x65,0x61,0x64,0x65,0x72,0x20,0x49,0x6e,0x66,0x6f,0x2e,0x22, /* ve Header Info." */ \
	0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0a,0x3c,0x2f,0x66,0x69,0x65,0x6c, /*  /></div>.</fiel */ \
	0x64,0x73,0x65,0x74,0x3e,0x0a,0x3c,0x2f,0x66,0x6f,0x72,0x6d,0x3e,0x0a,0x3c,0x2f, /* dset>.</form>.</ */ \
	0x64,0x69,0x76,0x3e,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x6c,0x61,0x6e, /* div>.<script lan */ \
	0x67,0x75,0x61,0x67,0x65,0x3d,0x22,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70, /* guage="javascrip */ \
	0x74,0x22,0x3e,0x0a,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x20,0x63,0x6f,0x6e, /* t">.function con */ \
	0x66,0x69,0x67,0x48,0x65,0x61,0x64,0x65,0x72,0x28,0x29,0x20,0x7b,0x0a,0x09,0x65, /* figHeader() {..e */ \
	0x20,0x3d,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x66,0x6f,0x72,0x6d, /*  = document.form */ \
	0x73,0x2e,0x68,0x65,0x61,0x64,0x65,0x72,0x63,0x66,0x67,0x3b,0x0a,0x09,0x73,0x74, /* s.headercfg;..st */ \
	0x20,0x3d,0x20,0x21,0x28,0x65,0x2e,0x74,0x78,0x68,0x72,0x2e,0x63,0x68,0x65,0x63, /*  = !(e.txhr.chec */ \
	0x6b,0x65,0x64,0x29,0x3b,0x0a,0x09,0x65,0x2e,0x6d,0x79,0x63,0x2e,0x64,0x69,0x73, /* ked);..e.myc.dis */ \
	0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0a,0x09,0x65,0x2e,0x6d, /* abled = st;..e.m */ \
	0x79,0x63,0x32,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73, /* yc2.disabled = s */ \
	0x74,0x3b,0x0a,0x09,0x65,0x2e,0x79,0x72,0x63,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c, /* t;..e.yrc.disabl */ \
	0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0a,0x09,0x65,0x2e,0x72,0x70,0x74,0x31, /* ed = st;..e.rpt1 */ \
	0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0a, /* .disabled = st;. */ \
	0x09,0x65,0x2e,0x72,0x70,0x74,0x32,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64, /* .e.rpt2.disabled */ \
	0x20,0x3d,0x20,0x73,0x74,0x3b,0x0a,0x09,0x65,0x2e,0x66,0x6c,0x67,0x36,0x2e,0x64, /*  = st;..e.flg6.d */ \
	0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0a,0x09,0x65, /* isabled = st;..e */ \
	0x2e,0x66,0x6c,0x67,0x35,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d, /* .flg5.disabled = */ \
	0x20,0x73,0x74,0x3b,0x0a,0x09,0x65,0x2e,0x66,0x6c,0x67,0x34,0x2e,0x64,0x69,0x73, /*  st;..e.flg4.dis */ \
	0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0a,0x09,0x65,0x2e,0x66, /* abled = st;..e.f */ \
	0x6c,0x67,0x33,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73, /* lg3.disabled = s */ \
	0x74,0x3b,0x0a,0x09,0x65,0x2e,0x66,0x6c,0x67,0x32,0x2e,0x64,0x69,0x73,0x61,0x62, /* t;..e.flg2.disab */ \
	0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0a,0x09,0x65,0x2e,0x66,0x6c,0x67, /* led = st;..e.flg */ \
	0x31,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b, /* 1.disabled = st; */ \
	0x0a,0x09,0x65,0x2e,0x66,0x6c,0x67,0x30,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65, /* ..e.flg0.disable */ \
	0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0a,0x09,0x65,0x2e,0x61,0x66,0x6c,0x67,0x2e, /* d = st;..e.aflg. */ \
	0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0a,0x09, /* disabled = st;.. */ \
	0x65,0x2e,0x61,0x6d,0x79,0x63,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20, /* e.amyc.disabled  */ \
	0x3d,0x20,0x73,0x74,0x3b,0x0a,0x09,0x65,0x2e,0x61,0x6d,0x79,0x32,0x2e,0x64,0x69, /* = st;..e.amy2.di */ \
	0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0a,0x09,0x65,0x2e, /* sabled = st;..e. */ \
	0x61,0x79,0x72,0x63,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20, /* ayrc.disabled =  */ \
	0x73,0x74,0x3b,0x0a,0x09,0x65,0x2e,0x61,0x72,0x74,0x31,0x2e,0x64,0x69,0x73,0x61, /* st;..e.art1.disa */ \
	0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0a,0x09,0x65,0x2e,0x61,0x72, /* bled = st;..e.ar */ \
	0x74,0x32,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74, /* t2.disabled = st */ \
	0x3b,0x0a,0x7d,0x0a,0x0a,0x63,0x6f,0x6e,0x66,0x69,0x67,0x48,0x65,0x61,0x64,0x65, /* ;.}..configHeade */ \
	0x72,0x28,0x29,0x3b,0x0a,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74,0x3e,0x0a, /* r();..</script>. */ \
	0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e,0x63, /* .~inc:footer.inc */ \
	0x7e,0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0xf5,0x00,0x00,0x00,0x73,0x00,0x00, /* ~....3.......s.. */ \
	0x00,0x7a,0x01,0x00,0x00,0x74,0x00,0x00,0x00,0xcb,0x01,0x00,0x00,0x81,0x00,0x00, /* .z...t.......... */ \
	0x00,0x35,0x02,0x00,0x00,0x75,0x00,0x00,0x00,0x9f,0x02,0x00,0x00,0x82,0x00,0x00, /* .5...u.......... */ \
	0x00,0x0a,0x03,0x00,0x00,0x76,0x00,0x00,0x00,0x5d,0x03,0x00,0x00,0x83,0x00,0x00, /* .....v...]...... */ \
	0x00,0xcb,0x03,0x00,0x00,0x77,0x00,0x00,0x00,0x1e,0x04,0x00,0x00,0x84,0x00,0x00, /* .....w.......... */ \
	0x00,0x8c,0x04,0x00,0x00,0x78,0x00,0x00,0x00,0xdf,0x04,0x00,0x00,0x85,0x00,0x00, /* .....x.......... */ \
	0x00,0x59,0x05,0x00,0x00,0x79,0x00,0x00,0x00,0xa4,0x05,0x00,0x00,0x7a,0x00,0x00, /* .Y...y.......z.. */ \
	0x00,0xe7,0x05,0x00,0x00,0x7b,0x00,0x00,0x00,0x2a,0x06,0x00,0x00,0x7c,0x00,0x00, /* .....{.......|.. */ \
	0x00,0x6d,0x06,0x00,0x00,0x7d,0x00,0x00,0x00,0xb0,0x06,0x00,0x00,0x7e,0x00,0x00, /* .m...}.......~.. */ \
	0x00,0xf3,0x06,0x00,0x00,0x7f,0x00,0x00,0x00,0x36,0x07,0x00,0x00,0x80,0x00,0x00, /* .........6...... */ \
	0x00,0x85,0x07,0x00,0x00,0x88,0x00,0x00,0x00,0x42,0x0a,0x00,0x00,0x02,0x00,0x00, /* .........B...... */ \
	0x00,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63, /* .~inc:header.inc */ \
	0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74, /* ~..<div id="cont */ \
	0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x41,0x63,0x63,0x65,0x73, /* ent">..<h1>Acces */ \
	0x73,0x20,0x43,0x6f,0x6e,0x74,0x72,0x6f,0x6c,0x20,0x46,0x69,0x6c,0x65,0x3c,0x2f, /* s Control File</ */ \
	0x68,0x31,0x3e,0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x74,0x79,0x70, /* h1>..<script typ */ \
	0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x2f,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69, /* e="text/javascri */ \
	0x70,0x74,0x22,0x20,0x6c,0x61,0x6e,0x67,0x75,0x61,0x67,0x65,0x3d,0x22,0x4a,0x61, /* pt" language="Ja */ \
	0x76,0x61,0x53,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x0d,0x0a,0x3c,0x21,0x2d,0x2d, /* vaScript">..<!-- */ \
	0x0d,0x0a,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x20,0x49,0x6e,0x69,0x74,0x56, /* ..function InitV */ \
	0x61,0x6c,0x75,0x65,0x53,0x65,0x74,0x28,0x29,0x0d,0x0a,0x7b,0x0d,0x0a,0x63,0x61, /* alueSet()..{..ca */ \
	0x6c,0x6c,0x73,0x69,0x67,0x6e,0x20,0x3d,0x20,0x6e,0x65,0x77,0x20,0x41,0x72,0x72, /* llsign = new Arr */ \
	0x61,0x79,0x28,0x29,0x3b,0x0d,0x0a,0x61,0x63,0x63,0x65,0x73,0x73,0x09,0x20,0x3d, /* ay();..access. = */ \
	0x20,0x6e,0x65,0x77,0x20,0x41,0x72,0x72,0x61,0x79,0x28,0x29,0x3b,0x09,0x0d,0x0a  /*  new Array();... */
#define DATACHUNK000016 \
	0x7e,0x61,0x63,0x63,0x65,0x73,0x73,0x46,0x69,0x72,0x73,0x74,0x7e,0x0d,0x0a,0x7e, /* ~accessFirst~..~ */ \
	0x61,0x63,0x63,0x65,0x73,0x73,0x7e,0x0d,0x0a,0x7d,0x0d,0x0a,0x0d,0x0a,0x2f,0x2f, /* access~..}....// */ \
	0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74,0x3e,0x0d,0x0a, /* -->..</script>.. */ \
	0x3c,0x66,0x6f,0x72,0x6d,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x61,0x63,0x63,0x22, /* <form name="acc" */ \
	0x3e,0x0d,0x0a,0x3c,0x62,0x72,0x3e,0x0d,0x0a,0x3c,0x62,0x3e,0x4e,0x6f,0x74,0x65, /* >..<br>..<b>Note */ \
	0x3a,0x20,0x44,0x6f,0x20,0x6e,0x6f,0x74,0x20,0x63,0x6c,0x6f,0x73,0x65,0x20,0x74, /* : Do not close t */ \
	0x68,0x69,0x73,0x20,0x77,0x69,0x6e,0x64,0x6f,0x77,0x20,0x75,0x6e,0x74,0x69,0x6c, /* his window until */ \
	0x20,0x63,0x6c,0x6f,0x73,0x69,0x6e,0x67,0x20,0x74,0x68,0x65,0x20,0x65,0x64,0x69, /*  closing the edi */ \
	0x74,0x20,0x77,0x69,0x6e,0x64,0x6f,0x77,0x21,0x3c,0x2f,0x62,0x3e,0x3c,0x62,0x72, /* t window!</b><br */ \
	0x3e,0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x74,0x79,0x70,0x65,0x3d, /* >..<script type= */ \
	0x22,0x74,0x65,0x78,0x74,0x2f,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74, /* "text/javascript */ \
	0x22,0x20,0x6c,0x61,0x6e,0x67,0x75,0x61,0x67,0x65,0x3d,0x22,0x4a,0x61,0x76,0x61, /* " language="Java */ \
	0x53,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x0d,0x0a,0x3c,0x21,0x2d,0x2d,0x0d,0x0a, /* Script">..<!--.. */ \
	0x76,0x61,0x72,0x20,0x77,0x3b,0x0d,0x0a,0x49,0x6e,0x69,0x74,0x56,0x61,0x6c,0x75, /* var w;..InitValu */ \
	0x65,0x53,0x65,0x74,0x28,0x29,0x3b,0x0d,0x0a,0x69,0x66,0x20,0x28,0x21,0x77,0x20, /* eSet();..if (!w  */ \
	0x7c,0x7c,0x20,0x77,0x2e,0x63,0x6c,0x6f,0x73,0x65,0x64,0x29,0x20,0x77,0x69,0x6e, /* || w.closed) win */ \
	0x64,0x6f,0x77,0x2e,0x6f,0x70,0x65,0x6e,0x28,0x22,0x2e,0x2f,0x65,0x64,0x69,0x74, /* dow.open("./edit */ \
	0x2e,0x68,0x74,0x6d,0x22,0x29,0x3b,0x0d,0x0a,0x65,0x6c,0x73,0x65,0x20,0x77,0x2e, /* .htm");..else w. */ \
	0x66,0x6f,0x63,0x75,0x73,0x28,0x29,0x3b,0x0d,0x0a,0x2f,0x2f,0x20,0x2d,0x2d,0x3e, /* focus();..// --> */ \
	0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74,0x3e,0x0d,0x0a,0x3c,0x2f,0x66, /* ..</script>..</f */ \
	0x6f,0x72,0x6d,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a, /* orm>..</div>.... */ \
	0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e, /* ~inc:footer.inc~ */ \
	0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0xcf,0x00,0x00,0x00,0xc3,0x00,0x00,0x00, /* ....3........... */ \
	0xde,0x00,0x00,0x00,0xaa,0x00,0x00,0x00,0x1f,0x02,0x00,0x00,0x02,0x00,0x00,0x00, /* ................ */ \
	0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e, /* ~inc:header.inc~ */ \
	0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65, /* ..<div id="conte */ \
	0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x4e,0x65,0x74,0x77, /* nt">....<h1>Netw */ \
	0x6f,0x72,0x6b,0x20,0x43,0x6f,0x6e,0x66,0x69,0x67,0x75,0x72,0x61,0x74,0x69,0x6f, /* ork Configuratio */ \
	0x6e,0x3c,0x2f,0x68,0x31,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x66,0x6f,0x72,0x6d,0x20, /* n</h1>....<form  */ \
	0x6d,0x65,0x74,0x68,0x6f,0x64,0x3d,0x22,0x70,0x6f,0x73,0x74,0x22,0x20,0x61,0x63, /* method="post" ac */ \
	0x74,0x69,0x6f,0x6e,0x3d,0x22,0x2f,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x63, /* tion="/protect/c */ \
	0x6f,0x6e,0x66,0x69,0x67,0x2e,0x68,0x74,0x6d,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d, /* onfig.htm" name= */ \
	0x22,0x63,0x6f,0x6e,0x66,0x69,0x67,0x22,0x3e,0x0d,0x0a,0x3c,0x66,0x69,0x65,0x6c, /* "config">..<fiel */ \
	0x64,0x73,0x65,0x74,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62, /* dset>..<div><lab */ \
	0x65,0x6c,0x3e,0x4d,0x41,0x43,0x20,0x41,0x64,0x64,0x72,0x65,0x73,0x73,0x3a,0x3c, /* el>MAC Address:< */ \
	0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20, /* /label>..<input  */ \
	0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65, /* type="text" name */ \
	0x3d,0x22,0x6d,0x61,0x63,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x63, /* ="mac" value="~c */ \
	0x6f,0x6e,0x66,0x69,0x67,0x5f,0x6d,0x61,0x63,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f, /* onfig_mac~" /></ */ \
	0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65, /* div>..<div><labe */ \
	0x6c,0x3e,0x69,0x72,0x63,0x44,0x44,0x42,0x20,0x44,0x4e,0x53,0x20,0x75,0x73,0x65, /* l>ircDDB DNS use */ \
	0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75, /* :</label>..<inpu */ \
	0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78, /* t type="checkbox */ \
	0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x73,0x6d,0x22,0x20,0x6e,0x61,0x6d, /* " class="sm" nam */ \
	0x65,0x3d,0x22,0x69,0x72,0x63,0x64,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22, /* e="ircd" value=" */ \
	0x31,0x22,0x20,0x7e,0x69,0x72,0x63,0x44,0x44,0x42,0x7e,0x20,0x2f,0x3e,0x26,0x6e, /* 1" ~ircDDB~ />&n */ \
	0x62,0x73,0x70,0x3b,0x0d,0x0a,0x54,0x79,0x70,0x65,0x20,0x3a,0x3c,0x73,0x65,0x6c, /* bsp;..Type :<sel */ \
	0x65,0x63,0x74,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x69,0x72,0x63,0x74,0x22,0x3e, /* ect name="irct"> */ \
	0x0d,0x0a,0x3c,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d, /* ..<option value= */ \
	0x22,0x30,0x22,0x3e,0x52,0x65,0x66,0x6c,0x65,0x63,0x74,0x6f,0x72,0x0d,0x0a,0x3c, /* "0">Reflector..< */ \
	0x6f,0x70,0x74,0x69,0x6f,0x6e,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x31,0x22, /* option value="1" */ \
	0x3e,0x44,0x63,0x73,0x0d,0x0a,0x3c,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x20,0x76,0x61, /* >Dcs..<option va */ \
	0x6c,0x75,0x65,0x3d,0x22,0x32,0x22,0x3e,0x44,0x78,0x74,0x72,0x61,0x0d,0x0a,0x3c, /* lue="2">Dxtra..< */ \
	0x2f,0x73,0x65,0x6c,0x65,0x63,0x74,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e, /* /select>..</div> */ \
	0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x52,0x65, /* ..<div><label>Re */ \
	0x70,0x65,0x61,0x74,0x65,0x72,0x2f,0x52,0x65,0x66,0x6c,0x65,0x63,0x74,0x6f,0x72, /* peater/Reflector */ \
	0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x7e,0x52,0x65,0x66,0x53, /* :</label>..~RefS */ \
	0x65,0x6c,0x65,0x63,0x74,0x46,0x69,0x72,0x73,0x74,0x7e,0x0d,0x0a,0x7e,0x52,0x65, /* electFirst~..~Re */ \
	0x66,0x53,0x65,0x6c,0x65,0x63,0x74,0x7e,0x0d,0x0a,0x26,0x6e,0x62,0x73,0x70,0x3b, /* fSelect~..&nbsp; */ \
	0x42,0x61,0x6e,0x64,0x26,0x6e,0x62,0x73,0x70,0x3b,0x0d,0x0a,0x3c,0x73,0x65,0x6c, /* Band&nbsp;..<sel */ \
	0x65,0x63,0x74,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x62,0x61,0x6e,0x64,0x22,0x20, /* ect name="band"  */ \
	0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x33,0x22,0x20,0x73,0x69,0x7a,0x65, /* class="ad3" size */ \
	0x3d,0x22,0x31,0x22,0x2f,0x3e,0x0d,0x0a,0x7e,0x42,0x61,0x6e,0x64,0x53,0x65,0x6c, /* ="1"/>..~BandSel */ \
	0x65,0x63,0x74,0x7e,0x0d,0x0a,0x3c,0x2f,0x73,0x65,0x6c,0x65,0x63,0x74,0x3e,0x0d  /* ect~..</select>. */
#define DATACHUNK000017 \
	0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c, /* .</div>..<div><l */ \
	0x61,0x62,0x65,0x6c,0x3e,0x44,0x50,0x6c,0x75,0x73,0x20,0x47,0x61,0x74,0x65,0x2f, /* abel>DPlus Gate/ */ \
	0x52,0x65,0x66,0x2e,0x20,0x49,0x50,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e, /* Ref. IP:</label> */ \
	0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74, /* ..<input type="t */ \
	0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x68,0x6f,0x73,0x74,0x22, /* ext" name="host" */ \
	0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x73,0x65,0x72,0x76,0x65,0x72,0x5f, /*  value="~server_ */ \
	0x6e,0x61,0x6d,0x65,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d, /* name~" /></div>. */ \
	0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x41,0x75,0x74, /* .<div><label>Aut */ \
	0x6f,0x2e,0x20,0x4c,0x69,0x6e,0x6b,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e, /* o. Link:</label> */ \
	0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63, /* ..<input type="c */ \
	0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22, /* heckbox" class=" */ \
	0x73,0x6d,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x61,0x75,0x74,0x63,0x22,0x20, /* sm" name="autc"  */ \
	0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x31,0x22,0x20,0x7e,0x41,0x75,0x74,0x43,0x6f, /* value="1" ~AutCo */ \
	0x6e,0x6e,0x65,0x63,0x74,0x7e,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d, /* nnect~ /></div>. */ \
	0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x41,0x75,0x74, /* .<div><label>Aut */ \
	0x6f,0x2e,0x20,0x52,0x65,0x4c,0x69,0x6e,0x6b,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65, /* o. ReLink:</labe */ \
	0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d, /* l>..<input type= */ \
	0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x63,0x6c,0x61,0x73,0x73, /* "checkbox" class */ \
	0x3d,0x22,0x73,0x6d,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x72,0x65,0x63,0x6f, /* ="sm" name="reco */ \
	0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x31,0x22,0x20,0x7e,0x52,0x65,0x43, /* " value="1" ~ReC */ \
	0x6f,0x6e,0x6e,0x65,0x63,0x74,0x7e,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e, /* onnect~ /></div> */ \
	0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x52,0x65, /* ..<div><label>Re */ \
	0x70,0x65,0x61,0x74,0x65,0x72,0x20,0x41,0x63,0x63,0x65,0x73,0x73,0x3a,0x3c,0x2f, /* peater Access:</ */ \
	0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74, /* label>..<input t */ \
	0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x63, /* ype="checkbox" c */ \
	0x6c,0x61,0x73,0x73,0x3d,0x22,0x73,0x6d,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22, /* lass="sm" name=" */ \
	0x72,0x65,0x70,0x74,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x31,0x22,0x20, /* rept" value="1"  */ \
	0x7e,0x52,0x65,0x70,0x65,0x61,0x74,0x65,0x72,0x7e,0x20,0x2f,0x3e,0x3c,0x2f,0x64, /* ~Repeater~ /></d */ \
	0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c, /* iv>..<div><label */ \
	0x3e,0x4a,0x69,0x74,0x74,0x65,0x72,0x20,0x42,0x75,0x66,0x66,0x65,0x72,0x20,0x57, /* >Jitter Buffer W */ \
	0x61,0x69,0x74,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69, /* ait:</label>..<i */ \
	0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22, /* nput type="text" */ \
	0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6a,0x69,0x74,0x74,0x22,0x20,0x76,0x61,0x6c, /*  name="jitt" val */ \
	0x75,0x65,0x3d,0x22,0x7e,0x4a,0x69,0x74,0x74,0x65,0x72,0x53,0x69,0x7a,0x65,0x7e, /* ue="~JitterSize~ */ \
	0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x32,0x22,0x20,0x63,0x6c,0x61,0x73,0x73, /* " size="2" class */ \
	0x3d,0x22,0x61,0x64,0x31,0x22,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a, /* ="ad1"/></div>.. */ \
	0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x4e,0x54,0x50,0x20, /* <div><label>NTP  */ \
	0x53,0x65,0x72,0x76,0x65,0x72,0x20,0x4e,0x61,0x6d,0x65,0x3a,0x3c,0x2f,0x6c,0x61, /* Server Name:</la */ \
	0x62,0x65,0x6c,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b, /* bel>&nbsp;&nbsp; */ \
	0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73, /* &nbsp;&nbsp;&nbs */ \
	0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e, /* p;&nbsp;&nbsp;&n */ \
	0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x0d,0x0a,0x3c,0x73,0x65,0x6c, /* bsp;&nbsp;..<sel */ \
	0x65,0x63,0x74,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6e,0x74,0x70,0x22,0x3e,0x0d, /* ect name="ntp">. */ \
	0x0a,0x3c,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22, /* .<option value=" */ \
	0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67,0x22,0x3e,0x70,0x6f, /* pool.ntp.org">po */ \
	0x6f,0x6c,0x2e,0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67,0x0d,0x0a,0x3c,0x6f,0x70,0x74, /* ol.ntp.org..<opt */ \
	0x69,0x6f,0x6e,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x65,0x75,0x72,0x6f,0x70, /* ion value="europ */ \
	0x65,0x2e,0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67,0x22,0x3e, /* e.pool.ntp.org"> */ \
	0x65,0x75,0x72,0x6f,0x70,0x65,0x2e,0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74,0x70,0x2e, /* europe.pool.ntp. */ \
	0x6f,0x72,0x67,0x0d,0x0a,0x3c,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x20,0x76,0x61,0x6c, /* org..<option val */ \
	0x75,0x65,0x3d,0x22,0x61,0x73,0x69,0x61,0x2e,0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74, /* ue="asia.pool.nt */ \
	0x70,0x2e,0x6f,0x72,0x67,0x22,0x3e,0x61,0x73,0x69,0x61,0x2e,0x70,0x6f,0x6f,0x6c, /* p.org">asia.pool */ \
	0x2e,0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67,0x0d,0x0a,0x3c,0x6f,0x70,0x74,0x69,0x6f, /* .ntp.org..<optio */ \
	0x6e,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x6f,0x63,0x65,0x61,0x6e,0x69,0x61, /* n value="oceania */ \
	0x2e,0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67,0x22,0x3e,0x6f, /* .pool.ntp.org">o */ \
	0x63,0x65,0x61,0x6e,0x69,0x61,0x2e,0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74,0x70,0x2e, /* ceania.pool.ntp. */ \
	0x6f,0x72,0x67,0x0d,0x0a,0x3c,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x20,0x76,0x61,0x6c, /* org..<option val */ \
	0x75,0x65,0x3d,0x22,0x6e,0x6f,0x72,0x74,0x68,0x2d,0x61,0x6d,0x65,0x72,0x69,0x63, /* ue="north-americ */ \
	0x61,0x2e,0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67,0x22,0x3e, /* a.pool.ntp.org"> */ \
	0x6e,0x6f,0x72,0x74,0x68,0x2d,0x61,0x6d,0x65,0x72,0x69,0x63,0x61,0x2e,0x70,0x6f, /* north-america.po */ \
	0x6f,0x6c,0x2e,0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67,0x0d,0x0a,0x3c,0x6f,0x70,0x74, /* ol.ntp.org..<opt */ \
	0x69,0x6f,0x6e,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x73,0x6f,0x75,0x74,0x68, /* ion value="south */ \
	0x2d,0x61,0x6d,0x65,0x72,0x69,0x63,0x61,0x2e,0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74, /* -america.pool.nt */ \
	0x70,0x2e,0x6f,0x72,0x67,0x22,0x3e,0x73,0x6f,0x75,0x74,0x68,0x2d,0x61,0x6d,0x65  /* p.org">south-ame */
#define DATACHUNK000018 \
	0x72,0x69,0x63,0x61,0x2e,0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74,0x70,0x2e,0x6f,0x72, /* rica.pool.ntp.or */ \
	0x67,0x0d,0x0a,0x3c,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x20,0x76,0x61,0x6c,0x75,0x65, /* g..<option value */ \
	0x3d,0x22,0x61,0x66,0x72,0x69,0x63,0x61,0x2e,0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74, /* ="africa.pool.nt */ \
	0x70,0x2e,0x6f,0x72,0x67,0x22,0x3e,0x61,0x66,0x72,0x69,0x63,0x61,0x2e,0x70,0x6f, /* p.org">africa.po */ \
	0x6f,0x6c,0x2e,0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67,0x0d,0x0a,0x3c,0x2f,0x73,0x65, /* ol.ntp.org..</se */ \
	0x6c,0x65,0x63,0x74,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c, /* lect>..</div>..< */ \
	0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x54,0x69,0x6d,0x65,0x20, /* div><label>Time  */ \
	0x5a,0x6f,0x6e,0x65,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c, /* Zone:</label>..< */ \
	0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74, /* input type="text */ \
	0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x7a,0x6f,0x6e,0x65,0x22,0x20,0x76,0x61, /* " name="zone" va */ \
	0x6c,0x75,0x65,0x3d,0x22,0x7e,0x54,0x69,0x6d,0x65,0x5a,0x6f,0x6e,0x65,0x7e,0x22, /* lue="~TimeZone~" */ \
	0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x20,0x73,0x69,0x7a, /*  class="ad1" siz */ \
	0x65,0x3d,0x22,0x33,0x22,0x2f,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x68,0x6f,0x75, /* e="3"/>&nbsp;hou */ \
	0x72,0x73,0x26,0x6e,0x62,0x73,0x70,0x3b,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74, /* rs&nbsp;..<input */ \
	0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d, /*  type="text" nam */ \
	0x65,0x3d,0x22,0x7a,0x6e,0x65,0x4d,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22, /* e="zneM" value=" */ \
	0x7e,0x54,0x69,0x6d,0x65,0x5a,0x6f,0x6e,0x65,0x4d,0x69,0x6e,0x75,0x74,0x65,0x73, /* ~TimeZoneMinutes */ \
	0x7e,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x33,0x22,0x20,0x73, /* ~" class="ad3" s */ \
	0x69,0x7a,0x65,0x3d,0x22,0x32,0x22,0x2f,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x6d, /* ize="2"/>&nbsp;m */ \
	0x69,0x6e,0x75,0x74,0x65,0x73,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64, /* inutes</div>..<d */ \
	0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x44,0x69,0x73,0x61,0x62,0x6c, /* iv><label>Disabl */ \
	0x65,0x20,0x4c,0x69,0x6e,0x6b,0x2f,0x55,0x6e,0x6c,0x69,0x6e,0x6b,0x20,0x66,0x72, /* e Link/Unlink fr */ \
	0x6f,0x6d,0x20,0x52,0x46,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a, /* om RF:</label>.. */ \
	0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65, /* <input type="che */ \
	0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x73,0x6d, /* ckbox" class="sm */ \
	0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x72,0x66,0x63,0x6d,0x22,0x20,0x76,0x61, /* " name="rfcm" va */ \
	0x6c,0x75,0x65,0x3d,0x22,0x31,0x22,0x20,0x7e,0x44,0x69,0x73,0x61,0x62,0x6c,0x65, /* lue="1" ~Disable */ \
	0x52,0x46,0x63,0x6d,0x64,0x7e,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a, /* RFcmd~/></div>.. */ \
	0x3c,0x62,0x72,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65, /* <br>..<div><labe */ \
	0x6c,0x3e,0x56,0x6f,0x69,0x63,0x65,0x20,0x4d,0x65,0x73,0x73,0x61,0x67,0x65,0x20, /* l>Voice Message  */ \
	0x4f,0x46,0x46,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69, /* OFF:</label>..<i */ \
	0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b, /* nput type="check */ \
	0x62,0x6f,0x78,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x73,0x6d,0x22,0x20, /* box" class="sm"  */ \
	0x6e,0x61,0x6d,0x65,0x3d,0x22,0x76,0x69,0x63,0x65,0x22,0x20,0x76,0x61,0x6c,0x75, /* name="vice" valu */ \
	0x65,0x3d,0x22,0x31,0x22,0x20,0x7e,0x56,0x6f,0x69,0x63,0x65,0x4d,0x73,0x67,0x7e, /* e="1" ~VoiceMsg~ */ \
	0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x64,0x69,0x76, /* /></div>....<div */ \
	0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x64, /* >&nbsp;&nbsp;</d */ \
	0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70, /* iv>..<div>..<inp */ \
	0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f, /* ut type="checkbo */ \
	0x78,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x73,0x6d,0x22,0x20,0x6e,0x61, /* x" class="sm" na */ \
	0x6d,0x65,0x3d,0x22,0x64,0x68,0x63,0x70,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d, /* me="dhcp" value= */ \
	0x22,0x31,0x22,0x20,0x6f,0x6e,0x63,0x6c,0x69,0x63,0x6b,0x3d,0x22,0x63,0x6f,0x6e, /* "1" onclick="con */ \
	0x66,0x69,0x67,0x49,0x50,0x42,0x6f,0x78,0x65,0x73,0x28,0x29,0x22,0x20,0x7e,0x63, /* figIPBoxes()" ~c */ \
	0x6f,0x6e,0x66,0x69,0x67,0x5f,0x64,0x68,0x63,0x70,0x63,0x68,0x65,0x63,0x6b,0x65, /* onfig_dhcpchecke */ \
	0x64,0x7e,0x20,0x2f,0x3e,0x20,0x45,0x6e,0x61,0x62,0x6c,0x65,0x20,0x44,0x48,0x43, /* d~ /> Enable DHC */ \
	0x50,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c, /* P</div>..<div><l */ \
	0x61,0x62,0x65,0x6c,0x3e,0x49,0x50,0x20,0x41,0x64,0x64,0x72,0x65,0x73,0x73,0x3a, /* abel>IP Address: */ \
	0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69, /* </label>..<td><i */ \
	0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22, /* nput type="text" */ \
	0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x69,0x70,0x22,0x20,0x76,0x61,0x6c,0x75,0x65, /*  name="ip" value */ \
	0x3d,0x22,0x7e,0x63,0x6f,0x6e,0x66,0x69,0x67,0x5f,0x69,0x70,0x7e,0x22,0x20,0x2f, /* ="~config_ip~" / */ \
	0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c, /* ></div>..<div><l */ \
	0x61,0x62,0x65,0x6c,0x3e,0x47,0x61,0x74,0x65,0x77,0x61,0x79,0x3a,0x3c,0x2f,0x6c, /* abel>Gateway:</l */ \
	0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75, /* abel>..<td><inpu */ \
	0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61, /* t type="text" na */ \
	0x6d,0x65,0x3d,0x22,0x67,0x77,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e, /* me="gw" value="~ */ \
	0x63,0x6f,0x6e,0x66,0x69,0x67,0x5f,0x67,0x77,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f, /* config_gw~" /></ */ \
	0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65, /* div>..<div><labe */ \
	0x6c,0x3e,0x53,0x75,0x62,0x6e,0x65,0x74,0x20,0x4d,0x61,0x73,0x6b,0x3a,0x3c,0x2f, /* l>Subnet Mask:</ */ \
	0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70, /* label>..<td><inp */ \
	0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e, /* ut type="text" n */ \
	0x61,0x6d,0x65,0x3d,0x22,0x73,0x75,0x62,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d, /* ame="sub" value= */ \
	0x22,0x7e,0x63,0x6f,0x6e,0x66,0x69,0x67,0x5f,0x73,0x75,0x62,0x6e,0x65,0x74,0x7e, /* "~config_subnet~ */ \
	0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76  /* " /></div>..<div */
#define DATACHUNK000019 \
	0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x50,0x72,0x69,0x6d,0x61,0x72,0x79,0x20, /* ><label>Primary  */ \
	0x44,0x4e,0x53,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74, /* DNS:</label>..<t */ \
	0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74, /* d><input type="t */ \
	0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x64,0x6e,0x73,0x31,0x22, /* ext" name="dns1" */ \
	0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x63,0x6f,0x6e,0x66,0x69,0x67,0x5f, /*  value="~config_ */ \
	0x64,0x6e,0x73,0x31,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d, /* dns1~" /></div>. */ \
	0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x53,0x65,0x63, /* .<div><label>Sec */ \
	0x6f,0x6e,0x64,0x61,0x72,0x79,0x20,0x44,0x4e,0x53,0x3a,0x3c,0x2f,0x6c,0x61,0x62, /* ondary DNS:</lab */ \
	0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65, /* el>..<input type */ \
	0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x64,0x6e, /* ="text" name="dn */ \
	0x73,0x32,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x63,0x6f,0x6e,0x66, /* s2" value="~conf */ \
	0x69,0x67,0x5f,0x64,0x6e,0x73,0x32,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69, /* ig_dns2~" /></di */ \
	0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20, /* v>..<div><input  */ \
	0x74,0x79,0x70,0x65,0x3d,0x22,0x73,0x75,0x62,0x6d,0x69,0x74,0x22,0x20,0x63,0x6c, /* type="submit" cl */ \
	0x61,0x73,0x73,0x3d,0x22,0x73,0x6d,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22, /* ass="sm" value=" */ \
	0x53,0x61,0x76,0x65,0x20,0x43,0x6f,0x6e,0x66,0x69,0x67,0x22,0x20,0x2f,0x3e,0x3c, /* Save Config" />< */ \
	0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x69,0x65,0x6c,0x64,0x73,0x65, /* /div>..</fieldse */ \
	0x74,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x6f,0x72,0x6d,0x3e,0x0d,0x0a,0x3c,0x2f,0x64, /* t>..</form>..</d */ \
	0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x6c, /* iv>....<script l */ \
	0x61,0x6e,0x67,0x75,0x61,0x67,0x65,0x3d,0x22,0x6a,0x61,0x76,0x61,0x73,0x63,0x72, /* anguage="javascr */ \
	0x69,0x70,0x74,0x22,0x3e,0x0d,0x0a,0x3c,0x21,0x2d,0x2d,0x0d,0x0a,0x66,0x75,0x6e, /* ipt">..<!--..fun */ \
	0x63,0x74,0x69,0x6f,0x6e,0x20,0x63,0x6f,0x6e,0x66,0x69,0x67,0x49,0x50,0x42,0x6f, /* ction configIPBo */ \
	0x78,0x65,0x73,0x28,0x29,0x20,0x7b,0x0d,0x0a,0x09,0x65,0x20,0x3d,0x20,0x64,0x6f, /* xes() {...e = do */ \
	0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x66,0x6f,0x72,0x6d,0x73,0x2e,0x63,0x6f,0x6e, /* cument.forms.con */ \
	0x66,0x69,0x67,0x3b,0x0d,0x0a,0x09,0x73,0x74,0x20,0x3d,0x20,0x65,0x2e,0x64,0x68, /* fig;...st = e.dh */ \
	0x63,0x70,0x2e,0x63,0x68,0x65,0x63,0x6b,0x65,0x64,0x3b,0x0d,0x0a,0x09,0x65,0x2e, /* cp.checked;...e. */ \
	0x69,0x70,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74, /* ip.disabled = st */ \
	0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x67,0x77,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65, /* ;...e.gw.disable */ \
	0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x73,0x75,0x62,0x2e, /* d = st;...e.sub. */ \
	0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a, /* disabled = st;.. */ \
	0x09,0x65,0x2e,0x64,0x6e,0x73,0x31,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64, /* .e.dns1.disabled */ \
	0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x64,0x6e,0x73,0x32,0x2e, /*  = st;...e.dns2. */ \
	0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a, /* disabled = st;.. */ \
	0x7d,0x0d,0x0a,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x66,0x6f,0x72,0x6d, /* }..document.form */ \
	0x73,0x2e,0x63,0x6f,0x6e,0x66,0x69,0x67,0x2e,0x6d,0x61,0x63,0x2e,0x64,0x69,0x73, /* s.config.mac.dis */ \
	0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x74,0x72,0x75,0x65,0x3b,0x0d,0x0a,0x64, /* abled = true;..d */ \
	0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x66,0x6f,0x72,0x6d,0x73,0x2e,0x63,0x6f, /* ocument.forms.co */ \
	0x6e,0x66,0x69,0x67,0x2e,0x68,0x6f,0x73,0x74,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c, /* nfig.host.disabl */ \
	0x65,0x64,0x20,0x3d,0x20,0x74,0x72,0x75,0x65,0x3b,0x0d,0x0a,0x64,0x6f,0x63,0x75, /* ed = true;..docu */ \
	0x6d,0x65,0x6e,0x74,0x2e,0x66,0x6f,0x72,0x6d,0x73,0x2e,0x63,0x6f,0x6e,0x66,0x69, /* ment.forms.confi */ \
	0x67,0x2e,0x64,0x70,0x72,0x74,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20, /* g.dprt.disabled  */ \
	0x3d,0x20,0x74,0x72,0x75,0x65,0x3b,0x0d,0x0a,0x0d,0x0a,0x2f,0x2f,0x2d,0x2d,0x3e, /* = true;....//--> */ \
	0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74,0x3e,0x0d,0x0a,0x7e,0x69,0x6e, /* ..</script>..~in */ \
	0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x00,0x00,0x00, /* c:footer.inc~... */ \
	0x00,0x33,0x00,0x00,0x00,0xde,0x00,0x00,0x00,0x25,0x00,0x00,0x00,0x53,0x01,0x00, /* .3.......%...S.. */ \
	0x00,0xd0,0x00,0x00,0x00,0x0b,0x02,0x00,0x00,0xc2,0x00,0x00,0x00,0x1d,0x02,0x00, /* ................ */ \
	0x00,0x8d,0x00,0x00,0x00,0x68,0x02,0x00,0x00,0x99,0x00,0x00,0x00,0xd8,0x02,0x00, /* .....h.......... */ \
	0x00,0x4a,0x00,0x00,0x00,0x4a,0x03,0x00,0x00,0xa2,0x00,0x00,0x00,0xbc,0x03,0x00, /* .J...J.......... */ \
	0x00,0x9a,0x00,0x00,0x00,0x30,0x04,0x00,0x00,0xa0,0x00,0x00,0x00,0x94,0x04,0x00, /* .....0.......... */ \
	0x00,0x6e,0x00,0x00,0x00,0x25,0x07,0x00,0x00,0x61,0x00,0x00,0x00,0x80,0x07,0x00, /* .n...%...a...... */ \
	0x00,0x6d,0x00,0x00,0x00,0x28,0x08,0x00,0x00,0xa1,0x00,0x00,0x00,0xa6,0x08,0x00, /* .m...(.......... */ \
	0x00,0xa7,0x00,0x00,0x00,0x2e,0x09,0x00,0x00,0x27,0x00,0x00,0x00,0xa2,0x09,0x00, /* .........'...... */ \
	0x00,0x28,0x00,0x00,0x00,0xff,0x09,0x00,0x00,0x29,0x00,0x00,0x00,0x61,0x0a,0x00, /* .(.......)...a.. */ \
	0x00,0x2a,0x00,0x00,0x00,0xc8,0x0a,0x00,0x00,0x2b,0x00,0x00,0x00,0x2b,0x0b,0x00, /* .........+...+.. */ \
	0x00,0x2c,0x00,0x00,0x00,0x2d,0x0d,0x00,0x00,0x02,0x00,0x00,0x00,0x7e,0x69,0x6e, /* .,...-.......~in */ \
	0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x3c, /* c:header.inc~..< */ \
	0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x22, /* div id="content" */ \
	0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x44,0x65,0x62,0x75,0x67,0x20,0x4d, /* >....<h1>Debug M */ \
	0x6f,0x64,0x65,0x3c,0x2f,0x68,0x31,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x66,0x6f,0x72, /* ode</h1>....<for */ \
	0x6d,0x20,0x6d,0x65,0x74,0x68,0x6f,0x64,0x3d,0x22,0x70,0x6f,0x73,0x74,0x22,0x20, /* m method="post"  */ \
	0x61,0x63,0x74,0x69,0x6f,0x6e,0x3d,0x22,0x2f,0x70,0x72,0x6f,0x74,0x65,0x63,0x74, /* action="/protect */ \
	0x2f,0x64,0x65,0x62,0x75,0x67,0x2e,0x68,0x74,0x6d,0x22,0x20,0x6e,0x61,0x6d,0x65, /* /debug.htm" name */ \
	0x3d,0x22,0x64,0x65,0x62,0x67,0x22,0x3e,0x0d,0x0a,0x3c,0x66,0x69,0x65,0x6c,0x64, /* ="debg">..<field */ \
	0x73,0x65,0x74,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65  /* set>..<div><labe */
#define DATACHUNK00001a \
	0x6c,0x3e,0x44,0x65,0x62,0x75,0x67,0x20,0x53,0x77,0x69,0x74,0x63,0x68,0x20,0x3a, /* l>Debug Switch : */ \
	0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x20,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20, /* </label> <input  */ \
	0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20, /* type="checkbox"  */ \
	0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x33,0x22,0x20,0x6e,0x61,0x6d,0x65, /* class="ad3" name */ \
	0x3d,0x22,0x64,0x62,0x67,0x73,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x31, /* ="dbgs" value="1 */ \
	0x22,0x20,0x20,0x7e,0x44,0x65,0x62,0x75,0x67,0x53,0x77,0x69,0x74,0x63,0x68,0x7e, /* "  ~DebugSwitch~ */ \
	0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e, /*  /></div>..<div> */ \
	0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x73,0x75,0x62, /* <input type="sub */ \
	0x6d,0x69,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x73,0x65,0x6e,0x64,0x22, /* mit" name="send" */ \
	0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x53,0x65,0x74,0x22,0x20,0x20,0x63,0x6c, /*  value="Set"  cl */ \
	0x61,0x73,0x73,0x3d,0x22,0x73,0x6d,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76, /* ass="sm" /></div */ \
	0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x69,0x65,0x6c,0x64,0x73,0x65,0x74,0x3e,0x0d,0x0a, /* >..</fieldset>.. */ \
	0x0d,0x0a,0x3c,0x2f,0x66,0x6f,0x72,0x6d,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76, /* ..</form>..</div */ \
	0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x6c,0x61,0x6e, /* >....<script lan */ \
	0x67,0x75,0x61,0x67,0x65,0x3d,0x22,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70, /* guage="javascrip */ \
	0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x2f,0x2f,0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f, /* t">....//-->..</ */ \
	0x73,0x63,0x72,0x69,0x70,0x74,0x3e,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f, /* script>..~inc:fo */ \
	0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x00,0x00,0x00,0x00,0x33,0x00,0x00, /* oter.inc~....3.. */ \
	0x00,0xe6,0x00,0x00,0x00,0xc9,0x00,0x00,0x00,0x9c,0x01,0x00,0x00,0x02,0x00,0x00, /* ................ */ \
	0x00,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63, /* .~inc:header.inc */ \
	0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74, /* ~..<div id="cont */ \
	0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x44,0x50,0x52, /* ent">....<h1>DPR */ \
	0x53,0x20,0x43,0x6f,0x6e,0x66,0x69,0x67,0x75,0x72,0x61,0x74,0x69,0x6f,0x6e,0x3c, /* S Configuration< */ \
	0x2f,0x68,0x31,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x66,0x6f,0x72,0x6d,0x20,0x6d,0x65, /* /h1>....<form me */ \
	0x74,0x68,0x6f,0x64,0x3d,0x22,0x70,0x6f,0x73,0x74,0x22,0x20,0x61,0x63,0x74,0x69, /* thod="post" acti */ \
	0x6f,0x6e,0x3d,0x22,0x2f,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x64,0x70,0x72, /* on="/protect/dpr */ \
	0x73,0x2e,0x68,0x74,0x6d,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x64,0x70,0x72, /* s.htm" name="dpr */ \
	0x73,0x22,0x3e,0x0d,0x0a,0x3c,0x66,0x69,0x65,0x6c,0x64,0x73,0x65,0x74,0x3e,0x0d, /* s">..<fieldset>. */ \
	0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70, /* .<div><input typ */ \
	0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x63,0x6c,0x61, /* e="checkbox" cla */ \
	0x73,0x73,0x3d,0x22,0x73,0x6d,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x64,0x70, /* ss="sm" name="dp */ \
	0x73,0x77,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x31,0x22,0x20,0x6f,0x6e, /* sw" value="1" on */ \
	0x63,0x6c,0x69,0x63,0x6b,0x3d,0x22,0x63,0x6f,0x6e,0x66,0x69,0x67,0x44,0x50,0x52, /* click="configDPR */ \
	0x53,0x42,0x6f,0x78,0x65,0x73,0x28,0x29,0x22,0x20,0x7e,0x44,0x50,0x52,0x53,0x5f, /* SBoxes()" ~DPRS_ */ \
	0x63,0x68,0x65,0x63,0x6b,0x65,0x64,0x7e,0x20,0x2f,0x3e,0x20,0x45,0x6e,0x61,0x62, /* checked~ /> Enab */ \
	0x6c,0x65,0x20,0x44,0x50,0x52,0x53,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c, /* le DPRS</div>..< */ \
	0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x44,0x50,0x52,0x53,0x20, /* div><label>DPRS  */ \
	0x53,0x65,0x72,0x76,0x65,0x72,0x20,0x49,0x50,0x20,0x3a,0x3c,0x2f,0x6c,0x61,0x62, /* Server IP :</lab */ \
	0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65, /* el>..<input type */ \
	0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x64,0x70, /* ="text" name="dp */ \
	0x69,0x70,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x64,0x70,0x72,0x73, /* ip" value="~dprs */ \
	0x69,0x70,0x7e,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x32,0x30,0x22,0x20,0x63, /* ip~" size="20" c */ \
	0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x3e,0x3c,0x2f,0x64,0x69,0x76, /* lass="ad1"></div */ \
	0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x44, /* >..<div><label>D */ \
	0x50,0x52,0x53,0x20,0x53,0x65,0x72,0x76,0x65,0x72,0x20,0x50,0x6f,0x72,0x74,0x20, /* PRS Server Port  */ \
	0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75, /* :</label>..<inpu */ \
	0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61, /* t type="text" na */ \
	0x6d,0x65,0x3d,0x22,0x64,0x70,0x70,0x74,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d, /* me="dppt" value= */ \
	0x22,0x7e,0x64,0x70,0x72,0x73,0x70,0x6f,0x72,0x74,0x7e,0x22,0x20,0x73,0x69,0x7a, /* "~dprsport~" siz */ \
	0x65,0x3d,0x22,0x35,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31, /* e="5" class="ad1 */ \
	0x22,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c, /* "></div>..<div>< */ \
	0x6c,0x61,0x62,0x65,0x6c,0x3e,0x59,0x6f,0x75,0x72,0x20,0x43,0x61,0x6c,0x6c,0x73, /* label>Your Calls */ \
	0x69,0x67,0x6e,0x20,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c, /* ign :</label>..< */ \
	0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74, /* input type="text */ \
	0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x64,0x70,0x63,0x6c,0x22,0x20,0x76,0x61, /* " name="dpcl" va */ \
	0x6c,0x75,0x65,0x3d,0x22,0x7e,0x64,0x70,0x72,0x73,0x63,0x61,0x6c,0x6c,0x7e,0x22, /* lue="~dprscall~" */ \
	0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x37,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d, /*  size="7" class= */ \
	0x22,0x61,0x64,0x31,0x22,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64, /* "ad1"></div>..<d */ \
	0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x44,0x2d,0x53,0x54,0x41,0x52, /* iv><label>D-STAR */ \
	0x20,0x49,0x44,0x20,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c, /*  ID :</label>..< */ \
	0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74, /* input type="text */ \
	0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x64,0x73,0x69,0x64,0x22,0x20,0x76,0x61, /* " name="dsid" va */ \
	0x6c,0x75,0x65,0x3d,0x22,0x7e,0x64,0x73,0x74,0x61,0x72,0x69,0x64,0x7e,0x22,0x20, /* lue="~dstarid~"  */ \
	0x73,0x69,0x7a,0x65,0x3d,0x22,0x31,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22  /* size="1" class=" */
#define DATACHUNK00001b \
	0x61,0x64,0x31,0x22,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69, /* ad1"></div>..<di */ \
	0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x41,0x6c,0x74,0x2e,0x20,0x4d,0x73, /* v><label>Alt. Ms */ \
	0x67,0x2e,0x20,0x53,0x53,0x49,0x44,0x20,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c, /* g. SSID :</label */ \
	0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22, /* >..<input type=" */ \
	0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x61,0x6c,0x69,0x64, /* text" name="alid */ \
	0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x61,0x6c,0x74,0x64,0x73,0x74, /* " value="~altdst */ \
	0x61,0x72,0x69,0x64,0x7e,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x32,0x22,0x20, /* arid~" size="2"  */ \
	0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x3e,0x3c,0x2f,0x64,0x69, /* class="ad1"></di */ \
	0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e, /* v>..<div><label> */ \
	0x56,0x61,0x6c,0x69,0x64,0x61,0x74,0x69,0x6f,0x6e,0x20,0x43,0x6f,0x64,0x65,0x20, /* Validation Code  */ \
	0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75, /* :</label>..<inpu */ \
	0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61, /* t type="text" na */ \
	0x6d,0x65,0x3d,0x22,0x64,0x70,0x63,0x64,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d, /* me="dpcd" value= */ \
	0x22,0x7e,0x64,0x70,0x72,0x73,0x76,0x61,0x6c,0x69,0x64,0x7e,0x22,0x20,0x73,0x69, /* "~dprsvalid~" si */ \
	0x7a,0x65,0x3d,0x22,0x37,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64, /* ze="7" class="ad */ \
	0x31,0x22,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e, /* 1"></div>..<div> */ \
	0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x41,0x63,0x63,0x65,0x70,0x74,0x20,0x66,0x72, /* <label>Accept fr */ \
	0x6f,0x6d,0x20,0x52,0x61,0x64,0x69,0x6f,0x20,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65, /* om Radio :</labe */ \
	0x6c,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63, /* l><input type="c */ \
	0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x64, /* heckbox" name="d */ \
	0x70,0x72,0x64,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x73,0x6d,0x22,0x20, /* prd" class="sm"  */ \
	0x7e,0x64,0x70,0x72,0x73,0x52,0x61,0x64,0x69,0x6f,0x7e,0x20,0x76,0x61,0x6c,0x75, /* ~dprsRadio~ valu */ \
	0x65,0x3d,0x22,0x31,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a, /* e="1" /></div>.. */ \
	0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x41,0x63,0x63,0x65, /* <div><label>Acce */ \
	0x70,0x74,0x20,0x66,0x72,0x6f,0x6d,0x20,0x49,0x6e,0x65,0x74,0x20,0x3a,0x3c,0x2f, /* pt from Inet :</ */ \
	0x6c,0x61,0x62,0x65,0x6c,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70, /* label><input typ */ \
	0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d, /* e="checkbox" nam */ \
	0x65,0x3d,0x22,0x64,0x70,0x69,0x74,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22, /* e="dpit" class=" */ \
	0x73,0x6d,0x22,0x20,0x7e,0x64,0x70,0x72,0x73,0x49,0x6e,0x65,0x74,0x7e,0x20,0x76, /* sm" ~dprsInet~ v */ \
	0x61,0x6c,0x75,0x65,0x3d,0x22,0x31,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76, /* alue="1" /></div */ \
	0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x41, /* >..<div><label>A */ \
	0x75,0x74,0x6f,0x2e,0x20,0x4c,0x69,0x6e,0x6b,0x20,0x20,0x3a,0x3c,0x2f,0x6c,0x61, /* uto. Link  :</la */ \
	0x62,0x65,0x6c,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d, /* bel><input type= */ \
	0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d, /* "checkbox" name= */ \
	0x22,0x64,0x70,0x61,0x74,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x73,0x6d, /* "dpat" class="sm */ \
	0x22,0x20,0x7e,0x64,0x70,0x72,0x73,0x41,0x75,0x74,0x6f,0x4c,0x69,0x6e,0x6b,0x7e, /* " ~dprsAutoLink~ */ \
	0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x31,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64, /*  value="1" /></d */ \
	0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c, /* iv>..<div><label */ \
	0x3e,0x41,0x75,0x74,0x6f,0x2e,0x20,0x52,0x65,0x4c,0x69,0x6e,0x6b,0x20,0x20,0x3a, /* >Auto. ReLink  : */ \
	0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74, /* </label><input t */ \
	0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e, /* ype="checkbox" n */ \
	0x61,0x6d,0x65,0x3d,0x22,0x64,0x70,0x72,0x65,0x22,0x20,0x63,0x6c,0x61,0x73,0x73, /* ame="dpre" class */ \
	0x3d,0x22,0x73,0x6d,0x22,0x20,0x7e,0x64,0x70,0x72,0x73,0x41,0x75,0x74,0x6f,0x52, /* ="sm" ~dprsAutoR */ \
	0x65,0x4c,0x69,0x6e,0x6b,0x7e,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x31,0x22, /* eLink~ value="1" */ \
	0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e, /*  /></div>..<div> */ \
	0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x43,0x6c,0x69,0x65,0x6e,0x74,0x20,0x49,0x6e, /* <label>Client In */ \
	0x66,0x6f,0x72,0x6d,0x61,0x74,0x69,0x6f,0x6e,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c, /* formation</label */ \
	0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x3c,0x62,0x72,0x3e,0x0d,0x0a,0x3c,0x64,0x69, /* ></div><br>..<di */ \
	0x76,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63, /* v><input type="c */ \
	0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x63, /* heckbox" name="c */ \
	0x6c,0x69,0x64,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x73,0x6d,0x22,0x20, /* lid" class="sm"  */ \
	0x7e,0x63,0x6c,0x69,0x65,0x6e,0x74,0x49,0x44,0x7e,0x20,0x76,0x61,0x6c,0x75,0x65, /* ~clientID~ value */ \
	0x3d,0x22,0x31,0x22,0x20,0x2f,0x3e,0x20,0x4c,0x65,0x74,0x20,0x43,0x6c,0x69,0x65, /* ="1" /> Let Clie */ \
	0x6e,0x74,0x20,0x49,0x44,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69, /* nt ID</div>..<di */ \
	0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x4c,0x61,0x74,0x69,0x74,0x75,0x64, /* v><label>Latitud */ \
	0x65,0x20,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e, /* e :</label>..<in */ \
	0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20, /* put type="text"  */ \
	0x6e,0x61,0x6d,0x65,0x3d,0x22,0x70,0x6c,0x61,0x74,0x22,0x20,0x76,0x61,0x6c,0x75, /* name="plat" valu */ \
	0x65,0x3d,0x22,0x7e,0x70,0x6c,0x61,0x74,0x7e,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d, /* e="~plat~" size= */ \
	0x22,0x38,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x3e, /* "8" class="ad1"> */ \
	0x20,0x28,0x64,0x64,0x2e,0x64,0x64,0x64,0x64,0x20,0x53,0x20,0x6e,0x65,0x67,0x61, /*  (dd.dddd S nega */ \
	0x74,0x69,0x76,0x65,0x29,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69, /* tive)</div>..<di */ \
	0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x4c,0x6f,0x6e,0x67,0x69,0x74,0x75, /* v><label>Longitu */ \
	0x64,0x65,0x20,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69  /* de :</label>..<i */
#define DATACHUNK00001c \
	0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22, /* nput type="text" */ \
	0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x70,0x6c,0x6e,0x67,0x22,0x20,0x76,0x61,0x6c, /*  name="plng" val */ \
	0x75,0x65,0x3d,0x22,0x7e,0x70,0x6c,0x6f,0x6e,0x67,0x7e,0x22,0x20,0x73,0x69,0x7a, /* ue="~plong~" siz */ \
	0x65,0x3d,0x22,0x39,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31, /* e="9" class="ad1 */ \
	0x22,0x3e,0x20,0x28,0x64,0x64,0x64,0x2e,0x64,0x64,0x64,0x64,0x20,0x57,0x20,0x4e, /* "> (ddd.dddd W N */ \
	0x65,0x67,0x61,0x74,0x69,0x76,0x65,0x29,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a, /* egative)</div>.. */ \
	0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x43,0x6f,0x6d,0x6d, /* <div><label>Comm */ \
	0x65,0x6e,0x74,0x20,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c, /* ent :</label>..< */ \
	0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74, /* input type="text */ \
	0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x70,0x63,0x6d,0x74,0x22,0x20,0x76,0x61, /* " name="pcmt" va */ \
	0x6c,0x75,0x65,0x3d,0x22,0x7e,0x70,0x63,0x6f,0x6d,0x6d,0x65,0x6e,0x74,0x7e,0x22, /* lue="~pcomment~" */ \
	0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x32,0x35,0x22,0x20,0x63,0x6c,0x61,0x73,0x73, /*  size="25" class */ \
	0x3d,0x22,0x61,0x64,0x31,0x22,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c, /* ="ad1"></div>..< */ \
	0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x49,0x6e,0x74,0x65,0x72, /* div><label>Inter */ \
	0x76,0x61,0x6c,0x20,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c, /* val :</label>..< */ \
	0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74, /* input type="text */ \
	0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x70,0x69,0x6e,0x74,0x22,0x20,0x76,0x61, /* " name="pint" va */ \
	0x6c,0x75,0x65,0x3d,0x22,0x7e,0x70,0x69,0x6e,0x74,0x65,0x72,0x76,0x61,0x6c,0x7e, /* lue="~pinterval~ */ \
	0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x34,0x22,0x20,0x63,0x6c,0x61,0x73,0x73, /* " size="4" class */ \
	0x3d,0x22,0x61,0x64,0x31,0x22,0x3e,0x20,0x6d,0x69,0x6e,0x75,0x74,0x65,0x73,0x3c, /* ="ad1"> minutes< */ \
	0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e, /* /div>......<div> */ \
	0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x53,0x4d,0x54,0x50,0x20,0x49,0x6e,0x66,0x6f, /* <label>SMTP Info */ \
	0x72,0x6d,0x61,0x74,0x69,0x6f,0x6e,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x3c, /* rmation</label>< */ \
	0x2f,0x64,0x69,0x76,0x3e,0x3c,0x62,0x72,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e, /* /div><br>..<div> */ \
	0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x53,0x4d,0x54,0x50,0x20,0x53,0x65,0x72,0x76, /* <label>SMTP Serv */ \
	0x65,0x72,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e, /* er:</label>..<in */ \
	0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20, /* put type="text"  */ \
	0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x73,0x6d,0x74,0x70,0x73,0x65,0x72,0x76, /* value="~smtpserv */ \
	0x65,0x72,0x7e,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x73,0x6d,0x74,0x73,0x22, /* er~" name="smts" */ \
	0x20,0x73,0x74,0x79,0x6c,0x65,0x3d,0x22,0x77,0x69,0x64,0x74,0x68,0x3a,0x31,0x36, /*  style="width:16 */ \
	0x35,0x70,0x78,0x22,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64, /* 5px"/></div>..<d */ \
	0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x50,0x6f,0x72,0x74,0x3a,0x3c, /* iv><label>Port:< */ \
	0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20, /* /label>..<input  */ \
	0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65, /* type="text" name */ \
	0x3d,0x22,0x73,0x6d,0x74,0x70,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e, /* ="smtp" value="~ */ \
	0x73,0x6d,0x74,0x70,0x70,0x6f,0x72,0x74,0x7e,0x22,0x20,0x73,0x74,0x79,0x6c,0x65, /* smtpport~" style */ \
	0x3d,0x22,0x77,0x69,0x64,0x74,0x68,0x3a,0x32,0x35,0x70,0x78,0x3b,0x22,0x2f,0x3e, /* ="width:25px;"/> */ \
	0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c, /* </div>....<div>< */ \
	0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63,0x68,0x65,0x63, /* input type="chec */ \
	0x6b,0x62,0x6f,0x78,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x73,0x6d,0x22, /* kbox" class="sm" */ \
	0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x73,0x6d,0x61,0x68,0x22,0x20,0x76,0x61,0x6c, /*  name="smah" val */ \
	0x75,0x65,0x3d,0x22,0x31,0x22,0x20,0x6f,0x6e,0x63,0x6c,0x69,0x63,0x6b,0x3d,0x22, /* ue="1" onclick=" */ \
	0x73,0x6d,0x74,0x70,0x41,0x75,0x74,0x68,0x28,0x29,0x22,0x20,0x7e,0x73,0x6d,0x74, /* smtpAuth()" ~smt */ \
	0x70,0x5f,0x61,0x75,0x74,0x68,0x7e,0x20,0x2f,0x3e,0x20,0x45,0x6e,0x61,0x62,0x6c, /* p_auth~ /> Enabl */ \
	0x65,0x20,0x41,0x75,0x74,0x68,0x2e,0x20,0x66,0x6f,0x72,0x20,0x53,0x4d,0x54,0x50, /* e Auth. for SMTP */ \
	0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61, /* </div>..<div><la */ \
	0x62,0x65,0x6c,0x3e,0x55,0x73,0x65,0x72,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c, /* bel>User:</label */ \
	0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22, /* >..<input type=" */ \
	0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x73,0x6d,0x75,0x73, /* text" name="smus */ \
	0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x73,0x6d,0x74,0x70,0x75,0x73, /* " value="~smtpus */ \
	0x65,0x72,0x7e,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x32,0x30,0x22,0x20,0x63, /* er~" size="20" c */ \
	0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64, /* lass="ad1" /></d */ \
	0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c, /* iv>..<div><label */ \
	0x3e,0x50,0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65, /* >Password:</labe */ \
	0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d, /* l>..<input type= */ \
	0x22,0x70,0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d, /* "password" name= */ \
	0x22,0x73,0x6d,0x70,0x73,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x73, /* "smps" value="~s */ \
	0x6d,0x74,0x70,0x70,0x61,0x73,0x73,0x7e,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22, /* mtppass~" size=" */ \
	0x32,0x30,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x20, /* 20" class="ad1"  */ \
	0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x26, /* /></div>..<div>& */ \
	0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c, /* nbsp;</div>....< */ \
	0x64,0x69,0x76,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d, /* div><input type= */ \
	0x22,0x73,0x75,0x62,0x6d,0x69,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x20,0x3d,0x22, /* "submit" name =" */ \
	0x73,0x75,0x62,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x73,0x6d,0x22,0x20  /* sub" class="sm"  */
#define DATACHUNK00001d \
	0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x53,0x61,0x76,0x65,0x22,0x20,0x2f,0x3e,0x3c, /* value="Save" />< */ \
	0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x69,0x65,0x6c,0x64,0x73,0x65, /* /div>..</fieldse */ \
	0x74,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x2f,0x66,0x6f,0x72,0x6d,0x3e,0x0d,0x0a,0x3c, /* t>....</form>..< */ \
	0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74, /* /div>....<script */ \
	0x20,0x6c,0x61,0x6e,0x67,0x75,0x61,0x67,0x65,0x3d,0x22,0x6a,0x61,0x76,0x61,0x73, /*  language="javas */ \
	0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x0d,0x0a,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f, /* cript">..functio */ \
	0x6e,0x20,0x63,0x6f,0x6e,0x66,0x69,0x67,0x44,0x50,0x52,0x53,0x42,0x6f,0x78,0x65, /* n configDPRSBoxe */ \
	0x73,0x28,0x29,0x20,0x7b,0x0d,0x0a,0x09,0x65,0x20,0x3d,0x20,0x64,0x6f,0x63,0x75, /* s() {...e = docu */ \
	0x6d,0x65,0x6e,0x74,0x2e,0x66,0x6f,0x72,0x6d,0x73,0x2e,0x64,0x70,0x72,0x73,0x3b, /* ment.forms.dprs; */ \
	0x0d,0x0a,0x09,0x69,0x66,0x20,0x28,0x21,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74, /* ...if (!document */ \
	0x2e,0x66,0x6f,0x72,0x6d,0x73,0x2e,0x64,0x70,0x72,0x73,0x2e,0x64,0x70,0x73,0x77, /* .forms.dprs.dpsw */ \
	0x2e,0x63,0x68,0x65,0x63,0x6b,0x65,0x64,0x29,0x0d,0x0a,0x09,0x7b,0x0d,0x0a,0x09, /* .checked)...{... */ \
	0x20,0x20,0x65,0x2e,0x64,0x70,0x69,0x70,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65, /*   e.dpip.disable */ \
	0x64,0x20,0x3d,0x20,0x74,0x72,0x75,0x65,0x3b,0x0d,0x0a,0x09,0x20,0x20,0x65,0x2e, /* d = true;...  e. */ \
	0x64,0x70,0x70,0x74,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20, /* dppt.disabled =  */ \
	0x74,0x72,0x75,0x65,0x3b,0x0d,0x0a,0x09,0x20,0x20,0x65,0x2e,0x64,0x70,0x63,0x6c, /* true;...  e.dpcl */ \
	0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x74,0x72,0x75,0x65, /* .disabled = true */ \
	0x3b,0x0d,0x0a,0x09,0x20,0x20,0x65,0x2e,0x64,0x73,0x69,0x64,0x2e,0x64,0x69,0x73, /* ;...  e.dsid.dis */ \
	0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x74,0x72,0x75,0x65,0x3b,0x0d,0x0a,0x09, /* abled = true;... */ \
	0x20,0x20,0x65,0x2e,0x64,0x70,0x63,0x64,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65, /*   e.dpcd.disable */ \
	0x64,0x20,0x3d,0x20,0x74,0x72,0x75,0x65,0x3b,0x0d,0x0a,0x09,0x7d,0x0d,0x0a,0x09, /* d = true;...}... */ \
	0x65,0x6c,0x73,0x65,0x0d,0x0a,0x09,0x7b,0x0d,0x0a,0x09,0x20,0x20,0x65,0x2e,0x64, /* else...{...  e.d */ \
	0x70,0x69,0x70,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x66, /* pip.disabled = f */ \
	0x61,0x6c,0x73,0x65,0x3b,0x0d,0x0a,0x09,0x20,0x20,0x65,0x2e,0x64,0x70,0x70,0x74, /* alse;...  e.dppt */ \
	0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x66,0x61,0x6c,0x73, /* .disabled = fals */ \
	0x65,0x3b,0x0d,0x0a,0x09,0x20,0x20,0x65,0x2e,0x64,0x70,0x63,0x6c,0x2e,0x64,0x69, /* e;...  e.dpcl.di */ \
	0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x66,0x61,0x6c,0x73,0x65,0x3b,0x0d, /* sabled = false;. */ \
	0x0a,0x09,0x20,0x20,0x65,0x2e,0x64,0x73,0x69,0x64,0x2e,0x64,0x69,0x73,0x61,0x62, /* ..  e.dsid.disab */ \
	0x6c,0x65,0x64,0x20,0x3d,0x20,0x66,0x61,0x6c,0x73,0x65,0x3b,0x0d,0x0a,0x09,0x20, /* led = false;...  */ \
	0x20,0x65,0x2e,0x64,0x70,0x63,0x64,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64, /*  e.dpcd.disabled */ \
	0x20,0x3d,0x20,0x66,0x61,0x6c,0x73,0x65,0x3b,0x0d,0x0a,0x09,0x7d,0x0d,0x0a,0x7d, /*  = false;...}..} */ \
	0x0d,0x0a,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x20,0x73,0x6d,0x74,0x70,0x41, /* ..function smtpA */ \
	0x75,0x74,0x68,0x28,0x29,0x20,0x7b,0x0d,0x0a,0x09,0x65,0x20,0x3d,0x20,0x64,0x6f, /* uth() {...e = do */ \
	0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x66,0x6f,0x72,0x6d,0x73,0x2e,0x64,0x70,0x72, /* cument.forms.dpr */ \
	0x73,0x3b,0x0d,0x0a,0x09,0x69,0x66,0x20,0x28,0x21,0x64,0x6f,0x63,0x75,0x6d,0x65, /* s;...if (!docume */ \
	0x6e,0x74,0x2e,0x66,0x6f,0x72,0x6d,0x73,0x2e,0x64,0x70,0x72,0x73,0x2e,0x73,0x6d, /* nt.forms.dprs.sm */ \
	0x61,0x68,0x2e,0x63,0x68,0x65,0x63,0x6b,0x65,0x64,0x29,0x0d,0x0a,0x09,0x7b,0x0d, /* ah.checked)...{. */ \
	0x0a,0x09,0x20,0x20,0x65,0x2e,0x73,0x6d,0x75,0x73,0x2e,0x64,0x69,0x73,0x61,0x62, /* ..  e.smus.disab */ \
	0x6c,0x65,0x64,0x20,0x3d,0x20,0x74,0x72,0x75,0x65,0x3b,0x0d,0x0a,0x09,0x20,0x20, /* led = true;...   */ \
	0x65,0x2e,0x73,0x6d,0x70,0x73,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20, /* e.smps.disabled  */ \
	0x3d,0x20,0x74,0x72,0x75,0x65,0x3b,0x0d,0x0a,0x09,0x7d,0x0d,0x0a,0x09,0x65,0x6c, /* = true;...}...el */ \
	0x73,0x65,0x0d,0x0a,0x09,0x7b,0x0d,0x0a,0x09,0x20,0x20,0x65,0x2e,0x73,0x6d,0x75, /* se...{...  e.smu */ \
	0x73,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x66,0x61,0x6c, /* s.disabled = fal */ \
	0x73,0x65,0x3b,0x0d,0x0a,0x09,0x20,0x20,0x65,0x2e,0x73,0x6d,0x70,0x73,0x2e,0x64, /* se;...  e.smps.d */ \
	0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x66,0x61,0x6c,0x73,0x65,0x3b, /* isabled = false; */ \
	0x0d,0x0a,0x09,0x7d,0x0d,0x0a,0x7d,0x0d,0x0a,0x0d,0x0a,0x63,0x6f,0x6e,0x66,0x69, /* ...}..}....confi */ \
	0x67,0x44,0x50,0x52,0x53,0x42,0x6f,0x78,0x65,0x73,0x28,0x29,0x3b,0x0d,0x0a,0x73, /* gDPRSBoxes();..s */ \
	0x6d,0x74,0x70,0x41,0x75,0x74,0x68,0x28,0x29,0x3b,0x0d,0x0a,0x2f,0x2f,0x2d,0x2d, /* mtpAuth();..//-- */ \
	0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74,0x3e,0x0d,0x0a,0x7e,0x69, /* >..</script>..~i */ \
	0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x00,0x00, /* nc:footer.inc~.. */ \
	0x00,0x00,0x33,0x00,0x00,0x00,0xe9,0x00,0x00,0x00,0xb1,0x00,0x00,0x00,0x5a,0x01, /* ..3...........Z. */ \
	0x00,0x00,0xac,0x00,0x00,0x00,0xd0,0x01,0x00,0x00,0xad,0x00,0x00,0x00,0x44,0x02, /* ..............D. */ \
	0x00,0x00,0xae,0x00,0x00,0x00,0xb4,0x02,0x00,0x00,0xaf,0x00,0x00,0x00,0x28,0x03, /* ..............(. */ \
	0x00,0x00,0xca,0x00,0x00,0x00,0xa0,0x03,0x00,0x00,0xb0,0x00,0x00,0x00,0x1f,0x04, /* ................ */ \
	0x00,0x00,0xb2,0x00,0x00,0x00,0x93,0x04,0x00,0x00,0xb3,0x00,0x00,0x00,0x01,0x05, /* ................ */ \
	0x00,0x00,0xba,0x00,0x00,0x00,0x75,0x05,0x00,0x00,0xcf,0x00,0x00,0x00,0xff,0x05, /* ......u......... */ \
	0x00,0x00,0xbb,0x00,0x00,0x00,0x72,0x06,0x00,0x00,0xb5,0x00,0x00,0x00,0xf3,0x06, /* ......r......... */ \
	0x00,0x00,0xb6,0x00,0x00,0x00,0x74,0x07,0x00,0x00,0xb7,0x00,0x00,0x00,0xe4,0x07, /* ......t......... */ \
	0x00,0x00,0xc5,0x00,0x00,0x00,0x86,0x08,0x00,0x00,0xbc,0x00,0x00,0x00,0xfe,0x08, /* ................ */ \
	0x00,0x00,0xbd,0x00,0x00,0x00,0x7b,0x09,0x00,0x00,0xbe,0x00,0x00,0x00,0xe8,0x09, /* ......{......... */ \
	0x00,0x00,0xbf,0x00,0x00,0x00,0x5d,0x0a,0x00,0x00,0xc0,0x00,0x00,0x00,0xdd,0x0d, /* ......]......... */ \
	0x00,0x00,0x02,0x00,0x00,0x00,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65, /* ......~inc:heade */ \
	0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d, /* r.inc~..<div id= */ \
	0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x3c,0x68,0x31,0x3e  /* "content">..<h1> */
#define DATACHUNK00001e \
	0x45,0x64,0x69,0x74,0x20,0x74,0x68,0x65,0x20,0x41,0x50,0x52,0x53,0x20,0x4d,0x73, /* Edit the APRS Ms */ \
	0x67,0x2e,0x20,0x43,0x6f,0x6e,0x74,0x72,0x6f,0x6c,0x20,0x46,0x69,0x6c,0x65,0x3c, /* g. Control File< */ \
	0x2f,0x68,0x31,0x3e,0x0d,0x0a,0x3c,0x66,0x6f,0x72,0x6d,0x20,0x6e,0x61,0x6d,0x65, /* /h1>..<form name */ \
	0x3d,0x22,0x44,0x70,0x72,0x73,0x45,0x64,0x69,0x74,0x22,0x20,0x6d,0x65,0x74,0x68, /* ="DprsEdit" meth */ \
	0x6f,0x64,0x3d,0x22,0x70,0x6f,0x73,0x74,0x22,0x20,0x61,0x63,0x74,0x69,0x6f,0x6e, /* od="post" action */ \
	0x3d,0x22,0x2f,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x64,0x70,0x72,0x73,0x65, /* ="/protect/dprse */ \
	0x64,0x69,0x74,0x2e,0x68,0x74,0x6d,0x22,0x20,0x65,0x6e,0x63,0x74,0x79,0x70,0x65, /* dit.htm" enctype */ \
	0x3d,0x22,0x6d,0x75,0x6c,0x74,0x69,0x70,0x61,0x72,0x74,0x2f,0x66,0x6f,0x72,0x6d, /* ="multipart/form */ \
	0x2d,0x64,0x61,0x74,0x61,0x22,0x3e,0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74, /* -data">..<script */ \
	0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x2f,0x6a,0x61,0x76,0x61, /*  type="text/java */ \
	0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x20,0x6c,0x61,0x6e,0x67,0x75,0x61,0x67,0x65, /* script" language */ \
	0x3d,0x22,0x4a,0x61,0x76,0x61,0x53,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x0d,0x0a, /* ="JavaScript">.. */ \
	0x3c,0x21,0x2d,0x2d,0x0d,0x0a,0x0d,0x0a,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e, /* <!--....function */ \
	0x20,0x64,0x65,0x6c,0x28,0x61,0x29,0x0d,0x0a,0x7b,0x0d,0x0a,0x20,0x20,0x77,0x69, /*  del(a)..{..  wi */ \
	0x6e,0x64,0x6f,0x77,0x2e,0x6f,0x70,0x65,0x6e,0x65,0x72,0x2e,0x63,0x61,0x6c,0x6c, /* ndow.opener.call */ \
	0x73,0x69,0x67,0x6e,0x2e,0x73,0x70,0x6c,0x69,0x63,0x65,0x20,0x28,0x61,0x2c,0x31, /* sign.splice (a,1 */ \
	0x29,0x3b,0x0d,0x0a,0x20,0x20,0x77,0x69,0x6e,0x64,0x6f,0x77,0x2e,0x6f,0x70,0x65, /* );..  window.ope */ \
	0x6e,0x65,0x72,0x2e,0x61,0x63,0x63,0x65,0x73,0x73,0x2e,0x73,0x70,0x6c,0x69,0x63, /* ner.access.splic */ \
	0x65,0x28,0x61,0x2c,0x31,0x29,0x3b,0x0d,0x0a,0x20,0x20,0x77,0x69,0x6e,0x64,0x6f, /* e(a,1);..  windo */ \
	0x77,0x2e,0x6f,0x70,0x65,0x6e,0x65,0x72,0x2e,0x65,0x6d,0x61,0x69,0x6c,0x2e,0x73, /* w.opener.email.s */ \
	0x70,0x6c,0x69,0x63,0x65,0x28,0x61,0x2c,0x31,0x29,0x3b,0x0d,0x0a,0x20,0x20,0x6e, /* plice(a,1);..  n */ \
	0x20,0x3d,0x20,0x77,0x69,0x6e,0x64,0x6f,0x77,0x2e,0x6f,0x70,0x65,0x6e,0x65,0x72, /*  = window.opener */ \
	0x2e,0x63,0x61,0x6c,0x6c,0x73,0x69,0x67,0x6e,0x2e,0x6c,0x65,0x6e,0x67,0x74,0x68, /* .callsign.length */ \
	0x3b,0x0d,0x0a,0x20,0x20,0x6c,0x6f,0x63,0x61,0x74,0x69,0x6f,0x6e,0x2e,0x72,0x65, /* ;..  location.re */ \
	0x6c,0x6f,0x61,0x64,0x28,0x29,0x3b,0x0d,0x0a,0x7d,0x0d,0x0a,0x0d,0x0a,0x66,0x75, /* load();..}....fu */ \
	0x6e,0x63,0x74,0x69,0x6f,0x6e,0x20,0x63,0x61,0x6e,0x63,0x65,0x6c,0x28,0x29,0x0d, /* nction cancel(). */ \
	0x0a,0x7b,0x0d,0x0a,0x20,0x20,0x6e,0x20,0x3d,0x20,0x77,0x69,0x6e,0x64,0x6f,0x77, /* .{..  n = window */ \
	0x2e,0x6f,0x70,0x65,0x6e,0x65,0x72,0x2e,0x63,0x61,0x6c,0x6c,0x73,0x69,0x67,0x6e, /* .opener.callsign */ \
	0x2e,0x6c,0x65,0x6e,0x67,0x74,0x68,0x3b,0x0d,0x0a,0x20,0x20,0x6c,0x6f,0x63,0x61, /* .length;..  loca */ \
	0x74,0x69,0x6f,0x6e,0x2e,0x72,0x65,0x6c,0x6f,0x61,0x64,0x28,0x29,0x3b,0x0d,0x0a, /* tion.reload();.. */ \
	0x7d,0x0d,0x0a,0x0d,0x0a,0x0d,0x0a,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x20, /* }......function  */ \
	0x69,0x6e,0x73,0x65,0x72,0x74,0x28,0x29,0x0d,0x0a,0x7b,0x0d,0x0a,0x20,0x20,0x69, /* insert()..{..  i */ \
	0x66,0x20,0x28,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x44,0x70,0x72,0x73, /* f (document.Dprs */ \
	0x45,0x64,0x69,0x74,0x2e,0x63,0x61,0x6c,0x6c,0x73,0x2e,0x76,0x61,0x6c,0x75,0x65, /* Edit.calls.value */ \
	0x2e,0x6c,0x65,0x6e,0x67,0x74,0x68,0x20,0x21,0x3d,0x20,0x30,0x29,0x0d,0x0a,0x20, /* .length != 0)..  */ \
	0x20,0x7b,0x0d,0x0a,0x20,0x20,0x20,0x20,0x69,0x66,0x20,0x28,0x64,0x6f,0x63,0x75, /*  {..    if (docu */ \
	0x6d,0x65,0x6e,0x74,0x2e,0x44,0x70,0x72,0x73,0x45,0x64,0x69,0x74,0x2e,0x63,0x61, /* ment.DprsEdit.ca */ \
	0x6c,0x6c,0x73,0x2e,0x76,0x61,0x6c,0x75,0x65,0x2e,0x63,0x68,0x61,0x72,0x41,0x74, /* lls.value.charAt */ \
	0x28,0x30,0x29,0x20,0x3d,0x3d,0x20,0x27,0x2a,0x27,0x29,0x0d,0x0a,0x20,0x20,0x20, /* (0) == '.')..    */ \
	0x20,0x7b,0x0d,0x0a,0x09,0x77,0x69,0x6e,0x64,0x6f,0x77,0x2e,0x61,0x6c,0x65,0x72, /*  {...window.aler */ \
	0x74,0x20,0x28,0x22,0x44,0x6f,0x20,0x6e,0x6f,0x74,0x20,0x75,0x73,0x65,0x20,0x27, /* t ("Do not use ' */ \
	0x2a,0x27,0x20,0x28,0x61,0x6c,0x6c,0x20,0x43,0x61,0x6c,0x6c,0x73,0x69,0x67,0x6e, /* .' (all Callsign */ \
	0x20,0x61,0x63,0x63,0x65,0x70,0x74,0x29,0x21,0x22,0x29,0x3b,0x0d,0x0a,0x09,0x72, /*  accept)!");...r */ \
	0x65,0x74,0x75,0x72,0x6e,0x3b,0x0d,0x0a,0x20,0x20,0x20,0x20,0x7d,0x0d,0x0a,0x20, /* eturn;..    }..  */ \
	0x20,0x7d,0x0d,0x0a,0x20,0x20,0x69,0x66,0x20,0x28,0x64,0x6f,0x63,0x75,0x6d,0x65, /*  }..  if (docume */ \
	0x6e,0x74,0x2e,0x44,0x70,0x72,0x73,0x45,0x64,0x69,0x74,0x2e,0x70,0x6f,0x73,0x69, /* nt.DprsEdit.posi */ \
	0x74,0x69,0x6f,0x6e,0x2e,0x76,0x61,0x6c,0x75,0x65,0x20,0x3d,0x3d,0x20,0x2d,0x31, /* tion.value == -1 */ \
	0x29,0x0d,0x0a,0x20,0x20,0x7b,0x09,0x0d,0x0a,0x20,0x20,0x20,0x20,0x20,0x77,0x69, /* )..  {...     wi */ \
	0x6e,0x64,0x6f,0x77,0x2e,0x6f,0x70,0x65,0x6e,0x65,0x72,0x2e,0x63,0x61,0x6c,0x6c, /* ndow.opener.call */ \
	0x73,0x69,0x67,0x6e,0x2e,0x70,0x75,0x73,0x68,0x28,0x64,0x6f,0x63,0x75,0x6d,0x65, /* sign.push(docume */ \
	0x6e,0x74,0x2e,0x44,0x70,0x72,0x73,0x45,0x64,0x69,0x74,0x2e,0x63,0x61,0x6c,0x6c, /* nt.DprsEdit.call */ \
	0x73,0x2e,0x76,0x61,0x6c,0x75,0x65,0x29,0x3b,0x0d,0x0a,0x20,0x20,0x20,0x20,0x20, /* s.value);..      */ \
	0x77,0x69,0x6e,0x64,0x6f,0x77,0x2e,0x6f,0x70,0x65,0x6e,0x65,0x72,0x2e,0x61,0x63, /* window.opener.ac */ \
	0x63,0x65,0x73,0x73,0x2e,0x70,0x75,0x73,0x68,0x28,0x64,0x6f,0x63,0x75,0x6d,0x65, /* cess.push(docume */ \
	0x6e,0x74,0x2e,0x44,0x70,0x72,0x73,0x45,0x64,0x69,0x74,0x2e,0x61,0x63,0x63,0x65, /* nt.DprsEdit.acce */ \
	0x73,0x2e,0x76,0x61,0x6c,0x75,0x65,0x29,0x3b,0x0d,0x0a,0x20,0x20,0x20,0x20,0x20, /* s.value);..      */ \
	0x77,0x69,0x6e,0x64,0x6f,0x77,0x2e,0x6f,0x70,0x65,0x6e,0x65,0x72,0x2e,0x65,0x6d, /* window.opener.em */ \
	0x61,0x69,0x6c,0x2e,0x70,0x75,0x73,0x68,0x28,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e, /* ail.push(documen */ \
	0x74,0x2e,0x44,0x70,0x72,0x73,0x45,0x64,0x69,0x74,0x2e,0x6d,0x61,0x69,0x6c,0x73, /* t.DprsEdit.mails */ \
	0x2e,0x76,0x61,0x6c,0x75,0x65,0x29,0x3b,0x0d,0x0a,0x20,0x20,0x7d,0x0d,0x0a,0x20, /* .value);..  }..  */ \
	0x20,0x65,0x6c,0x73,0x65,0x0d,0x0a,0x20,0x20,0x7b,0x0d,0x0a,0x20,0x20,0x20,0x20, /*  else..  {..     */ \
	0x20,0x77,0x69,0x6e,0x64,0x6f,0x77,0x2e,0x6f,0x70,0x65,0x6e,0x65,0x72,0x2e,0x63, /*  window.opener.c */ \
	0x61,0x6c,0x6c,0x73,0x69,0x67,0x6e,0x2e,0x73,0x70,0x6c,0x69,0x63,0x65,0x20,0x28, /* allsign.splice ( */ \
	0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x44,0x70,0x72,0x73,0x45,0x64,0x69  /* document.DprsEdi */
#define DATACHUNK00001f \
	0x74,0x2e,0x70,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x2e,0x76,0x61,0x6c,0x75,0x65, /* t.position.value */ \
	0x2c,0x30,0x2c,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x44,0x70,0x72,0x73, /* ,0,document.Dprs */ \
	0x45,0x64,0x69,0x74,0x2e,0x63,0x61,0x6c,0x6c,0x73,0x2e,0x76,0x61,0x6c,0x75,0x65, /* Edit.calls.value */ \
	0x29,0x3b,0x0d,0x0a,0x20,0x20,0x20,0x20,0x20,0x77,0x69,0x6e,0x64,0x6f,0x77,0x2e, /* );..     window. */ \
	0x6f,0x70,0x65,0x6e,0x65,0x72,0x2e,0x61,0x63,0x63,0x65,0x73,0x73,0x2e,0x73,0x70, /* opener.access.sp */ \
	0x6c,0x69,0x63,0x65,0x28,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x44,0x70, /* lice(document.Dp */ \
	0x72,0x73,0x45,0x64,0x69,0x74,0x2e,0x70,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x2e, /* rsEdit.position. */ \
	0x76,0x61,0x6c,0x75,0x65,0x2c,0x30,0x2c,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74, /* value,0,document */ \
	0x2e,0x44,0x70,0x72,0x73,0x45,0x64,0x69,0x74,0x2e,0x61,0x63,0x63,0x65,0x73,0x2e, /* .DprsEdit.acces. */ \
	0x76,0x61,0x6c,0x75,0x65,0x29,0x3b,0x0d,0x0a,0x20,0x20,0x20,0x20,0x20,0x77,0x69, /* value);..     wi */ \
	0x6e,0x64,0x6f,0x77,0x2e,0x6f,0x70,0x65,0x6e,0x65,0x72,0x2e,0x65,0x6d,0x61,0x69, /* ndow.opener.emai */ \
	0x6c,0x2e,0x73,0x70,0x6c,0x69,0x63,0x65,0x28,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e, /* l.splice(documen */ \
	0x74,0x2e,0x44,0x70,0x72,0x73,0x45,0x64,0x69,0x74,0x2e,0x70,0x6f,0x73,0x69,0x74, /* t.DprsEdit.posit */ \
	0x69,0x6f,0x6e,0x2e,0x76,0x61,0x6c,0x75,0x65,0x2c,0x30,0x2c,0x64,0x6f,0x63,0x75, /* ion.value,0,docu */ \
	0x6d,0x65,0x6e,0x74,0x2e,0x44,0x70,0x72,0x73,0x45,0x64,0x69,0x74,0x2e,0x6d,0x61, /* ment.DprsEdit.ma */ \
	0x69,0x6c,0x73,0x2e,0x76,0x61,0x6c,0x75,0x65,0x29,0x3b,0x0d,0x0a,0x20,0x20,0x7d, /* ils.value);..  } */ \
	0x0d,0x0a,0x20,0x20,0x6e,0x20,0x3d,0x20,0x77,0x69,0x6e,0x64,0x6f,0x77,0x2e,0x6f, /* ..  n = window.o */ \
	0x70,0x65,0x6e,0x65,0x72,0x2e,0x63,0x61,0x6c,0x6c,0x73,0x69,0x67,0x6e,0x2e,0x6c, /* pener.callsign.l */ \
	0x65,0x6e,0x67,0x74,0x68,0x3b,0x0d,0x0a,0x20,0x20,0x6c,0x6f,0x63,0x61,0x74,0x69, /* ength;..  locati */ \
	0x6f,0x6e,0x2e,0x72,0x65,0x6c,0x6f,0x61,0x64,0x28,0x29,0x3b,0x0d,0x0a,0x7d,0x0d, /* on.reload();..}. */ \
	0x0a,0x0d,0x0a,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x20,0x61,0x64,0x64,0x28, /* ...function add( */ \
	0x29,0x0d,0x0a,0x7b,0x0d,0x0a,0x20,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74, /* )..{..  document */ \
	0x2e,0x44,0x70,0x72,0x73,0x45,0x64,0x69,0x74,0x2e,0x70,0x6f,0x73,0x69,0x74,0x69, /* .DprsEdit.positi */ \
	0x6f,0x6e,0x2e,0x76,0x61,0x6c,0x75,0x65,0x20,0x3d,0x20,0x2d,0x31,0x3b,0x0d,0x0a, /* on.value = -1;.. */ \
	0x20,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x67,0x65,0x74,0x45,0x6c, /*   document.getEl */ \
	0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28,0x27,0x41,0x44,0x44,0x27,0x29, /* ementById('ADD') */ \
	0x2e,0x73,0x74,0x79,0x6c,0x65,0x2e,0x64,0x69,0x73,0x70,0x6c,0x61,0x79,0x20,0x3d, /* .style.display = */ \
	0x20,0x27,0x62,0x6c,0x6f,0x63,0x6b,0x27,0x3b,0x0d,0x0a,0x20,0x20,0x64,0x6f,0x63, /*  'block';..  doc */ \
	0x75,0x6d,0x65,0x6e,0x74,0x2e,0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74, /* ument.getElement */ \
	0x42,0x79,0x49,0x64,0x28,0x27,0x45,0x44,0x49,0x54,0x27,0x29,0x2e,0x73,0x74,0x79, /* ById('EDIT').sty */ \
	0x6c,0x65,0x2e,0x64,0x69,0x73,0x70,0x6c,0x61,0x79,0x20,0x3d,0x20,0x27,0x6e,0x6f, /* le.display = 'no */ \
	0x6e,0x65,0x27,0x3b,0x0d,0x0a,0x7d,0x0d,0x0a,0x0d,0x0a,0x66,0x75,0x6e,0x63,0x74, /* ne';..}....funct */ \
	0x69,0x6f,0x6e,0x20,0x65,0x64,0x74,0x28,0x61,0x29,0x0d,0x0a,0x7b,0x0d,0x0a,0x20, /* ion edt(a)..{..  */ \
	0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x44,0x70,0x72,0x73,0x45,0x64, /*  document.DprsEd */ \
	0x69,0x74,0x2e,0x63,0x61,0x6c,0x6c,0x65,0x2e,0x76,0x61,0x6c,0x75,0x65,0x20,0x3d, /* it.calle.value = */ \
	0x20,0x77,0x69,0x6e,0x64,0x6f,0x77,0x2e,0x6f,0x70,0x65,0x6e,0x65,0x72,0x2e,0x63, /*  window.opener.c */ \
	0x61,0x6c,0x6c,0x73,0x69,0x67,0x6e,0x5b,0x61,0x5d,0x3b,0x0d,0x0a,0x20,0x20,0x64, /* allsign[a];..  d */ \
	0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x44,0x70,0x72,0x73,0x45,0x64,0x69,0x74, /* ocument.DprsEdit */ \
	0x2e,0x6d,0x61,0x69,0x6c,0x65,0x2e,0x76,0x61,0x6c,0x75,0x65,0x20,0x3d,0x20,0x77, /* .maile.value = w */ \
	0x69,0x6e,0x64,0x6f,0x77,0x2e,0x6f,0x70,0x65,0x6e,0x65,0x72,0x2e,0x65,0x6d,0x61, /* indow.opener.ema */ \
	0x69,0x6c,0x5b,0x61,0x5d,0x3b,0x0d,0x0a,0x20,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65, /* il[a];..  docume */ \
	0x6e,0x74,0x2e,0x44,0x70,0x72,0x73,0x45,0x64,0x69,0x74,0x2e,0x70,0x6f,0x73,0x69, /* nt.DprsEdit.posi */ \
	0x74,0x69,0x6f,0x6e,0x2e,0x76,0x61,0x6c,0x75,0x65,0x20,0x3d,0x20,0x61,0x3b,0x0d, /* tion.value = a;. */ \
	0x0a,0x20,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x67,0x65,0x74,0x45, /* .  document.getE */ \
	0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28,0x27,0x45,0x44,0x49,0x54, /* lementById('EDIT */ \
	0x27,0x29,0x2e,0x73,0x74,0x79,0x6c,0x65,0x2e,0x64,0x69,0x73,0x70,0x6c,0x61,0x79, /* ').style.display */ \
	0x20,0x3d,0x20,0x27,0x62,0x6c,0x6f,0x63,0x6b,0x27,0x3b,0x0d,0x0a,0x20,0x20,0x64, /*  = 'block';..  d */ \
	0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65, /* ocument.getEleme */ \
	0x6e,0x74,0x42,0x79,0x49,0x64,0x28,0x27,0x41,0x44,0x44,0x27,0x29,0x2e,0x73,0x74, /* ntById('ADD').st */ \
	0x79,0x6c,0x65,0x2e,0x64,0x69,0x73,0x70,0x6c,0x61,0x79,0x20,0x3d,0x20,0x27,0x6e, /* yle.display = 'n */ \
	0x6f,0x6e,0x65,0x27,0x3b,0x0d,0x0a,0x7d,0x0d,0x0a,0x0d,0x0a,0x0d,0x0a,0x66,0x75, /* one';..}......fu */ \
	0x6e,0x63,0x74,0x69,0x6f,0x6e,0x20,0x69,0x6e,0x73,0x28,0x61,0x29,0x0d,0x0a,0x7b, /* nction ins(a)..{ */ \
	0x0d,0x0a,0x20,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x44,0x70,0x72, /* ..  document.Dpr */ \
	0x73,0x45,0x64,0x69,0x74,0x2e,0x70,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x2e,0x76, /* sEdit.position.v */ \
	0x61,0x6c,0x75,0x65,0x20,0x3d,0x20,0x61,0x3b,0x0d,0x0a,0x20,0x20,0x64,0x6f,0x63, /* alue = a;..  doc */ \
	0x75,0x6d,0x65,0x6e,0x74,0x2e,0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74, /* ument.getElement */ \
	0x42,0x79,0x49,0x64,0x28,0x27,0x41,0x44,0x44,0x27,0x29,0x2e,0x73,0x74,0x79,0x6c, /* ById('ADD').styl */ \
	0x65,0x2e,0x64,0x69,0x73,0x70,0x6c,0x61,0x79,0x20,0x3d,0x20,0x27,0x62,0x6c,0x6f, /* e.display = 'blo */ \
	0x63,0x6b,0x27,0x3b,0x0d,0x0a,0x20,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74, /* ck';..  document */ \
	0x2e,0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28, /* .getElementById( */ \
	0x27,0x45,0x44,0x49,0x54,0x27,0x29,0x2e,0x73,0x74,0x79,0x6c,0x65,0x2e,0x64,0x69, /* 'EDIT').style.di */ \
	0x73,0x70,0x6c,0x61,0x79,0x20,0x3d,0x20,0x27,0x6e,0x6f,0x6e,0x65,0x27,0x3b,0x0d, /* splay = 'none';. */ \
	0x0a,0x7d,0x0d,0x0a,0x0d,0x0a,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x20,0x72, /* .}....function r */ \
	0x65,0x70,0x28,0x29,0x0d,0x0a,0x7b,0x0d,0x0a,0x20,0x20,0x77,0x69,0x6e,0x64,0x6f  /* ep()..{..  windo */
#define DATACHUNK000020 \
	0x77,0x2e,0x6f,0x70,0x65,0x6e,0x65,0x72,0x2e,0x63,0x61,0x6c,0x6c,0x73,0x69,0x67, /* w.opener.callsig */ \
	0x6e,0x2e,0x73,0x70,0x6c,0x69,0x63,0x65,0x28,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e, /* n.splice(documen */ \
	0x74,0x2e,0x44,0x70,0x72,0x73,0x45,0x64,0x69,0x74,0x2e,0x70,0x6f,0x73,0x69,0x74, /* t.DprsEdit.posit */ \
	0x69,0x6f,0x6e,0x2e,0x76,0x61,0x6c,0x75,0x65,0x2c,0x31,0x2c,0x64,0x6f,0x63,0x75, /* ion.value,1,docu */ \
	0x6d,0x65,0x6e,0x74,0x2e,0x44,0x70,0x72,0x73,0x45,0x64,0x69,0x74,0x2e,0x63,0x61, /* ment.DprsEdit.ca */ \
	0x6c,0x6c,0x65,0x2e,0x76,0x61,0x6c,0x75,0x65,0x29,0x3b,0x0d,0x0a,0x20,0x20,0x77, /* lle.value);..  w */ \
	0x69,0x6e,0x64,0x6f,0x77,0x2e,0x6f,0x70,0x65,0x6e,0x65,0x72,0x2e,0x61,0x63,0x63, /* indow.opener.acc */ \
	0x65,0x73,0x73,0x2e,0x73,0x70,0x6c,0x69,0x63,0x65,0x28,0x64,0x6f,0x63,0x75,0x6d, /* ess.splice(docum */ \
	0x65,0x6e,0x74,0x2e,0x44,0x70,0x72,0x73,0x45,0x64,0x69,0x74,0x2e,0x70,0x6f,0x73, /* ent.DprsEdit.pos */ \
	0x69,0x74,0x69,0x6f,0x6e,0x2e,0x76,0x61,0x6c,0x75,0x65,0x2c,0x31,0x2c,0x64,0x6f, /* ition.value,1,do */ \
	0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x44,0x70,0x72,0x73,0x45,0x64,0x69,0x74,0x2e, /* cument.DprsEdit. */ \
	0x61,0x63,0x63,0x65,0x65,0x2e,0x76,0x61,0x6c,0x75,0x65,0x29,0x3b,0x0d,0x0a,0x20, /* accee.value);..  */ \
	0x20,0x77,0x69,0x6e,0x64,0x6f,0x77,0x2e,0x6f,0x70,0x65,0x6e,0x65,0x72,0x2e,0x65, /*  window.opener.e */ \
	0x6d,0x61,0x69,0x6c,0x2e,0x73,0x70,0x6c,0x69,0x63,0x65,0x28,0x64,0x6f,0x63,0x75, /* mail.splice(docu */ \
	0x6d,0x65,0x6e,0x74,0x2e,0x44,0x70,0x72,0x73,0x45,0x64,0x69,0x74,0x2e,0x70,0x6f, /* ment.DprsEdit.po */ \
	0x73,0x69,0x74,0x69,0x6f,0x6e,0x2e,0x76,0x61,0x6c,0x75,0x65,0x2c,0x31,0x2c,0x64, /* sition.value,1,d */ \
	0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x44,0x70,0x72,0x73,0x45,0x64,0x69,0x74, /* ocument.DprsEdit */ \
	0x2e,0x6d,0x61,0x69,0x6c,0x65,0x2e,0x76,0x61,0x6c,0x75,0x65,0x29,0x3b,0x0d,0x0a, /* .maile.value);.. */ \
	0x20,0x20,0x6e,0x20,0x3d,0x20,0x77,0x69,0x6e,0x64,0x6f,0x77,0x2e,0x6f,0x70,0x65, /*   n = window.ope */ \
	0x6e,0x65,0x72,0x2e,0x63,0x61,0x6c,0x6c,0x73,0x69,0x67,0x6e,0x2e,0x6c,0x65,0x6e, /* ner.callsign.len */ \
	0x67,0x74,0x68,0x3b,0x0d,0x0a,0x20,0x20,0x6c,0x6f,0x63,0x61,0x74,0x69,0x6f,0x6e, /* gth;..  location */ \
	0x2e,0x72,0x65,0x6c,0x6f,0x61,0x64,0x28,0x29,0x3b,0x0d,0x0a,0x7d,0x0d,0x0a,0x0d, /* .reload();..}... */ \
	0x0a,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x20,0x53,0x61,0x76,0x65,0x43,0x68, /* .function SaveCh */ \
	0x65,0x63,0x6b,0x28,0x29,0x0d,0x0a,0x7b,0x0d,0x0a,0x20,0x20,0x69,0x66,0x20,0x28, /* eck()..{..  if ( */ \
	0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x44,0x70,0x72,0x73,0x45,0x64,0x69, /* document.DprsEdi */ \
	0x74,0x2e,0x63,0x61,0x6c,0x6c,0x73,0x2e,0x76,0x61,0x6c,0x75,0x65,0x2e,0x6c,0x65, /* t.calls.value.le */ \
	0x6e,0x67,0x74,0x68,0x20,0x21,0x3d,0x20,0x30,0x29,0x0d,0x0a,0x20,0x20,0x7b,0x0d, /* ngth != 0)..  {. */ \
	0x0a,0x20,0x20,0x20,0x20,0x69,0x66,0x20,0x28,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e, /* .    if (documen */ \
	0x74,0x2e,0x44,0x70,0x72,0x73,0x45,0x64,0x69,0x74,0x2e,0x63,0x61,0x6c,0x6c,0x73, /* t.DprsEdit.calls */ \
	0x2e,0x76,0x61,0x6c,0x75,0x65,0x2e,0x63,0x68,0x61,0x72,0x41,0x74,0x28,0x30,0x29, /* .value.charAt(0) */ \
	0x20,0x3d,0x3d,0x20,0x27,0x2a,0x27,0x29,0x0d,0x0a,0x20,0x20,0x20,0x20,0x7b,0x0d, /*  == '.')..    {. */ \
	0x0a,0x09,0x77,0x69,0x6e,0x64,0x6f,0x77,0x2e,0x61,0x6c,0x65,0x72,0x74,0x20,0x28, /* ..window.alert ( */ \
	0x22,0x44,0x6f,0x20,0x6e,0x6f,0x74,0x20,0x75,0x73,0x65,0x20,0x27,0x2a,0x27,0x20, /* "Do not use '.'  */ \
	0x28,0x61,0x6c,0x6c,0x20,0x43,0x61,0x6c,0x6c,0x73,0x69,0x67,0x6e,0x20,0x61,0x63, /* (all Callsign ac */ \
	0x63,0x65,0x70,0x74,0x29,0x21,0x22,0x29,0x3b,0x0d,0x0a,0x09,0x72,0x65,0x74,0x75, /* cept)!");...retu */ \
	0x72,0x6e,0x3b,0x0d,0x0a,0x20,0x20,0x20,0x20,0x7d,0x0d,0x0a,0x20,0x20,0x7d,0x0d, /* rn;..    }..  }. */ \
	0x0a,0x0d,0x0a,0x20,0x20,0x69,0x66,0x20,0x28,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e, /* ...  if (documen */ \
	0x74,0x2e,0x44,0x70,0x72,0x73,0x45,0x64,0x69,0x74,0x2e,0x63,0x61,0x6c,0x6c,0x65, /* t.DprsEdit.calle */ \
	0x2e,0x76,0x61,0x6c,0x75,0x65,0x2e,0x6c,0x65,0x6e,0x67,0x74,0x68,0x20,0x21,0x3d, /* .value.length != */ \
	0x20,0x30,0x29,0x0d,0x0a,0x20,0x20,0x7b,0x0d,0x0a,0x20,0x20,0x20,0x20,0x69,0x66, /*  0)..  {..    if */ \
	0x20,0x28,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x44,0x70,0x72,0x73,0x45, /*  (document.DprsE */ \
	0x64,0x69,0x74,0x2e,0x63,0x61,0x6c,0x6c,0x65,0x2e,0x76,0x61,0x6c,0x75,0x65,0x2e, /* dit.calle.value. */ \
	0x63,0x68,0x61,0x72,0x41,0x74,0x28,0x30,0x29,0x20,0x3d,0x3d,0x20,0x27,0x2a,0x27, /* charAt(0) == '.' */ \
	0x29,0x0d,0x0a,0x20,0x20,0x20,0x20,0x7b,0x0d,0x0a,0x09,0x77,0x69,0x6e,0x64,0x6f, /* )..    {...windo */ \
	0x77,0x2e,0x61,0x6c,0x65,0x72,0x74,0x20,0x28,0x22,0x44,0x6f,0x20,0x6e,0x6f,0x74, /* w.alert ("Do not */ \
	0x20,0x75,0x73,0x65,0x20,0x27,0x2a,0x27,0x20,0x28,0x61,0x6c,0x6c,0x20,0x43,0x61, /*  use '.' (all Ca */ \
	0x6c,0x6c,0x73,0x69,0x67,0x6e,0x20,0x61,0x63,0x63,0x65,0x70,0x74,0x29,0x21,0x22, /* llsign accept)!" */ \
	0x29,0x3b,0x0d,0x0a,0x09,0x72,0x65,0x74,0x75,0x72,0x6e,0x3b,0x0d,0x0a,0x20,0x20, /* );...return;..   */ \
	0x20,0x20,0x7d,0x0d,0x0a,0x20,0x20,0x7d,0x0d,0x0a,0x20,0x20,0x64,0x6f,0x63,0x75, /*   }..  }..  docu */ \
	0x6d,0x65,0x6e,0x74,0x2e,0x44,0x70,0x72,0x73,0x45,0x64,0x69,0x74,0x2e,0x73,0x75, /* ment.DprsEdit.su */ \
	0x62,0x6d,0x69,0x74,0x28,0x29,0x3b,0x0d,0x0a,0x7d,0x0d,0x0a,0x2f,0x2f,0x2d,0x2d, /* bmit();..}..//-- */ \
	0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74,0x3e,0x0d,0x0a,0x3c,0x74, /* >..</script>..<t */ \
	0x61,0x62,0x6c,0x65,0x20,0x62,0x6f,0x72,0x64,0x65,0x72,0x3d,0x32,0x3e,0x0d,0x0a, /* able border=2>.. */ \
	0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65, /* <script type="te */ \
	0x78,0x74,0x2f,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x20,0x6c, /* xt/javascript" l */ \
	0x61,0x6e,0x67,0x75,0x61,0x67,0x65,0x3d,0x22,0x4a,0x61,0x76,0x61,0x53,0x63,0x72, /* anguage="JavaScr */ \
	0x69,0x70,0x74,0x22,0x3e,0x0d,0x0a,0x3c,0x21,0x2d,0x2d,0x0d,0x0a,0x0d,0x0a,0x20, /* ipt">..<!--....  */ \
	0x6e,0x20,0x3d,0x20,0x77,0x69,0x6e,0x64,0x6f,0x77,0x2e,0x6f,0x70,0x65,0x6e,0x65, /* n = window.opene */ \
	0x72,0x2e,0x63,0x61,0x6c,0x6c,0x73,0x69,0x67,0x6e,0x2e,0x6c,0x65,0x6e,0x67,0x74, /* r.callsign.lengt */ \
	0x68,0x3b,0x0d,0x0a,0x20,0x69,0x66,0x20,0x28,0x6e,0x20,0x3e,0x20,0x30,0x29,0x0d, /* h;.. if (n > 0). */ \
	0x0a,0x20,0x7b,0x0d,0x0a,0x20,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e, /* . {..  document. */ \
	0x77,0x72,0x69,0x74,0x65,0x28,0x22,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x43, /* write("<tr><td>C */ \
	0x61,0x6c,0x6c,0x53,0x69,0x67,0x6e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e, /* allSign</td><td> */ \
	0x52,0x46,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x45,0x2d,0x6d,0x61,0x69  /* RF</td><td>E-mai */
#define DATACHUNK000021 \
	0x6c,0x20,0x61,0x64,0x64,0x72,0x65,0x73,0x73,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74, /* l address</td><t */ \
	0x64,0x3e,0x20,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x22,0x29,0x3b, /* d> </td></tr>"); */ \
	0x0d,0x0a,0x20,0x20,0x66,0x6f,0x72,0x28,0x69,0x3d,0x30,0x3b,0x20,0x69,0x3c,0x6e, /* ..  for(i=0; i<n */ \
	0x3b,0x20,0x69,0x2b,0x2b,0x29,0x7b,0x0d,0x0a,0x20,0x20,0x20,0x20,0x64,0x6f,0x63, /* ; i++){..    doc */ \
	0x75,0x6d,0x65,0x6e,0x74,0x2e,0x77,0x72,0x69,0x74,0x65,0x28,0x22,0x3c,0x74,0x72, /* ument.write("<tr */ \
	0x3e,0x3c,0x74,0x64,0x3e,0x22,0x29,0x3b,0x0d,0x0a,0x20,0x20,0x20,0x20,0x64,0x6f, /* ><td>");..    do */ \
	0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x77,0x72,0x69,0x74,0x65,0x28,0x77,0x69,0x6e, /* cument.write(win */ \
	0x64,0x6f,0x77,0x2e,0x6f,0x70,0x65,0x6e,0x65,0x72,0x2e,0x63,0x61,0x6c,0x6c,0x73, /* dow.opener.calls */ \
	0x69,0x67,0x6e,0x5b,0x69,0x5d,0x29,0x3b,0x0d,0x0a,0x20,0x20,0x20,0x20,0x64,0x6f, /* ign[i]);..    do */ \
	0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x77,0x72,0x69,0x74,0x65,0x28,0x22,0x3c,0x2f, /* cument.write("</ */ \
	0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x22,0x29,0x3b,0x0d,0x0a,0x20,0x20,0x20,0x20, /* td><td>");..     */ \
	0x69,0x66,0x20,0x28,0x77,0x69,0x6e,0x64,0x6f,0x77,0x2e,0x6f,0x70,0x65,0x6e,0x65, /* if (window.opene */ \
	0x72,0x2e,0x61,0x63,0x63,0x65,0x73,0x73,0x5b,0x69,0x5d,0x20,0x3d,0x3d,0x20,0x22, /* r.access[i] == " */ \
	0x4f,0x4e,0x22,0x29,0x0d,0x0a,0x20,0x20,0x20,0x20,0x7b,0x20,0x0d,0x0a,0x20,0x20, /* ON")..    { ..   */ \
	0x09,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x77,0x72,0x69,0x74,0x65,0x28, /* .document.write( */ \
	0x22,0x4f,0x4e,0x22,0x29,0x3b,0x0d,0x0a,0x20,0x20,0x20,0x20,0x7d,0x20,0x65,0x6c, /* "ON");..    } el */ \
	0x73,0x65,0x20,0x7b,0x0d,0x0a,0x09,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e, /* se {...document. */ \
	0x77,0x72,0x69,0x74,0x65,0x28,0x22,0x4f,0x46,0x46,0x22,0x29,0x3b,0x0d,0x0a,0x20, /* write("OFF");..  */ \
	0x20,0x20,0x20,0x7d,0x0d,0x0a,0x20,0x20,0x20,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65, /*    }..    docume */ \
	0x6e,0x74,0x2e,0x77,0x72,0x69,0x74,0x65,0x28,0x22,0x3c,0x2f,0x74,0x64,0x3e,0x3c, /* nt.write("</td>< */ \
	0x74,0x64,0x3e,0x22,0x29,0x3b,0x0d,0x0a,0x20,0x20,0x20,0x20,0x64,0x6f,0x63,0x75, /* td>");..    docu */ \
	0x6d,0x65,0x6e,0x74,0x2e,0x77,0x72,0x69,0x74,0x65,0x28,0x77,0x69,0x6e,0x64,0x6f, /* ment.write(windo */ \
	0x77,0x2e,0x6f,0x70,0x65,0x6e,0x65,0x72,0x2e,0x65,0x6d,0x61,0x69,0x6c,0x5b,0x69, /* w.opener.email[i */ \
	0x5d,0x29,0x3b,0x0d,0x0a,0x20,0x20,0x20,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e, /* ]);..    documen */ \
	0x74,0x2e,0x77,0x72,0x69,0x74,0x65,0x28,0x22,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74, /* t.write("</td><t */ \
	0x64,0x3e,0x22,0x29,0x3b,0x0d,0x0a,0x20,0x20,0x20,0x20,0x64,0x6f,0x63,0x75,0x6d, /* d>");..    docum */ \
	0x65,0x6e,0x74,0x2e,0x77,0x72,0x69,0x74,0x65,0x28,0x22,0x3c,0x69,0x6e,0x70,0x75, /* ent.write("<inpu */ \
	0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x5c,0x22,0x62,0x75,0x74,0x74,0x6f,0x6e,0x5c, /* t type=\"button\ */ \
	0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x5c,0x22,0x44,0x65,0x6c,0x5c,0x22,0x20, /* " value=\"Del\"  */ \
	0x6f,0x6e,0x43,0x6c,0x69,0x63,0x6b,0x3d,0x5c,0x22,0x64,0x65,0x6c,0x28,0x22,0x29, /* onClick=\"del(") */ \
	0x3b,0x0d,0x0a,0x20,0x20,0x20,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e, /* ;..    document. */ \
	0x77,0x72,0x69,0x74,0x65,0x28,0x69,0x29,0x3b,0x0d,0x0a,0x20,0x20,0x20,0x20,0x64, /* write(i);..    d */ \
	0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x77,0x72,0x69,0x74,0x65,0x28,0x22,0x29, /* ocument.write(") */ \
	0x5c,0x22,0x3e,0x22,0x29,0x3b,0x0d,0x0a,0x20,0x20,0x20,0x20,0x64,0x6f,0x63,0x75, /* \">");..    docu */ \
	0x6d,0x65,0x6e,0x74,0x2e,0x77,0x72,0x69,0x74,0x65,0x28,0x22,0x3c,0x69,0x6e,0x70, /* ment.write("<inp */ \
	0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x5c,0x22,0x62,0x75,0x74,0x74,0x6f,0x6e, /* ut type=\"button */ \
	0x5c,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x5c,0x22,0x49,0x6e,0x73,0x5c,0x22, /* \" value=\"Ins\" */ \
	0x20,0x6f,0x6e,0x43,0x6c,0x69,0x63,0x6b,0x3d,0x5c,0x22,0x69,0x6e,0x73,0x28,0x22, /*  onClick=\"ins(" */ \
	0x29,0x3b,0x0d,0x0a,0x20,0x20,0x20,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74, /* );..    document */ \
	0x2e,0x77,0x72,0x69,0x74,0x65,0x28,0x69,0x29,0x3b,0x0d,0x0a,0x20,0x20,0x20,0x20, /* .write(i);..     */ \
	0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x77,0x72,0x69,0x74,0x65,0x28,0x22, /* document.write(" */ \
	0x29,0x5c,0x22,0x3e,0x22,0x29,0x3b,0x0d,0x0a,0x20,0x20,0x20,0x20,0x64,0x6f,0x63, /* )\">");..    doc */ \
	0x75,0x6d,0x65,0x6e,0x74,0x2e,0x77,0x72,0x69,0x74,0x65,0x28,0x22,0x3c,0x69,0x6e, /* ument.write("<in */ \
	0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x5c,0x22,0x62,0x75,0x74,0x74,0x6f, /* put type=\"butto */ \
	0x6e,0x5c,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x5c,0x22,0x45,0x64,0x69,0x74, /* n\" value=\"Edit */ \
	0x5c,0x22,0x20,0x6f,0x6e,0x43,0x6c,0x69,0x63,0x6b,0x3d,0x5c,0x22,0x65,0x64,0x74, /* \" onClick=\"edt */ \
	0x28,0x22,0x29,0x3b,0x0d,0x0a,0x20,0x20,0x20,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65, /* (");..    docume */ \
	0x6e,0x74,0x2e,0x77,0x72,0x69,0x74,0x65,0x28,0x69,0x29,0x3b,0x0d,0x0a,0x20,0x20, /* nt.write(i);..   */ \
	0x20,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x77,0x72,0x69,0x74,0x65, /*   document.write */ \
	0x28,0x22,0x29,0x5c,0x22,0x3e,0x22,0x29,0x3b,0x0d,0x0a,0x20,0x20,0x20,0x20,0x69, /* (")\">");..    i */ \
	0x66,0x20,0x28,0x69,0x20,0x3d,0x3d,0x20,0x28,0x6e,0x2d,0x31,0x29,0x29,0x0d,0x0a, /* f (i == (n-1)).. */ \
	0x20,0x20,0x20,0x20,0x20,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x77, /*       document.w */ \
	0x72,0x69,0x74,0x65,0x28,0x22,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70, /* rite("<input typ */ \
	0x65,0x3d,0x5c,0x22,0x62,0x75,0x74,0x74,0x6f,0x6e,0x5c,0x22,0x20,0x76,0x61,0x6c, /* e=\"button\" val */ \
	0x75,0x65,0x3d,0x5c,0x22,0x41,0x70,0x70,0x65,0x6e,0x64,0x5c,0x22,0x20,0x6f,0x6e, /* ue=\"Append\" on */ \
	0x43,0x6c,0x69,0x63,0x6b,0x3d,0x5c,0x22,0x61,0x64,0x64,0x28,0x29,0x5c,0x22,0x3e, /* Click=\"add()\"> */ \
	0x22,0x29,0x3b,0x0d,0x0a,0x20,0x20,0x20,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e, /* ");..    documen */ \
	0x74,0x2e,0x77,0x72,0x69,0x74,0x65,0x28,0x22,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f, /* t.write("</td></ */ \
	0x74,0x72,0x3e,0x22,0x29,0x3b,0x0d,0x0a,0x20,0x20,0x7d,0x0d,0x0a,0x20,0x7d,0x20, /* tr>");..  }.. }  */ \
	0x65,0x6c,0x73,0x65,0x20,0x7b,0x0d,0x0a,0x20,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65, /* else {..  docume */ \
	0x6e,0x74,0x2e,0x77,0x72,0x69,0x74,0x65,0x28,0x22,0x3c,0x74,0x72,0x3e,0x3c,0x74, /* nt.write("<tr><t */ \
	0x64,0x3e,0x4e,0x6f,0x20,0x45,0x6e,0x74,0x72,0x79,0x20,0x28,0x4e,0x6f,0x20,0x41, /* d>No Entry (No A */ \
	0x50,0x52,0x53,0x20,0x4d,0x73,0x67,0x2e,0x20,0x41,0x63,0x63,0x65,0x73,0x73,0x20, /* PRS Msg. Access  */ \
	0x66,0x69,0x6c,0x65,0x29,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x22  /* file)</td></tr>" */
#define DATACHUNK000022 \
	0x29,0x3b,0x0d,0x0a,0x20,0x7d,0x0d,0x0a,0x2f,0x2f,0x20,0x2d,0x2d,0x3e,0x0d,0x0a, /* );.. }..// -->.. */ \
	0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74,0x3e,0x0d,0x0a,0x3c,0x2f,0x74,0x61,0x62, /* </script>..</tab */ \
	0x6c,0x65,0x3e,0x0d,0x0a,0x3c,0x62,0x72,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76, /* le>..<br>..</div */ \
	0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x53,0x41,0x56,0x45, /* >..<div id="SAVE */ \
	0x22,0x3e,0x0d,0x0a,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b, /* ">..&nbsp;&nbsp; */ \
	0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x62,0x75,0x74, /* <input type="but */ \
	0x74,0x6f,0x6e,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x43,0x61,0x6e,0x63, /* ton" value="Canc */ \
	0x65,0x6c,0x22,0x20,0x6f,0x6e,0x43,0x6c,0x69,0x63,0x6b,0x3d,0x22,0x63,0x61,0x6e, /* el" onClick="can */ \
	0x63,0x65,0x6c,0x28,0x29,0x22,0x3e,0x20,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74, /* cel()"> <input t */ \
	0x79,0x70,0x65,0x3d,0x22,0x62,0x75,0x74,0x74,0x6f,0x6e,0x22,0x20,0x76,0x61,0x6c, /* ype="button" val */ \
	0x75,0x65,0x3d,0x22,0x43,0x6c,0x6f,0x73,0x65,0x22,0x20,0x6f,0x6e,0x43,0x6c,0x69, /* ue="Close" onCli */ \
	0x63,0x6b,0x3d,0x22,0x77,0x69,0x6e,0x64,0x6f,0x77,0x2e,0x63,0x6c,0x6f,0x73,0x65, /* ck="window.close */ \
	0x28,0x29,0x22,0x3e,0x20,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65, /* ()"> <input type */ \
	0x3d,0x22,0x62,0x75,0x74,0x74,0x6f,0x6e,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d, /* ="button" value= */ \
	0x22,0x53,0x61,0x76,0x65,0x22,0x20,0x6f,0x6e,0x43,0x6c,0x69,0x63,0x6b,0x3d,0x22, /* "Save" onClick=" */ \
	0x53,0x61,0x76,0x65,0x43,0x68,0x65,0x63,0x6b,0x28,0x29,0x22,0x20,0x3e,0x0d,0x0a, /* SaveCheck()" >.. */ \
	0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d, /* </div>..<div id= */ \
	0x22,0x46,0x49,0x52,0x53,0x54,0x22,0x3e,0x0d,0x0a,0x26,0x6e,0x62,0x73,0x70,0x3b, /* "FIRST">..&nbsp; */ \
	0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70, /* &nbsp;<input typ */ \
	0x65,0x3d,0x22,0x62,0x75,0x74,0x74,0x6f,0x6e,0x22,0x20,0x76,0x61,0x6c,0x75,0x65, /* e="button" value */ \
	0x3d,0x22,0x43,0x61,0x6e,0x63,0x65,0x6c,0x22,0x20,0x6f,0x6e,0x43,0x6c,0x69,0x63, /* ="Cancel" onClic */ \
	0x6b,0x3d,0x22,0x63,0x61,0x6e,0x63,0x65,0x6c,0x28,0x29,0x22,0x3e,0x20,0x3c,0x69, /* k="cancel()"> <i */ \
	0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x62,0x75,0x74,0x74,0x6f, /* nput type="butto */ \
	0x6e,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x43,0x6c,0x6f,0x73,0x65,0x22, /* n" value="Close" */ \
	0x20,0x6f,0x6e,0x43,0x6c,0x69,0x63,0x6b,0x3d,0x22,0x77,0x69,0x6e,0x64,0x6f,0x77, /*  onClick="window */ \
	0x2e,0x63,0x6c,0x6f,0x73,0x65,0x28,0x29,0x22,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69, /* .close()">..</di */ \
	0x76,0x3e,0x0d,0x0a,0x3c,0x62,0x72,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69, /* v>..<br>..<div i */ \
	0x64,0x3d,0x22,0x41,0x44,0x44,0x22,0x3e,0x0d,0x0a,0x26,0x6e,0x62,0x73,0x70,0x3b, /* d="ADD">..&nbsp; */ \
	0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70, /* &nbsp;<input typ */ \
	0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x63, /* e="text" name="c */ \
	0x61,0x6c,0x6c,0x73,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x39,0x22,0x3e,0x0d, /* alls" size="9">. */ \
	0x0a,0x3c,0x73,0x65,0x6c,0x65,0x63,0x74,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x61, /* .<select name="a */ \
	0x63,0x63,0x65,0x73,0x22,0x3e,0x0d,0x0a,0x3c,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x20, /* cces">..<option  */ \
	0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x4f,0x4e,0x22,0x3e,0x4f,0x4e,0x0d,0x0a,0x3c, /* value="ON">ON..< */ \
	0x6f,0x70,0x74,0x69,0x6f,0x6e,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x4f,0x46, /* option value="OF */ \
	0x46,0x22,0x3e,0x4f,0x46,0x46,0x0d,0x0a,0x3c,0x2f,0x73,0x65,0x6c,0x65,0x63,0x74, /* F">OFF..</select */ \
	0x3e,0x0d,0x0a,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c, /* >..&nbsp;&nbsp;< */ \
	0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74, /* input type="text */ \
	0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6d,0x61,0x69,0x6c,0x73,0x22,0x3e,0x0d, /* " name="mails">. */ \
	0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x62,0x75, /* .<input type="bu */ \
	0x74,0x74,0x6f,0x6e,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x49,0x6e,0x73, /* tton" value="Ins */ \
	0x65,0x72,0x74,0x2f,0x41,0x70,0x70,0x65,0x6e,0x64,0x22,0x20,0x6f,0x6e,0x43,0x6c, /* ert/Append" onCl */ \
	0x69,0x63,0x6b,0x3d,0x22,0x69,0x6e,0x73,0x65,0x72,0x74,0x28,0x29,0x22,0x3e,0x0d, /* ick="insert()">. */ \
	0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x62,0x75, /* .<input type="bu */ \
	0x74,0x74,0x6f,0x6e,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x43,0x61,0x6e, /* tton" value="Can */ \
	0x63,0x65,0x6c,0x22,0x20,0x6f,0x6e,0x43,0x6c,0x69,0x63,0x6b,0x3d,0x22,0x63,0x61, /* cel" onClick="ca */ \
	0x6e,0x63,0x65,0x6c,0x28,0x29,0x22,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e, /* ncel()">..</div> */ \
	0x0d,0x0a,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x45,0x44,0x49, /* ....<div id="EDI */ \
	0x54,0x22,0x3e,0x0d,0x0a,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70, /* T">..&nbsp;&nbsp */ \
	0x3b,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65, /* ;<input type="te */ \
	0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x63,0x61,0x6c,0x6c,0x65,0x22, /* xt" name="calle" */ \
	0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x39,0x22,0x3e,0x0d,0x0a,0x3c,0x73,0x65,0x6c, /*  size="9">..<sel */ \
	0x65,0x63,0x74,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x61,0x63,0x63,0x65,0x65,0x22, /* ect name="accee" */ \
	0x3e,0x0d,0x0a,0x3c,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x20,0x76,0x61,0x6c,0x75,0x65, /* >..<option value */ \
	0x3d,0x22,0x4f,0x4e,0x22,0x3e,0x4f,0x4e,0x0d,0x0a,0x3c,0x6f,0x70,0x74,0x69,0x6f, /* ="ON">ON..<optio */ \
	0x6e,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x4f,0x46,0x46,0x22,0x3e,0x4f,0x46, /* n value="OFF">OF */ \
	0x46,0x0d,0x0a,0x3c,0x2f,0x73,0x65,0x6c,0x65,0x63,0x74,0x3e,0x0d,0x0a,0x26,0x6e, /* F..</select>..&n */ \
	0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x69,0x6e,0x70,0x75,0x74, /* bsp;&nbsp;<input */ \
	0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d, /*  type="text" nam */ \
	0x65,0x3d,0x22,0x6d,0x61,0x69,0x6c,0x65,0x22,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70, /* e="maile">..<inp */ \
	0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x62,0x75,0x74,0x74,0x6f,0x6e,0x22, /* ut type="button" */ \
	0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x52,0x65,0x70,0x6c,0x61,0x63,0x65,0x22, /*  value="Replace" */ \
	0x20,0x6f,0x6e,0x43,0x6c,0x69,0x63,0x6b,0x3d,0x22,0x72,0x65,0x70,0x28,0x29,0x22, /*  onClick="rep()" */ \
	0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22  /* >..<input type=" */
#define DATACHUNK000023 \
	0x62,0x75,0x74,0x74,0x6f,0x6e,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x43, /* button" value="C */ \
	0x61,0x6e,0x63,0x65,0x6c,0x22,0x20,0x6f,0x6e,0x43,0x6c,0x69,0x63,0x6b,0x3d,0x22, /* ancel" onClick=" */ \
	0x63,0x61,0x6e,0x63,0x65,0x6c,0x28,0x29,0x22,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70, /* cancel()">..<inp */ \
	0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x68,0x69,0x64,0x64,0x65,0x6e,0x22, /* ut type="hidden" */ \
	0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x70,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x22, /*  name="position" */ \
	0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x64,0x69, /* >..</div>....<di */ \
	0x76,0x20,0x69,0x64,0x3d,0x22,0x54,0x45,0x58,0x54,0x22,0x3e,0x0d,0x0a,0x3c,0x74, /* v id="TEXT">..<t */ \
	0x65,0x78,0x74,0x61,0x72,0x65,0x61,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6d,0x73, /* extarea name="ms */ \
	0x67,0x63,0x22,0x20,0x63,0x6f,0x6c,0x73,0x3d,0x22,0x35,0x30,0x22,0x20,0x72,0x6f, /* gc" cols="50" ro */ \
	0x77,0x73,0x3d,0x22,0x31,0x30,0x22,0x3e,0x0d,0x0a,0x3c,0x2f,0x74,0x65,0x78,0x74, /* ws="10">..</text */ \
	0x61,0x72,0x65,0x61,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d, /* area>..</div>... */ \
	0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74, /* .<script type="t */ \
	0x65,0x78,0x74,0x2f,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x20, /* ext/javascript"  */ \
	0x6c,0x61,0x6e,0x67,0x75,0x61,0x67,0x65,0x3d,0x22,0x4a,0x61,0x76,0x61,0x53,0x63, /* language="JavaSc */ \
	0x72,0x69,0x70,0x74,0x22,0x3e,0x0d,0x0a,0x3c,0x21,0x2d,0x2d,0x0d,0x0a,0x20,0x6e, /* ript">..<!--.. n */ \
	0x20,0x3d,0x20,0x77,0x69,0x6e,0x64,0x6f,0x77,0x2e,0x6f,0x70,0x65,0x6e,0x65,0x72, /*  = window.opener */ \
	0x2e,0x63,0x61,0x6c,0x6c,0x73,0x69,0x67,0x6e,0x2e,0x6c,0x65,0x6e,0x67,0x74,0x68, /* .callsign.length */ \
	0x3b,0x0d,0x0a,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x44,0x70,0x72, /* ;.. document.Dpr */ \
	0x73,0x45,0x64,0x69,0x74,0x2e,0x6d,0x73,0x67,0x63,0x2e,0x76,0x61,0x6c,0x75,0x65, /* sEdit.msgc.value */ \
	0x20,0x3d,0x20,0x22,0x22,0x3b,0x0d,0x0a,0x20,0x66,0x6f,0x72,0x20,0x28,0x69,0x20, /*  = "";.. for (i  */ \
	0x3d,0x20,0x30,0x20,0x3b,0x20,0x69,0x20,0x3c,0x20,0x6e,0x20,0x3b,0x20,0x69,0x2b, /* = 0 ; i < n ; i+ */ \
	0x2b,0x29,0x0d,0x0a,0x20,0x7b,0x0d,0x0a,0x20,0x20,0x20,0x64,0x6f,0x63,0x75,0x6d, /* +).. {..   docum */ \
	0x65,0x6e,0x74,0x2e,0x44,0x70,0x72,0x73,0x45,0x64,0x69,0x74,0x2e,0x6d,0x73,0x67, /* ent.DprsEdit.msg */ \
	0x63,0x2e,0x76,0x61,0x6c,0x75,0x65,0x20,0x2b,0x3d,0x20,0x20,0x77,0x69,0x6e,0x64, /* c.value +=  wind */ \
	0x6f,0x77,0x2e,0x6f,0x70,0x65,0x6e,0x65,0x72,0x2e,0x63,0x61,0x6c,0x6c,0x73,0x69, /* ow.opener.callsi */ \
	0x67,0x6e,0x5b,0x69,0x5d,0x3b,0x0d,0x0a,0x20,0x20,0x20,0x64,0x6f,0x63,0x75,0x6d, /* gn[i];..   docum */ \
	0x65,0x6e,0x74,0x2e,0x44,0x70,0x72,0x73,0x45,0x64,0x69,0x74,0x2e,0x6d,0x73,0x67, /* ent.DprsEdit.msg */ \
	0x63,0x2e,0x76,0x61,0x6c,0x75,0x65,0x20,0x2b,0x3d,0x20,0x20,0x22,0x2c,0x22,0x3b, /* c.value +=  ","; */ \
	0x0d,0x0a,0x20,0x20,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x44,0x70, /* ..   document.Dp */ \
	0x72,0x73,0x45,0x64,0x69,0x74,0x2e,0x6d,0x73,0x67,0x63,0x2e,0x76,0x61,0x6c,0x75, /* rsEdit.msgc.valu */ \
	0x65,0x20,0x2b,0x3d,0x20,0x20,0x77,0x69,0x6e,0x64,0x6f,0x77,0x2e,0x6f,0x70,0x65, /* e +=  window.ope */ \
	0x6e,0x65,0x72,0x2e,0x61,0x63,0x63,0x65,0x73,0x73,0x5b,0x69,0x5d,0x3b,0x0d,0x0a, /* ner.access[i];.. */ \
	0x20,0x20,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x44,0x70,0x72,0x73, /*    document.Dprs */ \
	0x45,0x64,0x69,0x74,0x2e,0x6d,0x73,0x67,0x63,0x2e,0x76,0x61,0x6c,0x75,0x65,0x20, /* Edit.msgc.value  */ \
	0x2b,0x3d,0x20,0x20,0x22,0x2c,0x22,0x3b,0x0d,0x0a,0x20,0x20,0x20,0x64,0x6f,0x63, /* +=  ",";..   doc */ \
	0x75,0x6d,0x65,0x6e,0x74,0x2e,0x44,0x70,0x72,0x73,0x45,0x64,0x69,0x74,0x2e,0x6d, /* ument.DprsEdit.m */ \
	0x73,0x67,0x63,0x2e,0x76,0x61,0x6c,0x75,0x65,0x20,0x2b,0x3d,0x20,0x20,0x77,0x69, /* sgc.value +=  wi */ \
	0x6e,0x64,0x6f,0x77,0x2e,0x6f,0x70,0x65,0x6e,0x65,0x72,0x2e,0x65,0x6d,0x61,0x69, /* ndow.opener.emai */ \
	0x6c,0x5b,0x69,0x5d,0x3b,0x0d,0x0a,0x20,0x20,0x20,0x69,0x66,0x20,0x28,0x69,0x20, /* l[i];..   if (i  */ \
	0x21,0x3d,0x20,0x28,0x6e,0x2d,0x31,0x29,0x29,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65, /* != (n-1)) docume */ \
	0x6e,0x74,0x2e,0x44,0x70,0x72,0x73,0x45,0x64,0x69,0x74,0x2e,0x6d,0x73,0x67,0x63, /* nt.DprsEdit.msgc */ \
	0x2e,0x76,0x61,0x6c,0x75,0x65,0x20,0x2b,0x3d,0x20,0x20,0x22,0x2c,0x22,0x3b,0x0d, /* .value +=  ",";. */ \
	0x0a,0x20,0x20,0x20,0x65,0x6c,0x73,0x65,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e, /* .   else documen */ \
	0x74,0x2e,0x44,0x70,0x72,0x73,0x45,0x64,0x69,0x74,0x2e,0x6d,0x73,0x67,0x63,0x2e, /* t.DprsEdit.msgc. */ \
	0x76,0x61,0x6c,0x75,0x65,0x20,0x2b,0x3d,0x20,0x20,0x22,0x3b,0x22,0x3b,0x0d,0x0a, /* value +=  ";";.. */ \
	0x20,0x7d,0x0d,0x0a,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x67,0x65,0x74, /*  }..document.get */ \
	0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28,0x27,0x45,0x44,0x49, /* ElementById('EDI */ \
	0x54,0x27,0x29,0x2e,0x73,0x74,0x79,0x6c,0x65,0x2e,0x64,0x69,0x73,0x70,0x6c,0x61, /* T').style.displa */ \
	0x79,0x20,0x3d,0x20,0x27,0x6e,0x6f,0x6e,0x65,0x27,0x3b,0x0d,0x0a,0x69,0x66,0x20, /* y = 'none';..if  */ \
	0x28,0x6e,0x20,0x3e,0x20,0x30,0x29,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74, /* (n > 0) document */ \
	0x2e,0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28, /* .getElementById( */ \
	0x27,0x41,0x44,0x44,0x27,0x29,0x2e,0x73,0x74,0x79,0x6c,0x65,0x2e,0x64,0x69,0x73, /* 'ADD').style.dis */ \
	0x70,0x6c,0x61,0x79,0x20,0x3d,0x20,0x27,0x6e,0x6f,0x6e,0x65,0x27,0x3b,0x0d,0x0a, /* play = 'none';.. */ \
	0x65,0x6c,0x73,0x65,0x0d,0x0a,0x7b,0x0d,0x0a,0x20,0x20,0x64,0x6f,0x63,0x75,0x6d, /* else..{..  docum */ \
	0x65,0x6e,0x74,0x2e,0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79, /* ent.getElementBy */ \
	0x49,0x64,0x28,0x27,0x41,0x44,0x44,0x27,0x29,0x2e,0x73,0x74,0x79,0x6c,0x65,0x2e, /* Id('ADD').style. */ \
	0x64,0x69,0x73,0x70,0x6c,0x61,0x79,0x20,0x3d,0x20,0x27,0x62,0x6c,0x6f,0x63,0x6b, /* display = 'block */ \
	0x27,0x3b,0x0d,0x0a,0x20,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x44, /* ';..  document.D */ \
	0x70,0x72,0x73,0x45,0x64,0x69,0x74,0x2e,0x70,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e, /* prsEdit.position */ \
	0x2e,0x76,0x61,0x6c,0x75,0x65,0x20,0x3d,0x20,0x2d,0x31,0x3b,0x0d,0x0a,0x7d,0x0d, /* .value = -1;..}. */ \
	0x0a,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x67,0x65,0x74,0x45,0x6c,0x65, /* .document.getEle */ \
	0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28,0x27,0x54,0x45,0x58,0x54,0x27,0x29, /* mentById('TEXT') */ \
	0x2e,0x73,0x74,0x79,0x6c,0x65,0x2e,0x64,0x69,0x73,0x70,0x6c,0x61,0x79,0x20,0x3d, /* .style.display = */ \
	0x20,0x27,0x6e,0x6f,0x6e,0x65,0x27,0x3b,0x0d,0x0a,0x69,0x66,0x20,0x28,0x6e,0x20  /*  'none';..if (n  */
#define DATACHUNK000024 \
	0x3e,0x20,0x30,0x29,0x0d,0x0a,0x7b,0x0d,0x0a,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65, /* > 0)..{.. docume */ \
	0x6e,0x74,0x2e,0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49, /* nt.getElementByI */ \
	0x64,0x28,0x27,0x46,0x49,0x52,0x53,0x54,0x27,0x29,0x2e,0x73,0x74,0x79,0x6c,0x65, /* d('FIRST').style */ \
	0x2e,0x64,0x69,0x73,0x70,0x6c,0x61,0x79,0x3d,0x22,0x6e,0x6f,0x6e,0x65,0x22,0x0d, /* .display="none". */ \
	0x0a,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x67,0x65,0x74,0x45,0x6c, /* . document.getEl */ \
	0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28,0x27,0x53,0x41,0x56,0x45,0x27, /* ementById('SAVE' */ \
	0x29,0x2e,0x73,0x74,0x79,0x6c,0x65,0x2e,0x64,0x69,0x73,0x70,0x6c,0x61,0x79,0x3d, /* ).style.display= */ \
	0x22,0x62,0x6c,0x6f,0x63,0x6b,0x22,0x0d,0x0a,0x7d,0x0d,0x0a,0x65,0x6c,0x73,0x65, /* "block"..}..else */ \
	0x0d,0x0a,0x7b,0x0d,0x0a,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x67, /* ..{.. document.g */ \
	0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28,0x27,0x46, /* etElementById('F */ \
	0x49,0x52,0x53,0x54,0x27,0x29,0x2e,0x73,0x74,0x79,0x6c,0x65,0x2e,0x64,0x69,0x73, /* IRST').style.dis */ \
	0x70,0x6c,0x61,0x79,0x3d,0x22,0x62,0x6c,0x6f,0x63,0x6b,0x22,0x0d,0x0a,0x20,0x64, /* play="block".. d */ \
	0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65, /* ocument.getEleme */ \
	0x6e,0x74,0x42,0x79,0x49,0x64,0x28,0x27,0x53,0x41,0x56,0x45,0x27,0x29,0x2e,0x73, /* ntById('SAVE').s */ \
	0x74,0x79,0x6c,0x65,0x2e,0x64,0x69,0x73,0x70,0x6c,0x61,0x79,0x3d,0x22,0x6e,0x6f, /* tyle.display="no */ \
	0x6e,0x65,0x22,0x0d,0x0a,0x7d,0x0d,0x0a,0x0d,0x0a,0x0d,0x0a,0x2f,0x2f,0x20,0x2d, /* ne"..}......// - */ \
	0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74,0x3e,0x0d,0x0a,0x3c, /* ->..</script>..< */ \
	0x2f,0x66,0x6f,0x72,0x6d,0x3e,0x0d,0x0a,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66, /* /form>....~inc:f */ \
	0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x00,0x00,0x00,0x00,0x33,0x00, /* ooter.inc~....3. */ \
	0x00,0x00,0x44,0x19,0x00,0x00,0x02,0x00,0x00,0x00,0x7e,0x69,0x6e,0x63,0x3a,0x68, /* ..D.......~inc:h */ \
	0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76, /* eader.inc~..<div */ \
	0x20,0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a, /*  id="content">.. */ \
	0x3c,0x68,0x31,0x3e,0x41,0x50,0x52,0x53,0x20,0x4d,0x65,0x73,0x73,0x61,0x67,0x65, /* <h1>APRS Message */ \
	0x20,0x43,0x6f,0x6e,0x74,0x72,0x6f,0x6c,0x20,0x46,0x69,0x6c,0x65,0x3c,0x2f,0x68, /*  Control File</h */ \
	0x31,0x3e,0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x74,0x79,0x70,0x65, /* 1>..<script type */ \
	0x3d,0x22,0x74,0x65,0x78,0x74,0x2f,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70, /* ="text/javascrip */ \
	0x74,0x22,0x20,0x6c,0x61,0x6e,0x67,0x75,0x61,0x67,0x65,0x3d,0x22,0x4a,0x61,0x76, /* t" language="Jav */ \
	0x61,0x53,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x0d,0x0a,0x3c,0x21,0x2d,0x2d,0x0d, /* aScript">..<!--. */ \
	0x0a,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x20,0x49,0x6e,0x69,0x74,0x56,0x61, /* .function InitVa */ \
	0x6c,0x75,0x65,0x53,0x65,0x74,0x28,0x29,0x0d,0x0a,0x7b,0x0d,0x0a,0x63,0x61,0x6c, /* lueSet()..{..cal */ \
	0x6c,0x73,0x69,0x67,0x6e,0x20,0x3d,0x20,0x6e,0x65,0x77,0x20,0x41,0x72,0x72,0x61, /* lsign = new Arra */ \
	0x79,0x28,0x29,0x3b,0x0d,0x0a,0x61,0x63,0x63,0x65,0x73,0x73,0x09,0x20,0x3d,0x20, /* y();..access. =  */ \
	0x6e,0x65,0x77,0x20,0x41,0x72,0x72,0x61,0x79,0x28,0x29,0x3b,0x0d,0x0a,0x65,0x6d, /* new Array();..em */ \
	0x61,0x69,0x6c,0x09,0x20,0x3d,0x20,0x6e,0x65,0x77,0x20,0x41,0x72,0x72,0x61,0x79, /* ail. = new Array */ \
	0x28,0x29,0x3b,0x09,0x0d,0x0a,0x7e,0x45,0x6d,0x61,0x69,0x6c,0x41,0x63,0x63,0x65, /* ();...~EmailAcce */ \
	0x73,0x73,0x46,0x69,0x72,0x73,0x74,0x7e,0x0d,0x0a,0x7e,0x45,0x6d,0x61,0x69,0x6c, /* ssFirst~..~Email */ \
	0x41,0x63,0x63,0x65,0x73,0x73,0x7e,0x0d,0x0a,0x7d,0x0d,0x0a,0x0d,0x0a,0x2f,0x2f, /* Access~..}....// */ \
	0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74,0x3e,0x0d,0x0a, /* -->..</script>.. */ \
	0x3c,0x66,0x6f,0x72,0x6d,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x64,0x70,0x72,0x73, /* <form name="dprs */ \
	0x22,0x3e,0x0d,0x0a,0x3c,0x62,0x72,0x3e,0x0d,0x0a,0x3c,0x62,0x3e,0x4e,0x6f,0x74, /* ">..<br>..<b>Not */ \
	0x65,0x3a,0x20,0x44,0x6f,0x20,0x6e,0x6f,0x74,0x20,0x63,0x6c,0x6f,0x73,0x65,0x20, /* e: Do not close  */ \
	0x74,0x68,0x69,0x73,0x20,0x77,0x69,0x6e,0x64,0x6f,0x77,0x20,0x75,0x6e,0x74,0x69, /* this window unti */ \
	0x6c,0x20,0x63,0x6c,0x6f,0x73,0x69,0x6e,0x67,0x20,0x74,0x68,0x65,0x20,0x65,0x64, /* l closing the ed */ \
	0x69,0x74,0x20,0x77,0x69,0x6e,0x64,0x6f,0x77,0x21,0x3c,0x2f,0x62,0x3e,0x3c,0x62, /* it window!</b><b */ \
	0x72,0x3e,0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x74,0x79,0x70,0x65, /* r>..<script type */ \
	0x3d,0x22,0x74,0x65,0x78,0x74,0x2f,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70, /* ="text/javascrip */ \
	0x74,0x22,0x20,0x6c,0x61,0x6e,0x67,0x75,0x61,0x67,0x65,0x3d,0x22,0x4a,0x61,0x76, /* t" language="Jav */ \
	0x61,0x53,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x0d,0x0a,0x3c,0x21,0x2d,0x2d,0x0d, /* aScript">..<!--. */ \
	0x0a,0x76,0x61,0x72,0x20,0x77,0x3b,0x0d,0x0a,0x49,0x6e,0x69,0x74,0x56,0x61,0x6c, /* .var w;..InitVal */ \
	0x75,0x65,0x53,0x65,0x74,0x28,0x29,0x3b,0x0d,0x0a,0x69,0x66,0x20,0x28,0x21,0x77, /* ueSet();..if (!w */ \
	0x20,0x7c,0x7c,0x20,0x77,0x2e,0x63,0x6c,0x6f,0x73,0x65,0x64,0x29,0x20,0x77,0x69, /*  || w.closed) wi */ \
	0x6e,0x64,0x6f,0x77,0x2e,0x6f,0x70,0x65,0x6e,0x28,0x22,0x2e,0x2f,0x64,0x70,0x72, /* ndow.open("./dpr */ \
	0x73,0x65,0x64,0x69,0x74,0x2e,0x68,0x74,0x6d,0x22,0x29,0x3b,0x0d,0x0a,0x65,0x6c, /* sedit.htm");..el */ \
	0x73,0x65,0x20,0x77,0x2e,0x66,0x6f,0x63,0x75,0x73,0x28,0x29,0x3b,0x0d,0x0a,0x2f, /* se w.focus();../ */ \
	0x2f,0x20,0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74,0x3e, /* / -->..</script> */ \
	0x0d,0x0a,0x3c,0x2f,0x66,0x6f,0x72,0x6d,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76, /* ..</form>..</div */ \
	0x3e,0x0d,0x0a,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72, /* >....~inc:footer */ \
	0x2e,0x69,0x6e,0x63,0x7e,0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0xec,0x00,0x00, /* .inc~....3...... */ \
	0x00,0xc4,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0xc1,0x00,0x00,0x00,0x4b,0x02,0x00, /* .............K.. */ \
	0x00,0x02,0x00,0x00,0x00,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72, /* .....~inc:header */ \
	0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22, /* .inc~..<div id=" */ \
	0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x45, /* content">..<h1>E */ \
	0x64,0x69,0x74,0x20,0x74,0x68,0x65,0x20,0x41,0x63,0x63,0x65,0x73,0x73,0x20,0x43, /* dit the Access C */ \
	0x6f,0x6e,0x74,0x72,0x6f,0x6c,0x20,0x46,0x69,0x6c,0x65,0x3c,0x2f,0x68,0x31,0x3e  /* ontrol File</h1> */
#define DATACHUNK000025 \
	0x0d,0x0a,0x3c,0x66,0x6f,0x72,0x6d,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x65,0x64, /* ..<form name="ed */ \
	0x69,0x74,0x22,0x20,0x6d,0x65,0x74,0x68,0x6f,0x64,0x3d,0x22,0x70,0x6f,0x73,0x74, /* it" method="post */ \
	0x22,0x20,0x61,0x63,0x74,0x69,0x6f,0x6e,0x3d,0x22,0x2f,0x70,0x72,0x6f,0x74,0x65, /* " action="/prote */ \
	0x63,0x74,0x2f,0x65,0x64,0x69,0x74,0x2e,0x68,0x74,0x6d,0x22,0x20,0x65,0x6e,0x63, /* ct/edit.htm" enc */ \
	0x74,0x79,0x70,0x65,0x3d,0x22,0x6d,0x75,0x6c,0x74,0x69,0x70,0x61,0x72,0x74,0x2f, /* type="multipart/ */ \
	0x66,0x6f,0x72,0x6d,0x2d,0x64,0x61,0x74,0x61,0x22,0x3e,0x0d,0x0a,0x3c,0x73,0x63, /* form-data">..<sc */ \
	0x72,0x69,0x70,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x2f, /* ript type="text/ */ \
	0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x20,0x6c,0x61,0x6e,0x67, /* javascript" lang */ \
	0x75,0x61,0x67,0x65,0x3d,0x22,0x4a,0x61,0x76,0x61,0x53,0x63,0x72,0x69,0x70,0x74, /* uage="JavaScript */ \
	0x22,0x3e,0x0d,0x0a,0x3c,0x21,0x2d,0x2d,0x0d,0x0a,0x0d,0x0a,0x66,0x75,0x6e,0x63, /* ">..<!--....func */ \
	0x74,0x69,0x6f,0x6e,0x20,0x64,0x65,0x6c,0x28,0x61,0x29,0x0d,0x0a,0x7b,0x0d,0x0a, /* tion del(a)..{.. */ \
	0x20,0x20,0x77,0x69,0x6e,0x64,0x6f,0x77,0x2e,0x6f,0x70,0x65,0x6e,0x65,0x72,0x2e, /*   window.opener. */ \
	0x63,0x61,0x6c,0x6c,0x73,0x69,0x67,0x6e,0x2e,0x73,0x70,0x6c,0x69,0x63,0x65,0x20, /* callsign.splice  */ \
	0x28,0x61,0x2c,0x31,0x29,0x3b,0x0d,0x0a,0x20,0x20,0x77,0x69,0x6e,0x64,0x6f,0x77, /* (a,1);..  window */ \
	0x2e,0x6f,0x70,0x65,0x6e,0x65,0x72,0x2e,0x61,0x63,0x63,0x65,0x73,0x73,0x2e,0x73, /* .opener.access.s */ \
	0x70,0x6c,0x69,0x63,0x65,0x28,0x61,0x2c,0x31,0x29,0x3b,0x0d,0x0a,0x20,0x20,0x6e, /* plice(a,1);..  n */ \
	0x20,0x3d,0x20,0x77,0x69,0x6e,0x64,0x6f,0x77,0x2e,0x6f,0x70,0x65,0x6e,0x65,0x72, /*  = window.opener */ \
	0x2e,0x63,0x61,0x6c,0x6c,0x73,0x69,0x67,0x6e,0x2e,0x6c,0x65,0x6e,0x67,0x74,0x68, /* .callsign.length */ \
	0x3b,0x0d,0x0a,0x20,0x20,0x6c,0x6f,0x63,0x61,0x74,0x69,0x6f,0x6e,0x2e,0x72,0x65, /* ;..  location.re */ \
	0x6c,0x6f,0x61,0x64,0x28,0x29,0x3b,0x0d,0x0a,0x7d,0x0d,0x0a,0x0d,0x0a,0x66,0x75, /* load();..}....fu */ \
	0x6e,0x63,0x74,0x69,0x6f,0x6e,0x20,0x63,0x61,0x6e,0x63,0x65,0x6c,0x28,0x29,0x0d, /* nction cancel(). */ \
	0x0a,0x7b,0x0d,0x0a,0x20,0x20,0x6e,0x20,0x3d,0x20,0x77,0x69,0x6e,0x64,0x6f,0x77, /* .{..  n = window */ \
	0x2e,0x6f,0x70,0x65,0x6e,0x65,0x72,0x2e,0x63,0x61,0x6c,0x6c,0x73,0x69,0x67,0x6e, /* .opener.callsign */ \
	0x2e,0x6c,0x65,0x6e,0x67,0x74,0x68,0x3b,0x0d,0x0a,0x20,0x20,0x6c,0x6f,0x63,0x61, /* .length;..  loca */ \
	0x74,0x69,0x6f,0x6e,0x2e,0x72,0x65,0x6c,0x6f,0x61,0x64,0x28,0x29,0x3b,0x0d,0x0a, /* tion.reload();.. */ \
	0x7d,0x0d,0x0a,0x0d,0x0a,0x0d,0x0a,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x20, /* }......function  */ \
	0x69,0x6e,0x73,0x65,0x72,0x74,0x28,0x29,0x0d,0x0a,0x7b,0x0d,0x0a,0x20,0x20,0x69, /* insert()..{..  i */ \
	0x66,0x20,0x28,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x65,0x64,0x69,0x74, /* f (document.edit */ \
	0x2e,0x70,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x2e,0x76,0x61,0x6c,0x75,0x65,0x20, /* .position.value  */ \
	0x3d,0x3d,0x20,0x2d,0x31,0x29,0x0d,0x0a,0x20,0x20,0x7b,0x09,0x0d,0x0a,0x20,0x20, /* == -1)..  {...   */ \
	0x20,0x20,0x20,0x77,0x69,0x6e,0x64,0x6f,0x77,0x2e,0x6f,0x70,0x65,0x6e,0x65,0x72, /*    window.opener */ \
	0x2e,0x63,0x61,0x6c,0x6c,0x73,0x69,0x67,0x6e,0x2e,0x70,0x75,0x73,0x68,0x28,0x64, /* .callsign.push(d */ \
	0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x65,0x64,0x69,0x74,0x2e,0x63,0x61,0x6c, /* ocument.edit.cal */ \
	0x6c,0x73,0x2e,0x76,0x61,0x6c,0x75,0x65,0x29,0x3b,0x0d,0x0a,0x20,0x20,0x20,0x20, /* ls.value);..     */ \
	0x20,0x77,0x69,0x6e,0x64,0x6f,0x77,0x2e,0x6f,0x70,0x65,0x6e,0x65,0x72,0x2e,0x61, /*  window.opener.a */ \
	0x63,0x63,0x65,0x73,0x73,0x2e,0x70,0x75,0x73,0x68,0x28,0x64,0x6f,0x63,0x75,0x6d, /* ccess.push(docum */ \
	0x65,0x6e,0x74,0x2e,0x65,0x64,0x69,0x74,0x2e,0x61,0x63,0x63,0x65,0x73,0x2e,0x76, /* ent.edit.acces.v */ \
	0x61,0x6c,0x75,0x65,0x29,0x3b,0x0d,0x0a,0x20,0x20,0x7d,0x0d,0x0a,0x20,0x20,0x65, /* alue);..  }..  e */ \
	0x6c,0x73,0x65,0x0d,0x0a,0x20,0x20,0x7b,0x0d,0x0a,0x20,0x20,0x20,0x20,0x20,0x77, /* lse..  {..     w */ \
	0x69,0x6e,0x64,0x6f,0x77,0x2e,0x6f,0x70,0x65,0x6e,0x65,0x72,0x2e,0x63,0x61,0x6c, /* indow.opener.cal */ \
	0x6c,0x73,0x69,0x67,0x6e,0x2e,0x73,0x70,0x6c,0x69,0x63,0x65,0x20,0x28,0x64,0x6f, /* lsign.splice (do */ \
	0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x65,0x64,0x69,0x74,0x2e,0x70,0x6f,0x73,0x69, /* cument.edit.posi */ \
	0x74,0x69,0x6f,0x6e,0x2e,0x76,0x61,0x6c,0x75,0x65,0x2c,0x30,0x2c,0x64,0x6f,0x63, /* tion.value,0,doc */ \
	0x75,0x6d,0x65,0x6e,0x74,0x2e,0x65,0x64,0x69,0x74,0x2e,0x63,0x61,0x6c,0x6c,0x73, /* ument.edit.calls */ \
	0x2e,0x76,0x61,0x6c,0x75,0x65,0x29,0x3b,0x0d,0x0a,0x20,0x20,0x20,0x20,0x20,0x77, /* .value);..     w */ \
	0x69,0x6e,0x64,0x6f,0x77,0x2e,0x6f,0x70,0x65,0x6e,0x65,0x72,0x2e,0x61,0x63,0x63, /* indow.opener.acc */ \
	0x65,0x73,0x73,0x2e,0x73,0x70,0x6c,0x69,0x63,0x65,0x28,0x64,0x6f,0x63,0x75,0x6d, /* ess.splice(docum */ \
	0x65,0x6e,0x74,0x2e,0x65,0x64,0x69,0x74,0x2e,0x70,0x6f,0x73,0x69,0x74,0x69,0x6f, /* ent.edit.positio */ \
	0x6e,0x2e,0x76,0x61,0x6c,0x75,0x65,0x2c,0x30,0x2c,0x64,0x6f,0x63,0x75,0x6d,0x65, /* n.value,0,docume */ \
	0x6e,0x74,0x2e,0x65,0x64,0x69,0x74,0x2e,0x61,0x63,0x63,0x65,0x73,0x2e,0x76,0x61, /* nt.edit.acces.va */ \
	0x6c,0x75,0x65,0x29,0x3b,0x0d,0x0a,0x20,0x20,0x7d,0x0d,0x0a,0x20,0x20,0x6e,0x20, /* lue);..  }..  n  */ \
	0x3d,0x20,0x77,0x69,0x6e,0x64,0x6f,0x77,0x2e,0x6f,0x70,0x65,0x6e,0x65,0x72,0x2e, /* = window.opener. */ \
	0x63,0x61,0x6c,0x6c,0x73,0x69,0x67,0x6e,0x2e,0x6c,0x65,0x6e,0x67,0x74,0x68,0x3b, /* callsign.length; */ \
	0x0d,0x0a,0x20,0x20,0x6c,0x6f,0x63,0x61,0x74,0x69,0x6f,0x6e,0x2e,0x72,0x65,0x6c, /* ..  location.rel */ \
	0x6f,0x61,0x64,0x28,0x29,0x3b,0x0d,0x0a,0x7d,0x0d,0x0a,0x0d,0x0a,0x66,0x75,0x6e, /* oad();..}....fun */ \
	0x63,0x74,0x69,0x6f,0x6e,0x20,0x61,0x64,0x64,0x28,0x29,0x0d,0x0a,0x7b,0x0d,0x0a, /* ction add()..{.. */ \
	0x20,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x65,0x64,0x69,0x74,0x2e, /*   document.edit. */ \
	0x70,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x2e,0x76,0x61,0x6c,0x75,0x65,0x20,0x3d, /* position.value = */ \
	0x20,0x2d,0x31,0x3b,0x0d,0x0a,0x20,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74, /*  -1;..  document */ \
	0x2e,0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28, /* .getElementById( */ \
	0x27,0x41,0x44,0x44,0x27,0x29,0x2e,0x73,0x74,0x79,0x6c,0x65,0x2e,0x64,0x69,0x73, /* 'ADD').style.dis */ \
	0x70,0x6c,0x61,0x79,0x20,0x3d,0x20,0x27,0x62,0x6c,0x6f,0x63,0x6b,0x27,0x3b,0x0d, /* play = 'block';. */ \
	0x0a,0x20,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x67,0x65,0x74,0x45, /* .  document.getE */ \
	0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28,0x27,0x45,0x44,0x49,0x54  /* lementById('EDIT */
#define DATACHUNK000026 \
	0x27,0x29,0x2e,0x73,0x74,0x79,0x6c,0x65,0x2e,0x64,0x69,0x73,0x70,0x6c,0x61,0x79, /* ').style.display */ \
	0x20,0x3d,0x20,0x27,0x6e,0x6f,0x6e,0x65,0x27,0x3b,0x0d,0x0a,0x7d,0x0d,0x0a,0x0d, /*  = 'none';..}... */ \
	0x0a,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x20,0x65,0x64,0x74,0x28,0x61,0x29, /* .function edt(a) */ \
	0x0d,0x0a,0x7b,0x0d,0x0a,0x20,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e, /* ..{..  document. */ \
	0x65,0x64,0x69,0x74,0x2e,0x63,0x61,0x6c,0x6c,0x65,0x2e,0x76,0x61,0x6c,0x75,0x65, /* edit.calle.value */ \
	0x20,0x3d,0x20,0x77,0x69,0x6e,0x64,0x6f,0x77,0x2e,0x6f,0x70,0x65,0x6e,0x65,0x72, /*  = window.opener */ \
	0x2e,0x63,0x61,0x6c,0x6c,0x73,0x69,0x67,0x6e,0x5b,0x61,0x5d,0x3b,0x0d,0x0a,0x20, /* .callsign[a];..  */ \
	0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x65,0x64,0x69,0x74,0x2e,0x70, /*  document.edit.p */ \
	0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x2e,0x76,0x61,0x6c,0x75,0x65,0x20,0x3d,0x20, /* osition.value =  */ \
	0x61,0x3b,0x0d,0x0a,0x20,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x67, /* a;..  document.g */ \
	0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28,0x27,0x45, /* etElementById('E */ \
	0x44,0x49,0x54,0x27,0x29,0x2e,0x73,0x74,0x79,0x6c,0x65,0x2e,0x64,0x69,0x73,0x70, /* DIT').style.disp */ \
	0x6c,0x61,0x79,0x20,0x3d,0x20,0x27,0x62,0x6c,0x6f,0x63,0x6b,0x27,0x3b,0x0d,0x0a, /* lay = 'block';.. */ \
	0x20,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x67,0x65,0x74,0x45,0x6c, /*   document.getEl */ \
	0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28,0x27,0x41,0x44,0x44,0x27,0x29, /* ementById('ADD') */ \
	0x2e,0x73,0x74,0x79,0x6c,0x65,0x2e,0x64,0x69,0x73,0x70,0x6c,0x61,0x79,0x20,0x3d, /* .style.display = */ \
	0x20,0x27,0x6e,0x6f,0x6e,0x65,0x27,0x3b,0x0d,0x0a,0x7d,0x0d,0x0a,0x0d,0x0a,0x0d, /*  'none';..}..... */ \
	0x0a,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x20,0x69,0x6e,0x73,0x28,0x61,0x29, /* .function ins(a) */ \
	0x0d,0x0a,0x7b,0x0d,0x0a,0x20,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e, /* ..{..  document. */ \
	0x65,0x64,0x69,0x74,0x2e,0x70,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x2e,0x76,0x61, /* edit.position.va */ \
	0x6c,0x75,0x65,0x20,0x3d,0x20,0x61,0x3b,0x0d,0x0a,0x20,0x20,0x64,0x6f,0x63,0x75, /* lue = a;..  docu */ \
	0x6d,0x65,0x6e,0x74,0x2e,0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42, /* ment.getElementB */ \
	0x79,0x49,0x64,0x28,0x27,0x41,0x44,0x44,0x27,0x29,0x2e,0x73,0x74,0x79,0x6c,0x65, /* yId('ADD').style */ \
	0x2e,0x64,0x69,0x73,0x70,0x6c,0x61,0x79,0x20,0x3d,0x20,0x27,0x62,0x6c,0x6f,0x63, /* .display = 'bloc */ \
	0x6b,0x27,0x3b,0x0d,0x0a,0x20,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e, /* k';..  document. */ \
	0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28,0x27, /* getElementById(' */ \
	0x45,0x44,0x49,0x54,0x27,0x29,0x2e,0x73,0x74,0x79,0x6c,0x65,0x2e,0x64,0x69,0x73, /* EDIT').style.dis */ \
	0x70,0x6c,0x61,0x79,0x20,0x3d,0x20,0x27,0x6e,0x6f,0x6e,0x65,0x27,0x3b,0x0d,0x0a, /* play = 'none';.. */ \
	0x7d,0x0d,0x0a,0x0d,0x0a,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x20,0x72,0x65, /* }....function re */ \
	0x70,0x28,0x29,0x0d,0x0a,0x7b,0x0d,0x0a,0x20,0x20,0x77,0x69,0x6e,0x64,0x6f,0x77, /* p()..{..  window */ \
	0x2e,0x6f,0x70,0x65,0x6e,0x65,0x72,0x2e,0x63,0x61,0x6c,0x6c,0x73,0x69,0x67,0x6e, /* .opener.callsign */ \
	0x2e,0x73,0x70,0x6c,0x69,0x63,0x65,0x28,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74, /* .splice(document */ \
	0x2e,0x65,0x64,0x69,0x74,0x2e,0x70,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x2e,0x76, /* .edit.position.v */ \
	0x61,0x6c,0x75,0x65,0x2c,0x31,0x2c,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e, /* alue,1,document. */ \
	0x65,0x64,0x69,0x74,0x2e,0x63,0x61,0x6c,0x6c,0x65,0x2e,0x76,0x61,0x6c,0x75,0x65, /* edit.calle.value */ \
	0x29,0x3b,0x0d,0x0a,0x20,0x20,0x77,0x69,0x6e,0x64,0x6f,0x77,0x2e,0x6f,0x70,0x65, /* );..  window.ope */ \
	0x6e,0x65,0x72,0x2e,0x61,0x63,0x63,0x65,0x73,0x73,0x2e,0x73,0x70,0x6c,0x69,0x63, /* ner.access.splic */ \
	0x65,0x28,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x65,0x64,0x69,0x74,0x2e, /* e(document.edit. */ \
	0x70,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x2e,0x76,0x61,0x6c,0x75,0x65,0x2c,0x31, /* position.value,1 */ \
	0x2c,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x65,0x64,0x69,0x74,0x2e,0x61, /* ,document.edit.a */ \
	0x63,0x63,0x65,0x65,0x2e,0x76,0x61,0x6c,0x75,0x65,0x29,0x3b,0x0d,0x0a,0x20,0x20, /* ccee.value);..   */ \
	0x6e,0x20,0x3d,0x20,0x77,0x69,0x6e,0x64,0x6f,0x77,0x2e,0x6f,0x70,0x65,0x6e,0x65, /* n = window.opene */ \
	0x72,0x2e,0x63,0x61,0x6c,0x6c,0x73,0x69,0x67,0x6e,0x2e,0x6c,0x65,0x6e,0x67,0x74, /* r.callsign.lengt */ \
	0x68,0x3b,0x0d,0x0a,0x20,0x20,0x6c,0x6f,0x63,0x61,0x74,0x69,0x6f,0x6e,0x2e,0x72, /* h;..  location.r */ \
	0x65,0x6c,0x6f,0x61,0x64,0x28,0x29,0x3b,0x0d,0x0a,0x7d,0x0d,0x0a,0x0d,0x0a,0x2f, /* eload();..}..../ */ \
	0x2f,0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74,0x3e,0x0d, /* /-->..</script>. */ \
	0x0a,0x3c,0x74,0x61,0x62,0x6c,0x65,0x20,0x62,0x6f,0x72,0x64,0x65,0x72,0x3d,0x32, /* .<table border=2 */ \
	0x3e,0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x74,0x79,0x70,0x65,0x3d, /* >..<script type= */ \
	0x22,0x74,0x65,0x78,0x74,0x2f,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74, /* "text/javascript */ \
	0x22,0x20,0x6c,0x61,0x6e,0x67,0x75,0x61,0x67,0x65,0x3d,0x22,0x4a,0x61,0x76,0x61, /* " language="Java */ \
	0x53,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x0d,0x0a,0x3c,0x21,0x2d,0x2d,0x0d,0x0a, /* Script">..<!--.. */ \
	0x0d,0x0a,0x20,0x6e,0x20,0x3d,0x20,0x77,0x69,0x6e,0x64,0x6f,0x77,0x2e,0x6f,0x70, /* .. n = window.op */ \
	0x65,0x6e,0x65,0x72,0x2e,0x63,0x61,0x6c,0x6c,0x73,0x69,0x67,0x6e,0x2e,0x6c,0x65, /* ener.callsign.le */ \
	0x6e,0x67,0x74,0x68,0x3b,0x0d,0x0a,0x20,0x69,0x66,0x20,0x28,0x6e,0x20,0x3e,0x20, /* ngth;.. if (n >  */ \
	0x30,0x29,0x0d,0x0a,0x20,0x7b,0x0d,0x0a,0x20,0x20,0x66,0x6f,0x72,0x28,0x69,0x3d, /* 0).. {..  for(i= */ \
	0x30,0x3b,0x20,0x69,0x3c,0x6e,0x3b,0x20,0x69,0x2b,0x2b,0x29,0x7b,0x0d,0x0a,0x20, /* 0; i<n; i++){..  */ \
	0x20,0x20,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x77,0x72,0x69,0x74, /*    document.writ */ \
	0x65,0x28,0x22,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x22,0x29,0x3b,0x0d,0x0a, /* e("<tr><td>");.. */ \
	0x20,0x20,0x20,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x77,0x72,0x69, /*     document.wri */ \
	0x74,0x65,0x28,0x77,0x69,0x6e,0x64,0x6f,0x77,0x2e,0x6f,0x70,0x65,0x6e,0x65,0x72, /* te(window.opener */ \
	0x2e,0x63,0x61,0x6c,0x6c,0x73,0x69,0x67,0x6e,0x5b,0x69,0x5d,0x29,0x3b,0x0d,0x0a, /* .callsign[i]);.. */ \
	0x20,0x20,0x20,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x77,0x72,0x69, /*     document.wri */ \
	0x74,0x65,0x28,0x22,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x22,0x29,0x3b, /* te("</td><td>"); */ \
	0x0d,0x0a,0x20,0x20,0x20,0x20,0x69,0x66,0x20,0x28,0x77,0x69,0x6e,0x64,0x6f,0x77  /* ..    if (window */
#define DATACHUNK000027 \
	0x2e,0x6f,0x70,0x65,0x6e,0x65,0x72,0x2e,0x61,0x63,0x63,0x65,0x73,0x73,0x5b,0x69, /* .opener.access[i */ \
	0x5d,0x20,0x3d,0x3d,0x20,0x22,0x41,0x4c,0x4c,0x4f,0x57,0x22,0x29,0x0d,0x0a,0x20, /* ] == "ALLOW")..  */ \
	0x20,0x20,0x20,0x7b,0x20,0x0d,0x0a,0x20,0x20,0x09,0x64,0x6f,0x63,0x75,0x6d,0x65, /*    { ..  .docume */ \
	0x6e,0x74,0x2e,0x77,0x72,0x69,0x74,0x65,0x28,0x22,0x41,0x4c,0x4c,0x4f,0x57,0x22, /* nt.write("ALLOW" */ \
	0x29,0x3b,0x0d,0x0a,0x20,0x20,0x20,0x20,0x7d,0x20,0x65,0x6c,0x73,0x65,0x20,0x7b, /* );..    } else { */ \
	0x0d,0x0a,0x09,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x77,0x72,0x69,0x74, /* ...document.writ */ \
	0x65,0x28,0x22,0x44,0x45,0x4e,0x59,0x22,0x29,0x3b,0x0d,0x0a,0x20,0x20,0x20,0x20, /* e("DENY");..     */ \
	0x7d,0x0d,0x0a,0x20,0x20,0x20,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e, /* }..    document. */ \
	0x77,0x72,0x69,0x74,0x65,0x28,0x22,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e, /* write("</td><td> */ \
	0x22,0x29,0x3b,0x0d,0x0a,0x20,0x20,0x20,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e, /* ");..    documen */ \
	0x74,0x2e,0x77,0x72,0x69,0x74,0x65,0x28,0x22,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20, /* t.write("<input  */ \
	0x74,0x79,0x70,0x65,0x3d,0x5c,0x22,0x62,0x75,0x74,0x74,0x6f,0x6e,0x5c,0x22,0x20, /* type=\"button\"  */ \
	0x76,0x61,0x6c,0x75,0x65,0x3d,0x5c,0x22,0x44,0x65,0x6c,0x5c,0x22,0x20,0x6f,0x6e, /* value=\"Del\" on */ \
	0x43,0x6c,0x69,0x63,0x6b,0x3d,0x5c,0x22,0x64,0x65,0x6c,0x28,0x22,0x29,0x3b,0x0d, /* Click=\"del(");. */ \
	0x0a,0x20,0x20,0x20,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x77,0x72, /* .    document.wr */ \
	0x69,0x74,0x65,0x28,0x69,0x29,0x3b,0x0d,0x0a,0x20,0x20,0x20,0x20,0x64,0x6f,0x63, /* ite(i);..    doc */ \
	0x75,0x6d,0x65,0x6e,0x74,0x2e,0x77,0x72,0x69,0x74,0x65,0x28,0x22,0x29,0x5c,0x22, /* ument.write(")\" */ \
	0x3e,0x22,0x29,0x3b,0x0d,0x0a,0x20,0x20,0x20,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65, /* >");..    docume */ \
	0x6e,0x74,0x2e,0x77,0x72,0x69,0x74,0x65,0x28,0x22,0x3c,0x69,0x6e,0x70,0x75,0x74, /* nt.write("<input */ \
	0x20,0x74,0x79,0x70,0x65,0x3d,0x5c,0x22,0x62,0x75,0x74,0x74,0x6f,0x6e,0x5c,0x22, /*  type=\"button\" */ \
	0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x5c,0x22,0x49,0x6e,0x73,0x5c,0x22,0x20,0x6f, /*  value=\"Ins\" o */ \
	0x6e,0x43,0x6c,0x69,0x63,0x6b,0x3d,0x5c,0x22,0x69,0x6e,0x73,0x28,0x22,0x29,0x3b, /* nClick=\"ins("); */ \
	0x0d,0x0a,0x20,0x20,0x20,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x77, /* ..    document.w */ \
	0x72,0x69,0x74,0x65,0x28,0x69,0x29,0x3b,0x0d,0x0a,0x20,0x20,0x20,0x20,0x64,0x6f, /* rite(i);..    do */ \
	0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x77,0x72,0x69,0x74,0x65,0x28,0x22,0x29,0x5c, /* cument.write(")\ */ \
	0x22,0x3e,0x22,0x29,0x3b,0x0d,0x0a,0x20,0x20,0x20,0x20,0x64,0x6f,0x63,0x75,0x6d, /* ">");..    docum */ \
	0x65,0x6e,0x74,0x2e,0x77,0x72,0x69,0x74,0x65,0x28,0x22,0x3c,0x69,0x6e,0x70,0x75, /* ent.write("<inpu */ \
	0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x5c,0x22,0x62,0x75,0x74,0x74,0x6f,0x6e,0x5c, /* t type=\"button\ */ \
	0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x5c,0x22,0x45,0x64,0x69,0x74,0x5c,0x22, /* " value=\"Edit\" */ \
	0x20,0x6f,0x6e,0x43,0x6c,0x69,0x63,0x6b,0x3d,0x5c,0x22,0x65,0x64,0x74,0x28,0x22, /*  onClick=\"edt(" */ \
	0x29,0x3b,0x0d,0x0a,0x20,0x20,0x20,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74, /* );..    document */ \
	0x2e,0x77,0x72,0x69,0x74,0x65,0x28,0x69,0x29,0x3b,0x0d,0x0a,0x20,0x20,0x20,0x20, /* .write(i);..     */ \
	0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x77,0x72,0x69,0x74,0x65,0x28,0x22, /* document.write(" */ \
	0x29,0x5c,0x22,0x3e,0x22,0x29,0x3b,0x0d,0x0a,0x20,0x20,0x20,0x20,0x69,0x66,0x20, /* )\">");..    if  */ \
	0x28,0x69,0x20,0x3d,0x3d,0x20,0x28,0x6e,0x2d,0x31,0x29,0x29,0x0d,0x0a,0x20,0x20, /* (i == (n-1))..   */ \
	0x20,0x20,0x20,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x77,0x72,0x69, /*     document.wri */ \
	0x74,0x65,0x28,0x22,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d, /* te("<input type= */ \
	0x5c,0x22,0x62,0x75,0x74,0x74,0x6f,0x6e,0x5c,0x22,0x20,0x76,0x61,0x6c,0x75,0x65, /* \"button\" value */ \
	0x3d,0x5c,0x22,0x41,0x70,0x70,0x65,0x6e,0x64,0x5c,0x22,0x20,0x6f,0x6e,0x43,0x6c, /* =\"Append\" onCl */ \
	0x69,0x63,0x6b,0x3d,0x5c,0x22,0x61,0x64,0x64,0x28,0x29,0x5c,0x22,0x3e,0x22,0x29, /* ick=\"add()\">") */ \
	0x3b,0x0d,0x0a,0x20,0x20,0x20,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e, /* ;..    document. */ \
	0x77,0x72,0x69,0x74,0x65,0x28,0x22,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72, /* write("</td></tr */ \
	0x3e,0x22,0x29,0x3b,0x0d,0x0a,0x20,0x20,0x7d,0x0d,0x0a,0x20,0x7d,0x20,0x65,0x6c, /* >");..  }.. } el */ \
	0x73,0x65,0x20,0x7b,0x0d,0x0a,0x20,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74, /* se {..  document */ \
	0x2e,0x77,0x72,0x69,0x74,0x65,0x28,0x22,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e, /* .write("<tr><td> */ \
	0x4e,0x6f,0x20,0x45,0x6e,0x74,0x72,0x79,0x20,0x28,0x4e,0x6f,0x20,0x41,0x63,0x63, /* No Entry (No Acc */ \
	0x65,0x73,0x73,0x20,0x66,0x69,0x6c,0x65,0x29,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f, /* ess file)</td></ */ \
	0x74,0x72,0x3e,0x22,0x29,0x3b,0x0d,0x0a,0x20,0x7d,0x0d,0x0a,0x2f,0x2f,0x20,0x2d, /* tr>");.. }..// - */ \
	0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74,0x3e,0x0d,0x0a,0x3c, /* ->..</script>..< */ \
	0x2f,0x74,0x61,0x62,0x6c,0x65,0x3e,0x0d,0x0a,0x3c,0x62,0x72,0x3e,0x0d,0x0a,0x3c, /* /table>..<br>..< */ \
	0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22, /* /div>..<div id=" */ \
	0x53,0x41,0x56,0x45,0x22,0x3e,0x0d,0x0a,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e, /* SAVE">..&nbsp;&n */ \
	0x62,0x73,0x70,0x3b,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d, /* bsp;<input type= */ \
	0x22,0x62,0x75,0x74,0x74,0x6f,0x6e,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22, /* "button" value=" */ \
	0x43,0x61,0x6e,0x63,0x65,0x6c,0x22,0x20,0x6f,0x6e,0x43,0x6c,0x69,0x63,0x6b,0x3d, /* Cancel" onClick= */ \
	0x22,0x63,0x61,0x6e,0x63,0x65,0x6c,0x28,0x29,0x22,0x3e,0x20,0x3c,0x69,0x6e,0x70, /* "cancel()"> <inp */ \
	0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x62,0x75,0x74,0x74,0x6f,0x6e,0x22, /* ut type="button" */ \
	0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x43,0x6c,0x6f,0x73,0x65,0x22,0x20,0x6f, /*  value="Close" o */ \
	0x6e,0x43,0x6c,0x69,0x63,0x6b,0x3d,0x22,0x77,0x69,0x6e,0x64,0x6f,0x77,0x2e,0x63, /* nClick="window.c */ \
	0x6c,0x6f,0x73,0x65,0x28,0x29,0x22,0x3e,0x20,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20, /* lose()"> <input  */ \
	0x74,0x79,0x70,0x65,0x3d,0x22,0x73,0x75,0x62,0x6d,0x69,0x74,0x22,0x20,0x76,0x61, /* type="submit" va */ \
	0x6c,0x75,0x65,0x3d,0x22,0x53,0x61,0x76,0x65,0x22,0x3e,0x0d,0x0a,0x3c,0x2f,0x64, /* lue="Save">..</d */ \
	0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x46,0x49, /* iv>..<div id="FI */ \
	0x52,0x53,0x54,0x22,0x3e,0x0d,0x0a,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62  /* RST">..&nbsp;&nb */
#define DATACHUNK000028 \
	0x73,0x70,0x3b,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22, /* sp;<input type=" */ \
	0x62,0x75,0x74,0x74,0x6f,0x6e,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x43, /* button" value="C */ \
	0x61,0x6e,0x63,0x65,0x6c,0x22,0x20,0x6f,0x6e,0x43,0x6c,0x69,0x63,0x6b,0x3d,0x22, /* ancel" onClick=" */ \
	0x63,0x61,0x6e,0x63,0x65,0x6c,0x28,0x29,0x22,0x3e,0x20,0x3c,0x69,0x6e,0x70,0x75, /* cancel()"> <inpu */ \
	0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x62,0x75,0x74,0x74,0x6f,0x6e,0x22,0x20, /* t type="button"  */ \
	0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x43,0x6c,0x6f,0x73,0x65,0x22,0x20,0x6f,0x6e, /* value="Close" on */ \
	0x43,0x6c,0x69,0x63,0x6b,0x3d,0x22,0x77,0x69,0x6e,0x64,0x6f,0x77,0x2e,0x63,0x6c, /* Click="window.cl */ \
	0x6f,0x73,0x65,0x28,0x29,0x22,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d, /* ose()">..</div>. */ \
	0x0a,0x3c,0x62,0x72,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22, /* .<br>..<div id=" */ \
	0x41,0x44,0x44,0x22,0x3e,0x0d,0x0a,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62, /* ADD">..&nbsp;&nb */ \
	0x73,0x70,0x3b,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22, /* sp;<input type=" */ \
	0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x63,0x61,0x6c,0x6c, /* text" name="call */ \
	0x73,0x22,0x3e,0x0d,0x0a,0x3c,0x73,0x65,0x6c,0x65,0x63,0x74,0x20,0x6e,0x61,0x6d, /* s">..<select nam */ \
	0x65,0x3d,0x22,0x61,0x63,0x63,0x65,0x73,0x22,0x3e,0x0d,0x0a,0x3c,0x6f,0x70,0x74, /* e="acces">..<opt */ \
	0x69,0x6f,0x6e,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x41,0x4c,0x4c,0x4f,0x57, /* ion value="ALLOW */ \
	0x22,0x3e,0x41,0x4c,0x4c,0x4f,0x57,0x0d,0x0a,0x3c,0x6f,0x70,0x74,0x69,0x6f,0x6e, /* ">ALLOW..<option */ \
	0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x44,0x45,0x4e,0x59,0x22,0x3e,0x44,0x45, /*  value="DENY">DE */ \
	0x4e,0x59,0x0d,0x0a,0x3c,0x2f,0x73,0x65,0x6c,0x65,0x63,0x74,0x3e,0x0d,0x0a,0x3c, /* NY..</select>..< */ \
	0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x62,0x75,0x74,0x74, /* input type="butt */ \
	0x6f,0x6e,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x49,0x6e,0x73,0x65,0x72, /* on" value="Inser */ \
	0x74,0x2f,0x41,0x70,0x70,0x65,0x6e,0x64,0x22,0x20,0x6f,0x6e,0x43,0x6c,0x69,0x63, /* t/Append" onClic */ \
	0x6b,0x3d,0x22,0x69,0x6e,0x73,0x65,0x72,0x74,0x28,0x29,0x22,0x3e,0x0d,0x0a,0x3c, /* k="insert()">..< */ \
	0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x62,0x75,0x74,0x74, /* input type="butt */ \
	0x6f,0x6e,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x43,0x61,0x6e,0x63,0x65, /* on" value="Cance */ \
	0x6c,0x22,0x20,0x6f,0x6e,0x43,0x6c,0x69,0x63,0x6b,0x3d,0x22,0x63,0x61,0x6e,0x63, /* l" onClick="canc */ \
	0x65,0x6c,0x28,0x29,0x22,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a, /* el()">..</div>.. */ \
	0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x45,0x44,0x49,0x54,0x22, /* ..<div id="EDIT" */ \
	0x3e,0x0d,0x0a,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c, /* >..&nbsp;&nbsp;< */ \
	0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74, /* input type="text */ \
	0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x63,0x61,0x6c,0x6c,0x65,0x22,0x3e,0x0d, /* " name="calle">. */ \
	0x0a,0x3c,0x73,0x65,0x6c,0x65,0x63,0x74,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x61, /* .<select name="a */ \
	0x63,0x63,0x65,0x65,0x22,0x3e,0x0d,0x0a,0x3c,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x20, /* ccee">..<option  */ \
	0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x41,0x4c,0x4c,0x4f,0x57,0x22,0x3e,0x41,0x4c, /* value="ALLOW">AL */ \
	0x4c,0x4f,0x57,0x0d,0x0a,0x3c,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x20,0x76,0x61,0x6c, /* LOW..<option val */ \
	0x75,0x65,0x3d,0x22,0x44,0x45,0x4e,0x59,0x22,0x3e,0x44,0x45,0x4e,0x59,0x0d,0x0a, /* ue="DENY">DENY.. */ \
	0x3c,0x2f,0x73,0x65,0x6c,0x65,0x63,0x74,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75, /* </select>..<inpu */ \
	0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x62,0x75,0x74,0x74,0x6f,0x6e,0x22,0x20, /* t type="button"  */ \
	0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x52,0x65,0x70,0x6c,0x61,0x63,0x65,0x22,0x20, /* value="Replace"  */ \
	0x6f,0x6e,0x43,0x6c,0x69,0x63,0x6b,0x3d,0x22,0x72,0x65,0x70,0x28,0x29,0x22,0x3e, /* onClick="rep()"> */ \
	0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x62, /* ..<input type="b */ \
	0x75,0x74,0x74,0x6f,0x6e,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x43,0x61, /* utton" value="Ca */ \
	0x6e,0x63,0x65,0x6c,0x22,0x20,0x6f,0x6e,0x43,0x6c,0x69,0x63,0x6b,0x3d,0x22,0x63, /* ncel" onClick="c */ \
	0x61,0x6e,0x63,0x65,0x6c,0x28,0x29,0x22,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75, /* ancel()">..<inpu */ \
	0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x68,0x69,0x64,0x64,0x65,0x6e,0x22,0x20, /* t type="hidden"  */ \
	0x6e,0x61,0x6d,0x65,0x3d,0x22,0x70,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x22,0x3e, /* name="position"> */ \
	0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x64,0x69,0x76, /* ..</div>....<div */ \
	0x20,0x69,0x64,0x3d,0x22,0x54,0x45,0x58,0x54,0x22,0x3e,0x0d,0x0a,0x3c,0x74,0x65, /*  id="TEXT">..<te */ \
	0x78,0x74,0x61,0x72,0x65,0x61,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x61,0x63,0x63, /* xtarea name="acc */ \
	0x74,0x22,0x20,0x63,0x6f,0x6c,0x73,0x3d,0x22,0x35,0x30,0x22,0x20,0x72,0x6f,0x77, /* t" cols="50" row */ \
	0x73,0x3d,0x22,0x31,0x30,0x22,0x3e,0x0d,0x0a,0x3c,0x2f,0x74,0x65,0x78,0x74,0x61, /* s="10">..</texta */ \
	0x72,0x65,0x61,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a, /* rea>..</div>.... */ \
	0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65, /* <script type="te */ \
	0x78,0x74,0x2f,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x20,0x6c, /* xt/javascript" l */ \
	0x61,0x6e,0x67,0x75,0x61,0x67,0x65,0x3d,0x22,0x4a,0x61,0x76,0x61,0x53,0x63,0x72, /* anguage="JavaScr */ \
	0x69,0x70,0x74,0x22,0x3e,0x0d,0x0a,0x3c,0x21,0x2d,0x2d,0x0d,0x0a,0x20,0x6e,0x20, /* ipt">..<!--.. n  */ \
	0x3d,0x20,0x77,0x69,0x6e,0x64,0x6f,0x77,0x2e,0x6f,0x70,0x65,0x6e,0x65,0x72,0x2e, /* = window.opener. */ \
	0x63,0x61,0x6c,0x6c,0x73,0x69,0x67,0x6e,0x2e,0x6c,0x65,0x6e,0x67,0x74,0x68,0x3b, /* callsign.length; */ \
	0x0d,0x0a,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x65,0x64,0x69,0x74, /* .. document.edit */ \
	0x2e,0x61,0x63,0x63,0x74,0x2e,0x76,0x61,0x6c,0x75,0x65,0x20,0x3d,0x20,0x22,0x22, /* .acct.value = "" */ \
	0x3b,0x0d,0x0a,0x20,0x66,0x6f,0x72,0x20,0x28,0x69,0x20,0x3d,0x20,0x30,0x20,0x3b, /* ;.. for (i = 0 ; */ \
	0x20,0x69,0x20,0x3c,0x20,0x6e,0x20,0x3b,0x20,0x69,0x2b,0x2b,0x29,0x0d,0x0a,0x20, /*  i < n ; i++)..  */ \
	0x7b,0x0d,0x0a,0x20,0x20,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x65, /* {..   document.e */ \
	0x64,0x69,0x74,0x2e,0x61,0x63,0x63,0x74,0x2e,0x76,0x61,0x6c,0x75,0x65,0x20,0x2b, /* dit.acct.value + */ \
	0x3d,0x20,0x20,0x77,0x69,0x6e,0x64,0x6f,0x77,0x2e,0x6f,0x70,0x65,0x6e,0x65,0x72  /* =  window.opener */
#define DATACHUNK000029 \
	0x2e,0x63,0x61,0x6c,0x6c,0x73,0x69,0x67,0x6e,0x5b,0x69,0x5d,0x3b,0x0d,0x0a,0x20, /* .callsign[i];..  */ \
	0x20,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x65,0x64,0x69,0x74,0x2e, /*   document.edit. */ \
	0x61,0x63,0x63,0x74,0x2e,0x76,0x61,0x6c,0x75,0x65,0x20,0x2b,0x3d,0x20,0x20,0x22, /* acct.value +=  " */ \
	0x2c,0x22,0x3b,0x0d,0x0a,0x20,0x20,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74, /* ,";..   document */ \
	0x2e,0x65,0x64,0x69,0x74,0x2e,0x61,0x63,0x63,0x74,0x2e,0x76,0x61,0x6c,0x75,0x65, /* .edit.acct.value */ \
	0x20,0x2b,0x3d,0x20,0x20,0x77,0x69,0x6e,0x64,0x6f,0x77,0x2e,0x6f,0x70,0x65,0x6e, /*  +=  window.open */ \
	0x65,0x72,0x2e,0x61,0x63,0x63,0x65,0x73,0x73,0x5b,0x69,0x5d,0x3b,0x0d,0x0a,0x20, /* er.access[i];..  */ \
	0x20,0x20,0x69,0x66,0x20,0x28,0x69,0x20,0x21,0x3d,0x20,0x28,0x6e,0x2d,0x31,0x29, /*   if (i != (n-1) */ \
	0x29,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x65,0x64,0x69,0x74,0x2e, /* ) document.edit. */ \
	0x61,0x63,0x63,0x74,0x2e,0x76,0x61,0x6c,0x75,0x65,0x20,0x2b,0x3d,0x20,0x20,0x22, /* acct.value +=  " */ \
	0x2c,0x22,0x3b,0x0d,0x0a,0x20,0x20,0x20,0x65,0x6c,0x73,0x65,0x20,0x64,0x6f,0x63, /* ,";..   else doc */ \
	0x75,0x6d,0x65,0x6e,0x74,0x2e,0x65,0x64,0x69,0x74,0x2e,0x61,0x63,0x63,0x74,0x2e, /* ument.edit.acct. */ \
	0x76,0x61,0x6c,0x75,0x65,0x20,0x2b,0x3d,0x20,0x20,0x22,0x3b,0x22,0x3b,0x0d,0x0a, /* value +=  ";";.. */ \
	0x20,0x7d,0x0d,0x0a,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x67,0x65,0x74, /*  }..document.get */ \
	0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28,0x27,0x45,0x44,0x49, /* ElementById('EDI */ \
	0x54,0x27,0x29,0x2e,0x73,0x74,0x79,0x6c,0x65,0x2e,0x64,0x69,0x73,0x70,0x6c,0x61, /* T').style.displa */ \
	0x79,0x20,0x3d,0x20,0x27,0x6e,0x6f,0x6e,0x65,0x27,0x3b,0x0d,0x0a,0x69,0x66,0x20, /* y = 'none';..if  */ \
	0x28,0x6e,0x20,0x3e,0x20,0x30,0x29,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74, /* (n > 0) document */ \
	0x2e,0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28, /* .getElementById( */ \
	0x27,0x41,0x44,0x44,0x27,0x29,0x2e,0x73,0x74,0x79,0x6c,0x65,0x2e,0x64,0x69,0x73, /* 'ADD').style.dis */ \
	0x70,0x6c,0x61,0x79,0x20,0x3d,0x20,0x27,0x6e,0x6f,0x6e,0x65,0x27,0x3b,0x0d,0x0a, /* play = 'none';.. */ \
	0x65,0x6c,0x73,0x65,0x0d,0x0a,0x7b,0x0d,0x0a,0x20,0x20,0x64,0x6f,0x63,0x75,0x6d, /* else..{..  docum */ \
	0x65,0x6e,0x74,0x2e,0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79, /* ent.getElementBy */ \
	0x49,0x64,0x28,0x27,0x41,0x44,0x44,0x27,0x29,0x2e,0x73,0x74,0x79,0x6c,0x65,0x2e, /* Id('ADD').style. */ \
	0x64,0x69,0x73,0x70,0x6c,0x61,0x79,0x20,0x3d,0x20,0x27,0x62,0x6c,0x6f,0x63,0x6b, /* display = 'block */ \
	0x27,0x3b,0x0d,0x0a,0x20,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x65, /* ';..  document.e */ \
	0x64,0x69,0x74,0x2e,0x70,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x2e,0x76,0x61,0x6c, /* dit.position.val */ \
	0x75,0x65,0x20,0x3d,0x20,0x2d,0x31,0x3b,0x0d,0x0a,0x7d,0x0d,0x0a,0x64,0x6f,0x63, /* ue = -1;..}..doc */ \
	0x75,0x6d,0x65,0x6e,0x74,0x2e,0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74, /* ument.getElement */ \
	0x42,0x79,0x49,0x64,0x28,0x27,0x54,0x45,0x58,0x54,0x27,0x29,0x2e,0x73,0x74,0x79, /* ById('TEXT').sty */ \
	0x6c,0x65,0x2e,0x64,0x69,0x73,0x70,0x6c,0x61,0x79,0x20,0x3d,0x20,0x27,0x6e,0x6f, /* le.display = 'no */ \
	0x6e,0x65,0x27,0x3b,0x0d,0x0a,0x69,0x66,0x20,0x28,0x6e,0x20,0x3e,0x20,0x30,0x29, /* ne';..if (n > 0) */ \
	0x0d,0x0a,0x7b,0x0d,0x0a,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x67, /* ..{.. document.g */ \
	0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28,0x27,0x46, /* etElementById('F */ \
	0x49,0x52,0x53,0x54,0x27,0x29,0x2e,0x73,0x74,0x79,0x6c,0x65,0x2e,0x64,0x69,0x73, /* IRST').style.dis */ \
	0x70,0x6c,0x61,0x79,0x3d,0x22,0x6e,0x6f,0x6e,0x65,0x22,0x0d,0x0a,0x20,0x64,0x6f, /* play="none".. do */ \
	0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e, /* cument.getElemen */ \
	0x74,0x42,0x79,0x49,0x64,0x28,0x27,0x53,0x41,0x56,0x45,0x27,0x29,0x2e,0x73,0x74, /* tById('SAVE').st */ \
	0x79,0x6c,0x65,0x2e,0x64,0x69,0x73,0x70,0x6c,0x61,0x79,0x3d,0x22,0x62,0x6c,0x6f, /* yle.display="blo */ \
	0x63,0x6b,0x22,0x0d,0x0a,0x7d,0x0d,0x0a,0x65,0x6c,0x73,0x65,0x0d,0x0a,0x7b,0x0d, /* ck"..}..else..{. */ \
	0x0a,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x67,0x65,0x74,0x45,0x6c, /* . document.getEl */ \
	0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28,0x27,0x46,0x49,0x52,0x53,0x54, /* ementById('FIRST */ \
	0x27,0x29,0x2e,0x73,0x74,0x79,0x6c,0x65,0x2e,0x64,0x69,0x73,0x70,0x6c,0x61,0x79, /* ').style.display */ \
	0x3d,0x22,0x62,0x6c,0x6f,0x63,0x6b,0x22,0x0d,0x0a,0x20,0x64,0x6f,0x63,0x75,0x6d, /* ="block".. docum */ \
	0x65,0x6e,0x74,0x2e,0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79, /* ent.getElementBy */ \
	0x49,0x64,0x28,0x27,0x53,0x41,0x56,0x45,0x27,0x29,0x2e,0x73,0x74,0x79,0x6c,0x65, /* Id('SAVE').style */ \
	0x2e,0x64,0x69,0x73,0x70,0x6c,0x61,0x79,0x3d,0x22,0x6e,0x6f,0x6e,0x65,0x22,0x0d, /* .display="none". */ \
	0x0a,0x7d,0x0d,0x0a,0x2f,0x2f,0x20,0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63, /* .}..// -->..</sc */ \
	0x72,0x69,0x70,0x74,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x6f,0x72,0x6d,0x3e,0x0d,0x0a, /* ript>..</form>.. */ \
	0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e, /* ..~inc:footer.in */ \
	0x63,0x7e,0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0x5d,0x13,0x00,0x00,0x02,0x00, /* c~....3...]..... */ \
	0x00,0x00,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e, /* ..~inc:header.in */ \
	0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e, /* c~..<div id="con */ \
	0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x47,0x61, /* tent">....<h1>Ga */ \
	0x74,0x65,0x77,0x61,0x79,0x20,0x41,0x75,0x74,0x68,0x20,0x43,0x61,0x6c,0x6c,0x73, /* teway Auth Calls */ \
	0x69,0x67,0x6e,0x3c,0x2f,0x68,0x31,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x66,0x6f,0x72, /* ign</h1>....<for */ \
	0x6d,0x20,0x6d,0x65,0x74,0x68,0x6f,0x64,0x3d,0x22,0x70,0x6f,0x73,0x74,0x22,0x20, /* m method="post"  */ \
	0x61,0x63,0x74,0x69,0x6f,0x6e,0x3d,0x22,0x2f,0x70,0x72,0x6f,0x74,0x65,0x63,0x74, /* action="/protect */ \
	0x2f,0x67,0x61,0x74,0x65,0x77,0x61,0x79,0x61,0x75,0x74,0x68,0x2e,0x68,0x74,0x6d, /* /gatewayauth.htm */ \
	0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x61,0x75,0x74,0x68,0x22,0x3e,0x0d,0x0a, /* " name="auth">.. */ \
	0x3c,0x66,0x69,0x65,0x6c,0x64,0x73,0x65,0x74,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76, /* <fieldset>..<div */ \
	0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x4e,0x6f,0x64,0x65,0x20,0x43,0x61,0x6c, /* ><label>Node Cal */ \
	0x6c,0x73,0x69,0x67,0x6e,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a, /* lsign:</label>.. */ \
	0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78  /* <input type="tex */
#define DATACHUNK00002a \
	0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6e,0x6f,0x64,0x65,0x22,0x20,0x63, /* t" name="node" c */ \
	0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d, /* lass="ad1" size= */ \
	0x22,0x31,0x30,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x4e,0x6f,0x64, /* "10" value="~Nod */ \
	0x65,0x4e,0x61,0x6d,0x65,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e, /* eName~" /></div> */ \
	0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x41,0x75, /* ..<div><label>Au */ \
	0x74,0x68,0x20,0x43,0x61,0x6c,0x6c,0x73,0x69,0x67,0x6e,0x3a,0x3c,0x2f,0x6c,0x61, /* th Callsign:</la */ \
	0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70, /* bel>..<input typ */ \
	0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x61, /* e="text" name="a */ \
	0x75,0x74,0x68,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22, /* uth" class="ad1" */ \
	0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x31,0x30,0x22,0x20,0x76,0x61,0x6c,0x75,0x65, /*  size="10" value */ \
	0x3d,0x22,0x7e,0x61,0x75,0x74,0x68,0x5f,0x63,0x61,0x6c,0x6c,0x7e,0x22,0x20,0x2f, /* ="~auth_call~" / */ \
	0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c, /* ></div>..<div><l */ \
	0x61,0x62,0x65,0x6c,0x3e,0x50,0x49,0x4e,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c, /* abel>PIN:</label */ \
	0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22, /* >..<input type=" */ \
	0x70,0x69,0x6e,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x70,0x69,0x6e,0x22,0x20, /* pin" name="pin"  */ \
	0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x20,0x73,0x69,0x7a,0x65, /* class="ad1" size */ \
	0x3d,0x22,0x31,0x30,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x70,0x69, /* ="10" value="~pi */ \
	0x6e,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64, /* n~" /></div>..<d */ \
	0x69,0x76,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22, /* iv><input type=" */ \
	0x62,0x75,0x74,0x74,0x6f,0x6e,0x22,0x20,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22, /* button"  class=" */ \
	0x73,0x6d,0x22,0x20,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x53,0x61,0x76,0x65, /* sm"  value="Save */ \
	0x20,0x41,0x75,0x74,0x68,0x20,0x43,0x61,0x6c,0x6c,0x20,0x26,0x20,0x50,0x49,0x4e, /*  Auth Call & PIN */ \
	0x22,0x20,0x6f,0x6e,0x43,0x6c,0x69,0x63,0x6b,0x3d,0x22,0x43,0x68,0x65,0x63,0x6b, /* " onClick="Check */ \
	0x46,0x69,0x65,0x6c,0x64,0x28,0x29,0x22,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e, /* Field()"/></div> */ \
	0x0d,0x0a,0x3c,0x2f,0x66,0x69,0x65,0x6c,0x64,0x73,0x65,0x74,0x3e,0x0d,0x0a,0x3c, /* ..</fieldset>..< */ \
	0x2f,0x66,0x6f,0x72,0x6d,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a, /* /form>..</div>.. */ \
	0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22, /* ..<script type=" */ \
	0x74,0x65,0x78,0x74,0x2f,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22, /* text/javascript" */ \
	0x3e,0x0d,0x0a,0x3c,0x21,0x2d,0x2d,0x0d,0x0a,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f, /* >..<!--..functio */ \
	0x6e,0x20,0x43,0x68,0x65,0x63,0x6b,0x46,0x69,0x65,0x6c,0x64,0x28,0x29,0x0d,0x0a, /* n CheckField().. */ \
	0x7b,0x0d,0x0a,0x20,0x20,0x69,0x66,0x20,0x28,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e, /* {..  if (documen */ \
	0x74,0x2e,0x66,0x6f,0x72,0x6d,0x73,0x2e,0x61,0x75,0x74,0x68,0x2e,0x6e,0x6f,0x64, /* t.forms.auth.nod */ \
	0x65,0x2e,0x76,0x61,0x6c,0x75,0x65,0x2e,0x6c,0x65,0x6e,0x67,0x74,0x68,0x20,0x3d, /* e.value.length = */ \
	0x3d,0x20,0x30,0x29,0x0d,0x0a,0x20,0x20,0x7b,0x0d,0x0a,0x20,0x20,0x20,0x20,0x77, /* = 0)..  {..    w */ \
	0x69,0x6e,0x64,0x6f,0x77,0x2e,0x61,0x6c,0x65,0x72,0x74,0x28,0x22,0x4e,0x6f,0x64, /* indow.alert("Nod */ \
	0x65,0x20,0x43,0x61,0x6c,0x6c,0x53,0x69,0x67,0x6e,0x20,0x69,0x73,0x20,0x65,0x6d, /* e CallSign is em */ \
	0x70,0x74,0x79,0x21,0x22,0x29,0x3b,0x0d,0x0a,0x20,0x20,0x20,0x20,0x72,0x65,0x74, /* pty!");..    ret */ \
	0x75,0x72,0x6e,0x3b,0x0d,0x0a,0x20,0x20,0x7d,0x0d,0x0a,0x20,0x20,0x69,0x66,0x20, /* urn;..  }..  if  */ \
	0x28,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x66,0x6f,0x72,0x6d,0x73,0x2e, /* (document.forms. */ \
	0x61,0x75,0x74,0x68,0x2e,0x61,0x75,0x74,0x68,0x2e,0x76,0x61,0x6c,0x75,0x65,0x2e, /* auth.auth.value. */ \
	0x6c,0x65,0x6e,0x67,0x74,0x68,0x20,0x3d,0x3d,0x20,0x30,0x29,0x0d,0x0a,0x20,0x20, /* length == 0)..   */ \
	0x7b,0x0d,0x0a,0x20,0x20,0x20,0x20,0x77,0x69,0x6e,0x64,0x6f,0x77,0x2e,0x61,0x6c, /* {..    window.al */ \
	0x65,0x72,0x74,0x28,0x22,0x41,0x75,0x74,0x68,0x2e,0x20,0x43,0x61,0x6c,0x6c,0x53, /* ert("Auth. CallS */ \
	0x69,0x67,0x6e,0x20,0x69,0x73,0x20,0x65,0x6d,0x70,0x74,0x79,0x21,0x22,0x29,0x3b, /* ign is empty!"); */ \
	0x0d,0x0a,0x20,0x20,0x20,0x20,0x72,0x65,0x74,0x75,0x72,0x6e,0x3b,0x0d,0x0a,0x20, /* ..    return;..  */ \
	0x20,0x7d,0x0d,0x0a,0x20,0x20,0x20,0x20,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e, /*  }..     documen */ \
	0x74,0x2e,0x66,0x6f,0x72,0x6d,0x73,0x2e,0x61,0x75,0x74,0x68,0x2e,0x73,0x75,0x62, /* t.forms.auth.sub */ \
	0x6d,0x69,0x74,0x28,0x29,0x3b,0x20,0x0d,0x0a,0x7d,0x0d,0x0a,0x2f,0x2f,0x2d,0x2d, /* mit(); ..}..//-- */ \
	0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74,0x3e,0x0d,0x0a,0x0d,0x0a, /* >..</script>.... */ \
	0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e, /* ~inc:footer.inc~ */ \
	0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0xfa,0x00,0x00,0x00,0x4e,0x00,0x00,0x00, /* ....3.......N... */ \
	0x70,0x01,0x00,0x00,0x8b,0x00,0x00,0x00,0xdb,0x01,0x00,0x00,0x8c,0x00,0x00,0x00, /* p............... */ \
	0xde,0x03,0x00,0x00,0x02,0x00,0x00,0x00,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61, /* ........~inc:hea */ \
	0x64,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64, /* der.inc~.<div id */ \
	0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e,0x0a,0x0a,0x3c,0x68,0x31, /* ="content">..<h1 */ \
	0x3e,0x4c,0x6f,0x67,0x69,0x6e,0x20,0x53,0x75,0x63,0x63,0x65,0x73,0x73,0x66,0x75, /* >Login Successfu */ \
	0x6c,0x3c,0x2f,0x68,0x31,0x3e,0x0a,0x0a,0x3c,0x70,0x3e,0x59,0x6f,0x75,0x20,0x68, /* l</h1>..<p>You h */ \
	0x61,0x76,0x65,0x20,0x73,0x75,0x63,0x63,0x65,0x73,0x73,0x66,0x75,0x6c,0x6c,0x79, /* ave successfully */ \
	0x20,0x6c,0x6f,0x67,0x67,0x65,0x64,0x20,0x69,0x6e,0x20,0x74,0x6f,0x20,0x74,0x68, /*  logged in to th */ \
	0x65,0x20,0x77,0x65,0x62,0x20,0x73,0x65,0x72,0x76,0x65,0x72,0x2e,0x20,0x20,0x54, /* e web server.  T */ \
	0x68,0x69,0x73,0x20,0x61,0x75,0x74,0x68,0x65,0x6e,0x74,0x69,0x63,0x61,0x74,0x69, /* his authenticati */ \
	0x6f,0x6e,0x20,0x0a,0x69,0x73,0x20,0x76,0x61,0x6c,0x69,0x64,0x20,0x75,0x6e,0x74, /* on .is valid unt */ \
	0x69,0x6c,0x20,0x79,0x6f,0x75,0x20,0x63,0x6c,0x6f,0x73,0x65,0x20,0x79,0x6f,0x75, /* il you close you */ \
	0x72,0x20,0x62,0x72,0x6f,0x77,0x73,0x65,0x72,0x2e,0x3c,0x2f,0x70,0x3e,0x0a,0x0a  /* r browser.</p>.. */
#define DATACHUNK00002b \
	0x3c,0x70,0x3e,0x43,0x72,0x65,0x64,0x65,0x6e,0x74,0x69,0x61,0x6c,0x73,0x20,0x61, /* <p>Credentials a */ \
	0x72,0x65,0x20,0x76,0x65,0x72,0x69,0x66,0x69,0x65,0x64,0x20,0x69,0x6e,0x20,0x79, /* re verified in y */ \
	0x6f,0x75,0x72,0x20,0x6f,0x77,0x6e,0x20,0x63,0x75,0x73,0x74,0x6f,0x6d,0x20,0x63, /* our own custom c */ \
	0x61,0x6c,0x6c,0x62,0x61,0x63,0x6b,0x20,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e, /* allback function */ \
	0x20,0x63,0x61,0x6c,0x6c,0x65,0x64,0x20,0x0a,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x48, /*  called .<code>H */ \
	0x54,0x54,0x50,0x41,0x75,0x74,0x68,0x65,0x6e,0x74,0x69,0x63,0x61,0x74,0x65,0x3c, /* TTPAuthenticate< */ \
	0x2f,0x63,0x6f,0x64,0x65,0x3e,0x2e,0x20,0x20,0x49,0x6e,0x20,0x68,0x65,0x72,0x65, /* /code>.  In here */ \
	0x2c,0x20,0x79,0x6f,0x75,0x20,0x63,0x61,0x6e,0x20,0x64,0x65,0x74,0x65,0x72,0x6d, /* , you can determ */ \
	0x69,0x6e,0x65,0x20,0x69,0x66,0x20,0x74,0x68,0x65,0x20,0x73,0x75,0x70,0x70,0x6c, /* ine if the suppl */ \
	0x69,0x65,0x64,0x0a,0x75,0x73,0x65,0x72,0x20,0x6e,0x61,0x6d,0x65,0x20,0x61,0x6e, /* ied.user name an */ \
	0x64,0x20,0x70,0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x20,0x61,0x72,0x65,0x20,0x76, /* d password are v */ \
	0x61,0x6c,0x69,0x64,0x20,0x66,0x6f,0x72,0x20,0x61,0x63,0x63,0x65,0x73,0x73,0x20, /* alid for access  */ \
	0x74,0x6f,0x20,0x74,0x68,0x65,0x20,0x72,0x65,0x71,0x75,0x65,0x73,0x74,0x65,0x64, /* to the requested */ \
	0x20,0x70,0x61,0x67,0x65,0x2e,0x20,0x20,0x59,0x6f,0x75,0x20,0x63,0x61,0x6e,0x20, /*  page.  You can  */ \
	0x0a,0x61,0x64,0x64,0x20,0x6d,0x75,0x6c,0x74,0x69,0x70,0x6c,0x65,0x20,0x75,0x73, /* .add multiple us */ \
	0x65,0x72,0x73,0x20,0x61,0x6e,0x64,0x20,0x72,0x65,0x73,0x74,0x72,0x69,0x63,0x74, /* ers and restrict */ \
	0x20,0x64,0x69,0x66,0x66,0x65,0x72,0x65,0x6e,0x74,0x20,0x75,0x73,0x65,0x72,0x73, /*  different users */ \
	0x20,0x74,0x6f,0x20,0x64,0x69,0x66,0x66,0x65,0x72,0x65,0x6e,0x74,0x20,0x70,0x61, /*  to different pa */ \
	0x67,0x65,0x73,0x2e,0x3c,0x2f,0x70,0x3e,0x0a,0x0a,0x3c,0x70,0x20,0x63,0x6c,0x61, /* ges.</p>..<p cla */ \
	0x73,0x73,0x3d,0x22,0x65,0x78,0x65,0x72,0x63,0x69,0x73,0x65,0x22,0x3e,0x3c,0x62, /* ss="exercise"><b */ \
	0x3e,0x45,0x78,0x65,0x72,0x63,0x69,0x73,0x65,0x3a,0x3c,0x2f,0x62,0x3e,0x20,0x43, /* >Exercise:</b> C */ \
	0x68,0x61,0x6e,0x67,0x65,0x20,0x74,0x68,0x65,0x20,0x75,0x73,0x65,0x72,0x20,0x6e, /* hange the user n */ \
	0x61,0x6d,0x65,0x20,0x61,0x6e,0x64,0x20,0x70,0x61,0x73,0x73,0x77,0x6f,0x72,0x64, /* ame and password */ \
	0x20,0x69,0x6e,0x0a,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x48,0x54,0x54,0x50,0x41,0x75, /*  in.<code>HTTPAu */ \
	0x74,0x68,0x65,0x6e,0x74,0x69,0x63,0x61,0x74,0x65,0x3c,0x2f,0x63,0x6f,0x64,0x65, /* thenticate</code */ \
	0x3e,0x20,0x74,0x6f,0x20,0x6f,0x6e,0x65,0x20,0x6f,0x66,0x20,0x79,0x6f,0x75,0x72, /* > to one of your */ \
	0x20,0x63,0x68,0x6f,0x6f,0x73,0x69,0x6e,0x67,0x2e,0x20,0x20,0x28,0x54,0x68,0x65, /*  choosing.  (The */ \
	0x20,0x63,0x61,0x6c,0x6c,0x62,0x61,0x63,0x6b,0x20,0x69,0x73,0x20,0x0a,0x6c,0x6f, /*  callback is .lo */ \
	0x63,0x61,0x74,0x65,0x64,0x20,0x69,0x6e,0x20,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x43, /* cated in <code>C */ \
	0x75,0x73,0x74,0x6f,0x6d,0x48,0x54,0x54,0x50,0x41,0x70,0x70,0x2e,0x63,0x3c,0x2f, /* ustomHTTPApp.c</ */ \
	0x63,0x6f,0x64,0x65,0x3e,0x2e,0x29,0x3c,0x2f,0x70,0x3e,0x0a,0x0a,0x3c,0x64,0x69, /* code>.)</p>..<di */ \
	0x76,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x65,0x78,0x61,0x6d,0x70,0x6c,0x65, /* v class="example */ \
	0x62,0x6f,0x78,0x22,0x3e,0x0a,0x57,0x68,0x65,0x6e,0x20,0x79,0x6f,0x75,0x20,0x66, /* box">.When you f */ \
	0x69,0x6e,0x69,0x73,0x68,0x2c,0x20,0x72,0x65,0x66,0x72,0x65,0x73,0x68,0x20,0x74, /* inish, refresh t */ \
	0x68,0x69,0x73,0x20,0x70,0x61,0x67,0x65,0x20,0x74,0x6f,0x20,0x74,0x65,0x73,0x74, /* his page to test */ \
	0x20,0x79,0x6f,0x75,0x72,0x20,0x6e,0x65,0x77,0x20,0x75,0x73,0x65,0x72,0x20,0x6e, /*  your new user n */ \
	0x61,0x6d,0x65,0x20,0x61,0x6e,0x64,0x20,0x70,0x61,0x73,0x73,0x77,0x6f,0x72,0x64, /* ame and password */ \
	0x20,0x0a,0x63,0x6f,0x6d,0x62,0x69,0x6e,0x61,0x74,0x69,0x6f,0x6e,0x2e,0x0a,0x3c, /*  .combination..< */ \
	0x2f,0x64,0x69,0x76,0x3e,0x0a,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0a,0x0a,0x3c, /* /div>..</div>..< */ \
	0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78, /* script type="tex */ \
	0x74,0x2f,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x0a,0x3c, /* t/javascript">.< */ \
	0x21,0x2d,0x2d,0x0a,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x67,0x65,0x74, /* !--.document.get */ \
	0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28,0x27,0x68,0x65,0x6c, /* ElementById('hel */ \
	0x6c,0x6f,0x27,0x29,0x2e,0x69,0x6e,0x6e,0x65,0x72,0x48,0x54,0x4d,0x4c,0x20,0x3d, /* lo').innerHTML = */ \
	0x20,0x22,0x7e,0x68,0x65,0x6c,0x6c,0x6f,0x6d,0x73,0x67,0x7e,0x22,0x3b,0x0a,0x2f, /*  "~hellomsg~";./ */ \
	0x2f,0x2d,0x2d,0x3e,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74,0x3e,0x0a,0x0a, /* /-->.</script>.. */ \
	0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e, /* ~inc:footer.inc~ */ \
	0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0x7a,0x03,0x00,0x00,0x01,0x00,0x00,0x00, /* ....3...z....... */ \
	0x98,0x03,0x00,0x00,0x02,0x00,0x00,0x00,0x7e,0x72,0x65,0x62,0x6f,0x6f,0x74,0x7e, /* ........~reboot~ */ \
	0x00,0x00,0x00,0x00,0x2d,0x00,0x00,0x00,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61, /* ....-...~inc:hea */ \
	0x64,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69, /* der.inc~..<div i */ \
	0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a, /* d="content">.... */ \
	0x3c,0x68,0x31,0x3e,0x52,0x65,0x62,0x6f,0x6f,0x74,0x20,0x49,0x6e,0x20,0x50,0x72, /* <h1>Reboot In Pr */ \
	0x6f,0x67,0x72,0x65,0x73,0x73,0x2e,0x2e,0x2e,0x3c,0x2f,0x68,0x31,0x3e,0x0d,0x0a, /* ogress...</h1>.. */ \
	0x0d,0x0a,0x3c,0x70,0x3e,0x59,0x6f,0x75,0x72,0x20,0x73,0x65,0x74,0x74,0x69,0x6e, /* ..<p>Your settin */ \
	0x67,0x73,0x20,0x77,0x65,0x72,0x65,0x20,0x73,0x75,0x63,0x63,0x65,0x73,0x73,0x66, /* gs were successf */ \
	0x75,0x6c,0x6c,0x79,0x20,0x73,0x61,0x76,0x65,0x64,0x2c,0x20,0x61,0x6e,0x64,0x20, /* ully saved, and  */ \
	0x74,0x68,0x65,0x20,0x62,0x6f,0x61,0x72,0x64,0x20,0x69,0x73,0x20,0x6e,0x6f,0x77, /* the board is now */ \
	0x20,0x72,0x65,0x62,0x6f,0x6f,0x74,0x69,0x6e,0x67,0x20,0x0d,0x0a,0x74,0x6f,0x20, /*  rebooting ..to  */ \
	0x63,0x6f,0x6e,0x66,0x69,0x67,0x75,0x72,0x65,0x20,0x69,0x74,0x73,0x65,0x6c,0x66, /* configure itself */ \
	0x20,0x77,0x69,0x74,0x68,0x20,0x74,0x68,0x65,0x20,0x6e,0x65,0x77,0x20,0x73,0x65, /*  with the new se */ \
	0x74,0x74,0x69,0x6e,0x67,0x73,0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c, /* ttings.</p>....< */ \
	0x70,0x20,0x61,0x6c,0x69,0x67,0x6e,0x3d,0x22,0x63,0x65,0x6e,0x74,0x65,0x72,0x22, /* p align="center" */ \
	0x3e,0x3c,0x62,0x3e,0x59,0x6f,0x75,0x72,0x20,0x62,0x6f,0x61,0x72,0x64,0x20,0x69  /* ><b>Your board i */
#define DATACHUNK00002c \
	0x73,0x20,0x6e,0x6f,0x77,0x20,0x6c,0x6f,0x63,0x61,0x74,0x65,0x64,0x20,0x61,0x74, /* s now located at */ \
	0x3a,0x20,0x0d,0x0a,0x3c,0x61,0x20,0x68,0x72,0x65,0x66,0x3d,0x22,0x68,0x74,0x74, /* : ..<a href="htt */ \
	0x70,0x3a,0x2f,0x2f,0x7e,0x72,0x65,0x62,0x6f,0x6f,0x74,0x61,0x64,0x64,0x72,0x7e, /* p://~rebootaddr~ */ \
	0x2f,0x22,0x3e,0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,0x7e,0x72,0x65,0x62,0x6f,0x6f, /* /">http://~reboo */ \
	0x74,0x61,0x64,0x64,0x72,0x7e,0x2f,0x3c,0x2f,0x61,0x3e,0x3c,0x2f,0x62,0x3e,0x3c, /* taddr~/</a></b>< */ \
	0x2f,0x70,0x3e,0x0d,0x0a,0x3c,0x6d,0x65,0x74,0x61,0x20,0x68,0x74,0x74,0x70,0x2d, /* /p>..<meta http- */ \
	0x65,0x71,0x75,0x69,0x76,0x3d,0x22,0x72,0x65,0x66,0x72,0x65,0x73,0x68,0x22,0x20, /* equiv="refresh"  */ \
	0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x3d,0x22,0x35,0x3b,0x75,0x72,0x6c,0x3d,0x68, /* content="5;url=h */ \
	0x74,0x74,0x70,0x3a,0x2f,0x2f,0x7e,0x72,0x65,0x62,0x6f,0x6f,0x74,0x61,0x64,0x64, /* ttp://~rebootadd */ \
	0x72,0x7e,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x36,0x3e,0x3c,0x2f,0x68,0x36, /* r~">....<h6></h6 */ \
	0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c, /* >....</div>....< */ \
	0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x6c,0x61,0x6e,0x67,0x75,0x61,0x67,0x65,0x3d, /* script language= */ \
	0x22,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x0d,0x0a,0x3c, /* "javascript">..< */ \
	0x21,0x2d,0x2d,0x0d,0x0a,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x20,0x72,0x65, /* !--..function re */ \
	0x62,0x6f,0x6f,0x74,0x44,0x75,0x6d,0x6d,0x79,0x28,0x78,0x29,0x7b,0x7d,0x0d,0x0a, /* bootDummy(x){}.. */ \
	0x73,0x65,0x74,0x54,0x69,0x6d,0x65,0x6f,0x75,0x74,0x28,0x22,0x6e,0x65,0x77,0x41, /* setTimeout("newA */ \
	0x4a,0x41,0x58,0x43,0x6f,0x6d,0x6d,0x61,0x6e,0x64,0x28,0x27,0x2f,0x70,0x72,0x6f, /* JAXCommand('/pro */ \
	0x74,0x65,0x63,0x74,0x2f,0x72,0x65,0x62,0x6f,0x6f,0x74,0x2e,0x63,0x67,0x69,0x27, /* tect/reboot.cgi' */ \
	0x2c,0x72,0x65,0x62,0x6f,0x6f,0x74,0x44,0x75,0x6d,0x6d,0x79,0x2c,0x66,0x61,0x6c, /* ,rebootDummy,fal */ \
	0x73,0x65,0x29,0x3b,0x22,0x2c,0x35,0x30,0x30,0x29,0x3b,0x0d,0x0a,0x2f,0x2f,0x2d, /* se);",500);..//- */ \
	0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74,0x3e,0x0d,0x0a,0x7e, /* ->..</script>..~ */ \
	0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x00, /* inc:footer.inc~. */ \
	0x00,0x00,0x00,0x33,0x00,0x00,0x00,0x0c,0x01,0x00,0x00,0x2e,0x00,0x00,0x00,0x22, /* ...3..........." */ \
	0x01,0x00,0x00,0x2e,0x00,0x00,0x00,0x6e,0x01,0x00,0x00,0x2e,0x00,0x00,0x00,0x37, /* .......n.......7 */ \
	0x02,0x00,0x00,0x02,0x00,0x00,0x00,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64, /* .......~inc:head */ \
	0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64, /* er.inc~..<div id */ \
	0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c, /* ="content">....< */ \
	0x68,0x31,0x3e,0x46,0x69,0x72,0x6d,0x77,0x61,0x72,0x65,0x20,0x55,0x70,0x64,0x61, /* h1>Firmware Upda */ \
	0x74,0x65,0x3c,0x2f,0x68,0x31,0x3e,0x0d,0x0a,0x3c,0x66,0x6f,0x72,0x6d,0x20,0x6d, /* te</h1>..<form m */ \
	0x65,0x74,0x68,0x6f,0x64,0x3d,0x22,0x70,0x6f,0x73,0x74,0x22,0x20,0x61,0x63,0x74, /* ethod="post" act */ \
	0x69,0x6f,0x6e,0x3d,0x22,0x2f,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x75,0x70, /* ion="/protect/up */ \
	0x64,0x61,0x74,0x65,0x2e,0x68,0x74,0x6d,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22, /* date.htm" name=" */ \
	0x55,0x70,0x6c,0x6f,0x61,0x64,0x22,0x20,0x65,0x6e,0x63,0x74,0x79,0x70,0x65,0x3d, /* Upload" enctype= */ \
	0x22,0x6d,0x75,0x6c,0x74,0x69,0x70,0x61,0x72,0x74,0x2f,0x66,0x6f,0x72,0x6d,0x2d, /* "multipart/form- */ \
	0x64,0x61,0x74,0x61,0x22,0x3e,0x0d,0x0a,0x3c,0x70,0x3e,0x0d,0x0a,0x3c,0x69,0x6e, /* data">..<p>..<in */ \
	0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x66,0x69,0x6c,0x65,0x22,0x20, /* put type="file"  */ \
	0x6e,0x61,0x6d,0x65,0x3d,0x22,0x66,0x69,0x6c,0x65,0x22,0x20,0x73,0x69,0x7a,0x65, /* name="file" size */ \
	0x3d,0x22,0x35,0x30,0x22,0x3e,0x0d,0x0a,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e, /* ="50">..&nbsp;&n */ \
	0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x0d,0x0a,0x3c,0x69,0x6e,0x70, /* bsp;&nbsp;..<inp */ \
	0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x73,0x75,0x62,0x6d,0x69,0x74,0x22, /* ut type="submit" */ \
	0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x55,0x70,0x64,0x61,0x74,0x65,0x22,0x20, /*  value="Update"  */ \
	0x6f,0x6e,0x63,0x6c,0x69,0x63,0x6b,0x3d,0x22,0x72,0x65,0x74,0x75,0x72,0x6e,0x20, /* onclick="return  */ \
	0x63,0x6f,0x6e,0x66,0x69,0x72,0x6d,0x28,0x27,0x41,0x72,0x65,0x20,0x79,0x6f,0x75, /* confirm('Are you */ \
	0x20,0x73,0x75,0x72,0x65,0x3f,0x27,0x29,0x22,0x20,0x6f,0x6e,0x75,0x6e,0x6c,0x6f, /*  sure?')" onunlo */ \
	0x61,0x64,0x3d,0x22,0x72,0x65,0x74,0x75,0x72,0x6e,0x20,0x63,0x6f,0x6e,0x66,0x69, /* ad="return confi */ \
	0x72,0x6d,0x28,0x27,0x44,0x6f,0x20,0x79,0x6f,0x75,0x20,0x61,0x62,0x6f,0x72,0x74, /* rm('Do you abort */ \
	0x20,0x74,0x68,0x65,0x20,0x75,0x70,0x64,0x61,0x74,0x69,0x6e,0x67,0x3f,0x27,0x29, /*  the updating?') */ \
	0x22,0x3e,0x0d,0x0a,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x3c,0x70,0x3e,0x0d,0x0a,0x7e, /* ">..</p>..<p>..~ */ \
	0x75,0x70,0x6c,0x6f,0x61,0x64,0x65,0x64,0x7e,0x0d,0x0a,0x3c,0x2f,0x70,0x3e,0x0d, /* uploaded~..</p>. */ \
	0x0a,0x3c,0x62,0x3e,0x4e,0x6f,0x74,0x65,0x3a,0x20,0x4e,0x65,0x65,0x64,0x20,0x61, /* .<b>Note: Need a */ \
	0x62,0x6f,0x75,0x74,0x20,0x36,0x30,0x20,0x2d,0x31,0x38,0x30,0x20,0x73,0x65,0x63, /* bout 60 -180 sec */ \
	0x6f,0x6e,0x64,0x73,0x20,0x66,0x6f,0x72,0x20,0x75,0x70,0x64,0x61,0x74,0x69,0x6e, /* onds for updatin */ \
	0x67,0x3c,0x2f,0x62,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x6f,0x72,0x6d,0x3e,0x0d,0x0a, /* g</b>..</form>.. */ \
	0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70, /* </div>....<scrip */ \
	0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x2f,0x6a,0x61,0x76, /* t type="text/jav */ \
	0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x0d,0x0a,0x3c,0x21,0x2d,0x2d,0x0d, /* ascript">..<!--. */ \
	0x0a,0x2f,0x2f,0x2d,0x2d,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69, /* .//-->....</scri */ \
	0x70,0x74,0x3e,0x0d,0x0a,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74, /* pt>....~inc:foot */ \
	0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0x78, /* er.inc~....3...x */ \
	0x01,0x00,0x00,0xa9,0x00,0x00,0x00,0x10,0x02,0x00,0x00,0x02,0x00,0x00,0x00,0x7e, /* ...............~ */ \
	0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d, /* inc:header.inc~. */ \
	0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e, /* .<div id="conten */ \
	0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x55,0x73,0x65,0x72,0x20, /* t">....<h1>User  */ \
	0x49,0x44,0x20,0x61,0x6e,0x64,0x20,0x50,0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x20  /* ID and Password  */
#define DATACHUNK00002d \
	0x53,0x65,0x74,0x74,0x69,0x6e,0x67,0x3c,0x2f,0x68,0x31,0x3e,0x0d,0x0a,0x0d,0x0a, /* Setting</h1>.... */ \
	0x3c,0x66,0x6f,0x72,0x6d,0x20,0x6d,0x65,0x74,0x68,0x6f,0x64,0x3d,0x22,0x70,0x6f, /* <form method="po */ \
	0x73,0x74,0x22,0x20,0x61,0x63,0x74,0x69,0x6f,0x6e,0x3d,0x22,0x2f,0x70,0x72,0x6f, /* st" action="/pro */ \
	0x74,0x65,0x63,0x74,0x2f,0x75,0x73,0x65,0x72,0x2e,0x68,0x74,0x6d,0x22,0x20,0x6e, /* tect/user.htm" n */ \
	0x61,0x6d,0x65,0x3d,0x22,0x75,0x73,0x65,0x72,0x22,0x3e,0x0d,0x0a,0x3c,0x66,0x69, /* ame="user">..<fi */ \
	0x65,0x6c,0x64,0x73,0x65,0x74,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c, /* eldset>..<div><l */ \
	0x61,0x62,0x65,0x6c,0x3e,0x55,0x73,0x65,0x72,0x20,0x49,0x44,0x3a,0x3c,0x2f,0x6c, /* abel>User ID:</l */ \
	0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79, /* abel>..<input ty */ \
	0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22, /* pe="text" name=" */ \
	0x75,0x73,0x65,0x72,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x75,0x73, /* user" value="~us */ \
	0x65,0x72,0x5f,0x69,0x64,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e, /* er_id~" /></div> */ \
	0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x50,0x61, /* ..<div><label>Pa */ \
	0x73,0x73,0x77,0x6f,0x72,0x64,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d, /* ssword:</label>. */ \
	0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x70,0x61, /* .<input type="pa */ \
	0x73,0x73,0x77,0x6f,0x72,0x64,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x70,0x77, /* ssword" name="pw */ \
	0x64,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x75,0x73,0x65,0x72,0x5f, /* d" value="~user_ */ \
	0x70,0x61,0x73,0x73,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d, /* pass~" /></div>. */ \
	0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x50,0x61,0x73, /* .<div><label>Pas */ \
	0x73,0x77,0x6f,0x72,0x64,0x28,0x43,0x6f,0x6e,0x66,0x69,0x72,0x6d,0x29,0x3a,0x3c, /* sword(Confirm):< */ \
	0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20, /* /label>..<input  */ \
	0x74,0x79,0x70,0x65,0x3d,0x22,0x70,0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x22,0x20, /* type="password"  */ \
	0x6e,0x61,0x6d,0x65,0x3d,0x22,0x70,0x77,0x64,0x43,0x22,0x20,0x76,0x61,0x6c,0x75, /* name="pwdC" valu */ \
	0x65,0x3d,0x22,0x7e,0x75,0x73,0x65,0x72,0x5f,0x70,0x61,0x73,0x73,0x43,0x7e,0x22, /* e="~user_passC~" */ \
	0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e, /*  /></div>..<div> */ \
	0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x62,0x75,0x74, /* <input type="but */ \
	0x74,0x6f,0x6e,0x22,0x20,0x20,0x6f,0x6e,0x43,0x6c,0x69,0x63,0x6b,0x3d,0x22,0x70, /* ton"  onClick="p */ \
	0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x43,0x68,0x65,0x63,0x6b,0x28,0x29,0x22,0x20, /* asswordCheck()"  */ \
	0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x62,0x22,0x20,0x76,0x61,0x6c, /* class="ad1b" val */ \
	0x75,0x65,0x3d,0x22,0x53,0x61,0x76,0x65,0x20,0x49,0x44,0x20,0x26,0x20,0x50,0x61, /* ue="Save ID & Pa */ \
	0x73,0x73,0x77,0x6f,0x72,0x64,0x22,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d, /* ssword"/></div>. */ \
	0x0a,0x3c,0x2f,0x66,0x69,0x65,0x6c,0x64,0x73,0x65,0x74,0x3e,0x0d,0x0a,0x3c,0x2f, /* .</fieldset>..</ */ \
	0x66,0x6f,0x72,0x6d,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d, /* form>..</div>... */ \
	0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74, /* .<script type="t */ \
	0x65,0x78,0x74,0x2f,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x3e, /* ext/javascript"> */ \
	0x0d,0x0a,0x3c,0x21,0x2d,0x2d,0x0d,0x0a,0x2f,0x2f,0x2d,0x2d,0x3e,0x0d,0x0a,0x64, /* ..<!--..//-->..d */ \
	0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65, /* ocument.getEleme */ \
	0x6e,0x74,0x42,0x79,0x49,0x64,0x28,0x27,0x68,0x65,0x6c,0x6c,0x6f,0x27,0x29,0x2e, /* ntById('hello'). */ \
	0x69,0x6e,0x6e,0x65,0x72,0x48,0x54,0x4d,0x4c,0x20,0x3d,0x20,0x22,0x7e,0x68,0x65, /* innerHTML = "~he */ \
	0x6c,0x6c,0x6f,0x6d,0x73,0x67,0x7e,0x22,0x3b,0x0d,0x0a,0x66,0x75,0x6e,0x63,0x74, /* llomsg~";..funct */ \
	0x69,0x6f,0x6e,0x20,0x70,0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x43,0x68,0x65,0x63, /* ion passwordChec */ \
	0x6b,0x28,0x29,0x0d,0x0a,0x7b,0x0d,0x0a,0x09,0x69,0x66,0x20,0x28,0x64,0x6f,0x63, /* k()..{...if (doc */ \
	0x75,0x6d,0x65,0x6e,0x74,0x2e,0x75,0x73,0x65,0x72,0x2e,0x70,0x77,0x64,0x2e,0x76, /* ument.user.pwd.v */ \
	0x61,0x6c,0x75,0x65,0x20,0x21,0x3d,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74, /* alue != document */ \
	0x2e,0x75,0x73,0x65,0x72,0x2e,0x70,0x77,0x64,0x43,0x2e,0x76,0x61,0x6c,0x75,0x65, /* .user.pwdC.value */ \
	0x29,0x0d,0x0a,0x09,0x7b,0x0d,0x0a,0x09,0x09,0x61,0x6c,0x65,0x72,0x74,0x20,0x28, /* )...{....alert ( */ \
	0x22,0x50,0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x20,0x4d,0x69,0x73,0x73,0x6d,0x61, /* "Password Missma */ \
	0x74,0x63,0x68,0x21,0x22,0x29,0x3b,0x0d,0x0a,0x09,0x09,0x72,0x65,0x74,0x75,0x72, /* tch!");....retur */ \
	0x6e,0x3b,0x0d,0x0a,0x09,0x7d,0x0d,0x0a,0x09,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e, /* n;...}...documen */ \
	0x74,0x2e,0x75,0x73,0x65,0x72,0x2e,0x73,0x75,0x62,0x6d,0x69,0x74,0x28,0x29,0x3b, /* t.user.submit(); */ \
	0x0d,0x0a,0x0d,0x0a,0x7d,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74,0x3e, /* ....}..</script> */ \
	0x0d,0x0a,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e, /* ....~inc:footer. */ \
	0x69,0x6e,0x63,0x7e,0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0xde,0x00,0x00,0x00, /* inc~....3....... */ \
	0x6a,0x00,0x00,0x00,0x3b,0x01,0x00,0x00,0x6b,0x00,0x00,0x00,0xa4,0x01,0x00,0x00, /* j...;...k....... */ \
	0x6c,0x00,0x00,0x00,0x9e,0x02,0x00,0x00,0x01,0x00,0x00,0x00,0x65,0x03,0x00,0x00, /* l...........e... */ \
	0x02,0x00,0x00,0x00                                                              /* ....             */


/**************************************
 * MPFS2 C linkable symbols
 **************************************/
// For C18, these are split into seperate arrays because it speeds up compilation a lot.  
// For other compilers, the entire data array must be defined as a single variable to 
// ensure that the linker does not reorder the data chunks in Flash when compiler 
// optimizations are turned on.
#if defined(__18CXX)
	ROM BYTE MPFS_Start[] = {DATACHUNK000000};
	ROM BYTE MPFS_000001[] = {DATACHUNK000001};
	ROM BYTE MPFS_000002[] = {DATACHUNK000002};
	ROM BYTE MPFS_000003[] = {DATACHUNK000003};
	ROM BYTE MPFS_000004[] = {DATACHUNK000004};
	ROM BYTE MPFS_000005[] = {DATACHUNK000005};
	ROM BYTE MPFS_000006[] = {DATACHUNK000006};
	ROM BYTE MPFS_000007[] = {DATACHUNK000007};
	ROM BYTE MPFS_000008[] = {DATACHUNK000008};
	ROM BYTE MPFS_000009[] = {DATACHUNK000009};
	ROM BYTE MPFS_00000a[] = {DATACHUNK00000a};
	ROM BYTE MPFS_00000b[] = {DATACHUNK00000b};
	ROM BYTE MPFS_00000c[] = {DATACHUNK00000c};
	ROM BYTE MPFS_00000d[] = {DATACHUNK00000d};
	ROM BYTE MPFS_00000e[] = {DATACHUNK00000e};
	ROM BYTE MPFS_00000f[] = {DATACHUNK00000f};
	ROM BYTE MPFS_000010[] = {DATACHUNK000010};
	ROM BYTE MPFS_000011[] = {DATACHUNK000011};
	ROM BYTE MPFS_000012[] = {DATACHUNK000012};
	ROM BYTE MPFS_000013[] = {DATACHUNK000013};
	ROM BYTE MPFS_000014[] = {DATACHUNK000014};
	ROM BYTE MPFS_000015[] = {DATACHUNK000015};
	ROM BYTE MPFS_000016[] = {DATACHUNK000016};
	ROM BYTE MPFS_000017[] = {DATACHUNK000017};
	ROM BYTE MPFS_000018[] = {DATACHUNK000018};
	ROM BYTE MPFS_000019[] = {DATACHUNK000019};
	ROM BYTE MPFS_00001a[] = {DATACHUNK00001a};
	ROM BYTE MPFS_00001b[] = {DATACHUNK00001b};
	ROM BYTE MPFS_00001c[] = {DATACHUNK00001c};
	ROM BYTE MPFS_00001d[] = {DATACHUNK00001d};
	ROM BYTE MPFS_00001e[] = {DATACHUNK00001e};
	ROM BYTE MPFS_00001f[] = {DATACHUNK00001f};
	ROM BYTE MPFS_000020[] = {DATACHUNK000020};
	ROM BYTE MPFS_000021[] = {DATACHUNK000021};
	ROM BYTE MPFS_000022[] = {DATACHUNK000022};
	ROM BYTE MPFS_000023[] = {DATACHUNK000023};
	ROM BYTE MPFS_000024[] = {DATACHUNK000024};
	ROM BYTE MPFS_000025[] = {DATACHUNK000025};
	ROM BYTE MPFS_000026[] = {DATACHUNK000026};
	ROM BYTE MPFS_000027[] = {DATACHUNK000027};
	ROM BYTE MPFS_000028[] = {DATACHUNK000028};
	ROM BYTE MPFS_000029[] = {DATACHUNK000029};
	ROM BYTE MPFS_00002a[] = {DATACHUNK00002a};
	ROM BYTE MPFS_00002b[] = {DATACHUNK00002b};
	ROM BYTE MPFS_00002c[] = {DATACHUNK00002c};
	ROM BYTE MPFS_00002d[] = {DATACHUNK00002d};
#else
	ROM BYTE MPFS_Start[] = {DATACHUNK000000, DATACHUNK000001, DATACHUNK000002, DATACHUNK000003, DATACHUNK000004, DATACHUNK000005, DATACHUNK000006, DATACHUNK000007, DATACHUNK000008, DATACHUNK000009, DATACHUNK00000a, DATACHUNK00000b, DATACHUNK00000c, DATACHUNK00000d, DATACHUNK00000e, DATACHUNK00000f, DATACHUNK000010, DATACHUNK000011, DATACHUNK000012, DATACHUNK000013, DATACHUNK000014, DATACHUNK000015, DATACHUNK000016, DATACHUNK000017, DATACHUNK000018, DATACHUNK000019, DATACHUNK00001a, DATACHUNK00001b, DATACHUNK00001c, DATACHUNK00001d, DATACHUNK00001e, DATACHUNK00001f, DATACHUNK000020, DATACHUNK000021, DATACHUNK000022, DATACHUNK000023, DATACHUNK000024, DATACHUNK000025, DATACHUNK000026, DATACHUNK000027, DATACHUNK000028, DATACHUNK000029, DATACHUNK00002a, DATACHUNK00002b, DATACHUNK00002c, DATACHUNK00002d};
#endif


/**************************************************************
 * End of MPFS
 **************************************************************/
#endif // #if defined(STACK_USE_MPFS2)
#endif // #if !defined(MPFS_USE_EEPROM) && !defined(MPFS_USE_SPI_FLASH)
