/*
 *  MIDI API Sample
 *
 *    10/01/03 V0.10 by oga.
 *
 *    Ql: http://www.deqnotes.net/midi/winapi_midiprog/winapi_midiprog.pdf
 */

#include <stdio.h>
#include <windows.h>
#include <mmsystem.h>

int main(int a, char *b)
{
	MIDIOUTCAPS outCaps;
	MIDIINCAPS  inCaps;
	MMRESULT res;
	UINT num, devid;

	/* MIDIo̓foCX擾*/
	num = midiOutGetNumDevs();
	printf("## Number of output devices: %d\n", num);
	/* efoCXID ɑ΂for [v*/
	for (devid=0; devid<num; devid++) {
		/* foCX̏outCaps Ɋi[*/
		res = midiOutGetDevCaps(devid, &outCaps, sizeof(outCaps));
		/* midiOutGetDevCaps ̖߂lłȂ(=s) Ȃ玟̃[v*/
		if (res != MMSYSERR_NOERROR) { continue; }
		/* foCXID Ƃ̃foCX\*/
		printf("ID=%d: %s\n", devid, outCaps.szPname);
	}

	/* MIDI̓foCX擾*/
	num = midiInGetNumDevs();
	printf("## Number of input devices: %d\n", num);
	/* efoCXID ɑ΂for [v*/
	for (devid=0; devid<num; devid++) {
		/* foCX̏outCaps Ɋi[*/
		res = midiInGetDevCaps(devid, &inCaps, sizeof(inCaps));
		/* midiOutGetDevCaps ̖߂lłȂ(=s) Ȃ玟̃[v*/
		if (res != MMSYSERR_NOERROR) { continue; }
		/* foCXID Ƃ̃foCX\*/
		printf("ID=%d: %s\n", devid, inCaps.szPname);
	}
	return 0;
}
