/*
 -----------------------------------------------------------------------------
 This source file is part of OGRE
 (Object-oriented Graphics Rendering Engine)
 For the latest info, see http://www.ogre3d.org/
 
 Copyright (c) 2000-2014 Torus Knot Software Ltd
 
 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:
 
 The above copyright notice and this permission notice shall be included in
 all copies or substantial portions of the Software.
 
 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
 -----------------------------------------------------------------------------
 */

#ifndef __SAMPLE_H__
#define __SAMPLE_H__

#include <Ogre.h>
#include <OgreTrays.h>
#include <OgreCameraMan.h>
#include <OgreApplicationContext.h>

#include "SampleContext.h"

class Context : public OgreBites::SampleContext
{
public:
    Context();
    
    void passAssetAsArrayBuffer(unsigned char*, int length);
    void clearScene();
    
    static void _mainLoop(void* target);
private:
    unsigned char* mBuffer;
    Ogre::SceneNode* mNode;

    void destroyMaterials( Ogre::String resourceGroupID );
    void destroyTextures( Ogre::String resourceGroupID );
    void unloadResource(Ogre::ResourceManager* resMgr, const Ogre::String& resourceName);

    void setup();

    bool mouseWheelRolled(const OgreBites::MouseWheelEvent& evt);
};
#endif
