module ApplicationHelper
  def unit_collection
    ret = {}
    %w(metric imperial).each do |u|
      ret[I18n.t("unit.#{u}", default: u.capitalize)] = u
    end
    ret
  end

  def icon(type, *extra)
    content_tag :i , '', class: "icon-#{type} #{extra.join(' ')}"
  end

  def next_arrow
    content_tag :div, icon("caret-down"), class: 'next-arrow'
  end

  def nv_show_rating nvobj
    nvobj.rating.blank? || nvobj.rating == 0 and return "";
    ret = content_tag :span, "", id: "rating_nv_#{nvobj.id}", class: 'rating-container'
    ret += javascript_tag %Q(
     $('#rating_nv_#{nvobj.id}').raty({
       score: #{nvobj.rating}, path: '#{root_path}assets', readOnly: true
     });
    )
    ret
  end

  def format_bytesize size
    size.blank? and return ""
    if size > 1024*1024
      "#{'%.2f' % (size/1024.0/1024)} MB"
    elsif size > 1024
      "#{'%.1f' % (size/1024.0)} KB"
    else
      "#{size} B"
    end
  end
end
