module ApplicationHelper
  def unit_collection
    ret = {}
    %w(metric imperial).each do |u|
      ret[I18n.t("unit.#{u}", default: u.capitalize)] = u
    end
    ret
  end

  def icon(type, *extra)
    content_tag :i , '', class: "icon-#{type} #{extra.join(' ')}"
  end

  def next_arrow
    content_tag :div, icon("caret-down"), class: 'next-arrow'
  end
end
