class NaviVoicesController < ApplicationController
  before_action :set_navi_voice, only: [:show, :edit, :update, :destroy]

  # GET /navi_voices
  # GET /navi_voices.json
  def index
    @navi_voices = NaviVoice.all
  end

  # GET /navi_voices/1
  # GET /navi_voices/1.json
  def show
  end

  # GET /navi_voices/new
  def new
    @navi_voice = NaviVoice.new
    @navi_voice.lang = request.env['HTTP_ACCEPT_LANGUAGE'].to_s.scan(/^[a-z]{2}/).first
  end

  # GET /navi_voices/1/edit
  def edit
  end

  # POST /navi_voices
  # POST /navi_voices.json
  def create
    @navi_voice = NaviVoice.new(navi_voice_params)

    @navi_voice.save
    respond_with @navi_voice, location: navi_voices_path
  end

  # PATCH/PUT /navi_voices/1
  # PATCH/PUT /navi_voices/1.json
  def update
    respond_to do |format|
      if @navi_voice.update(navi_voice_params)
        format.html { redirect_to @navi_voice, notice: 'Navi voice was successfully updated.' }
        format.json { head :no_content }
      else
        format.html { render action: 'edit' }
        format.json { render json: @navi_voice.errors, status: :unprocessable_entity }
      end
    end
  end

  # DELETE /navi_voices/1
  # DELETE /navi_voices/1.json
  def destroy
    @navi_voice.destroy
    respond_to do |format|
      format.html { redirect_to navi_voices_url }
      format.json { head :no_content }
    end
  end

  private
    # Use callbacks to share common setup or constraints between actions.
    def set_navi_voice
      @navi_voice = NaviVoice.find(params[:id])
    end

    # Never trust parameters from the scary internet, only allow the white list through.
    def navi_voice_params
      params.require(:navi_voice).permit(:title, :archive, :description, :unit, :lang, :author, :raw_delete_key)
    end
end
