set :sshkit_backend, SSHKit::Backend::Docker
set :stage, :development
set :branch, 'master'
set :deploy_to, '/app'
set :repo_url, '/src'
fetch(:default_env).merge!(rails_env: :development, RAILS_SERVE_STATIC_FILES: 1,
                           SECRET_KEY_BASE: 'dummy', DEVISE_SECRET_KEY: 'dummy')
set :bundle_without, 'test'

fetch(:linked_dirs, []).clear
fetch(:linked_files, []).clear

server docker: {
  image: 'nvc-base',
  commit: 'nvc-test',
  volume: "#{Dir.pwd}:/src",
}, user: 'rails:rails', roles: %w{web app}

Rake::Task["passenger:restart"].clear
