/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic;

import net.arnx.jsonic.Formatter;
import net.arnx.jsonic.JSON;
import net.arnx.jsonic.JSONHint;
import net.arnx.jsonic.NullFormatter;
import net.arnx.jsonic.io.OutputSource;

final class ObjectArrayFormatter
implements Formatter {
    public static final ObjectArrayFormatter INSTANCE = new ObjectArrayFormatter();

    ObjectArrayFormatter() {
    }

    public boolean format(JSON.Context context, Object src, Object o, OutputSource out) throws Exception {
        int i;
        Object[] array = (Object[])o;
        JSONHint hint = context.getHint();
        Class<?> lastClass = null;
        Formatter lastFormatter = null;
        out.append('[');
        for (i = 0; i < array.length; ++i) {
            Object item = array[i];
            if (item == src) {
                item = null;
            }
            if (i != 0) {
                out.append(',');
            }
            if (context.isPrettyPrint()) {
                out.append('\n');
                int indent = context.getInitialIndent() + context.getDepth() + 1;
                for (int j = 0; j < indent; ++j) {
                    out.append(context.getIndentText());
                }
            }
            context.enter(i, hint);
            item = context.preformatInternal(item);
            if (item == null) {
                NullFormatter.INSTANCE.format(context, src, item, out);
            } else if (hint == null) {
                if (item.getClass().equals(lastClass)) {
                    lastFormatter.format(context, src, item, out);
                } else {
                    lastFormatter = context.formatInternal(item, out);
                    lastClass = item.getClass();
                }
            } else {
                context.formatInternal(item, out);
            }
            context.exit();
        }
        if (context.isPrettyPrint() && i > 0) {
            out.append('\n');
            int indent = context.getInitialIndent() + context.getDepth();
            for (int j = 0; j < indent; ++j) {
                out.append(context.getIndentText());
            }
        }
        out.append(']');
        return true;
    }
}

