/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic;

import java.io.IOException;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.arnx.jsonic.JSON;
import net.arnx.jsonic.JSONEventType;
import net.arnx.jsonic.io.InputSource;
import net.arnx.jsonic.parse.JSONParser;
import net.arnx.jsonic.parse.ScriptParser;
import net.arnx.jsonic.parse.TraditionalParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONReader {
    private JSON.Context context;
    private JSONParser parser;
    private JSONEventType type;

    JSONReader(JSON.Context context, InputSource in, boolean multilineMode, boolean ignoreWhitespace) {
        this.context = context;
        switch (context.getMode()) {
            case STRICT: {
                this.parser = new JSONParser(in, context.getMaxDepth(), multilineMode, ignoreWhitespace, context.getLocalCache());
                break;
            }
            case SCRIPT: {
                this.parser = new ScriptParser(in, context.getMaxDepth(), multilineMode, ignoreWhitespace, context.getLocalCache());
                break;
            }
            default: {
                this.parser = new TraditionalParser(in, context.getMaxDepth(), multilineMode, ignoreWhitespace, context.getLocalCache());
            }
        }
    }

    public JSONEventType next() throws IOException {
        this.type = this.parser.next();
        return this.type;
    }

    public <T> T getValue(Class<T> cls) throws IOException {
        return this.context.convertInternal(this.getValue(), cls);
    }

    public Object getValue(Type t) throws IOException {
        return this.context.convertInternal(this.getValue(), t);
    }

    public Map<?, ?> getMap() throws IOException {
        return (Map)this.getValue();
    }

    public List<?> getList() throws IOException {
        return (List)this.getValue();
    }

    public String getString() throws IOException {
        return (String)this.parser.getValue();
    }

    public BigDecimal getNumber() throws IOException {
        return (BigDecimal)this.parser.getValue();
    }

    public Boolean getBoolean() throws IOException {
        return (Boolean)this.parser.getValue();
    }

    Object getValue() throws IOException {
        if (this.type == null) {
            throw new IllegalStateException("you should call next.");
        }
        int ilen = 0;
        int[] istack = new int[8];
        int olen = 0;
        Object[] ostack = new Object[16];
        do {
            switch (this.type) {
                case START_OBJECT: 
                case START_ARRAY: {
                    istack = this.iexpand(istack, ilen + 1);
                    istack[ilen++] = olen;
                    break;
                }
                case NAME: 
                case STRING: 
                case NUMBER: 
                case BOOLEAN: 
                case NULL: {
                    Object value = this.parser.getValue();
                    ostack = this.oexpand(ostack, olen + 1);
                    ostack[olen++] = value;
                    break;
                }
                case END_ARRAY: {
                    int i;
                    int start = istack[--ilen];
                    int len = olen - start;
                    ArrayList<Object> array = new ArrayList<Object>(len);
                    for (i = start; i < olen; ++i) {
                        array.add(ostack[i]);
                    }
                    olen = start;
                    ostack = this.oexpand(ostack, olen + 1);
                    ostack[olen++] = array;
                    break;
                }
                case END_OBJECT: {
                    int i;
                    int start = istack[--ilen];
                    int len = olen - start;
                    LinkedHashMap<Object, Object> object = new LinkedHashMap<Object, Object>(len < 2 ? 4 : (len < 4 ? 8 : (len < 12 ? 16 : (int)((float)len / 0.75f) + 1)));
                    for (i = start; i < olen; i += 2) {
                        object.put(ostack[i], ostack[i + 1]);
                    }
                    olen = start;
                    ostack = this.oexpand(ostack, olen + 1);
                    ostack[olen++] = object;
                }
            }
        } while ((!this.parser.isInterpretterMode() || ilen != 0) && (this.type = this.parser.next()) != null);
        return ostack[0];
    }

    public int getDepth() {
        return this.parser.getDepth();
    }

    private int[] iexpand(int[] array, int min) {
        if (min > array.length) {
            int[] narray = new int[array.length * 3 / 2 + 1];
            System.arraycopy(array, 0, narray, 0, array.length);
            array = narray;
        }
        return array;
    }

    private Object[] oexpand(Object[] array, int min) {
        if (min > array.length) {
            Object[] narray = new Object[array.length * 3 / 2 + 1];
            System.arraycopy(array, 0, narray, 0, array.length);
            array = narray;
        }
        return array;
    }
}

