/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic;

import java.lang.reflect.Type;
import java.sql.Time;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import net.arnx.jsonic.Converter;
import net.arnx.jsonic.JSON;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DateConverter
implements Converter {
    public static final DateConverter INSTANCE = new DateConverter();
    private static final Pattern TIMEZONE_PATTERN = Pattern.compile("(?:GMT|UTC)([+-][0-9]{2})([0-9]{2})");

    DateConverter() {
    }

    @Override
    public Object convert(JSON.Context context, Object value, Class<?> c, Type t) throws Exception {
        Calendar cal;
        DateFormat format;
        String str;
        if (value instanceof Map) {
            value = ((Map)value).get(null);
        } else if (value instanceof List) {
            List src = (List)value;
            value = !src.isEmpty() ? src.get(0) : null;
        }
        Date date = null;
        if (value instanceof Number) {
            date = (Date)context.createInternal(c);
            date.setTime(((Number)value).longValue());
        } else if (value != null && (str = value.toString().trim()).length() > 0 && (date = (format = context.getDateFormat()) != null ? format.parse(str) : DateConverter.convertDate(context, str)) != null && !c.isAssignableFrom(date.getClass())) {
            long time = date.getTime();
            date = (Date)context.createInternal(c);
            date.setTime(time);
        }
        if (date instanceof java.sql.Date) {
            cal = Calendar.getInstance(context.getTimeZone(), context.getLocale());
            cal.setTimeInMillis(date.getTime());
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            date.setTime(cal.getTimeInMillis());
        } else if (date instanceof Time) {
            cal = Calendar.getInstance(context.getTimeZone(), context.getLocale());
            cal.setTimeInMillis(date.getTime());
            cal.set(1, 1970);
            cal.set(2, 0);
            cal.set(5, 1);
            date.setTime(cal.getTimeInMillis());
        }
        return date;
    }

    static Date convertDate(JSON.Context context, String value) throws ParseException {
        if ((value = value.trim()).length() == 0) {
            return null;
        }
        value = TIMEZONE_PATTERN.matcher(value).replaceFirst("GMT$1:$2");
        DateFormat format = null;
        if (Character.isDigit(value.charAt(0))) {
            StringBuilder sb = context.getLocalCache().getCachedBuffer();
            String types = "yMdHmsSZ";
            int pos = value.length() > 2 && value.charAt(2) == ':' ? 3 : 0;
            boolean before = true;
            int count = 0;
            for (int i = 0; i < value.length(); ++i) {
                boolean digit;
                char c = value.charAt(i);
                if (!(pos != 4 && pos != 5 && pos != 6 || c != '+' && c != '-' || i + 1 >= value.length() || !Character.isDigit(value.charAt(i + 1)))) {
                    if (!before) {
                        sb.append('\'');
                    }
                    pos = 7;
                    count = 0;
                    before = true;
                    continue;
                }
                if (pos == 7 && c == ':' && i + 1 < value.length() && Character.isDigit(value.charAt(i + 1))) {
                    value = value.substring(0, i) + value.substring(i + 1);
                    continue;
                }
                boolean bl = digit = Character.isDigit(c) && pos < 8;
                if (before != digit) {
                    sb.append('\'');
                    if (digit) {
                        count = 0;
                        ++pos;
                    }
                }
                if (digit) {
                    char type = types.charAt(pos);
                    if (count == (type == 'y' || type == 'Z' ? 4 : (type == 'S' ? 3 : 2))) {
                        count = 0;
                        type = types.charAt(++pos);
                    }
                    if (type != 'Z' || count == 0) {
                        sb.append(type);
                    }
                    ++count;
                } else {
                    sb.append(c == '\'' ? "''" : Character.valueOf(c));
                }
                before = digit;
            }
            if (!before) {
                sb.append('\'');
            }
            format = new SimpleDateFormat(sb.toString(), Locale.ENGLISH);
        } else if (value.length() > 18) {
            if (value.charAt(3) == ',') {
                String pattern = "EEE, dd MMM yyyy HH:mm:ss Z";
                format = new SimpleDateFormat(value.length() < pattern.length() ? pattern.substring(0, value.length()) : pattern, Locale.ENGLISH);
            } else if (value.charAt(13) == ':') {
                format = new SimpleDateFormat("EEE MMM dd HH:mm:ss Z yyyy", Locale.ENGLISH);
            } else if (value.charAt(18) == ':') {
                String pattern = "EEE MMM dd yyyy HH:mm:ss Z";
                format = new SimpleDateFormat(value.length() < pattern.length() ? pattern.substring(0, value.length()) : pattern, Locale.ENGLISH);
            } else {
                format = DateFormat.getDateTimeInstance(2, 2, context.getLocale());
            }
        } else {
            format = DateFormat.getDateInstance(2, context.getLocale());
        }
        format.setLenient(false);
        format.setTimeZone(context.getTimeZone());
        return format.parse(value);
    }
}

