/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic.util;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TimeZone;
import net.arnx.jsonic.util.ExtendedDateFormat;

public class LocalCache {
    private static final int CACHE_SIZE = 256;
    private ResourceBundle resources;
    private Locale locale;
    private TimeZone timeZone;
    private StringBuilder builderCache;
    private String[] stringCache;
    private BigDecimal[] numberCache;
    private Map<String, DateFormat> dateFormatCache;
    private Map<String, NumberFormat> numberFormatCache;

    public LocalCache(String bundle, Locale locale, TimeZone timeZone) {
        this.resources = ResourceBundle.getBundle(bundle, locale);
        this.locale = locale;
        this.timeZone = timeZone;
    }

    public StringBuilder getCachedBuffer() {
        if (this.builderCache == null) {
            this.builderCache = new StringBuilder();
        } else {
            this.builderCache.setLength(0);
        }
        return this.builderCache;
    }

    public String getString(StringBuilder sb) {
        if (sb.length() == 0) {
            return "";
        }
        if (sb.length() < 32) {
            String str;
            int index = this.getCacheIndex(sb);
            if (index < 0) {
                return sb.toString();
            }
            if (this.stringCache == null) {
                this.stringCache = new String[256];
            }
            if (this.numberCache == null) {
                this.numberCache = new BigDecimal[256];
            }
            if ((str = this.stringCache[index]) == null || str.length() != sb.length()) {
                this.stringCache[index] = str = sb.toString();
                this.numberCache[index] = null;
                return str;
            }
            for (int i = 0; i < sb.length(); ++i) {
                if (str.charAt(i) == sb.charAt(i)) continue;
                this.stringCache[index] = str = sb.toString();
                this.numberCache[index] = null;
                return str;
            }
            return str;
        }
        return sb.toString();
    }

    public BigDecimal getBigDecimal(StringBuilder sb) {
        if (sb.length() == 1) {
            if (sb.charAt(0) == '0') {
                return BigDecimal.ZERO;
            }
            if (sb.charAt(0) == '1') {
                return BigDecimal.ONE;
            }
        }
        if (sb.length() < 32) {
            int index = this.getCacheIndex(sb);
            if (index < 0) {
                return new BigDecimal(sb.toString());
            }
            if (this.stringCache == null) {
                this.stringCache = new String[256];
            }
            if (this.numberCache == null) {
                this.numberCache = new BigDecimal[256];
            }
            String str = this.stringCache[index];
            BigDecimal num = this.numberCache[index];
            if (str == null || str.length() != sb.length()) {
                str = sb.toString();
                num = new BigDecimal(str);
                this.stringCache[index] = str;
                this.numberCache[index] = num;
                return num;
            }
            for (int i = 0; i < sb.length(); ++i) {
                if (str.charAt(i) == sb.charAt(i)) continue;
                str = sb.toString();
                num = new BigDecimal(str);
                this.stringCache[index] = str;
                this.numberCache[index] = num;
                return num;
            }
            if (num == null) {
                this.numberCache[index] = num = new BigDecimal(str);
            }
            return num;
        }
        return new BigDecimal(sb.toString());
    }

    private int getCacheIndex(StringBuilder sb) {
        int h = 0;
        int max = Math.min(16, sb.length());
        for (int i = 0; i < max; ++i) {
            h = h * 31 + sb.charAt(i);
        }
        return h & 0xFF;
    }

    public NumberFormat getNumberFormat(String format) {
        NumberFormat nformat = null;
        if (this.numberFormatCache == null) {
            this.numberFormatCache = new HashMap<String, NumberFormat>();
        } else {
            nformat = this.numberFormatCache.get(format);
        }
        if (nformat == null) {
            nformat = new DecimalFormat(format, new DecimalFormatSymbols(this.locale));
            this.numberFormatCache.put(format, nformat);
        }
        return nformat;
    }

    public DateFormat getDateFormat(String format) {
        DateFormat dformat = null;
        if (this.dateFormatCache == null) {
            this.dateFormatCache = new HashMap<String, DateFormat>();
        } else {
            dformat = this.dateFormatCache.get(format);
        }
        if (dformat == null) {
            dformat = new ExtendedDateFormat(format, this.locale);
            dformat.setTimeZone(this.timeZone);
            this.dateFormatCache.put(format, dformat);
        }
        return dformat;
    }

    public String getMessage(String id) {
        return this.getMessage(id, null);
    }

    public String getMessage(String id, Object ... args) {
        if (args != null && args.length > 0) {
            return MessageFormat.format(this.resources.getString(id), args);
        }
        return this.resources.getString(id);
    }
}

