﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;

namespace SpiderNet {
	/// <summary>
	/// ScopeSettingForm.xaml の相互作用ロジック
	/// </summary>
	public partial class ScopeSettingForm : Window {
		private int NumChannel;
		private int [] ChannelNumber;
		private ScopeClass TargetScope;
		private string [] UnitString;
		private string [] LabelString;
		private double [] MultiplyValue;
		private int CurrentChannelIndex;


		public ScopeSettingForm() {
			InitializeComponent();
		}

		private void SetSelectedLabels() {
			if (CurrentChannelIndex != -1) {
				int Channel = ChannelNumber[CurrentChannelIndex];
				ChannelIDTextBox.Text = ChannelComboBox.Items[CurrentChannelIndex].ToString();
				LabelTextBox.Text = LabelString[Channel];
				UnitTextBox.Text = UnitString[Channel];
				MultiplierTextBox.Text = string.Format("{0:F2}",MultiplyValue[Channel]);
			}
		}

		public bool ShowSettingForm(ScopeClass Scope) {
			TargetScope = Scope;
			TargetScope.GetSettings();
			NumChannel = Scope.NumChannel();
			ChannelComboBox.Items.Clear();
			ChannelNumber = new int[NumChannel];
			UnitString = new string[NumChannel];
			LabelString = new string[NumChannel];
			MultiplyValue = new double[NumChannel];
					
			int ChID = 0;
			for (int ChIndex = 0; ChIndex < NumChannel; ChIndex++) {
				UnitString[ChIndex] = Scope.ChannelUnit(ChIndex);
				LabelString[ChIndex] = Scope.ChannelLabel(ChIndex);
				MultiplyValue[ChIndex] = Scope.ChannelMultiplier(ChIndex);

				if (Scope.ChannelOn(ChIndex)) {
					ChannelComboBox.Items.Add(string.Format("Ch{0:D}",ChIndex+1));
					ChannelNumber[ChID] = ChIndex;
					ChID++;
				}
			}
			if (NumChannel > 0) { 
				CurrentChannelIndex = 0;
				SetSelectedLabels();
				ChannelComboBox.SelectedIndex = 0;
			}
			return (ShowDialog() == true);
		}

		private void OKButton_Click(object sender, RoutedEventArgs e) {
			for (int ChIndex = 0; ChIndex < NumChannel; ChIndex++) {
				TargetScope.Channel[ChIndex].TraceLabel = LabelString[ChIndex];
				TargetScope.Channel[ChIndex].TraceUnit = UnitString[ChIndex];
				TargetScope.Channel[ChIndex].Multiplier = MultiplyValue[ChIndex];
			}
			DialogResult = true;
		}

		private void ChannelComboBox_SelectionChanged(object sender, SelectionChangedEventArgs e) {
			int Channel = ChannelNumber[CurrentChannelIndex];
			LabelString[Channel] = LabelTextBox.Text;
			UnitString[Channel] = UnitTextBox.Text;
			MultiplyValue[Channel] = Convert.ToDouble(MultiplierTextBox.Text);
			CurrentChannelIndex = ChannelComboBox.SelectedIndex;
			SetSelectedLabels();
		}

		private void CancelButton_Click(object sender, RoutedEventArgs e) {
			DialogResult = false;
	
		}
	}
}
