﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using NationalInstruments.NI4882;

namespace SpiderNet
{
	/// <summary>
	/// MainWindow.xaml の相互作用ロジック
	/// </summary>
	public partial class MainWindow : Window
	{
		private DeviceListClass DeviceList;

		public MainWindow()
		{
			InitializeComponent();

			System.Resources.ResourceManager rm =
				new System.Resources.ResourceManager("SpiderNet.Properties.Resources", typeof(MainWindow).Assembly);
			Title = rm.GetString("UITitleMainWindow");

			try{
				DeviceList = new DeviceListClass();
			}
			catch(System.Exception Ex){
				ErrorDialog Dialog = new ErrorDialog(Ex);
				Close();
			}
		}


		private void ExitMenu_Click(object sender, RoutedEventArgs e)
		{
			Close();
		}

		private void NewScopeMenu_Click(object sender, RoutedEventArgs e)
		{
			NewScopeForm NewScopeForm = new NewScopeForm(DeviceList);
			if((Boolean)NewScopeForm.ShowDialog()) {
				Device NewDevice = NewScopeForm.CreatedDevice();
				DeviceList.UseDevice(NewDevice);
				ScopeClass NewScope = ScopeManager.CreateNewScope(NewDevice);
				var NewScopeMenuItem = new MenuItem();
				NewScopeMenuItem.Header = NewScope.ScopeID;
				NewScopeMenuItem.Click += ScopeSettingMenu_Click;
				ScopeMenu.Items.Add(NewScopeMenuItem);
				NewDevice.GoToLocal();
			}
		}

		private void ScopeSettingMenu_Click(object sender, RoutedEventArgs e) {
			MenuItem SenderItem = (MenuItem)sender;
			string ScopeID = (string)SenderItem.Header;
			ScopeClass Scope = ScopeManager.GetScopeFromID(ScopeID);
			if (Scope != null) {
				ScopeSettingForm SettingForm = new ScopeSettingForm();
				SettingForm.ShowSettingForm(Scope);
			}


		}

		private void CaptureMenu_Click(object sender, RoutedEventArgs e) {
			ScopeManager.GetWaveform();

		}

		private void PreferenceMenu_Click(object sender, RoutedEventArgs e) {
			PreferenceWindow pw = new PreferenceWindow();
			if((Boolean)pw.ShowDialog()){
			}

		}
	}
}
