/** ###################################################################
**     Filename    : ProcessorExpert.c
**     Project     : ProcessorExpert
**     Processor   : MKL25Z128VLK4
**     Version     : Driver 01.01
**     Compiler    : GNU C Compiler
**     Date/Time   : 2013-03-10, 17:33, # CodeGen: 0
**     Abstract    :
**         Main module.
**         This module contains user's application code.
**     Settings    :
**     Contents    :
**         No public methods
**
** ###################################################################*/
/* MODULE ProcessorExpert */


/* Including needed modules to compile this module/procedure */
#include "Cpu.h"
#include "Events.h"
#include "CsIO1.h"
#include "IO1.h"
#include "TU1.h"
#include "GPIO1.h"
/* Including shared modules, which are used for whole project */
#include "PE_Types.h"
#include "PE_Error.h"
#include "PE_Const.h"
#include "IO_Map.h"

/* User includes (#include below this line is not maintained by Processor Expert) */
#include "stdio.h"
#include "stdlib.h"

volatile bool DataReceivedFlg = FALSE;
TU1_TValueType pTicks;
char PositiveLogic=TRUE;
unsigned short t1,t2,t3,t4,t5,t6,t7,t8;
unsigned short ondelay,offdelay;
TopologyType Topology=SINGLE;


int ConfigurationOK(char *CommandString){
/* Configuration command syntax is as follows:
 * First char: 'c'
 * Second char: 'p' or 'n' for Positive or Negative logic
 * Third char: 's','d','l','t','e', Single, Double, Leg(Upper and Lower arm), delayed single, delayed double
 * Returns TRUE for acceptable setting, else returns FALSE.
 */
	switch(CommandString[1]){
	case 'p':
		PositiveLogic = TRUE;
		break;
	case 'n':
		PositiveLogic = FALSE;
		break;
	default:
		return(FALSE);
	}
	switch(CommandString[2]){
	case 's':
		Topology = SINGLE;	// only U(=PTC0) is available, single pulse
		break;
	case 'd':
		Topology = DOUBLE;	// only U(=PTC0) is available, double pulse
		break;
	case 'l':
		Topology = LEG;		// U(=PTC0) and X(=PTC1) are available, X for double, U for single
		break;
	case 't':
		Topology = DLYSINGLE;	// Y is delayed from U, single pulse
		break;
	case 'e':
		Topology = DLYDOUBLE;	// Y is delayed from U, double pulse
		break;
	case 'u':
		Topology = DUALSINGLE;	// Y = U, single pulse
		break;
	case 'f':
		Topology = DUALDOUBLE;	// Y = U, double pulse
		break;
	default:
		return(FALSE);
		break;
	}
	return(TRUE);
}

void ClearOutput(){
	/* Clear All output to 0(L for PositiveLogic, H for NegativeLogic) */
	if(PositiveLogic){
		GPIO1_ClearFieldBits(GPIO1_DeviceData, PortC, 1);
		GPIO1_ClearFieldBits(GPIO1_DeviceData, PortC, 2);
	} else {
		GPIO1_SetFieldBits(GPIO1_DeviceData, PortC, 1);
		GPIO1_SetFieldBits(GPIO1_DeviceData, PortC, 2);
	}
}

int SetPulseWidthOK(char *InBuffer){
/* Set pulse width command syntax is as follows:
 * First char: 'W'
 * up to seven pulse width will be set by one line.
 * Each pulse width contains 16bit 4characters hexadecimal string, such as 0A12 D4B0 and so on.
 * Every pulse width is separated by one space character
 * Total pulse width must be in unsinged short(16bit) range.
 * 
 * Topology=SINGLE
 * PTC16=U __________________+------+_________________
 *                             T1
 * Topology=DOUBLE                            
 * PTC16=U ____+------+________+---------+_______
 *                T1    T2        T3   
 * 
 * Topology=LEG
 * PTC16=U __________________+------+_________________
 *                             T3
 * PTC17=X ____+------+__________________+---------+_______
 *                T1    T2           T4     T5   
 * 
 * Topology=DLYSINGLE
 * PTC16=U ____+---------+_________________
 *                T1
 * PTC17=X ______+---------+_______________
 *            T2         T3
 *               
 * Topology=DLYDOUBLE
 * PTC16=U ____+------+________+---------+_______
 *                T1       T2       T3   
 * PTC17=X ______+------+________+---------+_______
 *             T4      T5        T4       T5
 *             
 * Topology=DUALSINGLE
 * PTC16=U ____+---------+_________________
 *                T1
 * PTC17=X ____+---------+_______________
 *               
 * Topology=DUALDOUBLE
 * PTC16=U ____+------+________+---------+_______
 *                T1       T2       T3   
 * PTC17=X ____+------+________+---------+_______
 
 Returns TRUE for successful setting, otherwise, FALSE.
 
 */
	InBuffer[0] = ' ';
	switch(Topology){
	case SINGLE:
	case DUALSINGLE:
		sscanf(InBuffer,"%hx",&t1);
		TPM0_C0V = t1;
		break;
	case DOUBLE:
	case DUALDOUBLE:
		sscanf(InBuffer,"%hx %hx %hx",&t1,&t2,&t3);
		if( ((long)(t1+t2) > 0x10000) || ((long)(t1+t2+t3) > 0x10000)){
			return(FALSE);
		}
		TPM0_C0V = t1;
		TPM0_C1V = t1+t2;
		TPM0_C2V = t1+t2+t3;
		break;
	case LEG:
		sscanf(InBuffer,"%hx %hx %hx %hx %hx",&t1,&t2,&t3,&t4,&t5);
		if( ((long)(t1+t2) > 0x10000) || ((long)(t1+t2+t3) > 0x10000)
			|| ((long)(t1+t2+t3+t4) > 0x10000) || ((long)(t1+t2+t3+t4+t5) > 0x10000)){
			return(FALSE);
		}
		TPM0_C0V = t1;
		TPM0_C1V = t1+t2;
		TPM0_C2V = t1+t2+t3;
		TPM0_C3V = t1+t2+t3+t4;
		TPM0_C4V = t1+t2+t3+t4+t5;
		break;
	case DLYSINGLE:
		sscanf(InBuffer,"%hx %hx %hx",&t1,&t2,&t3);
		if((t2 > t1) || (t3 > t1)){
			return(FALSE);
		}
		TPM0_C0V = t1;
		ondelay = t2;
		offdelay = t3;
		break;
	case DLYDOUBLE:
		sscanf(InBuffer,"%hx %hx %hx %hx %hx",&t1,&t2,&t3,&t4,&t5);
		if( (t4 > t1) || (t5 > t1) || (t4 > t2) || (t5 > t2) || (t4 > t3) || (t5 > t3) ){
			return(FALSE);
		}
		if( ((long)(t1+t2) > 0x10000) || ((long)(t1+t2+t3) > 0x10000)
			|| ((long)(t1+t2+t3+t4) > 0x10000) || ((long)(t1+t2+t3+t4+t5) > 0x10000)){
			return(FALSE);
		}
		TPM0_C0V = t1;
		TPM0_C1V = t1+t2;
		TPM0_C2V = t1+t2+t3;
		ondelay = t4;
		offdelay = t5;
		break;
	}
	return(TRUE);
}


void MakePulse(){
	TU1_Disable(TU1_DeviceData);
	TU1_ResetCounter(TU1_DeviceData);
	switch(Topology){
		case SINGLE:
		case DOUBLE:
			TogglePortC16;
			break;
		case LEG:
			TogglePortC17;
			break;
		case DLYSINGLE:
		case DLYDOUBLE:
			TogglePortC16;
			DummyWaitOn;
			TogglePortC17;
			break;
		case DUALSINGLE:
		case DUALDOUBLE:
			TogglePortC16and17;
	}
	TU1_Enable(TU1_DeviceData);
}

#define LINEBUFLEN 80

/*lint -save  -e970 Disable MISRA rule (6.3) checking. */
int main(void){
/*lint -restore Enable MISRA rule (6.3) checking. */

  /* Write your local variable definition here */
  char InBuffer[LINEBUFLEN];
  int ModeOK;
  int TimingOK;
  int IsIllegal;
	  
  /*** Processor Expert internal initialization. DON'T REMOVE THIS CODE!!! ***/
  PE_low_level_init();
  /*** End of Processor Expert internal initialization.                    ***/
	ModeOK = FALSE;
	TimingOK = FALSE;
	for(;;){
		IsIllegal = FALSE;
		uart_puts(TERM_PORT_NUM,LINEBUFLEN,"ok\n");
		uart_gets(TERM_PORT_NUM,LINEBUFLEN,InBuffer);

		switch(InBuffer[0]){
		case 'c':
			if(ConfigurationOK(InBuffer) == TRUE){
				ClearOutput();
				ModeOK = TRUE;
				TimingOK = FALSE;
			} else {
				ModeOK = FALSE;
				TimingOK = FALSE;
				IsIllegal = TRUE;
			}
			break;		  
		case 'w':
			if(ModeOK){
				if(SetPulseWidthOK(InBuffer) == TRUE) {
					TimingOK = TRUE;
				} else {
					TimingOK = FALSE;
				}
			} else {
				IsIllegal = TRUE;
			}
			break;
		case 't':
			if(TimingOK && ModeOK) {
				MakePulse();
			} else {
				IsIllegal = TRUE;
			}
			break;
		default :
			IsIllegal = TRUE;
			TimingOK = 0;
			break;
		}
		if(IsIllegal){
			uart_puts(TERM_PORT_NUM,LINEBUFLEN,"illegal command\n");
		}
	}



  /*** Don't write any code pass this line, or it will be deleted during code generation. ***/
  /*** RTOS startup code. Macro PEX_RTOS_START is defined by the RTOS component. DON'T MODIFY THIS CODE!!! ***/
  #ifdef PEX_RTOS_START
    PEX_RTOS_START();                  /* Startup of the selected RTOS. Macro is defined by the RTOS component. */
  #endif
  /*** End of RTOS startup code.  ***/
  /*** Processor Expert end of main routine. DON'T MODIFY THIS CODE!!! ***/
  for(;;){}
  /*** Processor Expert end of main routine. DON'T WRITE CODE BELOW!!! ***/
} /*** End of main routine. DO NOT MODIFY THIS TEXT!!! ***/

/* END ProcessorExpert */
/*
** ###################################################################
**
**     This file was created by Processor Expert 10.0 [05.03]
**     for the Freescale Kinetis series of microcontrollers.
**
** ###################################################################
*/
