/** ###################################################################
**     Filename    : Events.c
**     Project     : ProcessorExpert
**     Processor   : MKL25Z128VLK4
**     Component   : Events
**     Version     : Driver 01.00
**     Compiler    : GNU C Compiler
**     Date/Time   : 2013-03-10, 17:33, # CodeGen: 0
**     Abstract    :
**         This is user's event module.
**         Put your event handler code here.
**     Settings    :
**     Contents    :
**         Cpu_OnNMIINT - void Cpu_OnNMIINT(void);
**
** ###################################################################*/
/* MODULE Events */

#include "Cpu.h"
#include "Events.h"

/* User includes (#include below this line is not maintained by Processor Expert) */
extern TopologyType Topology;

/*
** ===================================================================
**     Event       :  Cpu_OnNMIINT (module Events)
**
**     Component   :  Cpu [MKL25Z128LK4]
**     Description :
**         This event is called when the Non maskable interrupt had
**         occurred. This event is automatically enabled when the <NMI
**         interrrupt> property is set to 'Enabled'.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
void Cpu_OnNMIINT(void)
{
  /* Write your code here ... */
}

/*
** ===================================================================
**     Event       :  Cpu_OnHardFault (module Events)
**
**     Component   :  Cpu [MKL25Z128LK4]
**     Description :
**         This event is called when the Hard Fault exception had
**         occurred. This event is automatically enabled when the <Hard
**         Fault> property is set to 'Enabled'.
**     Parameters  : None
**     Returns     : Nothing
** ===================================================================
*/
void Cpu_OnHardFault(void)
{
  /* Write your code here ... */
}

/*
** ===================================================================
**     Function    : uart_putchar
**
**     Description :
**         This function sends one character to the desired UART port.
**         It was written to patch a CodeWarrior bug with the printf
**         function.
**     Parameters  :
**         NAME            - DESCRIPTION
**         ch              - Character to be sent to the UART
**         uart_port_num   - Specifies which UART to send the 
**         					 character to.   
**                           
**     Returns     : Nothing
** ===================================================================
*/
void uart_putchar (int uart_port_num, char ch)
{
	if (uart_port_num == 0)
	{
      /* Wait until space is available in the FIFO */
      while(!(UART0_S1 & UART_S1_TDRE_MASK));
    
      /* Send the character */
      UART0_D = (uint8)ch;
	}
	else if (uart_port_num == 1)
	{
	  /* Wait until space is available in the FIFO */
	  while(!(UART1_S1 & UART_S1_TDRE_MASK));
	   
	  /* Send the character */
	  UART1_D = (uint8)ch;
	}
	else
	{
	  /* Wait until space is available in the FIFO */
	  while(!(UART2_S1 & UART_S1_TDRE_MASK));
	  
	  /* Send the character */
	  UART2_D = (uint8)ch;
	}
 }

/*
** ===================================================================
**     Function    : uart_getchar
**
**     Description :
**         This function gets one character to the desired UART port.
**         It was written to patch a CodeWarrior bug with the getchar
**         function.
**     Parameters  :
**         NAME            - DESCRIPTION
**         uart_port_num   - Specifies which UART to get the 
**         					 character from.   
**                           
**     Returns     : character (UARTx_D)
** ===================================================================
*/
char uart_getchar (int uart_port_num)
{
	if (uart_port_num == 0) {
      /* Wait until space is available in the FIFO */
      while(!(UART0_S1 & UART_S1_RDRF_MASK));
    
      /* Send the character */
      return (uint8)UART0_D;
	}
	else if (uart_port_num == 1)
	{
	  /* Wait until space is available in the FIFO */
	  while(!(UART1_S1 & UART_S1_RDRF_MASK));
	   
	  /* Send the character */
	  return (uint8)UART1_D;
	}
	else
	{
	  /* Wait until space is available in the FIFO */
	  while(!(UART2_S1 & UART_S1_RDRF_MASK));
	  
	  /* Send the character */
	  return (uint8)UART2_D;
	}
 }

void uart_puts(int uart_port_num, int strsize, char *buffer){
/*
 * uarr_puts: alternative for puts
 * send LF(\0a) terminated string.
 * contents of buffer should be [*]..[*][LF][\0]
 * LF character will be send as the last character.
 * 
 */	
	char c;
	int index = 0;

	do {
		c = buffer[index];
		uart_putchar(uart_port_num,c);
		index++;
	}while((c != '\n') && (c != 0x00U) && (index < strsize));
	if(c != '\n'){
		uart_putchar(uart_port_num,'^n');
	}
}

char *uart_gets(int uart_port_num, int bufsize, char *buffer){
/*
 * uarr_gets: alternative for gets
 * receives LF(\n) terminated string. Maximum size of string is bufsize.
 * last received LF character is NOT appended in result string buffer.
 * result buffer is NULL terminated.
 */	
	char c;
	int index = 0;

	do {
		c = uart_getchar(uart_port_num);
		buffer[index] = c;
		index++;
	}while((c != 0x0a) && (index < bufsize));
	buffer[index-1] = 0;	// LF is replaced by NULL, or last oversized char will be disposed
	return buffer;
}


/*
** ===================================================================
**     Event       :  TU1_OnChannel0 (module Events)
**
**     Component   :  TU1 [TimerUnit_LDD]
**     Description :
**         Called if compare register match the counter registers or
**         capture register has a new content. OnChannel0 event and
**         Timer unit must be enabled. See <SetEventMask> and
**         <GetEventMask> methods. This event is available only if a
**         <Interrupt> is enabled.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * UserDataPtr     - Pointer to the user or
**                           RTOS specific data. The pointer passed as
**                           the parameter of Init method.
**     Returns     : Nothing
** ===================================================================
*/
void TU1_OnChannel0(LDD_TUserData *UserDataPtr)
{
	switch(Topology){
		case SINGLE:
			TogglePortC16;
			TU1_Disable(TU1_DeviceData);
			break;
		case DOUBLE:
			TogglePortC16;
			break;
		case LEG:
			TogglePortC17;
			break;
		case DLYSINGLE:
			TogglePortC16;
			DummyWaitOff;
			TogglePortC17;
			TU1_Disable(TU1_DeviceData);
			break;
		case DLYDOUBLE:
			TogglePortC16;
			DummyWaitOff;
			TogglePortC17;
			break;
		case DUALSINGLE:
			TogglePortC16and17;
			TU1_Disable(TU1_DeviceData);
			break;
		case DUALDOUBLE:
			TogglePortC16and17;
			break;
	}
}

/*
** ===================================================================
**     Event       :  TU1_OnChannel1 (module Events)
**
**     Component   :  TU1 [TimerUnit_LDD]
**     Description :
**         Called if compare register match the counter registers or
**         capture register has a new content. OnChannel1 event and
**         Timer unit must be enabled. See <SetEventMask> and
**         <GetEventMask> methods. This event is available only if a
**         <Interrupt> is enabled.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * UserDataPtr     - Pointer to the user or
**                           RTOS specific data. The pointer passed as
**                           the parameter of Init method.
**     Returns     : Nothing
** ===================================================================
*/
void TU1_OnChannel1(LDD_TUserData *UserDataPtr)
{
	switch(Topology){
		case SINGLE:
			break;
		case DOUBLE:
			TogglePortC16;
			break;
		case LEG:
			TogglePortC16;
			break;
		case DLYSINGLE:
			break;
		case DLYDOUBLE:
			TogglePortC16;
			DummyWaitOn;
			TogglePortC17;
			break;
		case DUALSINGLE:
			break;
		case DUALDOUBLE:
			TogglePortC16and17;
			break;
	}
}

/*
** ===================================================================
**     Event       :  TU1_OnChannel2 (module Events)
**
**     Component   :  TU1 [TimerUnit_LDD]
**     Description :
**         Called if compare register match the counter registers or
**         capture register has a new content. OnChannel2 event and
**         Timer unit must be enabled. See <SetEventMask> and
**         <GetEventMask> methods. This event is available only if a
**         <Interrupt> is enabled.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * UserDataPtr     - Pointer to the user or
**                           RTOS specific data. The pointer passed as
**                           the parameter of Init method.
**     Returns     : Nothing
** ===================================================================
*/
void TU1_OnChannel2(LDD_TUserData *UserDataPtr)
{
	switch(Topology){
		case SINGLE:
			break;
		case DOUBLE:
			TogglePortC16;
			TU1_Disable(TU1_DeviceData);
			break;
		case LEG:
			TogglePortC16;
			break;
		case DLYSINGLE:
			break;
		case DLYDOUBLE:
			TogglePortC16;
			DummyWaitOff;
			TogglePortC17;
			TU1_Disable(TU1_DeviceData);
			break;
		case DUALSINGLE:
			break;
		case DUALDOUBLE:
			TogglePortC16and17;
			TU1_Disable(TU1_DeviceData);
			break;
	}
}

/*
** ===================================================================
**     Event       :  TU1_OnChannel3 (module Events)
**
**     Component   :  TU1 [TimerUnit_LDD]
**     Description :
**         Called if compare register match the counter registers or
**         capture register has a new content. OnChannel3 event and
**         Timer unit must be enabled. See <SetEventMask> and
**         <GetEventMask> methods. This event is available only if a
**         <Interrupt> is enabled.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * UserDataPtr     - Pointer to the user or
**                           RTOS specific data. The pointer passed as
**                           the parameter of Init method.
**     Returns     : Nothing
** ===================================================================
*/
void TU1_OnChannel3(LDD_TUserData *UserDataPtr)
{
	switch(Topology){
		case SINGLE:
			break;
		case DOUBLE:
			break;
		case LEG:
			TogglePortC17;
			break;
		case DLYSINGLE:
			break;
		case DLYDOUBLE:
			break;
		case DUALSINGLE:
			break;
		case DUALDOUBLE:
			break;
	}
}

/*
** ===================================================================
**     Event       :  TU1_OnChannel4 (module Events)
**
**     Component   :  TU1 [TimerUnit_LDD]
**     Description :
**         Called if compare register match the counter registers or
**         capture register has a new content. OnChannel4 event and
**         Timer unit must be enabled. See <SetEventMask> and
**         <GetEventMask> methods. This event is available only if a
**         <Interrupt> is enabled.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * UserDataPtr     - Pointer to the user or
**                           RTOS specific data. The pointer passed as
**                           the parameter of Init method.
**     Returns     : Nothing
** ===================================================================
*/
void TU1_OnChannel4(LDD_TUserData *UserDataPtr)
{
	switch(Topology){
		case SINGLE:
			break;
		case DOUBLE:
			break;
		case LEG:
			TogglePortC17;
			TU1_Disable(TU1_DeviceData);
			break;
		case DLYSINGLE:
			break;
		case DLYDOUBLE:
			break;
		case DUALSINGLE:
			break;
		case DUALDOUBLE:
			break;
	}
}



/*
** ===================================================================
**     Event       :  TU1_OnCounterRestart (module Events)
**
**     Component   :  TU1 [TimerUnit_LDD]
**     Description :
**         Called if counter overflow/underflow or counter is
**         reinitialized by modulo or compare register matching.
**         OnCounterRestart event and Timer unit must be enabled. See
**         <SetEventMask> and <GetEventMask> methods. This event is
**         available only if a <Interrupt> is enabled.
**     Parameters  :
**         NAME            - DESCRIPTION
**       * UserDataPtr     - Pointer to the user or
**                           RTOS specific data. The pointer passed as
**                           the parameter of Init method.
**     Returns     : Nothing
** ===================================================================
*/
void TU1_OnCounterRestart(LDD_TUserData *UserDataPtr)
{
  /* Write your code here ... */
}

/* END Events */

/*
** ###################################################################
**
**     This file was created by Processor Expert 10.0 [05.03]
**     for the Freescale Kinetis series of microcontrollers.
**
** ###################################################################
*/
