#include "osecpu-vm.h"
#include <setjmp.h>

// OsecpuMain()͂api.cɂ܂I

typedef struct _ApiWork {
	char winClosed, autoSleep /* , col3bgr */;
//	jmp_buf setjmpEnv;
	jmp_buf setjmpErr;
	unsigned char lastConsoleChar;
} ApiWork;

static ApiWork apiWork;

const Int32 *apiEntry(OsecpuVm *vm);
void apiInit(OsecpuVm *vm);
void apiEnd(OsecpuVm *vm);

#define BUFFER_SIZE		1024 * 1024	// 1M

int OsecpuMain(int argc, const unsigned char **argv)
{
	Defines defs;
	OsecpuJitc jitc;
	OsecpuVm vm;
	unsigned char *byteBuf0 = malloc(BUFFER_SIZE);
	Int32 *j32buf = malloc(BUFFER_SIZE * sizeof (Int32));
	int fileSize, rc, i;
	FILE *fp;
	jitc.defines = &defs;
	vm.defines = &defs;
	if (argc <= 1) {
		fputs("usage>osecpu app.ose\n", stderr);
		exit(1);
	}
	fp = fopen(argv[1], "rb");
	if (fp == NULL) {
		fputs("fopen error.\n", stderr);
		exit(1);
	}
	fileSize = fread(byteBuf0, 1, BUFFER_SIZE, fp);
	fclose(fp);
	if (fileSize >= BUFFER_SIZE) {
		fputs("app-file too large.\n", stderr);
		exit(1);
	}
	if (byteBuf0[0] != 0x05 || byteBuf0[1] != 0xe2 || fileSize < 3) {
		fputs("app-file signature mismatch.\n", stderr);
		exit(1);
	}
	for (;;) {
		if (fileSize < 0) break;
		if (byteBuf0[2] == 0x02) {
			fileSize = decode_tek5 (byteBuf0 + 3, byteBuf0 + fileSize, byteBuf0 + 2, byteBuf0 + BUFFER_SIZE);
			if (fileSize > 0) fileSize += 2;
			continue;
		}
		if (byteBuf0[2] == 0x01) {
			fileSize = decode_upx  (byteBuf0 + 3, byteBuf0 + fileSize, byteBuf0 + 2, byteBuf0 + BUFFER_SIZE);
			if (fileSize > 0) fileSize += 2;
			continue;
		}
		if (byteBuf0[2] >= 0x10) {
			fileSize = decode_fcode(byteBuf0 + 2, byteBuf0 + fileSize, byteBuf0 + 2, byteBuf0 + BUFFER_SIZE);
			if (fileSize > 0) fileSize += 2;
			continue;
		}
		break;
	}
	if (fileSize <= 0 || byteBuf0[2] != 0x00) {
		fputs("app-file decode error.\n", stderr);
		exit(1);
	}
	hh4ReaderInit(&jitc.hh4r, byteBuf0 + 3, 0, byteBuf0 + fileSize, 0);
	jitc.dst  = j32buf;
	jitc.dst1 = j32buf + BUFFER_SIZE;
	rc = jitcAll(&jitc);
	if (rc != 0) {
		fprintf(stderr, "jitcAll()=%d, DR0=%d\n", rc, jitc.dr[0]);
		exit(1);
	}
//	*jitc.dst = -1; // I[̂߂̓opecode.
	vm.ip  = j32buf;
	vm.ip1 = jitc.dst;

	apiInit(&vm);
//	for (i = 1; i < argc; i++) {
//		if (strcmp(argv[i], "-col3bgr") == 0)
//			apiWork.col3bgr = 1;
//	}
	rc = execAll(&vm);
	if (rc != EXEC_SRC_OVERRUN) {
		fprintf(stderr, "execAll()=%d, DR0=%d\n", rc, vm.dr[0]); // EXEC_SRC_OVERRUNȂ琬.
		exit(1);
	}
	apiEnd(&vm);
	return 0;
}

/* driver.c */
void *mallocRWE(int bytes); // stmalloc.
void drv_openWin(int x, int y, unsigned char *buf, char *winClosed);
void drv_flshWin(int sx, int sy, int x0, int y0);
void drv_sleep(int msec);
extern int *vram, v_xsiz, v_ysiz;

void apiInit(OsecpuVm *vm)
{
	int i, j;
	for (i = 0; i <= 0x3f; i++) {
		vm->r[i] = 0; vm->bit[i] = 32; // Rxx: ׂ32rbg0.
		vm->p[i].typ = PTR_TYP_INVALID; // Pxx: ׂĕs.
	}
	j = 1;
	for (i = 0; i < DEFINES_MAXLABELS; i++) {
		if (j > 4) break;
		if (vm->defines->label[i].typ == 0) continue; // gp.
		if (vm->defines->label[i].opt == 0) continue;
		if (vm->defines->label[i].typ == PTR_TYP_CODE) continue;
		execStep_plimm(vm, j, i);
		j++;
	}
	vm->p[0x28].typ = PTR_TYP_NATIVECODE;
	vm->p[0x28].p = (void *) &apiEntry;
	apiWork.winClosed = 0;
	apiWork.autoSleep = 0;
//	apiWork.col3bgr = 0;
	apiWork.lastConsoleChar = '\n';
//	if (setjmp(apiWork.setjmpEnv) != 0)
//		apiEnd(vm);
	return;
}

Int32 apiGetRxx(OsecpuVm *vm, int r, int bit);

void api0001_putString(OsecpuVm *vm);
void api0002_drawPoint(OsecpuVm *vm);
void api0003_drawLine(OsecpuVm *vm);
void api0004_rect(OsecpuVm *vm);
void api0005_oval(OsecpuVm *vm);
void api0006_drawString(OsecpuVm *vm);
void api0008_exit(OsecpuVm *vm);
void api0009_sleep(OsecpuVm *vm);
void api0010_openWin(OsecpuVm *vm);

const Int32 *apiEntry(OsecpuVm *vm)
// VM̍ĊJn_Ԃ.
{
	int func = apiGetRxx(vm, 0x30, 16); // 16bit݂Ȃ.
	int i;
	if (vm->errorCode != 0) goto fin;
	if (setjmp(apiWork.setjmpErr) != 0) goto fin;
	if (0x0002 <= func && func <= 0x0006) {
		if (vram == 0) {
			v_xsiz = 640;
			v_ysiz = 480;
			vram = malloc(v_xsiz * v_ysiz * 4);
			drv_openWin(v_xsiz, v_ysiz, (void *) vram, &apiWork.winClosed);
			apiWork.autoSleep = 1;
			for (i = 0; i < v_xsiz * v_ysiz; i++)
				vram[i] = 0;
		}
	}
	if (func == 0x0001) { api0001_putString(vm);	goto fin; }
	if (func == 0x0002) { api0002_drawPoint(vm);	goto fin; }
	if (func == 0x0003) { api0003_drawLine(vm);		goto fin; }
	if (func == 0x0004) { api0004_rect(vm);			goto fin; }
	if (func == 0x0005) { api0005_oval(vm);			goto fin; }
	if (func == 0x0006) { api0006_drawString(vm);	goto fin; }
	if (func == 0x0008) { api0008_exit(vm);			goto fin; }
	if (func == 0x0009) { api0009_sleep(vm);		goto fin; }
	if (func == 0x0010) { api0010_openWin(vm);		goto fin; }
	jitcSetRetCode(&vm->errorCode, EXEC_API_ERROR);
fin: ;
	const Int32 *retcode = NULL;
	execStep_checkMemAccess(vm, 0x30, PTR_TYP_CODE, EXEC_CMA_FLAG_EXEC); // liveSigñ`FbN.
	if (vm->errorCode == 0)
		retcode = (const Int32 *) vm->p[0x30].p;
	return retcode;
}

void apiEnd(OsecpuVm *vm)
{
	// I.
	if (apiWork.autoSleep != 0) {
		if (vram != 0)
			drv_flshWin(v_xsiz, v_ysiz, 0, 0);
		while (apiWork.winClosed == 0)
			drv_sleep(100);
	}
	if (apiWork.lastConsoleChar != '\n')
		putchar('\n');
	exit(0);
}

Int32 apiGetRxx(OsecpuVm *vm, int r, int bit)
{
	if (vm->bit[r] != BIT_DISABLE_REG && vm->bit[r] < bit)
		jitcSetRetCode(&vm->errorCode, EXEC_BAD_BITS);
	return execStep_SignBitExtend(vm->r[r], bit - 1);
}

static int iColor1[] = {
	0x000000, 0xff0000, 0x00ff00, 0xffff00,
	0x0000ff, 0xff00ff, 0x00ffff, 0xffffff
};

void putOsaskChar(int c)
{
	if (0x10 <= c && c <= 0x1f)
		c = "0123456789ABCDEF"[c & 0x0f];
	putchar(c);
	apiWork.lastConsoleChar = c;
	return;
}

static unsigned char fontdata[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x10, 0x10, 0x00, 0x00,
	0x28, 0x28, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x44, 0x44, 0x44, 0xfe, 0x44, 0x44, 0x44, 0x44, 0x44, 0xfe, 0x44, 0x44, 0x44, 0x00, 0x00,
	0x10, 0x3a, 0x56, 0x92, 0x92, 0x90, 0x50, 0x38, 0x14, 0x12, 0x92, 0x92, 0xd4, 0xb8, 0x10, 0x10,
	0x62, 0x92, 0x94, 0x94, 0x68, 0x08, 0x10, 0x10, 0x20, 0x2c, 0x52, 0x52, 0x92, 0x8c, 0x00, 0x00,
	0x00, 0x70, 0x88, 0x88, 0x88, 0x90, 0x60, 0x47, 0xa2, 0x92, 0x8a, 0x84, 0x46, 0x39, 0x00, 0x00,
	0x04, 0x08, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x02, 0x04, 0x08, 0x08, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x08, 0x08, 0x04, 0x02, 0x00,
	0x80, 0x40, 0x20, 0x20, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x20, 0x20, 0x40, 0x80, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x92, 0x54, 0x38, 0x54, 0x92, 0x10, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0xfe, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x08, 0x08, 0x10,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00,
	0x02, 0x02, 0x04, 0x04, 0x08, 0x08, 0x08, 0x10, 0x10, 0x20, 0x20, 0x40, 0x40, 0x40, 0x80, 0x80,
	0x00, 0x18, 0x24, 0x24, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x24, 0x24, 0x18, 0x00, 0x00,
	0x00, 0x08, 0x18, 0x28, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x3e, 0x00, 0x00,
	0x00, 0x18, 0x24, 0x42, 0x42, 0x02, 0x04, 0x08, 0x10, 0x20, 0x20, 0x40, 0x40, 0x7e, 0x00, 0x00,
	0x00, 0x18, 0x24, 0x42, 0x02, 0x02, 0x04, 0x18, 0x04, 0x02, 0x02, 0x42, 0x24, 0x18, 0x00, 0x00,
	0x00, 0x0c, 0x0c, 0x0c, 0x14, 0x14, 0x14, 0x24, 0x24, 0x44, 0x7e, 0x04, 0x04, 0x1e, 0x00, 0x00,
	0x00, 0x7c, 0x40, 0x40, 0x40, 0x58, 0x64, 0x02, 0x02, 0x02, 0x02, 0x42, 0x24, 0x18, 0x00, 0x00,
	0x00, 0x18, 0x24, 0x42, 0x40, 0x58, 0x64, 0x42, 0x42, 0x42, 0x42, 0x42, 0x24, 0x18, 0x00, 0x00,
	0x00, 0x7e, 0x42, 0x42, 0x04, 0x04, 0x08, 0x08, 0x08, 0x10, 0x10, 0x10, 0x10, 0x38, 0x00, 0x00,
	0x00, 0x18, 0x24, 0x42, 0x42, 0x42, 0x24, 0x18, 0x24, 0x42, 0x42, 0x42, 0x24, 0x18, 0x00, 0x00,
	0x00, 0x18, 0x24, 0x42, 0x42, 0x42, 0x42, 0x42, 0x26, 0x1a, 0x02, 0x42, 0x24, 0x18, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x08, 0x08, 0x10,
	0x00, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x80, 0x80, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x00, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x80, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x80, 0x00,
	0x00, 0x38, 0x44, 0x82, 0x82, 0x82, 0x04, 0x08, 0x10, 0x10, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00,
	0x00, 0x38, 0x44, 0x82, 0x9a, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0x9c, 0x80, 0x46, 0x38, 0x00, 0x00,
	0x00, 0x18, 0x18, 0x18, 0x18, 0x24, 0x24, 0x24, 0x24, 0x7e, 0x42, 0x42, 0x42, 0xe7, 0x00, 0x00,
	0x00, 0xf0, 0x48, 0x44, 0x44, 0x44, 0x48, 0x78, 0x44, 0x42, 0x42, 0x42, 0x44, 0xf8, 0x00, 0x00,
	0x00, 0x3a, 0x46, 0x42, 0x82, 0x80, 0x80, 0x80, 0x80, 0x80, 0x82, 0x42, 0x44, 0x38, 0x00, 0x00,
	0x00, 0xf8, 0x44, 0x44, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x44, 0x44, 0xf8, 0x00, 0x00,
	0x00, 0xfe, 0x42, 0x42, 0x40, 0x40, 0x44, 0x7c, 0x44, 0x40, 0x40, 0x42, 0x42, 0xfe, 0x00, 0x00,
	0x00, 0xfe, 0x42, 0x42, 0x40, 0x40, 0x44, 0x7c, 0x44, 0x44, 0x40, 0x40, 0x40, 0xf0, 0x00, 0x00,
	0x00, 0x3a, 0x46, 0x42, 0x82, 0x80, 0x80, 0x9e, 0x82, 0x82, 0x82, 0x42, 0x46, 0x38, 0x00, 0x00,
	0x00, 0xe7, 0x42, 0x42, 0x42, 0x42, 0x42, 0x7e, 0x42, 0x42, 0x42, 0x42, 0x42, 0xe7, 0x00, 0x00,
	0x00, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x00, 0x00,
	0x00, 0x1f, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x84, 0x48, 0x30, 0x00,
	0x00, 0xe7, 0x42, 0x44, 0x48, 0x50, 0x50, 0x60, 0x50, 0x50, 0x48, 0x44, 0x42, 0xe7, 0x00, 0x00,
	0x00, 0xf0, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x42, 0x42, 0xfe, 0x00, 0x00,
	0x00, 0xc3, 0x42, 0x66, 0x66, 0x66, 0x5a, 0x5a, 0x5a, 0x42, 0x42, 0x42, 0x42, 0xe7, 0x00, 0x00,
	0x00, 0xc7, 0x42, 0x62, 0x62, 0x52, 0x52, 0x52, 0x4a, 0x4a, 0x4a, 0x46, 0x46, 0xe2, 0x00, 0x00,
	0x00, 0x38, 0x44, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x44, 0x38, 0x00, 0x00,
	0x00, 0xf8, 0x44, 0x42, 0x42, 0x42, 0x44, 0x78, 0x40, 0x40, 0x40, 0x40, 0x40, 0xf0, 0x00, 0x00,
	0x00, 0x38, 0x44, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x92, 0x8a, 0x44, 0x3a, 0x00, 0x00,
	0x00, 0xfc, 0x42, 0x42, 0x42, 0x42, 0x7c, 0x44, 0x42, 0x42, 0x42, 0x42, 0x42, 0xe7, 0x00, 0x00,
	0x00, 0x3a, 0x46, 0x82, 0x82, 0x80, 0x40, 0x38, 0x04, 0x02, 0x82, 0x82, 0xc4, 0xb8, 0x00, 0x00,
	0x00, 0xfe, 0x92, 0x92, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x00, 0x00,
	0x00, 0xe7, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x24, 0x3c, 0x00, 0x00,
	0x00, 0xe7, 0x42, 0x42, 0x42, 0x42, 0x24, 0x24, 0x24, 0x24, 0x18, 0x18, 0x18, 0x18, 0x00, 0x00,
	0x00, 0xe7, 0x42, 0x42, 0x42, 0x5a, 0x5a, 0x5a, 0x5a, 0x24, 0x24, 0x24, 0x24, 0x24, 0x00, 0x00,
	0x00, 0xe7, 0x42, 0x42, 0x24, 0x24, 0x24, 0x18, 0x24, 0x24, 0x24, 0x42, 0x42, 0xe7, 0x00, 0x00,
	0x00, 0xee, 0x44, 0x44, 0x44, 0x28, 0x28, 0x28, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x00, 0x00,
	0x00, 0xfe, 0x84, 0x84, 0x08, 0x08, 0x10, 0x10, 0x20, 0x20, 0x40, 0x42, 0x82, 0xfe, 0x00, 0x00,
	0x00, 0x3e, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x3e, 0x00,
	0x80, 0x80, 0x40, 0x40, 0x20, 0x20, 0x20, 0x10, 0x10, 0x08, 0x08, 0x04, 0x04, 0x04, 0x02, 0x02,
	0x00, 0x7c, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x7c, 0x00,
	0x00, 0x10, 0x28, 0x44, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x00,
	0x10, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x08, 0x04, 0x3c, 0x44, 0x84, 0x84, 0x8c, 0x76, 0x00, 0x00,
	0xc0, 0x40, 0x40, 0x40, 0x40, 0x58, 0x64, 0x42, 0x42, 0x42, 0x42, 0x42, 0x64, 0x58, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x4c, 0x84, 0x84, 0x80, 0x80, 0x82, 0x44, 0x38, 0x00, 0x00,
	0x0c, 0x04, 0x04, 0x04, 0x04, 0x34, 0x4c, 0x84, 0x84, 0x84, 0x84, 0x84, 0x4c, 0x36, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x82, 0x82, 0xfc, 0x80, 0x82, 0x42, 0x3c, 0x00, 0x00,
	0x0e, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7c, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x36, 0x4c, 0x84, 0x84, 0x84, 0x84, 0x4c, 0x34, 0x04, 0x04, 0x78,
	0xc0, 0x40, 0x40, 0x40, 0x40, 0x58, 0x64, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0xe3, 0x00, 0x00,
	0x00, 0x10, 0x10, 0x00, 0x00, 0x30, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38, 0x00, 0x00,
	0x00, 0x04, 0x04, 0x00, 0x00, 0x0c, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x08, 0x08, 0x30,
	0xc0, 0x40, 0x40, 0x40, 0x40, 0x4e, 0x44, 0x48, 0x50, 0x60, 0x50, 0x48, 0x44, 0xe6, 0x00, 0x00,
	0x30, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xf6, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0x49, 0xdb, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xd8, 0x64, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0xe3, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x82, 0x82, 0x82, 0x82, 0x82, 0x44, 0x38, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xd8, 0x64, 0x42, 0x42, 0x42, 0x42, 0x42, 0x64, 0x58, 0x40, 0xe0,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x34, 0x4c, 0x84, 0x84, 0x84, 0x84, 0x84, 0x4c, 0x34, 0x04, 0x0e,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xdc, 0x62, 0x42, 0x40, 0x40, 0x40, 0x40, 0x40, 0xe0, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x7a, 0x86, 0x82, 0xc0, 0x38, 0x06, 0x82, 0xc2, 0xbc, 0x00, 0x00,
	0x00, 0x00, 0x10, 0x10, 0x10, 0x7c, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x0e, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x46, 0x3b, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xe7, 0x42, 0x42, 0x42, 0x24, 0x24, 0x24, 0x18, 0x18, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xe7, 0x42, 0x42, 0x5a, 0x5a, 0x5a, 0x24, 0x24, 0x24, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xc6, 0x44, 0x28, 0x28, 0x10, 0x28, 0x28, 0x44, 0xc6, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xe7, 0x42, 0x42, 0x24, 0x24, 0x24, 0x18, 0x18, 0x10, 0x10, 0x60,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x82, 0x84, 0x08, 0x10, 0x20, 0x42, 0x82, 0xfe, 0x00, 0x00,
	0x00, 0x06, 0x08, 0x10, 0x10, 0x10, 0x10, 0x60, 0x10, 0x10, 0x10, 0x10, 0x08, 0x06, 0x00, 0x00,
	0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
	0x00, 0x60, 0x10, 0x08, 0x08, 0x08, 0x08, 0x06, 0x08, 0x08, 0x08, 0x08, 0x10, 0x60, 0x00, 0x00,
	0x00, 0x72, 0x8c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x10, 0x28, 0x44, 0x82, 0xfe, 0x82, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x00
};

int apiLoadColor(OsecpuVm *vm, int rxx)
{
	int c = apiGetRxx(vm, rxx, 16), m, rr, gg, bb;
	m = apiGetRxx(vm, 0x31, 2) & 3;
	if (m == 0x00) {
	//	static col3_bgr_table[8] = { 0, 4, 2, 6, 1, 5, 3, 7 };
		if (c < -1 || c > 7)
			jitcSetRetCode(&vm->errorCode, EXEC_API_ERROR);
	//	if (apiWork.col3bgr != 0)
	//		c = col3_bgr_table[c & 7];
		c = iColor1[c & 0x07];
	}
	if (m == 0x01) {
		// 00, 24, 48, 6d, 91, b6, da, ff
		if (c < 0 || c >= (1 << 9))
			jitcSetRetCode(&vm->errorCode, EXEC_API_ERROR);
		rr = (c >>  6) & 0x07;
		gg = (c >>  3) & 0x07;
		bb =  c        & 0x07;
		rr = (rr * 255) / 7;
		gg = (gg * 255) / 7;
		bb = (bb * 255) / 7;
		c = rr << 16 | gg << 8 | bb;
	}
	if (m == 0x02) {
		// 00, 08, 10, 18, 20, 29, 31, 39,
		// 41, 4a, 52, 5a, 62, 6a, 73, 7b,
		// 83, 8b, 94, 9c, a4, ac, b4, bd,
		// c5, cd, d5, de, e6, ee, f6, ff
		if (c < 0 || c >= (1 << 15))
			jitcSetRetCode(&vm->errorCode, EXEC_API_ERROR);
		rr = (c >> 10) & 0x1f;
		gg = (c >>  5) & 0x1f;
		bb =  c        & 0x1f;
		rr = (rr * 255) / 31;
		gg = (gg * 255) / 31;
		bb = (bb * 255) / 31;
		c = rr << 16 | gg << 8 | bb;
	}
	if (m == 0x03)
		c = apiGetRxx(vm, rxx, 32);
	if (vm->errorCode > 0)
		longjmp(apiWork.setjmpErr, 1);
	return c;
}

void apiCheckPoint(OsecpuVm *vm, int x, int y)
{
	if (x < 0 || v_xsiz <= x || y < 0 || v_ysiz <= y) {
		jitcSetRetCode(&vm->errorCode, EXEC_API_ERROR);
		longjmp(apiWork.setjmpErr, 1);
	}
	return;
}

void apiFillRect(int modeC, int x0, int y0, int x1, int y1, int c)
{
	int x, y;
	if (modeC == 0x00) {
		for (y = y0; y <= y1; y++) {
			for (x = x0; x <= x1; x++)
				vram[x + y * v_xsiz] =  c;
		}
	} else {
		for (y = y0; y <= y1; y++) {
			for (x = x0; x <= x1; x++) {
				if (modeC == 0x04) vram[x + y * v_xsiz] |= c;
				if (modeC == 0x08) vram[x + y * v_xsiz] ^= c;
				if (modeC == 0x0c) vram[x + y * v_xsiz] &= c;
			}
		}
	}
	return;
}

void api0001_putString(OsecpuVm *vm) { }

void api0002_drawPoint(OsecpuVm *vm)
// Point(mode:R31, c:R32, x:R33, y:R34)
{
	int c = apiLoadColor(vm, 0x32), modeC = apiGetRxx(vm, 0x31, 4) & 0x0c;
	int x = apiGetRxx(vm, 0x33, 16), y = apiGetRxx(vm, 0x34, 16);
	apiCheckPoint(vm, x, y);
	if (modeC == 0x00) vram[x + y * v_xsiz]  = c;
	if (modeC == 0x04) vram[x + y * v_xsiz] |= c;
	if (modeC == 0x08) vram[x + y * v_xsiz] ^= c;
	if (modeC == 0x0c) vram[x + y * v_xsiz] &= c;
	return;
}

void api0003_drawLine(OsecpuVm *vm)
{
	int c = apiLoadColor(vm, 0x32), modeC = apiGetRxx(vm, 0x31, 4) & 0x0c;
	int x0 = apiGetRxx(vm, 0x33, 16), y0 = apiGetRxx(vm, 0x34, 16);
	int x1 = apiGetRxx(vm, 0x35, 16), y1 = apiGetRxx(vm, 0x36, 16);
	int dx, dy, x, y, len, i;
	if (1) { // NbsOOFF̏ꍇ.
		if (x0 == -1) x0 = v_xsiz - 1;
		if (y0 == -1) y0 = v_ysiz - 1;
		if (x1 == -1) x1 = v_xsiz - 1;
		if (y1 == -1) y1 = v_ysiz - 1;
		apiCheckPoint(vm, x0, y0);
		apiCheckPoint(vm, x1, y1);
	}
	dx = x1 - x0;
	dy = y1 - y0;
	x = x0 << 10;
	y = y0 << 10;
	if (dx < 0) dx = - dx;
	if (dy < 0) dy = - dy;
	if (dx >= dy) {
		len = dx + 1; dx = 1024;
		if (x0 > x1) dx *= -1;
		if (y0 > y1) dy *= -1;
		dy = (dy << 10) / len;
	} else {
		len = dy + 1; dy = 1024;
		if (y0 > y1) dy *= -1;
		if (x0 > x1) dx *= -1;
		dx = (dx << 10) / len;
	}
	if (modeC == 0) {
		for (i = 0; i < len; i++) {
			vram[(x >> 10) + (y >> 10) * v_xsiz] =  c;
			x += dx;
			y += dy;
		}
	} else {
		for (i = 0; i < len; i++) {
			if (modeC == 0x04) vram[(x >> 10) + (y >> 10) * v_xsiz] |= c;
			if (modeC == 0x08) vram[(x >> 10) + (y >> 10) * v_xsiz] ^= c;
			if (modeC == 0x0c) vram[(x >> 10) + (y >> 10) * v_xsiz] &= c;
			x += dx;
			y += dy;
		}
	}
	return;
}

void api0004_rect(OsecpuVm *vm)
// Rect(mode:R31, c:R32, xsiz:R33, ysiz:R34, x0:R35, y0:R36)
{
	int c = apiLoadColor(vm, 0x32), mode = apiGetRxx(vm, 0x31, 6);
	int xsiz = apiGetRxx(vm, 0x33, 16), ysiz = apiGetRxx(vm, 0x34, 16), x0, y0, x1, y1;
	if (xsiz == -1) { xsiz = v_xsiz; x0 = 0; } else { x0 = apiGetRxx(vm, 0x35, 16); }
	if (ysiz == -1) { ysiz = v_ysiz; y0 = 0; } else { y0 = apiGetRxx(vm, 0x36, 16); }
	if (ysiz == 0) ysiz = xsiz;
//printf("c=%06X %d %d %d %d", c, xsiz, ysiz, x0, y0);
	x1 = x0 + xsiz - 1;
	y1 = y0 + ysiz - 1;
	apiCheckPoint(vm, x0, y0);
	apiCheckPoint(vm, x1, y1);
	if ((mode & 0x20) == 0)
		apiFillRect(mode & 0x0c, x0, y0, x1, y1, c);
	else {
		apiFillRect(mode & 0x0c, x0, y0, x1, y0, c);
		apiFillRect(mode & 0x0c, x0, y1, x1, y1, c);
		apiFillRect(mode & 0x0c, x0, y0, x0, y1, c);
		apiFillRect(mode & 0x0c, x1, y0, x1, y1, c);
	}
	return;
}

void api0005_oval(OsecpuVm *vm)
// Oval(mode:R31, c:R32, xsiz:R33, ysiz:R34, x0:R35, y0:R36)
{
	// ̌vZx̓A[LeN`Ɉˑ.
	int c = apiLoadColor(vm, 0x32), mode = apiGetRxx(vm, 0x31, 6);
	int xsiz = apiGetRxx(vm, 0x33, 16), ysiz = apiGetRxx(vm, 0x34, 16), x0, y0, x1, y1;
	double dcx, dcy, dcxy, dtx, dty, dcx1, dcy1, dcxy1, dtx1, dty1;
	int x, y, modeC;
	if (xsiz == -1) { xsiz = v_xsiz; x0 = 0; } else { x0 = apiGetRxx(vm, 0x35, 16); }
	if (ysiz == -1) { ysiz = v_ysiz; y0 = 0; } else { y0 = apiGetRxx(vm, 0x36, 16); }
	if (ysiz == 0) ysiz = xsiz;
	x1 = x0 + xsiz - 1;
	y1 = y0 + ysiz - 1;
	apiCheckPoint(vm, x0, y0);
	apiCheckPoint(vm, x1, y1);
	dcx = 0.5 * (xsiz - 1);
	dcy = 0.5 * (ysiz - 1);
	dcxy = (dcx + 0.5) * (dcy + 0.5) - 0.1;
	dcxy *= dcxy;
	if ((mode & ~3) == 0) {
		for (y = 0; y < ysiz; y++) {
			dty = (y - dcy) * dcx;
			for (x = 0; x < xsiz; x++) {
				dtx = (x - dcx) * dcy;
				if (dtx * dtx + dty * dty > dcxy) continue;
				vram[(x + x0) + (y + y0) * v_xsiz] =  c;
			}
		}
	} else if ((mode & 0x20) == 0) {
		modeC = mode & 0x0c;
		for (y = 0; y < ysiz; y++) {
			dty = (y - dcy) * dcx;
			for (x = 0; x < xsiz; x++) {
				dtx = (x - dcx) * dcy;
				if (dtx * dtx + dty * dty > dcxy) continue;
				if (modeC == 0x04) vram[x + y * v_xsiz] |= c;
				if (modeC == 0x08) vram[x + y * v_xsiz] ^= c;
				if (modeC == 0x0c) vram[x + y * v_xsiz] &= c;
			}
		}
	} else {
		#define DRAWOVALPARAM	1
		modeC = mode & 0x0c;
		dcx1 = 0.5 * (xsiz - (1 + DRAWOVALPARAM * 2));
		dcy1 = 0.5 * (ysiz - (1 + DRAWOVALPARAM * 2));
		dcxy1 = (dcx1 + 0.5) * (dcy1 + 0.5) - 0.1;
		dcxy1 *= dcxy1;
		for (y = 0; y < ysiz; y++) {
			dty  = (y - dcy) * dcx;
			dty1 = (y - dcy) * dcx1;
			for (x = 0; x < xsiz; x++) {
				dtx = (x - dcx) * dcy;
				dtx1 = (x - dcx) * dcy1;
				if (dtx * dtx + dty * dty > dcxy) continue;
				if (DRAWOVALPARAM <= x && x < xsiz - DRAWOVALPARAM && DRAWOVALPARAM <= y && y < ysiz - DRAWOVALPARAM) {
					if (dtx1 * dtx1 + dty1 * dty1 < dcxy1) continue;
				}
				if (modeC == 0x00) vram[x + y * v_xsiz]  = c;
				if (modeC == 0x04) vram[x + y * v_xsiz] |= c;
				if (modeC == 0x08) vram[x + y * v_xsiz] ^= c;
				if (modeC == 0x0c) vram[x + y * v_xsiz] &= c;
			}
		}
	}
	return;
}

void api0006_drawString(OsecpuVm *vm) { }
void api0008_exit(OsecpuVm *vm) { }
void api0009_sleep(OsecpuVm *vm) { }

void api0010_openWin(OsecpuVm *vm)
{
	int i;
	if (vram != 0)
		jitcSetRetCode(&vm->errorCode, EXEC_API_ERROR);
	v_xsiz = apiGetRxx(vm, 0x31, 16);
	v_ysiz = apiGetRxx(vm, 0x32, 16);
	if (v_ysiz == 0) v_ysiz = v_xsiz;
	if (v_xsiz <= 0 || 4096 < v_xsiz || v_ysiz < 0 || 4096 < v_ysiz)
		jitcSetRetCode(&vm->errorCode, EXEC_API_ERROR);
	if (vm->errorCode > 0) goto fin;
	vram = malloc(v_xsiz * v_ysiz * 4);
	drv_openWin(v_xsiz, v_ysiz, (void *) vram, &apiWork.winClosed);
	apiWork.autoSleep = 1;
	for (i = 0; i < v_xsiz * v_ysiz; i++)
		vram[i] = 0;
fin:
	return;
}

