package jp.co.nic.ngware.service;

import static org.junit.Assert.*;

import java.util.List;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.context.SpringBootTest.WebEnvironment;
import org.springframework.test.context.junit4.SpringRunner;

import jp.co.nic.ngware.domain.TechUserInfo;

@RunWith(SpringRunner.class)
@SpringBootTest(webEnvironment = WebEnvironment.RANDOM_PORT)
public class TechServiceTest {

	@Autowired
	TechService tech;

	@Test
	public void 取得できるかのテスト() {
		List<TechUserInfo> users = tech.getUsers(new String[] { "1" });
		assertEquals(users.size(), 2);
		users = tech.getUsers(new String[] { "1", "2" });
		assertEquals(users.size(), 3);
		users = tech.getUsers(new String[] { "3" });
		assertEquals(users.size(), 0);
	}

	@Test
	public void 画面用のコンバージョンができるかのテスト() {
		List<TechUserInfo> users = tech.getUsers(new String[] { "1" });
		List<TechUserInfo> r1 = tech.to(users);
		users = tech.getUsers(new String[] { "1", "2" });
		List<TechUserInfo> r2 = tech.to(users);
		r2.size();
	}
}