<my-handsontable>
  <div class="row">
    <div class="col-xs-12">
      <div name="grid" style="height: 265px;"></div>
    </div>
  </div>
  <style>
    .handsontable th {
      background-color: #F0FFF0;
    }
    .handsontable tbody th.ht__highlight, .handsontable thead th.ht__highlight {
      background-color: #F0FFF0;
    }
  </style>

  <script>
  var
    table,
    self = this,
    el = self.grid,
    elContainer = el.parentNode,
    tableSetting = {
      colHeaders: [
          '名前',
          '性別',
          '点数',
          '偏差値',
      ],
      columns: [
          {
              data: 'name',
  			      type: 'text',
          },
          {
              data: 'seibetsu',
              editor: 'select',
              selectOptions: ['男', '女'],
              className: 'htCenter'
          },
          {
              data: 'tensu',
              type: 'numeric',
              format: '0',
        },
      ],
      stretchH: 'all',
      autoWrapRow: true,
      colWidths: [150, 50, 50],
      height: 260,
      minSpareRows: 1,
      rowHeaders: true,
      data: $.extend([], store.data.state.records),
      afterCreateRow: function(index, amount) {
        obseriot.notify( action.createRecord, {
          index: index,
          record: this.getData()[index]
        });
      },
      afterChange: function(changes, source) {
        if(changes) {
          for(e of changes) {
            obseriot.notify( action.changeRecord, {
              index: e[0],
              column: e[1],
              value: e[3],
            })
          }
        }
      }
    };

  this.on('mount', function() {
      table = new Handsontable(el, tableSetting);
  });

  function f(data) {
    table.loadData($.extend([], data.records))
    
  }
  
  obseriot.listen(store.load, f)

  this.on('unmount', function() {
    obseriot.unlisten(store.load, f)
  })
  </script>
</my-handsontable>
