<my-bar-chart>
  <div><svg name="bar"></svg></div>
  <style>
    svg.nvd3-svg {
      height: 180px;
    }
  </style>
  <script type="javascript">

  var self = this
  var chart = nv.models.discreteBarChart()
      .x(function(d) { return d.label })    //Specify the data accessors.
      .y(function(d) { return d.value })
      .valueFormat(d3.format(',.0d'))
      .staggerLabels(true)    //Too many bars and not enough room? Try staggering labels.
      .showValues(true)       //...instead, show the bar value right on top of each bar.
      chart.yAxis.tickFormat(d3.format(',.0d'));
  var chartdata = null;

  this.on('mount', function() {
    nv.addGraph(function() {
      chartdata = d3.select(self.bar).datum(
        [
          {
            key: "all",
            values:store.tensubunpu.state.records
          }
        ]
      );
      chartdata.transition().duration(500).call(chart);
      return chart;
    });
    obseriot.listen(store.tensubunpu, function (data) {
      chartdata.datum(
        [
          {
            key: "all",
            values:store.tensubunpu.state.records
          }
        ]
      ).transition().duration(500).call(chart);
    });
    var resizing = false;
    $(window).resize( function() {
      if (resizing) clearTimeout(resizing);
      resizing = setTimeout(function() {
        chart.update();
      }, 200);
    });
  })
  </script>
</my-bar-chart>
