<my-app>
  <div class="container-fluid main">
    <div class="row">
      <div class="col-md-offset-1 col-md-10">
        <my-navbar></my-navbar>
        <div class="row">
          <div class="col-sm-6">
            <my-frame caption="データ入力 (上のボタンで入力方式切替)">
              <div id="grid"></div>
            </my-frame>
          </div>
          <div class="col-sm-6">
            <div class="row">
              <div class="col-sm-12">
                <my-frame caption="点数分布">
                  <my-bar-chart id="tensubunpu"></my-bar-chart>
                </my-frame>
              </div>
              <div class="col-sm-12">
                <my-frame caption="男女比">
                  <my-pie-chart id="danjohi"></my-pie-chart>
                </my-frame>
              </div>
              <div class="col-sm-12">
                <my-frame caption="ツリー">
                  <my-tree id="tree"></my-tree>
                </my-frame>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

<script>
    var self = this;

    // 受講者データの一括ロードアクション
    obseriot.defineAction(
      "load", // action name
      function(e) { // handler action
        return e;
      }
    );

    // データレコード変更アクション
    // {index, column, value} e
    // index: 配列インデックス
    // column: 要素名
    // value: 値
    obseriot.defineAction(
      "changeRecord", // action name
      function(e) { // handler action
        return e;
      }
    );

    // データレコード追加アクション
    obseriot.defineAction(
      "createRecord", // action name
      // {index, record} e
      // index: 配列挿入位置のインデックス
      // record: 追加レコード(受講者データのrecord)
      function(e) { // handler action
        return e;
      }
    );

    // 受講者データ
    // {records: [{name, tensu, seibetsu},...]}
    obseriot.defineStore(
      "data",  // sotre name
      function () { // handler action
        var trimData = [];
        for(rec of store.data.state.records) {
            var isEmpty = function(e){return !e || e == ""}
            if(!isEmpty(rec.name) || !isEmpty(rec.tensu) || !isEmpty(rec.seibetsu))
              trimData.push(rec)
        }
        return {records: trimData}
      },
      {// default state
        records: []
      }
    );

    // データロード通知用ストア
    // 表入力コンポーネントはこちらを監視する
    obseriot.defineStore(
      "load",  // sotre name
      function () { // handler action
        // 返すのはsore.data
        return store.data.state
      },
      store.data.state
    );

    // 点数分布ストア
    // {records: [{lavel, value}...]}
    obseriot.defineStore(
      "tensubunpu",  // sotre name
      function () { // handler action
        return store.tensubunpu.state
      },
      {// default state
        records: []
      }
    );

    // 男女比ストア
    // {records: [{lavel, value}...]}
    obseriot.defineStore(
      "danjohi",  // sotre name
      function () { // handler action
        return store.danjohi.state
      },
      {// default state
        records: []
      }
    );

    // データロードアクション監視 → (受講者データ取得) →受講者データストア入れ替え
    // → 受講者データストア変更通知 & データロードストア変更通知
    obseriot.listen( action.load, function (e) {
    //   var data = {records:[
    //     {name: '田中', tensu:80, seibetsu:'男'},
    //     {name: '山田', tensu:100, seibetsu:'女'},
    //     {name: '鈴木', tensu:75, seibetsu:'男'},
    //   ]};
      //Get from server
      var data = opts.records;
      store.data.state.records = data;
      obseriot.notify( store.data );
      obseriot.notify( store.load );
    });

    // データ変更アクション監視 → 受講者データストア変更
    // → 受講者データストア変更通知
    obseriot.listen( action.changeRecord, function (e) { // {index, column, value} e
      var record = store.data.state.records[e.index];
      record[e.column] = e.value;
      obseriot.notify( store.data );
    });

    // データ変更アクション監視 → 受講者データストア追加
    // → 受講者データストア変更通知
    obseriot.listen( action.createRecord, function (e) { // {index, record} e
      var records = store.data.state.records;
      records.splice(e.index, 0, e.record);
      obseriot.notify( store.data );
    });

    // 受講者データストア監視 → 点数分布計算 → 点数分布データストア変更通知
    obseriot.listen( store.data, function (data) {
      var total = data.records.length
      var lange20 = data.records.filter(function(e){return 20 < e.tensu && e.tensu <= 40 }).length
      var lange40 = data.records.filter(function(e){return 40 < e.tensu && e.tensu <= 60 }).length
      var lange60 = data.records.filter(function(e){return 60 < e.tensu && e.tensu <= 80 }).length
      var lange80 = data.records.filter(function(e){return 80 < e.tensu }).length
      var other = total - lange20 - lange40 - lange60 - lange80
        store.tensubunpu.state = {
          records: [
            {'label': '  -20', 'value': other},
            {'label': '20-40', 'value': lange20},
            {'label': '40-60', 'value': lange40},
            {'label': '60-80', 'value': lange60},
            {'label': '80-  ', 'value': lange80},
          ]
        }
        obseriot.notify( store.tensubunpu );
    });

    // 受講者データストア監視 → 男女比計算 → 男女比データストア変更通知
    obseriot.listen( store.data, function (data) {
      store.danjohi.state = {
        records: [
          {'label': '男', 'value': data.records.filter(function(e){return e.seibetsu=='男'}).length},
          {'label': '女', 'value': data.records.filter(function(e){return e.seibetsu=='女'}).length},
          {'label': 'その他', 'value': data.records.filter(function(e){return e.seibetsu!='男' && e.seibetsu!='女'}).length},
        ]
      }
      obseriot.notify( store.danjohi );
    });


    // データ入力Viewの切り替え

    // 入力方式切り替えアクション
    obseriot.defineAction(
      "changeInputView", // action name
      function(e) { // handler action
        return e;
      }
    );

    var changeInputView = function() {
      var mode = true; //true: HandsonTable, false: W2UI
      var currentGrid = null;
      return function() {
        if(currentGrid) currentGrid.unmount(true)
        if (mode)
          currentGrid = riot.mount('#grid', 'my-handsontable')[0];
        else
          currentGrid = riot.mount('#grid', 'my-w2uigrid')[0];
        mode = !mode;
      }
    }();

    obseriot.listen( action.changeInputView, function () {
      changeInputView();
    });


    // レンダリング後の初期処理
    this.on('mount', function() {
      changeInputView();
      obseriot.notify( action.load );
    });
    </script>

</my-app>
