<!--
  numberタグ
  opts.placeholder : プレースホルダー
  opts.name : オブジェクト名
  opts.value : 値
  opts.title : タイトル名
  opts.islocked : true=disabled , false=enabled
  opts.maxlength : 最大桁数
  opts.addstyle : 追加で設定したいCSS
  opts.message : 表示したいエラーメッセージ
-->
<project-number-text>
    <div>
        <span class="{ showContext ? 'hint--top-right hint--always hint--error' : ''}" style="{addStyle}" aria-label="{errorMsg}">
            <input type='text' class="form-control"
                    placeholder="{placeholder}"
                    name="{name}"
                    value="{value}"
                    title="{title}"
                    onkeydown="{keydown}"
                    onkeyup="{keyup}"
                    disabled="{isLocked}"
                    autocomplete="off" />
        </span>
    </div>
    <style scoped>
        :scope input[type="text"] {
            padding: 0px 4px;
        }
    </style>
    this.placeholder = opts.placeholder ? opts.placeholder : ""
    this.name = opts.name ? opts.name : ""
    this.value = opts.value ? opts.value : ""
    this.title = opts.title ? opts.title : ""
    this.isLocked = opts.islocked ? "disabled" : ""
    this.maxlength = opts.maxlength ? opts.maxlength : ""
    this.addStyle = opts.addstyle ? opts.addstyle : ""
    this.errorMsg = `最大${this.maxlength}桁`

    this.showContext = false

    this.keydown = e => {
        // 0～9, テンキ―0～9, backspace, delete, →, ←, Home, End, 以外は入力キャンセル
        if(!APP.util.isInputNumberKeyCode(e.keyCode)) {
            return false
        }
        return true
    }

    this.keyup = e => {
        if(!APP.util.isKeyUpNumberKeyCode(e.keyCode)) {
            return false
        }
        if(APP.util.isMaxlengthOver(e.target.value, opts.maxlength)){
            this.showContext = true
        } else {
            this.showContext = false
        }
    }
</project-number-text>

<!--
  textタグ
  opts.placeholder : プレースホルダー
  opts.name : オブジェクト名
  opts.value : 値
  opts.title : タイトル名
  opts.islocked : true=disabled , false=enabled
  opts.maxlength : 最大桁数
  opts.addstyle : 追加で設定したいCSS
  opts.message : 表示したいエラーメッセージ
-->
<project-text>
    <div>
        <span class="{ showContext ? 'hint--top-right hint--always hint--error' : ''}" style="{addStyle}" aria-label="{errorMsg}">
            <input type='text' class="form-control"
                    placeholder="{placeholder}"
                    name="{name}"
                    value="{value}"
                    title="{title}"
                    onkeyup="{keyup}"
                    disabled="{isLocked}"
                    autocomplete="off" />
        </span>
    </div>
    <style scoped>
        :scope input[type="text"] {
            padding: 0px 4px;
        }
    </style>
    this.placeholder = opts.placeholder ? opts.placeholder : ""
    this.name = opts.name ? opts.name : ""
    this.value = opts.value ? opts.value : ""
    this.title = opts.title ? opts.title : ""
    this.isLocked = opts.islocked ? "disabled" : ""
    this.maxlength = opts.maxlength ? opts.maxlength : ""
    this.addStyle = opts.addstyle ? opts.addstyle : ""
    this.errorMsg = `最大${this.maxlength}桁`

    this.showContext = false

    this.keyup = e => {
        if(APP.util.isMaxlengthOver(e.target.value, opts.maxlength)){
            this.showContext = true
        } else {
            this.showContext = false
        }
    }
</project-text>