<tech-base-layout>
    <style scoped>
        :scope
        body, a, a:hover{
            color:#555;
        }
        :scope .conditions{
            margin:0 auto 10px auto;
            min-height:100px;
            border:solid 1px #e6e6e6;
            background-color: #ffffcc;
        }
      </style>
		<ngware-base-layout>
			<yield to='content'>
				<div class="conditions">
					<ngware-tech-condition/>
				</div>
				<div>
					<ngware-tech-list/>
				</div>
			<project-table/>
			</yield>
		</ngware-base-layout>
</tech-base-layout>

<ngware-tech-condition>
	<style scoped>
        :scope > table{
            margin: 0 auto;
            border-collapse: collapse;
            width: 100%;
        }

    </style>
	<div class="mui-checkbox">
		<label>
			<input type="checkbox" name='techs' value="1">java
		</label>
	</div>
	<div class="mui-checkbox">
		<label>
			<input type="checkbox" name='techs' value="2">spring
		</label>
	</div>
	<input type="button" value="sample" onClick="{search}" />
	var self = this
	this.search = e => {
		let ary = new Array()
		this.techs.forEach(checks => {
			if(checks.checked){
				ary.push(checks.value)
			}
		})
		obseriot.notify( action.getUsersTechs, {techs:ary} )
    }
</ngware-tech-condition>

<ngware-tech-list>
     <style scoped>
        :scope table{
            margin: 0 auto;
            border-collapse: collapse;
            width: 100%;
        }
        :scope table tr td{
            padding: 10px 5px;
        }
        :scope .header{
            background-color: #F6FF33;
        }
        :scope .namewidth{
             width: 150px;
        }
        :scope .pwidth{
             width: 60px;
        }
        :scope .nwidth{
             width: 100px;
        }
        .warning {
             background-color: #ffffcc;
             border-left: 6px solid #ffeb3b;
        }
    </style>

	<div if="{ !userList | (userList.length==0) }" class="warning">
	  対象者なし
	</div>

	<table border="1" if="{ userList | !(userList.length==0) }">
     <tr>
		<td class="header namewidth">氏名</td>
		<td class="header nwidth">経験月数</td>
		<td class="header pwidth">設計</td>
		<td class="header pwidth">実装</td>
		<td class="header pwidth">テスト</td>
		<td class="header nwidth">サポート要否</td>
		<td class="header">スキル名</td>
     </tr>
 	 <tr each="{ user in userList }">
     	<td if="{ user.groupSeq == 1 }" rowspan="{ user.rowSpan }">{user.firstName + user.lastName}</td>
     	<td>{convertMonth(user.monthExperience)}</td>
		<td>{convertPossible(user.design)}</td>
		<td>{convertPossible(user.implementation)}</td>
		<td>{convertPossible(user.test)}</td>
		<td>{convertNeed(user.support)}</td>
		<td>{user.skillId} : {user.skillName}</td>
     </tr>
   	</table>
    var self = this
    this.userList = []

	obseriot.listen( store.getUsersTechs, e => {
    	self.userList =  e.items
    	self.update()
	} )

	this.convertMonth = month =>{
		let y = Math.floor(month / 12)
		let m = month % 12
		if(y == 0){
			return `${m}ヶ月`
		}
		return `${y}年 ${m}ヶ月`
    }

    this.convertPossible = val =>{
        if(val == 0){
        	return "不可能"
        }
        else {
        	return "可能"
        }
    }

    this.convertNeed = val =>{
        if(val == 0){
        	return "必要"
        }
        else {
        	return "不要"
        }
    }

    //データ変更イベントを待ち受ける
    //obseriot.listen( store.changePage,  // sotre name
    //  data => { // handler action
    //    self.items = data.items
    //    self.update()
    //  }
    //)

    //init
    //obseriot.notify( action.changePage, {page: 1,})
</ngware-tech-list>