<login>
  <style scoped>
    .login{
      text-align:center;
      padding-top:50px;
    }
    .login-box{
      width:300px;
      background-color:#f7f7f7;
      margin:20px auto;
      padding: 20px 0 0 0;
      box-shadow:0px 2px 2px rgba(0, 0, 0, 0.3);
      border:solid 1px #ccc;
    }
    .login-title{
      font-size:200%;
    }
    .secret-function{
      font-size:70%;
      color:#aaa;
    }
    .message-box{
      width:400px;
      margin:20px auto;
      padding: 20px 0 20px 0;
    }
    .danger {
         background-color: #f44336;;
         border-left: 6px solid #f44336;
         color : #ffffff;
         text-align:center;
    }
  </style>
  <div class="login">
    <div><span>ngware ログイン</span></div>
    <form class="login-box form-group" method="POST" action="{APP.session.contextPath}/authentication" onsubmit={submit}>
      <login-item-text placeholder="ユーザーID" variable="accountId" />
      <login-item-text placeholder="パスワード" variable="password" type="password"/>
      <div style="margin-top:30px;"></div>
      <login-item-button/>
      <div style="margin-top:30px;"></div>
    </form>
    <div if="{message}" class="danger message-box">
	  <span>{message}</span>
	</div>

  </div>
  var self = this
  this.message = null

  this.validation = variable => {
    if (! this.doCheck) return
    switch(variable) {
      case 'accountId':
      case 'password':
        return this[variable] ? null || "" : '*入力必須'
      default:
        return null
    }
  }

  this.submit = e => {
    if (this.isInvalid()) return
    e.target.submit()
  }

  this.isInvalid = () => {
    this.doCheck = true
    var props = ['accountId', 'password']
    for(var index in props){
        var prop = props[index]
        if (this.validation(prop)){
            return true
        }
    }
  }

	//obseriot.jsで動作
	obseriot.listen( action.loginError, function ( eMessage ) {
		if(!_.isEmpty(eMessage)){
			self.message =eMessage
			self.update();
		}
	} )

	obseriot.notify( action.loginError, {error: message, locale:locale} )


</login>

<!--
  opts.variable : login タグの変数名。バリデーションメソッド呼び出しに使用
-->
<login-base-item>
  <style scoped>
    .item{
      padding:0 10px;
      margin-top:10px;
    }
    .validation-error{
      color:red;
      text-align:left;
  </style>
  <div class="item">
    <yield from='content'/>
    <div class="validation-error" show={validation()}>{validation()}</div>
  </div>
  //継承先のoptsを保持する。yield用
  this.receiveParam = opts.option
  this.mixin(APP.mixin.appDefault)
  this.loginTag = this.findAncestor('login')
  this.validation = () => {
    return this.loginTag.validation(opts.variable)
  }
  this.change = e => {
    this.loginTag[opts.variable] = e.target.value
    this.loginTag.update()
  }
</login-base-item>

<!--
  opts.variable : login タグの変数名。値の代入に使用
  opts.lock : true ならdisabled となる
  opts.type : text, password 等。省略時はtext
  opts.placeholder
-->
<login-item-text>
  <login-base-item variable={opts.variable} option={opts}>
    <yield to='content'>
      <!-- 変数参照はlogin-itemになるため継承先のoptsを継承元に渡して参照できるようにする -->
      <input type={receiveParam.type || 'text'} class="form-control" placeholder={receiveParam.placeholder}
        value={sourceTag[receiveParam.variable]} onkeyup="{change}" onblur="{change}" name="{receiveParam.variable}" disabled={receiveParam.lock} />
    </yield>
  </login-base-item>
</login-item-text>

<login-item-button>
  <login-base-item variable={opts.variable}>
    <yield to='content'>
      <button type="submit" class="btn btn-primary">ログイン</button>
    </yield>
  </login-base-item>
</login-item-button>

