<!--
    datetimepickerタグ
    opts.placeholder　日付テキストが空の場合におけるプレースホルダー
    opts.date　固定日付。データ取得などで動的に変更したい場合は
               obseriot.notify( action.datetime, {datetime: 数値,})で付与してくれればＯＫ
 -->
<datetimepicker>
    <span class="{ showContext ? 'flatpickr hint--top-right hint--always hint--error' : 'flatpickr'}"
          data-wrap="true" data-click-opens="false" aria-label="yyyyMMdd">
        <input placeholder="{opts.placeholder}" data-input="true" name="standardDate"
         class="standard-date" value="{datetime}" onkeyup="{dateTextKeyUp}" onchange="{changeValue}" maxlength="8">
        <a class="input-button" data-toggle><i class="glyphicon glyphicon-calendar"></i></a>
    </span>
    <style scoped>
        :scope .standard-date{
            width:100px;
            top:-3px;
            position:relative;
            display:inline;
            padding: 6px 6px 6px 6px;
        }
        :scope .glyphicon-calendar{
            font-size:140%;
            margin-left:0px;
            cursor:pointer;
        }
    </style>
    var self = this
    this.showContext = false
    this.datetime = ""
    this.flatpick = {}

    //optsで日付が設定されている場合。ここで設定されるのは固定値くらいしか・・・
    if(isDate(opts.date)){
        this.datetime = convertDate(opts.date)
    }
    this.on('mount', () => {
        var toJPN = {
            weekdays : ['日','月','火','水','木','金','土'],
            months:['1月','2月','3月','4月','5月','6月','7月','8月','9月','10月','11月','12月']
        }
        Flatpickr.l10n.weekdays.shorthand = toJPN.weekdays
        Flatpickr.l10n.months.longhand = toJPN.months
        this.flatpick = flatpickr('.flatpickr',{
                                "inline": false,
                                "dateFormat":"Ymd",
                                "allowInput":true
                              }
        );
    });

    function convertDate(dateTime){
        if(isDate(dateTime)){
            return APP.util.formatDate(dateTime, 'YYYYMMDD')
        }
        return null
    }

    //指定された文字列か数値が日付に変換確認
    function isDate(val){
        let d = new Date(val)
        if(d.toString() === "Invalid Date"){
            return false
        }
        return true
    }

    //指定された文字列が日付がYYYYMMDD形式かに変換確認
    function isMatchDateString(val){
        let matchResult = getMatchResult(val)
        if(matchResult){
            return true
        }
        return false
    }

    //指定された文字列が日付がYYYYMMDD形式かに変換確認
    function isValidateStringDate(val){
        if(isMatchDateString(val)){
            if(isDate(getDateRegularExpression(getMatchResult(val)))){
                return true
            }
        }
        return false
    }

    //指定された文字列が正規表現でYYYYMMDDを確認
    function getMatchResult(val){
        return val.match(/(\d{4})(\d{2})(\d{2})/)
    }

    //指定された正規表現の結果配列をDateが認識できる日付形式にする
    function getDateRegularExpression(array){
        return `${array[1]}/${array[2]}/${array[3]}`
    }

    function toDate(val){
        let matchResult = getMatchResult(val)
        return new Date(getDateRegularExpression(matchResult))
    }

    this.dateTextKeyUp = e =>{
        var k = e.keyCode
        // 0～9, テンキ―0～9, スペース, backspace, delete以外は入力キャンセル
        if(!((k >= 48 && k <= 57) || (k >= 96 && k <= 105) || k == 32 || k == 8 || k == 46)) {
            return false
        }
        let val = e.target.value
        if(isValidateStringDate(val)){
            this.showContext = false
            this.datetime = APP.util.formatDate(toDate(val), 'YYYYMMDD')
            return false
        }
        this.showContext = true
        return false
    }

    this.changeValue = e =>{
        let val = e.target.value
        if(isValidateStringDate(val)){
            this.flatpick.setDate(toDate(val))
        }
    }

    //データ変更イベントを待ち受けて、日付を変更する
    obseriot.listen( action.datetime, e => { // {datetime} e
        self.datetime = e.datetime
        //日付にデフォルトを設定しておく
        if(isDate(e.datetime)){
            self.flatpick.setDate(new Date(e.datetime))
            self.datetime = convertDate(e.datetime)
        }
        self.update()
    })
</datetimepicker>