--CREATE SCHEMA
CREATE USER NGWARE IDENTIFIED BY NGWARE
 DEFAULT TABLESPACE USERS
 TEMPORARY TABLESPACE TEMP
 QUOTA UNLIMITED ON USERS;
GRANT CONNECT TO NGWARE;

CREATE TABLE NGWARE.ACCESS_USER
(
 ACCOUNTID VARCHAR2(90) NOT NULL,
 NAME VARCHAR2(10) NOT NULL,
 PASSWORD  VARCHAR2(90) NOT NULL,
 COMPANYID VARCHAR2(10) NOT NULL,
 CREATE_DATE DATE DEFAULT SYSDATE,
 DEL CHAR(1) DEFAULT 0
);


/*
SELECT PARAMETER, VALUE
  FROM NLS_DATABASE_PARAMETERS
 WHERE PARAMETER IN ('NLS_CHARACTERSET', 'NLS_NCHAR_CHARACTERSET');
*/
--Database Characterset AL32UTF8じゃない場合
--http://www.shift-the-oracle.com/utility/csscan-csalter.html
--全角3バイト。英数字は1バイトで換算する

--会社を追加したい場合は別スキーマとする。

--権限マスタ
-- 用意するのは以下のデータ(変更可能・・・にするか？)
-- WF_COMPANY ワークフロー専用の権限　会社以下すべて扱える(木津さん、江藤さんだけかな？)
-- WF_APPROVAL ワークフロー専用の権限　最終承認権限あり(木津さん、江藤さん、管理部の一部の人？)
-- WF_INSPECTOR ワークフロー専用の権限　点検後承認権限あり(管理部の方々想定)
-- WF_GROUP ワークフロー専用の権限　所属グループ以下すべて扱える
-- WF_PRIVATE ワークフロー専用の権限　自分のだけ(意味ナッシング？)
-- COMPANY 会社以下すべて扱える(ワークフローは別)
-- GROUP 所属グループ以下すべて扱える(ワークフローは別)
-- PRIVATE 自分のだけ(ワークフローは別)
-- APPROVAL 最終承認権限あり(ワークフローは別)
-- INSPECTOR 点検後承認権限あり(ワークフローは別)
DROP TABLE NGWARE.M_ROLE;
CREATE TABLE NGWARE.M_ROLE
(
	ROLE_ID    NUMBER PRIMARY KEY,
	ROLE_TYPE  VARCHAR2(40) NOT NULL,
	APPROVAL   CHAR(1) DEFAULT 0,
	ROLE_NAME  VARCHAR2(200) NOT NULL,
	CREATED    TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
	MODIFIED   TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
	ENABLED    CHAR(1) DEFAULT 1
);

DROP SEQUENCE NGWARE.S_ROLE;
CREATE SEQUENCE NGWARE.S_ROLE
	START WITH 1
	INCREMENT BY 1
	MAXVALUE 100000
	MINVALUE 1
	CYCLE
;

--ワークフロー設定マスタ
DROP TABLE NGWARE.M_WF_SETTING;
CREATE TABLE NGWARE.M_WF_SETTING
(
	WF_ID         NUMBER PRIMARY KEY,                      --ワークフローID
	WF_NAME       VARCHAR2(400) NOT NULL,                  --ワークフロー名(常駐先勤務表とか)
	CREATED       TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
	MODIFIED      TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
	ENABLED       CHAR(1) DEFAULT 1
);

DROP SEQUENCE NGWARE.S_WF_SETTING;
CREATE SEQUENCE NGWARE.S_WF_SETTING
	START WITH 1
	INCREMENT BY 1
	MAXVALUE 100000
	MINVALUE 1
	CYCLE
;

--ワークフロー詳細設定マスタ
DROP TABLE NGWARE.M_WF_DETAIL_SETTING;
CREATE TABLE NGWARE.M_WF_DETAIL_SETTING
(
	WF_ID           NUMBER NOT NULL,                    --ワークフローID
	WF_POSITION     NUMBER NOT NULL,                    --ワークフロー順序(番号が高いのがフローの終わり)
	WF_DETAIL_NAME  VARCHAR2(400) NOT NULL,             --詳細ワークフロー名(一次承認とか)
	CREATED         TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
	MODIFIED        TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
	ENABLED         CHAR(1) DEFAULT 1,
	UNIQUE (WF_ID,WF_POSITION)
);

--ワークフロー詳細設定権限マスタ
DROP TABLE NGWARE.M_WF_DETAIL_ROLE_SETTING;
CREATE TABLE NGWARE.M_WF_DETAIL_ROLE_SETTING
(
	WF_ID           NUMBER NOT NULL,                  --ワークフローID
	WF_POSITION     NUMBER NOT NULL,                  --ワークフロー順序
	ROLE_ID         NUMBER,                           --承認可能なROLE_ID こっちにデータがある場合USER_IDは入らない
	USER_ID         NUMBER,                           --承認可能なUSER_ID こっちにデータがある場合ROLE_IDは入らない
	CREATED         TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
	MODIFIED        TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
	ENABLED         CHAR(1) DEFAULT 1
);

--ユーザー権限設定マスタ
DROP TABLE NGWARE.M_USER_ROLE;
CREATE TABLE NGWARE.M_USER_ROLE
(
	USER_ID    NUMBER,
	ROLE_ID    NUMBER,
	CREATED    TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
	MODIFIED   TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
	ENABLED    CHAR(1) DEFAULT 1,
	UNIQUE (USER_ID,ROLE_ID)
);

--グループマスタ
DROP TABLE NGWARE.M_GROUP;
CREATE TABLE NGWARE.M_GROUP
(
	GROUP_ID        NUMBER PRIMARY KEY,
	GROUP_NAME      VARCHAR (128) NOT NULL,
	PUBLIC_FLAG     CHAR,
	GROUP_NAME_KANA VARCHAR (128),
	ZIPCODE         VARCHAR (24),
	ADDRESS         VARCHAR (300),
	TELEPHONE       VARCHAR (45),
	FAX_NUMBER      VARCHAR (45),
	URL             VARCHAR (99),
	CREATED         TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
	MODIFIED        TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
	ENABLED         CHAR(1) DEFAULT 1
);

DROP SEQUENCE NGWARE.S_GROUP;
CREATE SEQUENCE NGWARE.S_GROUP
	START WITH 1
	INCREMENT BY 1
	MAXVALUE 100000
	MINVALUE 1
	CYCLE
;

--ユーザーマスタ
DROP TABLE NGWARE.M_USER;
CREATE TABLE NGWARE.M_USER
(
	USER_ID          NUMBER PRIMARY KEY,
	ACCOUNTID        VARCHAR2 (90) NOT NULL,
	PASSWORD         VARCHAR2 (90) NOT NULL,
	FIRST_NAME       VARCHAR2 (90) NOT NULL,
	LAST_NAME        VARCHAR2 (90) NOT NULL,
	EMAIL            VARCHAR2 (120),
	CONFIRM_VALUE    VARCHAR2 (120),
	LAST_LOGIN       TIMESTAMP,
	PASSWORD_CHANGED TIMESTAMP,
	POSITION_ID      NUMBER,
	IN_TELEPHONE     VARCHAR (45),
	OUT_TELEPHONE    VARCHAR (45),
	CELLULAR_PHONE   VARCHAR (45),
	CELLULAR_MAIL    VARCHAR (120),
	CELLULAR_UID     VARCHAR (99),
	FIRST_NAME_KANA  VARCHAR (90),
	LAST_NAME_KANA   VARCHAR (90),
	CREATED_USER_ID  NUMBER,
	UPDATED_USER_ID  NUMBER,
	CREATED          TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
	MODIFIED         TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
	ENABLED          CHAR(1) DEFAULT 1,
	UNIQUE (ACCOUNTID)
);

DROP SEQUENCE NGWARE.S_USER;
CREATE SEQUENCE NGWARE.S_USER
	START WITH 1
	INCREMENT BY 1
	MAXVALUE 100000
	MINVALUE 1
	CYCLE
;

--役職マスタ
DROP TABLE NGWARE.M_POSITION;
CREATE TABLE NGWARE.M_POSITION
(
	POSITION_ID   NUMBER PRIMARY KEY,
	POSITION_NAME VARCHAR (128) NOT NULL,
	CREATED       TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
	MODIFIED      TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
	ENABLED       CHAR(1) DEFAULT 1
);

DROP SEQUENCE NGWARE.S_POSITION;
CREATE SEQUENCE NGWARE.S_POSITION
	START WITH 1
	INCREMENT BY 1
	MAXVALUE 100000
	MINVALUE 1
	CYCLE
;

--会社マスタ
DROP TABLE NGWARE.M_COMPANY;
CREATE TABLE NGWARE.M_COMPANY
(
	COMPANY_ID        NUMBER PRIMARY KEY,
	COMPANY_NAME      VARCHAR (128) NOT NULL,
	COMPANY_NAME_KANA VARCHAR (128),
	ZIPCODE           VARCHAR (8),
	ADDRESS           VARCHAR (300),
	TELEPHONE         VARCHAR (45),
	FAX_NUMBER        VARCHAR (45),
	URL               VARCHAR (99),
	CREATED           TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
	MODIFIED          TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
	ENABLED           CHAR(1) DEFAULT 1
);

DROP SEQUENCE NGWARE.S_COMPANY;
CREATE SEQUENCE NGWARE.S_COMPANY
	START WITH 1
	INCREMENT BY 1
	MAXVALUE 100000
	MINVALUE 1
	CYCLE
;

--関連を持つ　3.閉包テーブルモデル
DROP TABLE NGWARE.R_COMPANY_GROUP;
DROP TABLE NGWARE.R_COMPANY_GROUP_HIS;
DROP TABLE NGWARE.R_GROUP_USER;

--グループのリレーション設定
CREATE TABLE NGWARE.R_COMPANY_GROUP
(
	COMPANY_ID         NUMBER,   --会社コード
	CURRENT_GROUP_ID   NUMBER,   --自分自身
	CHILD_GROUP_ID     NUMBER    --子グループ又は課
);

--グループツリー設定履歴
CREATE TABLE NGWARE.R_COMPANY_GROUP_HIS
(
	HISTORY_ID         NUMBER PRIMARY KEY,
	COMPANY_ID         NUMBER,   --会社コード
	CURRENT_GROUP_ID   NUMBER,   --自分自身
	CHILD_GROUP_ID     NUMBER,   --子グループ又は課
	CREATED            TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
	MODIFIED           TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

--グループとユーザーのリレーション設定
CREATE TABLE NGWARE.R_GROUP_USER
(
	GROUP_ID           NUMBER,
	USER_ID            NUMBER,
	CREATED            TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
	MODIFIED           TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);


--メニューマスタ
DROP TABLE NGWARE.M_MENU;
CREATE TABLE NGWARE.M_MENU
(
	ORDER_ID       NUMBER PRIMARY KEY,
	MENU_NAME      VARCHAR (128) NOT NULL,
	URL            VARCHAR (99) NOT NULL,
	CREATED        TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
	MODIFIED       TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
	ENABLED        CHAR(1) DEFAULT 1
);

--メニュー権限マスタ
DROP TABLE NGWARE.M_MENU_ROLE;
CREATE TABLE NGWARE.M_MENU_ROLE
(
	ORDER_ID       NUMBER NOT NULL,
	ROLE_ID        NUMBER NOT NULL,
	CREATED        TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
	MODIFIED       TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
	ENABLED        CHAR(1) DEFAULT 1
);

--スキルマスタ
DROP TABLE NGWARE.M_SKILL;
CREATE TABLE NGWARE.M_SKILL
(
	SKILL_ID        NUMBER PRIMARY KEY,
	SKILL_NAME      VARCHAR (300) NOT NULL,
	CREATED         TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
	MODIFIED        TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
	ENABLED         CHAR(1) DEFAULT 1
);

DROP SEQUENCE NGWARE.S_SKILL;
CREATE SEQUENCE NGWARE.S_SKILL
	START WITH 1
	INCREMENT BY 1
	MAXVALUE 100000
	MINVALUE 1
	CYCLE
;

--関連を持つ　3.閉包テーブルモデル
DROP TABLE NGWARE.R_SKILL;
DROP TABLE NGWARE.R_SKILL_USER;

--スキルのリレーション設定
CREATE TABLE NGWARE.R_SKILL
(
	CURRENT_SKILL_ID   NUMBER,   --自分自身
	CHILD_SKILL_ID     NUMBER,   --子のスキル
	HIERARCHY          NUMBER    --階層
);

--スキルとユーザーのリレーション設定
CREATE TABLE NGWARE.R_SKILL_USER
(
	SKILL_ID           NUMBER NOT NULL,
	USER_ID            NUMBER NOT NULL,
	MONTH_EXPERIENCE   NUMBER NOT NULL,   --経験月数
	DESIGN             CHAR(1) DEFAULT 0, --設計(0:不可 1:可能)
	IMPLEMENTATION     CHAR(1) DEFAULT 0, --実装(0:不可 1:可能)
	TEST               CHAR(1) DEFAULT 0, --テスト(0:不可 1:可能)
	SUPPORT            CHAR(1) DEFAULT 0, --サポート(0:必要 1:不要)
	CREATED            TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
	MODIFIED           TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);
