package jp.co.nic.ngware.web.user;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import jp.co.nic.ngware.domain.UserInfo;
import jp.co.nic.ngware.service.UserService;

@Controller
public class UserController {

	@Autowired
	UserService userService;

	@RequestMapping("/user_search")
	public @ResponseBody List<UserInfo> findList(@RequestParam(value = "accountId", required = false) String accountId,
			@RequestParam(value = "firstName", required = false) String firstName,
			@RequestParam(value = "lastName", required = false) String lastName,
			@RequestParam(value = "positionId", required = false) String positionId,
			@RequestParam(value = "cellularPhone", required = false) String cellularPhone,
			@RequestParam(value = "firstNameKana", required = false) String firstNameKana,
			@RequestParam(value = "lastNameKana", required = false) String lastNameKana) {
		return userService.getUsers(
				userService.create(null, accountId, firstName, lastName, positionId, cellularPhone, firstNameKana,
						lastNameKana));
	}

	@RequestMapping("/user_detail")
	public @ResponseBody UserInfo findOne(@RequestParam(value = "userId", required = false) String userId) {
		return userService.getUsers(
				userService.create(userId, null, null, null, null, null, null, null))
				.stream()
				.findFirst()
				.orElse(new UserInfo());
	}
}
