package jp.co.nic.ngware.web.tech;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import jp.co.nic.ngware.domain.TechUserInfo;
import jp.co.nic.ngware.service.TechService;

@Controller
public class TechController {

	@Autowired
	TechService techService;

	@RequestMapping("/tech_search")
	public @ResponseBody List<TechUserInfo> getTechUsers(
			@RequestParam(value = "skills", required = false) String[] skills) {
		return techService.to(techService.getUsers(skills));
	}
}
