package jp.co.nic.ngware.web.sample;

import java.io.File;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;

import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Interval;

import jp.co.nic.ngware.domain.FileInfo;
import jp.co.nic.ngware.domain.SampleBean;
import jp.co.nic.ngware.domain.SampleBean2;

public class SampleForm {
	List<SampleBean> lst;

	String testStr = "test";

	Date datetimepicker1;

	Date datetimepicker2;

	Date datetimepicker3;

	Date datetimepicker4;

	public Date getDatetimepicker1() {
		return datetimepicker1;
	}

	public void setDatetimepicker1(Date datetimepicker1) {
		this.datetimepicker1 = datetimepicker1;
	}

	public Date getDatetimepicker2() {
		return datetimepicker2;
	}

	public void setDatetimepicker2(Date datetimepicker2) {
		this.datetimepicker2 = datetimepicker2;
	}

	public Date getDatetimepicker3() {
		return datetimepicker3;
	}

	public void setDatetimepicker3(Date datetimepicker3) {
		this.datetimepicker3 = datetimepicker3;
	}

	public Date getDatetimepicker4() {
		return datetimepicker4;
	}

	public void setDatetimepicker4(Date datetimepicker4) {
		this.datetimepicker4 = datetimepicker4;
	}

	public String getTestStr() {
		return testStr;
	}

	public void setTestStr(String testStr) {
		this.testStr = testStr;
	}

	static String WORLD = "地球";

	public static enum Area {

		ASIA(0, "Asia"), NORTHAMERICA(1, "NorthAmerica"), INDIA(2, "India"), EUROPE(3, "Europe"), AFRICA(4,
				"Africa"), SOUTHAMERICA(5, "SouthAmerica"), NONE(99, "NoArea");

		private int areaCode;

		private String areaName;

		private Area(int areaCode, String areaName) {
			this.areaCode = areaCode;
			this.areaName = areaName;
		}

		private static final Map<Integer, String> areaMap = new HashMap<Integer, String>();

		static {
			for (Area entry : values()) {
				areaMap.put(entry.getAreaCode(), entry.getAreaName());
			}
		}

		public int getAreaCode() {
			return areaCode;
		}

		public String getAreaName() {
			return areaName;
		}

		public static String of(Integer areaCode) {
			return areaMap.get(areaCode);
		}
	}

	public List<SampleBean> getLst() {
		return lst;
	}

	public void setLst(List<SampleBean> lst) {
		this.lst = lst;
	}

	public void createBean() {
		lst = new ArrayList<SampleBean>();
		lst.add(this.createBean(WORLD, Area.ASIA, "日本"));
		lst.add(this.createBean(WORLD, Area.ASIA, "台湾"));
		lst.add(this.createBean(WORLD, Area.ASIA, "中国"));

		lst.add(this.createBean(WORLD, Area.NORTHAMERICA, "アメリカ"));
		lst.add(this.createBean(WORLD, Area.NORTHAMERICA, "カナダ"));

		lst.add(this.createBean(WORLD, Area.INDIA, "インド"));

		List<SampleBean> personDtoList = lst.stream()
				.map(rec -> Optional.ofNullable(rec).get())
				.filter(rec -> rec.getArea().equals(Area.NORTHAMERICA))
				.filter(rec -> rec.getWorld().equals(WORLD))
				.collect(Collectors.toList());

		SampleBean personDto = lst.stream()
				.filter(rec -> rec.getArea().equals(Area.AFRICA))
				.filter(rec -> rec.getWorld().equals(WORLD))
				.findFirst()
				.orElse(new SampleBean());

		personDto.setRowSpanCount(personDtoList.size());
		this.fullOuterJoinTest();
		System.out.println(personDtoList.size());
	}

	private SampleBean createBean(String world, Area area, String country) {
		return SampleBean.builder().world(world).area(area).country(country).build();
	}

	private SampleBean createBean(int row, String world, Area area, String country) {
		//		SampleBean bean = new SampleBean();
		//		bean.setWorld(world);
		//		bean.setArea(area);
		//		bean.setCountry(country);
		//		bean.setRow(row);
		//		return bean;
		return SampleBean.builder().row(row).world(world).area(area).country(country).build();
	}

	private void fullOuterJoinTest() {
		List<SampleBean> leftList = new ArrayList<SampleBean>();

		leftList.add(this.createBean(1, WORLD, Area.ASIA, "日本"));
		leftList.add(this.createBean(1, WORLD, Area.ASIA, "台湾"));
		leftList.add(this.createBean(1, WORLD, Area.ASIA, "中国"));
		leftList.add(this.createBean(2, WORLD, Area.NORTHAMERICA, "アメリカ"));
		leftList.add(this.createBean(2, WORLD, Area.NORTHAMERICA, "カナダ"));
		leftList.add(this.createBean(3, WORLD, Area.INDIA, "インド"));
		leftList.add(this.createBean(4, WORLD, Area.AFRICA, "エジプト"));
		leftList.add(this.createBean(5, WORLD, Area.NONE, StringUtils.EMPTY));

		List<SampleBean> rightList = new ArrayList<SampleBean>();

		rightList.add(this.createBean(1, WORLD, Area.ASIA, "日本"));
		rightList.add(this.createBean(1, WORLD, Area.ASIA, "中国"));
		rightList.add(this.createBean(1, WORLD, Area.ASIA, "台湾"));
		rightList.add(this.createBean(2, WORLD, Area.NORTHAMERICA, "アメリカ"));
		rightList.add(this.createBean(2, WORLD, Area.NORTHAMERICA, "カナダ"));
		rightList.add(this.createBean(3, WORLD, Area.EUROPE, "フランス"));
		rightList.add(this.createBean(5, WORLD, Area.NONE, "なし"));

		// sort
		Function<SampleBean, Integer> rowExtractor = d -> d.getRow();
		Function<SampleBean, Area> areaExtractor = d -> d.getArea();

		Comparator<SampleBean> c = Comparator.comparing(rowExtractor).thenComparing(areaExtractor);
		Collections.sort(leftList, c);
		Collections.sort(rightList, c);

		List<SampleBean> leftOuterJoinList = this.getDiffData(leftList, rightList);
		List<SampleBean> rightOuterJoinList = this.getDiffData(rightList, leftList);

		leftOuterJoinList.size();
		rightOuterJoinList.size();
	}

	private List<SampleBean> getDiffData(List<SampleBean> leftList, List<SampleBean> rightList) {

		List<SampleBean> rtn = new ArrayList<SampleBean>();

		Predicate<? super SampleBean> pred = rec -> rightList.stream()
				.filter(rightRec -> rec.getRow() == rightRec.getRow()
						&& rec.getArea() == rightRec.getArea()
						&& rec.getCountry().equals(rightRec.getCountry()))
				.findFirst()
				.isPresent();

		Map<Boolean, List<SampleBean>> m1 = leftList.stream().collect(Collectors.partitioningBy(pred));

		//Hitしなかったもの
		List<SampleBean> result1 = m1.entrySet().stream()
				.filter(nonMatch -> nonMatch.getKey().booleanValue() == false)
				.flatMap(entry -> Arrays.stream(entry.getValue().toArray(new SampleBean[0])))
				.collect(Collectors.toList());
		result1.size();

		//Hitしたもの
		List<SampleBean> result2 = m1.entrySet().stream()
				.filter(match -> match.getKey().booleanValue() == true)
				.flatMap(entry -> Arrays.stream(entry.getValue().toArray(new SampleBean[0])))
				.collect(Collectors.toList());
		result2.size();

		// sort
		Comparator<SampleBean> c = Comparator.comparing(SampleBean::getRow)
				.thenComparing(SampleBean::getArea)
				.thenComparing(SampleBean::getCountry, Comparator.reverseOrder());
		Collections.sort(rtn, c);

		sortTest();

		return rtn;
	}

	private void sortTest() {

		List<SampleBean> rightList = new ArrayList<SampleBean>();

		rightList.add(this.createBean(1, WORLD, Area.ASIA, "日本"));
		rightList.add(this.createBean(1, WORLD, Area.ASIA, "中国"));
		rightList.add(this.createBean(1, WORLD, Area.ASIA, "台湾"));
		rightList.add(this.createBean(2, WORLD, Area.NORTHAMERICA, "アメリカ"));
		rightList.add(this.createBean(2, WORLD, Area.NORTHAMERICA, "カナダ"));
		rightList.add(this.createBean(3, WORLD, Area.EUROPE, "フランス"));
		rightList.add(this.createBean(5, WORLD, Area.NONE, "なし"));
		rightList.add(null);

		Comparator<SampleBean> nullExists = Comparator.comparing(SampleBean::getRow, Comparator.reverseOrder())
				.thenComparing(SampleBean::getArea)
				.thenComparing(SampleBean::getCountry);
		Collections.sort(rightList, Comparator.nullsFirst(nullExists));
		Collections.sort(rightList, Comparator.nullsLast(nullExists));

		rightList.removeIf(bean -> !Optional.ofNullable(bean).isPresent());

		Comparator<SampleBean> c = Comparator.comparing(SampleBean::getRow).thenComparing(SampleBean::getArea)
				.thenComparing(SampleBean::getCountry, Comparator.reverseOrder());
		Collections.sort(rightList, c);
	}

	public void sampleConvertBean() {
		lst = new ArrayList<SampleBean>();
		lst.add(this.createBean(WORLD, Area.ASIA, "日本"));
		lst.add(this.createBean(WORLD, Area.ASIA, "台湾"));
		lst.add(this.createBean(WORLD, Area.ASIA, "中国"));

		lst.add(this.createBean(WORLD, Area.NORTHAMERICA, "アメリカ"));
		lst.add(this.createBean(WORLD, Area.NORTHAMERICA, "カナダ"));

		lst.add(this.createBean(WORLD, Area.INDIA, "インド"));

		List<SampleBean2> testList = lst.stream()
				.filter(bean -> Area.AFRICA.equals(bean.getArea()))
				.map(this::convertSampleBean)
				.collect(Collectors.toList());
		testList.size();

		List<SampleBean2> testList2 = lst.stream()
				.filter(bean -> bean.getArea() == Area.ASIA)
				.map(this::convertSampleBean)
				.collect(Collectors.toList());
		testList2.size();

		jodaTest1();
		jodaTest2();
		jodaTest3();
	}

	private SampleBean2 convertSampleBean(SampleBean bean1) {
		return SampleBean2.builder().world(bean1.getWorld()).area(bean1.getArea()).country(bean1.getCountry()).build();
	}

	public void imageTest() {
		Path path = FileSystems.getDefault().getPath("F:/9in1yt.jpg");
		FileInfo fileInfo = getImageFileInfo(path);
		System.out.println("Extension : " + fileInfo.getExtension());
		System.out.println("Width     : " + fileInfo.getWidth());
		System.out.println("Height    : " + fileInfo.getHeight());

	}

	public static FileInfo getImageFileInfo(Path path) {
		File target = path.toFile();
		try (ImageInputStream iis = ImageIO.createImageInputStream(target)) {
			String ext = null;
			Iterator<ImageReader> readers = ImageIO.getImageReaders(path);
			if (!readers.hasNext()) {
				return new FileInfo();
			}
			ImageReader reader = readers.next();
			reader.setInput(path);
			String[] suffixes = reader.getOriginatingProvider().getFileSuffixes();
			FileInfo fileInfo = new FileInfo();
			fileInfo.setWidth(reader.getWidth(0));
			fileInfo.setHeight(reader.getHeight(0));
			if (suffixes == null || suffixes.length == 0) {
				ext = "";
			} else {
				ext = Arrays.stream(suffixes).filter(suffix -> suffix.length() == 3).findFirst().orElse("");
			}
			fileInfo.setExtension(ext);
			return fileInfo;
		} catch (Exception e) {
			e.printStackTrace();
			return new FileInfo();
		}
	}

	public void testA() {
		List<SampleBean> list = new ArrayList<SampleBean>();

		list.add(this.createBean(1, WORLD, Area.ASIA, "日本"));
		list.add(this.createBean(2, WORLD, Area.NORTHAMERICA, "アメリカ"));
		list.add(this.createBean(2, WORLD, Area.NORTHAMERICA, "カナダ"));

		List<TestBean> a = new ArrayList<TestBean>();
		a.addAll(this.createTestBean(list, "testA"));
		a.addAll(this.createTestBean(list, "testB"));

		a.size();
	}

	private List<TestBean> createTestBean(List<SampleBean> list, String text) {
		ArrayList<TestBean> lst = new ArrayList<TestBean>();
		TestBean bean = new TestBean();
		list.stream().filter(b -> b.getArea().equals(Area.ASIA)).forEach(d -> {
			bean.setText(text);
			bean.setId(d.getArea().getAreaName());
			lst.add(bean);
		});

		return lst;
	}

	public static class TestBean {
		private String text;

		private String id;

		public String getText() {
			return text;
		}

		public void setText(String st) {
			text = st;
		}

		public String getId() {
			return id;
		}

		public void setId(String st) {
			id = st;
		}
	}

	private void jodaTest1() {
		System.out.println("jodaTest1!!!");
		DateTime dt1 = createDateTime(2015, 7, 8, 0, 0, 0, 0);
		DateTime dt2 = createDateTime(2015, 7, 12, 0, 0, 0, 0);
		Interval interval1 = createInterval(dt1, dt2);

		DateTime dt3 = createDateTime(2015, 7, 11, 15, 30, 0, 0);
		DateTime dt4 = createDateTime(2015, 7, 13, 0, 0, 0, 0);
		Interval interval2 = createInterval(dt3, dt4);

		isOverlaps(interval1, interval2);
		isAbuts(interval1, interval2);

	}

	private void jodaTest2() {
		System.out.println("jodaTest2!!!");
		DateTime dt1 = createDateTime(2015, 7, 8, 0, 0, 0, 0);
		DateTime dt2 = createDateTime(2015, 7, 12, 0, 0, 0, 0);
		Interval interval1 = createInterval(dt1, dt2);

		DateTime dt3 = createDateTime(2015, 7, 12, 0, 0, 0, 0);
		DateTime dt4 = createDateTime(2015, 7, 13, 0, 0, 0, 0);
		Interval interval2 = createInterval(dt3, dt4);

		isOverlaps(interval1, interval2);
		isAbuts(interval1, interval2);
	}

	private void jodaTest3() {
		System.out.println("jodaTest3!!!");
		DateTime dt1 = createDateTime(2015, 7, 8, 0, 0, 0, 0);
		DateTime dt2 = createDateTime(null);
		Interval interval1 = createInterval(dt1, dt2);

		//逆はダメインスタンス作成時に例外が投げられる
		//java.lang.IllegalArgumentException: The end instant must be greater the start
		//一括画面に入る前にチェックしないとなぁ・・・
		DateTime dt3 = createDateTime(2015, 7, 16, 15, 30, 0, 0);
		DateTime dt4 = createDateTime(2015, 7, 13, 0, 0, 0, 0);
		Interval interval2 = createInterval(dt3, dt4);

		isOverlaps(interval1, interval2);
		isAbuts(interval1, interval2);
	}

	private void isAbuts(Interval interval1, Interval interval2) {
		if (interval1.abuts(interval2)) {
			System.out.println("abuts!!!");
		} else {
			System.out.println("not abuts!!!");
		}
	}

	private void isOverlaps(Interval interval1, Interval interval2) {
		if (interval1.overlaps(interval2)) {
			System.out.println("overlaps!!!");
		} else {
			System.out.println("not overlaps!!!");
		}
	}

	private Interval createInterval(DateTime fromDate, DateTime toDate) {
		if (fromDate.isAfter(toDate)) {
			return null;
		}
		return new Interval(fromDate, toDate);
	}

	private DateTime createDateTime(int year, int monthOfYear, int dayOfMonth, int hourOfDay, int minuteOfHour,
			int secondOfMinute,
			int millisOfSecond) {
		return new DateTime(year, monthOfYear, dayOfMonth, hourOfDay, minuteOfHour, secondOfMinute, secondOfMinute);
	}

	private DateTime createDateTime(Date date) {
		return new DateTime(Optional.ofNullable(date).orElse(new Date(Long.MAX_VALUE)));
	}

	private DateTime createDateTime(String date, ZoneId zone) {
		try {
			SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
			Date dt = null;
			if (!StringUtils.isEmpty(date)) {
				dt = format.parse(date);
			}
			return new DateTime(Optional.ofNullable(dt).orElse(new Date(Long.MAX_VALUE)),
					DateTimeZone.forID("Asia/Tokyo"));
		} catch (ParseException e) {
			return null;
		}
	}
}
