package jp.co.nic.ngware.web.index;

import java.util.List;
import java.util.Optional;

import org.springframework.http.MediaType;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.google.common.collect.Lists;

import jp.co.nic.ngware.domain.Data;
import jp.co.nic.ngware.util.ApplicationUtils;

@Controller
public class IndexController {

	@RequestMapping(value = { "/", "/login" })
	public String start(Model model) {
		UserDetails user = (UserDetails) ApplicationUtils.getAuthentication();
		String url = Optional.ofNullable(user).map(ud -> "dashboard").orElse("login");
		return createUrl(url);
	}

	private String createUrl(String path) {
		if ("dashboard".equals(path)) {
			return "redirect:/dashboard";
		}
		return "login";
	}

	@RequestMapping(value = "/request", method = RequestMethod.POST, consumes = MediaType.APPLICATION_JSON_UTF8_VALUE, produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
	public String request(@RequestBody List<Data> request) {
		List<Data> requestedData = Optional.ofNullable(request).orElse(Lists.newArrayList());
		requestedData.stream().forEach(this::printConsole);
		return "index";
	}

	private void printConsole(Data data) {
		System.out
				.println("name=" + data.getName() + "  tensu=" + data.getTensu() + "  seibetsu=" + data.getSeibetsu());
	}
}
